/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.jobLog;

import com.kdjsystem.mlink.shop.jobLog.JobLogDTO;
import com.kdjsystem.mlink.shop.jobLog.JobLogService;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class JobLogQueue {
    private static final int BATCH_SIZE = 50;
    private static final BlockingQueue<JobLogDTO> queue = new LinkedBlockingQueue<JobLogDTO>(10000);
    private static volatile boolean running = true;

    static {
        Thread worker = new Thread(() -> {
            while (running || !queue.isEmpty()) {
                try {
                    ArrayList<JobLogDTO> batch = new ArrayList<JobLogDTO>(50);
                    queue.drainTo(batch, 50);
                    if (batch.isEmpty()) {
                        Thread.sleep(200L);
                        continue;
                    }
                    JobLogService.get().addLogBatch(batch);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, "JobLog-Worker");
        worker.setDaemon(false);
        worker.start();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            running = false;
            try {
                worker.join(3000L);
            }
            catch (InterruptedException interruptedException) {}
        }));
    }

    public static void offer(JobLogDTO dto) {
        if (dto != null) {
            queue.offer(dto);
        }
    }
}

