/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.mlink;

import com.kdjsystem.mlink.shop.dao.ShopCateDto;
import com.kdjsystem.mlink.tot.data.dao.DBCPInit;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;

public class MLinkShopDao {
    public static MLinkShopDao instance = new MLinkShopDao();

    private MLinkShopDao() {
    }

    public static MLinkShopDao get() {
        return instance;
    }

    public static ShopCateDto getNewCategorys(String id) throws Exception {
        ShopCateDto list = new ShopCateDto();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            connection = DBCPInit.getInstance().getConnection();
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT ID, ifnull(SHOPCATE,'') as SHOPCATE, ifnull(DOMECATG,'') as DOMECATG\r\n\tFROM category WHERE id =?");
            pstmt = connection.prepareStatement(sql.toString().toUpperCase());
            pstmt.setString(1, id);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.setId(rs.getString("ID"));
                list.setShopcate(rs.getString("SHOPCATE"));
                list.setDomecatg(rs.getString("DOMECATG"));
            }
            if (list.getId() == null || list.getId().equals("")) {
                ShopCateDto shopCateDto = list;
                DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                return shopCateDto;
            }
        }
        catch (Exception ex) {
            try {
                ex.printStackTrace();
                throw ex;
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                throw throwable;
            }
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public static String getFullCateName(String shopcd, String code) throws Exception {
        ArrayList<ShopCateDto> list = new ArrayList<ShopCateDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT   IFNULL(FULLCAT,'') AS FULLCAT \r\n");
                sql.append(" FROM DOMECATEG  \r\n");
                sql.append(" WHERE SHOPCD= ? \r\n");
                sql.append(" AND CODE = ? \r\n");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, shopcd);
                pstmt.setString(2, code);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ShopCateDto dto = new ShopCateDto();
                    dto.setName(rs.getString("FULLCAT"));
                    list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list.size() == 0 ? "" : ((ShopCateDto)list.get(0)).getName();
    }
}

