/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.mlink;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.shop.dao.ShopPreferencesDto;
import com.kdjsystem.mlink.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.shop.data.cafe24.Cafe24AcessToken;
import com.kdjsystem.mlink.shop.data.lotteon.LotteOnProductQnaDto;
import com.kdjsystem.mlink.tot.common.YDMAHttpUtil;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.stream.StreamSupport;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class MLinkShopStateUpdate {
    static MLinkShopStateUpdate instance = new MLinkShopStateUpdate();
    private static final List<String> cookieNeedShocdList = Arrays.asList("shop0067", "shop00671", "shop0068", "shop00681", "shop0004", "shop0055", "shop0041", "shop0003", "shop00031", "shop0110", "shop0076", "shop0075", "shop0106", "shop0233", "shop0007");
    JsonParser parser = new JsonParser();
    String userAgent = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36";

    public static MLinkShopStateUpdate get() {
        return instance;
    }

    public ShoppingMallDetailDto mallStatusUpdate(boolean execFlag, ShoppingMallDetailDto shopinfo) throws Exception {
        ShopPreferencesDto dto = ShopCommonDao.get().getSystemConf();
        String date = YDMATimeUtil.getCurrentDateHanjin();
        String shopcd = shopinfo.getShopcd();
        Map<String, String> cookies = this.getCookies(shopinfo, dto);
        switch (shopcd) {
            case "shop00671": 
            case "shop00681": {
                this.getESMStatus(shopinfo, cookies);
                break;
            }
            case "shop0004": {
                this.getBuyzleStatus(shopinfo, cookies);
                break;
            }
            case "shop0055": {
                this.getSmartStoreStatus(shopinfo, cookies);
                break;
            }
            case "shop0041": {
                this.getNaverPayStatus(shopinfo, cookies);
                break;
            }
            case "shop00031": {
                if (dto.getSecondAuth11styn().equals("Y")) {
                    this.get11stStatus(shopinfo, date, cookies);
                    break;
                }
                this.get11stStatus(shopinfo, date);
                break;
            }
            case "shop0110": {
                this.getCafe24Status(shopinfo, cookies);
                break;
            }
            case "shop0076": {
                this.getTmonStatus(shopinfo, cookies);
                break;
            }
            case "shop0273": {
                this.getKakaoStoreStatus(shopinfo, date);
                break;
            }
            case "shop0075": {
                this.getCoupangStatus(shopinfo, cookies);
                break;
            }
            case "shop0287": {
                this.getWemakepriceStatus(shopinfo);
                break;
            }
            case "shop0411": {
                this.getSsgStatus(shopinfo);
                break;
            }
            case "shop0372": {
                this.getLotteOnStatus(shopinfo, date);
                break;
            }
            case "shop0106": {
                this.getMelchiStatus(shopinfo, cookies);
                break;
            }
            case "shop0233": {
                this.get72timeStatus(shopinfo, cookies, YDMATimeUtil.getCurrentDateScheduler());
                break;
            }
            case "shop9984": {
                this.getAlwayzStatus(shopinfo);
                break;
            }
            case "shop9982": {
                this.getTossShoppingStatus(shopinfo, date);
                break;
            }
            case "shop0007": {
                this.getGsShopStatus(shopinfo, cookies);
            }
        }
        return shopinfo;
    }

    private Map<String, String> getCookies(ShoppingMallDetailDto shopinfo, ShopPreferencesDto dto) throws Exception {
        block15: {
            boolean flag = true;
            IShopCommonLogin i = new IShopCommonLogin(){};
            String loginID = shopinfo.getShoppingid();
            String password = shopinfo.getPassword();
            String shopcd = shopinfo.getShopcd();
            String authkey = shopinfo.getAuthkey1();
            String channelNo = shopinfo.getNicknm1();
            if (!cookieNeedShocdList.contains(shopcd)) break block15;
            switch (shopcd) {
                case "shop0055": {
                    List<String> multistore = Arrays.asList(shopinfo.getApikey().split(","));
                    if (multistore != null && multistore.size() > 1) {
                        return i.loginCookie(loginID, password, shopcd, flag, authkey, multistore.get(0), multistore.get(1));
                    }
                    return i.loginCookie(loginID, password, shopcd, flag, authkey, "", "");
                }
                case "shop0041": {
                    return i.loginCookie(loginID, password, shopcd, flag, authkey, channelNo, "");
                }
                case "shop00031": {
                    if (dto.getSecondAuth11styn().equals("Y")) {
                        return i.loginCookie(loginID, password, shopcd, flag, authkey);
                    }
                    return null;
                }
            }
            return i.loginCookie(loginID, password, shopcd, flag, authkey);
        }
        return null;
    }

    public ShoppingMallDetailDto get11stStatus(ShoppingMallDetailDto shopinfo, String date) throws Exception {
        shopinfo.setCookies("success");
        try {
            String apikey = shopinfo.getApikey();
            String startdt = YDMATimeUtil.getNetworkDayToSubtract(date, -6);
            String enddt = date;
            String startdt_tm = startdt + "0000";
            LocalDateTime now = LocalDateTime.now();
            String enddt_tm = date + String.format("%02d", now.getHour()) + String.format("%02d", now.getMinute());
            Hashtable<String, String> htRequestProperty = new Hashtable<String, String>();
            String url = String.format("https://api.11st.co.kr/rest/alimi/getalimilist/%s/%s/01", startdt, enddt);
            htRequestProperty.put("Content-Type", "text/xml");
            htRequestProperty.put("openapikey", apikey);
            String response = YDMAHttpUtil.get(url, htRequestProperty);
            response = response.replaceAll("ns2:", "");
            int emernotice = response.length() - response.replace("<emerNtceSeq>", "").length();
            shopinfo.setShopnotice(emernotice / 13);
            url = String.format("http://api.11st.co.kr/rest/prodqnaservices/prodqnalist/%s/%s/02", startdt, enddt);
            htRequestProperty = new Hashtable();
            htRequestProperty.put("Content-Type", "text/xml");
            htRequestProperty.put("openapikey", apikey);
            response = YDMAHttpUtil.get(url, htRequestProperty);
            response = response.replaceAll("ns2:", "");
            int question = response.length() - response.replace("<brdInfoClfNo>", "").length();
            shopinfo.setCustomerqna(question / 14);
            url = String.format("http://api.11st.co.kr/rest/claimservice/cancelorders/%s/%s", startdt_tm, enddt_tm);
            htRequestProperty = new Hashtable();
            htRequestProperty.put("Content-Type", "text/xml");
            htRequestProperty.put("openapikey", apikey);
            response = YDMAHttpUtil.get(url, htRequestProperty);
            response = response.replaceAll("ns2:", "");
            int cancelReq = response.length() - response.replace("<ordCnDtlsRsn>", "").length();
            url = String.format("http://api.11st.co.kr/rest/claimservice/returnorders/%s/%s", startdt_tm, enddt_tm);
            htRequestProperty = new Hashtable();
            htRequestProperty.put("Content-Type", "text/xml");
            htRequestProperty.put("openapikey", apikey);
            response = YDMAHttpUtil.get(url, htRequestProperty);
            response = response.replaceAll("ns2:", "");
            int returnReq = response.length() - response.replace("<clmReqCont>", "").length();
            url = String.format("http://api.11st.co.kr/rest/claimservice/exchangeorders/%s/%s", startdt_tm, enddt_tm);
            htRequestProperty = new Hashtable();
            htRequestProperty.put("Content-Type", "text/xml");
            htRequestProperty.put("openapikey", apikey);
            response = YDMAHttpUtil.get(url, htRequestProperty);
            response = response.replaceAll("ns2:", "");
            int exchangeReq = response.length() - response.replace("<clmReqCont>", "").length();
            shopinfo.setCancellationorder(cancelReq / 14 + returnReq / 12 + exchangeReq / 12);
            url = String.format("https://api.11st.co.kr/rest/ordservices/complete/%s/%s", startdt_tm, enddt_tm);
            htRequestProperty = new Hashtable();
            htRequestProperty.put("Content-Type", "text/xml");
            htRequestProperty.put("openapikey", apikey);
            response = YDMAHttpUtil.get(url, htRequestProperty);
            response = response.replaceAll("ns2:", "");
            int neword = response.length() - response.replace("<bndlDlvSeq>", "").length();
            shopinfo.setNeworder(neword / 12);
            url = String.format("https://api.11st.co.kr/rest/ordservices/packaging/%s/%s", startdt_tm, enddt_tm);
            htRequestProperty = new Hashtable();
            htRequestProperty.put("Content-Type", "text/xml");
            htRequestProperty.put("openapikey", apikey);
            response = YDMAHttpUtil.get(url, htRequestProperty);
            response = response.replaceAll("ns2:", "");
            int shippedbefore = response.length() - response.replace("<bndlDlvSeq>", "").length();
            shopinfo.setShippedbefore(shippedbefore / 12);
        }
        catch (Exception e) {
            YDMAStringUtil.Print("11\ubc88\uac00 \ubd88\ub7ec\uc624\ub294 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd " + String.valueOf(e));
            shopinfo.setCookies("");
            throw new Exception(e);
        }
        return shopinfo;
    }

    public ShoppingMallDetailDto get11stStatus(ShoppingMallDetailDto shopinfo, String date, Map<String, String> cookie) throws Exception {
        shopinfo.setCookies("success");
        try {
            String apikey = shopinfo.getApikey();
            String startdt = YDMATimeUtil.getNetworkDayToSubtract(date, -6);
            String enddt = date;
            String startdt_tm = startdt + "0000";
            LocalDateTime now = LocalDateTime.now();
            String enddt_tm = date + String.format("%02d", now.getHour()) + String.format("%02d", now.getMinute());
            Hashtable<String, String> htRequestProperty = new Hashtable<String, String>();
            String url = String.format("https://api.11st.co.kr/rest/alimi/getalimilist/%s/%s/01", startdt, enddt);
            htRequestProperty.put("Content-Type", "text/xml");
            htRequestProperty.put("openapikey", apikey);
            String response = YDMAHttpUtil.get(url, htRequestProperty);
            response = response.replaceAll("ns2:", "");
            int emernotice = response.length() - response.replace("<emerNtceSeq>", "").length();
            shopinfo.setShopnotice(emernotice / 13);
            url = String.format("http://api.11st.co.kr/rest/prodqnaservices/prodqnalist/%s/%s/02", startdt, enddt);
            htRequestProperty = new Hashtable();
            htRequestProperty.put("Content-Type", "text/xml");
            htRequestProperty.put("openapikey", apikey);
            response = YDMAHttpUtil.get(url, htRequestProperty);
            response = response.replaceAll("ns2:", "");
            int question = response.length() - response.replace("<brdInfoClfNo>", "").length();
            shopinfo.setCustomerqna(question / 14);
            url = String.format("http://api.11st.co.kr/rest/claimservice/cancelorders/%s/%s", startdt_tm, enddt_tm);
            htRequestProperty = new Hashtable();
            htRequestProperty.put("Content-Type", "text/xml");
            htRequestProperty.put("openapikey", apikey);
            response = YDMAHttpUtil.get(url, htRequestProperty);
            response = response.replaceAll("ns2:", "");
            int cancelReq = response.length() - response.replace("<ordCnDtlsRsn>", "").length();
            url = String.format("http://api.11st.co.kr/rest/claimservice/returnorders/%s/%s", startdt_tm, enddt_tm);
            htRequestProperty = new Hashtable();
            htRequestProperty.put("Content-Type", "text/xml");
            htRequestProperty.put("openapikey", apikey);
            response = YDMAHttpUtil.get(url, htRequestProperty);
            response = response.replaceAll("ns2:", "");
            int returnReq = response.length() - response.replace("<clmReqCont>", "").length();
            url = String.format("http://api.11st.co.kr/rest/claimservice/exchangeorders/%s/%s", startdt_tm, enddt_tm);
            htRequestProperty = new Hashtable();
            htRequestProperty.put("Content-Type", "text/xml");
            htRequestProperty.put("openapikey", apikey);
            response = YDMAHttpUtil.get(url, htRequestProperty);
            response = response.replaceAll("ns2:", "");
            int exchangeReq = response.length() - response.replace("<clmReqCont>", "").length();
            shopinfo.setCancellationorder(cancelReq / 14 + returnReq / 12 + exchangeReq / 12);
            url = String.format("https://api.11st.co.kr/rest/ordservices/complete/%s/%s", startdt_tm, enddt_tm);
            htRequestProperty = new Hashtable();
            htRequestProperty.put("Content-Type", "text/xml");
            htRequestProperty.put("openapikey", apikey);
            response = YDMAHttpUtil.get(url, htRequestProperty);
            response = response.replaceAll("ns2:", "");
            int neword = response.length() - response.replace("<bndlDlvSeq>", "").length();
            shopinfo.setNeworder(neword / 12);
            url = String.format("https://api.11st.co.kr/rest/ordservices/packaging/%s/%s", startdt_tm, enddt_tm);
            htRequestProperty = new Hashtable();
            htRequestProperty.put("Content-Type", "text/xml");
            htRequestProperty.put("openapikey", apikey);
            response = YDMAHttpUtil.get(url, htRequestProperty);
            response = response.replaceAll("ns2:", "");
            int shippedbefore = response.length() - response.replace("<bndlDlvSeq>", "").length();
            shopinfo.setShippedbefore(shippedbefore / 12);
            shopinfo.setCookies(cookie.toString());
            Connection.Response prodResponse = Jsoup.connect((String)"https://apis.11st.co.kr/product/bruce/selleroffice/v1/main/product-current-count").cookies(cookie).userAgent(this.userAgent).followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).execute();
            String prodBody = prodResponse.body();
            JsonObject prodObject = this.parser.parse(prodBody).getAsJsonObject();
            int saleProduct = prodObject.get("selling").getAsInt();
            int endScheduleProduct = prodObject.get("sellingDueDaySoon").getAsInt();
            shopinfo.setOnsaleproduct(saleProduct);
            shopinfo.setClosesale(endScheduleProduct);
            shopinfo.setRegisterproduct(saleProduct + endScheduleProduct);
        }
        catch (Exception e) {
            YDMAStringUtil.Print("11\ubc88\uac00 \ubd88\ub7ec\uc624\ub294 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd " + String.valueOf(e));
            shopinfo.setCookies("");
            throw new Exception(e);
        }
        return shopinfo;
    }

    public ShoppingMallDetailDto getBuyzleStatus(ShoppingMallDetailDto shopinfo, Map<String, String> cookie) {
        try {
            shopinfo.setCookies(cookie.toString());
            Document response_order = Jsoup.connect((String)"https://seller.buyzle.co.kr/main/sales").cookies(cookie).followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).get();
            Elements sales = response_order.select("div.statusBox > dl > a > dd");
            int neworder = Integer.parseInt(((Element)sales.get(1)).text());
            int confirmorder = Integer.parseInt(((Element)sales.get(2)).text());
            int claim = Integer.parseInt(((Element)sales.get(12)).text()) + Integer.parseInt(((Element)sales.get(13)).text()) + Integer.parseInt(((Element)sales.get(14)).text());
            shopinfo.setNeworder(neworder);
            shopinfo.setShippedbefore(confirmorder);
            shopinfo.setCancellationorder(claim);
            Document response_qna = Jsoup.connect((String)"https://seller.buyzle.co.kr/main/customer").cookies(cookie).followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).get();
            Elements inquiry = response_qna.select("span.tText");
            int notice = Integer.parseInt(((Element)inquiry.get(1)).text().replaceAll("[^0-9]", ""));
            int qna = Integer.parseInt(((Element)inquiry.get(0)).text().replaceAll("[^0-9]", ""));
            shopinfo.setShopnotice(notice);
            shopinfo.setCustomerqna(qna);
            Document response_prd = Jsoup.connect((String)"https://seller.buyzle.co.kr/main/sales-status").cookies(cookie).followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).get();
            Elements prd = response_prd.select("div.statusBox > dl > dd");
            int onsale = ((Element)prd.get(0)).text().equals("") ? 0 : Integer.parseInt(((Element)prd.get(0)).text().replaceAll("[^0-9]", ""));
            int sellingDueDaySoon = ((Element)prd.get(1)).text().equals("") ? 0 : Integer.parseInt(((Element)prd.get(1)).text().replaceAll("[^0-9]", ""));
            shopinfo.setOnsaleproduct(onsale);
            shopinfo.setRegisterproduct(-1);
            shopinfo.setClosesale(sellingDueDaySoon);
        }
        catch (Exception e) {
            YDMAStringUtil.Print("\ubc14\uc774\uc990 \ubd88\ub7ec\uc624\ub294 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd" + String.valueOf(e));
            shopinfo.setCookies("");
        }
        return shopinfo;
    }

    public ShoppingMallDetailDto getSmartStoreStatus(ShoppingMallDetailDto shopinfo, Map<String, String> cookie) {
        try {
            shopinfo.setCookies(cookie.toString());
            Connection.Response response_order = Jsoup.connect((String)"https://sell.smartstore.naver.com/api/dashboards/pay/sale-stats").cookies(cookie).followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).execute();
            JsonObject jsonObject = (JsonObject)this.parser.parse(response_order.body());
            int neworder = jsonObject.get("newOrderCases").getAsInt();
            int confirmorder = jsonObject.get("deliveryPreparingCases").getAsInt();
            shopinfo.setNeworder(neworder);
            shopinfo.setShippedbefore(confirmorder);
            Connection.Response response_claim = Jsoup.connect((String)"https://sell.smartstore.naver.com/api/dashboards/pay/claim").cookies(cookie).followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).execute();
            JsonObject jsonObject2 = (JsonObject)this.parser.parse(response_claim.body());
            int claim = jsonObject2.get("cancelClaimCases").getAsInt() + jsonObject2.get("exchangeClaimCases").getAsInt() + jsonObject2.get("returnClaimCases").getAsInt();
            shopinfo.setCancellationorder(claim);
            Connection.Response response_prd = Jsoup.connect((String)"https://sell.smartstore.naver.com/api/dashboards/channel/products").cookies(cookie).followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).execute();
            JsonObject jsonObject3 = (JsonObject)this.parser.parse(response_prd.body());
            int onsale = Integer.parseInt(jsonObject3.get("onSaleProductCount").getAsString().replace(",", ""));
            shopinfo.setClosesale(-1);
            shopinfo.setShopnotice(-1);
            shopinfo.setRegisterproduct(-1);
            shopinfo.setOnsaleproduct(onsale);
            Connection.Response response_inquiry = Jsoup.connect((String)"https://sell.smartstore.naver.com/api/dashboards/inquiries?isRefresh=false&page=0&size=4").cookies(cookie).followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).execute();
            String body4 = response_inquiry.body();
            JsonObject jsonObject4 = (JsonObject)this.parser.parse(body4);
            int inquiry = jsonObject4.get("customerInquiryCount").getAsInt() + jsonObject4.get("productInquiryCount").getAsInt() + jsonObject4.get("talktalkInquiryCount").getAsInt();
            shopinfo.setCustomerqna(inquiry);
        }
        catch (Exception e) {
            YDMAStringUtil.Print("\uc2a4\ub9c8\ud2b8\uc2a4\ud1a0\uc5b4 \ubd88\ub7ec\uc624\ub294 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd " + String.valueOf(e));
            shopinfo.setCookies("");
        }
        return shopinfo;
    }

    public ShoppingMallDetailDto getNaverPayStatus(ShoppingMallDetailDto shopinfo, Map<String, String> cookie) {
        try {
            shopinfo.setCookies(cookie.toString());
            Connection.Response rs = Jsoup.connect((String)"https://admin.pay.naver.com/").cookies(cookie).followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).execute();
            Document body = Jsoup.parseBodyFragment((String)rs.body());
            String newOrder = body.select("#container > div.aside > div.orderinfo > ul > li:nth-child(1) > em > a").text();
            shopinfo.setNeworder(Integer.parseInt(newOrder));
            String confirmorder = body.select("#container > div.aside > div.orderinfo > ul > li:nth-child(2) > em > a").text();
            shopinfo.setShippedbefore(Integer.parseInt(confirmorder));
            String cancel = body.select("#cancelClaimCases > strong").text();
            String exchange = body.select("#exchangeClaimCases > strong").text();
            String returnOrd = body.select("#returnClaimCases > strong").text();
            shopinfo.setCancellationorder(Integer.parseInt(cancel) + Integer.parseInt(exchange) + Integer.parseInt(returnOrd));
            String Question = body.select("#container > div.aside > div.orderinfo > ul > li.last > em > a").text();
            shopinfo.setCustomerqna(Integer.parseInt(Question));
        }
        catch (Exception e) {
            shopinfo.setCookies("");
            YDMAStringUtil.Print("\ub124\uc774\ubc84 \ud398\uc774\ub97c \ubd88\ub7ec\uc624\ub294 \uc911 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4. " + String.valueOf(e));
        }
        return shopinfo;
    }

    public ShoppingMallDetailDto getESMStatus(ShoppingMallDetailDto shopinfo, Map<String, String> cookie) {
        try {
            String shopcd = shopinfo.getShopcd();
            shopinfo.setCookies(cookie.toString());
            Connection.Response response_order = Jsoup.connect((String)"https://www.esmplus.com/SellNote/Info/HomeSellNoteData?isUseCache=1").referrer("https://www.esmplus.com/Home/Home").cookies(cookie).followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).execute();
            JsonObject orderObject = (JsonObject)this.parser.parse(response_order.body());
            orderObject = shopcd.equals("shop0067") || shopcd.equals("shop00671") ? orderObject.get("IACSellNoteData").getAsJsonObject() : (shopcd.equals("shop0068") || shopcd.equals("shop00681") ? orderObject.get("GMKTSellNoteData").getAsJsonObject() : orderObject.get("TotalSellNoteData").getAsJsonObject());
            int neworder = orderObject.get("NewOrder").getAsInt();
            int confirmorder = orderObject.get("DeliveryRequest").getAsInt();
            int claim = orderObject.get("ExchangeRequest").getAsInt() + orderObject.get("CancelRequest").getAsInt() + orderObject.get("ReturnRequest").getAsInt();
            shopinfo.setNeworder(neworder);
            shopinfo.setShippedbefore(confirmorder);
            shopinfo.setCancellationorder(claim);
            Connection.Response response_stock = Jsoup.connect((String)"https://www.esmplus.com/Home/MainGoodsData").cookies(cookie).followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).execute();
            JsonObject stockObject = (JsonObject)this.parser.parse(response_stock.body());
            stockObject = shopcd.equals("shop0067") || shopcd.equals("shop00671") ? (JsonObject)stockObject.get("IACMainGoodsDat") : (shopcd.equals("shop0068") || shopcd.equals("shop00681") ? (JsonObject)stockObject.get("GMKTMainGoodsDat") : (JsonObject)stockObject.get("TotalMainGoodsDat"));
            int stock = stockObject.get("SellStopLe7Cnt").getAsInt();
            shopinfo.setClosesale(stock);
            Connection.Response inquiry_auction = Jsoup.connect((String)"https://www.esmplus.com/Home/HomeDetailQna?type=1").cookies(cookie).followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).execute();
            Connection.Response inquiry_gmarket = Jsoup.connect((String)"https://www.esmplus.com/Home/HomeDetailQna?type=2").cookies(cookie).followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).execute();
            String body = "";
            body = shopcd.equals("shop0067") || shopcd.equals("shop00671") ? inquiry_auction.body() : (shopcd.equals("shop0068") || shopcd.equals("shop00681") ? inquiry_gmarket.body() : inquiry_auction.body());
            JsonObject inquiryObject = (JsonObject)this.parser.parse(body);
            int notice = inquiryObject.get("EmergencyQnACount").getAsInt();
            int inquiry = inquiryObject.get("ItemQnACount").getAsInt() + inquiryObject.get("NoteCount").getAsInt();
            String site = "";
            if (shopcd.equals("shop0067") || shopcd.equals("shop00671")) {
                site = "1";
            } else if (shopcd.equals("shop0068") || shopcd.equals("shop00681")) {
                site = "2";
            }
            StringBuilder jsonBuilder = new StringBuilder();
            jsonBuilder.append("{").append("\"Keyword\":\"\",").append("\"SiteId\":\"").append(site).append("\",").append("\"CategorySiteId\":-1,").append("\"CategoryCode\":\"\",").append("\"CategoryLevel\":\"\",").append("\"TransPolicyNo\":0,").append("\"StatusCode\":\"11\",").append("\"SearchDateType\":0,").append("\"SearchStartDate\":\"\",").append("\"SearchEndDate\":\"\",").append("\"SellerId\":\"").append(shopinfo.getShoppingid()).append("\",").append("\"SellerSiteId\":\"").append(site).append("\",").append("\"StockQty\":-1,").append("\"SellPeriod\":0,").append("\"DiscountUseIs\":-1,").append("\"DeliveryFeeApplyType\":0,").append("\"OptAddDeliveryType\":0,").append("\"OptSelUseIs\":-1,").append("\"PremiumEnd\":0,").append("\"PremiumPlusEnd\":0,").append("\"FocusEnd\":0,").append("\"FocusPlusEnd\":0,").append("\"GoodsIdType\":\"S\",").append("\"GoodsIds\":\"\",").append("\"ShopCateReg\":-1,").append("\"IsTPLUse\":\"\",").append("\"SellMinPrice\":0,").append("\"SellMaxPrice\":0,").append("\"OrderByType\":11,").append("\"GroupOrderByType\":1,").append("\"IsGroupUse\":\"\",").append("\"IsApplyEpin\":\"\",").append("\"IsConvertSingleGoods\":\"\",").append("\"DisplayLimityn\":\"\"").append("}");
            Connection.Response rs = Jsoup.connect((String)"https://www.esmplus.com/Sell/SingleGoodsMng/GetSingleGoodsList?_dc=1617695796702").cookies(cookie).header("Host", "www.esmplus.com").header("Origin", "http://www.esmplus.com").userAgent(this.userAgent).data("paramsData", jsonBuilder.toString()).data("page", "1").data("start", "0").data("limit", "30").referrer("http://www.esmplus.com/Sell/SingleGoodsMng?menuCode=TDM396").method(Connection.Method.POST).followRedirects(true).ignoreHttpErrors(true).ignoreContentType(true).execute();
            JsonObject jsonobject = (JsonObject)this.parser.parse(rs.body());
            int prodCount = jsonobject.get("total").getAsInt();
            shopinfo.setShopnotice(notice);
            shopinfo.setCustomerqna(inquiry);
            shopinfo.setRegisterproduct(-1);
            shopinfo.setOnsaleproduct(prodCount);
        }
        catch (Exception e) {
            YDMAStringUtil.Print("ESM \ubd88\ub7ec\uc624\ub294 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd " + String.valueOf(e));
            shopinfo.setCookies("");
        }
        return shopinfo;
    }

    public ShoppingMallDetailDto getCoupangStatus(ShoppingMallDetailDto shopinfo, Map<String, String> cookie) {
        try {
            shopinfo.setCookies(cookie.toString());
            String baseUrl = "https://wing.coupang.com/home-cards/%s/data?platform=DESKTOP";
            Connection.Response response_prd = Jsoup.connect((String)String.format(baseUrl, "ProductManagement")).cookies(cookie).followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).execute();
            JsonObject jsonObject = (JsonObject)this.parser.parse(response_prd.body());
            jsonObject = (JsonObject)jsonObject.get("data");
            jsonObject = (JsonObject)jsonObject.get("valid");
            int onsale = jsonObject.get("count").getAsInt();
            shopinfo.setOnsaleproduct(onsale);
            Connection.Response response_order = Jsoup.connect((String)String.format(baseUrl, "SalesDelivery")).cookies(cookie).followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).execute();
            JsonObject jsonObject2 = (JsonObject)this.parser.parse(response_order.body());
            jsonObject2 = (JsonObject)jsonObject2.get("data");
            jsonObject2 = (JsonObject)jsonObject2.get("statuses");
            JsonObject accept = (JsonObject)jsonObject2.get("accept");
            JsonObject instruct = (JsonObject)jsonObject2.get("instruct");
            int neworder = accept.get("count").getAsInt();
            int confirmorder = instruct.get("count").getAsInt();
            shopinfo.setNeworder(neworder);
            shopinfo.setShippedbefore(confirmorder);
            Connection.Response response_claim = Jsoup.connect((String)String.format(baseUrl, "CancelReturnExchange")).cookies(cookie).followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).execute();
            JsonObject jsonObject3 = (JsonObject)this.parser.parse(response_claim.body());
            jsonObject3 = (JsonObject)jsonObject3.get("data");
            JsonObject exchange = (JsonObject)jsonObject3.get("exchange");
            JsonObject releaseStop = (JsonObject)jsonObject3.get("releaseStop");
            JsonObject unConfirm = (JsonObject)jsonObject3.get("unConfirm");
            int claim = exchange.get("count").getAsInt() + releaseStop.get("count").getAsInt() + unConfirm.get("count").getAsInt();
            shopinfo.setCancellationorder(claim);
            Connection.Response response_inquiry = Jsoup.connect((String)String.format(baseUrl, "UnansweredInquiry")).cookies(cookie).followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).execute();
            JsonObject jsonObject4 = (JsonObject)this.parser.parse(response_inquiry.body());
            jsonObject4 = (JsonObject)jsonObject4.get("data");
            JsonObject csUnansweredInquiry = (JsonObject)jsonObject4.get("csUnansweredInquiry");
            JsonObject productUnansweredInquiry = (JsonObject)jsonObject4.get("productUnansweredInquiry");
            int inquiry = csUnansweredInquiry.get("count").getAsInt() + productUnansweredInquiry.get("count").getAsInt();
            shopinfo.setCustomerqna(inquiry);
            shopinfo.setShopnotice(-1);
            shopinfo.setRegisterproduct(-1);
        }
        catch (Exception e) {
            YDMAStringUtil.Print("\ucfe0\ud321 \ubd88\ub7ec\uc624\ub294 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd " + String.valueOf(e));
            shopinfo.setCookies("");
        }
        return shopinfo;
    }

    public ShoppingMallDetailDto getTmonStatus(ShoppingMallDetailDto shopinfo, Map<String, String> cookie) {
        try {
            shopinfo.setCookies(cookie.toString());
            Connection.Response response_prd = Jsoup.connect((String)"https://spc-www.tmon.co.kr/api/SELL/JSON").cookies(cookie).followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).execute();
            String body = response_prd.body();
            JsonObject jsonObject = (JsonObject)this.parser.parse(body);
            jsonObject = (JsonObject)jsonObject.get("data");
            JsonArray arr = (JsonArray)jsonObject.get("result");
            JsonObject onsale = (JsonObject)arr.get(0);
            JsonObject closesoon = (JsonObject)arr.get(1);
            int sales = Integer.parseInt(onsale.get("text1").getAsString().replace(",", "").replace("\uac74", "").trim());
            int closed = Integer.parseInt(closesoon.get("text1").getAsString().replace(",", "").replace("\uac74", "").trim());
            shopinfo.setOnsaleproduct(sales);
            shopinfo.setClosesale(closed);
            Connection.Response response_order = Jsoup.connect((String)"https://spc-www.tmon.co.kr/api/ORDER/JSON").cookies(cookie).followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).execute();
            JsonObject jsonObject2 = (JsonObject)this.parser.parse(response_order.body());
            jsonObject2 = (JsonObject)jsonObject2.get("data");
            JsonArray arr2 = (JsonArray)jsonObject2.get("result");
            JsonObject neword = (JsonObject)arr2.get(0);
            JsonObject confirm = (JsonObject)arr2.get(1);
            int neworder = Integer.parseInt(neword.get("text1").getAsString().replace(" \uac74", ""));
            int confirmorder = Integer.parseInt(confirm.get("text1").getAsString().replace(" \uac74", ""));
            shopinfo.setNeworder(neworder);
            shopinfo.setShippedbefore(confirmorder);
            Connection.Response response_claim = Jsoup.connect((String)"https://spc-www.tmon.co.kr/api/CANCEL/JSON").cookies(cookie).followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).execute();
            JsonObject jsonObject3 = (JsonObject)this.parser.parse(response_claim.body());
            jsonObject3 = (JsonObject)jsonObject3.get("data");
            JsonArray arr3 = (JsonArray)jsonObject3.get("result");
            JsonObject cancelreq = (JsonObject)arr3.get(0);
            JsonObject refundreq = (JsonObject)arr3.get(1);
            JsonObject exchangereq = (JsonObject)arr3.get(3);
            int cancel = Integer.parseInt(cancelreq.get("text1").getAsString().replace(" \uac74", ""));
            int returnreq = Integer.parseInt(refundreq.get("text1").getAsString().replace(" \uac74", ""));
            int exchange = Integer.parseInt(exchangereq.get("text1").getAsString().replace(" \uac74", ""));
            shopinfo.setCancellationorder(cancel + returnreq + exchange);
            Connection.Response response_inquiry = Jsoup.connect((String)"https://spc-www.tmon.co.kr/api/QUESTION/JSON").cookies(cookie).followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).execute();
            JsonObject jsonObject4 = (JsonObject)this.parser.parse(response_inquiry.body());
            jsonObject4 = (JsonObject)jsonObject4.get("data");
            JsonArray arr4 = (JsonArray)jsonObject4.get("result");
            JsonObject inquiry1 = (JsonObject)arr4.get(0);
            JsonObject inquiry2 = (JsonObject)arr4.get(1);
            int customerinquiry = Integer.parseInt(inquiry1.get("text2").getAsString().replace("\ubbf8\ub2f5\ubcc0", "").replace("\uac74", "").trim());
            int centerinquiry = Integer.parseInt(inquiry2.get("text2").getAsString().replace("\ubbf8\ub2f5\ubcc0", "").replace("\uac74", "").trim());
            shopinfo.setCustomerqna(customerinquiry + centerinquiry);
            shopinfo.setShopnotice(-1);
            shopinfo.setRegisterproduct(-1);
        }
        catch (Exception e) {
            YDMAStringUtil.Print("\ud2f0\ubaac \ubd88\ub7ec\uc624\ub294 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd " + String.valueOf(e));
            shopinfo.setCookies("");
        }
        return shopinfo;
    }

    public ShoppingMallDetailDto getMelchiStatus(ShoppingMallDetailDto shopinfo, Map<String, String> cookie) {
        try {
            shopinfo.setCookies(cookie.toString());
            Connection.Response response = Jsoup.connect((String)"https://scm.smelchi.com/member/seller").cookies(cookie).followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).execute();
            Document body = Jsoup.parseBodyFragment((String)response.body());
            String t = body.select("dd.point[onclick='javascript:goOrderList('02')']").text();
            shopinfo.setNeworder(Integer.parseInt(t));
            t = body.select("dd.point[onclick='javascript:goOrderList('03')']").text();
            shopinfo.setShippedbefore(Integer.parseInt(t));
            int claim = Integer.parseInt(body.select("dd#msg11 > a > span").text().length() > 0 ? body.select("dd#msg11 > a > span").text() : "0") + Integer.parseInt(body.select("dd#msg31 > a > span").text().length() > 0 ? body.select("dd#msg31 > a > span").text() : "0") + Integer.parseInt(body.select("dd#msg21 > a > span").text().length() > 0 ? body.select("dd#msg21 > a > span").text() : "0");
            shopinfo.setCancellationorder(claim);
            int inquiry = Integer.parseInt(body.select("td#qnaCntStatus2 > a > span").text().length() > 0 ? body.select("td#qnaCntStatus2 > a > span").text() : "0") + Integer.parseInt(body.select("td#buyerQnaCntStatus2 > a > span").text().length() > 0 ? body.select("td#buyerQnaCntStatus2 > a > span").text() : "0");
            shopinfo.setCustomerqna(inquiry);
            int onsale = Integer.parseInt(body.select("#table_style01 > tbody > tr:nth-child(2) > td > span").text().length() > 0 ? body.select("#table_style01 > tbody > tr:nth-child(2) > td > span").text().replace(",", "") : "0");
            int stopsale = Integer.parseInt(body.select("#table_style01 > tbody > tr:nth-child(3) > td > span").text().length() > 0 ? body.select("#table_style01 > tbody > tr:nth-child(3) > td > span").text().replace(",", "") : "0");
            shopinfo.setOnsaleproduct(onsale);
            shopinfo.setRegisterproduct(onsale + stopsale);
            shopinfo.setShopnotice(-1);
        }
        catch (Exception e) {
            YDMAStringUtil.Print("\uba78\uce58\uc1fc\ud551 \ubd88\ub7ec\uc624\ub294 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd " + String.valueOf(e));
            shopinfo.setCookies("");
        }
        return shopinfo;
    }

    public ShoppingMallDetailDto get72timeStatus(ShoppingMallDetailDto shopinfo, Map<String, String> cookie, String date) throws Exception {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        Date parse_date = formatter.parse(date);
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(parse_date);
        cal1.add(5, -7);
        String sdate = formatter.format(cal1.getTime());
        try {
            shopinfo.setCookies(cookie.toString());
            String cookies = cookie.toString().replace("{", "").replace("}", "").replaceAll(",", ";");
            URL url = URI.create("http://seller.72time.kr/mallinmall").toURL();
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            con.setReadTimeout(1000);
            con.setRequestProperty("Cookie", cookies);
            con.connect();
            Object result = "";
            BufferedReader reader = new BufferedReader(new InputStreamReader(con.getInputStream(), "euc-kr"));
            String inputLine = null;
            while ((inputLine = reader.readLine()) != null) {
                result = (String)result + inputLine + "\r\n";
            }
            reader.close();
            Document body = Jsoup.parse((String)result);
            String neworder = body.select("td:contains(\uc2e0\uaddc\uc8fc\ubb38)").next().text().replaceAll("[^0-9]", "");
            shopinfo.setNeworder(0);
            shopinfo.setShippedbefore(Integer.parseInt(neworder));
            int claim = Integer.parseInt(body.select("div:contains(\ud658\ubd88\uc2e0\uccad) > a").text().replaceAll("[^0-9]", "")) + Integer.parseInt(body.select("div:contains(\ubd80\ubd84\ud658\ubd88\uc2e0\uccad) > a").text().replaceAll("[^0-9]", ""));
            int inquiry = Integer.parseInt(body.select("td:contains(\uc0c1\ud488\ubb38\uc758)").next().text().replaceAll("[^0-9]", "")) + Integer.parseInt(body.select("td:contains(1:1 \ubb38\uc758)").next().text().replaceAll("[^0-9]", ""));
            shopinfo.setCustomerqna(inquiry);
            url = URI.create("http://seller.72time.kr/mallinmall/goods/goods_list.asp").toURL();
            con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            con.setReadTimeout(1000);
            con.setRequestProperty("Cookie", cookies);
            con.connect();
            reader = new BufferedReader(new InputStreamReader(con.getInputStream(), "euc-kr"));
            inputLine = null;
            result = "";
            while ((inputLine = reader.readLine()) != null) {
                result = (String)result + inputLine + "\r\n";
            }
            reader.close();
            body = Jsoup.parse((String)result);
            int onsale = Integer.parseInt(body.select("b:contains(\uc0c1\ud488\ubaa9\ub85d)").next().text().replaceAll("[^0-9]", ""));
            shopinfo.setOnsaleproduct(onsale);
            shopinfo.setRegisterproduct(-1);
            shopinfo.setClosesale(-1);
            shopinfo.setShopnotice(-1);
            HashMap<String, String> data2 = new HashMap<String, String>();
            data2.put("menu", "confirm");
            data2.put("mode", "");
            data2.put("uid", "");
            data2.put("suid", "");
            data2.put("page", "1");
            data2.put("listsize", "10");
            data2.put("order", "");
            data2.put("cancel_requestor", "");
            data2.put("view_type", "all");
            data2.put("sstate", "102");
            data2.put("sordstate", "102");
            data2.put("ssdate", sdate);
            data2.put("sedate", date);
            data2.put("skey", "ordname");
            data2.put("sword", "");
            data2.put("slistsize", "10");
            String URL2 = "http://seller.72time.kr/mallinmall/order/order_list.excel.etc.asp";
            body = Jsoup.connect((String)URL2).header("Content-Type", "application/x-www-form-urlencoded").cookies(cookie).data(data2).ignoreContentType(true).post();
            Elements odInfo = body.select("tr[bgcolor=#FFFFFF]");
            for (Element order : odInfo) {
                if (!order.select("tr > td:nth-child(28)").text().contains("\ucde8\uc18c\uc2e0\uccad")) continue;
                ++claim;
            }
            shopinfo.setCancellationorder(claim);
        }
        catch (Exception e) {
            YDMAStringUtil.Print("72\ud0c0\uc784 \ubd88\ub7ec\uc624\ub294 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd " + String.valueOf(e));
            shopinfo.setCookies("");
        }
        return shopinfo;
    }

    public ShoppingMallDetailDto getCafe24Status(ShoppingMallDetailDto shopinfo, Map<String, String> cookies) throws Exception {
        try {
            shopinfo.setCookies(cookies.toString());
            String id = shopinfo.getShoppingid();
            String productUrl = String.format("https://%s.cafe24.com/api/anew/product?shop_no=1&menu_name=dashboard&mode=pro", id);
            String json = "[{\"method\":\"getMenuQuery\",\"jsonrpc\":\"2.0\",\"id\":\"f0a49f6a\"}]";
            Connection.Response rs = Jsoup.connect((String)productUrl).cookies(cookies).method(Connection.Method.POST).header("Content-Type", "application/json").requestBody(json).ignoreContentType(true).followRedirects(true).execute();
            JsonArray jsonarray = (JsonArray)this.parser.parse(rs.body());
            JsonObject jsonObject = jsonarray.get(0).getAsJsonObject();
            jsonObject = jsonObject.get("result").getAsJsonObject();
            jsonObject = jsonObject.get("product_count").getAsJsonObject();
            YDMAStringUtil.Print();
            shopinfo.setOnsaleproduct(jsonObject.get("selling").getAsInt());
            shopinfo.setRegisterproduct(jsonObject.get("total").getAsInt());
            String orderUrl = String.format("https://%s.cafe24api.com/api/v2/admin/dashboard", id);
            Connection.Response response_order = Jsoup.connect((String)orderUrl).header("Authorization", "Bearer " + Cafe24AcessToken.get().getAccessToken(shopinfo)).header("Content-Type", "application/json").followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).execute();
            JsonObject Object2 = (JsonObject)this.parser.parse(response_order.body());
            Object2 = (JsonObject)Object2.get("dashboard");
            JsonArray dailysales = Object2.get("daily_sales_stats").getAsJsonArray();
            int neworder = 0;
            int confirmorder = 0;
            int cancelreq = 0;
            int returnreq = 0;
            int exchangereq = 0;
            for (JsonElement ele : dailysales) {
                JsonObject today = ele.getAsJsonObject();
                neworder += today.get("prepare_count").getAsInt();
                confirmorder += today.get("standby_count").getAsInt();
                cancelreq += today.get("canceled_count").getAsInt();
                returnreq += today.get("returned_count").getAsInt();
                exchangereq += today.get("exchanged_count").getAsInt();
            }
            shopinfo.setNeworder(neworder);
            shopinfo.setShippedbefore(confirmorder);
            shopinfo.setCancellationorder(cancelreq + returnreq + exchangereq);
            String questionUrl = String.format("https://%s.cafe24.com/admin/php/shop1/b/board_admin_bulletin_l.php", id);
            Document doc = Jsoup.connect((String)questionUrl).cookies(cookies).get();
            Elements strongTags = doc.select("p.total strong");
            shopinfo.setCustomerqna(Integer.parseInt(((Element)strongTags.get(0)).text()));
            shopinfo.setClosesale(-1);
            shopinfo.setShopnotice(-1);
        }
        catch (Exception e) {
            YDMAStringUtil.Print("\uce74\ud39824 \ubd88\ub7ec\uc624\ub294 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd " + String.valueOf(e));
            shopinfo.setCookies("");
            throw new Exception(e);
        }
        return shopinfo;
    }

    public ShoppingMallDetailDto getKakaoStoreStatus(ShoppingMallDetailDto shopinfo, String date) throws Exception {
        try {
            JsonObject jsonObject;
            Connection.Response rs;
            int neworder = 0;
            int confirmorder = 0;
            int claim = 0;
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
            Date sdate = formatter.parse(date);
            Calendar cal1 = Calendar.getInstance();
            cal1.setTime(sdate);
            String kakaoApi = shopinfo.getApikey();
            StringBuilder urlbuilder = new StringBuilder();
            urlbuilder.append("https://kapi.kakao.com/v2/shopping/orders?").append("orderModifiedAtStart=%s%%2000:00:00").append("&orderModifiedAtEnd=%s%%2023:59:59");
            String baseUrl = urlbuilder.toString();
            String formatDate = "";
            int i = 0;
            while (i < 7) {
                formatDate = YDMATimeUtil.convertSabangNetClaimDateToClmdt(date, false);
                rs = Jsoup.connect((String)String.format(baseUrl, formatDate, formatDate)).header("Host", "kapi.kakao.com").header("Authorization", "KakaoAK b99a474fd6fe27f966e76e37591f0053").header("Target-Authorization", "KakaoAK " + kakaoApi).header("channel-ids", "101").header("Content-Type", "application/json").followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).execute();
                jsonObject = this.parser.parse(rs.body()).getAsJsonObject();
                JsonArray arr = jsonObject.get("contents").getAsJsonArray();
                for (JsonElement ele : arr) {
                    switch (ele.getAsJsonObject().get("orderStatus").getAsString()) {
                        case "ShippingRequest": {
                            ++neworder;
                            break;
                        }
                        case "ShippingWaiting": {
                            ++confirmorder;
                            break;
                        }
                        case "ShippingCancelRequest": 
                        case "ReturnRequest": 
                        case "ExchangeRequest": 
                        case "ShippingCancelRequestBuyer": 
                        case "ShippingCancelRequestSeller": {
                            ++claim;
                        }
                    }
                }
                cal1.add(5, -1);
                date = formatter.format(cal1.getTime());
                ++i;
            }
            shopinfo.setNeworder(neworder);
            shopinfo.setShippedbefore(confirmorder);
            shopinfo.setCancellationorder(claim);
            rs = Jsoup.connect((String)"https://kapi.kakao.com/v1/store/products?page=1&size=10&productOrder=CREATED_AT&pageOrder=ASC").header("Host", "kapi.kakao.com").header("Authorization", "KakaoAK b99a474fd6fe27f966e76e37591f0053").header("Target-Authorization", "KakaoAK " + kakaoApi).header("channel-ids", "101").header("Content-Type", "application/x-www-form-urlencoded;charset=utf-8").followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).execute();
            jsonObject = this.parser.parse(rs.body()).getAsJsonObject();
            int totalcnt = jsonObject.get("totalCount").getAsInt();
            shopinfo.setRegisterproduct(totalcnt);
            shopinfo.setOnsaleproduct(-1);
            rs = Jsoup.connect((String)"https://kapi.kakao.com/v1/store/qna/unansweredCount").header("Host", "kapi.kakao.com").header("Authorization", "KakaoAK b99a474fd6fe27f966e76e37591f0053").header("Target-Authorization", "KakaoAK " + kakaoApi).header("channel-ids", "101").header("Content-Type", "application/x-www-form-urlencoded;charset=utf-8").followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).execute();
            jsonObject = this.parser.parse(rs.body()).getAsJsonObject();
            int inquiry = jsonObject.get("answer").getAsInt();
            shopinfo.setCustomerqna(inquiry);
            shopinfo.setShopnotice(-1);
            shopinfo.setClosesale(-1);
            shopinfo.setCookies("success");
        }
        catch (Exception e) {
            YDMAStringUtil.Print("\uce74\uce74\uc624\uc2a4\ud1a0\uc5b4 \ubd88\ub7ec\uc624\ub294 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd " + String.valueOf(e));
            shopinfo.setCookies("");
            throw new Exception(e);
        }
        return shopinfo;
    }

    public ShoppingMallDetailDto getWemakepriceStatus(ShoppingMallDetailDto shopinfo) {
        String date = YDMATimeUtil.getCurrentDateScheduler();
        int neworder = 0;
        int confirmorder = 0;
        int claim = 0;
        int inquiry = 0;
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            Date sdate = formatter.parse(date);
            Calendar cal1 = Calendar.getInstance();
            cal1.setTime(sdate);
            shopinfo.setCookies("success");
            int i = 0;
            while (i < 7) {
                Connection.Response response_inquiry;
                String body4;
                String json = "{ \"fromDate\": \"" + date + " 00:00:00\", \"toDate\": \"" + date + " 23:59:59\", \"type\": \"NEW\" }";
                Connection.Response response = Jsoup.connect((String)"http://api.kdjsystem.com:8082/wemarket/api/v2/getOrderList").header("apiKey", shopinfo.getApikey()).header("Accept", "application/json").header("Content-Type", "application/json").requestBody(json).followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
                JsonObject jsonObject = (JsonObject)this.parser.parse(response.body());
                jsonObject = (JsonObject)jsonObject.get("data");
                JsonArray arr = (JsonArray)jsonObject.get("bundle");
                neworder += arr.size();
                json = "{ \"fromDate\": \"" + date + " 00:00:00\", \"toDate\": \"" + date + " 23:59:59\", \"type\": \"CONFIRM\" }";
                response = Jsoup.connect((String)"http://api.kdjsystem.com:8082/wemarket/api/v2/getOrderList").header("apiKey", shopinfo.getApikey()).header("Accept", "application/json").header("Content-Type", "application/json").requestBody(json).followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
                String body = response.body();
                if (body.contains("\"error\":null")) {
                    jsonObject = (JsonObject)this.parser.parse(body);
                    jsonObject = (JsonObject)jsonObject.get("data");
                    arr = (JsonArray)jsonObject.get("bundle");
                    confirmorder += arr.size();
                }
                json = "{ \"fromDate\": \"" + date + " 00:00:00\", \"toDate\": \"" + date + " 23:59:59\", \"claimType\": \"CANCEL\", \"claimStatus\": \"REQUEST\" }";
                response = Jsoup.connect((String)"http://api.kdjsystem.com:8082/wemarket/api/v2/getClaimList").header("apiKey", shopinfo.getApikey()).header("Accept", "application/json").header("Content-Type", "application/json").requestBody(json).followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
                body = response.body();
                if (body.contains("\"error\":null")) {
                    jsonObject = (JsonObject)this.parser.parse(body);
                    jsonObject = (JsonObject)jsonObject.get("data");
                    arr = (JsonArray)jsonObject.get("claim");
                    claim += arr.size();
                }
                json = "{ \"fromDate\": \"" + date + " 00:00:00\", \"toDate\": \"" + date + " 23:59:59\", \"claimType\": \"EXCHANGE\", \"claimStatus\": \"REQUEST\" }";
                response = Jsoup.connect((String)"http://api.kdjsystem.com:8082/wemarket/api/v2/getClaimList").header("apiKey", shopinfo.getApikey()).header("Accept", "application/json").header("Content-Type", "application/json").requestBody(json).followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
                body = response.body();
                if (body.contains("\"error\":null")) {
                    jsonObject = (JsonObject)this.parser.parse(body);
                    jsonObject = (JsonObject)jsonObject.get("data");
                    arr = (JsonArray)jsonObject.get("claim");
                    claim += arr.size();
                }
                json = "{ \"fromDate\": \"" + date + " 00:00:00\", \"toDate\": \"" + date + " 23:59:59\", \"claimType\": \"RETURN\", \"claimStatus\": \"REQUEST\" }";
                response = Jsoup.connect((String)"http://api.kdjsystem.com:8082/wemarket/api/v2/getClaimList").header("apiKey", shopinfo.getApikey()).header("Accept", "application/json").header("Content-Type", "application/json").requestBody(json).followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
                body = response.body();
                if (body.contains("\"error\":null")) {
                    jsonObject = (JsonObject)this.parser.parse(body);
                    jsonObject = (JsonObject)jsonObject.get("data");
                    arr = (JsonArray)jsonObject.get("claim");
                    claim += arr.size();
                }
                if ((body4 = (response_inquiry = Jsoup.connect((String)("http://api.kdjsystem.com:8082/wemarket/api/v2/getQnaAPI?basicDate=" + date)).header("apiKey", shopinfo.getApikey()).followRedirects(true).ignoreContentType(true).ignoreHttpErrors(true).method(Connection.Method.GET).execute()).body()).contains("qnaSeq")) {
                    try {
                        JsonObject jsonObject4 = (JsonObject)this.parser.parse(body4);
                        int stridx = jsonObject4.get("message").getAsString().indexOf("{");
                        int endidx = jsonObject4.get("message").getAsString().lastIndexOf("}");
                        String result = jsonObject4.get("message").getAsString().substring(stridx, endidx + 1);
                        JsonObject jsonObject5 = (JsonObject)this.parser.parse(result);
                        arr = (JsonArray)jsonObject5.get("data");
                        inquiry += arr.size();
                    }
                    catch (Exception exception) {}
                }
                cal1.add(5, -1);
                date = formatter.format(cal1.getTime());
                ++i;
            }
            shopinfo.setNeworder(neworder);
            shopinfo.setShippedbefore(confirmorder);
            shopinfo.setCancellationorder(claim);
            shopinfo.setCustomerqna(inquiry);
            shopinfo.setRegisterproduct(-1);
            shopinfo.setOnsaleproduct(-1);
            shopinfo.setClosesale(-1);
            shopinfo.setShopnotice(-1);
        }
        catch (Exception e) {
            YDMAStringUtil.Print("\uc704\uba54\ud504 \ubd88\ub7ec\uc624\ub294 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd " + String.valueOf(e));
            shopinfo.setCookies("");
        }
        return shopinfo;
    }

    public ShoppingMallDetailDto getLotteOnStatus(ShoppingMallDetailDto shopinfo, String date) throws Exception {
        int neworder = 0;
        int confirmorder = 0;
        int claim = 0;
        int inquiry = 0;
        int shopnotice = 0;
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
            Date sdate = formatter.parse(date);
            Calendar cal1 = Calendar.getInstance();
            cal1.setTime(sdate);
            shopinfo.setCookies("success");
            ObjectMapper mapper = new ObjectMapper();
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            String basicLotteOnApiUrl = "https://openapi.lotteon.com/v1/openapi/";
            String bearerToken = "Bearer " + shopinfo.getApikey();
            int i = 0;
            while (i < 7) {
                Object json = "{\"srchStrtDt\":\"" + date + "000000\",\"srchEndDt\":\"" + date + "235959\",\"odPrgsStepCd\":\"11\"}";
                Connection.Response response = Jsoup.connect((String)(basicLotteOnApiUrl + "delivery/v1/SellerDeliveryProgressStateSearch")).header("Authorization", bearerToken).header("X-Agent-Authorization", "t86ur8pop2rb").header("Accept", "application/json").header("Accept-Language", "ko").header("X-Timezone", "GMT+09:00").header("Content-Type", "application/json").requestBody((String)json).followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
                JsonObject jsonObject = this.parser.parse(response.body()).getAsJsonObject();
                neworder += jsonObject.get("dataCount").getAsInt();
                json = "{\"srchStrtDt\":\"" + date + "000000\",\"srchEndDt\":\"" + date + "235959\",\"odPrgsStepCd\":\"12\"}";
                response = Jsoup.connect((String)(basicLotteOnApiUrl + "delivery/v1/SellerDeliveryProgressStateSearch")).header("Authorization", bearerToken).header("X-Agent-Authorization", "t86ur8pop2rb").header("Accept", "application/json").header("Accept-Language", "ko").header("X-Timezone", "GMT+09:00").header("Content-Type", "application/json").requestBody((String)json).followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
                jsonObject = this.parser.parse(response.body()).getAsJsonObject();
                confirmorder += jsonObject.get("dataCount").getAsInt();
                json = "{\"srchStrtDttm\":\"" + date + "000000\",\"srchEndDttm\":\"" + date + "235959\",\"odPrgsStepCd\":\"02\"}";
                response = Jsoup.connect((String)(basicLotteOnApiUrl + "claim/v1/cancellationOpenApi/getCancellationRequestAndComplateList")).header("Authorization", bearerToken).header("X-Agent-Authorization", "t86ur8pop2rb").header("Accept", "application/json").header("Accept-Language", "ko").header("X-Timezone", "GMT+09:00").header("Content-Type", "application/json").requestBody((String)json).followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
                jsonObject = this.parser.parse(response.body()).getAsJsonObject();
                claim += jsonObject.get("dataCount").isJsonNull() ? 0 : jsonObject.get("dataCount").getAsInt();
                json = "{\"srchStrtDttm\":\"" + date + "000000\",\"srchEndDttm\":\"" + date + "235959\", \"odPrgsStepCd\":\"03\"}";
                response = Jsoup.connect((String)(basicLotteOnApiUrl + "claim/v1/returningOpenApi/returnRequestSearch")).header("Authorization", bearerToken).header("X-Agent-Authorization", "t86ur8pop2rb").header("Accept", "application/json").header("Accept-Language", "ko").header("X-Timezone", "GMT+09:00").header("Content-Type", "application/json").requestBody((String)json).followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
                jsonObject = this.parser.parse(response.body()).getAsJsonObject();
                claim += jsonObject.get("dataCount").isJsonNull() ? 0 : jsonObject.get("dataCount").getAsInt();
                json = "{\"srchStrtDttm\":\"" + date + "000000\",\"srchEndDttm\":\"" + date + "235959\", \"odIfPrgsStepCd\":\"00\"}";
                response = Jsoup.connect((String)(basicLotteOnApiUrl + "claim/v1/exchangeOpenApi/exchangeSearch")).header("Authorization", bearerToken).header("X-Agent-Authorization", "t86ur8pop2rb").header("Accept", "application/json").header("Accept-Language", "ko").header("X-Timezone", "GMT+09:00").header("Content-Type", "application/json").requestBody((String)json).followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
                jsonObject = this.parser.parse(response.body()).getAsJsonObject();
                claim += jsonObject.get("dataCount").isJsonNull() ? 0 : jsonObject.get("dataCount").getAsInt();
                json = "{\"scStrtDt\":\"" + date + "\",\"scEndDt\":\"" + date + "\", \"ctctCfmYn\" : \"N\"}";
                response = Jsoup.connect((String)(basicLotteOnApiUrl + "customer/v1/getSellerContactList")).header("Authorization", bearerToken).header("X-Agent-Authorization", "t86ur8pop2rb").header("Accept", "application/json").header("Accept-Language", "ko").header("X-Timezone", "GMT+09:00").header("Content-Type", "application/json").requestBody((String)json).followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
                jsonObject = this.parser.parse(response.body()).getAsJsonObject();
                if (!jsonObject.get("rsltList").isJsonNull()) {
                    JsonArray arr = jsonObject.get("rsltList").getAsJsonArray();
                    shopnotice = (int)((long)shopnotice + StreamSupport.stream(arr.spliterator(), false).map(JsonElement::getAsJsonObject).filter(obj -> obj.has("sndDvsNm") && !obj.get("sndDvsNm").isJsonNull() && "\ubc1c\uc1a1".equals(obj.get("sndDvsNm").getAsString())).count());
                }
                LotteOnProductQnaDto.RequestParameter requestParmeter = new LotteOnProductQnaDto.RequestParameter();
                requestParmeter.trGrpCd = "SR";
                requestParmeter.trNo = shopinfo.getAuthkey1();
                requestParmeter.regEndDttm = date + "235959";
                requestParmeter.regStrDttm = date + "000000";
                requestParmeter.qnaStatCd = "NPROC";
                requestParmeter.pageNo = "1";
                requestParmeter.rowsPerPage = "100";
                json = mapper.writeValueAsString((Object)requestParmeter);
                response = Jsoup.connect((String)(basicLotteOnApiUrl + "product/v1/product/qna/list")).header("Authorization", bearerToken).header("X-Agent-Authorization", "t86ur8pop2rb").header("Accept", "application/json").header("Accept-Language", "ko").header("X-Timezone", "GMT+09:00").header("Content-Type", "application/json").requestBody((String)json).followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
                jsonObject = this.parser.parse(response.body()).getAsJsonObject();
                inquiry += jsonObject.get("dataCount").getAsInt();
                json = "{\"scStrtDt\": \"" + date + "\", \"scEndDt\": \"" + date + "\", \"slrInqProcStatCd\": \"UNANS\"}";
                response = Jsoup.connect((String)(basicLotteOnApiUrl + "customer/v1/getSellerInquiryList")).header("Authorization", bearerToken).header("X-Agent-Authorization", "t86ur8pop2rb").header("Accept", "application/json").header("Accept-Language", "ko").header("X-Timezone", "GMT+09:00").header("Content-Type", "application/json").requestBody((String)json).followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
                jsonObject = this.parser.parse(response.body()).getAsJsonObject();
                inquiry += jsonObject.get("rsltList").isJsonNull() ? 0 : jsonObject.get("rsltList").getAsJsonArray().size();
                cal1.add(5, -1);
                date = formatter.format(cal1.getTime());
                ++i;
            }
            String json = "{\"trGrpCd\":\"SR\",\"pageNo\":1,\"rowsPerPage\":30,\"trNo\":\"" + shopinfo.getAuthkey1() + "\",\"regStrtDttm\":\"19900101000000\",\"regEndDttm\":\"29991231235959\",\"slStatCd\":\"SALE\"}";
            Connection.Response response = Jsoup.connect((String)(basicLotteOnApiUrl + "product/v1/product/list")).header("Authorization", bearerToken).header("X-Agent-Authorization", "t86ur8pop2rb").header("Accept", "application/json").header("Accept-Language", "ko").header("X-Timezone", "GMT+09:00").header("Content-Type", "application/json").requestBody(json).followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
            if (response.statusCode() == 200) {
                try {
                    JsonObject result = this.parser.parse(response.body()).getAsJsonObject();
                    int prodCount = result.get("dataCount").getAsInt();
                    shopinfo.setOnsaleproduct(prodCount);
                }
                catch (Exception exception) {
                    shopinfo.setOnsaleproduct(-1);
                }
            } else {
                shopinfo.setOnsaleproduct(-1);
            }
            shopinfo.setNeworder(neworder);
            shopinfo.setShippedbefore(confirmorder);
            shopinfo.setCancellationorder(claim);
            shopinfo.setCustomerqna(inquiry);
            shopinfo.setShopnotice(shopnotice);
            shopinfo.setRegisterproduct(-1);
            shopinfo.setClosesale(-1);
        }
        catch (Exception e) {
            YDMAStringUtil.Print("\ub86f\ub370\uc628 \ubd88\ub7ec\uc624\ub294 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd " + String.valueOf(e));
            shopinfo.setCookies("");
            throw new Exception(e);
        }
        return shopinfo;
    }

    public ShoppingMallDetailDto getSsgStatus(ShoppingMallDetailDto shopinfo) {
        try {
            JsonElement obj;
            String date = YDMATimeUtil.getCurrentDateScheduler();
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            Date sdate = formatter.parse(date);
            Calendar cal1 = Calendar.getInstance();
            cal1.setTime(sdate);
            cal1.add(5, -6);
            String startdate = formatter.format(cal1.getTime());
            shopinfo.setCookies("success");
            String json = "{\"requestShppDirection\":{\"perdType\":\"02\",\"perdStrDts\":\"" + startdate + "\",\"perdEndDts\":\"" + date + "\",\"commType\":null,\"commValue\":null,\"shppDivDtlCd\":null,\"shppStatCd\":\"10\",\"rsvtItemYn\":null,\"frgShppYn\":null,\"reOrderYns\":null,\"itemNm\":null,\"itemDiv\":null,\"itemId\":null,\"splVenItemId\":null,\"rcptpeNm\":null,\"ordpeNm\":null,\"mbrId\":null,\"mallTypeCd\":null}}";
            Connection.Response rs = Jsoup.connect((String)"https://eapi.ssgadm.com/api/pd/1/listShppDirection.ssg").header("Authorization", shopinfo.getApikey()).header("accept", "application/json").header("Content-Type", "application/json").requestBody(json).followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
            JsonObject jsonObject = this.parser.parse(rs.body()).getAsJsonObject();
            jsonObject = jsonObject.get("result").getAsJsonObject();
            JsonArray arr = jsonObject.get("shppDirections").getAsJsonArray();
            int neworder = 0;
            if (!arr.get(0).toString().equals("\"\"")) {
                jsonObject = arr.get(0).getAsJsonObject();
                JsonElement obj2 = jsonObject.get("shppDirection");
                if (obj2 instanceof JsonObject) {
                    neworder = 1;
                } else if (obj2 instanceof JsonArray) {
                    jsonObject = arr.get(0).getAsJsonObject();
                    arr = (JsonArray)jsonObject.get("shppDirection");
                    neworder = arr.size();
                }
            }
            json = "{\"requestWarehouseOut\":{\"perdType\":\"02\",\"perdStrDts\":\"" + startdate + "\",\"perdEndDts\":\"" + date + "\"}}";
            rs = Jsoup.connect((String)"https://eapi.ssgadm.com/api/pd/1/listWarehouseOut.ssg").header("Authorization", shopinfo.getApikey()).header("accept", "application/json").header("Content-Type", "application/json").requestBody(json).followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
            jsonObject = this.parser.parse(rs.body()).getAsJsonObject();
            jsonObject = jsonObject.get("result").getAsJsonObject();
            arr = jsonObject.get("warehouseOuts").getAsJsonArray();
            int confirmorder = 0;
            if (!arr.get(0).toString().equals("\"\"")) {
                jsonObject = arr.get(0).getAsJsonObject();
                JsonElement obj3 = jsonObject.get("warehouseOut");
                if (obj3 instanceof JsonObject) {
                    ++confirmorder;
                } else if (obj3 instanceof JsonArray) {
                    jsonObject = arr.get(0).getAsJsonObject();
                    arr = (JsonArray)jsonObject.get("warehouseOut");
                    confirmorder = arr.size();
                }
            }
            shopinfo.setNeworder(neworder);
            shopinfo.setShippedbefore(confirmorder);
            startdate = startdate.replace("-", "");
            date = date.replace("-", "");
            rs = Jsoup.connect((String)"https://eapi.ssgadm.com/api/claim/v2/cancel/requests").header("Authorization", shopinfo.getApikey()).header("accept", "application/json").header("Content-Type", "application/json").data("perdStrDts", startdate).data("perdEndDts", date).requestBody(json).followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
            jsonObject = this.parser.parse(rs.body()).getAsJsonObject();
            jsonObject = jsonObject.get("result").getAsJsonObject();
            int cancelreq = 0;
            if (jsonObject.has("resultData")) {
                obj = jsonObject.get("resultData");
                if (obj instanceof JsonObject) {
                    ++cancelreq;
                } else if (obj instanceof JsonArray) {
                    jsonObject = arr.get(0).getAsJsonObject();
                    arr = (JsonArray)jsonObject.get("resultData");
                    cancelreq = arr.size();
                }
            }
            json = "{\"requestExchangeTarget\":{\"perdType\":\"01\",\"perdStrDts\":\"" + startdate + "\",\"perdEndDts\":\"" + date + "\"}}";
            rs = Jsoup.connect((String)"https://eapi.ssgadm.com/api/pd/1/listExchangeTarget.ssg").header("Authorization", shopinfo.getApikey()).header("Accept", "application/json").header("Content-Type", "application/json").requestBody(json).followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
            jsonObject = this.parser.parse(rs.body()).getAsJsonObject();
            arr = (jsonObject = jsonObject.get("result").getAsJsonObject()).get("exchangeTargets").getAsJsonArray();
            if (!arr.get(0).toString().equals("\"\"")) {
                jsonObject = arr.get(0).getAsJsonObject();
                obj = jsonObject.get("exchangeTarget");
                if (obj instanceof JsonObject) {
                    ++cancelreq;
                } else if (obj instanceof JsonArray) {
                    jsonObject = arr.get(0).getAsJsonObject();
                    arr = (JsonArray)jsonObject.get("exchangeTarget");
                    cancelreq = arr.size();
                }
            }
            shopinfo.setCancellationorder(cancelreq);
            json = "{\"postngReq\":{\"qnaStartDt\":\"" + startdate + "0000\",\"qnaEndDt\":\"" + date + "0000\"}}";
            rs = Jsoup.connect((String)"https://eapi.ssgadm.com/api/postng/qnaList.ssg").header("Authorization", shopinfo.getApikey()).header("accept", "application/json").header("Content-Type", "application/json").requestBody(json).followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
            jsonObject = this.parser.parse(rs.body()).getAsJsonObject();
            jsonObject = jsonObject.get("result").getAsJsonObject();
            int inquiry = 0;
            shopinfo.setCustomerqna(inquiry += jsonObject.get("totalCount").getAsInt());
            shopinfo.setClosesale(-1);
            shopinfo.setShopnotice(-1);
            shopinfo.setOnsaleproduct(-1);
            shopinfo.setRegisterproduct(-1);
        }
        catch (Exception e) {
            YDMAStringUtil.Print("SSG \ubd88\ub7ec\uc624\ub294 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd " + String.valueOf(e));
            shopinfo.setCookies("");
        }
        return shopinfo;
    }

    public ShoppingMallDetailDto getAlwayzStatus(ShoppingMallDetailDto shopinfo) {
        int neworder = 0;
        int confirmorder = 0;
        int inquiry = 0;
        int shopnotice = 0;
        int saleProduct = 0;
        int cancelCount = 0;
        int refundCount = 0;
        if (!shopinfo.getApikey().equals("")) {
            try {
                String inputLine;
                shopinfo.setCookies("success");
                String json = "{\"condition\":{\"type\":\"item\",\"itemCondition\":{\"soldOut\":false,\"$or\":[{\"outOfStock\":false},{\"outOfStock\":null}]}}}";
                Connection.Response rs = Jsoup.connect((String)"https://alwayz-seller-back.ilevit.com/sellers/items/v2/count-request").header("Connection", "keep-alive").header("Content-Type", "application/json").header("x-access-token", shopinfo.getApikey()).userAgent(this.userAgent).method(Connection.Method.POST).requestBody(json).ignoreHttpErrors(true).ignoreContentType(true).followRedirects(true).execute();
                JsonObject jsonObject = this.parser.parse(rs.body()).getAsJsonObject();
                int status2 = jsonObject.get("status").getAsInt();
                int data2 = jsonObject.get("data").getAsInt();
                if (status2 == 200) {
                    saleProduct = data2;
                }
                shopinfo.setOnsaleproduct(saleProduct);
                URL url = URI.create("https://alwayz-seller-back.ilevit.com/sellers/orders/status").toURL();
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setRequestProperty("User-Agent", this.userAgent);
                connection.setRequestProperty("x-access-token", shopinfo.getApikey());
                BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                StringBuilder response = new StringBuilder();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                in.close();
                jsonObject = this.parser.parse(response.toString()).getAsJsonObject();
                int status1 = jsonObject.get("status").getAsInt();
                if (status1 == 200) {
                    JsonArray dataArray = jsonObject.get("data").getAsJsonArray();
                    int i = 0;
                    while (i < dataArray.size()) {
                        JsonObject object = dataArray.get(i).getAsJsonObject();
                        String dataStatus = object.get("status").getAsString();
                        int dataCount = Integer.parseInt(object.get("totalOrderNum").toString());
                        if (dataStatus.equals("canceling-pre-shipping-post-excel") && dataCount > 0) {
                            cancelCount = dataCount;
                        } else if ((dataStatus.equals("refunding") || dataStatus.equals("canceling-shipping")) && dataCount > 0) {
                            refundCount = dataCount;
                        } else if (dataStatus.equals("pre-shipping-post-excel") && dataCount > 0) {
                            confirmorder = dataCount;
                        } else if (dataStatus.equals("pre-shipping-pre-excel") && dataCount > 0) {
                            neworder = dataCount;
                        }
                        ++i;
                    }
                }
                shopinfo.setNeworder(neworder);
                shopinfo.setShippedbefore(confirmorder);
                shopinfo.setCancellationorder(cancelCount + refundCount);
                String json1 = "{\"type\":\"ITEM_QUESTION\"}";
                inquiry = this.getQnA(json1, shopinfo);
                shopinfo.setCustomerqna(inquiry);
                String json2 = "{\"type\":\"QUESTION_FROM_ADMIN\"}";
                shopnotice = this.getQnA(json2, shopinfo);
                shopinfo.setShopnotice(shopnotice);
                shopinfo.setRegisterproduct(-1);
                shopinfo.setClosesale(-1);
            }
            catch (Exception e) {
                YDMAStringUtil.Print("Home \ud654\uba74\uc5d0\uc11c \uc62c\uc6e8\uc774\uc988\ub97c \ubd88\ub7ec\uc624\ub294 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd " + String.valueOf(e));
                shopinfo.setCookies("");
            }
        }
        return shopinfo;
    }

    public int getQnA(String json, ShoppingMallDetailDto shopinfo) {
        int count = 0;
        try {
            String url = "https://alwayz-seller-back.ilevit.com/sellers/questions-by-condition?condition=" + URLEncoder.encode(json, "UTF-8") + "&limit=-1&skip=0";
            Connection.Response rs = Jsoup.connect((String)url).header("Connection", "keep-alive").header("x-access-token", shopinfo.getApikey()).userAgent(this.userAgent).method(Connection.Method.GET).ignoreHttpErrors(true).ignoreContentType(true).followRedirects(true).execute();
            JsonObject jsonObject = this.parser.parse(rs.body()).getAsJsonObject();
            int status2 = jsonObject.get("status").getAsInt();
            JsonArray dataArray = jsonObject.get("data").getAsJsonArray();
            if (status2 == 200 && dataArray.size() > 0) {
                int i = 0;
                while (i < dataArray.size()) {
                    JsonObject object = dataArray.get(i).getAsJsonObject();
                    if (!object.has("answerInfo") || object.get("answerInfo").isJsonNull()) {
                        ++count;
                    }
                    ++i;
                }
            }
        }
        catch (Exception exception) {}
        return count;
    }

    public ShoppingMallDetailDto getTossShoppingStatus(ShoppingMallDetailDto shopinfo, String date) throws Exception {
        String apikey = shopinfo.getApikey();
        String startdt = YDMATimeUtil.getNetworkDayToSubtract(date, -6);
        String enddt = date;
        IShopCommonLogin is = new IShopCommonLogin(){};
        SimpleDateFormat inputFormat = new SimpleDateFormat("yyyyMMdd");
        SimpleDateFormat outputFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            startdt = outputFormat.format(inputFormat.parse(startdt));
            enddt = outputFormat.format(inputFormat.parse(enddt));
        }
        catch (Exception e) {
            YDMAStringUtil.Print("\ub0a0\uc9dc \ubcc0\ud658 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd: " + e.getMessage());
            shopinfo.setCookies("");
            return shopinfo;
        }
        int neworder = 0;
        int confirmorder = 0;
        int claim = 0;
        int shopnotice = -1;
        int question = 0;
        try {
            Connection.Response rs;
            Map<String, String> cookie = is.getTossCookies(shopinfo.getShoppingid(), shopinfo.getPassword());
            shopinfo.setCookies(cookie.toString());
            JsonObject body = new JsonObject();
            JsonObject successOrderObject = new JsonObject();
            JsonObject pagingObject = new JsonObject();
            String strParam = "";
            String[] orderStatus = new String[]{"\uacb0\uc81c\uc644\ub8cc", "\uc0c1\ud488\uc900\ube44\uc911", "\ubc1c\uc1a1\uc9c0\uc5f0"};
            int i = 0;
            while (i < 3) {
                strParam = this.getTossNewOrderStringParam(apikey, startdt, enddt, orderStatus[i]);
                rs = Jsoup.connect((String)"https://api-public.toss.im/api-public/v1/shopping-order/order/histories/paging").cookies(cookie).header("content-type", "application/json").header("X-Merchant-id", apikey).userAgent(this.userAgent).requestBody(strParam).method(Connection.Method.POST).ignoreContentType(true).execute();
                body = this.parser.parse(rs.body()).getAsJsonObject();
                successOrderObject = body.getAsJsonObject("success");
                pagingObject = successOrderObject.getAsJsonObject("paging");
                if (i == 0) {
                    neworder += pagingObject.get("totalCount").getAsInt();
                } else {
                    confirmorder += pagingObject.get("totalCount").getAsInt();
                }
                ++i;
            }
            String[] claimTypes = new String[]{"CANCEL", "EXCHANGE", "RETURN"};
            int i2 = 0;
            while (i2 < 3) {
                strParam = this.getTossOrderClaimSyncStringParam(claimTypes[i2], startdt, enddt);
                rs = Jsoup.connect((String)"https://api-public.toss.im/api-public/v1/shopping-order/orders/claims").cookies(cookie).header("content-type", "application/json").header("X-Merchant-id", apikey).userAgent(this.userAgent).requestBody(strParam).method(Connection.Method.POST).ignoreContentType(true).execute();
                body = this.parser.parse(rs.body()).getAsJsonObject();
                successOrderObject = body.getAsJsonObject("success");
                pagingObject = successOrderObject.getAsJsonObject("paging");
                claim += pagingObject.get("totalCount").getAsInt();
                ++i2;
            }
            shopinfo.setNeworder(neworder);
            shopinfo.setShippedbefore(confirmorder);
            shopinfo.setCancellationorder(claim);
            JsonObject inquiryRequestBody = new JsonObject();
            inquiryRequestBody.addProperty("page", (Number)1);
            inquiryRequestBody.addProperty("pageSize", (Number)50);
            JsonArray statuses = new JsonArray();
            statuses.add("READY");
            inquiryRequestBody.add("statuses", (JsonElement)statuses);
            JsonArray types = new JsonArray();
            inquiryRequestBody.add("types", (JsonElement)types);
            inquiryRequestBody.addProperty("merchantId", apikey);
            rs = Jsoup.connect((String)"https://shopping-merchant-api.toss.im/api-public/v3/shopping-merchant/product/inquiry/all").header("Content-Type", "application/json").userAgent(this.userAgent).requestBody(inquiryRequestBody.toString()).cookies(cookie).method(Connection.Method.POST).ignoreContentType(true).execute();
            JsonObject inquiryResponseBody = this.parser.parse(rs.body()).getAsJsonObject();
            if (inquiryResponseBody.has("success")) {
                JsonObject successObject = inquiryResponseBody.getAsJsonObject("success");
                question = successObject.get("totalCount").getAsInt();
            }
            shopinfo.setShopnotice(shopnotice);
            shopinfo.setCustomerqna(question);
            int totalCount = 0;
            int onsaleTotalCount = 0;
            rs = Jsoup.connect((String)"https://api-public.toss.im/api-public/v2/shopping-internal/products?").data("page", "0").data("size", "50").header("x-merchant-id", apikey).timeout(100000).cookies(cookie).method(Connection.Method.GET).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36").ignoreContentType(true).execute();
            JsonObject productResponseBody = this.parser.parse(rs.body()).getAsJsonObject();
            if (productResponseBody.has("success")) {
                JsonObject successObject = productResponseBody.getAsJsonObject("success");
                JsonObject paging = successObject.getAsJsonObject("paging");
                totalCount = paging.get("totalCount").getAsInt();
            }
            shopinfo.setRegisterproduct(totalCount);
            rs = Jsoup.connect((String)"https://api-public.toss.im/api-public/v2/shopping-internal/products?").data("page", "0").data("size", "50").data("displayStatuses", "\ub178\ucd9c\uc911").cookies(cookie).method(Connection.Method.GET).header("x-merchant-id", apikey).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36").ignoreContentType(true).execute();
            JsonObject onsaleResponseBody = this.parser.parse(rs.body()).getAsJsonObject();
            if (onsaleResponseBody.has("success")) {
                JsonObject successObject = onsaleResponseBody.getAsJsonObject("success");
                JsonObject paging = successObject.getAsJsonObject("paging");
                onsaleTotalCount = paging.get("totalCount").getAsInt();
            }
            shopinfo.setOnsaleproduct(onsaleTotalCount);
            shopinfo.setClosesale(-1);
        }
        catch (IOException e) {
            YDMAStringUtil.Print("Home \ud654\uba74\uc5d0\uc11c \ud1a0\uc2a4\uc1fc\ud551\uc744 \ubd88\ub7ec\uc624\ub294 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd " + String.valueOf(e));
            shopinfo.setCookies("");
        }
        return shopinfo;
    }

    private String getTossNewOrderStringParam(String merchantId, String startDate, String endDate, String orderStatus) throws Exception {
        JsonObject json = new JsonObject();
        json.addProperty("merchantId", merchantId);
        json.addProperty("queryType", "ORDER_ID");
        json.addProperty("query", "");
        json.addProperty("startDate", startDate);
        json.addProperty("endDate", endDate);
        json.addProperty("orderProductStatus", orderStatus);
        json.addProperty("masking", Boolean.valueOf(true));
        json.add("stockIds", (JsonElement)new JsonArray());
        json.addProperty("page", (Number)1);
        json.addProperty("pageSize", (Number)200);
        json.addProperty("sortDirection", "DESC");
        return json.toString();
    }

    private String getTossOrderClaimSyncStringParam(String type, String startDate, String endDate) throws Exception {
        JsonObject json = new JsonObject();
        json.addProperty("type", type);
        json.addProperty("page", (Number)1);
        json.addProperty("fromRequestDate", startDate);
        json.addProperty("toRequestDate", endDate);
        JsonArray statuses = new JsonArray();
        statuses.add("REQUESTED");
        json.add("statuses", (JsonElement)statuses);
        json.addProperty("pageSize", (Number)50);
        return json.toString();
    }

    private void getGsShopStatus(ShoppingMallDetailDto shopinfo, Map<String, String> cookies) {
        int neworder = 0;
        int confirmorder = 0;
        int claim = 0;
        int inquiry = 0;
        int shopnotice = 0;
        int saleProduct = 0;
        try {
            shopinfo.setCookies(cookies.toString());
            Connection.Response rs = Jsoup.connect((String)"https://withgs.gsshop.com/cmm/main/listmainTopMonitor").userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36").cookies(cookies).header("Content-Type", "application/json").header("Accept", "application/json, text/plain, */*").requestBody("").method(Connection.Method.POST).ignoreContentType(true).timeout(15000).execute();
            JsonObject obj = this.parser.parse(rs.body()).getAsJsonObject();
            JsonObject mainTopMonitor = obj.get("mainTopMonitor").getAsJsonObject();
            neworder = mainTopMonitor.get("dirdlvOrdToday").getAsInt();
            claim = mainTopMonitor.get("dirdlvRtpToday").getAsInt() + mainTopMonitor.get("dirdlvCnlToday").getAsInt();
            inquiry = mainTopMonitor.get("noAnswr").getAsInt();
            shopnotice = -1;
            confirmorder = -1;
            rs = Jsoup.connect((String)"https://withgs.gsshop.com/cmm/main/listMainContents").userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36").cookies(cookies).header("Content-Type", "application/json").header("Accept", "application/json, text/plain, */*").requestBody("").method(Connection.Method.POST).ignoreContentType(true).timeout(15000).execute();
            obj = this.parser.parse(rs.body()).getAsJsonObject();
            JsonObject mainPrdSaleAndStockCursta = obj.get("mainPrdSaleAndStockCursta").getAsJsonObject();
            saleProduct = mainPrdSaleAndStockCursta.get("saleMidRecnt").getAsInt();
            shopinfo.setNeworder(neworder);
            shopinfo.setShippedbefore(confirmorder);
            shopinfo.setCancellationorder(claim);
            shopinfo.setShopnotice(shopnotice);
            shopinfo.setCustomerqna(inquiry);
            shopinfo.setOnsaleproduct(saleProduct);
            shopinfo.setRegisterproduct(-1);
            shopinfo.setClosesale(-1);
        }
        catch (Exception e) {
            YDMAStringUtil.Print("Home \ud654\uba74\uc5d0\uc11c \uc9c0\uc5d0\uc2a4\uc0f5\uc744 \ubd88\ub7ec\uc624\ub294 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd " + String.valueOf(e));
            shopinfo.setCookies("");
        }
    }
}

