/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.tot;

import com.kdjsystem.mlink.tot.logging.AppLog;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.ptr.IntByReference;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;

public final class WinWindowKiller
implements Runnable {
    private static final AtomicBoolean RUNNING = new AtomicBoolean(false);
    private static Thread thread;
    private static final List<Pattern> MSG;

    static {
        MSG = Arrays.asList(Pattern.compile("no\\s+updates\\s+were\\s+found", 2), Pattern.compile("available\\s+software\\s+sites", 2), Pattern.compile("information", 2), Pattern.compile("\uc815\ubcf4"));
    }

    private WinWindowKiller() {
    }

    public static void start() {
        if (!WinWindowKiller.isWindows()) {
            return;
        }
        if (!RUNNING.compareAndSet(false, true)) {
            return;
        }
        thread = new Thread((Runnable)new WinWindowKiller(), "WinWindowKiller");
        thread.setDaemon(true);
        thread.start();
        AppLog.info("WinWindowKiller: started");
    }

    public static void stop() {
        RUNNING.set(false);
        if (thread != null) {
            thread.interrupt();
        }
        thread = null;
    }

    @Override
    public void run() {
        int myPid = Kernel32.INSTANCE.GetCurrentProcessId();
        User32 user = User32.INSTANCE;
        while (RUNNING.get()) {
            try {
                user.EnumWindows((hWnd, data2) -> {
                    AppLog.info("WinWindowKiller: run start");
                    if (!user.IsWindowVisible(hWnd)) {
                        return true;
                    }
                    IntByReference pidRef = new IntByReference();
                    user.GetWindowThreadProcessId(hWnd, pidRef);
                    AppLog.info("WinWindowKiller: run myPid");
                    AppLog.info("WinWindowKiller: run myPid" + pidRef.getValue() + ":" + myPid);
                    char[] buf = new char[1024];
                    int len = user.GetWindowText(hWnd, buf, buf.length);
                    String title = len > 0 ? new String(buf, 0, len) : "";
                    AppLog.info("WinWindowKiller: run title: " + title);
                    if (WinWindowKiller.matches(title)) {
                        AppLog.info("WinWindowKiller MATCH \u2192 WM_CLOSE, title='" + title + "'");
                        user.PostMessage(hWnd, 16, null, null);
                    }
                    return true;
                }, Pointer.NULL);
                Thread.sleep(600L);
            }
            catch (Throwable t) {
                AppLog.warn("WinWindowKiller loop error: " + String.valueOf(t));
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private static boolean matches(String title) {
        AppLog.info("WinWindowKiller: matches" + title);
        if (title == null) {
            return false;
        }
        String t = title.trim();
        for (Pattern p : MSG) {
            if (!p.matcher(t).find()) continue;
            return true;
        }
        return false;
    }

    private static boolean isWindows() {
        String os = System.getProperty("os.name", "").toLowerCase();
        return os.contains("win");
    }
}

