/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.tot.common;

import com.google.common.io.CharStreams;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.kdjsystem.mlink.tot.common.YDMAProperties;
import com.kdjsystem.mlink.tot.common.YDMASessonUtil;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.aes256util.AES256Util;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;

public class FtpUtil {
    static String host;
    static Integer port;
    static String webPath;
    static String user;
    static String password;
    static String imagepath;
    private static Session session;
    private static Channel channel;
    private static ChannelSftp channelSftp;
    private static FTPClient ftpClient;
    private static List<String> files;
    private static List<String> directories;
    static FtpUtil instance;

    static {
        session = null;
        channel = null;
        channelSftp = null;
        ftpClient = null;
        files = new ArrayList<String>();
        directories = new ArrayList<String>();
    }

    public static FtpUtil getInstance() throws Exception {
        if (instance == null) {
            instance = new FtpUtil();
        }
        return instance;
    }

    public static void connectFtp() throws Exception {
        host = YDMAProperties.getInstance().getAppProperty("ftpezup2.host");
        port = Integer.parseInt(YDMAProperties.getInstance().getAppProperty("ftpezup2.port"));
        user = YDMAProperties.getInstance().getAppProperty("ftpezup2.username");
        AES256Util.getInstance((String)AES256Util.KEY_WORD);
        user = AES256Util.decrypt((String)user);
        password = YDMAProperties.getInstance().getAppProperty("ftpezup2.password");
        AES256Util.getInstance((String)AES256Util.KEY_WORD);
        password = AES256Util.decrypt((String)password);
        webPath = YDMAProperties.getInstance().getAppProperty("ftpezup2.webpath");
        imagepath = YDMAProperties.getInstance().getAppProperty("ftpezup2.imagepath");
        try {
            ftpClient = new FTPClient();
            ftpClient.connect(host, port.intValue());
            FtpUtil.showServerReply(ftpClient);
            int replyCode = ftpClient.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)replyCode)) {
                YDMAStringUtil.Print("Connect failed");
                return;
            }
            boolean success = ftpClient.login(user, password);
            FtpUtil.showServerReply(ftpClient);
            if (!success) {
                YDMAStringUtil.Print("Could not login to the server");
                return;
            }
        }
        catch (IOException ex) {
            YDMAStringUtil.Print("Oops! Something wrong happened");
            ex.printStackTrace();
        }
    }

    private static void showServerReply(FTPClient ftpClient) {
        String[] replies = ftpClient.getReplyStrings();
        if (replies != null && replies.length > 0) {
            String[] stringArray = replies;
            int n = replies.length;
            int n2 = 0;
            while (n2 < n) {
                String aReply = stringArray[n2];
                YDMAStringUtil.Print("SERVER: " + aReply);
                ++n2;
            }
        }
    }

    public static void connect() throws Exception {
        host = YDMAProperties.getInstance().getAppProperty("ftp.host");
        port = Integer.parseInt(YDMAProperties.getInstance().getAppProperty("ftp.port"));
        user = YDMAProperties.getInstance().getAppProperty("ftp.username");
        AES256Util.getInstance((String)AES256Util.KEY_WORD);
        user = AES256Util.decrypt((String)user);
        password = YDMAProperties.getInstance().getAppProperty("ftp.password");
        AES256Util.getInstance((String)AES256Util.KEY_WORD);
        password = AES256Util.decrypt((String)password);
        JSch jsch = new JSch();
        session = jsch.getSession(user, host, port.intValue());
        session.setConfig("StrictHostKeyChecking", "no");
        session.setPassword(password);
        session.connect();
        channel = session.openChannel("sftp");
        channel.connect();
        channelSftp = (ChannelSftp)channel;
    }

    public static void connect2(String host) throws Exception {
        port = Integer.parseInt(YDMAProperties.getInstance().getAppProperty("ftp.port"));
        user = YDMAProperties.getInstance().getAppProperty("ftp.username");
        AES256Util.getInstance((String)AES256Util.KEY_WORD);
        user = AES256Util.decrypt((String)user);
        password = YDMAProperties.getInstance().getAppProperty("ftp.password");
        AES256Util.getInstance((String)AES256Util.KEY_WORD);
        password = AES256Util.decrypt((String)password);
        JSch jsch = new JSch();
        session = jsch.getSession(user, host, port.intValue());
        session.setConfig("StrictHostKeyChecking", "no");
        session.setPassword(password);
        session.connect();
        channel = session.openChannel("sftp");
        channel.connect();
        channelSftp = (ChannelSftp)channel;
    }

    public static void disconnect() {
        if (session != null && session.isConnected()) {
            channelSftp.quit();
            channel.disconnect();
            session.disconnect();
        }
    }

    public static void disconnectFtp() throws Exception {
        ftpClient.logout();
        ftpClient.disconnect();
    }

    public static void uploadXmlFileToWeb(char type) throws Exception {
        String remoteDir = "";
        remoteDir = YDMAProperties.getInstance().getAppProperty("ftp.webpath");
        String templatePath = null;
        String templateFile = null;
        if (type == 'O') {
            templatePath = YDMASessonUtil.getAppPath(YDMAProperties.getInstance().getAppProperty("sabang.orderTemplatePath"));
            templateFile = YDMAProperties.getInstance().getAppProperty("sabang.orderTempateFile");
        } else if (type == 'P') {
            templatePath = YDMASessonUtil.getAppPath(YDMAProperties.getInstance().getAppProperty("sabang.productTemplatePath"));
            templateFile = YDMAProperties.getInstance().getAppProperty("sabang.productTempateFile");
        } else if (type == 'C') {
            templatePath = YDMASessonUtil.getAppPath(YDMAProperties.getInstance().getAppProperty("sabang.claimTemplatePath"));
            templateFile = YDMAProperties.getInstance().getAppProperty("sabang.claimTempateFile");
        } else if (type == 'Q') {
            templatePath = YDMASessonUtil.getAppPath(YDMAProperties.getInstance().getAppProperty("sabang.questionTemplatePath"));
            templateFile = YDMAProperties.getInstance().getAppProperty("sabang.questionTempateFile");
        } else if (type == 'S') {
            templatePath = YDMASessonUtil.getAppPath(YDMAProperties.getInstance().getAppProperty("sabang.pickupExpressSabangNetTemplatePath"));
            templateFile = YDMAProperties.getInstance().getAppProperty("sabang.pickupExpressSabangNetTempateFile");
        }
        String templateFullpath = templatePath + File.separator + templateFile;
        FtpUtil.upload(remoteDir, templateFullpath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deletefile(String remoteDir, String fileName) throws Exception {
        Class<FtpUtil> clazz = FtpUtil.class;
        synchronized (FtpUtil.class) {
            FtpUtil.deleteSFtp(remoteDir, fileName);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteFtp(String remoteDir, String fileName, String host) throws Exception {
        Class<FtpUtil> clazz = FtpUtil.class;
        synchronized (FtpUtil.class) {
            block8: {
                FtpUtil.connect2(host);
                try {
                    try {
                        channelSftp.cd(remoteDir);
                        channelSftp.rm(fileName);
                    }
                    catch (SftpException e) {
                        e.printStackTrace();
                        FtpUtil.disconnect();
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    FtpUtil.disconnect();
                    throw throwable;
                }
                FtpUtil.disconnect();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteSFtp(String remoteDir, String fileName) throws Exception {
        Class<FtpUtil> clazz = FtpUtil.class;
        synchronized (FtpUtil.class) {
            block8: {
                FtpUtil.connect();
                try {
                    try {
                        channelSftp.cd(remoteDir);
                        channelSftp.rm(fileName);
                    }
                    catch (SftpException e) {
                        e.printStackTrace();
                        FtpUtil.disconnect();
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    FtpUtil.disconnect();
                    throw throwable;
                }
                FtpUtil.disconnect();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static boolean isExistsDirSftp(String pathName) {
        boolean success = true;
        try {
            channelSftp.stat(pathName);
        }
        catch (Exception exception) {
            success = false;
            YDMAStringUtil.Print(pathName + " not found");
        }
        return success;
    }

    public static boolean isExistsDir(String pathName) {
        boolean success = true;
        try {
            success = ftpClient.cwd(pathName) == 550 ? false : ftpClient.cwd(pathName) == 250;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String uploadnCreateDir(String remoteDir, String localfileName, String tartgetfileName) throws Exception {
        String templatefilename = "";
        Class<FtpUtil> clazz = FtpUtil.class;
        synchronized (FtpUtil.class) {
            templatefilename = FtpUtil.uploadSFtpSourcToTarget(remoteDir, localfileName, tartgetfileName);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return templatefilename;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String uploadnCreateDir(String remoteDir, String localfileName, String tartgetfileName, String host) throws Exception {
        String templatefilename = "";
        Class<FtpUtil> clazz = FtpUtil.class;
        synchronized (FtpUtil.class) {
            templatefilename = FtpUtil.uploadSFtpSourcToTarget2(remoteDir, localfileName, tartgetfileName, host);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return templatefilename;
        }
    }

    public static String uploadSFtpSourcToTarget(String remoteDir, String localfileName, String tartgetfileName) throws Exception {
        FileInputStream fis = null;
        FtpUtil.connect();
        try {
            if (!FtpUtil.isExistsDirSftp(remoteDir)) {
                channelSftp.mkdir(remoteDir);
            }
            channelSftp.cd(remoteDir);
            File file = new File(localfileName);
            fis = new FileInputStream(file);
            channelSftp.put((InputStream)fis, tartgetfileName);
            YDMAStringUtil.Print("File uploaded successfully - " + file.getAbsolutePath());
        }
        catch (Throwable throwable) {}
        FtpUtil.disconnect();
        return tartgetfileName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String uploadSFtpSourcToTarget2(String remoteDir, String localfileName, String tartgetfileName, String host) throws Exception {
        String string;
        block12: {
            FileInputStream fis = null;
            FtpUtil.connect2(host);
            try {
                String rootDir = channelSftp.pwd();
                Object uploadDir = "/xmldir".equals(rootDir) ? remoteDir : "xmldir/" + remoteDir;
                String[] dirs = ((String)uploadDir).split("/");
                String pathSoFar = "";
                String[] stringArray = dirs;
                int n = dirs.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        channelSftp.cd((String)uploadDir);
                        File file = new File(localfileName);
                        fis = new FileInputStream(file);
                        channelSftp.put((InputStream)fis, tartgetfileName);
                        YDMAStringUtil.Print("File uploaded successfully - " + file.getAbsolutePath());
                        string = tartgetfileName;
                        if (fis == null) break block12;
                        break;
                    }
                    String dir = stringArray[n2];
                    String string2 = pathSoFar = pathSoFar.isEmpty() ? dir : pathSoFar + "/" + dir;
                    if (!FtpUtil.isExistsDirSftp(pathSoFar)) {
                        channelSftp.mkdir(pathSoFar);
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                try {
                    throw e;
                }
                catch (Throwable throwable) {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException iOException) {}
                    }
                    FtpUtil.disconnect();
                    throw throwable;
                }
            }
            try {
                fis.close();
            }
            catch (IOException iOException) {}
        }
        FtpUtil.disconnect();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String upload(String remoteDir, String fileName) throws Exception {
        String templatefilename = "";
        Class<FtpUtil> clazz = FtpUtil.class;
        synchronized (FtpUtil.class) {
            templatefilename = FtpUtil.uploadSFtp(remoteDir, fileName);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return templatefilename;
        }
    }

    public static String[] downSFtpFileWithSplit(String remoteDir, String fileName) throws Exception {
        String[] file = null;
        FtpUtil.connect();
        try {
            channelSftp.cd(remoteDir);
            InputStream iStream = channelSftp.get(fileName);
            Throwable throwable = null;
            Object var5_7 = null;
            try (InputStreamReader reader = new InputStreamReader(iStream, StandardCharsets.UTF_8);){
                file = CharStreams.toString((Readable)reader).split(";");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            YDMAStringUtil.Print("File downloaded successfully - " + String.valueOf(file));
        }
        finally {
            FtpUtil.disconnect();
        }
        return file;
    }

    public static String[] downSFtpFileWithSplitPlus(String remoteDir, String fileName) throws Exception {
        String[] file = null;
        FtpUtil.connect();
        try {
            channelSftp.cd(remoteDir);
            InputStream iStream = channelSftp.get(fileName);
            Throwable throwable = null;
            Object var5_7 = null;
            try (InputStreamReader reader = new InputStreamReader(iStream, StandardCharsets.UTF_8);){
                file = CharStreams.toString((Readable)reader).split(";;");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            YDMAStringUtil.Print("File downloaded successfully - " + String.valueOf(file));
        }
        finally {
            FtpUtil.disconnect();
        }
        return file;
    }

    private static boolean getFileList(FTPClient client, String cw, List<String> files, List<String> directories) throws IOException {
        if (client.changeWorkingDirectory(cw)) {
            FTPFile[] fTPFileArray = client.listFiles();
            int n = fTPFileArray.length;
            int n2 = 0;
            while (n2 < n) {
                FTPFile file = fTPFileArray[n2];
                if (file.isFile()) {
                    files.add(cw + file.getName());
                } else {
                    if (!FtpUtil.getFileList(client, cw + file.getName() + File.separator, files, directories)) {
                        return false;
                    }
                    directories.add(cw + file.getName() + File.separator);
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    public static String uploadSFtp(String remoteDir, String fileName) throws Exception {
        FileInputStream fis = null;
        String templatefilename = "";
        FtpUtil.connect();
        try {
            channelSftp.cd(remoteDir);
            File file = new File(fileName);
            templatefilename = file.getName();
            fis = new FileInputStream(file);
            channelSftp.put((InputStream)fis, file.getName());
            YDMAStringUtil.Print("File uploaded successfully - " + file.getAbsolutePath());
        }
        catch (Throwable throwable) {}
        if (fis != null) {
            fis.close();
        }
        FtpUtil.disconnect();
        return templatefilename;
    }

    public static int uploadImage(String prodcd, String sourimage, int imgnum, List<String> comlist) throws Exception {
        FileInputStream fis = null;
        int result = 0;
        String tagimage = prodcd + "0" + Integer.toString(imgnum) + ".jpg";
        FtpUtil.connect();
        try {
            try {
                channelSftp.cd(imagepath + comlist.get(1));
                File file = new File(sourimage);
                fis = new FileInputStream(file);
                channelSftp.put((InputStream)fis, tagimage);
            }
            catch (Exception e) {
                e.getMessage();
                result = 0;
                result = 1;
            }
        }
        finally {
            result = 1;
        }
        return result;
    }

    public static void uploadLocalImage(String prodcd, String mainimg, int imgnum, List<String> comlist) {
        try {
            FileInputStream fis = null;
            String imagename = mainimg;
            String SRC_FILE = "";
            BufferedImage img = null;
            URL url = null;
            Image resizeImage = null;
            BufferedImage newImage = null;
            Graphics g = null;
            SRC_FILE = "tmp1";
            try {
                if (imagename.contains("http")) {
                    url = new URL(imagename);
                    img = ImageIO.read(url);
                } else {
                    img = ImageIO.read(new File(imagename));
                }
                resizeImage = img.getScaledInstance(90, 85, 4);
                newImage = new BufferedImage(90, 85, 1);
                g = newImage.getGraphics();
                g.drawImage(resizeImage, 0, 0, null);
                g.dispose();
                ImageIO.write((RenderedImage)newImage, "jpg", new File(SRC_FILE));
                String tagimage = prodcd + ".jpg";
                FtpUtil.connect();
                channelSftp.cd(imagepath + comlist.get(1) + "/thumb2/");
                File file = new File(SRC_FILE);
                fis = new FileInputStream(file);
                channelSftp.put((InputStream)fis, tagimage);
                if (imagename.contains("http")) {
                    url = new URL(imagename);
                    img = ImageIO.read(url);
                } else {
                    img = ImageIO.read(new File(imagename));
                }
                resizeImage = img.getScaledInstance(25, 25, 4);
                newImage = new BufferedImage(25, 25, 1);
                g = newImage.getGraphics();
                g.drawImage(resizeImage, 0, 0, null);
                g.dispose();
                ImageIO.write((RenderedImage)newImage, "jpg", new File(SRC_FILE));
                FtpUtil.connect();
                channelSftp.cd(imagepath + comlist.get(1) + "/thumb1/");
                file = new File(SRC_FILE);
                fis = new FileInputStream(file);
                channelSftp.put((InputStream)fis, tagimage);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            YDMAStringUtil.Print("\uc378\ub124\uc77c \uc0dd\uc131\uc644\ub8cc2");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

