/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.alwayz;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.data.alwayz.AlwayzAccessToken;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class AlwayzExitsProductCd {
    static AlwayzExitsProductCd instance = new AlwayzExitsProductCd();

    public static AlwayzExitsProductCd get() {
        return instance;
    }

    public String getIsExistProdNo(String company_goods_cd, String loginID, String password, String shopcd) {
        String token;
        block14: {
            try {
                token = AlwayzAccessToken.get().getAccessToken(loginID, password);
                if (token != null && !token.isEmpty()) break block14;
                return "ERROR: Token \ubc1c\uae09 \uc2e4\ud328";
            }
            catch (Exception e) {
                e.printStackTrace();
                return "ERROR: " + e.getMessage();
            }
        }
        String requestJson = this.buildSearchRequestJson(company_goods_cd);
        Request request2 = this.buildPostRequest(token, requestJson);
        Throwable throwable = null;
        Object var9_11 = null;
        try (Response response = AlwayzAccessToken.getOkhttpClient().newCall(request2).execute();){
            if (response.isSuccessful() && response.body() != null) {
                return this.parseProductIdFromResponse(response.body().string());
            }
            return "ERROR: \uc751\ub2f5 \uc2e4\ud328 - HTTP " + response.code();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private String buildSearchRequestJson(String companyGoodsCd) throws JsonProcessingException {
        Info info = new Info();
        info.condition.type = "item";
        info.condition.itemCondition.code = companyGoodsCd;
        info.condition.itemSortCondition.createdAt = -1;
        info.page = 1;
        info.pageLimit = 20;
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString((Object)info);
    }

    private Request buildPostRequest(String token, String json) {
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.get((String)"application/json; charset=utf-8"), (String)json);
        return new Request.Builder().url("https://alwayz-seller-back.ilevit.com/sellers/items/v2/list-request").header("Connection", "keep-alive").header("x-access-token", token).header("Content-Type", "application/json").header("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36").post(requestBody).build();
    }

    private String parseProductIdFromResponse(String responseBody) {
        JsonParser jsonParser = new JsonParser();
        JsonObject jsonObject = jsonParser.parse(responseBody).getAsJsonObject();
        int status2 = jsonObject.get("status").getAsInt();
        if (status2 == 2000) {
            JsonObject data2 = jsonObject.getAsJsonObject("data");
            JsonArray itemsInfo = data2.getAsJsonArray("itemsInfo");
            if (itemsInfo == null || itemsInfo.size() == 0) {
                return "";
            }
            JsonObject firstItem = itemsInfo.get(0).getAsJsonObject();
            return firstItem.get("_id").getAsString();
        }
        return "";
    }

    private class Info {
        @JsonProperty(value="condition")
        private Condition condition = new Condition();
        @JsonProperty(value="page")
        private int page;
        @JsonProperty(value="pageLimit")
        private int pageLimit;

        private class Condition {
            @JsonProperty(value="type")
            private String type;
            @JsonProperty(value="itemCondition")
            private ItemCondition itemCondition;
            @JsonProperty(value="itemSortCondition")
            private ItemSortCondition itemSortCondition;

            private Condition() {
                this.itemCondition = new ItemCondition();
                this.itemSortCondition = new ItemSortCondition();
            }
        }

        private class ItemCondition {
            @JsonProperty(value="recommendItemCode")
            private String code;

            private ItemCondition() {
            }
        }

        private class ItemSortCondition {
            @JsonProperty(value="createdAt")
            private int createdAt;

            private ItemSortCondition() {
            }
        }
    }
}

