/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.kakaostore;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.ImageUpload.ImageTransformParams;
import com.kdjsystem.mlink.shop.ImageUpload.UnifiedUploadManager;
import com.kdjsystem.mlink.shop.common.IProduct;
import com.kdjsystem.mlink.shop.common.IProductModifyStatusApi;
import com.kdjsystem.mlink.shop.common.ResultMarketPrice;
import com.kdjsystem.mlink.shop.common.ShopCommon;
import com.kdjsystem.mlink.shop.dao.RegResultDTO;
import com.kdjsystem.mlink.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.shop.dao.ShopKakaoStoreAdditionalDto;
import com.kdjsystem.mlink.shop.dao.ShopOptionDto;
import com.kdjsystem.mlink.shop.dao.ShopPreferencesDto;
import com.kdjsystem.mlink.shop.dao.ShopProdAttrnmDto;
import com.kdjsystem.mlink.shop.dao.ShopProductAdditionDto;
import com.kdjsystem.mlink.shop.dao.ShopProductDao;
import com.kdjsystem.mlink.shop.dao.ShopProductDto;
import com.kdjsystem.mlink.shop.dao.ShopProductSendDto;
import com.kdjsystem.mlink.shop.dao.ShopWorkDao;
import com.kdjsystem.mlink.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.shop.data.kakaostore.KakaoStoreProductDto;
import com.kdjsystem.mlink.shop.data.kakaostore.ShopKakaoStoreUtil;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBException;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class KakaoStoreProductModifyService
extends IProductModifyStatusApi {
    private static final String Host = "https://kapi.kakao.com";
    List<ShopOptionDto> options;

    private String setProductReg(ShopProductDto dto, ShopKakaoStoreAdditionalDto dtllist, ShoppingMallDetailDto shoppingMallDetailDto, List<String> strImages) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        String json = "";
        try {
            KakaoStoreProductDto.ProdRequest.ProductRequest productRequest = new KakaoStoreProductDto.ProdRequest.ProductRequest();
            this.setProductName(dto, dtllist, productRequest);
            this.setCategory(dto, productRequest, shoppingMallDetailDto, dtllist);
            this.setCert(dto, productRequest);
            this.setModel(dto, shoppingMallDetailDto, dtllist, productRequest);
            this.setDelivery(dto, dtllist, productRequest);
            this.setDiscount(dtllist, productRequest);
            this.setShareDiscount(dtllist, productRequest);
            this.setGroupDiscount(dtllist, productRequest);
            this.setMaxNMinsetting(dtllist, productRequest);
            this.setMinorPurchasable(dto, dtllist, productRequest);
            ResultMarketPrice resultMarketPrice = new ResultMarketPrice();
            resultMarketPrice = this.setSaleCost(dto, dtllist, resultMarketPrice, productRequest);
            this.setOption(dto, dtllist, resultMarketPrice, productRequest);
            this.setImageRemark(dto, dtllist, shoppingMallDetailDto, strImages, productRequest);
            this.setOrigin(dto, dtllist, productRequest);
            this.setNotice(dto, dtllist, productRequest);
            productRequest.productId = dto.getShopprodno();
            productRequest.storeManagementCode = dto.getCompayny_goods_cd();
            productRequest.taxType = dtllist.getTax();
            productRequest.displayStatus = dtllist.getDisplaystatus();
            productRequest.productCondition = dtllist.getProdcondition();
            productRequest.plusFriendSubscriberExclusive = dtllist.getPlusfriend().equals("true");
            productRequest.shoppingHowDisplayable = dtllist.getShophowdisplayable().equals("true");
            productRequest.useSalePeriod = dtllist.getSaleperiod().equals("Y");
            if (dtllist.getSaleperiod().equals("Y")) {
                KakaoStoreProductDto.ProdRequest.ProductRequest.Period salePeriod = new KakaoStoreProductDto.ProdRequest.ProductRequest.Period();
                salePeriod.from = YDMATimeUtil.getCurrentTime();
                salePeriod.to = YDMATimeUtil.getSaleEndDt(dtllist.getSalefrom()).replaceAll("-", "").concat("235959");
                productRequest.salePeriod = salePeriod;
            }
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            json = mapper.writeValueAsString((Object)productRequest);
            YDMAStringUtil.Print(json);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        return json;
    }

    private void setProductName(ShopProductDto dto, ShopKakaoStoreAdditionalDto dtllist, KakaoStoreProductDto.ProdRequest.ProductRequest productRequest) throws Exception {
        String value = "";
        try {
            value = IProduct.formatProductNameByCode(dtllist.getProdnmoutput(), dto);
            if (!dtllist.getProdnmaddfront().equals("")) {
                value = dtllist.getProdnmaddfront().concat(value);
            }
            if (!dtllist.getProdnmaddback().equals("")) {
                value = value.concat(" ").concat(dtllist.getProdnmaddback());
            }
            if (dtllist.getProdnmafter().equals("Y")) {
                value = ShopCommon.setAddKeywordInProdName(value, dto.getGoods_search(), "L", 69);
            }
            if (dtllist.getProdnmrand().equals("Y")) {
                value = ShopCommon.setWordRandomGenerator(value);
            }
            if (dtllist.getProdnmedit().equals("Y")) {
                value = value.replaceAll("[@|#|$|^|{|}|\u00a7|\u203b|\u2606|\u2605|\u266a|\u321c|\u2122|;|\uff06|-|\uff0a|:|`|<|>|\u2191|\u2192|\u2193|\u00b7|\u2103|\u339d|\u3396|\u2665|\u2661|&]", "");
            }
            if (dto.getProdnmlenyn().equals("Y") && value.length() > 138) {
                value = value.substring(0, 130);
            }
            productRequest.name = value;
        }
        catch (Exception exception) {
            throw new Exception("\uc0c1\ud488\uba85\uc744 \uc785\ub825\ud558\ub294 \ub3c4\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setCategory(ShopProductDto dto, KakaoStoreProductDto.ProdRequest.ProductRequest productRequest, ShoppingMallDetailDto shoppingMallDetailDto, ShopKakaoStoreAdditionalDto dtllist) throws Exception {
        String cateNum = "";
        try {
            if (dtllist.getIsCategory().equals("1")) {
                cateNum = dtllist.getShopcatno();
            } else {
                if (dto.getShopCid() == null || dto.getShopCid().equals("")) {
                    throw new Exception("\ud574\ub2f9\uc0c1\ud488\uc758 \uce74\ud14c\uace0\ub9ac \ucf54\ub4dc\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.");
                }
                cateNum = dto.getShopCid();
            }
            productRequest.categoryId = cateNum;
        }
        catch (Exception exception) {
            throw new Exception("\uce74\ud14c\uace0\ub9ac\ub97c \uc785\ub825\ud558\ub294 \ub3c4\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setCert(ShopProductDto dto, KakaoStoreProductDto.ProdRequest.ProductRequest productRequest) throws Exception {
        try {
            KakaoStoreProductDto.ProdRequest.ProductRequest.Cert cert;
            ArrayList<KakaoStoreProductDto.ProdRequest.ProductRequest.Cert> certs = new ArrayList<KakaoStoreProductDto.ProdRequest.ProductRequest.Cert>();
            String certTypeVal = dto.getCert_type();
            String certVal = dto.getCert() != null ? dto.getCert().trim() : "";
            String certTypeCode = dto.getCertno() != null ? dto.getCertno().trim() : "";
            List<Object> result = new ArrayList<String>();
            switch (certTypeVal) {
                case "0": {
                    result.add("NOT_APPLICABLE");
                    break;
                }
                case "1": {
                    if (!certVal.isEmpty()) {
                        result = this.setCertTypeAndCertCode(certVal, certTypeCode);
                        break;
                    }
                    throw new Exception("\uc778\uc99d\uc815\ubcf4\uac00 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
                }
                case "2": {
                    result.add("DETAIL_REF");
                    break;
                }
                default: {
                    throw new Exception("\uc778\uc99d\ud0c0\uc785\uc774 \uc720\ud6a8\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
                }
            }
            if (!result.isEmpty() && result.get(0) != null) {
                cert = new KakaoStoreProductDto.ProdRequest.ProductRequest.Cert();
                cert.certType = (String)result.get(0);
                if (result.size() > 1 && !((String)result.get(1)).isEmpty()) {
                    cert.certCode = (String)result.get(1);
                }
            } else {
                throw new Exception("\uc778\uc99d\uc815\ubcf4 \uc785\ub825 \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
            }
            certs.add(cert);
            productRequest.certs = certs;
        }
        catch (Exception e) {
            throw new Exception("\ub370\uc774\ud130\uc785\ub825\uc2e4\ud328 : \uc778\uc99d\uc815\ubcf4 \uc785\ub825 \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4. " + e.getMessage());
        }
    }

    private List<String> setCertTypeAndCertCode(String certVal, String certTypeCode) {
        ArrayList<String> result = new ArrayList<String>();
        String requestedCertType = "";
        String requestedCertCode = "";
        switch (certVal) {
            case "2": {
                requestedCertType = "KC_1";
                requestedCertCode = certTypeCode;
                break;
            }
            case "3": {
                requestedCertType = "KC_5";
                requestedCertCode = certTypeCode;
                break;
            }
            case "4": {
                requestedCertType = "KC_2";
                requestedCertCode = certTypeCode;
                break;
            }
            case "5": {
                requestedCertType = "KC_6";
                requestedCertCode = certTypeCode;
                break;
            }
            case "7": {
                requestedCertType = "FOOD_3";
                requestedCertCode = certTypeCode;
                break;
            }
            case "8": {
                requestedCertType = "FOOD_1";
                requestedCertCode = certTypeCode;
                break;
            }
            case "11": {
                requestedCertType = "FOOD_2";
                requestedCertCode = certTypeCode;
                break;
            }
            case "25": {
                requestedCertType = "FOOD_14";
                requestedCertCode = certTypeCode;
                break;
            }
            case "32": {
                requestedCertType = "KC_3";
                requestedCertCode = certTypeCode;
                break;
            }
            case "34": {
                requestedCertType = "KC_4";
                break;
            }
            case "35": {
                requestedCertType = "KC_7";
                break;
            }
            case "40": {
                requestedCertType = "KC_8";
                requestedCertCode = certTypeCode;
                break;
            }
            case "41": {
                requestedCertType = "KC_9";
                requestedCertCode = certTypeCode;
                break;
            }
            case "42": {
                requestedCertType = "KC_10";
                break;
            }
            case "44": {
                requestedCertType = "ECOLIFE_1";
                requestedCertCode = certTypeCode;
                break;
            }
            case "45": {
                requestedCertType = "ECOLIFE_1";
                requestedCertCode = certTypeCode;
                break;
            }
        }
        result.add(requestedCertType);
        result.add(requestedCertCode);
        return result;
    }

    private void setModel(ShopProductDto dto, ShoppingMallDetailDto shoppingMallDetailDto, ShopKakaoStoreAdditionalDto dtllist, KakaoStoreProductDto.ProdRequest.ProductRequest productRequest) throws Exception {
        BiFunction<String, String, String> firstNonBlank2 = (a, b) -> a != null ? a : b;
        try {
            String dtoModel = ShopKakaoStoreUtil.sanitize(dto.getModel_nm());
            String addModel = ShopKakaoStoreUtil.sanitize(dtllist.getModel());
            productRequest.modelId = addModel == null ? this.getModelSearch(dtoModel, shoppingMallDetailDto.getApikey()) : addModel;
            if (productRequest.modelId.isEmpty()) {
                String dtoMaker = ShopKakaoStoreUtil.sanitize(dto.getMaker());
                String dtoBrand = ShopKakaoStoreUtil.sanitize(dto.getBrand_nm());
                String addMaker = ShopKakaoStoreUtil.sanitize(dtllist.getManufacturer());
                String addBrand = ShopKakaoStoreUtil.sanitize(dtllist.getBrand());
                String manufacturer = firstNonBlank2.apply(dtoMaker, addMaker);
                String brand = firstNonBlank2.apply(dtoBrand, addBrand);
                productRequest.manufacturer = manufacturer != null ? manufacturer : "";
                productRequest.brand = brand != null ? brand : "";
            }
        }
        catch (RuntimeException e) {
            throw new Exception("\ub370\uc774\ud130\uc785\ub825\uc2e4\ud328 : \ubaa8\ub378,\ube0c\ub79c\ub4dc,\uc81c\uc870\uc0ac\ub97c \uc785\ub825\ud558\ub294 \ub3c4\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.", e);
        }
    }

    private String getModelSearch(String model, String apiKey) {
        if (model == null) {
            return "";
        }
        String modelId = "";
        try {
            Connection.Response response = Jsoup.connect((String)("https://kapi.kakao.com/v1/store/search?model=" + model)).header("Host", "kapi.kakao.com").header("Authorization", "KakaoAK b99a474fd6fe27f966e76e37591f0053").header("Target-Authorization", "KakaoAK " + apiKey).header("channel-ids", "101").method(Connection.Method.GET).ignoreContentType(true).followRedirects(true).ignoreHttpErrors(true).execute();
            JsonObject resultObject = (JsonObject)jsonParser.parse(response.body());
            JsonArray contents = (JsonArray)resultObject.get("contents");
            if (contents.size() > 0) {
                Iterator iterator = contents.iterator();
                if (iterator.hasNext()) {
                    JsonElement ele = (JsonElement)iterator.next();
                    JsonObject content = ele.getAsJsonObject();
                    modelId = content.get("modelId").getAsString();
                }
                return modelId;
            }
            return modelId;
        }
        catch (Exception exception) {
            return modelId;
        }
    }

    private void setDelivery(ShopProductDto dto, ShopKakaoStoreAdditionalDto dtllist, KakaoStoreProductDto.ProdRequest.ProductRequest productRequest) throws Exception {
        try {
            KakaoStoreProductDto.ProdRequest.ProductRequest.Delivery delivery;
            block50: {
                block48: {
                    delivery = new KakaoStoreProductDto.ProdRequest.ProductRequest.Delivery();
                    delivery.deliveryMethodType = dtllist.getDelivery();
                    delivery.bundleGroupAvailable = dtllist.getBundlegroup().equals("true");
                    if (!dtllist.getDeliverytype().equals("Y")) break block48;
                    switch (dto.getDelv_type()) {
                        case "0": {
                            delivery.deliveryFeeType = "PAID";
                            delivery.baseFee = new BigDecimal(dto.getDelv_cost());
                            delivery.deliveryFeePaymentType = "PREPAID";
                            break;
                        }
                        case "1": {
                            delivery.deliveryFeeType = "FREE";
                            delivery.baseFee = new BigDecimal(0);
                            delivery.deliveryFeePaymentType = "PREPAID";
                            break;
                        }
                        case "3": {
                            delivery.deliveryFeeType = "QUANTITY_PAID";
                            delivery.baseFee = new BigDecimal(dto.getDelv_cost());
                            delivery.bundleGroupAvailable = false;
                            delivery.repeatQuantity = new Integer(dto.getDelivery_qty());
                            delivery.deliveryFeePaymentType = "PREPAID";
                            break;
                        }
                        case "": {
                            int delvCost = Integer.parseInt(dto.getDelv_cost());
                            if (delvCost == 0) {
                                delivery.deliveryFeeType = "FREE";
                                delivery.baseFee = new BigDecimal(0);
                                delivery.deliveryFeePaymentType = "PREPAID";
                                dto.setDelv_type("1");
                                break;
                            }
                            if (delvCost > 10) {
                                delivery.deliveryFeeType = "PAID";
                                delivery.baseFee = new BigDecimal(dto.getDelv_cost());
                                delivery.deliveryFeePaymentType = "PREPAID";
                                dto.setDelv_type("0");
                                break;
                            }
                            throw new Exception("\uc0c1\ud488\uc815\ubcf4\uc758 \ubc30\uc1a1\ube44\uac00 10\uc6d0 \uc774\ud558\uc785\ub2c8\ub2e4. \ubc30\uc1a1\ube44\ub97c 10\uc6d0 \uc774\uc0c1 \uc785\ub825\ud558\uc138\uc694.");
                        }
                        default: {
                            delivery.deliveryFeeType = "PAID";
                            delivery.baseFee = new BigDecimal(dto.getDelv_cost());
                            delivery.deliveryFeePaymentType = "COLLECT";
                            break;
                        }
                    }
                    break block50;
                }
                String deliveryFee = "";
                delivery.deliveryFeeType = dtllist.getDeliveryfeetype();
                delivery.deliveryFeePaymentType = dtllist.getDeliverypaymenttype();
                switch (dtllist.getDeliveryfeetype()) {
                    case "FREE": {
                        delivery.baseFee = new BigDecimal(0);
                        break;
                    }
                    case "PAID": {
                        if (dtllist.getBasefee().equals("9999")) {
                            if (!dto.getDelv_cost().equals("0")) {
                                deliveryFee = dto.getDelv_cost();
                            } else {
                                ShopPreferencesDto systemconf = ShopCommonDao.get().getSystemConf();
                                deliveryFee = systemconf.getDeliverycost();
                            }
                        } else {
                            deliveryFee = dtllist.getBasefee();
                        }
                        delivery.baseFee = new BigDecimal(deliveryFee);
                        break;
                    }
                    case "CONDITIONAL_FREE": {
                        if (dtllist.getBasefee().equals("9999")) {
                            if (!dto.getDelv_cost().equals("0")) {
                                deliveryFee = dto.getDelv_cost();
                            } else {
                                ShopPreferencesDto systemconf = ShopCommonDao.get().getSystemConf();
                                deliveryFee = systemconf.getDeliverycost();
                            }
                        } else {
                            deliveryFee = dtllist.getBasefee();
                        }
                        delivery.baseFee = new BigDecimal(deliveryFee);
                        delivery.freeConditionalAmount = new BigDecimal(dtllist.getAddbasefee());
                        break;
                    }
                    case "QUANTITY_PAID": {
                        delivery.bundleGroupAvailable = false;
                        delivery.baseFee = new BigDecimal(dtllist.getBasefee());
                        delivery.repeatQuantity = new Integer(dtllist.getAddbasefee());
                    }
                }
            }
            delivery.returnDeliveryFee = new BigDecimal(dtllist.getReturndeliveryfee());
            delivery.exchangeDeliveryFee = new BigDecimal(dtllist.getExchangedeliveryfee());
            delivery.shippingAddressId = new Long(dtllist.getShippingaddrid());
            delivery.returnAddressId = new Long(dtllist.getReturnaddrid());
            delivery.asPhoneNumber = dtllist.getAsphonenumber();
            delivery.asGuideWords = dtllist.getAsguidewords();
            delivery.usePickUpDelivery = false;
            delivery.useQuickDelivery = false;
            delivery.useIsolatedAreaNotice = dtllist.getUseisolatedarea().equals("true");
            if (dtllist.getUseisolatedarea().equals("true")) {
                delivery.isolatedAreaNotice = dtllist.getIsolateareanotice();
            }
            if (dtllist.getJjmt_delv_yn().equals("Y")) {
                delivery.availableIsolatedArea = true;
                if (dtllist.getJejuMountYn().equals("Y")) {
                    delivery.useIsolatedAreaFee = true;
                    delivery.jejuAreaAdditionalFee = new BigDecimal(dtllist.getJejuDeliveryFee().equals("") ? "0" : dtllist.getJejuDeliveryFee());
                    delivery.isolatedAreaAdditionalFee = new BigDecimal(dtllist.getMountDeliveryFee().equals("") ? "0" : dtllist.getMountDeliveryFee());
                }
            } else {
                delivery.availableIsolatedArea = false;
            }
            productRequest.delivery = delivery;
        }
        catch (Exception exception) {
            throw new Exception("\ubc30\uc1a1\uc815\ubcf4\ub97c \uc785\ub825\ud558\ub294 \ub3c4\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setDiscount(ShopKakaoStoreAdditionalDto dtllist, KakaoStoreProductDto.ProdRequest.ProductRequest productRequest) throws Exception {
        try {
            KakaoStoreProductDto.ProdRequest.ProductRequest.Discount discount = new KakaoStoreProductDto.ProdRequest.ProductRequest.Discount();
            discount.useDiscount = dtllist.getDiscount().equals("true");
            discount.useDiscountPeriod = dtllist.getDiscountperiod().equals("true");
            if (dtllist.getDiscount().equals("true")) {
                discount.type = dtllist.getDiscounttype();
                discount.value = new Integer(dtllist.getDiscountval().equals("") ? null : dtllist.getDiscountval());
                if (dtllist.getDiscountperiod().equals("true")) {
                    KakaoStoreProductDto.ProdRequest.ProductRequest.Discount.Period discountPeriod = new KakaoStoreProductDto.ProdRequest.ProductRequest.Discount.Period();
                    discountPeriod.from = YDMATimeUtil.getCurrentTime();
                    discountPeriod.to = YDMATimeUtil.getSaleEndDt(dtllist.getDiscountfrom()).replaceAll("-", "").concat("235959");
                    discount.discountPeriod = discountPeriod;
                }
            }
            productRequest.discount = discount;
        }
        catch (Exception exception) {
            throw new Exception("\uc989\uc2dc\ud560\uc778\uc815\ubcf4\ub97c \uc785\ub825\ud558\ub294 \ub3c4\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setShareDiscount(ShopKakaoStoreAdditionalDto dtllist, KakaoStoreProductDto.ProdRequest.ProductRequest productRequest) throws Exception {
        try {
            KakaoStoreProductDto.ProdRequest.ProductRequest.ShareDiscountRequest shareDiscount = new KakaoStoreProductDto.ProdRequest.ProductRequest.ShareDiscountRequest();
            shareDiscount.useShareDiscount = dtllist.getSharediscount().equals("true");
            if (dtllist.getSharediscount().equals("true")) {
                shareDiscount.value = new Long(dtllist.getSharediscountval());
                shareDiscount.slotCount = new Integer(dtllist.getSharedslotcnt());
                shareDiscount.useSalePeriod = true;
                KakaoStoreProductDto.ProdRequest.ProductRequest.ShareDiscountRequest.Period discountPeriod = new KakaoStoreProductDto.ProdRequest.ProductRequest.ShareDiscountRequest.Period();
                discountPeriod.from = YDMATimeUtil.getCurrentTime();
                discountPeriod.to = YDMATimeUtil.getSaleEndDt(dtllist.getSharedfrom()).replaceAll("-", "").concat("235959");
                shareDiscount.discountPeriod = discountPeriod;
            } else {
                shareDiscount.value = new Long("0");
                shareDiscount.useSalePeriod = false;
            }
            productRequest.shareDiscount = shareDiscount;
        }
        catch (Exception exception) {
            throw new Exception("\uc18c\ubb38\ub0b4\uba74\ud560\uc778\uc815\ubcf4\ub97c \uc785\ub825\ud558\ub294 \ub3c4\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setGroupDiscount(ShopKakaoStoreAdditionalDto dtllist, KakaoStoreProductDto.ProdRequest.ProductRequest productRequest) throws Exception {
        String groupfrom = "";
        try {
            KakaoStoreProductDto.ProdRequest.ProductRequest.GroupDIscountRequest groupDiscount = new KakaoStoreProductDto.ProdRequest.ProductRequest.GroupDIscountRequest();
            groupDiscount.useGroupDiscount = dtllist.getGroupdiscount().equals("true");
            if (dtllist.getGroupdiscount().equals("true")) {
                groupDiscount.price = new BigDecimal(dtllist.getGroupprice());
                groupDiscount.useStock = dtllist.getGroupstockyn().equals("true");
                groupDiscount.stock = new Integer(dtllist.getGroupstock().equals("") ? null : dtllist.getGroupstock());
                KakaoStoreProductDto.ProdRequest.ProductRequest.GroupDIscountRequest.Period period = new KakaoStoreProductDto.ProdRequest.ProductRequest.GroupDIscountRequest.Period();
                period.from = YDMATimeUtil.getCurrentTime();
                groupfrom = dtllist.getGroupfrom().equals("24") ? "1" : (dtllist.getGroupfrom().equals("48") ? "2" : "3");
                period.to = YDMATimeUtil.getSaleEndDt(groupfrom).replaceAll("-", "").concat("235959");
                groupDiscount.period = period;
            } else {
                groupDiscount.price = new BigDecimal(0);
                groupDiscount.useStock = false;
            }
            productRequest.groupDiscount = groupDiscount;
        }
        catch (Exception exception) {
            throw new Exception("\ud1a1\ub51c\ud560\uc778\uc815\ubcf4\ub97c \uc785\ub825\ud558\ub294 \ub3c4\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setMaxNMinsetting(ShopKakaoStoreAdditionalDto dtllist, KakaoStoreProductDto.ProdRequest.ProductRequest productRequest) throws Exception {
        try {
            productRequest.minPurchaseQuantity = new Integer(dtllist.getMinpurchaseqty().equals("") ? "0" : dtllist.getMinpurchaseqty());
            productRequest.maxPurchaseQuantity = new Integer(dtllist.getMaxpurchaseqty().equals("") ? "0" : dtllist.getMaxpurchaseqty());
            productRequest.maxPurchaseQuantityOfBuyer = 999;
        }
        catch (Exception exception) {
            throw new Exception("\ucd5c\ub300,\ucd5c\uc18c\uad6c\ub9e4\uc218\ub7c9\uc744 \uc785\ub825\ud558\ub294 \ub3c4\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setMinorPurchasable(ShopProductDto dto, ShopKakaoStoreAdditionalDto dtllist, KakaoStoreProductDto.ProdRequest.ProductRequest productRequest) throws Exception {
        try {
            productRequest.minorPurchasable = dtllist.getTypeaddi().equals("Y") ? Boolean.valueOf(dto.getAdult().equals("0")) : Boolean.valueOf(true);
        }
        catch (Exception exception) {
            throw new Exception("\uc131\uc778\uc0c1\ud488\uc5ec\ubd80\ub97c \uc785\ub825\ud558\ub294 \ub3c4\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private ResultMarketPrice setSaleCost(ShopProductDto dto, ShopKakaoStoreAdditionalDto dtllist, ResultMarketPrice resultMarketPrice, KakaoStoreProductDto.ProdRequest.ProductRequest productRequest) throws Exception {
        int deliveryFee = 0;
        long price_cost = YDMAStringUtil.convertToLong(dto.getGoods_cost());
        try {
            if (dtllist.getFreedelivery().equals("T")) {
                if (dtllist.getExpprc().equals("9999")) {
                    if (!dto.getDelv_cost().equals("0")) {
                        deliveryFee = Integer.parseInt(dto.getDelv_cost());
                    } else {
                        ShopPreferencesDto systemconf = ShopCommonDao.get().getSystemConf();
                        deliveryFee = Integer.parseInt(systemconf.getDeliverycost());
                    }
                } else {
                    deliveryFee = Integer.parseInt(dtllist.getExpprc());
                }
                price_cost += (long)deliveryFee;
            }
            Long salePrice = price_cost;
            int limit_price = YDMAStringUtil.convertToInt(dto.getLimit_price());
            resultMarketPrice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
            if (salePrice > YDMAStringUtil.convertToLong(resultMarketPrice.getConsumer_if_sale_price())) {
                resultMarketPrice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
            }
            productRequest.salePrice = new BigDecimal(resultMarketPrice.getConsumer_if_sale_price());
            dto.setGoods_price(resultMarketPrice.getTotal_sale_discount());
            dto.setMarket_price(resultMarketPrice.getTotal_sale_discount());
            dto.setGoods_consumer_price(resultMarketPrice.getTotal_sale_discount());
        }
        catch (Exception exception) {
            throw new Exception("\ud310\ub9e4\uac00\ub97c \uacc4\uc0b0\ud558\ub294 \ub3c4\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        return resultMarketPrice;
    }

    private void setOption(ShopProductDto dto, ShopKakaoStoreAdditionalDto dtllist, ResultMarketPrice resultMarketPrice, KakaoStoreProductDto.ProdRequest.ProductRequest productRequest) throws Exception {
        this.options = this.getProductOptions(dto);
        try {
            KakaoStoreProductDto.ProdRequest.ProductRequest.Option option2 = new KakaoStoreProductDto.ProdRequest.ProductRequest.Option();
            if (!dto.getChar_1_nm().equals("\ub2e8\ud488")) {
                ArrayList<KakaoStoreProductDto.ProdRequest.ProductRequest.Option.Combination> combinations = new ArrayList<KakaoStoreProductDto.ProdRequest.ProductRequest.Option.Combination>();
                ArrayList<KakaoStoreProductDto.ProdRequest.ProductRequest.Option.CombinationAttribute> combinationAttributes = new ArrayList<KakaoStoreProductDto.ProdRequest.ProductRequest.Option.CombinationAttribute>();
                for (ShopOptionDto opt : this.options) {
                    String resultOptionValue;
                    KakaoStoreProductDto.ProdRequest.ProductRequest.Option.Combination.Name name;
                    if (opt.getName().contains("\ud488\uc808") || opt.getOptspecdes().contains("\ud488\uc808") || opt.getCnt().equals("0")) continue;
                    KakaoStoreProductDto.ProdRequest.ProductRequest.Option.Combination combination = new KakaoStoreProductDto.ProdRequest.ProductRequest.Option.Combination();
                    ArrayList<KakaoStoreProductDto.ProdRequest.ProductRequest.Option.Combination.Name> names = new ArrayList<KakaoStoreProductDto.ProdRequest.ProductRequest.Option.Combination.Name>();
                    List<String> typeLst = Arrays.asList(opt.getName().split(":"));
                    List<String> nameLst = Arrays.asList(opt.getOptspecdes().split(":"));
                    option2.type = "COMBINATION";
                    Long salePrice1 = YDMAStringUtil.convertToLong(dto.getGoods_cost());
                    String deliveryFee = "";
                    if (dtllist.getFreedelivery().equals("T")) {
                        if (dtllist.getExpprc().equals("9999")) {
                            if (!dto.getDelv_cost().equals("") || !dto.getDelv_cost().equals("0")) {
                                deliveryFee = dto.getDelv_cost();
                            } else {
                                ShopPreferencesDto systemconf = ShopCommonDao.get().getSystemConf();
                                deliveryFee = systemconf.getDeliverycost();
                            }
                        } else {
                            deliveryFee = String.valueOf(dtllist.getExpprc());
                        }
                        salePrice1 = salePrice1 + (long)Integer.parseInt(deliveryFee);
                    }
                    salePrice1 = salePrice1 + YDMAStringUtil.convertToLong(opt.getAmt());
                    int limit_price1 = YDMAStringUtil.convertToInt(opt.getLimit_price());
                    ResultMarketPrice optionprice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price1, salePrice1);
                    if (salePrice1 > YDMAStringUtil.convertToLong(optionprice.getConsumer_if_sale_price())) {
                        optionprice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price1, salePrice1);
                    }
                    int addAmt = Integer.parseInt(optionprice.getTotal_sale_discount()) - Integer.parseInt(dto.getGoods_price());
                    if (typeLst.size() == 3) {
                        combination.usable = true;
                        combination.price = new BigDecimal(addAmt);
                        combination.stockQuantity = new Integer(opt.getCnt().equals("") ? "0" : opt.getCnt());
                        combination.managedCode = opt.getOptcompanycd();
                        combination.name = names;
                        combinations.add(combination);
                        int i = 0;
                        while (i < typeLst.size()) {
                            name = new KakaoStoreProductDto.ProdRequest.ProductRequest.Option.Combination.Name();
                            resultOptionValue = ShopKakaoStoreUtil.addText(dtllist, nameLst.get(i));
                            name.key = typeLst.get(i);
                            name.value = resultOptionValue;
                            names.add(name);
                            ++i;
                        }
                        continue;
                    }
                    if (typeLst.size() == 2) {
                        combination.usable = true;
                        combination.price = new BigDecimal(addAmt);
                        combination.stockQuantity = new Integer(opt.getCnt().equals("") ? "0" : opt.getCnt());
                        combination.managedCode = opt.getOptcompanycd();
                        combination.name = names;
                        combinations.add(combination);
                        int i = 0;
                        while (i < typeLst.size()) {
                            name = new KakaoStoreProductDto.ProdRequest.ProductRequest.Option.Combination.Name();
                            resultOptionValue = ShopKakaoStoreUtil.addText(dtllist, nameLst.get(i));
                            name.key = typeLst.get(i);
                            name.value = resultOptionValue;
                            names.add(name);
                            ++i;
                        }
                        continue;
                    }
                    combination.usable = true;
                    combination.price = new BigDecimal(addAmt);
                    combination.stockQuantity = new Integer(opt.getCnt().equals("") ? "0" : opt.getCnt());
                    combination.managedCode = opt.getOptcompanycd();
                    combination.name = names;
                    combinations.add(combination);
                    KakaoStoreProductDto.ProdRequest.ProductRequest.Option.Combination.Name name2 = new KakaoStoreProductDto.ProdRequest.ProductRequest.Option.Combination.Name();
                    String resultOptionValue2 = ShopKakaoStoreUtil.addText(dtllist, nameLst.get(0));
                    name2.key = opt.getName();
                    name2.value = resultOptionValue2;
                    names.add(name2);
                }
                option2.combinations = combinations;
                Function<List, List> getStr = list -> list.stream().map(p -> p.key + ":" + p.value).collect(Collectors.toList());
                List options = combinations.stream().flatMap(p -> ((List)getStr.apply(p.name)).stream()).distinct().collect(Collectors.toList());
                int i = 0;
                while (i < options.size()) {
                    String[] strOption = ((String)options.get(i)).split(":");
                    KakaoStoreProductDto.ProdRequest.ProductRequest.Option.CombinationAttribute combinationAttribute = new KakaoStoreProductDto.ProdRequest.ProductRequest.Option.CombinationAttribute();
                    combinationAttribute.name = strOption[0];
                    combinationAttribute.value = ShopKakaoStoreUtil.addText(dtllist, strOption[1]);
                    combinationAttributes.add(combinationAttribute);
                    option2.combinationAttributes = combinationAttributes;
                    ++i;
                }
            } else {
                productRequest.stockQuantity = new Integer("999");
                option2.type = "NONE";
            }
            productRequest.option = option2;
        }
        catch (Exception exception) {
            throw new Exception("\ub370\uc774\ud130\uc785\ub825\uc2e4\ud328 : \uc635\uc158\uc815\ubcf4\ub97c \uc785\ub825\ud558\ub294 \ub3c4\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setImageRemark(ShopProductDto dto, ShopKakaoStoreAdditionalDto dtllist, ShoppingMallDetailDto shoppingMallDetailDto, List<String> strImages, KakaoStoreProductDto.ProdRequest.ProductRequest productRequest) throws Exception {
        Object remark = dto.getGoods_remarks();
        Object addDetailPlus = "";
        try {
            remark = dtllist.getProddetailfront().concat((String)remark);
            remark = ((String)remark).concat(dtllist.getProddetailback());
            if (dtllist.getRemarktop().equals("Y")) {
                remark = "<h2 style='font-size:16px;font-weight: bold;font-family: Dotum;text-align: center;'>\uc0c1\ud488\uba85 : " + dto.getGoods_nm() + "</h2>".concat((String)remark);
            }
            if (dtllist.getDetailkeywordb().equals("Y")) {
                addDetailPlus = dtllist.getDetailKeywordL() + dto.getGoods_search().replace(",", " ") + dtllist.getDetailKeywordR();
            }
            if (dtllist.getDetailproductcodeb().equals("Y")) {
                addDetailPlus = (String)addDetailPlus + dtllist.getDetailProductCodeL() + dto.getCompayny_goods_cd() + dtllist.getDetailProductCodeR();
            }
            if (dtllist.getDetailproductnameb().equals("Y")) {
                addDetailPlus = (String)addDetailPlus + dtllist.getDetailProdcutNameL() + dto.getGoods_nm() + dtllist.getDetailProdcutNameR();
            }
            productRequest.productDetailDescription = (String)addDetailPlus + (String)remark;
            List<String> url = this.getImage(dto, strImages, dtllist, shoppingMallDetailDto);
            KakaoStoreProductDto.ProdRequest.ProductRequest.ProductImage productImage = new KakaoStoreProductDto.ProdRequest.ProductRequest.ProductImage();
            productImage.imageRatio = "SQUARE";
            KakaoStoreProductDto.ProdRequest.ProductRequest.ProductImage.RepresentImage representImage = new KakaoStoreProductDto.ProdRequest.ProductRequest.ProductImage.RepresentImage();
            representImage.url = url.get(0);
            if (url.size() > 1) {
                ArrayList<KakaoStoreProductDto.ProdRequest.ProductRequest.ProductImage.OptionalImage> optionalImages = new ArrayList<KakaoStoreProductDto.ProdRequest.ProductRequest.ProductImage.OptionalImage>();
                int i = 1;
                while (i < url.size()) {
                    if (i <= 3) {
                        KakaoStoreProductDto.ProdRequest.ProductRequest.ProductImage.OptionalImage optionalImage = new KakaoStoreProductDto.ProdRequest.ProductRequest.ProductImage.OptionalImage();
                        optionalImage.url = url.get(i);
                        optionalImages.add(optionalImage);
                    }
                    ++i;
                }
                productImage.optionalImages = optionalImages;
            }
            productImage.representImage = representImage;
            productRequest.productImage = productImage;
        }
        catch (Exception exception) {
            throw new Exception("\uc0c1\uc138\uc124\uba85 \ubc0f \uc774\ubbf8\uc9c0\ub97c \uc785\ub825\ud558\ub294 \ub3c4\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private String getImagePath(String path, String apikey) throws Exception {
        try {
            Connection.Response response = Jsoup.connect((String)("https://kapi.kakao.com/v1/store/product/image/check/url?url=" + path)).header("Host", "kapi.kakao.com").header("Authorization", "KakaoAK b99a474fd6fe27f966e76e37591f0053").header("Target-Authorization", "KakaoAK " + apikey).header("channel-ids", "101").header("Content-Type", "application/x-www-form-urlencoded;charset=utf-8").ignoreContentType(true).method(Connection.Method.GET).execute();
            JsonObject jsonObject = jsonParser.parse(response.body()).getAsJsonObject();
            if (jsonObject.get("code").getAsString().equals("ACCEPTED")) {
                this.getImagePath(path, apikey);
            }
            path = jsonObject.get("url").getAsString();
        }
        catch (Exception e) {
            throw new Exception("\uc774\ubbf8\uc9c0 \ubcc0\ud658 \uc624\ub958" + String.valueOf(e));
        }
        return path;
    }

    private List<String> getImage(ShopProductDto dto, List<String> strImages, ShopKakaoStoreAdditionalDto dtllist, ShoppingMallDetailDto shoppingMallDetailDto) throws Exception {
        ArrayList<String> decodedString = new ArrayList<String>();
        int i = 0;
        while (i < strImages.size()) {
            String img;
            String uploadedImageUrl = img = strImages.get(0);
            try {
                Connection.Response response = Jsoup.connect((String)"https://kapi.kakao.com/v1/store/product/image/upload/url").header("Host", "kapi.kakao.com").header("Authorization", "KakaoAK b99a474fd6fe27f966e76e37591f0053").header("Target-Authorization", "KakaoAK " + shoppingMallDetailDto.getApikey()).header("channel-ids", "101").header("Content-Type", "application/x-www-form-urlencoded;charset=utf-8").data("url", uploadedImageUrl).data("ratio", "SQUARE").ignoreContentType(true).method(Connection.Method.POST).execute();
                JsonParser jsonParser = new JsonParser();
                JsonObject jsonObject = (JsonObject)jsonParser.parse(response.body());
                String imgpath = jsonObject.get("url").getAsString();
                imgpath = this.getImagePath(imgpath, shoppingMallDetailDto.getApikey());
                decodedString.add(imgpath);
            }
            catch (Exception e) {
                throw new Exception("\ub300\ud45c \uc774\ubbf8\uc9c0 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4." + e.getMessage().toString());
            }
            ++i;
        }
        return decodedString;
    }

    private void setOrigin(ShopProductDto dto, ShopKakaoStoreAdditionalDto dtllist, KakaoStoreProductDto.ProdRequest.ProductRequest productRequest) throws Exception {
        try {
            KakaoStoreProductDto.ProdRequest.ProductRequest.ProductOriginAreaInfo productOriginAreaInfo = new KakaoStoreProductDto.ProdRequest.ProductRequest.ProductOriginAreaInfo();
            if (dtllist.getOriginyn().equals("N")) {
                productOriginAreaInfo.originAreaType = dtllist.getOriginlagid();
                productOriginAreaInfo.originAreaCode = dtllist.getOriginid();
                productOriginAreaInfo.originAreaContent = dtllist.getOrigin();
            } else {
                productOriginAreaInfo.originAreaContent = dto.getOrigin();
                if (dto.getOrigin().contains("\uad6d\ub0b4") || dto.getOrigin().contains("\ub300\ud55c\ubbfc\uad6d")) {
                    productOriginAreaInfo.originAreaCode = "0002190";
                    productOriginAreaInfo.originAreaType = "LOCAL";
                } else if (dto.getOrigin().contains("\ud574\uc678")) {
                    productOriginAreaInfo.originAreaCode = "0200037";
                    productOriginAreaInfo.originAreaType = "IMPORT";
                } else {
                    productOriginAreaInfo.originAreaCode = "03";
                    productOriginAreaInfo.originAreaType = "USER_INPUT";
                }
            }
            productOriginAreaInfo.registerWithOtherOriginArea = false;
            productRequest.productOriginAreaInfo = productOriginAreaInfo;
        }
        catch (Exception exception) {
            throw new Exception("\uc6d0\uc0b0\uc9c0\ub97c \uc785\ub825\ud558\ub294 \ub3c4\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setNotice(ShopProductDto dto, ShopKakaoStoreAdditionalDto dtllist, KakaoStoreProductDto.ProdRequest.ProductRequest productRequest) throws Exception, JAXBException {
        try {
            String announcementType = ShopProductDao.get().getAttrcd(dto);
            ShopProductDao.get().setNotice(dto, dto.getShopProdAttrnmDtos());
            KakaoStoreProductDto.ProdRequest.ProductRequest.AnnouncementInfo announcementInfo = new KakaoStoreProductDto.ProdRequest.ProductRequest.AnnouncementInfo();
            announcementInfo.announcementType = announcementType;
            List<ShopProdAttrnmDto> kakaoProductAttrList = ShopProductDao.get().getProductKakaoNotice(dto.getProp1_cd(), "shop0273");
            announcementInfo.announcement.put("announcementType", announcementType);
            announcementInfo.announcement.put("ignoreAll", false);
            for (ShopProdAttrnmDto kakaoProduct : kakaoProductAttrList) {
                ShopProdAttrnmDto shopProdAttrnmDtos = dto.getShopProdAttrnmDtos().stream().filter(p -> p.getAttrnm().contains(kakaoProduct.getAttrvl())).findAny().orElse(null);
                if (shopProdAttrnmDtos != null) {
                    if (shopProdAttrnmDtos.getProp_val().equals("")) {
                        shopProdAttrnmDtos.setProp_val("\uc0c1\uc138 \ud398\uc774\uc9c0 \ucc38\uc870");
                    }
                    if (dtllist.getCollectapplication().equals("Y")) {
                        if (dtllist.getNoticetitleyn().equals("Y")) {
                            announcementInfo.announcement.put(kakaoProduct.getColseq(), kakaoProduct.getColseq() + " : \uc0c1\uc138 \ud398\uc774\uc9c0 \ucc38\uc870");
                            continue;
                        }
                        announcementInfo.announcement.put(kakaoProduct.getColseq(), "\uc0c1\uc138 \ud398\uc774\uc9c0 \ucc38\uc870");
                        continue;
                    }
                    if (dtllist.getNoticetitleyn().equals("Y")) {
                        announcementInfo.announcement.put(kakaoProduct.getColseq(), kakaoProduct.getColseq() + " : " + shopProdAttrnmDtos.getProp_val());
                        continue;
                    }
                    announcementInfo.announcement.put(kakaoProduct.getColseq(), shopProdAttrnmDtos.getProp_val());
                    continue;
                }
                announcementInfo.announcement.put(kakaoProduct.getColseq(), "\uc0c1\uc138 \ud398\uc774\uc9c0 \ucc38\uc870");
            }
            productRequest.announcementInfo = announcementInfo;
        }
        catch (IOException iOException) {
            throw new Exception("\uace0\uc2dc\uc815\ubcf4\ub97c \ubd88\ub7ec\uc624\ub294 \ub3c4\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean modifyProductStatusDto(ShopProductDto shopProductDto, ShopProductAdditionDto dtllist, ShoppingMallDetailDto shoppingMallDetailDto, String status2, ShopProductSendDto shopProductSendDto, Map<String, String> loginCookies) throws Exception {
        int cnt = this.getMultithreadCount();
        String apiKey = shoppingMallDetailDto.getApikey();
        try {
            int slp = 0;
            switch (status2) {
                case "8": {
                    this.productSoldOut(apiKey, shopProductDto);
                    if (shopProductDto.getResult_code().equals("1")) return true;
                    return false;
                }
                case "9": {
                    this.productResumeSale(apiKey, shopProductDto);
                    if (shopProductDto.getResult_code().equals("1")) return true;
                    return false;
                }
                case "6": 
                case "7": {
                    this.productDelete(apiKey, shopProductDto);
                    if (!shopProductDto.getResult_code().equals("1")) {
                        return false;
                    }
                    shopProductDto.setShopprodno("");
                    slp = 2000 * cnt;
                    Thread.sleep(slp);
                    return true;
                }
                case "0": {
                    String matched = IProduct.findFirstForbiddenKeyword(shopProductDto, shoppingMallDetailDto.getForbiddenKeywords());
                    if (matched != null) {
                        throw new IllegalArgumentException(String.format("\uae08\uc9c0 \ud0a4\uc6cc\ub4dc '%s'\uac00 \uac10\uc9c0\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \uc0c1\ud488\uba85=\"%s\", \uac80\uc0c9 \ud0a4\uc6cc\ub4dc=\"%s\"", matched, shopProductDto.getGoods_nm(), shopProductDto.getGoods_search()));
                    }
                    ShopKakaoStoreAdditionalDto kakaodtllist = null;
                    kakaodtllist = (ShopKakaoStoreAdditionalDto)shopProductSendDto.getProductAdditionDto();
                    ArrayList<String> strImages = new ArrayList();
                    ImageTransformParams params = new ImageTransformParams();
                    params.setShopProductDto(shopProductDto);
                    params.setChangesize(kakaodtllist.getChangesize());
                    params.setChangeSizeX(kakaodtllist.getChangeSizeX());
                    params.setChangeSizeY(kakaodtllist.getChangeSizeY());
                    params.setChangeSizeW(kakaodtllist.getChangeSizeW());
                    params.setChangeSizeH(kakaodtllist.getChangeSizeH());
                    params.setAngle(kakaodtllist.getAngle());
                    params.setScalePercent(kakaodtllist.getScalePercent());
                    params.setImgThreeOnFour(kakaodtllist.getImgThreeOnFour());
                    params.setRemoveImgTextYN("");
                    params.setMirrorImgYN(kakaodtllist.getMirrorImgYN());
                    params.setImageresize("");
                    params.setImageresize1("");
                    UnifiedUploadManager manager = new UnifiedUploadManager();
                    this.imageDelete = strImages = manager.processAndUploadImages(params);
                    String json = this.setProductReg(shopProductDto, kakaodtllist, shoppingMallDetailDto, strImages);
                    this.productRegSend(json, shopProductDto, shoppingMallDetailDto.getApikey());
                    if (!shopProductDto.getResult_code().equals("1")) {
                        return false;
                    }
                    slp = 5000 * cnt;
                    Thread.sleep(slp);
                }
            }
            return true;
        }
        catch (Exception e) {
            shopProductDto.setResult_code("-1");
            shopProductDto.setResult_text(e.getMessage());
            return false;
        }
    }

    private void productSoldOut(String apiKey, ShopProductDto shopProductDto) throws Exception {
        this.updateSellStatus(apiKey, shopProductDto, "OFF");
    }

    private void productResumeSale(String apiKey, ShopProductDto shopProductDto) throws Exception {
        this.updateSellStatus(apiKey, shopProductDto, "ON");
    }

    private void updateSellStatus(String apiKey, ShopProductDto shopProductDto, String status2) throws Exception {
        String body = "";
        try {
            Connection.Response response = Jsoup.connect((String)"https://kapi.kakao.com/v1/store/product/update").header("Host", "kapi.kakao.com").header("Authorization", "KakaoAK b99a474fd6fe27f966e76e37591f0053").header("Target-Authorization", "KakaoAK " + apiKey).header("channel-ids", "101").header("Content-Type", "application/x-www-form-urlencoded;charset=utf-8").data("productId", shopProductDto.getShopprodno()).data("saleStatus", status2).ignoreContentType(true).method(Connection.Method.POST).execute();
            body = response.body();
            if (body.contains(shopProductDto.getShopprodno()) && response.statusCode() == 200) {
                shopProductDto.setResult_code("1");
            } else {
                shopProductDto.setResult_code("-1");
                shopProductDto.setResult_text(body);
            }
        }
        catch (Exception e) {
            if (e.getMessage().equals("HTTP error fetching URL")) {
                throw new Exception("\uc774\ubbf8 \ud310\ub9e4\uc911\uc9c0 \ub41c \uc0c1\ud488\uc785\ub2c8\ub2e4. \uc1fc\ud551\ubab0\uc5d0\uc11c \uc9c1\uc811 \uc0ad\uc81c\ud574\uc8fc\uc138\uc694.");
            }
            throw new Exception("\uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4." + body + e.getMessage());
        }
    }

    private void productDelete(String apiKey, ShopProductDto shopProductDto) throws Exception {
        String body = "";
        try {
            String json = "{\"productIds\":[" + Integer.parseInt(shopProductDto.getShopprodno()) + "]}";
            Connection.Response response = Jsoup.connect((String)"https://kapi.kakao.com/v2/store/products/delete").header("Host", "kapi.kakao.com").header("Authorization", "KakaoAK b99a474fd6fe27f966e76e37591f0053").header("Target-Authorization", "KakaoAK " + apiKey).header("channel-ids", "101").header("Content-Type", "application/json").requestBody(json).ignoreContentType(true).method(Connection.Method.PUT).execute();
            body = response.body();
            if (body.contains(shopProductDto.getShopprodno()) && response.statusCode() == 200) {
                shopProductDto.setResult_code("1");
            } else {
                shopProductDto.setResult_code("-1");
                shopProductDto.setResult_text(body);
            }
        }
        catch (Exception e) {
            shopProductDto.setResult_code("-1");
            shopProductDto.setResult_text(body);
            throw new Exception("\uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4." + body + e.getMessage());
        }
    }

    @Override
    public boolean isExistProdNo(ShopProductDto dto, ShoppingMallDetailDto shoppingMallDetailDto, Map<String, String> cookies) throws Exception {
        String productId;
        block3: {
            productId = "";
            try {
                if (!dto.getShopprodno().equals("")) break block3;
                return false;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        Connection.Response response = Jsoup.connect((String)("https://kapi.kakao.com/v1/store/product/store_managed_code?code=" + dto.getCompayny_goods_cd())).header("Host", "kapi.kakao.com").header("Authorization", "KakaoAK b99a474fd6fe27f966e76e37591f0053").header("Target-Authorization", "KakaoAK " + shoppingMallDetailDto.getApikey()).header("channel_ids", "101").header("Content-Type", "application/json;charset=UTF-8").method(Connection.Method.GET).ignoreContentType(true).followRedirects(true).ignoreHttpErrors(true).execute();
        String body = response.body();
        JsonParser parser = new JsonParser();
        JsonArray jsonArray = (JsonArray)parser.parse(body);
        JsonObject jsonObject = (JsonObject)jsonArray.get(0);
        productId = jsonObject.get("productId").getAsString();
        return !productId.equals("");
    }

    private synchronized void productRegSend(String json, ShopProductDto dto, String apiKey) throws Exception {
        String body = "";
        try {
            Connection.Response response = Jsoup.connect((String)Host.concat("/v1/store/product/update")).header("Host", "kapi.kakao.com").header("Authorization", "KakaoAK b99a474fd6fe27f966e76e37591f0053").header("Target-Authorization", "KakaoAK " + apiKey).header("channel_ids", "101").header("Content-Type", "application/x-www-form-urlencoded;charset=utf-8").data("product", json).method(Connection.Method.POST).ignoreContentType(true).execute();
            body = response.body();
            JsonParser parser = new JsonParser();
            JsonObject object = (JsonObject)parser.parse(body);
            dto.setShopprodno(object.get("productId").getAsString());
            if (!dto.getShopprodno().equals("")) {
                dto.setResult_code("1");
            } else {
                dto.setResult_code("-1");
                dto.setResult_text(body);
            }
        }
        catch (Exception e) {
            dto.setResult_code("-1");
            dto.setResult_text(body);
            throw new Exception("\uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4." + body + e.getMessage());
        }
    }

    private int getMultithreadCount() {
        int cnt;
        try {
            cnt = ShopWorkDao.get().getMultiThreadCnt();
            int cores = Runtime.getRuntime().availableProcessors();
            if (cnt != 1 && cnt > cores / 2) {
                cnt = cores / 2;
            }
        }
        catch (Exception exception) {
            return 1;
        }
        return cnt;
    }

    @Override
    public boolean deleteProduct(ShopProductDto shopProductDto) throws Exception {
        return false;
    }

    @Override
    public RegResultDTO deleteAfterRegister(ShopProductSendDto sendInfo, ShopProductDto prodInfo) throws Exception {
        return null;
    }
}

