/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.job;

import com.kdjsystem.mlink.shop.common.ShopCommon;
import com.kdjsystem.mlink.shop.dao.MallDTO;
import com.kdjsystem.mlink.shop.dao.RegProductOption;
import com.kdjsystem.mlink.shop.dao.ResultDto;
import com.kdjsystem.mlink.shop.dao.ScheduleInfoDto;
import com.kdjsystem.mlink.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.shop.dao.ShopPreferencesDto;
import com.kdjsystem.mlink.shop.dao.ShopProductDao;
import com.kdjsystem.mlink.shop.dao.ShopProductDto;
import com.kdjsystem.mlink.shop.dao.ShopWorkDao;
import com.kdjsystem.mlink.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.shop.mlink.MLinkCommon;
import com.kdjsystem.mlink.shop.mlink.MLinkProductConnection;
import com.kdjsystem.mlink.tot.common.YDMAProgressBar;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

public class JobProductModify {
    public void modifyProductState(List<ScheduleInfoDto> schedulerInfos, YDMAProgressBar console) {
        String shopString = "";
        try {
            List<ShoppingMallDetailDto> shopInfos = ShopCommonDao.get().ShoppingMallDetailList();
            ScheduleInfoDto oneScheduInfo = schedulerInfos.get(0);
            if (oneScheduInfo.getSitechk().equals("Y") && oneScheduInfo.getAutoprodregchk().equals("Y")) {
                this.modifyProcess(console, schedulerInfos, shopInfos);
            }
        }
        catch (Exception e) {
            console.setValueBack(String.format("[%s] \uc5d0\ub7ec\ubc1c\uc0dd: %s", shopString, e.getMessage()), 100);
        }
    }

    private void modifyProcess(YDMAProgressBar console, List<ScheduleInfoDto> schedulerInfos, List<ShoppingMallDetailDto> shopInfos) {
        console.setValueBack("[INFO] \uc1fc\ud551\ubab0 \ubcc4 \uc0c1\ud488 \uc790\ub3d9 \uc218\uc815\uc744 \uc9c4\ud589\ud569\ub2c8\ub2e4.", 28);
        String shopString = "";
        try {
            String runId = UUID.randomUUID().toString();
            ShopWorkDao.get().setSchProdinfoDeleteByNotCompno(runId);
            ShopPreferencesDto conf = ShopCommonDao.get().getSystemConf();
            for (ScheduleInfoDto schedulerInfo : schedulerInfos) {
                try {
                    shopString = this.getShopString(schedulerInfo, shopInfos);
                    console.setValueBack(shopString + " \uc790\ub3d9 \uc218\uc815 \ud504\ub85c\uc138\uc2a4\ub97c \uc2dc\uc791\ud569\ub2c8\ub2e4.", 20);
                    if (schedulerInfo.getAddition_seq() < 1) {
                        console.setValueBack(shopString + " \ubd80\uac00\uc815\ubcf4\uac00 \uc124\uc815\ub418\uc9c0 \uc54a\uc544 \uc791\uc5c5\uc5d0\uc11c \uc81c\uc678\ub429\ub2c8\ub2e4.", 20);
                        continue;
                    }
                    console.setValueBack(shopString + " \uc218\uc815 \ub300\uc0c1 \uc0c1\ud488\uc744 \uc870\ud68c\ud569\ub2c8\ub2e4.", 20);
                    String modiTagetNaddInfo = schedulerInfo.getReg_target();
                    String shopCd = schedulerInfo.getShopcd();
                    String shopSeq = schedulerInfo.getShopseq();
                    String sendStatus = String.valueOf(6000);
                    List<ShopProductDto> prodList = ShopProductDao.get().getShopProductListForModify(shopCd, shopSeq, sendStatus);
                    if (prodList.size() > 0) {
                        String query = prodList.stream().map(p -> String.format("SELECT '%s' AS PRODSEQ, \n'%s' AS SEQ, \n'%s' AS SHOPPRODNO, \n'%s' AS SENDSEQ \r\n", p.getProdseq(), p.getSeq(), p.getShopprodno(), p.getSendseq())).distinct().collect(Collectors.joining(" UNION ALL ", "WITH CTE_PRODLIST AS( ", ")"));
                        prodList = ShopProductDao.get().getShopProductListForModify(query, shopCd, shopSeq, sendStatus);
                    }
                    console.setValueBack(shopString + " DB\uc5d0\uc11c \uc870\uac74\uc5d0 \ub9de\ub294 " + prodList.size() + "\uac74\uc774 \uc870\ud68c\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", 20);
                    prodList = MLinkCommon.get().getCategorysShopCidSetting(null, prodList);
                    ArrayList<MallDTO> malls = new ArrayList<MallDTO>();
                    malls.add(new MallDTO(schedulerInfo.getShopcd(), schedulerInfo.getShopseq(), String.valueOf(schedulerInfo.getAddition_seq())));
                    List<ShopProductDto> filterProds = MLinkProductConnection.get().getQueueRegProductSendList(prodList, malls);
                    if (filterProds == null || filterProds.size() == 0) {
                        console.setValueBack(shopString + " \uc791\uc5c5\ub9ac\uc2a4\ud2b8\uc5d0 \ub4f1\ub85d\ud560 \uac74\uc774 \uc5c6\uc2b5\ub2c8\ub2e4. \ub2e4\uc74c \uc1fc\ud551\ubab0 \uc791\uc5c5\uc744 \uc2dc\uc791\ud569\ub2c8\ub2e4.", 20);
                        continue;
                    }
                    console.setValueBack(shopString + " \uce74\ud14c\uace0\ub9ac \ubc0f \uc791\uc5c5 \ub9ac\uc2a4\ud2b8 \ud544\ud130\ub9c1 \uc644\ub8cc(\uc720\uc9c0 " + filterProds.size() + "\uac74)", 20);
                    RegProductOption option2 = null;
                    if (modiTagetNaddInfo.contains(",")) {
                        String[] addInfoArray = modiTagetNaddInfo.split(",");
                        option2 = new RegProductOption(addInfoArray[0], addInfoArray[1], addInfoArray[2], "N");
                    } else {
                        option2 = new RegProductOption("N", "N", "N", "N");
                    }
                    ResultDto ret = MLinkProductConnection.get().sendQueueModifyProduct(malls, shopInfos, filterProds, conf, option2, console, shopString);
                    List<Object> filters = new ArrayList();
                    List sendList = (List)ret.getItems();
                    if (sendList != null) {
                        List sendProdNums = sendList.stream().map(p -> p.getCompayny_goods_cd()).collect(Collectors.toList());
                        filters = filterProds.stream().filter(p -> !sendProdNums.contains(p.getCompayny_goods_cd())).collect(Collectors.toList());
                    } else {
                        filters = filterProds;
                    }
                    ShopWorkDao.get().setSchProdinfoInsert(runId, filterProds);
                    int sendSize = sendList != null ? sendList.size() : 0;
                    int filterSize = filters != null ? filters.size() : 0;
                    console.setValueBack(String.format("%s %s\uac74\uc758 \uc0c1\ud488\uc774 \uc791\uc5c5\ub9ac\uc2a4\ud2b8\uc5d0 \ub4f1\ub85d\ub418\uace0 %s\uac74\uc774 \ud544\ud130\ub9c1 \ub418\uc5c8\uc2b5\ub2c8\ub2e4.", shopString, sendSize, filterSize), 28);
                    console.setValueBack(shopString + " 10\ucd08 \ub300\uae30 \ud6c4 \uc2dc\uc791\ud569\ub2c8\ub2e4.", 28);
                    Thread.sleep(10000L);
                }
                catch (Exception e) {
                    console.setValueBack(String.format("%s \uc5d0\ub7ec\ubc1c\uc0dd : %s", shopString, e.getMessage()), 28);
                }
            }
            ShopWorkDao.get().setSchProdinfoDeleteByNotCompno(runId);
            console.setValueBack("--------------------------------------------------------------------------------------", 28);
            console.setValueBack("[INFO] \uc1fc\ud551\ubab0\ubcc4 \uc0c1\ud488 \uc790\ub3d9 \uc218\uc815\uc774 \uc644\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \uc791\uc5c5\uad00\ub9ac \uba54\ub274\uc5d0\uc11c \uc218\uc815 \ub0b4\uc5ed\uc744 \ud655\uc778\ud558\uc2e4 \uc218 \uc788\uc2b5\ub2c8\ub2e4. \r\n", 28);
        }
        catch (Exception e) {
            console.setValueBack(String.format("%s \uc5d0\ub7ec\ubc1c\uc0dd : %s", shopString, e.getMessage()), 28);
        }
    }

    private String getShopString(ScheduleInfoDto schedulerInfo, List<ShoppingMallDetailDto> shopInfos) {
        String shopString = "";
        String shopName = ShopCommon.getShoppingMallName(schedulerInfo.getShopcd());
        String shopNickName = shopInfos.stream().filter(p -> p.getShopcd().equals(schedulerInfo.getShopcd()) && p.getShopseq().equals(schedulerInfo.getShopseq())).map(p -> p.getNicknm1()).findFirst().orElse("");
        String shopId = shopInfos.stream().filter(p -> p.getShopcd().equals(schedulerInfo.getShopcd()) && p.getShopseq().equals(schedulerInfo.getShopseq())).map(p -> p.getShoppingid()).findFirst().orElse("");
        shopString = String.format("[%s - %s(%s)]", shopName, shopId, shopNickName);
        return shopString;
    }
}

