/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.onnme;

import com.jogamp.common.util.InterruptSource;
import com.kdjsystem.mlink.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.shop.dao.ShopDeliveryDto;
import com.kdjsystem.mlink.shop.dao.ShopOrderDao;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.shop.mlink.MLinkCommon;
import com.kdjsystem.mlink.shop.mlink.MLinkDomeOrderCollectConnection;
import com.kdjsystem.mlink.tot.common.YDMAProgressBar;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoAlertPresentException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.Select;
import org.openqa.selenium.support.ui.WebDriverWait;

public class OnnmeCommon {
    public static OnnmeCommon instance = new OnnmeCommon();
    private List<ShopOrderMstDto> ret;

    private OnnmeCommon() {
    }

    public static OnnmeCommon get() {
        return instance;
    }

    public List<ShopOrderMstDto> OrderListComplate(List<ShopOrderMstDto> list, ShoppingMallDetailDto shopdto, YDMAProgressBar console) throws Exception {
        list = list.stream().filter(d -> d.getDosinstatus() != null && !d.getDosinstatus().equals("\ud488\uc808")).collect(Collectors.toList());
        MLinkCommon.get().setValueYDMAprogrssBarisScheduler(console, "\ud488\uc808\uc0c1\ud488 \ubc0f \ub3d9\uc77c\ubc30\uc1a1\uc9c0 \uc81c\uc678 " + list.size() + "\uac74\uc758 \uc8fc\ubb38\uc815\ubcf4 \uc804\uc1a1\uc744 \uc2dc\uc791\ud569\ub2c8\ub2e4", 0);
        int page = 0;
        ChromeDriver driver = IShopCommonLogin.loginOnnme(shopdto.getShoppingid(), shopdto.getPassword(), "shop9987", true);
        driver.get("https://onnme.com/order/basket.html");
        InterruptSource.Thread.sleep((long)1000L);
        try {
            WebElement emptyCartButton = driver.findElement(By.cssSelector((String)"a[onclick='Basket.emptyBasket()']"));
            if (emptyCartButton.isDisplayed()) {
                emptyCartButton.click();
                InterruptSource.Thread.sleep((long)1000L);
                Alert alert = driver.switchTo().alert();
                alert.accept();
                InterruptSource.Thread.sleep((long)1000L);
            }
        }
        catch (NoSuchElementException noSuchElementException) {}
        Map<String, List<ShopOrderMstDto>> groupedOrders = list.stream().collect(Collectors.groupingBy(ShopOrderMstDto::getReceive_name));
        for (Map.Entry<String, List<ShopOrderMstDto>> entry : groupedOrders.entrySet()) {
            List<ShopOrderMstDto> groupedOrderList = entry.getValue();
            for (ShopOrderMstDto dto : groupedOrderList) {
                try {
                    String productDetailUrl = "https://onnme.com/product/detail.html?product_no=" + dto.getGoodsNo();
                    driver.get(productDetailUrl);
                    InterruptSource.Thread.sleep((long)1000L);
                    String[] options = dto.getP_sku_value2().split(":");
                    if (options.length == 2) {
                        String option1Value = options[0].trim();
                        String option2Value = options[1].trim();
                        Select option1Select = new Select(driver.findElement(By.name((String)"option1")));
                        option1Select.selectByVisibleText(option1Value);
                        InterruptSource.Thread.sleep((long)1000L);
                        Select option2Select = new Select(driver.findElement(By.name((String)"option2")));
                        option2Select.selectByVisibleText(option2Value);
                    } else {
                        Select option1Select = new Select(driver.findElement(By.name((String)"option1")));
                        option1Select.selectByVisibleText(dto.getP_sku_value2());
                    }
                    InterruptSource.Thread.sleep((long)1000L);
                    WebElement quantityInput = driver.findElement(By.id((String)"option_box1_quantity"));
                    quantityInput.click();
                    quantityInput.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, "a"})});
                    quantityInput.sendKeys(new CharSequence[]{Keys.DELETE});
                    quantityInput.sendKeys(new CharSequence[]{String.valueOf(dto.getSale_cnt())});
                    InterruptSource.Thread.sleep((long)1000L);
                    driver.findElement(By.cssSelector((String)".ec-base-button a.btn_15_f2")).click();
                    InterruptSource.Thread.sleep((long)1000L);
                    try {
                        Alert alert = driver.switchTo().alert();
                        alert.dismiss();
                        InterruptSource.Thread.sleep((long)1000L);
                    }
                    catch (NoAlertPresentException noAlertPresentException) {}
                }
                catch (Exception e) {
                    MLinkCommon.get().setValueYDMAprogrssBarisScheduler(console, "\uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4. " + e.getMessage(), page);
                    e.printStackTrace();
                }
            }
            try {
                ShopOrderMstDto dto;
                driver.get("https://onnme.com/order/basket.html");
                InterruptSource.Thread.sleep((long)1000L);
                driver.findElement(By.cssSelector((String)"a[onclick='Basket.orderAll(this)']")).click();
                InterruptSource.Thread.sleep((long)1000L);
                dto = groupedOrderList.get(0);
                WebElement receiveName = driver.findElement(By.id((String)"rname"));
                receiveName.clear();
                receiveName.sendKeys(new CharSequence[]{dto.getReceive_name()});
                driver.findElement(By.id((String)"btn_search_rzipcode")).click();
                InterruptSource.Thread.sleep((long)1000L);
                driver.switchTo().frame(driver.findElement(By.id((String)"iframeZipcode")));
                WebElement innerIframe = driver.findElement(By.cssSelector((String)"iframe[title='\uc6b0\ud3b8\ubc88\ud638\uc11c\ube44\uc2a4 \ub808\uc774\uc5b4 \ud504\ub808\uc784']"));
                driver.switchTo().frame(innerIframe);
                WebElement deepestIframe = driver.findElement(By.id((String)"__daum__viewerFrame_1"));
                driver.switchTo().frame(deepestIframe);
                WebElement postalCodeInput = driver.findElement(By.id((String)"region_name"));
                postalCodeInput.sendKeys(new CharSequence[]{dto.getReceive_addr()});
                driver.findElement(By.cssSelector((String)"button.btn_search")).click();
                InterruptSource.Thread.sleep((long)1000L);
                WebElement firstResult = driver.findElement(By.cssSelector((String)"button.link_post span.txt_addr"));
                firstResult.click();
                InterruptSource.Thread.sleep((long)1000L);
                driver.switchTo().defaultContent();
                WebElement address2 = driver.findElement(By.id((String)"raddr2"));
                address2.clear();
                address2.sendKeys(new CharSequence[]{dto.getReceive_addr()});
                String mobile = dto.getReceive_cel().replace("-", "");
                WebElement mobile2 = driver.findElement(By.id((String)"rphone2_2"));
                mobile2.clear();
                mobile2.sendKeys(new CharSequence[]{mobile.substring(3, 7)});
                WebElement mobile3 = driver.findElement(By.id((String)"rphone2_3"));
                mobile3.clear();
                mobile3.sendKeys(new CharSequence[]{mobile.substring(7, 11)});
                WebElement message = driver.findElement(By.id((String)"omessage"));
                message.sendKeys(new CharSequence[]{dto.getDelv_msg()});
                WebElement agreeChk = driver.findElement(By.id((String)"delivery_info_checkbox0"));
                agreeChk.click();
                InterruptSource.Thread.sleep((long)1000L);
                WebElement ordererNameElement = driver.findElement(By.id((String)"oname"));
                String ordererName = ordererNameElement.getAttribute("value");
                WebElement pname = driver.findElement(By.id((String)"pname"));
                pname.sendKeys(new CharSequence[]{ordererName});
                Select bankAccount = new Select(driver.findElement(By.id((String)"bankaccount")));
                bankAccount.selectByVisibleText("\uce74\uce74\uc624\ubc45\ud06c 3333260204364 \uae40\uc740\ud76c");
                WebElement purchaseChk = driver.findElement(By.id((String)"chk_purchase_agreement"));
                purchaseChk.click();
                InterruptSource.Thread.sleep((long)1000L);
                WebElement payment = driver.findElement(By.id((String)"btn_payment"));
                payment.click();
                InterruptSource.Thread.sleep((long)1000L);
                WebElement confirmPayment = driver.findElement(By.id((String)"ec-shop_btn_layer_payment"));
                confirmPayment.click();
                InterruptSource.Thread.sleep((long)1000L);
                OnnmeCommon.getOrderNo(driver, groupedOrderList, page, console, shopdto.getShopseq());
            }
            catch (Exception e) {
                MLinkCommon.get().setValueYDMAprogrssBarisScheduler(console, "\uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4. " + e.getMessage(), page);
                e.printStackTrace();
            }
        }
        driver.quit();
        return this.ret;
    }

    public static void getOrderNo(ChromeDriver driver, List<ShopOrderMstDto> list, int page, YDMAProgressBar console, String shopSeq) throws Exception {
        ArrayList<ShopOrderMstDto> ret = new ArrayList<ShopOrderMstDto>();
        try {
            String date = YDMATimeUtil.getCurrentDateScheduler();
            String url = "https://onnme.com/myshop/order/list.html?order_status=all&history_start_date=" + date + "&history_end_date=" + date + "&mode=&term=";
            driver.get(url);
            WebDriverWait wait = new WebDriverWait((WebDriver)driver, 10L);
            wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.cssSelector((String)"tr.xans-record-")));
            List orderRows = driver.findElements(By.cssSelector((String)"tr.xans-record-"));
            for (WebElement row : orderRows) {
                String orderNo = row.findElement(By.cssSelector((String)"td.number p a")).getText().replaceAll("[\\[\\]]", "");
                String orderStatus = row.findElement(By.cssSelector((String)"td.state p.txtEm")).getText();
                String productNameWithCode = row.findElement(By.cssSelector((String)"td.product a.ec-product-name")).getText();
                String productCode = productNameWithCode.substring(productNameWithCode.indexOf("[") + 1, productNameWithCode.indexOf("]"));
                for (ShopOrderMstDto dto : list) {
                    if ((!dto.getCompayny_goods_cd().replaceAll("OM", "").equals(productCode) || !orderStatus.equals("\uc785\uae08\uc804")) && !orderStatus.equals("\uc0c1\ud488\uc900\ube44\uc911") && !orderStatus.equals("\ubc30\uc1a1\uc900\ube44\uc911")) continue;
                    dto.setDs_order_status("\uc628\ubbf8\uc2e0\uaddc");
                    dto.setOrder_status("500");
                    dto.setDosinOrder_code(orderNo + "-" + shopSeq);
                    dto.setResult_code("1");
                    ret.add(dto);
                    String headerText = " \u2192 \ucc98\ub9ac\ub418\uc5c8\uc2b5\ub2c8\ub2e4.\n     ";
                    String comment = String.format("\uc218\ucde8\uc778\uba85 : %s, \uc8fc\ubb38\ubc88\ud638 : %s, \uc0c1\ud488\ucf54\ub4dc : %s, \uc218\ub7c9 : %s \uc8fc\ubb38\uc774 \uc131\uacf5\ud588\uc2b5\ub2c8\ub2e4.", dto.getReceive_name(), dto.getDosinOrder_code(), dto.getCompayny_goods_cd(), dto.getSale_cnt());
                    String jobType = console == null ? "ORD_DOD" : "ORD_DOD_SCH";
                    OnnmeCommon.setValueOrder(console, headerText + comment, ++page, dto, jobType, "\uc131\uacf5", comment);
                }
            }
            ShopOrderDao.get().SaveOrUpdate(ret);
            MLinkCommon.get().setValueYDMAprogrssBarisScheduler(console, "---------------------------------------------------------------------------------------", page);
            MLinkCommon.get().setValueYDMAprogrssBarisScheduler(console, String.format("[\uc628\ubbf8 \uacb0\uacfc] \uc8fc\ubb38 \uac74\uc218 %s\uac74 \uc785\ub2c8\ub2e4.", page), page);
            MLinkCommon.get().setValueYDMAprogrssBarisScheduler(console, "\uce74\uce74\uc624\ubc45\ud06c 3333-26-0204364 \uae40\uc740\ud76c (\uac00\uc785\ud55c \ubc95\uc778\uba85\uc73c\ub85c \uc785\uae08 \ubc14\ub78d\ub2c8\ub2e4.)", page);
        }
        catch (Exception e) {
            e.printStackTrace();
            MLinkCommon.get().setValueYDMAprogrssBarisScheduler(console, "\uc801\ub9bd\uae08\uc774 \ubd80\uc871\ud558\uac70\ub098 \uc608\uc0c1\uce58 \ubabb\ud55c \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.", page);
        }
    }

    public List<ShopOrderMstDto> OrderListComplateCallBack(List<ShopOrderMstDto> list, ShoppingMallDetailDto dto1, YDMAProgressBar console, boolean isAll) throws Exception {
        int page = 0;
        ArrayList<ShopOrderMstDto> ret = new ArrayList<ShopOrderMstDto>();
        try {
            ChromeDriver driver = IShopCommonLogin.loginOnnme(dto1.getShoppingid(), dto1.getPassword(), "shop9987", true);
            new WebDriverWait((WebDriver)driver, 10L);
            for (ShopOrderMstDto dto : list) {
                List<ShopDeliveryDto> datasource = ShopCommonDao.get().getExpress(dto.getShopid());
                String orderCode = dto.getDosinOrder_code().contains("-") ? dto.getDosinOrder_code().split("-")[0] : dto.getDosinOrder_code();
                String url = "https://onnme.com/myshop/order/detail.html?order_id=" + orderCode + "&page=1&history_start_date=" + dto.getStartDt() + "&history_end_date=" + dto.getEndDt();
                driver.get(url);
                InterruptSource.Thread.sleep((long)2000L);
                WebElement orderNoElement = driver.findElement(By.xpath((String)"//th[text()='\uc8fc\ubb38\ubc88\ud638']/following-sibling::td"));
                String orderNo = orderNoElement.getText().trim();
                List productRows = driver.findElements(By.cssSelector((String)"tbody.xans-myshop-orderhistorydetailbasic tr.xans-record-"));
                for (WebElement productRow : productRows) {
                    String productNameWithCode = productRow.findElement(By.cssSelector((String)"td.left strong.name")).getText().trim();
                    String productCode = productNameWithCode.substring(productNameWithCode.indexOf("[") + 1, productNameWithCode.indexOf("]")).trim();
                    String orderStatus = productRow.findElement(By.cssSelector((String)"p.txtEm")).getText().trim();
                    String deliveryCompany = "";
                    String invoiceNo = "";
                    if (orderStatus.equals("\ubc30\uc1a1\uc911") || orderStatus.equals("\ubc30\uc1a1\uc644\ub8cc")) {
                        try {
                            WebElement deliveryCompanyElement = productRow.findElement(By.cssSelector((String)"p + p > a"));
                            if (deliveryCompanyElement != null) {
                                deliveryCompany = deliveryCompanyElement.getText().trim();
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        try {
                            WebElement invoiceNoElement = productRow.findElement(By.cssSelector((String)"p + p + p > a"));
                            if (invoiceNoElement != null) {
                                invoiceNo = invoiceNoElement.getText().trim().replace("[", "").replace("]", "").replace("-", "");
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (!orderCode.equals(orderNo) || !dto.getCompayny_goods_cd().replaceAll("OM", "").equals(productCode)) continue;
                    dto.setDelivery_id("");
                    dto.setInvoice_no("");
                    switch (orderStatus) {
                        case "\uc0c1\ud488\uc900\ube44\uc911": {
                            dto.setOrder_status("501");
                            dto.setDs_order_status("\uc0c1\ud488\uc900\ube44\uc911");
                            break;
                        }
                        case "\ubc30\uc1a1\uc900\ube44\uc911": {
                            dto.setOrder_status("501");
                            dto.setDs_order_status("\ubc30\uc1a1\uc900\ube44\uc911");
                            break;
                        }
                        case "\uc785\uae08\uc804": {
                            dto.setDs_order_status("\uc628\ubbf8\uc2e0\uaddc");
                            break;
                        }
                        case "\ubc30\uc1a1\uc911": 
                        case "\ubc30\uc1a1\uc644\ub8cc": {
                            ShopDeliveryDto deliveryDto = null;
                            for (ShopDeliveryDto d : datasource) {
                                if (!d.getDs_code().replaceAll(" ", "").contains(deliveryCompany)) continue;
                                deliveryDto = d;
                                break;
                            }
                            dto.setDs_order_status(orderStatus);
                            dto.setDelivery_id(deliveryDto != null ? deliveryDto.getDlvID() : "");
                            dto.setInvoice_no(invoiceNo);
                            dto.setOrder_status("402");
                            break;
                        }
                        default: {
                            dto.setDs_order_status(orderStatus);
                        }
                    }
                    dto.setResult_code("1");
                }
                ret.add(dto);
                ++page;
                if (dto.getInvoice_no().equals("")) {
                    MLinkDomeOrderCollectConnection.get().showDomeMessage(dto, page, "", false, console);
                    continue;
                }
                MLinkDomeOrderCollectConnection.get().showDomeMessage(dto, page, "", true, console);
            }
            driver.quit();
            if (!isAll) {
                this.setValue(console, "---------------------------------------------------------------------------------------", page);
                this.setValue(console, String.format("[\uacb0\uacfc] \ub3d9\uae30\ud654 %s\uac74 \uc785\ub2c8\ub2e4.", page), page);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MLinkCommon.get().setValueYDMAprogrssBarisScheduler(console, "\uc628\ubbf8 \ub3d9\uae30\ud654 \uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4. [" + String.valueOf(e) + "]", page);
        }
        return ret;
    }

    private void setValue(YDMAProgressBar console, String message, int page) {
        MLinkCommon.get().setValueYDMAprogrssBarisScheduler(console, message, page);
    }

    private static void setValueOrder(YDMAProgressBar console, String message, int page, ShopOrderMstDto shopOrderMstDto, String jobType, String jobResult, String logMsg) {
        MLinkCommon.get().setValueOrder(console, message, page, shopOrderMstDto, jobType, jobResult, logMsg, false);
    }
}

