/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.tot.ui;

import com.kdjsystem.mlink.tot.common.BrandCombo;
import com.kdjsystem.mlink.tot.common.YDMAProperties;
import com.kdjsystem.mlink.tot.common.YDMASessonUtil;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import com.kdjsystem.mlink.tot.common.YMDAResourceManager;
import com.kdjsystem.mlink.tot.data.dao.BaseStockDao;
import com.kdjsystem.mlink.tot.data.dao.BaseStockDto;
import com.kdjsystem.mlink.tot.data.dao.BrandsDto;
import com.kdjsystem.mlink.tot.data.excel.MyDataManagerFactory;
import com.kdjsystem.mlink.tot.data.excel.MyExcelManager;
import com.kdjsystem.mlink.tot.ui.BaseStockDetailDialog;
import com.kdjsystem.mlink.tot.ui.MyCellRenderer;
import com.kdjsystem.mlink.tot.ui.MyColumnHeaderRenderer;
import com.kdjsystem.mlink.tot.ui.ProcdParseDialog;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.nebula.jface.gridviewer.GridTableViewer;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridCellRenderer;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridHeaderRenderer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;

public class BaseStockManager
extends Composite {
    public static String ID = "com.kdjsystem.mlink.tot.command.BaseStockManager.ID";
    public static String TITLE = "\uae30\ucd08\uc7ac\uace0";
    String[][] column_name = new String[][]{{"No.", "65"}, {"\uc0c1\ud488\ucf54\ub4dc", "200"}, {"I", "30"}, {"\uc0c1\ud488\uba85", "450"}, {"\uaddc\uaca9", "270"}, {"\uc7a5\ubd80\uc218\ub7c9", "100"}, {"\uc2e4\uc7ac\uace0\uc218\ub7c9", "100"}, {"\ucc28\uc774\uc218\ub7c9", "100"}, {"\uc0ac\uc720", "450"}};
    int selectedRowNoMst = -1;
    public int sumOfQty;
    public int sumOfRealQty;
    public int sumOfDiffQty;
    public DateTime dt_stkdt;
    Combo cb_option;
    Text txt_search_condition;
    public String date;
    private Text txt_search;
    GridTableViewer tableViewer;
    private Grid table;
    Label lblNewLabel_final;
    Button btn_save;
    String recvDtNumTag = "\uc785\uace0 \ubc88\ud638 :";
    GridTableViewer tableViewer2;
    Grid table2;
    GridColumn tableViewerColumn_sumqty;
    GridColumn tableViewerColumn_sumrlqty;
    GridColumn tableViewerColumn_sumdiffqty;
    String id;
    String stockListFullPath;
    private Text text;
    private String img_path = "";
    Button today;
    Button week1;
    Button month1;
    Button month3;
    private Composite composite_3;
    private Label lblNewLabel;
    private Combo combo;
    private Combo cb_brands;
    private BrandCombo bcb_brands;

    public BaseStockManager(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout(256));
        Composite composite = new Composite((Composite)this, 0);
        GridLayout gl_composite = new GridLayout(1, false);
        gl_composite.marginWidth = 0;
        gl_composite.marginHeight = 0;
        gl_composite.horizontalSpacing = 0;
        gl_composite.verticalSpacing = 0;
        composite.setLayout((Layout)gl_composite);
        Composite composite_1 = new Composite(composite, 0);
        GridLayout gl_composite_1 = new GridLayout(18, false);
        composite_1.setLayout((Layout)gl_composite_1);
        composite_1.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.composite_3 = new Composite(composite_1, 0);
        this.composite_3.setLayout((Layout)new GridLayout(2, false));
        GridData gd_composite_3 = new GridData(16384, 0x1000000, false, false, 10, 1);
        gd_composite_3.widthHint = 353;
        this.composite_3.setLayoutData((Object)gd_composite_3);
        this.lblNewLabel = new Label(this.composite_3, 0);
        this.lblNewLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.lblNewLabel.setText("\ud654\uc8fc\uc0ac(\ud68c\uc0ac)");
        this.cb_brands = new Combo(this.composite_3, 0);
        this.cb_brands.setItems(new String[]{"\ud68c\uc0ac\uc120\ud0dd"});
        GridData gd_cb_brands = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_cb_brands.widthHint = 91;
        this.cb_brands.setLayoutData((Object)gd_cb_brands);
        this.cb_brands.select(0);
        this.bcb_brands = new BrandCombo(this.cb_brands);
        new Label(composite_1, 0);
        new Label(composite_1, 0);
        new Label(composite_1, 0);
        new Label(composite_1, 0);
        new Label(composite_1, 0);
        new Label(composite_1, 0);
        new Label(composite_1, 0);
        new Label(composite_1, 0);
        this.dt_stkdt = new DateTime(composite_1, 2048);
        BaseStockDao dao = new BaseStockDao();
        String day = "";
        try {
            int brandcd = this.bcb_brands.getSelectionValue();
            YDMAStringUtil.Print("\ub0a0\uc9dc : " + dao.getMaxStkdt(brandcd));
            day = dao.getMaxStkdt(brandcd).equals("20181231") ? "20181231" : dao.getMaxStkdt(brandcd);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        this.dt_stkdt.setYear(Integer.parseInt(day.substring(0, 4)));
        this.dt_stkdt.setMonth(Integer.parseInt(day.substring(4, 6)) - 1);
        this.dt_stkdt.setDay(Integer.parseInt(day.substring(6, 8)));
        this.date = YDMATimeUtil.getOrddtDate(this.dt_stkdt);
        this.today = new Button(composite_1, 0);
        this.today.setText("\uc624\ub298");
        this.today.setBackground(SWTResourceManager.getColor(29));
        this.today.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseStockManager.this.setDefaultDate("\uc624\ub298");
            }
        });
        this.week1 = new Button(composite_1, 0);
        this.week1.setText("1\uc8fc\uc77c");
        this.week1.setBackground(SWTResourceManager.getColor(29));
        this.week1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseStockManager.this.setDefaultDate("week1");
            }
        });
        this.month1 = new Button(composite_1, 0);
        this.month1.setText("1\uac1c\uc6d4");
        this.month1.setBackground(SWTResourceManager.getColor(29));
        this.month1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseStockManager.this.setDefaultDate("month1");
            }
        });
        this.month3 = new Button(composite_1, 0);
        this.month3.setText("3\uac1c\uc6d4");
        this.month3.setBackground(SWTResourceManager.getColor(29));
        this.month3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseStockManager.this.setDefaultDate("month3");
            }
        });
        ComboViewer comboViewer = new ComboViewer(composite_1, 8);
        this.cb_option = comboViewer.getCombo();
        this.cb_option.setItems(new String[]{"\uc0c1\ud488\ucf54\ub4dc", "\uc0c1\ud488\uba85"});
        this.cb_option.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.cb_option.select(1);
        this.txt_search_condition = new Text(composite_1, 2048);
        GridData gd_txt_search_condition = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_txt_search_condition.heightHint = 17;
        gd_txt_search_condition.widthHint = 271;
        this.txt_search_condition.setLayoutData((Object)gd_txt_search_condition);
        Button btn_search = new Button(composite_1, 0);
        btn_search.setToolTipText("\uc7ac\uace0 \uc870\ud68c");
        GridData gd_btn_search = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btn_search.heightHint = 25;
        btn_search.setLayoutData((Object)gd_btn_search);
        btn_search.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseStockManager.this.date = YDMATimeUtil.getOrddtDate(BaseStockManager.this.dt_stkdt);
                BaseStockManager.this.getBaseStockListFromDB(BaseStockManager.this.txt_search_condition.getText().trim(), BaseStockManager.this.date);
            }
        });
        btn_search.setImage(ResourceManager.getPluginImage("com.kdjsystem.mlink.tot", "icons/N\uac80\uc0c9.png"));
        Button btn_excel = new Button(composite_1, 0);
        GridData gd_btn_excel = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btn_excel.heightHint = 25;
        btn_excel.setLayoutData((Object)gd_btn_excel);
        btn_excel.setToolTipText("\uc5d1\uc140\ub85c \ub2e4\uc6b4\ub85c\ub4dc");
        btn_excel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseStockManager.this.downloadExcel();
            }
        });
        btn_excel.setImage(ResourceManager.getPluginImage("com.kdjsystem.mlink.tot", "icons/N\uc5d1\uc140\uc800\uc7a5.png"));
        Label lblNewLabel_1 = new Label(composite_1, 0);
        lblNewLabel_1.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblNewLabel_1.setText("      \uc5d1\uc140\ud30c\uc77c");
        this.txt_search = new Text(composite_1, 2048);
        this.txt_search.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                BaseStockManager.this.txt_search.getShell().setImeInputMode(20);
            }
        });
        GridData gd_txt_search = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        gd_txt_search.heightHint = 17;
        gd_txt_search.widthHint = 250;
        this.txt_search.setLayoutData((Object)gd_txt_search);
        this.txt_search.setBounds(0, 0, 73, 26);
        Button btn_search_order = new Button(composite_1, 0);
        btn_search_order.setToolTipText("\ud30c\uc77c \uac80\uc0c9");
        btn_search_order.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseStockManager.this.uploadExcelFile();
                String filename = BaseStockManager.this.stockListFullPath.substring(BaseStockManager.this.stockListFullPath.lastIndexOf(File.separator) + 1, BaseStockManager.this.stockListFullPath.length());
                BaseStockManager.this.txt_search.setText(filename);
                BaseStockManager.this.txt_search.update();
            }
        });
        GridData gd_btn_search_order = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btn_search_order.heightHint = 25;
        btn_search_order.setLayoutData((Object)gd_btn_search_order);
        btn_search_order.setBounds(0, 0, 93, 30);
        btn_search_order.setImage(ResourceManager.getPluginImage("com.kdjsystem.mlink.tot", "icons/N\uac80\uc0c9.png"));
        Button btn_upload = new Button(composite_1, 0);
        GridData gd_btn_upload = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btn_upload.heightHint = 25;
        gd_btn_upload.widthHint = 95;
        btn_upload.setLayoutData((Object)gd_btn_upload);
        btn_upload.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseStockManager.this.date = YDMATimeUtil.getOrddtDate(BaseStockManager.this.dt_stkdt);
                BaseStockManager.this.syncUploadRealStock2(BaseStockManager.this.date);
            }
        });
        btn_upload.setText("\uc5c5\ub85c\ub4dc ");
        btn_upload.setToolTipText("\uc5c5\ub85c\ub4dc\ud558\uae30");
        btn_upload.setImage(ResourceManager.getPluginImage("com.kdjsystem.mlink.tot", "icons/N\uc5c5\ub85c\ub4dc.png"));
        this.btn_save = new Button(composite_1, 0);
        GridData gd_btn_save = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btn_save.heightHint = 25;
        gd_btn_save.widthHint = 95;
        this.btn_save.setLayoutData((Object)gd_btn_save);
        this.btn_save.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseStockManager.this.saveBaseStockIntoDB();
            }
        });
        this.btn_save.setText("\uc800\uc7a5");
        this.btn_save.setToolTipText("\uc800\uc7a5\ud558\uae30");
        this.btn_save.setImage(ResourceManager.getPluginImage("com.kdjsystem.mlink.tot", "icons/N\uc800\uc7a5.png"));
        Button btn_delete = new Button(composite_1, 0);
        GridData gd_btn_delete = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btn_delete.heightHint = 25;
        gd_btn_delete.widthHint = 95;
        btn_delete.setLayoutData((Object)gd_btn_delete);
        btn_delete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseStockManager.this.deleteAllMstDtl();
            }
        });
        btn_delete.setText("\uc804\uccb4\uc0ad\uc81c");
        btn_delete.setToolTipText("\uc804\uccb4\uc0ad\uc81c\ud558\uae30");
        btn_delete.setImage(ResourceManager.getPluginImage("com.kdjsystem.mlink.tot", "icons/N\ucde8\uc18c.png"));
        Button btn_confirm = new Button(composite_1, 0);
        GridData gd_btn_confirm = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btn_confirm.heightHint = 25;
        gd_btn_confirm.widthHint = 95;
        btn_confirm.setLayoutData((Object)gd_btn_confirm);
        btn_confirm.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseStockManager.this.setConfirmBaseStock();
            }
        });
        btn_confirm.setText(" \uc7ac\uace0\ud655\uc815 ");
        btn_confirm.setToolTipText("\uc7ac\uace0\ucc28\uc774\ud655\uc815\ud558\uae30");
        btn_confirm.setImage(ResourceManager.getPluginImage("com.kdjsystem.mlink.tot", "icons/N\ucc98\ub9ac\uc644\ub8cc.png"));
        this.lblNewLabel_final = new Label(composite_1, 0);
        this.lblNewLabel_final.setText("                        ");
        Composite composite_2 = new Composite(composite, 0);
        GridLayout gl_composite_2 = new GridLayout(1, false);
        gl_composite_2.verticalSpacing = 0;
        gl_composite_2.marginWidth = 0;
        gl_composite_2.marginHeight = 0;
        gl_composite_2.horizontalSpacing = 0;
        composite_2.setLayout((Layout)gl_composite_2);
        composite_2.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        composite_2.setBounds(0, 0, 64, 64);
        this.tableViewer = new GridTableViewer(composite_2, 66306);
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                BaseStockManager.this.openBaseStockDialog();
            }
        });
        this.table = this.tableViewer.getGrid();
        this.table.setFont(SWTResourceManager.getFont("\ub9d1\uc740 \uace0\ub515", 10, 0));
        this.table.setLinesVisible(true);
        this.table.setLineColor(SWTResourceManager.getColor(18));
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.table.setHeaderVisible(true);
        MyColumnHeaderRenderer myHeaderRender = new MyColumnHeaderRenderer();
        myHeaderRender.setBGC(14);
        myHeaderRender.setFGC(1);
        int i = 0;
        while (i < this.column_name.length) {
            String[] column = this.column_name[i];
            GridColumn tableViewerColumn_x = new GridColumn(this.table, 0x1000000);
            tableViewerColumn_x.setHeaderRenderer((GridHeaderRenderer)myHeaderRender);
            myHeaderRender.setSize(100, Integer.parseInt(column[1]));
            tableViewerColumn_x.setWidth(Integer.parseInt(column[1]));
            tableViewerColumn_x.setText(column[0]);
            if (i == 1 || i == 2 || i == 3 || i == 7) {
                MyCellRenderer myCellRenderer = new MyCellRenderer();
                myCellRenderer.setColumnAlign(16384);
                tableViewerColumn_x.setCellRenderer((GridCellRenderer)myCellRenderer);
            }
            ++i;
        }
        Composite composite_sub = new Composite(composite, 2048);
        GridLayout gl_composite_sub = new GridLayout(2, false);
        gl_composite_sub.verticalSpacing = 0;
        gl_composite_sub.marginWidth = 0;
        gl_composite_sub.marginHeight = 0;
        gl_composite_sub.horizontalSpacing = 0;
        composite_sub.setLayout((Layout)gl_composite_sub);
        GridData gd_composite_sub = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_composite_sub.heightHint = 30;
        gd_composite_sub.widthHint = 200;
        composite_sub.setLayoutData((Object)gd_composite_sub);
        this.tableViewer2 = new GridTableViewer(composite_sub, 66306);
        this.table2 = this.tableViewer2.getGrid();
        this.table2.setFont(SWTResourceManager.getFont("\ub9d1\uc740 \uace0\ub515", 10, 0));
        this.table2.setLayoutData((Object)new GridData(4, 4, true, true, 1, 3));
        this.table2.setLinesVisible(true);
        this.table2.setLineColor(SWTResourceManager.getColor(18));
        this.table2.setHeaderVisible(true);
        MyColumnHeaderRenderer myHeaderRender2 = new MyColumnHeaderRenderer();
        myHeaderRender2.setBGC(14);
        myHeaderRender2.setFGC(1);
        GridColumn tableViewerColumn_x = new GridColumn(this.table2, 0x1000000);
        tableViewerColumn_x.setHeaderRenderer((GridHeaderRenderer)myHeaderRender2);
        tableViewerColumn_x.setWidth(Integer.parseInt(this.column_name[0][1]) + Integer.parseInt(this.column_name[1][1]) + Integer.parseInt(this.column_name[2][1]) + Integer.parseInt(this.column_name[3][1]) + Integer.parseInt(this.column_name[4][1]));
        tableViewerColumn_x.setText("\ud569\uacc4");
        this.tableViewerColumn_sumqty = new GridColumn(this.table2, 0x1000000);
        this.tableViewerColumn_sumqty.setWidth(Integer.parseInt(this.column_name[5][1]));
        this.tableViewerColumn_sumqty.setText(Integer.toString(this.sumOfQty));
        this.tableViewerColumn_sumrlqty = new GridColumn(this.table2, 0x1000000);
        this.tableViewerColumn_sumrlqty.setWidth(Integer.parseInt(this.column_name[6][1]));
        this.tableViewerColumn_sumrlqty.setText(Integer.toString(this.sumOfRealQty));
        this.tableViewerColumn_sumdiffqty = new GridColumn(this.table2, 0x1000000);
        this.tableViewerColumn_sumdiffqty.setWidth(Integer.parseInt(this.column_name[7][1]));
        this.tableViewerColumn_sumdiffqty.setText(Integer.toString(this.sumOfDiffQty));
        new Label(composite_sub, 0);
        new Label(composite_sub, 0);
        new Label(composite_sub, 0);
        this.tableViewer.setContentProvider((IContentProvider)new BaseStkContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new BaseStkLableProvider());
        this.tableViewer2.setContentProvider((IContentProvider)new BaseStkContentProvider());
        this.date = YDMATimeUtil.getOrddtDate(this.dt_stkdt);
        Label lblNewLabel_5 = new Label(composite_1, 0);
        lblNewLabel_5.setText(this.recvDtNumTag);
        this.setBrandNameCheck();
        this.getBaseStockListFromDB("", this.date);
    }

    private void setBrandNameCheck() {
        try {
            List<BrandsDto> contents = YDMASessonUtil.getBrandcodelist();
            for (BrandsDto list : contents) {
                this.bcb_brands.add(list.getBrandnm(), list.getBrandcd(), list.getDspseq());
            }
            this.bcb_brands.selectIdex(1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String[] setDefaultDate(String data2) {
        String[] days = YDMATimeUtil.getZMonthDiffDay(-1, "yyyyMMdd");
        int yearOff = Integer.valueOf(days[1].substring(0, 4));
        int monOff = Integer.valueOf(days[1].substring(4, 6));
        int dayOff = Integer.valueOf(days[1].substring(6, 8));
        this.dt_stkdt.setYear(yearOff);
        this.dt_stkdt.setMonth(monOff);
        this.dt_stkdt.setDay(dayOff);
        switch (data2) {
            case "\uc624\ub298": {
                SimpleDateFormat mSimpleDateFormat = new SimpleDateFormat("yyyyMMdd", Locale.KOREA);
                Date currentTime = new Date();
                String mTime = mSimpleDateFormat.format(currentTime);
                this.dt_stkdt.setYear(Integer.parseInt(mTime.substring(0, 4)));
                this.dt_stkdt.setMonth(Integer.parseInt(mTime.substring(4, 6)) - 1);
                this.dt_stkdt.setDay(Integer.parseInt(mTime.substring(6, 8)));
                break;
            }
            case "week1": {
                Calendar calendar = Calendar.getInstance();
                calendar.add(5, -7);
                Date date = calendar.getTime();
                String aa = new SimpleDateFormat("yyyyMMdd").format(date);
                this.dt_stkdt.setYear(Integer.parseInt(aa.substring(0, 4)));
                this.dt_stkdt.setMonth(Integer.parseInt(aa.substring(4, 6)) - 1);
                this.dt_stkdt.setDay(Integer.parseInt(aa.substring(6, 8)));
                break;
            }
            case "month1": {
                this.dt_stkdt.setMonth(monOff - 1);
                break;
            }
            case "month3": {
                this.dt_stkdt.setMonth(monOff - 3);
                break;
            }
            case "month6": {
                this.dt_stkdt.setMonth(monOff - 6);
                break;
            }
        }
        return days;
    }

    private void openBaseStockDialog() {
        int brandcd = this.bcb_brands.getSelectionValue();
        if (brandcd == -1) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)" \ud2b9\uc815 \ud654\uc8fc(\ud68c\uc0ac)\ub97c \uc120\ud0dd\ud6c4 \uc218\ud589 \ud574\uc8fc\uc138\uc694!.");
            return;
        }
        try {
            List list = (List)this.tableViewer.getInput();
            BaseStockDao dao = new BaseStockDao();
            BaseStockDto dto_orgin = (BaseStockDto)list.get(this.table.getSelectionIndex());
            this.date = YDMATimeUtil.getOrddtDate(this.dt_stkdt);
            if (dao.isExistBasstkmst(this.date, brandcd)) {
                BaseStockDetailDialog baseStockDtlDlg = new BaseStockDetailDialog(this.getShell(), dto_orgin, this, this.date, brandcd);
                baseStockDtlDlg.open();
            } else {
                MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)"\uae30\ucd08 \uc7ac\uace0\ub97c \uc218\uc815\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.\n \uc800\uc7a5 \ud6c4 \ub2e4\uc2dc \ub20c\ub7ec\uc8fc\uc138\uc694.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)e.getMessage());
        }
    }

    private void getBaseStockListFromDB(String name, String date) {
        try {
            int brandcd = this.bcb_brands.getSelectionValue();
            if (brandcd == -1) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)" \ud2b9\uc815 \ud654\uc8fc(\ud68c\uc0ac)\ub97c \uc120\ud0dd\ud6c4 \uc218\ud589 \ud574\uc8fc\uc138\uc694!.");
                return;
            }
            int opt = this.cb_option.getSelectionIndex();
            BaseStockDao dao = new BaseStockDao();
            List<BaseStockDto> contents = dao.getProdcutListByDate(opt, name, date, brandcd);
            this.img_path = String.format("%s\\%s", YDMASessonUtil.getAppPath(YDMAProperties.getInstance().getAppProperty("Product.image.productImage")), YDMASessonUtil.getImageFolderName());
            this.sortBaseStockList(contents);
            this.tableViewer.setInput(contents);
            this.tableViewer.refresh();
            this.sumOfQty = this.getSumOfQty(contents);
            this.sumOfRealQty = this.getSumOfRealQty(contents);
            this.sumOfDiffQty = this.getSumOfDiffQty(contents);
            this.updateColumnGirdHeader(this.sumOfQty, this.sumOfRealQty, this.sumOfDiffQty);
            this.tableViewer2.refresh();
            try {
                if (dao.isExistBasstkmst(date, brandcd) && this.lblNewLabel_final.getText().length() != 0 && dao.getRecvDtAndSeq(date, brandcd).length() > 8) {
                    this.lblNewLabel_final.setText(dao.getRecvDtAndSeq(date, brandcd));
                } else {
                    this.lblNewLabel_final.setText("                        ");
                }
                this.lblNewLabel_final.redraw();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            if (contents == null || contents.size() == 0) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)"\uc870\uac74\uc5d0 \ub9de\ub294  \uc0c1\ud488\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.");
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)e.getMessage());
        }
    }

    public int getSumOfQty(List<BaseStockDto> dto) {
        int sumQty = 0;
        int j = 0;
        while (j < dto.size()) {
            sumQty += Integer.parseInt(dto.get(j).getQty());
            ++j;
        }
        return sumQty;
    }

    public int getSumOfRealQty(List<BaseStockDto> dto) {
        int sumRealQty = 0;
        int j = 0;
        while (j < dto.size()) {
            sumRealQty += Integer.parseInt(dto.get(j).getRealQty() == null ? "0" : dto.get(j).getRealQty());
            ++j;
        }
        return sumRealQty;
    }

    public int getSumOfDiffQty(List<BaseStockDto> dto) {
        int sumDiffQty = 0;
        int j = 0;
        while (j < dto.size()) {
            sumDiffQty += Integer.parseInt(dto.get(j).getDiffQty());
            ++j;
        }
        return sumDiffQty;
    }

    public void updateColumnGirdHeader(int qty, int rlqty, int diffqty) {
        this.tableViewerColumn_sumqty.setText(Integer.toString(qty));
        this.tableViewerColumn_sumrlqty.setText(Integer.toString(rlqty));
        this.tableViewerColumn_sumdiffqty.setText(Integer.toString(diffqty));
    }

    private void downloadExcel() {
        block10: {
            int brandcd = this.bcb_brands.getSelectionValue();
            if (brandcd == -1) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)" \ud2b9\uc815 \ud654\uc8fc(\ud68c\uc0ac)\ub97c \uc120\ud0dd\ud6c4 \uc218\ud589 \ud574\uc8fc\uc138\uc694!.");
                return;
            }
            try {
                BaseStockDao dao = new BaseStockDao();
                this.date = YDMATimeUtil.getOrddtDate(this.dt_stkdt);
                if (dao.isExistBasstkmst(this.date, brandcd)) {
                    File file;
                    if (this.tableViewer.getInput() == null || ((List)this.tableViewer.getInput()).size() == 0) {
                        MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)"\uc5d1\uc140\ud30c\uc77c\ub85c \uc800\uc7a5\ud560 \uc8fc\ubb38\ub0b4\uc5ed\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.");
                        return;
                    }
                    if (dao.isExistBasstkmst(this.date, brandcd) && this.lblNewLabel_final.getText().length() > 8 && dao.getRecvDtAndSeq(this.date, brandcd).length() > 8 && this.lblNewLabel_final.getText().length() == dao.getRecvDtAndSeq(this.date, brandcd).length()) {
                        MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)"\uc774\ubbf8 \uc785\ucd9c\uace0 \ucc98\ub9ac\uac00 \uc644\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                        return;
                    }
                    String salePath = YDMASessonUtil.getAppPath(YDMAProperties.getInstance().getAppProperty("wareh.salePath"));
                    String fileSavePath = salePath + File.separator + this.date + "_\uae30\ucd08\uc7ac\uace0.xlsx";
                    if (fileSavePath == null) {
                        MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)"\uacbd\ub85c\uac00 \uc798\ubabb\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                        return;
                    }
                    int pos = 1;
                    int count = 0;
                    do {
                        if (!(file = new File(fileSavePath)).exists()) continue;
                        Object fileNm = fileSavePath.substring(0, fileSavePath.lastIndexOf("."));
                        String fileExt = fileSavePath.substring(fileSavePath.lastIndexOf(".") + 1, fileSavePath.length());
                        String len = ((String)fileNm).substring(((String)fileNm).length() - pos);
                        try {
                            count = Integer.parseInt(len);
                            fileNm = ((String)fileNm).substring(0, ((String)fileNm).length() - pos);
                        }
                        catch (NumberFormatException numberFormatException) {
                            count = 0;
                        }
                        fileNm = (String)fileNm + "(" + ++count;
                        fileSavePath = (String)fileNm + ")." + fileExt;
                        pos = ("" + count).length();
                    } while (file.exists());
                    this.printBaseStockList(fileSavePath);
                    break block10;
                }
                MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)"\uc5d1\uc140\ub85c \ub2e4\uc6b4\ub85c\ub4dc\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.\n \uc800\uc7a5 \ud6c4 \ub2e4\uc2dc \ub20c\ub7ec\uc8fc\uc138\uc694.");
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    private int printBaseStockList(String fileSavePath) throws Exception {
        int i;
        List<List<String>> sheetContents = this.BaseStkDaoToList((List)this.tableViewer.getInput());
        String newfile = fileSavePath;
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFColor color_fail = new XSSFColor();
        color_fail.setIndexed((int)IndexedColors.RED.getIndex());
        XSSFColor color_pass = new XSSFColor();
        color_pass.setIndexed((int)IndexedColors.BLUE.getIndex());
        XSSFColor color_normal = new XSSFColor();
        color_normal.setIndexed((int)IndexedColors.WHITE.getIndex());
        XSSFCellStyle cs_left = workbook.createCellStyle();
        cs_left.setAlignment(HorizontalAlignment.LEFT);
        cs_left.setFillForegroundColor(color_normal);
        cs_left.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        XSSFCellStyle cs_right = workbook.createCellStyle();
        cs_right.setAlignment(HorizontalAlignment.RIGHT);
        cs_right.setFillForegroundColor(color_normal);
        cs_right.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        XSSFCellStyle cs_center = workbook.createCellStyle();
        cs_center.setAlignment(HorizontalAlignment.LEFT);
        cs_center.setFillForegroundColor(color_normal);
        cs_center.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        XSSFSheet sheet = workbook.createSheet("\uae30\ucd08\uc7ac\uace0");
        if (sheet == null) {
            return -1;
        }
        Row row_head = sheet.createRow(0);
        int i2 = 0;
        while (i2 < this.column_name.length) {
            if (i2 != 2) {
                Cell cell = row_head.createCell(i2);
                cell.setCellValue(this.column_name[i2][0]);
                sheet.setColumnWidth(i2, Integer.parseInt(this.column_name[i2][1]) * 10 * 3);
                cell.setCellStyle((CellStyle)cs_center);
            }
            ++i2;
        }
        int rowIdx = 1;
        for (List<String> rowContents : sheetContents) {
            Row row = sheet.createRow(rowIdx);
            i = 0;
            while (i < this.column_name.length) {
                if (i != 2) {
                    Cell cell = row.createCell(i);
                    String value = rowContents.get(i);
                    cell.setCellValue(value);
                    if (i == 1 || i == 2 || i == 3 || i == 7) {
                        cell.setCellStyle((CellStyle)cs_left);
                    } else {
                        cell.setCellStyle((CellStyle)cs_center);
                    }
                }
                ++i;
            }
            ++rowIdx;
        }
        Row row_tail = sheet.createRow(sheetContents.size() + 1);
        Cell cell = row_tail.createCell(0);
        cell.setCellValue("\ud569\uacc4");
        sheet.addMergedRegion(new CellRangeAddress(sheetContents.size() + 1, sheetContents.size() + 1, 0, 3));
        cell.setCellStyle((CellStyle)cs_center);
        ArrayList<Integer> qtyList = new ArrayList<Integer>();
        qtyList.add(this.sumOfQty);
        qtyList.add(this.sumOfRealQty);
        qtyList.add(this.sumOfDiffQty);
        i = 0;
        while (i < 3) {
            Cell cell2 = row_tail.createCell(i + 4);
            cell2.setCellValue((double)((Integer)qtyList.get(i)).intValue());
            sheet.setColumnWidth(i + 4, 3000);
            cell2.setCellStyle((CellStyle)cs_center);
            ++i;
        }
        FileOutputStream fileOut = new FileOutputStream(newfile);
        workbook.write((OutputStream)fileOut);
        fileOut.close();
        MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)("\uc7ac\uace0\ub0b4\uc5ed\uc744 \uc5d1\uc140\ud30c\uc77c\ub85c \uc800\uc7a5\ud558\uc600\uc2b5\ub2c8\ub2e4.\n" + fileSavePath));
        return 0;
    }

    private List<List<String>> BaseStkDaoToList(List<BaseStockDto> listDto) {
        ArrayList<List<String>> resultList = new ArrayList<List<String>>();
        int i = 0;
        while (i < listDto.size()) {
            BaseStockDto dto = listDto.get(i);
            ArrayList<String> list = new ArrayList<String>();
            list.add(dto.getRowno());
            list.add(dto.getProdcd());
            list.add(dto.getProdcd());
            list.add(dto.getProdnm());
            list.add(dto.getSpecdes());
            list.add(dto.getQty());
            list.add(dto.getRealQty());
            list.add(dto.getDiffQty());
            list.add(dto.getReason());
            resultList.add(list);
            ++i;
        }
        return resultList;
    }

    private List<BaseStockDto> ListToBaseStkDao(List<List<String>> list) {
        ArrayList<BaseStockDto> resultList = new ArrayList<BaseStockDto>();
        int i = 0;
        while (i < list.size()) {
            BaseStockDto dto = new BaseStockDto();
            dto.setRowno(list.get(i).get(0));
            dto.setProdcd(list.get(i).get(1));
            dto.setImg(list.get(i).get(1));
            dto.setProdnm(list.get(i).get(3));
            dto.setSpecdes(list.get(i).get(4));
            dto.setQty(list.get(i).get(5));
            dto.setRealQty(list.get(i).get(6));
            dto.setDiffQty(list.get(i).get(7));
            dto.setReason(list.get(i).get(8));
            resultList.add(dto);
            ++i;
        }
        return resultList;
    }

    private void uploadExcelFile() {
        int brandcd = this.bcb_brands.getSelectionValue();
        if (brandcd == -1) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)" \ud2b9\uc815 \ud654\uc8fc(\ud68c\uc0ac)\ub97c \uc120\ud0dd\ud6c4 \uc218\ud589 \ud574\uc8fc\uc138\uc694!.");
            return;
        }
        BaseStockDao dao = new BaseStockDao();
        try {
            if (dao.isExistBasstkmst(this.date, brandcd) && this.lblNewLabel_final.getText().length() > 8 && dao.getRecvDtAndSeq(this.date, brandcd).length() > 8 && this.lblNewLabel_final.getText().length() == dao.getRecvDtAndSeq(this.date, brandcd).length()) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)"\uc774\ubbf8 \uc785\ucd9c\uace0 \ucc98\ub9ac\uac00 \uc644\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                return;
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        FileDialog fileSelectionDialog = MyDataManagerFactory.createExcelFileSelectionDialog();
        fileSelectionDialog.setText("\uc7ac\uace0\ub0b4\uc5ed\uc11c\ucc3e\uae30");
        String filePath = fileSelectionDialog.open();
        if (filePath == null) {
            return;
        }
        this.stockListFullPath = filePath;
        try {
            MyExcelManager readExcelManager = MyDataManagerFactory.createExcelManager(this.stockListFullPath);
            readExcelManager.loadData();
            List<List<String>> sheetContents = readExcelManager.getSheetContents(0, 0);
            sheetContents.remove(sheetContents.size() - 1);
            this.showRealStockList(sheetContents);
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)e.getMessage());
        }
    }

    private void showRealStockList(List<List<String>> origin_Contents) throws Exception {
        if (origin_Contents == null || origin_Contents.size() == 0) {
            this.tableViewer.setInput(null);
            this.tableViewer.refresh();
            if (!this.table.isVisible()) {
                this.table.setVisible(true);
            }
            MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)"\uc0c8\ub85c\uc6b4 \uc7ac\uace0\ub0b4\uc5ed\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.");
            return;
        }
        if (origin_Contents.get(0).size() != 9) {
            MessageDialog.openError((Shell)this.getShell(), (String)TITLE, (String)"\uc7ac\uace0\ub370\uc774\ud130\uc758 \ud615\uc2dd\uc774 \ub9de\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
            return;
        }
        ProcdParseDialog d = new ProcdParseDialog(this.getShell(), origin_Contents);
        d.open();
        List<BaseStockDto> contents = this.ListToBaseStkDao(origin_Contents);
        this.tableViewer.setInput(null);
        this.tableViewer.setInput(contents);
        this.tableViewer.refresh();
        if (!this.table.isVisible()) {
            this.table.setVisible(true);
        }
        this.updateColumnGirdHeader(this.getSumOfQty(contents), this.getSumOfRealQty(contents), this.getSumOfDiffQty(contents));
        this.tableViewer2.refresh();
        System.gc();
        Thread.sleep(100L);
        String filename = this.stockListFullPath.substring(this.stockListFullPath.lastIndexOf(File.separator) + 1, this.stockListFullPath.length());
        StringTokenizer stockDateToken = new StringTokenizer(filename, "_");
        String stockDate = stockDateToken.nextToken();
        if (stockDate.length() == 8 && Integer.parseInt(stockDate.substring(4, 6)) < 13 && Integer.parseInt(stockDate.substring(6, 8)) < 32) {
            this.dt_stkdt.setYear(Integer.parseInt(stockDate.substring(0, 4)));
            this.dt_stkdt.setMonth(Integer.parseInt(stockDate.substring(4, 6)) - 1);
            this.dt_stkdt.setDay(Integer.parseInt(stockDate.substring(6, 8)));
            this.dt_stkdt.update();
        }
        MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)"\uc2e4\uc0ac\ub0b4\uc5ed\uc744 \uac00\uc838\uc654\uc2b5\ub2c8\ub2e4.\n \uc5c5\ub85c\ub4dc\ub97c \ub20c\ub7ec \uc2e4\uc0ac\ub0b4\uc5ed\uc744 \uc7ac\uace0\ud604\ud669\uc5d0 \ub3d9\uae30\ud654\uc2dc\ud0a4\uc138\uc694.");
    }

    private void syncUploadRealStock(String date) {
        int brandcd = this.bcb_brands.getSelectionValue();
        if (brandcd == -1) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)" \ud2b9\uc815 \ud654\uc8fc(\ud68c\uc0ac)\ub97c \uc120\ud0dd\ud6c4 \uc218\ud589 \ud574\uc8fc\uc138\uc694!.");
            return;
        }
        BaseStockDao dao = new BaseStockDao();
        List uploadList = (List)this.tableViewer.getInput();
        try {
            int i = 0;
            while (i < uploadList.size()) {
                String realStkcd = ((BaseStockDto)uploadList.get(i)).getProdcd();
                if (dao.isExistRealStock(brandcd, date, realStkcd)) {
                    dao.updateBaseStock(brandcd, (BaseStockDto)uploadList.get(i), date);
                } else if (dao.isExistRealStockInProdmst(brandcd, ((BaseStockDto)uploadList.get(i)).getProdcd())) {
                    dao.insertRealStock(brandcd, (BaseStockDto)uploadList.get(i), date);
                } else {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)("\ud574\ub2f9 \uc0c1\ud488\uc758 \uc0c1\ud488\ucf54\ub4dc\uac00 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc74c.. \n" + ((BaseStockDto)uploadList.get(i)).getProdcd()));
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.getBaseStockListFromDB("", date);
        MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)"\uc5c5\ub85c\ub4dc\uac00 \uc644\ub8cc \ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
    }

    private void syncUploadRealStock2(String date) {
        BaseStockDao dao = new BaseStockDao();
        List uploadList = (List)this.tableViewer.getInput();
        ArrayList<BaseStockDto> updateList = new ArrayList<BaseStockDto>();
        ArrayList<BaseStockDto> insertList = new ArrayList<BaseStockDto>();
        ArrayList<BaseStockDto> misstList = new ArrayList<BaseStockDto>();
        int brandcd = this.bcb_brands.getSelectionValue();
        if (brandcd == -1) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)" \ud2b9\uc815 \ud654\uc8fc(\ud68c\uc0ac)\ub97c \uc120\ud0dd\ud6c4 \uc218\ud589 \ud574\uc8fc\uc138\uc694!.");
            return;
        }
        try {
            List<BaseStockDto> baseStockList = dao.getProdcutListByDate(1, "", date, brandcd);
            if (dao.isExistBasstkmst(date, brandcd) && this.lblNewLabel_final.getText().length() > 8 && dao.getRecvDtAndSeq(date, brandcd).length() > 8 && this.lblNewLabel_final.getText().length() == dao.getRecvDtAndSeq(date, brandcd).length()) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)"\uc774\ubbf8 \uc785\ucd9c\uace0 \ucc98\ub9ac\uac00 \uc644\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                return;
            }
            if (baseStockList.isEmpty()) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)"\uc800\uc7a5\ub41c \uc7ac\uace0\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.");
                return;
            }
            if (uploadList.isEmpty()) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)"\uc5c5\ub85c\ub4dc\ud560 \uc7ac\uace0 \ubaa9\ub85d\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.");
                return;
            }
            if (dao.isExistBasstkdtl(brandcd, date)) {
                int i = 0;
                while (i < uploadList.size()) {
                    boolean hasInsertRow = true;
                    int j = 0;
                    while (j < baseStockList.size()) {
                        if (((BaseStockDto)uploadList.get(i)).getProdcd().equals(baseStockList.get(j).getProdcd())) {
                            updateList.add((BaseStockDto)uploadList.get(i));
                            hasInsertRow = false;
                            break;
                        }
                        ++j;
                    }
                    if (hasInsertRow) {
                        insertList.add((BaseStockDto)uploadList.get(i));
                    }
                    ++i;
                }
                if (!updateList.isEmpty()) {
                    i = 0;
                    while (i < updateList.size()) {
                        ++i;
                    }
                    dao.updateRealStock(brandcd, updateList, date);
                }
                if (!insertList.isEmpty()) {
                    Object errorcd = "";
                    int i2 = 0;
                    while (i2 < insertList.size()) {
                        if (!dao.isExistRealStockInProdmst(brandcd, ((BaseStockDto)insertList.get(i2)).getProdcd())) {
                            misstList.add((BaseStockDto)insertList.get(i2));
                            errorcd = (String)errorcd + ((BaseStockDto)insertList.get(i2)).getProdcd() + "\n";
                            insertList.remove(i2);
                        }
                        ++i2;
                    }
                    if (!insertList.isEmpty()) {
                        dao.insertRealStock(brandcd, insertList, date);
                    } else {
                        MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)("\uc874\uc7ac\ud558\uc9c0 \uc54a\ub294  \uc0c1\ud488\ucf54\ub4dc\uac00 \uc788\uc2b5\ub2c8\ub2e4..\n " + (String)errorcd));
                    }
                }
                this.getBaseStockListFromDB("", date);
                MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)"\uc5c5\ub85c\ub4dc\uac00 \uc644\ub8cc \ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
            } else {
                MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)"\uc800\uc7a5\ub41c \uc7ac\uace0\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.\n\uc800\uc7a5\uc744 \uba3c\uc800 \ud558\uc2ed\uc2dc\uc624.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void saveBaseStockIntoDB() {
        int brandcd = this.bcb_brands.getSelectionValue();
        if (brandcd == -1) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)" \ud2b9\uc815 \ud654\uc8fc(\ud68c\uc0ac)\ub97c \uc120\ud0dd\ud6c4 \uc218\ud589 \ud574\uc8fc\uc138\uc694!.");
            return;
        }
        this.date = YDMATimeUtil.getOrddtDate(this.dt_stkdt);
        BaseStockDao dao = new BaseStockDao();
        try {
            if (dao.isExistBasstkmst(this.date, brandcd) && this.lblNewLabel_final.getText().length() > 8 && dao.getRecvDtAndSeq(this.date, brandcd).length() > 8 && this.lblNewLabel_final.getText().length() == dao.getRecvDtAndSeq(this.date, brandcd).length()) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)"\uc774\ubbf8 \uc785\ucd9c\uace0 \ucc98\ub9ac\uac00 \uc644\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                return;
            }
            List uploadList = (List)this.tableViewer.getInput();
            if (uploadList == null || uploadList.size() == 0) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)"\uc800\uc7a5\ud560 \uc7ac\uace0\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.");
                return;
            }
            if (dao.isExistBasstkmst(this.date, brandcd)) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)"\uc774\ubbf8 \ub4f1\ub85d\ub418\uc5b4 \uc788\uc2b5\ub2c8\ub2e4.");
                return;
            }
            String msg = this.date.substring(0, 4) + "-" + this.date.substring(4, 6) + "-" + this.date.substring(6, 8) + "\uc758 \uc7ac\uace0 \ub0b4\uc5ed\uc744 \uc5c5\ub85c\ub4dc\ud558\uc2dc\uaca0\uc2b5\ub2c8\uae4c?";
            if (MessageDialog.openQuestion((Shell)this.getShell(), (String)TITLE, (String)msg)) {
                dao.processBaseStkMstDtlInsert(brandcd, uploadList, this.date);
                MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)"\uc800\uc7a5\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
            } else {
                MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)"\ucde8\uc18c\ud558\uc600\uc2b5\ub2c8\ub2e4.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)e.getMessage());
        }
    }

    private void setConfirmBaseStock() {
        int brandcd = this.bcb_brands.getSelectionValue();
        if (brandcd == -1) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)" \ud2b9\uc815 \ud654\uc8fc(\ud68c\uc0ac)\ub97c \uc120\ud0dd\ud6c4 \uc218\ud589 \ud574\uc8fc\uc138\uc694!.");
            return;
        }
        this.date = YDMATimeUtil.getOrddtDate(this.dt_stkdt);
        BaseStockDao dao = new BaseStockDao();
        try {
            if (!dao.isExistBasstkmst(this.date, brandcd)) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)(this.date.substring(0, 4) + "-" + this.date.substring(4, 6) + "-" + this.date.substring(6, 8) + "\uc5d0 \uc800\uc7a5\ub41c \uae30\ucd08\uc7ac\uace0\uac00 \uc5c6\uc2b5\ub2c8\ub2e4. \n \uc800\uc7a5 \ud6c4 \ub2e4\uc2dc \uc2dc\ub3c4\ud574 \uc8fc\uc2ed\uc2dc\uc624."));
                return;
            }
            YDMAStringUtil.Print(this.lblNewLabel_final.getText().length() + " " + dao.getRecvDtAndSeq(this.date, brandcd).length());
            if (dao.isExistBasstkmst(this.date, brandcd) && this.lblNewLabel_final.getText().length() > 8 && dao.getRecvDtAndSeq(this.date, brandcd).length() > 8 && this.lblNewLabel_final.getText().length() == dao.getRecvDtAndSeq(this.date, brandcd).length()) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)"\uc774\ubbf8 \uc785\ucd9c\uace0 \ucc98\ub9ac\uac00 \uc644\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                return;
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        String msg = this.date.substring(0, 4) + "-" + this.date.substring(4, 6) + "-" + this.date.substring(6, 8) + "\uc758 \uc7ac\uace0\ucc28\uc774\ub97c \ud655\uc815\ud558\uc2dc\uaca0\uc2b5\ub2c8\uae4c?";
        if (MessageDialog.openQuestion((Shell)this.getShell(), (String)TITLE, (String)msg)) {
            try {
                dao.insertBaseStockByDateID(brandcd, this.date);
                this.getBaseStockListFromDB("", this.date);
                YDMAStringUtil.Print("\uc7ac\uace0\ucc28\uc774 \ud655\uc815 : " + dao.getRecvDtAndSeq(this.date, brandcd));
                if (dao.isExistBasstkmst(this.date, brandcd) && this.lblNewLabel_final.getText().length() != 0 && dao.getRecvDtAndSeq(this.date, brandcd).length() > 8) {
                    this.lblNewLabel_final.setText(dao.getRecvDtAndSeq(this.date, brandcd));
                    this.lblNewLabel_final.redraw();
                    YDMAStringUtil.Print("\uc7ac\uace0\ucc28\uc774 \ud655\uc815 redraw");
                }
                MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)"\uc7ac\uace0\ucc28\uc774\uac00 \ud655\uc815\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void sortBaseStockList(List<BaseStockDto> dtoList) {
        Collections.sort(dtoList, new Comparator<BaseStockDto>(){

            @Override
            public int compare(BaseStockDto obj1, BaseStockDto obj2) {
                return obj1.getProdcd().compareToIgnoreCase(obj2.getProdcd());
            }
        });
        int i = 0;
        while (i < dtoList.size()) {
            dtoList.get(i).setRowno(Integer.toString(i + 1));
            ++i;
        }
    }

    private void deleteAllMstDtl() {
        int brandcd = this.bcb_brands.getSelectionValue();
        if (brandcd == -1) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)" \ud2b9\uc815 \ud654\uc8fc(\ud68c\uc0ac)\ub97c \uc120\ud0dd\ud6c4 \uc218\ud589 \ud574\uc8fc\uc138\uc694!.");
            return;
        }
        this.date = YDMATimeUtil.getOrddtDate(this.dt_stkdt);
        BaseStockDao dao = new BaseStockDao();
        try {
            if (!dao.isExistBasstkdtl(brandcd, this.date)) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)"\uc0ad\uc81c\ud560 \uc7ac\uace0\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.");
                return;
            }
            if (dao.getRecvDtAndSeq(this.date, brandcd).length() < 8) {
                String msg = this.date.substring(0, 4) + "-" + this.date.substring(4, 6) + "-" + this.date.substring(6, 8) + "\uc758 \uc804\uccb4 \uc7ac\uace0\ub97c \uc0ad\uc81c\ud558\uc2dc\uaca0\uc2b5\ub2c8\uae4c?";
                if (MessageDialog.openQuestion((Shell)this.getShell(), (String)TITLE, (String)msg)) {
                    dao.deleteBaseStkMst(brandcd, this.date);
                    dao.deleteBaseStkDtl(brandcd, this.date);
                    MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)"\uc7ac\uace0\ub97c \uc0ad\uc81c\ud558\uc600\uc2b5\ub2c8\ub2e4.");
                    this.getBaseStockListFromDB("", this.date);
                } else {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)"\uc804\uc7ac \uc7ac\uace0 \uc0ad\uc81c\ub97c \ucde8\uc18c\ud558\uc600\uc2b5\ub2c8\ub2e4.");
                }
            } else {
                MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)"\uc7ac\uace0\ub97c \uc0ad\uc81c\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \n\uc7ac\uace0 \uc0ad\uc81c\ub294 \uc785\uace0\ubc88\ud638\uac00 \uc5c6\ub294 \uacbd\uc6b0\ub9cc \uac00\ub2a5\ud569\ub2c8\ub2e4.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void blockSaveButton(String date) {
        int brandcd = this.bcb_brands.getSelectionValue();
        if (brandcd == -1) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)" \ud2b9\uc815 \ud654\uc8fc(\ud68c\uc0ac)\ub97c \uc120\ud0dd\ud6c4 \uc218\ud589 \ud574\uc8fc\uc138\uc694!.");
            return;
        }
        BaseStockDao dao = new BaseStockDao();
        try {
            if (dao.isExistBasstkmst(date, brandcd)) {
                this.btn_save.setEnabled(false);
                this.btn_save.update();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class BaseStkContentProvider
    extends ArrayContentProvider
    implements IStructuredContentProvider {
        BaseStkContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Object[]) {
                return (Object[])inputElement;
            }
            if (inputElement instanceof Collection) {
                return ((Collection)inputElement).toArray();
            }
            return new Object[0];
        }
    }

    class BaseStkLableProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        BaseStkLableProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            BaseStockDto dto = (BaseStockDto)element;
            String value = "";
            switch (columnIndex) {
                case 0: {
                    value = dto.getRowno();
                    break;
                }
                case 1: {
                    value = dto.getProdcd();
                    break;
                }
                case 2: {
                    value = dto.getProdcd();
                    break;
                }
                case 3: {
                    value = dto.getProdnm();
                    break;
                }
                case 4: {
                    value = dto.getSpecdes();
                    break;
                }
                case 5: {
                    value = dto.getQty();
                    break;
                }
                case 6: {
                    value = dto.getRealQty();
                    break;
                }
                case 7: {
                    dto.setDiffQty(Integer.toString(Integer.parseInt(dto.getQty() == null ? "0" : dto.getQty()) - Integer.parseInt(dto.getRealQty() == null ? "0" : dto.getRealQty())));
                    value = dto.getDiffQty();
                    break;
                }
                case 8: {
                    value = dto.getReason();
                    break;
                }
                default: {
                    value = "";
                }
            }
            return value;
        }

        public Color getForeground(Object element, int columnIndex) {
            return null;
        }

        public Color getBackground(Object element, int columnIndex) {
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            Image imgValue = null;
            if (columnIndex == 2) {
                BaseStockDto dto = (BaseStockDto)element;
                String SRC_FILE = String.format("%s\\%s%s", BaseStockManager.this.img_path, dto.getImg(), ".jpg");
                try {
                    imgValue = YMDAResourceManager.getImage(SRC_FILE.trim());
                    YMDAResourceManager.dispose();
                }
                catch (NullPointerException nullPointerException) {
                    imgValue = null;
                }
            }
            return imgValue;
        }
    }
}

