/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.stream.Collectors;

public class SequenceResolver<T> {
    private ListWithIterator<T> primaryList;
    private List<ListWithIterator<T>> secondaryLists;
    private Set<T> processedItems;

    public List<T> getSequence(List<T> primary, List<List<T>> secondary) {
        T item;
        this.prepareDataStructures(primary, secondary);
        ArrayList<T> order = new ArrayList<T>();
        while ((item = this.getNextItem()) != null) {
            this.processedItems.add(item);
            this.advanceIterator(this.primaryList.iterator);
            for (ListWithIterator<T> secondaryList : this.secondaryLists) {
                this.advanceIterator(secondaryList.iterator);
            }
            order.add(item);
        }
        return order;
    }

    private void prepareDataStructures(List<T> primary, List<List<T>> secondary) {
        this.primaryList = new ListWithIterator<T>(primary);
        this.secondaryLists = secondary.stream().map(ListWithIterator::new).collect(Collectors.toList());
        this.processedItems = new HashSet<T>();
    }

    private T getNextItem() {
        Candidate<T>[] candidates = this.getTopCandidates();
        switch (candidates.length) {
            case 0: {
                return null;
            }
            case 1: {
                return candidates[0].item;
            }
        }
        int i = 0;
        while (i < candidates.length) {
            if (candidates[i].isPrimary) {
                return candidates[i].item;
            }
            ++i;
        }
        return candidates[0].item;
    }

    private Candidate<T>[] getTopCandidates() {
        Candidate<T>[] candidates = this.getEligibleCandidates();
        this.rankCandidates(candidates);
        if (candidates.length > 0) {
            int topRank = candidates[0].rank;
            int i = 1;
            while (i < candidates.length) {
                if (candidates[i].rank < topRank) {
                    topRank = candidates[i].rank;
                }
                ++i;
            }
            ArrayList<Candidate<T>> topCandidates = new ArrayList<Candidate<T>>();
            int i2 = 0;
            while (i2 < candidates.length) {
                if (candidates[i2].rank == topRank) {
                    topCandidates.add(candidates[i2]);
                }
                ++i2;
            }
            return this.toCandidatesArray(topCandidates);
        }
        return candidates;
    }

    private Candidate<T>[] getEligibleCandidates() {
        Candidate<T>[] allCandidates = this.getAllCandidates();
        Candidate<T> primary = null;
        int i = 0;
        while (i < allCandidates.length) {
            if (allCandidates[i].isPrimary) {
                primary = allCandidates[i];
                break;
            }
            ++i;
        }
        if (primary != null) {
            ArrayList<Candidate<T>> eligibleCandidates = new ArrayList<Candidate<T>>(allCandidates.length);
            eligibleCandidates.add(primary);
            Set primarySet = Collections.singleton(primary.item);
            int i2 = 0;
            while (i2 < allCandidates.length) {
                Candidate<T> c = allCandidates[i2];
                if (c != primary && this.countPrecedingItems(c.item, primary.src, primarySet) == 0) {
                    eligibleCandidates.add(c);
                }
                ++i2;
            }
            return this.toCandidatesArray(eligibleCandidates);
        }
        return allCandidates;
    }

    private Candidate<T>[] getAllCandidates() {
        ArrayList<Candidate<T>> candidates = new ArrayList<Candidate<T>>();
        Object item = this.getNextItem(this.primaryList.iterator);
        if (item != null) {
            Candidate c = new Candidate();
            c.item = item;
            c.isPrimary = true;
            c.src = this.primaryList.list;
            candidates.add(c);
        }
        for (ListWithIterator<T> secondary : this.secondaryLists) {
            item = this.getNextItem(secondary.iterator);
            if (item == null) continue;
            Candidate c = new Candidate();
            c.item = item;
            c.isPrimary = false;
            c.src = secondary.list;
            if (candidates.contains(c)) continue;
            candidates.add(c);
        }
        return this.toCandidatesArray(candidates);
    }

    private Candidate<T>[] toCandidatesArray(List<Candidate<T>> candidates) {
        return candidates.toArray(new Candidate[candidates.size()]);
    }

    private void rankCandidates(Candidate<T>[] candidates) {
        HashSet candidateItems = new HashSet();
        int i = 0;
        while (i < candidates.length) {
            candidateItems.add(candidates[i].item);
            ++i;
        }
        i = 0;
        while (i < candidates.length) {
            Candidate<T> c = candidates[i];
            int j = 0;
            while (j < candidates.length) {
                c.rank += this.countPrecedingItems(c.item, candidates[j].src, candidateItems);
                ++j;
            }
            ++i;
        }
    }

    private int countPrecedingItems(Object item, List<?> list, Set<?> set) {
        int count = 0;
        for (Object next : list) {
            if (next.equals(item)) {
                return count;
            }
            if (!set.contains(next)) continue;
            ++count;
        }
        return 0;
    }

    private T getNextItem(ListIterator<T> iter) {
        if (iter.hasNext()) {
            T next = iter.next();
            iter.previous();
            return next;
        }
        return null;
    }

    private void advanceIterator(ListIterator<T> iter) {
        while (iter.hasNext()) {
            T item = iter.next();
            if (this.processedItems.contains(item)) continue;
            iter.previous();
            break;
        }
    }

    private static class Candidate<T> {
        public T item;
        public boolean isPrimary;
        public int rank;
        public List<?> src;

        private Candidate() {
        }

        public boolean equals(Object obj) {
            return this.item.equals(obj);
        }

        public int hashCode() {
            return this.item.hashCode();
        }
    }

    private record ListWithIterator<T>(List<T> list, ListIterator<T> iterator) {
        public ListWithIterator(List<T> list) {
            this(list, list.listIterator());
        }
    }
}

