/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.helper;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JsonHelper {
    public static boolean isExistsJsonObjectKey(JsonObject jsonObject, String key) {
        return jsonObject.has(key);
    }

    public static String jsonStringOrDefault(JsonObject jsonObject, String key) {
        if (jsonObject.has(key)) {
            return jsonObject.get(key).getAsString();
        }
        return "";
    }

    public static String jsonNullStr(JsonElement val) {
        if (val.isJsonNull()) {
            return "";
        }
        return val.getAsString();
    }

    public static String jsonElementNullInt(JsonElement val) {
        if (val == null || val.isJsonNull()) {
            return "0";
        }
        return String.format("%.0f", Double.parseDouble(val.getAsString()));
    }

    public static List<List<String>> parseShopContent(String json) {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode root = mapper.readTree(json);
            JsonNode shopNode = root.get("shop");
            if (shopNode != null && shopNode.isObject()) {
                Iterator it = shopNode.fields();
                while (it.hasNext()) {
                    Map.Entry entry = (Map.Entry)it.next();
                    String shopKey = (String)entry.getKey();
                    JsonNode seqArray = (JsonNode)entry.getValue();
                    for (JsonNode seqNode : seqArray) {
                        result.add(Arrays.asList(shopKey, seqNode.asText()));
                    }
                }
            }
        }
        catch (Exception exception) {}
        return result;
    }
}

