/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.helper;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.shop.jcef.CookieMapModel;
import com.kdjsystem.mlink.yellim.shop.jcef.KaKaoLoginPopup;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class LoginPopupHelper {
    static boolean isNotHasCookie = true;
    static String val = "";
    static CookieMapModel model = null;

    private static String getCookieFileName(String shopcd, String loginid, String authKey) {
        String fileName = Arrays.asList(shopcd, loginid, authKey).stream().map(p -> p.isEmpty() ? "blank" : p).collect(Collectors.joining("_", "", ".txt"));
        return fileName;
    }

    public static String readFileLines(String filePath) throws IOException {
        File file = new File(filePath);
        if (!file.exists()) {
            return "";
        }
        List<String> lines = Files.readAllLines(Paths.get(filePath, new String[0]), StandardCharsets.UTF_8);
        StringBuffer sb = new StringBuffer();
        for (String line : lines) {
            sb.append(line);
        }
        if (file.delete()) {
            YDMAStringUtil.Print("File deleted successfully");
        } else {
            YDMAStringUtil.Print("Failed to delete the file");
        }
        return sb.toString();
    }

    private static String getLoginEncoder(String shopcd, String id, String pw, String authKey, boolean isClose) {
        String ret = "";
        ObjectMapper mapper = new ObjectMapper();
        BrowserConfig browserConfig = ShopConfig.builder(shopcd, id, pw, authKey, isClose).build();
        try {
            String json = mapper.writeValueAsString((Object)browserConfig);
            ret = Base64.getEncoder().encodeToString(json.getBytes());
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static String getCookies(String shopcd, String id, String pw, String authKey) {
        return LoginPopupHelper.getCookies(shopcd, id, pw, authKey, true);
    }

    public static String getCookies(String shopcd, String id, String pw, String authKey, boolean isClose) {
        try {
            String param = LoginPopupHelper.getLoginEncoder(shopcd, id, pw, authKey, isClose);
            LoginPopupHelper.login(param);
            return LoginPopupHelper.readFileLines(LoginPopupHelper.getCookieFileName(shopcd, id, authKey));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return "";
    }

    public static void login(String param) throws IOException, InterruptedException {
        block9: {
            Path currentPath = Paths.get("", new String[0]);
            currentPath.toAbsolutePath().toString();
            String cmd = String.format("java -jar mlinkBroswer.jar %s ", param);
            Runtime run = Runtime.getRuntime();
            Process p = null;
            try {
                try {
                    p = run.exec(cmd);
                    StreamGobbler gb1 = new StreamGobbler(p.getInputStream());
                    StreamGobbler gb2 = new StreamGobbler(p.getErrorStream());
                    gb1.start();
                    gb2.start();
                    while (gb1.isAlive() || gb2.isAlive()) {
                    }
                    YDMAStringUtil.Print("Thread gb1 Status : " + String.valueOf((Object)gb1.getState()));
                    YDMAStringUtil.Print("Thread gb2 Status : " + String.valueOf((Object)gb1.getState()));
                    p.waitFor();
                }
                catch (Exception e) {
                    YDMAStringUtil.Print(e.toString());
                    if (p != null) {
                        p.destroy();
                    }
                    break block9;
                }
            }
            catch (Throwable throwable) {
                if (p != null) {
                    p.destroy();
                }
                throw throwable;
            }
            if (p != null) {
                p.destroy();
            }
        }
        YDMAStringUtil.Print(" test------");
    }

    public static Map<String, String> convertToMapCookie(String val) {
        HashMap<String, String> mapRet = new HashMap<String, String>();
        for (String s : Arrays.asList(val.split(";"))) {
            String[] item = s.split("=");
            if (item.length != 2) continue;
            mapRet.put(item[0], item[1]);
        }
        return mapRet;
    }

    public static String getCookies(String shopcd, String id, String pw) {
        KaKaoLoginPopup.getInstance(shopcd, id, pw, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                isNotHasCookie = false;
                val = e.getActionCommand();
                YDMAStringUtil.Print("============================");
                YDMAStringUtil.Print("\ucfe0\ud0a4" + val);
                YDMAStringUtil.Print("============================");
            }
        });
        KaKaoLoginPopup.getInstance().setSize(400, 600);
        KaKaoLoginPopup.getInstance().setVisible(true);
        while (isNotHasCookie) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
        }
        if (!isNotHasCookie) {
            isNotHasCookie = true;
            KaKaoLoginPopup.getInstance().close();
        }
        return val;
    }

    private static class BrowserConfig {
        private String shopcd;
        private String loginid;
        private String passwd;
        private String authkey;
        private String defaultUrl;
        private String loginSuccesUrl;
        private String script;
        private boolean isClose;

        private BrowserConfig() {
        }

        public boolean isClose() {
            return this.isClose;
        }

        public void setClose(boolean isClose) {
            this.isClose = isClose;
        }

        public String getShopcd() {
            return this.shopcd;
        }

        public void setShopcd(String shopcd) {
            this.shopcd = shopcd;
        }

        public String getLoginid() {
            return this.loginid;
        }

        public void setLoginid(String loginid) {
            this.loginid = loginid;
        }

        public String getPasswd() {
            return this.passwd;
        }

        public void setPasswd(String passwd) {
            this.passwd = passwd;
        }

        public String getAuthkey() {
            return this.authkey;
        }

        public void setAuthkey(String authkey) {
            this.authkey = authkey;
        }

        public String getDefaultUrl() {
            return this.defaultUrl;
        }

        public void setDefaultUrl(String defaultUrl) {
            this.defaultUrl = defaultUrl;
        }

        public String getLoginSuccesUrl() {
            return this.loginSuccesUrl;
        }

        public void setLoginSuccesUrl(String loginSuccesUrl) {
            this.loginSuccesUrl = loginSuccesUrl;
        }

        public String getScript() {
            return this.script;
        }

        public void setScript(String script) {
            this.script = script;
        }
    }

    private static class ShopConfig {
        BrowserConfig config;

        public static ShopConfig builder(String shopcd, String id, String pw, String authKey, boolean isClose) {
            BrowserConfig config = new BrowserConfig();
            config.setShopcd(shopcd);
            config.setLoginid(id);
            config.setPasswd(pw);
            config.setAuthkey(authKey);
            config.setClose(isClose);
            return new ShopConfig(config);
        }

        public ShopConfig(BrowserConfig config) {
            this.config = config;
            this.setDefaultUrl(config.shopcd);
            this.setSuccesUrl(config.shopcd);
            this.setScript(config.shopcd);
        }

        public BrowserConfig build() {
            return this.config;
        }

        public void setDefaultUrl(String shopcd) {
            switch (shopcd) {
                case "shop0273": {
                    this.config.setDefaultUrl("https://accounts.kakao.com/login/?continue=https%253A%252F%252Fshopping-sell.kakao.com%252Fhub#login");
                    break;
                }
                case "shop0287": {
                    this.config.setDefaultUrl("https://wpartner.wemakeprice.com");
                    break;
                }
                case "shop0372": {
                    this.config.setDefaultUrl("https://store.lotteon.com/cm/main/login_SO.wsp");
                    break;
                }
                case "shop0411": {
                    this.config.setDefaultUrl("https://po.ssgadm.com");
                    break;
                }
                case "shop0003": {
                    this.config.setDefaultUrl("https://login.11st.co.kr/auth/front/selleroffice/login.tmall?returnURL=https://soffice.11st.co.kr");
                    break;
                }
                case "shop00031": {
                    this.config.setDefaultUrl("https://login.11st.co.kr/auth/front/selleroffice/login.tmall?returnURL=https://soffice.11st.co.kr");
                    break;
                }
                case "shop0075": {
                    this.config.setDefaultUrl("https://wing.coupang.com/login?ui_locales=&returnUrl=https%3A%2F%2Fwing.coupang.com%2F");
                }
            }
        }

        public void setSuccesUrl(String shopcd) {
            switch (shopcd) {
                case "shop0273": {
                    this.config.setLoginSuccesUrl("https://shopping-sell.kakao.com/hub");
                    break;
                }
                case "shop0287": {
                    this.config.setLoginSuccesUrl("https://wpartner.wemakeprice.com/main");
                    break;
                }
                case "shop0372": {
                    this.config.setLoginSuccesUrl("https://store.lotteon.com/cm/main/index_SO.wsp");
                    break;
                }
                case "shop0411": {
                    this.config.setLoginSuccesUrl("https://po.ssgadm.com/main.ssg");
                    break;
                }
                case "shop0003": {
                    this.config.setLoginSuccesUrl("https://soffice.11st.co.kr/view/main");
                    break;
                }
                case "shop00031": {
                    this.config.setLoginSuccesUrl("https://soffice.11st.co.kr/view/main");
                    break;
                }
                case "shop0075": {
                    this.config.setLoginSuccesUrl("https://wing.coupang.com/");
                }
            }
        }

        public void setScript(String shopcd) {
            switch (shopcd) {
                case "shop0273": {
                    this.config.setScript(this.getKakaoBrowserScript().toString());
                    break;
                }
                case "shop0287": {
                    this.config.setScript(this.getWemarketBrowserScript().toString());
                    break;
                }
                case "shop0372": {
                    this.config.setScript(this.getLotteOnBrowserScript().toString());
                    break;
                }
                case "shop0411": {
                    this.config.setScript(ShopConfig.getSSGBrowserScript().toString());
                    break;
                }
                case "shop0003": {
                    this.config.setScript(this.get11stBrowserScript().toString());
                    break;
                }
                case "shop00031": {
                    this.config.setScript(this.get11stBrowserScript().toString());
                    break;
                }
                case "shop0075": {
                    this.config.setScript(this.getCoupangBrowserScript().toString());
                }
            }
        }

        private StringBuilder get11stBrowserScript() {
            StringBuilder stringBuilder = new StringBuilder();
            String idxPath = "//*[@id=\"loginName\"]";
            String pwxPath = "//*[@id=\"passWord\"]";
            String btxPath = "//*[@id=\"loginbutton\"]";
            stringBuilder.append(String.format("var _id = document.evaluate('%s', document, null, XPathResult.FIRST_ORDERED_NODE_TYPE, null).singleNodeValue; \r\n", idxPath));
            stringBuilder.append(String.format("var _pw = document.evaluate('%s', document, null, XPathResult.FIRST_ORDERED_NODE_TYPE, null).singleNodeValue; \r\n", pwxPath));
            stringBuilder.append(String.format("var _btn = document.evaluate('%s', document, null, XPathResult.FIRST_ORDERED_NODE_TYPE, null).singleNodeValue; \r\n", btxPath));
            stringBuilder.append(String.format(" _id.value = '%s'; \r\n", "kdj.id"));
            stringBuilder.append(String.format(" _pw.value = '%s'; \r\n", "kdj.pw"));
            stringBuilder.append(" $('button.c-button.c-button--submit').trigger('click'); ");
            return stringBuilder;
        }

        private StringBuilder getWemarketBrowserScript() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("var setIdAndPw = function(){ ");
            stringBuilder.append("\t\tvar _loginId = document.querySelector('input[name=loginid]'); ");
            stringBuilder.append("\t\tvar _loginPw = document.querySelector('input[name=loginpassword]'); ");
            stringBuilder.append("\t\tvar _captchaInput = document.getElementById('_captchaWord'); ");
            stringBuilder.append("\t\tif (_loginId && _loginPw) { ");
            stringBuilder.append("\t\t_loginId.value = 'kdj.id'; ");
            stringBuilder.append("\t\t_loginPw.value = 'kdj.pw'; ");
            stringBuilder.append("\t\t\tdocument.querySelector('body > .wrap').style.minWidth = 'unset'; ");
            stringBuilder.append("\t\t\t_captchaInput.focus(); ");
            stringBuilder.append("\t\t} else { ");
            stringBuilder.append("\t\t\tsetTimeout(setIdAndPw, 500); ");
            stringBuilder.append("\t\t} ");
            stringBuilder.append("\t}; ");
            stringBuilder.append("\tsetIdAndPw(); ");
            return stringBuilder;
        }

        private StringBuilder getLotteOnBrowserScript() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(" let lotteLogin = new Promise((resolve, reject) => { \r\n");
            stringBuilder.append("    setTimeout(()=> { \r\n");
            stringBuilder.append(" $('#mf_loginUserId').val('kdj.id');   \r\n");
            stringBuilder.append(" $('#mf_sct_passwd').val('kdj.pw');  \r\n");
            stringBuilder.append("  resolve(true);   \r\n");
            stringBuilder.append("   resolve(true); \r\n");
            stringBuilder.append(" }, 1000) \r\n");
            stringBuilder.append(" });  \r\n");
            stringBuilder.append("lotteLogin.then((successMessage) => { \r\n");
            stringBuilder.append("          $('#mf_btn_login').get(0).click(); \r\n");
            stringBuilder.append("  }); \r\n");
            return stringBuilder;
        }

        private static StringBuilder getSSGBrowserScript() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(" let ssGLogin = new Promise((resolve, reject) => { \r\n");
            stringBuilder.append("    setTimeout(()=> { \r\n");
            stringBuilder.append("    $('#userId').val('kdj.id'); \r\n");
            stringBuilder.append("$('#userPwd').val('kdj.pw'); \r\n");
            stringBuilder.append("resolve(true); \r\n");
            stringBuilder.append("}, 100); \r\n");
            stringBuilder.append("}); \r\n");
            stringBuilder.append(" ssGLogin.then((successMessage) => { \r\n");
            stringBuilder.append(" $('.set_btn > a').get(0).click(); \r\n");
            stringBuilder.append("}); \r\n");
            return stringBuilder;
        }

        private StringBuilder getKakaoBrowserScript() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("  let kakaoLogin = new Promise((resolve, reject) => {   \r\n");
            stringBuilder.append("\t\tsetTimeout(()=> {   \r\n");
            stringBuilder.append("\t\tdocument.querySelector('#loginId--1').focus()  \r\n");
            stringBuilder.append("\t\tdocument.execCommand('insertText', false, 'kdj.id');  \r\n");
            stringBuilder.append("\t\tdocument.querySelector('#password--2').focus()  \r\n");
            stringBuilder.append("\t\tdocument.execCommand('insertText', false, 'kdj.pw');  \r\n");
            stringBuilder.append("\t\tresolve(true);     \r\n");
            stringBuilder.append("\t}, 1000)   \r\n");
            stringBuilder.append("\t});    \r\n");
            stringBuilder.append("\tkakaoLogin.then((successMessage) => {   \r\n");
            stringBuilder.append("\t\tdocument.querySelector('#mainContent > div > div > form > div.confirm_btn > button.btn_g.highlight.submit').click();  \r\n");
            stringBuilder.append("\t});   \r\n");
            return stringBuilder;
        }

        private StringBuilder getCoupangBrowserScript() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("  let coupangLogin = new Promise((resolve, reject) => {   \r\n");
            stringBuilder.append("\t\tsetTimeout(()=> {   \r\n");
            stringBuilder.append("\t\tdocument.querySelector('#username').value = 'kdj.id'  \r\n");
            stringBuilder.append("\t\tdocument.querySelector('#password').value = 'kdj.pw'  \r\n");
            stringBuilder.append("\t\tresolve(true);     \r\n");
            stringBuilder.append("\t}, 1000)   \r\n");
            stringBuilder.append("\t});    \r\n");
            stringBuilder.append("\tcoupangLogin.then((successMessage) => {   \r\n");
            stringBuilder.append("\t\tdocument.querySelector('#kc-login').click();  \r\n");
            stringBuilder.append("\t});   \r\n");
            return stringBuilder;
        }
    }

    private static class StreamGobbler
    extends Thread {
        InputStream is;
        String value = "";

        public StreamGobbler(InputStream is) {
            this.is = is;
        }

        @Override
        public void run() {
            try {
                String line;
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                while ((line = br.readLine()) != null) {
                    YDMAStringUtil.Print(line);
                }
            }
            catch (IOException ioe) {
                YDMAStringUtil.Print(ioe);
            }
        }
    }
}

