/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.kdjsystem.mlink.yellim.code.MallCode;
import com.kdjsystem.mlink.yellim.common.YDMASessonUtil;
import com.kdjsystem.mlink.yellim.common.YDMATimeUtil;
import com.kdjsystem.mlink.yellim.dao.CategoryDAO;
import com.kdjsystem.mlink.yellim.dao.DomemallDAO;
import com.kdjsystem.mlink.yellim.dao.ProductDAO;
import com.kdjsystem.mlink.yellim.dto.CategoryDTO;
import com.kdjsystem.mlink.yellim.dto.DomemallDTO;
import com.kdjsystem.mlink.yellim.dto.ProductAddProcessDTO;
import com.kdjsystem.mlink.yellim.dto.ProductDTO;
import com.kdjsystem.mlink.yellim.dto.ProductOptionDTO;
import com.kdjsystem.mlink.yellim.dto.ResultProcessDTO;
import com.kdjsystem.mlink.yellim.dto.ShoppingmallDTO;
import com.kdjsystem.mlink.yellim.factory.IProductAddProcess;
import com.kdjsystem.mlink.yellim.helper.DateHelper;
import com.kdjsystem.mlink.yellim.shop.data.gsshop.GsShopApiClient;
import com.kdjsystem.mlink.yellim.shop.data.gsshop.GsShopRows;
import com.kdjsystem.mlink.yellim.ui.CommonProgressDialog;
import com.kdjsystem.mlink.yellim.ui.ProductAddDialog;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IProgressMonitor;

public class GsShopProductAddService
implements IProductAddProcess {
    @Override
    public ResultProcessDTO addProcess(ProductAddProcessDTO dto) throws Exception {
        boolean flag = true;
        int pageIdx = 1;
        int infoRet = 0;
        int inRet = 0;
        int rowsPerPage = 50;
        ShoppingmallDTO shopInfo = dto.getSHOPINFO();
        List<DomemallDTO> domemallInfos = DomemallDAO.get().selectDomemallInfos();
        String shopInfoLog = String.format("[%s - %s(%s)]", shopInfo.getSHOPNM(), shopInfo.getSHOPPINGID(), shopInfo.getNICKNM1());
        String date = DateHelper.getCurrentTimeString();
        this.setValue(String.format("%s %s \uc1fc\ud551\ubab0 \uc0c1\ud488 \ub370\uc774\ud130 \ucd94\uac00\ub97c \uc9c4\ud589\ud569\ub2c8\ub2e4.", date, shopInfoLog), 0);
        String startDate = GsShopProductAddService.convertDateFormat(dto.getSTART_DATE());
        String endDate = GsShopProductAddService.convertDateFormat(dto.getEND_DATE());
        Map<String, String> cookies = dto.getCOOKIES();
        String baseUrl = "https://withgs.gsshop.com/prd/prdRegModifyList_M/list";
        try {
            while (flag) {
                List<ProductDTO> responseProducts;
                LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
                params.put("coGoodsCond", "1");
                params.put("coGoodsNmCond", "1");
                params.put("setInfo1", "");
                params.put("setInfo2", "");
                params.put("setInfo3", "Y");
                params.put("setInfo4", "Y");
                params.put("setInfo5", "Y");
                params.put("coSetDe", "0");
                params.put("coSetMd", "0");
                params.put("coSetSh", "0");
                params.put("coSetQa", "0");
                params.put("coGoodsTxt", "");
                params.put("coGoodsNmTxt", "");
                params.put("coMediaType", "");
                params.put("blckPrd", "");
                params.put("regSubj", "");
                params.put("dpatOpVal", "");
                params.put("saleEndRsnCd", "");
                params.put("clsChkStCd", "");
                params.put("mdId", "");
                params.put("rowsPerPage", String.valueOf(rowsPerPage));
                params.put("dateFrom", startDate);
                params.put("dateTo", endDate);
                params.put("pageIdx", String.valueOf(pageIdx));
                params.put("pageRange", "10");
                GsShopRows rows = GsShopApiClient.search(baseUrl, params, cookies);
                if (rows.getTotalCount() == 0) {
                    this.setValue("\uc120\ud0dd\ud55c \ub0a0\uc9dc\uc5d0 \ud574\ub2f9\ub418\ub294 \ub370\uc774\ud130\uac00 \uc5c6\uc2b5\ub2c8\ub2e4. \uc0c1\ud488 \ucd94\uac00\ub97c \uc885\ub8cc\ud569\ub2c8\ub2e4.", 100);
                    return new ResultProcessDTO(0, "", infoRet, inRet);
                }
                List<Map<String, String>> productList = this.getProds(rows);
                if (productList.size() < rowsPerPage) {
                    flag = false;
                }
                if ((responseProducts = this.getProductDetail(productList, shopInfo, cookies, domemallInfos, shopInfoLog)).size() > 0) {
                    this.setValue(String.format(" %s \ud398\uc774\uc9c0 %s\uac74\uc744 DB\uc5d0 \uc800\uc7a5\ud569\ub2c8\ub2e4.", pageIdx, responseProducts.size()), 0);
                    for (ProductDTO product2 : responseProducts) {
                        if (ProductAddDialog.getIsCanceled()) {
                            return new ResultProcessDTO(0, "", infoRet, inRet);
                        }
                        ProductDTO copyProduct = ProductDAO.get().selectProductInfo(product2.getCompayny_goods_cd());
                        if (copyProduct == null) {
                            ret = ProductDAO.get().insertProductInfo(product2);
                            if (ret == 1) {
                                infoRet += ret;
                                String comment = String.format(" [%s] \ub9c8\uc2a4\ud130 \uc0c1\ud488 \uc800\uc7a5 \uc644\ub8cc", product2.getCompayny_goods_cd());
                                this.setValueProd(comment, 50, product2, null, "YEL_ADD", "\uc131\uacf5", "[\uc6b4\uc601\uc0c1\ud488\uad00\ub9ac - \uc0c1\ud488\ucd94\uac00] \ub9c8\uc2a4\ud130 \uc0c1\ud488\uc774 \ucd94\uac00\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", false);
                            }
                        } else {
                            copyProduct.setClass_cd3(product2.getClass_cd3());
                            copyProduct.setShop_cid_info(product2.getShop_cid_info());
                            ret = ProductDAO.get().updateProductInfo(copyProduct);
                            if (ret == 1) {
                                infoRet += ret;
                                String comment = String.format(" [%s] \ub9c8\uc2a4\ud130 \uc0c1\ud488 \uc218\uc815 \uc644\ub8cc", product2.getCompayny_goods_cd());
                                this.setValueProd(comment, 50, product2, null, "YEL_ADD", "\uc131\uacf5", "[\uc6b4\uc601\uc0c1\ud488\uad00\ub9ac - \uc0c1\ud488\ucd94\uac00] \ub9c8\uc2a4\ud130 \uc0c1\ud488\uc774 \uc774\ubbf8 \uc874\uc7ac\ud558\uc5ec \uc0c1\ud0dc\uac00 \uc218\uc815\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", false);
                            }
                        }
                        copyProduct = ProductDAO.get().selectProductInfo(product2.getCompayny_goods_cd());
                        ProductDTO copyProductIn = ProductDAO.get().selectProductIn(shopInfo, copyProduct.getPRODSEQ());
                        if (copyProductIn == null) {
                            product2.setPRODSEQ(copyProduct.getPRODSEQ());
                            int ret = ProductDAO.get().insertProductIn(product2);
                            if (ret == 1) {
                                inRet += ret;
                                String comment = String.format(" %s [%s] \uc1fc\ud551\ubab0 \uc0c1\ud488 \uc800\uc7a5 \uc644\ub8cc", shopInfoLog, product2.getCompayny_goods_cd());
                                this.setValueProd(comment, 50, product2, shopInfo, "YEL_ADD", "\uc131\uacf5", "[\uc6b4\uc601\uc0c1\ud488\uad00\ub9ac - \uc0c1\ud488\ucd94\uac00] \uc0c1\ud488\uc774 \uc5e0\ub9c1\ud06c\uc5d0 \ucd94\uac00\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", true);
                            }
                        } else {
                            copyProductIn.setClass_cd3(product2.getClass_cd3());
                            copyProductIn.setShop_cid_info(product2.getShop_cid_info());
                            copyProductIn.setGoods_nm(product2.getGoods_nm());
                            copyProductIn.setShopprodno(product2.getShopprodno());
                            copyProductIn.setDelv_r_cost(product2.getDelv_r_cost());
                            copyProductIn.setSaleenddt(product2.getSaleenddt());
                            copyProductIn.setMarket_price(product2.getMarket_price());
                            copyProductIn.setGoods_price(product2.getGoods_price());
                            copyProductIn.setGoods_consumer_price(product2.getGoods_consumer_price());
                            copyProductIn.setCompayny_goods_cd(product2.getCompayny_goods_cd());
                            copyProductIn.setSaleStatusCd(product2.getSaleStatusCd());
                            copyProductIn.setStdPrdYn(product2.getStdPrdYn());
                            copyProductIn.setStatus(product2.getStatus());
                            copyProductIn.setSendstats(product2.getSendstats());
                            String codeDivision = domemallInfos.stream().filter(p -> p.getCODE_DIVISION().equals(MallCode.getDomeMallProductCodeDivision(product2.getCompayny_goods_cd()))).map(p -> p.getSHOPCD()).findFirst().orElse("");
                            copyProductIn.setGoods_keyword(codeDivision);
                            int ret = ProductDAO.get().updateProductIn(copyProductIn);
                            if (ret == 1) {
                                inRet += ret;
                                String comment = String.format(" %s [%s] \uc1fc\ud551\ubab0 \uc0c1\ud488 \uc218\uc815 \uc644\ub8cc", shopInfoLog, product2.getCompayny_goods_cd());
                                this.setValueProd(comment, 50, product2, shopInfo, "YEL_ADD", "\uc131\uacf5", "[\uc6b4\uc601\uc0c1\ud488\uad00\ub9ac - \uc0c1\ud488\ucd94\uac00] \uc0c1\ud488\uc774 \uc774\ubbf8 \uc874\uc7ac\ud558\uc5ec \uc0c1\ud0dc\uac00 \uc5e0\ub9c1\ud06c\uc5d0\uc11c \uc218\uc815\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", true);
                            }
                        }
                        copyProductIn = ProductDAO.get().selectProductIn(shopInfo, copyProduct.getPRODSEQ());
                        if (product2.getOPTIONS() == null) continue;
                        for (ProductOptionDTO option2 : product2.getOPTIONS()) {
                            ProductOptionDTO copyOption = ProductDAO.get().selectOptProductInfo(copyProduct.getPRODSEQ(), option2.getSKUSEQ());
                            if (copyOption == null) {
                                option2.setPRODSEQ(Integer.parseInt(copyProduct.getPRODSEQ()));
                                option2.setCOMPAYNY_GOODS_CD(product2.getCompayny_goods_cd());
                                ProductDAO.get().insertOptProductInfo(option2);
                            } else {
                                copyOption.setCOMPAYNY_GOODS_CD(product2.getCompayny_goods_cd());
                                copyOption.setOPTPRODCD(option2.getOPTPRODCD());
                                copyOption.setOPTPRODNM(option2.getOPTPRODNM());
                                copyOption.setOPTSPECDES(option2.getOPTSPECDES());
                                copyOption.setOPTEA(option2.getOPTEA());
                                copyOption.setOPTSAFESTOCK(option2.getOPTSAFESTOCK());
                                copyOption.setOPTVERTSTOCK(option2.getOPTVERTSTOCK());
                                copyOption.setOPTADDAMT(option2.getOPTADDAMT());
                                copyOption.setINSERTDT(option2.getINSERTDT());
                                copyOption.setINSERTID(option2.getINSERTID());
                                copyOption.setMODIFYDT(option2.getMODIFYDT());
                                copyOption.setSTATUS(option2.getSTATUS());
                            }
                            ProductOptionDTO copyOptionIn = ProductDAO.get().selectOptProductIn(copyProductIn.getSENDSEQ(), option2.getSKUSEQ());
                            if (copyOptionIn == null) {
                                option2.setSENDSEQ(Integer.parseInt(copyProductIn.getSENDSEQ()));
                                option2.setPRODSEQ(Integer.parseInt(copyProduct.getPRODSEQ()));
                                ProductDAO.get().insertOptProductIn(option2);
                                continue;
                            }
                            copyOptionIn.setSHOPPRODNO(option2.getSHOPPRODNO());
                            copyOptionIn.setSHOPPRODSKU(option2.getSHOPPRODSKU());
                            copyOptionIn.setSHOPPRODSKU_NM(option2.getSHOPPRODSKU_NM());
                            copyOptionIn.setOPTPRODCD(option2.getOPTPRODCD());
                            copyOptionIn.setOPTPRODNM(option2.getOPTPRODNM());
                            copyOptionIn.setOPTSPECDES(option2.getOPTSPECDES());
                            copyOptionIn.setOPTEA(option2.getOPTEA());
                            copyOptionIn.setOPTSAFESTOCK(option2.getOPTSAFESTOCK());
                            copyOptionIn.setOPTVERTSTOCK(option2.getOPTVERTSTOCK());
                            copyOptionIn.setOPTADDAMT(option2.getOPTADDAMT());
                            copyOptionIn.setINSERTDT(option2.getINSERTDT());
                            copyOptionIn.setINSERTID(option2.getINSERTID());
                            copyOptionIn.setMODIFYDT(option2.getMODIFYDT());
                            copyOptionIn.setSTATUS(option2.getSTATUS());
                        }
                    }
                }
                ++pageIdx;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String errorMessage = ex.getMessage() != null ? ex.getMessage() : "\uc54c \uc218 \uc5c6\ub294 \uc624\ub958 \ubc1c\uc0dd";
            this.setValue(String.format("%s %s %s", date, shopInfoLog, errorMessage), 100);
            this.setValue("--------------------------------------------------------------------------------------", 100);
            return new ResultProcessDTO(-1, "", 0, 0);
        }
        this.setValue(String.format("%s %s \ucd1d %s\uac74\uc758 \uc0c1\ud488 \ub370\uc774\ud130 \ucd94\uac00\ub97c \uc644\ub8cc\ud588\uc2b5\ub2c8\ub2e4.", date, shopInfoLog, inRet), 100);
        this.setValue("--------------------------------------------------------------------------------------", 100);
        return new ResultProcessDTO(0, "", infoRet, inRet);
    }

    @Override
    public ResultProcessDTO addProcess(ProductAddProcessDTO dto, List<String> specificCodes) throws Exception {
        return null;
    }

    @Override
    public ResultProcessDTO addProcess2(ProductAddProcessDTO proDto, List<String> specificCodes, IProgressMonitor monitor, ShoppingmallDTO dto) throws Exception {
        return null;
    }

    private List<ProductDTO> getProductDetail(List<Map<String, String>> productList, ShoppingmallDTO shoppingmallDTO, Map<String, String> cookies, List<DomemallDTO> domemallInfos, String shopInfoLog) {
        ArrayList<ProductDTO> responseProducts = new ArrayList<ProductDTO>();
        try {
            int i = 0;
            while (i < productList.size()) {
                if (ProductAddDialog.getIsCanceled()) {
                    return responseProducts;
                }
                String suppGoodsCode = productList.get(i).get("suppGoodsCode");
                String goodsCode = productList.get(i).get("goodsCode");
                String suppCode = shoppingmallDTO.getSHOPPINGID();
                String status2 = productList.get(i).get("status");
                String saleEndDate = productList.get(i).get("saleEndDate");
                HashMap<String, Object> lgecScmProduct = new HashMap<String, Object>();
                lgecScmProduct.put("suppCode", suppCode);
                lgecScmProduct.put("suppGoodsCode", suppGoodsCode);
                lgecScmProduct.put("goodsCode", goodsCode);
                HashMap<String, Object> lgecScmUpdateRequest = new HashMap<String, Object>();
                lgecScmUpdateRequest.put("suppCode", suppCode);
                lgecScmUpdateRequest.put("suppGoodsCode", suppGoodsCode);
                lgecScmUpdateRequest.put("subDesc", "10");
                lgecScmUpdateRequest.put("goodsName", "");
                lgecScmUpdateRequest.put("ecPrdName1", "");
                lgecScmUpdateRequest.put("ecPrdName2", "");
                lgecScmUpdateRequest.put("ecPrdName3", "");
                lgecScmUpdateRequest.put("prdNmStrDt", "");
                lgecScmUpdateRequest.put("prdNmEndDt", "");
                lgecScmUpdateRequest.put("prdPrcStrDt", "");
                lgecScmUpdateRequest.put("prdNmMinute", "");
                lgecScmUpdateRequest.put("prdNmMinute2", "");
                lgecScmUpdateRequest.put("prdPrcMinute", "");
                lgecScmUpdateRequest.put("requestMemo", "");
                JsonNode root = GsShopApiClient.searchProdDetail(cookies, lgecScmProduct, lgecScmUpdateRequest);
                JsonNode result = root.path("result");
                JsonNode reqImageList = root.path("reqImageList");
                ProductDTO productDTO = this.buildGsShopResultDTO(goodsCode, suppGoodsCode, result, reqImageList, status2, saleEndDate, shoppingmallDTO, domemallInfos, cookies);
                responseProducts.add(productDTO);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return responseProducts;
    }

    private ProductDTO buildGsShopResultDTO(String goodsCode, String suppGoodsCode, JsonNode result, JsonNode reqImageList, String status2, String saleEndDate, ShoppingmallDTO shoppingmallDTO, List<DomemallDTO> domemallInfos, Map<String, String> cookies) {
        ArrayList<ProductDTO> responseProducts = new ArrayList<ProductDTO>();
        ProductDTO responseProduct = new ProductDTO();
        try {
            responseProduct.setShopcd("shop0007");
            responseProduct.setShopseq(String.valueOf(shoppingmallDTO.getSHOPSEQ()));
            responseProduct.setSHOP_USERID(String.valueOf(shoppingmallDTO.getSHOPPINGID()));
            responseProduct.setShopprodno(goodsCode);
            responseProduct.setGoods_nm(result.path("goodsDesc").asText(""));
            responseProduct.setCompayny_goods_cd(suppGoodsCode);
            responseProduct.setMarket_price(result.path("khsPrice").asText(""));
            responseProduct.setGoods_price(result.path("khsPrice").asText(""));
            responseProduct.setGoods_consumer_price(result.path("khsPrice").asText(""));
            if (reqImageList != null && reqImageList.isArray() && reqImageList.size() > 0) {
                responseProduct.setInsertdt(reqImageList.get(0).path("enterDateTime").asText(""));
            } else {
                responseProduct.setInsertdt(YDMATimeUtil.getCurrentTimeByYDFormat());
            }
            responseProduct.setModifyid(responseProduct.getInsertdt());
            responseProduct.setSaleenddt(saleEndDate + " 23:59:59");
            responseProduct.setStatus(this.getStatus(status2));
            responseProduct.setSendstats(this.getSendStatus(status2));
            String codeDivision = domemallInfos.stream().filter(p -> p.getCODE_DIVISION().equals(MallCode.getDomeMallProductCodeDivision(responseProduct.getCompayny_goods_cd()))).map(p -> p.getSHOPCD()).findFirst().orElse("");
            responseProduct.setGoods_keyword(codeDivision);
            String classCode = String.join((CharSequence)"", result.path("class1").asText(), result.path("class2").asText(), result.path("class3").asText(), result.path("class4").asText());
            String classDesc = Stream.of(result.path("class1Desc").asText(""), result.path("class2Desc").asText(""), result.path("class3Desc").asText(""), result.path("class4Desc").asText("")).filter(s -> !s.isBlank()).collect(Collectors.joining(">"));
            CategoryDTO category = this.getCategory(classCode, classDesc, shoppingmallDTO);
            responseProduct.setClass_cd3(category.getCODE());
            responseProduct.setShop_cid_info(category.getSHOPCATE_JSON());
            responseProduct.setGmcategnm(classDesc);
            responseProduct.setBrand_nm(result.path("brandName").asText(""));
            responseProduct.setModel_no(result.path("suppModelCode").asText(""));
            responseProduct.setMaker(result.path("factoryName").asText(""));
            responseProduct.setOrigin(result.path("nativeCountry").asText(""));
            String prodType = result.path("prodType").asText("");
            if ("S".equals(prodType)) {
                List<ProductOptionDTO> options = this.getOption(responseProduct, cookies);
                responseProduct.setOPTIONS(options);
                String[] optionNames = options.stream().map(p -> p.getOPTPRODNM()).findFirst().orElse("").split("/");
                if (optionNames.length == 1) {
                    responseProduct.setChar_1_nm(optionNames[0]);
                } else if (optionNames.length == 2) {
                    responseProduct.setChar_1_nm(optionNames[0]);
                    responseProduct.setChar_2_nm(optionNames[1]);
                }
            } else {
                responseProduct.setChar_1_nm("\ub2e8\ud488");
                responseProduct.setChar_1_val("");
                responseProduct.setChar_2_nm("");
                responseProduct.setChar_2_val("");
            }
            responseProducts.add(responseProduct);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return responseProduct;
    }

    private List<ProductOptionDTO> getOption(ProductDTO responseProduct, Map<String, String> cookies) {
        ArrayList<ProductOptionDTO> options = new ArrayList<ProductOptionDTO>();
        try {
            JsonNode root = GsShopApiClient.searchProdOpt(cookies, responseProduct);
            JsonNode lgecScmPrditmList = root.path("lgecScmPrditmList");
            JsonNode styleHeader = root.path("styleHeader");
            String attrTitle1 = styleHeader.path("attrTitle1").asText();
            String attrTitle2 = styleHeader.path("attrTitle2").asText();
            if (lgecScmPrditmList.isArray()) {
                int i = 0;
                while (i < lgecScmPrditmList.size()) {
                    JsonNode item = lgecScmPrditmList.get(i);
                    ProductOptionDTO option2 = new ProductOptionDTO();
                    option2.setSKUSEQ(i + 1);
                    option2.setSHOPPRODNO(responseProduct.getShopprodno());
                    option2.setSHOPPRODSKU(item.path("variantsCode").asText());
                    option2.setSHOPPRODSKU_NM(responseProduct.getGoods_nm());
                    option2.setPRODCD(responseProduct.getCompayny_goods_cd());
                    option2.setOPTPRODCD(responseProduct.getCompayny_goods_cd().concat("-" + String.valueOf(i + 1)));
                    String color = item.path("colorDesc").asText();
                    if ("None".equals(item.path("sizeDesc").asText())) {
                        option2.setOPTPRODNM(attrTitle1);
                        option2.setOPTSPECDES(color);
                    } else {
                        String size = item.path("sizeDesc").asText();
                        option2.setOPTPRODNM(attrTitle1 + ":" + attrTitle2);
                        option2.setOPTSPECDES(color + ":" + size);
                    }
                    option2.setOPTSAFESTOCK(Integer.parseInt(responseProduct.getGoods_price()));
                    option2.setOPTVERTSTOCK(Integer.parseInt(item.path("ordQty").asText()));
                    option2.setOPTADDAMT(0);
                    option2.setINSERTDT(responseProduct.getInsertdt());
                    option2.setINSERTID(YDMASessonUtil.getUserInfo().getUserId());
                    String optStatus = item.path("saleCloseTxt").asText();
                    option2.setSTATUS("N".equals(optStatus) ? "0" : "1");
                    options.add(option2);
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            options = null;
        }
        return options;
    }

    private CategoryDTO getCategory(String classCode, String classDesc, ShoppingmallDTO shopInfo) {
        try {
            String[] names = classDesc.split(">");
            String lastName = names[names.length - 1].trim();
            CategoryDTO category = CategoryDAO.get().selectShoppingMallCategory(classCode, lastName);
            if (category == null && (category = CategoryDAO.get().selectShoppingMallCategory(classCode)) == null) {
                category = CategoryDAO.get().selectCategory("350119000");
            }
            return category;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String getStatus(String saleStatusCd) {
        switch (saleStatusCd) {
            case "\ud310\ub9e4\uc911": {
                return "0";
            }
            case "\uc77c\uc2dc\ud488\uc808": {
                return "1";
            }
            case "\ud310\ub9e4\uc885\ub8cc": {
                return "3";
            }
        }
        return "";
    }

    private String getSendStatus(String saleStatusCd) {
        switch (saleStatusCd) {
            case "\ud310\ub9e4\uc911": {
                return String.valueOf(8000);
            }
            case "\uc77c\uc2dc\ud488\uc808": {
                return String.valueOf(4000);
            }
            case "\ud310\ub9e4\uc885\ub8cc": {
                return String.valueOf(3000);
            }
        }
        return "";
    }

    private List<Map<String, String>> getProds(GsShopRows rows) {
        ArrayList<Map<String, String>> prodList = new ArrayList<Map<String, String>>();
        int i = 0;
        while (i < rows.getRows().size()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("status", rows.getRows().get(i).getCells().get(1));
            map.put("suppGoodsCode", rows.getRows().get(i).getCells().get(3));
            map.put("goodsCode", rows.getRows().get(i).getCells().get(4));
            map.put("saleEndDate", rows.getRows().get(i).getCells().get(24));
            prodList.add(map);
            ++i;
        }
        return prodList;
    }

    public static String convertDateFormat(String date) {
        if (date == null || date.isEmpty()) {
            return "";
        }
        LocalDate localDate = LocalDate.parse(date);
        return localDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
    }

    private void setValue(String message, int value) {
        CommonProgressDialog.get().setValue(message, value);
    }

    private void setValueProd(String title, int value, ProductDTO item, ShoppingmallDTO shopInfo, String jobType, String jobResult, String logMsg, boolean isProdIn) {
        CommonProgressDialog.get().setValueProd(title, value, item, shopInfo, jobType, jobResult, logMsg, isProdIn);
    }
}

