/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonObject;
import com.kdjsystem.mlink.yellim.code.MallCode;
import com.kdjsystem.mlink.yellim.common.FtpUtil;
import com.kdjsystem.mlink.yellim.common.YDMAProperties;
import com.kdjsystem.mlink.yellim.common.YDMASessonUtil;
import com.kdjsystem.mlink.yellim.dao.ProductDAO;
import com.kdjsystem.mlink.yellim.dto.ProductDTO;
import com.kdjsystem.mlink.yellim.dto.ProductModifyProcessDTO;
import com.kdjsystem.mlink.yellim.dto.ProductOptionDTO;
import com.kdjsystem.mlink.yellim.dto.ResultProcessDTO;
import com.kdjsystem.mlink.yellim.dto.ShoppingmallDTO;
import com.kdjsystem.mlink.yellim.factory.IProductModifyProcess;
import com.kdjsystem.mlink.yellim.protocol.InterParkProduct;
import com.kdjsystem.mlink.yellim.protocol.InterParkProductDetailDto;
import com.kdjsystem.mlink.yellim.protocol.InterParkProductOption;
import com.kdjsystem.mlink.yellim.protocol.InterParkProductOptionList;
import com.kdjsystem.mlink.yellim.protocol.InterParkUpdateOptionRequest;
import com.kdjsystem.mlink.yellim.shop.common.IProductModifyStatusApi;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductAdditionDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductSendDto;
import com.kdjsystem.mlink.yellim.ui.CommonProgressDialog;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class InterParkProductModifyService
extends IProductModifyStatusApi
implements IProductModifyProcess {
    private static final String \ud310\ub9e4\uc7ac\uac1c = "01";
    private static final String \ud310\ub9e4\uc911\uc9c0 = "03";
    private static final String \ud310\ub9e4\uc0c1\ud488\uc0ad\uc81c = "98";

    @Override
    public ResultProcessDTO modifyProcess(ProductModifyProcessDTO dto, String jobType, String logMsg) throws Exception {
        String shopInfoLog = String.format("[%s - %s(%s)]", dto.getSHOPINFO().getSHOPNM(), dto.getSHOPINFO().getSHOPPINGID(), dto.getSHOPINFO().getNICKNM1());
        ProductDTO prodInfo = dto.getPRODUCT();
        ShoppingmallDTO shopInfo = dto.getSHOPINFO();
        boolean flag = true;
        try {
            switch (dto.getPROCESS_STATUS()) {
                case 4100: {
                    flag = this.setProductmdoifyStatusApi(prodInfo, shopInfo, \ud310\ub9e4\uc911\uc9c0);
                    if (!flag) {
                        return new ResultProcessDTO(-1, "", dto.getPRODUCT().getSENDSEQ());
                    }
                    this.logProductInDetail(shopInfoLog, prodInfo, "\ud310\ub9e4\uc911\ub2e8", shopInfo, "\uc131\uacf5", "YEL_DIS_AUT", "\uc0c1\ud488\uc744 \uc1fc\ud551\ubab0\uc5d0\uc11c \ud310\ub9e4\uc911\ub2e8 \ucc98\ub9ac\ud588\uc2b5\ub2c8\ub2e4.");
                    break;
                }
                case 4200: {
                    flag = this.setProductmdoifyStatusApi(dto.getPRODUCT(), dto.getSHOPINFO(), \ud310\ub9e4\uc7ac\uac1c);
                    if (flag) break;
                    return new ResultProcessDTO(-1, "", dto.getPRODUCT().getSENDSEQ());
                }
                case 3000: 
                case 4000: {
                    flag = this.setProductmdoifyStatusApi(dto.getPRODUCT(), dto.getSHOPINFO(), \ud310\ub9e4\uc0c1\ud488\uc0ad\uc81c);
                    if (!flag) {
                        return new ResultProcessDTO(-1, "", dto.getPRODUCT().getSENDSEQ());
                    }
                    this.logProductInDetail(shopInfoLog, dto.getPRODUCT(), "\uc0ad\uc81c", dto.getSHOPINFO(), "\uc131\uacf5", jobType, logMsg);
                }
            }
            dto.getPRODUCT().setResult_code("1");
            return new ResultProcessDTO(0, "\uc815\uc0c1\uc801\uc73c\ub85c \ucc98\ub9ac\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", dto.getPRODUCT().getSENDSEQ());
        }
        catch (Exception e) {
            return new ResultProcessDTO(-1, e.getMessage(), dto.getPRODUCT().getSENDSEQ());
        }
    }

    private boolean setProductmdoifyStatusApi(ProductDTO dto, ShoppingmallDTO shoppingMallDetailDto, String status2) {
        ProductBuyzleStatChange reg = new ProductBuyzleStatChange();
        reg.item.prdNo = dto.getShopprodno();
        reg.item.saleStatTp = status2;
        reg.item.prdNm = dto.getGoods_nm();
        reg.item.saleUnitcost = dto.getGoods_price();
        try {
            String xml = reg.getXml();
            String templatefilename = this.setXmlFile(xml);
            StringBuffer response = new StringBuffer();
            ArrayList<String> callback = new ArrayList<String>();
            HttpURLConnection httpConnection = null;
            URL obj = null;
            String xmlfile = "http://" + YDMAProperties.getInstance().getAppProperty("ftp.host") + "/xmldir/" + templatefilename;
            String url = String.format("http://ipss1.buyzle.co.kr/openapi/product/ProductAPIService.do?_method=UpdateProductAPIData&citeKey=%s&secretKey=%s&dataUrl=%s", shoppingMallDetailDto.getEDITAUTHKEY1(), shoppingMallDetailDto.getEDITAPIKEY(), xmlfile);
            obj = new URL(url);
            httpConnection = (HttpURLConnection)obj.openConnection();
            int responseCode = httpConnection.getResponseCode();
            if (responseCode == 200) {
                BufferedReader buffReader = new BufferedReader(new InputStreamReader(httpConnection.getInputStream(), "euc-kr"));
                String inputLine = null;
                while ((inputLine = buffReader.readLine()) != null) {
                    response.append(inputLine);
                }
                buffReader.close();
            }
            httpConnection.disconnect();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            ByteArrayInputStream bis = new ByteArrayInputStream(response.toString().getBytes());
            Document doc = db.parse(bis);
            Node n = doc.getFirstChild();
            NodeList nl = n.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                Node an = nl.item(i);
                if (an.getNodeType() == 1) {
                    NodeList nl2 = an.getChildNodes();
                    int i2 = 0;
                    while (i2 < nl2.getLength()) {
                        Node an2 = nl2.item(i2);
                        if (an2.hasChildNodes()) {
                            callback.add(an2.getTextContent());
                        }
                        ++i2;
                    }
                }
                ++i;
            }
            String remoteDir = YDMAProperties.getInstance().getAppProperty("ftp.webpath");
            FtpUtil.deletefile(remoteDir, templatefilename);
            File deleteFile = new File(YDMASessonUtil.getAppPath() + "\\YDwmsData\\" + templatefilename);
            if (deleteFile.exists()) {
                deleteFile.delete();
            }
            boolean flag = this.isNumeric((String)callback.get(0));
            return flag;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean isNumeric(String str) {
        try {
            Double.parseDouble(str);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    private String setXmlFile(String xml) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(new InputSource(new StringReader(xml)));
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("encoding", "euc-kr");
        transformer.setOutputProperty("indent", "yes");
        DOMSource DOMsource = new DOMSource(doc);
        Random random = new Random();
        random.setSeed(System.currentTimeMillis());
        int anum = random.nextInt();
        String localfile = YDMASessonUtil.getAppPath() + "\\YDwmsData\\EditProductInterPark" + YDMASessonUtil.getCompnoInfo().getCompno() + YDMASessonUtil.getUserInfo().getUserId() + Integer.toString(anum) + ".xml";
        StreamResult result = new StreamResult(new File(localfile));
        transformer.transform(DOMsource, result);
        String remoteDir = YDMAProperties.getInstance().getAppProperty("ftp.webpath");
        String templatefilename = FtpUtil.upload(remoteDir, localfile);
        return templatefilename;
    }

    @Override
    public boolean deleteProduct(ProductDTO shopProductDto) throws Exception {
        return false;
    }

    @Override
    public boolean modifyProductStatusDto(ProductDTO shopProductDto, ShopProductAdditionDto dtllist, ShoppingmallDTO shoppingMallDetailDto, String status2, ShopProductSendDto shopProductSendDto, Map<String, String> loginCookies) throws Exception {
        return true;
    }

    @Override
    public boolean isExistProdNo(ProductDTO dto, ShoppingmallDTO shoppingMallDetailDto, Map<String, String> cookies) throws Exception {
        return false;
    }

    @Override
    public ResultProcessDTO optionModifyProcess(ProductModifyProcessDTO dto) throws Exception {
        ArrayList<ProductOptionDTO> requestOptions = new ArrayList<ProductOptionDTO>();
        try {
            List<ProductOptionDTO> options = dto.getPRODUCT().getOPTIONS();
            List<ProductOptionDTO> oldOptions = ProductDAO.get().selectOptProductIn(dto.getPRODUCT().getSENDSEQ());
            for (ProductOptionDTO oldOption : oldOptions) {
                ProductOptionDTO filter = options.stream().filter(p -> p.getSENDSEQ() == oldOption.getSENDSEQ() && p.getSKUSEQ() == oldOption.getSKUSEQ()).findFirst().orElse(null);
                if (filter != null) {
                    oldOption.setOPTVERTSTOCK(0);
                }
                requestOptions.add(oldOption);
            }
            options.sort((p1, p2) -> Integer.compare(p1.getSKUSEQ(), p2.getSKUSEQ()));
            String json = this.getOptionModifyJson(requestOptions);
            Connection.Response response = Jsoup.connect((String)MallCode.getInterParkOptionModifyURL(dto.getPRODUCT().getShopprodno())).cookies(dto.getCOOKIES()).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36").referrer("https://seller.interpark.com/views/products/search").header("Host", "seller.interpark.com").header("Content-Type", "application/json;charset=UTF-8").method(Connection.Method.PUT).requestBody(json).followRedirects(true).ignoreHttpErrors(true).followRedirects(true).ignoreContentType(true).execute();
            JsonObject bodyObj = jsonParser.parse(response.body()).getAsJsonObject();
            if (bodyObj.get("code").getAsInt() == 200) {
                return new ResultProcessDTO(0, bodyObj.get("message").getAsString(), dto.getPRODUCT().getCompayny_goods_cd());
            }
            return new ResultProcessDTO(-1, bodyObj.get("message").getAsString(), dto.getPRODUCT().getCompayny_goods_cd());
        }
        catch (Exception e) {
            return new ResultProcessDTO(-1, e.getMessage(), dto.getPRODUCT().getCompayny_goods_cd());
        }
    }

    private String getOptionModifyJson(List<ProductOptionDTO> options) {
        try {
            InterParkProductDetailDto productDetailDto = new InterParkProductDetailDto();
            productDetailDto.setOptPrirTp(\ud310\ub9e4\uc7ac\uac1c);
            InterParkProduct product2 = new InterParkProduct();
            product2.setProductDetailDto(productDetailDto);
            product2.setOptStkMgtYn("Y");
            ArrayList<InterParkProductOption> productOptions = new ArrayList<InterParkProductOption>();
            ArrayList<InterParkProductOptionList> productOptionLists = new ArrayList<InterParkProductOptionList>();
            for (ProductOptionDTO option2 : options) {
                String[] names = option2.getOPTPRODNM().split("/");
                String[] vals = option2.getOPTSPECDES().split("/");
                InterParkProductOption productOption = new InterParkProductOption();
                InterParkProductOptionList productOptionList = new InterParkProductOptionList();
                productOptionList.setOptMainImg("");
                productOptionList.setOriginOptMainImg("");
                productOptionList.setOptDtlImg1("");
                productOptionList.setOriginOptDtlImg1("");
                productOptionList.setOptDtlImg2("");
                productOptionList.setOriginOptDtlImg2("");
                productOptionList.setOptDtlImg3("");
                productOptionList.setOriginOptDtlImg3("");
                productOptionList.setOptDtlImg4("");
                productOptionList.setOriginOptDtlImg4("");
                productOptionList.setOptDtlImg5("");
                productOptionList.setOriginOptDtlImg5("");
                if (names.length == 1) {
                    productOption.setOptItemNm(option2.getOPTSPECDES());
                    productOption.setOptItemNm2(null);
                    productOptionList.setOptNm(names[0]);
                    productOptionList.setOptNm2(null);
                    productOptionList.setOptItemNm(vals[0]);
                    productOptionList.setOptNo("0");
                    productOptionList.setPrdNo(option2.getSHOPPRODSKU());
                    productOptionList.setOptTp(option2.getOPTVERTSTOCK() > 0 ? \ud310\ub9e4\uc7ac\uac1c : "02");
                    productOptionList.setAddPrice(String.valueOf(option2.getOPTADDAMT()));
                    productOptionList.setSalePossRestQty(String.valueOf(option2.getOPTVERTSTOCK()));
                    productOptionList.setSaleLmtQty("999");
                    productOptionList.setExternalPrdNo(option2.getOPTPRODCD());
                } else if (names.length == 2) {
                    productOption.setOptItemNm(vals[0]);
                    productOption.setOptItemNm2(vals[1]);
                    productOptionList.setOptNm(names[0]);
                    productOptionList.setOptNm2(names[1]);
                    productOptionList.setOptItemNm(vals[0]);
                    productOptionList.setOptItemNm2(vals[1]);
                    productOptionList.setOptNo("0");
                    productOptionList.setPrdNo(option2.getSHOPPRODSKU());
                    productOptionList.setOptTp(option2.getOPTVERTSTOCK() > 0 ? \ud310\ub9e4\uc7ac\uac1c : "02");
                    productOptionList.setAddPrice(String.valueOf(option2.getOPTADDAMT()));
                    productOptionList.setSalePossRestQty(String.valueOf(option2.getOPTVERTSTOCK()));
                    productOptionList.setSaleLmtQty("999");
                    productOptionList.setExternalPrdNo(option2.getOPTPRODCD());
                }
                productOptions.add(productOption);
                productOptionLists.add(productOptionList);
            }
            InterParkUpdateOptionRequest request2 = new InterParkUpdateOptionRequest();
            request2.setProduct(product2);
            request2.setProductOption(productOptions);
            request2.setProductOptionList(productOptionLists);
            ObjectMapper objectMapper = new ObjectMapper();
            return objectMapper.writeValueAsString((Object)request2);
        }
        catch (Exception exception) {
            return "";
        }
    }

    private void logProductInDetail(String shopInfoLog, ProductDTO prodInfo, String action, ShoppingmallDTO shoppingmallDTO, String jobResult, String jobType, String logMsg) {
        String comment = String.format(" %s [%s]\n \u2192 \uc0c1\ud488\uc744 \uc1fc\ud551\ubab0\uc5d0\uc11c %s \ucc98\ub9ac\ud588\uc2b5\ub2c8\ub2e4.", shopInfoLog, prodInfo.getCompayny_goods_cd(), action);
        CommonProgressDialog.get().setValueBackProd(comment, 50, prodInfo, shoppingmallDTO, jobType, jobResult, logMsg, true);
    }

    static final class AdaptorCDATA
    extends XmlAdapter<String, String> {
        AdaptorCDATA() {
        }

        public String marshal(String v) throws Exception {
            return "<![CDATA[" + v + "]]>";
        }

        public String unmarshal(String v) throws Exception {
            return v;
        }
    }

    @XmlRootElement(name="result")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    private static final class ProductBuyzleStatChange {
        @XmlElement(name="title")
        private String title = "Buyzle Product API";
        @XmlElement(name="description")
        private String description = "\uc0c1\ud488 \uc218\uc815";
        @XmlElement(name="item")
        private modifyItem item = new modifyItem();

        private ProductBuyzleStatChange() {
        }

        public String getXml() throws JAXBException {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ProductBuyzleStatChange.class});
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("jaxb.encoding", (Object)"euc-kr");
            StringWriter writer = new StringWriter();
            marshaller.marshal((Object)this, (Writer)writer);
            String theXML = writer.toString().replaceAll("&lt;", "<").replaceAll("&gt;", ">");
            return theXML;
        }
    }

    private static class modifyItem {
        @XmlElement(name="prdNo")
        private String prdNo;
        @XmlElement(name="saleStatTp")
        private String saleStatTp;
        @XmlElement(name="prdNm")
        @XmlJavaTypeAdapter(value=AdaptorCDATA.class)
        private String prdNm;
        @XmlElement(name="saleUnitcost")
        private String saleUnitcost;

        private modifyItem() {
        }
    }
}

