/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.service;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.yellim.code.MallCode;
import com.kdjsystem.mlink.yellim.common.YDMASessonUtil;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.common.YDMATimeUtil;
import com.kdjsystem.mlink.yellim.dao.CategoryDAO;
import com.kdjsystem.mlink.yellim.dao.DomemallDAO;
import com.kdjsystem.mlink.yellim.dao.ProductDAO;
import com.kdjsystem.mlink.yellim.dto.CategoryDTO;
import com.kdjsystem.mlink.yellim.dto.DomemallDTO;
import com.kdjsystem.mlink.yellim.dto.ProductAddProcessDTO;
import com.kdjsystem.mlink.yellim.dto.ProductDTO;
import com.kdjsystem.mlink.yellim.dto.ProductOptionDTO;
import com.kdjsystem.mlink.yellim.dto.ResultProcessDTO;
import com.kdjsystem.mlink.yellim.dto.ShoppingmallDTO;
import com.kdjsystem.mlink.yellim.factory.IProductAddProcess;
import com.kdjsystem.mlink.yellim.helper.DateHelper;
import com.kdjsystem.mlink.yellim.helper.JsonHelper;
import com.kdjsystem.mlink.yellim.ui.CommonProgressDialog;
import com.kdjsystem.mlink.yellim.ui.ProductAddDialog;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class KakaoStoreProductAddService
implements IProductAddProcess {
    @Override
    public ResultProcessDTO addProcess(ProductAddProcessDTO dto) throws Exception {
        boolean flag = true;
        int page = 1;
        int infoRet = 0;
        int inRet = 0;
        String from = dto.getSTART_DATE().replaceAll("-", "") + "000000";
        String to = dto.getEND_DATE().replaceAll("-", "") + "235959";
        ShoppingmallDTO shopInfo = dto.getSHOPINFO();
        List<DomemallDTO> domemallInfos = DomemallDAO.get().selectDomemallInfos();
        String shopInfoLog = String.format("[%s - %s(%s)]", shopInfo.getSHOPNM(), shopInfo.getSHOPPINGID(), shopInfo.getNICKNM1());
        String date = DateHelper.getCurrentTimeString();
        this.setValue(String.format("%s %s \uc1fc\ud551\ubab0 \uc0c1\ud488 \ub370\uc774\ud130 \ucd94\uac00\ub97c \uc9c4\ud589\ud569\ub2c8\ub2e4.", date, shopInfoLog), 0);
        try {
            while (flag) {
                JsonParser parser = new JsonParser();
                Connection.Response response = Jsoup.connect((String)MallCode.getKakaoProductsSearchURL(String.valueOf(page))).header("Host", "kapi.kakao.com").header("Authorization", "KakaoAK b99a474fd6fe27f966e76e37591f0053").header("Target-Authorization", "KakaoAK " + shopInfo.getAPIKEY()).header("channel_ids", "101").header("Content-Type", "application/json;charset=UTF-8").method(Connection.Method.GET).ignoreContentType(true).followRedirects(true).ignoreHttpErrors(true).execute();
                String body = response.body();
                JsonObject jsonObject = (JsonObject)parser.parse(body);
                JsonArray contents = (JsonArray)jsonObject.get("contents");
                if (contents == null || contents.size() == 0) {
                    this.setValue(String.format("%s \ucd1d %s\uac74\uc758 \uc0c1\ud488 \ub370\uc774\ud130 \ucd94\uac00\ub97c \uc644\ub8cc\ud588\uc2b5\ub2c8\ub2e4.", shopInfoLog, inRet), 100);
                    this.setValue("--------------------------------------------------------------------------------------", 100);
                    return new ResultProcessDTO(0, "", infoRet, inRet);
                }
                JsonArray productList = new JsonArray();
                int i = 0;
                while (i < contents.size()) {
                    JsonObject product2 = (JsonObject)contents.get(i);
                    if (Long.parseLong(from) < product2.get("createdAt").getAsLong() && product2.get("createdAt").getAsLong() < Long.parseLong(to)) {
                        productList.add((JsonElement)product2);
                    }
                    ++i;
                }
                if (productList.size() == 0) {
                    ++page;
                    Thread.sleep(1000L);
                    continue;
                }
                ArrayList<ProductDTO> responseProducts = new ArrayList<ProductDTO>();
                int i2 = 0;
                while (i2 < productList.size()) {
                    if (ProductAddDialog.getIsCanceled()) {
                        return new ResultProcessDTO(0, "", infoRet, inRet);
                    }
                    JsonObject data2 = (JsonObject)productList.get(i2);
                    if (JsonHelper.jsonNullStr(data2.get("productSaleStatus")).equals("ON_SALE")) {
                        ProductDTO responseProduct = this.setDataBinding(shopInfo, data2.get("createdAt").getAsString(), JsonHelper.jsonNullStr(data2.get("productId")), domemallInfos);
                        responseProducts.add(responseProduct);
                        this.setValue(String.format(" %s [%s] \ubd88\ub7ec\uc624\ub294 \uc911..", shopInfoLog, responseProduct.getCompayny_goods_cd()), 0);
                    }
                    ++i2;
                }
                if (responseProducts.size() > 0) {
                    this.setValue(String.format(" %s \ud398\uc774\uc9c0 %s\uac74\uc744 DB\uc5d0 \uc800\uc7a5\ud569\ub2c8\ub2e4.", page, responseProducts.size()), 0);
                    for (ProductDTO product3 : responseProducts) {
                        if (ProductAddDialog.getIsCanceled()) {
                            return new ResultProcessDTO(0, "", infoRet, inRet);
                        }
                        ProductDTO copyProduct = ProductDAO.get().selectProductInfo(product3.getCompayny_goods_cd());
                        if (copyProduct == null) {
                            if (!this.getSendStatus(product3.getSaleStatusCd()).equals(Integer.toString(8000))) continue;
                            ret = ProductDAO.get().insertProductInfo(product3);
                            if (ret == 1) {
                                infoRet += ret;
                                String comment = String.format(" [%s] \ub9c8\uc2a4\ud130 \uc0c1\ud488 \uc800\uc7a5 \uc644\ub8cc", product3.getCompayny_goods_cd());
                                this.setValueProd(comment, 50, product3, null, "YEL_ADD", "\uc131\uacf5", "[\uc6b4\uc601\uc0c1\ud488\uad00\ub9ac - \uc0c1\ud488\ucd94\uac00] \ub9c8\uc2a4\ud130 \uc0c1\ud488\uc774 \ucd94\uac00\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", false);
                            }
                        } else {
                            copyProduct.setClass_cd3(product3.getClass_cd3());
                            copyProduct.setShop_cid_info(product3.getShop_cid_info());
                            ret = ProductDAO.get().updateProductInfo(copyProduct);
                            if (ret == 1) {
                                infoRet += ret;
                                String comment = String.format(" [%s] \ub9c8\uc2a4\ud130 \uc0c1\ud488 \uc218\uc815 \uc644\ub8cc", product3.getCompayny_goods_cd());
                                this.setValueProd(comment, 50, product3, null, "YEL_ADD", "\uc131\uacf5", "[\uc6b4\uc601\uc0c1\ud488\uad00\ub9ac - \uc0c1\ud488\ucd94\uac00] \ub9c8\uc2a4\ud130 \uc0c1\ud488\uc774 \uc774\ubbf8 \uc874\uc7ac\ud558\uc5ec \uc0c1\ud0dc\uac00 \uc218\uc815\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", false);
                            }
                        }
                        copyProduct = ProductDAO.get().selectProductInfo(product3.getCompayny_goods_cd());
                        ProductDTO copyProductIn = ProductDAO.get().selectProductIn(shopInfo, copyProduct.getPRODSEQ());
                        if (copyProductIn == null) {
                            product3.setPRODSEQ(copyProduct.getPRODSEQ());
                            int ret = ProductDAO.get().insertProductIn(product3);
                            if (ret == 1) {
                                inRet += ret;
                                String comment = String.format(" %s [%s] \uc1fc\ud551\ubab0 \uc0c1\ud488 \uc800\uc7a5 \uc644\ub8cc", shopInfoLog, product3.getCompayny_goods_cd());
                                this.setValueProd(comment, 50, product3, shopInfo, "YEL_ADD", "\uc131\uacf5", "[\uc6b4\uc601\uc0c1\ud488\uad00\ub9ac - \uc0c1\ud488\ucd94\uac00] \uc0c1\ud488\uc774 \uc5e0\ub9c1\ud06c\uc5d0 \ucd94\uac00\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", true);
                            }
                        } else {
                            copyProductIn.setClass_cd3(product3.getClass_cd3());
                            copyProductIn.setShop_cid_info(product3.getShop_cid_info());
                            copyProductIn.setGoods_nm(product3.getGoods_nm());
                            copyProductIn.setShopprodno(product3.getShopprodno());
                            copyProductIn.setDelv_r_cost(product3.getDelv_r_cost());
                            copyProductIn.setSaleenddt(product3.getSaleenddt());
                            copyProductIn.setMarket_price(product3.getMarket_price());
                            copyProductIn.setGoods_price(product3.getGoods_price());
                            copyProductIn.setGoods_consumer_price(product3.getGoods_consumer_price());
                            copyProductIn.setCompayny_goods_cd(product3.getCompayny_goods_cd());
                            copyProductIn.setSaleStatusCd(product3.getSaleStatusCd());
                            copyProductIn.setStdPrdYn(product3.getStdPrdYn());
                            copyProductIn.setStatus(product3.getStatus());
                            copyProductIn.setSendstats(product3.getSendstats());
                            String codeDivision = domemallInfos.stream().filter(p -> p.getCODE_DIVISION().equals(MallCode.getDomeMallProductCodeDivision(product3.getCompayny_goods_cd()))).map(p -> p.getSHOPCD()).findFirst().orElse("");
                            copyProductIn.setGoods_keyword(codeDivision);
                            int ret = ProductDAO.get().updateProductIn(copyProductIn);
                            if (ret == 1) {
                                inRet += ret;
                                String comment = String.format(" %s [%s] \uc1fc\ud551\ubab0 \uc0c1\ud488 \uc218\uc815 \uc644\ub8cc", shopInfoLog, product3.getCompayny_goods_cd());
                                this.setValueProd(comment, 50, product3, shopInfo, "YEL_ADD", "\uc131\uacf5", "[\uc6b4\uc601\uc0c1\ud488\uad00\ub9ac - \uc0c1\ud488\ucd94\uac00] \uc0c1\ud488\uc774 \uc774\ubbf8 \uc874\uc7ac\ud558\uc5ec \uc0c1\ud0dc\uac00 \uc5e0\ub9c1\ud06c\uc5d0\uc11c \uc218\uc815\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", true);
                            }
                        }
                        copyProductIn = ProductDAO.get().selectProductIn(shopInfo, copyProduct.getPRODSEQ());
                        if (product3.getOPTIONS() == null) continue;
                        for (ProductOptionDTO option2 : product3.getOPTIONS()) {
                            ProductOptionDTO copyOption = ProductDAO.get().selectOptProductInfo(copyProduct.getPRODSEQ(), option2.getSKUSEQ());
                            if (copyOption == null) {
                                option2.setPRODSEQ(Integer.parseInt(copyProduct.getPRODSEQ()));
                                option2.setCOMPAYNY_GOODS_CD(product3.getCompayny_goods_cd());
                                ProductDAO.get().insertOptProductInfo(option2);
                            } else {
                                copyOption.setCOMPAYNY_GOODS_CD(product3.getCompayny_goods_cd());
                                copyOption.setOPTPRODCD(option2.getOPTPRODCD());
                                copyOption.setOPTPRODNM(option2.getOPTPRODNM());
                                copyOption.setOPTSPECDES(option2.getOPTSPECDES());
                                copyOption.setOPTEA(option2.getOPTEA());
                                copyOption.setOPTSAFESTOCK(option2.getOPTSAFESTOCK());
                                copyOption.setOPTVERTSTOCK(option2.getOPTVERTSTOCK());
                                copyOption.setOPTADDAMT(option2.getOPTADDAMT());
                                copyOption.setINSERTDT(option2.getINSERTDT());
                                copyOption.setINSERTID(option2.getINSERTID());
                                copyOption.setMODIFYDT(option2.getMODIFYDT());
                                copyOption.setSTATUS(option2.getSTATUS());
                            }
                            ProductOptionDTO copyOptionIn = ProductDAO.get().selectOptProductIn(copyProductIn.getSENDSEQ(), option2.getSKUSEQ());
                            if (copyOptionIn == null) {
                                option2.setSENDSEQ(Integer.parseInt(copyProductIn.getSENDSEQ()));
                                option2.setPRODSEQ(Integer.parseInt(copyProduct.getPRODSEQ()));
                                ProductDAO.get().insertOptProductIn(option2);
                                continue;
                            }
                            copyOptionIn.setSHOPPRODNO(option2.getSHOPPRODNO());
                            copyOptionIn.setSHOPPRODSKU(option2.getSHOPPRODSKU());
                            copyOptionIn.setSHOPPRODSKU_NM(option2.getSHOPPRODSKU_NM());
                            copyOptionIn.setOPTPRODCD(option2.getOPTPRODCD());
                            copyOptionIn.setOPTPRODNM(option2.getOPTPRODNM());
                            copyOptionIn.setOPTSPECDES(option2.getOPTSPECDES());
                            copyOptionIn.setOPTEA(option2.getOPTEA());
                            copyOptionIn.setOPTSAFESTOCK(option2.getOPTSAFESTOCK());
                            copyOptionIn.setOPTVERTSTOCK(option2.getOPTVERTSTOCK());
                            copyOptionIn.setOPTADDAMT(option2.getOPTADDAMT());
                            copyOptionIn.setINSERTDT(option2.getINSERTDT());
                            copyOptionIn.setINSERTID(option2.getINSERTID());
                            copyOptionIn.setMODIFYDT(option2.getMODIFYDT());
                            copyOptionIn.setSTATUS(option2.getSTATUS());
                        }
                    }
                }
                if (jsonObject.get("last").getAsBoolean()) {
                    this.setValue(String.format("\ucd1d %s\uac74\uc758 \uc0c1\ud488 \ub370\uc774\ud130 \ucd94\uac00\ub97c \uc644\ub8cc\ud588\uc2b5\ub2c8\ub2e4.", inRet), 100);
                    this.setValue("--------------------------------------------------------------------------------------", 100);
                    return new ResultProcessDTO(0, "", infoRet, inRet);
                }
                ++page;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String errorMessage = ex.getMessage() != null ? ex.getMessage() : "\uc54c \uc218 \uc5c6\ub294 \uc624\ub958 \ubc1c\uc0dd";
            this.setValue(String.format("%s %s %s", date, shopInfoLog, errorMessage), 100);
            this.setValue("--------------------------------------------------------------------------------------", 100);
            return new ResultProcessDTO(-1, "", 0, 0);
        }
        this.setValue(String.format("%s %s \ucd1d %s\uac74\uc758 \uc0c1\ud488 \ub370\uc774\ud130 \ucd94\uac00\ub97c \uc644\ub8cc\ud588\uc2b5\ub2c8\ub2e4.", date, shopInfoLog, inRet), 100);
        this.setValue("--------------------------------------------------------------------------------------", 100);
        return new ResultProcessDTO(0, "", infoRet, inRet);
    }

    @Override
    public ResultProcessDTO addProcess(ProductAddProcessDTO dto, List<String> specificCodes) throws Exception {
        boolean flag = true;
        int page = 1;
        int infoRet = 0;
        int inRet = 0;
        String from = dto.getSTART_DATE().replaceAll("-", "") + "000000";
        String to = dto.getEND_DATE().replaceAll("-", "") + "235959";
        ShoppingmallDTO shopInfo = dto.getSHOPINFO();
        List<DomemallDTO> domemallInfos = DomemallDAO.get().selectDomemallInfos();
        String shopInfoLog = String.format("[%s - %s(%s)]", shopInfo.getSHOPNM(), shopInfo.getSHOPPINGID(), shopInfo.getNICKNM1());
        String date = DateHelper.getCurrentTimeString();
        this.setValue(String.format("%s %s \uc1fc\ud551\ubab0 \uc0c1\ud488 \ub370\uc774\ud130 \ucd94\uac00\ub97c \uc9c4\ud589\ud569\ub2c8\ub2e4.", date, shopInfoLog), 0);
        try {
            while (flag) {
                JsonParser parser = new JsonParser();
                Connection.Response response = Jsoup.connect((String)MallCode.getKakaoProductsSearchURL(String.valueOf(page))).header("Host", "kapi.kakao.com").header("Authorization", "KakaoAK b99a474fd6fe27f966e76e37591f0053").header("Target-Authorization", "KakaoAK " + shopInfo.getAPIKEY()).header("channel_ids", "101").header("Content-Type", "application/json;charset=UTF-8").method(Connection.Method.GET).ignoreContentType(true).followRedirects(true).ignoreHttpErrors(true).execute();
                String body = response.body();
                JsonObject jsonObject = (JsonObject)parser.parse(body);
                if (jsonObject.get("last").getAsBoolean()) {
                    this.setValue(String.format("%s \ucd1d %s\uac74\uc758 \uc0c1\ud488 \ub370\uc774\ud130 \ucd94\uac00\ub97c \uc644\ub8cc\ud588\uc2b5\ub2c8\ub2e4.", shopInfoLog, inRet), 100);
                    this.setValue("--------------------------------------------------------------------------------------", 100);
                    return new ResultProcessDTO(0, "", infoRet, inRet);
                }
                JsonArray contents = (JsonArray)jsonObject.get("contents");
                if (contents == null || contents.size() == 0) {
                    this.setValue(String.format("%s \ucd1d %s\uac74\uc758 \uc0c1\ud488 \ub370\uc774\ud130 \ucd94\uac00\ub97c \uc644\ub8cc\ud588\uc2b5\ub2c8\ub2e4.", shopInfoLog, inRet), 100);
                    this.setValue("--------------------------------------------------------------------------------------", 100);
                    return new ResultProcessDTO(0, "", infoRet, inRet);
                }
                JsonArray productList = new JsonArray();
                int i = 0;
                while (i < contents.size()) {
                    JsonObject product2 = (JsonObject)contents.get(i);
                    if (Long.parseLong(from) < product2.get("createdAt").getAsLong() && product2.get("createdAt").getAsLong() < Long.parseLong(to)) {
                        productList.add((JsonElement)product2);
                    }
                    ++i;
                }
                if (productList.size() == 0) {
                    ++page;
                    Thread.sleep(1000L);
                    continue;
                }
                ArrayList<ProductDTO> responseProducts = new ArrayList<ProductDTO>();
                int i2 = 0;
                while (i2 < productList.size()) {
                    String specificCode;
                    if (ProductAddDialog.getIsCanceled()) {
                        return new ResultProcessDTO(0, "", infoRet, inRet);
                    }
                    JsonObject data2 = (JsonObject)productList.get(i2);
                    if (JsonHelper.jsonNullStr(data2.get("productSaleStatus")).equals("ON_SALE") && (specificCodes.size() <= 0 || !(specificCode = specificCodes.stream().filter(p -> p.equals(JsonHelper.jsonNullStr(data2.get("storeManagementCode")))).findFirst().orElse("")).equals(""))) {
                        ProductDTO responseProduct = this.setDataBinding(shopInfo, data2.get("createdAt").getAsString(), JsonHelper.jsonNullStr(data2.get("productId")), domemallInfos);
                        responseProducts.add(responseProduct);
                        this.setValue(String.format(" %s [%s] \ubd88\ub7ec\uc624\ub294 \uc911..", shopInfoLog, responseProduct.getCompayny_goods_cd()), 0);
                    }
                    ++i2;
                }
                if (responseProducts.size() > 0) {
                    this.setValue(String.format(" %s \ud398\uc774\uc9c0 %s\uac74\uc744 DB\uc5d0 \uc800\uc7a5\ud569\ub2c8\ub2e4.", page, responseProducts.size()), 0);
                    for (ProductDTO product3 : responseProducts) {
                        if (ProductAddDialog.getIsCanceled()) {
                            return new ResultProcessDTO(0, "", infoRet, inRet);
                        }
                        ProductDTO copyProduct = ProductDAO.get().selectProductInfo(product3.getCompayny_goods_cd());
                        if (copyProduct == null) {
                            if (!this.getSendStatus(product3.getSaleStatusCd()).equals(Integer.toString(8000))) continue;
                            ret = ProductDAO.get().insertProductInfo(product3);
                            if (ret == 1) {
                                infoRet += ret;
                                String comment = String.format(" [%s] \ub9c8\uc2a4\ud130 \uc0c1\ud488 \uc800\uc7a5 \uc644\ub8cc", product3.getCompayny_goods_cd());
                                this.setValueProd(comment, 50, product3, null, "YEL_ADD", "\uc131\uacf5", "[\uc6b4\uc601\uc0c1\ud488\uad00\ub9ac - \uc0c1\ud488\ucd94\uac00] \ub9c8\uc2a4\ud130 \uc0c1\ud488\uc774 \ucd94\uac00\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", false);
                            }
                        } else {
                            copyProduct.setClass_cd3(product3.getClass_cd3());
                            copyProduct.setShop_cid_info(product3.getShop_cid_info());
                            ret = ProductDAO.get().updateProductInfo(copyProduct);
                            if (ret == 1) {
                                infoRet += ret;
                                String comment = String.format(" [%s] \ub9c8\uc2a4\ud130 \uc0c1\ud488 \uc218\uc815 \uc644\ub8cc", product3.getCompayny_goods_cd());
                                this.setValueProd(comment, 50, product3, null, "YEL_ADD", "\uc131\uacf5", "[\uc6b4\uc601\uc0c1\ud488\uad00\ub9ac - \uc0c1\ud488\ucd94\uac00] \ub9c8\uc2a4\ud130 \uc0c1\ud488\uc774 \uc774\ubbf8 \uc874\uc7ac\ud558\uc5ec \uc0c1\ud0dc\uac00 \uc218\uc815\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", false);
                            }
                        }
                        copyProduct = ProductDAO.get().selectProductInfo(product3.getCompayny_goods_cd());
                        ProductDTO copyProductIn = ProductDAO.get().selectProductIn(shopInfo, copyProduct.getPRODSEQ());
                        if (copyProductIn == null) {
                            product3.setPRODSEQ(copyProduct.getPRODSEQ());
                            int ret = ProductDAO.get().insertProductIn(product3);
                            if (ret == 1) {
                                inRet += ret;
                                String comment = String.format(" %s [%s] \uc1fc\ud551\ubab0 \uc0c1\ud488 \uc800\uc7a5 \uc644\ub8cc", shopInfoLog, product3.getCompayny_goods_cd());
                                this.setValueProd(comment, 50, product3, shopInfo, "YEL_ADD", "\uc131\uacf5", "[\uc6b4\uc601\uc0c1\ud488\uad00\ub9ac - \uc0c1\ud488\ucd94\uac00] \uc0c1\ud488\uc774 \uc5e0\ub9c1\ud06c\uc5d0 \ucd94\uac00\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", true);
                            }
                        } else {
                            copyProductIn.setClass_cd3(product3.getClass_cd3());
                            copyProductIn.setShop_cid_info(product3.getShop_cid_info());
                            copyProductIn.setGoods_nm(product3.getGoods_nm());
                            copyProductIn.setShopprodno(product3.getShopprodno());
                            copyProductIn.setDelv_r_cost(product3.getDelv_r_cost());
                            copyProductIn.setSaleenddt(product3.getSaleenddt());
                            copyProductIn.setMarket_price(product3.getMarket_price());
                            copyProductIn.setGoods_price(product3.getGoods_price());
                            copyProductIn.setGoods_consumer_price(product3.getGoods_consumer_price());
                            copyProductIn.setCompayny_goods_cd(product3.getCompayny_goods_cd());
                            copyProductIn.setSaleStatusCd(product3.getSaleStatusCd());
                            copyProductIn.setStdPrdYn(product3.getStdPrdYn());
                            copyProductIn.setStatus(product3.getStatus());
                            copyProductIn.setSendstats(product3.getSendstats());
                            String codeDivision = domemallInfos.stream().filter(p -> p.getCODE_DIVISION().equals(MallCode.getDomeMallProductCodeDivision(product3.getCompayny_goods_cd()))).map(p -> p.getSHOPCD()).findFirst().orElse("");
                            copyProductIn.setGoods_keyword(codeDivision);
                            int ret = ProductDAO.get().updateProductIn(copyProductIn);
                            if (ret == 1) {
                                inRet += ret;
                                String comment = String.format(" %s [%s] \uc1fc\ud551\ubab0 \uc0c1\ud488 \uc218\uc815 \uc644\ub8cc", shopInfoLog, product3.getCompayny_goods_cd());
                                this.setValueProd(comment, 50, product3, shopInfo, "YEL_ADD", "\uc131\uacf5", "[\uc6b4\uc601\uc0c1\ud488\uad00\ub9ac - \uc0c1\ud488\ucd94\uac00] \uc0c1\ud488\uc774 \uc774\ubbf8 \uc874\uc7ac\ud558\uc5ec \uc0c1\ud0dc\uac00 \uc5e0\ub9c1\ud06c\uc5d0\uc11c \uc218\uc815\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", true);
                            }
                        }
                        copyProductIn = ProductDAO.get().selectProductIn(shopInfo, copyProduct.getPRODSEQ());
                        if (product3.getOPTIONS() == null) continue;
                        for (ProductOptionDTO option2 : product3.getOPTIONS()) {
                            ProductOptionDTO copyOption = ProductDAO.get().selectOptProductInfo(copyProduct.getPRODSEQ(), option2.getSKUSEQ());
                            if (copyOption == null) {
                                option2.setPRODSEQ(Integer.parseInt(copyProduct.getPRODSEQ()));
                                option2.setCOMPAYNY_GOODS_CD(product3.getCompayny_goods_cd());
                                ProductDAO.get().insertOptProductInfo(option2);
                            } else {
                                copyOption.setCOMPAYNY_GOODS_CD(product3.getCompayny_goods_cd());
                                copyOption.setOPTPRODCD(option2.getOPTPRODCD());
                                copyOption.setOPTPRODNM(option2.getOPTPRODNM());
                                copyOption.setOPTSPECDES(option2.getOPTSPECDES());
                                copyOption.setOPTEA(option2.getOPTEA());
                                copyOption.setOPTSAFESTOCK(option2.getOPTSAFESTOCK());
                                copyOption.setOPTVERTSTOCK(option2.getOPTVERTSTOCK());
                                copyOption.setOPTADDAMT(option2.getOPTADDAMT());
                                copyOption.setINSERTDT(option2.getINSERTDT());
                                copyOption.setINSERTID(option2.getINSERTID());
                                copyOption.setMODIFYDT(option2.getMODIFYDT());
                                copyOption.setSTATUS(option2.getSTATUS());
                                ProductDAO.get().updateOptProductInfo(copyOption);
                            }
                            ProductOptionDTO copyOptionIn = ProductDAO.get().selectOptProductIn(copyProductIn.getSENDSEQ(), option2.getSKUSEQ());
                            if (copyOptionIn == null) {
                                option2.setSENDSEQ(Integer.parseInt(copyProductIn.getSENDSEQ()));
                                option2.setPRODSEQ(Integer.parseInt(copyProduct.getPRODSEQ()));
                                ProductDAO.get().insertOptProductIn(option2);
                                continue;
                            }
                            copyOptionIn.setSHOPPRODNO(option2.getSHOPPRODNO());
                            copyOptionIn.setSHOPPRODSKU(option2.getSHOPPRODSKU());
                            copyOptionIn.setSHOPPRODSKU_NM(option2.getSHOPPRODSKU_NM());
                            copyOptionIn.setOPTPRODCD(option2.getOPTPRODCD());
                            copyOptionIn.setOPTPRODNM(option2.getOPTPRODNM());
                            copyOptionIn.setOPTSPECDES(option2.getOPTSPECDES());
                            copyOptionIn.setOPTEA(option2.getOPTEA());
                            copyOptionIn.setOPTSAFESTOCK(option2.getOPTSAFESTOCK());
                            copyOptionIn.setOPTVERTSTOCK(option2.getOPTVERTSTOCK());
                            copyOptionIn.setOPTADDAMT(option2.getOPTADDAMT());
                            copyOptionIn.setINSERTDT(option2.getINSERTDT());
                            copyOptionIn.setINSERTID(option2.getINSERTID());
                            copyOptionIn.setMODIFYDT(option2.getMODIFYDT());
                            copyOptionIn.setSTATUS(option2.getSTATUS());
                            ProductDAO.get().updateOptProductIn(copyOptionIn);
                        }
                    }
                }
                ++page;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String errorMessage = ex.getMessage() != null ? ex.getMessage() : "\uc54c \uc218 \uc5c6\ub294 \uc624\ub958 \ubc1c\uc0dd";
            this.setValue(String.format("%s %s %s", date, shopInfoLog, errorMessage), 100);
            this.setValue("--------------------------------------------------------------------------------------", 100);
            return new ResultProcessDTO(-1, "", 0, 0);
        }
        this.setValue(String.format("%s %s \ucd1d %s\uac74\uc758 \uc0c1\ud488 \ub370\uc774\ud130 \ucd94\uac00\ub97c \uc644\ub8cc\ud588\uc2b5\ub2c8\ub2e4.", date, shopInfoLog, inRet), 100);
        this.setValue("--------------------------------------------------------------------------------------", 100);
        return new ResultProcessDTO(0, "", infoRet, inRet);
    }

    public ProductDTO setDataBinding(ShoppingmallDTO shopInfo, String crtdate, String shopprodno, List<DomemallDTO> domemallInfos) {
        ProductDTO responseProduct = new ProductDTO();
        JsonParser parser = new JsonParser();
        try {
            Connection.Response response = Jsoup.connect((String)MallCode.getKakaoProductSearchURL(shopprodno)).header("Host", "kapi.kakao.com").header("Authorization", "KakaoAK b99a474fd6fe27f966e76e37591f0053").header("Target-Authorization", "KakaoAK " + shopInfo.getAPIKEY()).header("channel_ids", "101").header("Content-Type", "application/json;charset=UTF-8").method(Connection.Method.GET).ignoreContentType(true).followRedirects(true).ignoreHttpErrors(true).execute();
            String body = response.body();
            YDMAStringUtil.Print(body);
            JsonObject data2 = (JsonObject)parser.parse(body);
            responseProduct.setShopcd(shopInfo.getSHOPCD());
            responseProduct.setShopseq(String.valueOf(shopInfo.getSHOPSEQ()));
            responseProduct.setSHOP_USERID(shopInfo.getSHOPPINGID());
            responseProduct.setShopprodno(shopprodno);
            responseProduct.setCompayny_goods_cd(JsonHelper.jsonNullStr(data2.get("storeManagementCode")));
            responseProduct.setGoods_nm(JsonHelper.jsonNullStr(data2.get("name")));
            responseProduct.setStatus(this.getStatus(JsonHelper.jsonNullStr(data2.get("productSaleStatus"))));
            responseProduct.setSendstats(this.getSendStatus(JsonHelper.jsonNullStr(data2.get("productSaleStatus"))));
            responseProduct.setSaleStatusCd(this.getSendStatus(JsonHelper.jsonNullStr(data2.get("productSaleStatus"))));
            if (responseProduct.getSaleStatusCd().equals("8000")) {
                responseProduct.setSaleStatusCd("ON_SALE");
            }
            responseProduct.setBrand_nm(JsonHelper.jsonNullStr(data2.get("brand")));
            responseProduct.setInsertdt(YDMATimeUtil.getLondtoDate1(crtdate));
            responseProduct.setModifyid(responseProduct.getInsertdt());
            responseProduct.setSaleenddt("2999-12-31");
            responseProduct.setMarket_price(JsonHelper.jsonElementNullInt(data2.get("salePrice")));
            responseProduct.setGoods_price(JsonHelper.jsonElementNullInt(data2.get("salePrice")));
            responseProduct.setGoods_consumer_price(JsonHelper.jsonElementNullInt(data2.get("salePrice")));
            String codeDivision = domemallInfos.stream().filter(p -> p.getCODE_DIVISION().equals(MallCode.getDomeMallProductCodeDivision(responseProduct.getCompayny_goods_cd()))).map(p -> p.getSHOPCD()).findFirst().orElse("");
            responseProduct.setGoods_keyword(codeDivision);
            JsonObject productImageObj = data2.get("productImage").getAsJsonObject();
            JsonObject representImageObj = productImageObj.get("representImage").getAsJsonObject();
            responseProduct.setImg_path(JsonHelper.jsonNullStr(representImageObj.get("url")));
            CategoryDTO category = this.getCategory(data2, shopInfo);
            responseProduct.setClass_cd3(category.getCODE());
            responseProduct.setShop_cid_info(category.getSHOPCATE_JSON());
            responseProduct.setGmcategnm(data2.get("wholeCategoryName").getAsString());
            JsonObject optionObj = data2.get("option").getAsJsonObject();
            if (!optionObj.get("type").getAsString().equals("NONE")) {
                List<ProductOptionDTO> options = this.getOption(optionObj, responseProduct);
                responseProduct.setOPTIONS(options);
                String[] optionNames = options.stream().map(p -> p.getOPTPRODNM()).findFirst().orElse("").split("/");
                if (optionNames.length == 1) {
                    responseProduct.setChar_1_nm(optionNames[0]);
                } else if (optionNames.length == 2) {
                    responseProduct.setChar_1_nm(optionNames[0]);
                    responseProduct.setChar_2_nm(optionNames[1]);
                }
            } else {
                responseProduct.setChar_1_nm("\ub2e8\ud488");
                responseProduct.setChar_1_val("");
                responseProduct.setChar_2_nm("");
                responseProduct.setChar_2_val("");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return responseProduct;
    }

    public CategoryDTO getCategory(JsonObject data2, ShoppingmallDTO shopInfo) {
        try {
            String code = data2.get("categoryId").getAsString();
            String[] names = data2.get("wholeCategoryName").getAsString().split(">");
            String lastName = names[names.length - 1].trim();
            CategoryDTO category = CategoryDAO.get().selectShoppingMallCategory(code, lastName);
            if (category == null && (category = CategoryDAO.get().selectShoppingMallCategory(code)) == null) {
                category = CategoryDAO.get().selectCategory("350119000");
            }
            return category;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<ProductOptionDTO> getOption(JsonObject optionObj, ProductDTO responseProduct) {
        ArrayList<ProductOptionDTO> options = new ArrayList<ProductOptionDTO>();
        try {
            JsonArray combinationsArr = optionObj.get("combinations").getAsJsonArray();
            int i = 0;
            while (i < combinationsArr.size()) {
                JsonObject combination = combinationsArr.get(i).getAsJsonObject();
                ProductOptionDTO option2 = new ProductOptionDTO();
                option2.setSKUSEQ(i + 1);
                option2.setSHOPPRODNO(responseProduct.getShopprodno());
                option2.setSHOPPRODSKU(String.valueOf(combination.get("id").getAsInt()));
                option2.setSHOPPRODSKU_NM(responseProduct.getGoods_nm());
                option2.setPRODCD(responseProduct.getCompayny_goods_cd());
                option2.setOPTPRODCD(combination.get("managedCode").getAsString());
                Object optprodnm = "";
                Object optspecdes = "";
                JsonArray nameArr = combination.get("name").getAsJsonArray();
                if (nameArr.size() == 1) {
                    optprodnm = nameArr.get(0).getAsJsonObject().get("key").getAsString();
                    optspecdes = nameArr.get(0).getAsJsonObject().get("value").getAsString();
                } else if (nameArr.size() == 2) {
                    String name1 = nameArr.get(0).getAsJsonObject().get("key").getAsString();
                    String name2 = nameArr.get(1).getAsJsonObject().get("key").getAsString();
                    optprodnm = name1 + "/" + name2;
                    String val1 = nameArr.get(0).getAsJsonObject().get("value").getAsString();
                    String val2 = nameArr.get(1).getAsJsonObject().get("value").getAsString();
                    optspecdes = val1 + "/" + val2;
                }
                option2.setOPTPRODNM((String)optprodnm);
                option2.setOPTSPECDES((String)optspecdes);
                option2.setOPTSAFESTOCK(Integer.parseInt(responseProduct.getGoods_price()));
                option2.setOPTVERTSTOCK(combination.get("stockQuantity").getAsInt());
                option2.setOPTADDAMT(combination.get("price").getAsInt());
                option2.setINSERTDT(responseProduct.getInsertdt());
                option2.setINSERTID(YDMASessonUtil.getUserInfo().getUserId());
                option2.setSTATUS(combination.get("stockQuantity").getAsInt() > 0 ? "0" : "1");
                options.add(option2);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            options = null;
        }
        return options;
    }

    private String getStatus(String status2) {
        switch (status2) {
            case "ON_SALE": 
            case "WAIT": {
                return "0";
            }
            case "OUT_OF_STOCK": {
                return "1";
            }
            case "CLOSE": 
            case "SUSPENSION": 
            case "PROHIBITION": {
                return "3";
            }
        }
        return "";
    }

    private String getSendStatus(String status2) {
        switch (status2) {
            case "ON_SALE": {
                return String.valueOf(8000);
            }
            case "WAIT": {
                return String.valueOf(9000);
            }
            case "OUT_OF_STOCK": {
                return String.valueOf(4000);
            }
            case "CLOSE": 
            case "SUSPENSION": 
            case "PROHIBITION": {
                return String.valueOf(3000);
            }
        }
        return "";
    }

    @Override
    public ResultProcessDTO addProcess2(ProductAddProcessDTO proDto, List<String> specificCodes, IProgressMonitor monitor, ShoppingmallDTO dto) throws Exception {
        return null;
    }

    private void setValue(String message, int value) {
        CommonProgressDialog.get().setValue(message, value);
    }

    private void setValueProd(String title, int value, ProductDTO item, ShoppingmallDTO shopInfo, String jobType, String jobResult, String logMsg, boolean isProdIn) {
        CommonProgressDialog.get().setValueProd(title, value, item, shopInfo, jobType, jobResult, logMsg, isProdIn);
    }
}

