/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.shop.coupang;

import com.coupang.openapi.sdk.Hmac;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.yellim.shop.dao.ShopOrderMstDto;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class CoupangOrderReturnCommand
implements IShopOrderCommand {
    private static IShopOrderCommand instance = new CoupangOrderReturnCommand();

    public static IShopOrderCommand getInstance() {
        return instance;
    }

    @Override
    public void Login(String loginID, String loginPw, String gubun) throws Exception {
    }

    private CoupangOrderReturnCommand() {
    }

    @Override
    public int Search(String URL2, String startdt, String enddt) throws Exception {
        return 0;
    }

    @Override
    public int Search_conf(String URL2, String startdt, String enddt, String searchkeyword) throws Exception {
        return 0;
    }

    private ShopOrderMstDto getApiList(ShopOrderMstDto param, String json) throws Exception {
        block21: {
            new ArrayList();
            CloseableHttpResponse response = null;
            CloseableHttpClient client = null;
            param.getShop_userid();
            param.getShopPw();
            param.getShopid();
            try {
                String URL2 = "/v2/providers/openapi/apis/api/v4/vendors/%s/returnRequests/%s/approval";
                String acessKey = param.getAuthkey1();
                String secretKey = param.getAuthKey2();
                String vendorid = param.getVendorId();
                URL2 = String.format(URL2, vendorid, Long.valueOf(param.getReceiptid()));
                URIBuilder uriBuilder = new URIBuilder().setPath(URL2);
                String authorization = Hmac.generate((String)"PATCH", (String)uriBuilder.build().toString(), (String)secretKey, (String)acessKey);
                uriBuilder.setScheme("https").setHost("api-gateway.coupang.com").setPort(443);
                StringEntity params = new StringEntity(json, "UTF-8");
                client = HttpClients.createDefault();
                HttpPatch requestPatch = new HttpPatch(uriBuilder.build().toString());
                requestPatch.addHeader("Authorization", authorization);
                requestPatch.addHeader("content-type", "application/json");
                requestPatch.setEntity((HttpEntity)params);
                response = client.execute((HttpUriRequest)requestPatch);
                int status2 = response.getStatusLine().getStatusCode();
                response.getStatusLine().getReasonPhrase();
                if (status2 != 200) break block21;
                InputStream is = response.getEntity().getContent();
                BufferedReader br = new BufferedReader(new InputStreamReader(is, "utf-8"));
                JsonParser parser = new JsonParser();
                JsonObject resObject = (JsonObject)parser.parse((Reader)br);
                YDMAStringUtil.Print(resObject);
                String code = this.jsonElementNullStr(resObject.get("code"));
                String msg = this.jsonElementNullStr(resObject.get("message"));
                if (code.equals("200")) {
                    param.setResult_code("1");
                    param.setResult_text("\ubc18\ud488\ucc98\ub9ac \ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                    param.setOrder_status("R02");
                    ShopOrderMstDto shopOrderMstDto = param;
                    return shopOrderMstDto;
                }
                param.setResult_code("-1");
                param.setResult_text(msg);
            }
            finally {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return param;
    }

    @Override
    public List<ShopOrderMstDto> Completed(List<ShopOrderMstDto> param) throws Exception {
        String vendorid = param.get(0).getVendorId();
        ArrayList<ShopOrderMstDto> retlist = new ArrayList<ShopOrderMstDto>();
        for (ShopOrderMstDto dto : param) {
            ObjectMapper mapper = new ObjectMapper();
            mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
            OrderRequestBody requestBody = new OrderRequestBody();
            requestBody.setVendorId(vendorid);
            requestBody.setReceiptId(Long.valueOf(dto.getReceiptid()));
            requestBody.setCancelCount(Math.abs(Long.valueOf(dto.getSale_cnt())));
            String json = mapper.writeValueAsString((Object)requestBody);
            ShopOrderMstDto retParam = this.getApiList(dto, json);
            retlist.add(retParam);
        }
        return retlist;
    }

    private static class OrderRequestBody {
        private String vendorId;
        private Long receiptId;
        private Long cancelCount;

        private OrderRequestBody() {
        }

        public String getVendorId() {
            return this.vendorId;
        }

        public void setVendorId(String vendorId) {
            this.vendorId = vendorId;
        }

        public Long getReceiptId() {
            return this.receiptId;
        }

        public void setReceiptId(Long receiptId) {
            this.receiptId = receiptId;
        }

        public Long getCancelCount() {
            return this.cancelCount;
        }

        public void setCancelCount(Long cancelCount) {
            this.cancelCount = cancelCount;
        }
    }
}

