/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.shop.dao;

import com.kdjsystem.mlink.yellim.common.YDMASessonUtil;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.common.YDMATimeUtil;
import com.kdjsystem.mlink.yellim.data.dao.DBCPInit;
import com.kdjsystem.mlink.yellim.dto.ProductDTO;
import com.kdjsystem.mlink.yellim.dto.ShoppingmallDTO;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductAdditionDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductSendDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopWorkDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShoppingMallDetailDto;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ShopWorkDao {
    private static ShopWorkDao daoInstance = new ShopWorkDao();
    Map<String, String> mapAddrList = new HashMap<String, String>();

    private ShopWorkDao() {
    }

    public static ShopWorkDao get() {
        return daoInstance;
    }

    public List<ShopWorkDto> getWorkAllList() throws Exception {
        ArrayList<ShopWorkDto> list = new ArrayList<ShopWorkDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append(" SELECT                           \r\n");
                sql.append("MAX(WORKSEQ) AS WORKSEQ,  \r\n ");
                sql.append("IFNULL(SHOPCD,'' ) AS SHOPCD,  \r\n ");
                sql.append("IFNULL(COMPNO,'' ) AS COMPNO,  \r\n ");
                sql.append("IFNULL(WORKCD,'' ) AS WORKCD,  \r\n ");
                sql.append("IFNULL(WORKDETCD,'' ) AS WORKDETCD,  \r\n ");
                sql.append("IFNULL(INSERTID,'' ) AS INSERTID,  \r\n ");
                sql.append("IFNULL(WORKDATEFROM,'' ) AS WORKDATEFROM,  \r\n ");
                sql.append("IFNULL(WORKDATETO,'' ) AS WORKDATETO,  \r\n ");
                sql.append("SUM(WORKDLAPSED) AS WORKDLAPSED,  \r\n ");
                sql.append("(CASE WHEN  MAX(WORKSEQ) = (COUNT(CASE WHEN WORKDETCD='W06' OR WORKDETCD='W05' OR WORKDETCD='W04'  OR WORKDETCD='W02' THEN '1'  END)) THEN '\uc644\ub8cc' ELSE '\uc9c4\ud589\uc911' END)  AS WORKSTATS,    \r\n ");
                sql.append("FlOOR((COUNT(CASE WHEN WORKDETCD='W06' OR WORKDETCD='W05' OR WORKDETCD='W04'  OR WORKDETCD='W02' THEN '1'  END) / MAX(WORKSEQ)) * 100) AS WORKCURRRATE,  \r\n ");
                sql.append("IFNULL(WORKMESSAGE,'' ) AS WORKMESSAGE,  \r\n ");
                sql.append("IFNULL(GROUP_CONCAT( WORKLOG), '') AS WORKLOG,   \r\n ");
                sql.append(" IFNULL(GROUP_CONCAT(PRODSEQ) ,'')  AS PRODSEQ,  \r\n ");
                sql.append("IFNULL(SHOPSEQ,'' ) AS SHOPSEQ,  \r\n ");
                sql.append("IFNULL(USER_ID,'' ) AS USER_ID,  \r\n ");
                sql.append("IFNULL(ADDRSEQ,'' ) AS ADDRSEQ,  \r\n ");
                sql.append("IFNULL(SHOPCATNO,'' ) AS SHOPCATNO  \r\n ");
                sql.append(" FROM workmngr  where compno = ?  \r\n");
                sql.append(" GROUP BY workgrp ");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[getWorkAllList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                int rowno = 0;
                while (rs.next()) {
                    ShopWorkDto dto = new ShopWorkDto();
                    dto.setRowno("" + ++rowno);
                    dto.setWorkseq(rs.getString("WORKSEQ"));
                    dto.setShopcd(rs.getString("SHOPCD"));
                    dto.setCompno(rs.getString("COMPNO"));
                    dto.setWorkcd(rs.getString("WORKCD"));
                    dto.setWorkdetcd(rs.getString("WORKDETCD"));
                    dto.setInsertid(rs.getString("INSERTID"));
                    dto.setWorkdatefrom(rs.getString("WORKDATEFROM"));
                    dto.setWorkdateto(rs.getString("WORKDATETO"));
                    dto.setWorkdlapsed(rs.getString("WORKDLAPSED"));
                    dto.setWorkstats(rs.getString("WORKSTATS"));
                    dto.setWorkcurrrate(rs.getString("WORKCURRRATE"));
                    dto.setWorkmessage(rs.getString("WORKMESSAGE"));
                    dto.setWorklog(rs.getString("WORKLOG"));
                    dto.setProdseq(rs.getString("PRODSEQ"));
                    dto.setShopseq(rs.getString("SHOPSEQ"));
                    dto.setUser_id(rs.getString("USER_ID"));
                    dto.setAddrseq(rs.getString("ADDRSEQ"));
                    dto.setShopcatno(rs.getString("SHOPCATNO"));
                    list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public void setWorkListInsert(List<ProductDTO> prodList, ShopProductAdditionDto shopProductAdditionDto, ShoppingMallDetailDto shoppingMallDetailDto, String \uc0c1\ud488\ub4f1\ub85d, String \ub300\uae30) throws Exception {
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "INSERT INTO workmngr\r\n (WORKGRP,WORKSEQ, SHOPCD, COMPNO, WORKCD, WORKDETCD, INSERTID, WORKDATEFROM, WORKDATETO, WORKDLAPSED, WORKSTATS, WORKCURRRATE, WORKMESSAGE, WORKLOG, \r\n  PRODSEQ, SHOPSEQ, USER_ID, ADDRSEQ, SHOPCATNO ) \r\n VALUES(?,?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,  \t   ?, ?, ?, ?, ? ) ";
                PreparedStatement pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                for (ProductDTO dto : prodList) {
                    int rowIdx = 0;
                    pstmt.setString(++rowIdx, dto.getWorkgrp());
                    pstmt.setString(++rowIdx, dto.getWorkseq());
                    pstmt.setString(++rowIdx, shoppingMallDetailDto.getShopcd());
                    pstmt.setString(++rowIdx, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setString(++rowIdx, \uc0c1\ud488\ub4f1\ub85d);
                    pstmt.setString(++rowIdx, \ub300\uae30);
                    pstmt.setString(++rowIdx, YDMASessonUtil.getUserInfo().getUserId());
                    pstmt.setString(++rowIdx, "");
                    pstmt.setString(++rowIdx, \ub300\uae30.equals("W05") ? YDMATimeUtil.getCurrentTimeByYDFormat() : "");
                    pstmt.setString(++rowIdx, \ub300\uae30.equals("W05") ? "0" : "");
                    pstmt.setString(++rowIdx, \ub300\uae30.equals("W05") ? "1\uac74\uc2e4\ud328" : "");
                    pstmt.setString(++rowIdx, \ub300\uae30.equals("W05") ? "100%" : "0%");
                    pstmt.setString(++rowIdx, "");
                    pstmt.setString(++rowIdx, dto.getResult_text());
                    pstmt.setString(++rowIdx, dto.getPRODSEQ());
                    pstmt.setString(++rowIdx, shoppingMallDetailDto.getShopseq());
                    pstmt.setString(++rowIdx, shoppingMallDetailDto.getShoppingid());
                    pstmt.setString(++rowIdx, shopProductAdditionDto.getSeq());
                    pstmt.setString(++rowIdx, dto.getShopCatInDto() == null ? "0" : dto.getShopCatInDto().getShopcatno());
                    pstmt.addBatch();
                    pstmt.clearParameters();
                }
                YDMAStringUtil.Print("[setWorkListInsert]" + pstmt.toString());
                pstmt.executeBatch();
                pstmt.clearParameters();
            }
            catch (Exception e) {
                e.printStackTrace();
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public void setWorkListInsert(ShopProductSendDto sendDTO, String \uc0c1\ud488\ub4f1\ub85d, String \ub300\uae30) throws Exception {
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "INSERT INTO workmngr\r\n ( SHOPCD, COMPNO, WORKCD, WORKDETCD, INSERTID, WORKDATEFROM, WORKDATETO, WORKDLAPSED, WORKSTATS, WORKCURRRATE, WORKMESSAGE, WORKLOG, \r\n  PRODSEQ, SHOPSEQ, USER_ID, ADDRSEQ, SHOPCATNO ) \r\n VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,  \t   ?, ?, ?, ?, ? ) ";
                PreparedStatement pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                List<ProductDTO> prodList = sendDTO.getShopProductDto();
                ShopProductAdditionDto shopProductAdditionDto = sendDTO.getProductAdditionDto();
                ShoppingmallDTO shopInfo = sendDTO.getShoppingmallDTO();
                for (ProductDTO dto : prodList) {
                    int rowIdx = 0;
                    pstmt.setString(++rowIdx, shopInfo.getSHOPCD());
                    pstmt.setString(++rowIdx, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setString(++rowIdx, \uc0c1\ud488\ub4f1\ub85d);
                    pstmt.setString(++rowIdx, \ub300\uae30);
                    pstmt.setString(++rowIdx, YDMASessonUtil.getUserInfo().getUserId());
                    pstmt.setString(++rowIdx, "");
                    pstmt.setString(++rowIdx, \ub300\uae30.equals("W05") ? YDMATimeUtil.getCurrentTimeByYDFormat() : "");
                    pstmt.setString(++rowIdx, \ub300\uae30.equals("W05") ? "0" : "");
                    pstmt.setString(++rowIdx, \ub300\uae30.equals("W05") ? "1\uac74\uc2e4\ud328" : "");
                    pstmt.setString(++rowIdx, \ub300\uae30.equals("W05") ? "100%" : "0%");
                    pstmt.setString(++rowIdx, "");
                    pstmt.setString(++rowIdx, dto.getResult_text());
                    pstmt.setString(++rowIdx, dto.getPRODSEQ());
                    pstmt.setInt(++rowIdx, shopInfo.getSHOPSEQ());
                    pstmt.setString(++rowIdx, shopInfo.getSHOPPINGID());
                    pstmt.setString(++rowIdx, shopProductAdditionDto.getSeq());
                    pstmt.setString(++rowIdx, dto.getShopCatInDto() == null ? "0" : dto.getShopCatInDto().getShopcatno());
                    pstmt.addBatch();
                    pstmt.clearParameters();
                }
                YDMAStringUtil.Print("[setWorkListInsert]" + pstmt.toString());
                pstmt.executeBatch();
                pstmt.clearParameters();
            }
            catch (Exception e) {
                e.printStackTrace();
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public int getMultiThreadCnt() throws Exception {
        int result = 1;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = " select ifnull(SUGGPROCNT,'0')    from systemconf   where compno=? ";
                pstmt = connection.prepareStatement(sql.toUpperCase());
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[getsystemconf]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    result = rs.getInt(1);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public ShopProductSendDto getWorkChoiceList(ShopProductSendDto sendDTO) throws Exception {
        int i = 0;
        while (i < sendDTO.getShopProductDto().size()) {
            block7: {
                PreparedStatement pstmt = null;
                Connection connection = null;
                ResultSet rs = null;
                new ArrayList();
                new ArrayList();
                try {
                    try {
                        connection = DBCPInit.getInstance().getConnection();
                        StringBuffer with_cte = new StringBuffer();
                        String sql = String.format(" SELECT ifnull(WORKSEQ,'') from workmngr where shopcd = ? and workcd = '%s' and workdetcd = '%s' and prodseq = ? and shopseq = ?  and user_id = ? and addrseq = ? and compno = ? ", "100", "W01");
                        with_cte.append(sql);
                        sql = with_cte.toString().toUpperCase();
                        pstmt = connection.prepareStatement(sql);
                        pstmt.setString(1, sendDTO.getShoppingmallDTO().getSHOPCD());
                        pstmt.setString(2, sendDTO.getShopProductDto().get(i).getPRODSEQ());
                        pstmt.setInt(3, sendDTO.getShoppingmallDTO().getSHOPSEQ());
                        pstmt.setString(4, sendDTO.getShoppingmallDTO().getSHOPPINGID());
                        pstmt.setString(5, sendDTO.getProductAdditionDto().getSeq());
                        pstmt.setString(6, YDMASessonUtil.getCompnoInfo().getCompno());
                        YDMAStringUtil.Print(pstmt.toString());
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            sendDTO.getShopProductDto().get(i).setWorkseq(rs.getString(1));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                    throw throwable;
                }
                DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            }
            ++i;
        }
        return sendDTO;
    }

    public void setWorkstatsUpdate(ProductDTO dto, String \uc9c4\ud589\uc911, String rate) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "update workmngr    set WORKDETCD=?, WORKCURRRATE=?, WORKDATEFROM = ?  where compno= ?  AND WORKGRP=? and WORKSEQ = ?   ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                int rowIdx = 0;
                pstmt.setString(++rowIdx, \uc9c4\ud589\uc911);
                pstmt.setString(++rowIdx, rate);
                pstmt.setString(++rowIdx, dto.getWorkdatefrom());
                pstmt.setString(++rowIdx, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(++rowIdx, dto.getWorkgrp());
                pstmt.setString(++rowIdx, dto.getWorkseq());
                YDMAStringUtil.Print("[setWorkstatsUpdate]" + pstmt.toString());
                pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
    }

    public void setWorkstatsSuccessUpdate(ProductDTO dto, String \uc644\ub8cc, String rate, String workstats, String worklog) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "update workmngr set WORKDETCD=?, WORKCURRRATE=?, WORKDATETO = ?, WORKDLAPSED = ?, WORKSTATS = ?, WORKLOG = ?  where compno= ? and WORKSEQ = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                int rowIdx = 0;
                pstmt.setString(++rowIdx, \uc644\ub8cc);
                pstmt.setString(++rowIdx, rate);
                pstmt.setString(++rowIdx, YDMATimeUtil.getCurrentTimeByYDFormat());
                pstmt.setString(++rowIdx, YDMATimeUtil.getOffset(dto.getWorkdatefrom(), YDMATimeUtil.getCurrentTimeByYDFormat()));
                pstmt.setString(++rowIdx, workstats);
                pstmt.setString(++rowIdx, worklog);
                pstmt.setString(++rowIdx, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(++rowIdx, dto.getWorkseq());
                YDMAStringUtil.Print("[setWorkstatsSuccessUpdate]" + pstmt.toString());
                pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
    }
}

