/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.shop.data.kakaostore;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.common.YDMATimeUtil;
import com.kdjsystem.mlink.yellim.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.yellim.shop.dao.ShopOrderDao;
import com.kdjsystem.mlink.yellim.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.yellim.shop.data.kakaostore.IShopOrderKakaoStoreCommand;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

class KakaoStoreOrderNewCommand
extends IShopOrderKakaoStoreCommand {
    private static IShopOrderCommand instance = new KakaoStoreOrderNewCommand();
    boolean flag;

    public static IShopOrderCommand getInstance() {
        return instance;
    }

    private KakaoStoreOrderNewCommand() {
    }

    @Override
    public int Search(String URL2, String startdt, String enddt) throws Exception {
        return 0;
    }

    @Override
    public List<ShopOrderMstDto> Completed(List<ShopOrderMstDto> param) throws Exception {
        ArrayList<ShopOrderMstDto> dtolist = new ArrayList<ShopOrderMstDto>();
        try {
            String startdt = param.get(0).getStartDt().substring(0, 8);
            String enddt = param.get(0).getEndDt().substring(0, 8);
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
            Date sdate = formatter.parse(startdt);
            Date edate = formatter.parse(enddt);
            long range = Math.abs((edate.getTime() - sdate.getTime()) / 86400000L) + 1L;
            Calendar cal1 = Calendar.getInstance();
            Calendar cal2 = Calendar.getInstance();
            cal1.setTime(sdate);
            cal2.setTime(sdate);
            int i = 0;
            while (i < (int)range) {
                this.getOrder(param, startdt, dtolist, 1);
                cal1.add(5, 1);
                startdt = formatter.format(cal1.getTime());
                ++i;
            }
        }
        catch (Exception exception) {
            throw new Exception("\uce74\uce74\uc624\uc2a4\ud1a0\uc5b4 \uc8fc\ubb38 \ub3d9\uae30\ud654\uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd \ud588\uc2b5\ub2c8\ub2e4.");
        }
        return dtolist;
    }

    public List<ShopOrderMstDto> getOrder(List<ShopOrderMstDto> param, String date, List<ShopOrderMstDto> dtolist, int page) throws Exception {
        return dtolist;
    }

    public List<ShopOrderMstDto> getOrder2(List<ShopOrderMstDto> param, String date, List<ShopOrderMstDto> dtolist, int page) throws Exception {
        return dtolist;
    }

    public void orderConfirm(String odNo, String apikey) throws Exception {
        String json = "{\"orderIds\": [" + odNo + "]}";
        try {
            Connection.Response response = Jsoup.connect((String)"https://kapi.kakao.com/v1/shopping/orders/deliveries/status/confirm").header("Host", "kapi.kakao.com").header("Authorization", "KakaoAK b99a474fd6fe27f966e76e37591f0053").header("Target-Authorization", "KakaoAK " + apikey).header("channel-ids", "101").header("Content-Type", "application/json").requestBody(json).followRedirects(true).ignoreContentType(true).ignoreHttpErrors(true).method(Connection.Method.POST).execute();
            YDMAStringUtil.Print(response.body().toString());
        }
        catch (Exception exception) {
            throw new Exception("\uce74\uce74\uc624\uc2a4\ud1a0\uc5b4 \uc8fc\ubb38\ud655\uc778 \uc911 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
        }
    }

    public List<ShopOrderMstDto> dataMapping(List<ShopOrderMstDto> param, JsonObject object, String status2, List<ShopOrderMstDto> dtolist) {
        try {
            String odNo = object.get("orderId").getAsString();
            boolean ordMatch = dtolist.stream().anyMatch(s -> s.getOrder_id().equals(odNo));
            if (!ShopOrderDao.get().isOrdered(odNo) && !ordMatch) {
                ShopOrderMstDto dto = new ShopOrderMstDto();
                dto.setShopid(param.get(0).getShopid());
                dto.setShop_userid(param.get(0).getShop_userid());
                dto.setOrder_id(this.isNullCheck(object.get("orderId")));
                dto.setReg_date(YDMATimeUtil.getCurrentTimeByYDFormat());
                dto.setOrder_status(status2);
                Object ordDt = object.get("createdAt").getAsString();
                ordDt = ((String)ordDt).substring(0, 4) + "-" + ((String)ordDt).substring(4, 6) + "-" + ((String)ordDt).substring(6, 8) + " " + ((String)ordDt).substring(8, 10) + ":" + ((String)ordDt).substring(10, 12) + ":" + ((String)ordDt).substring(12, 14);
                dto.setOrder_date((String)ordDt);
                Connection.Response response_order = Jsoup.connect((String)("https://kapi.kakao.com/v1/shopping/order?order_id=" + odNo)).header("Host", "kapi.kakao.com").header("Authorization", "KakaoAK b99a474fd6fe27f966e76e37591f0053").header("Target-Authorization", "KakaoAK " + param.get(0).getApikey()).header("channel-ids", "101").header("Content-Type", "application/x-www-form-urlencoded;charset=utf-8").followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).execute();
                String body = response_order.body();
                JsonParser jsonParser = new JsonParser();
                JsonObject jsonObject = (JsonObject)jsonParser.parse(body);
                JsonObject orderer = (JsonObject)jsonObject.get("orderer");
                String phoneNumber = this.isNullCheck(orderer.get("phoneNumber")).replace("+82 ", "0");
                dto.setUser_tel(phoneNumber);
                JsonObject prdinfo = (JsonObject)jsonObject.get("orderProduct");
                dto.setMall_product_id(this.isNullCheck(prdinfo.get("id")));
                dto.setP_product_name(this.isNullCheck(prdinfo.get("name")));
                dto.setProduct_name(this.isNullCheck(prdinfo.get("name")));
                dto.setCompayny_goods_cd(this.isNullCheck(prdinfo.get("sellerItemNo")));
                dto.setProduct_id(this.isNullCheck(prdinfo.get("sellerItemNo")));
                dto.setCompno(param.get(0).getCompno());
                dto.setP_sku_value(this.isNullCheck(prdinfo.get("optionContent")));
                prdinfo.get("quantity").getAsInt();
                int productPrice = prdinfo.get("settlementBasicPrice").getAsInt();
                int optionPrice = prdinfo.get("optionPrice").getAsInt();
                int baseFee = prdinfo.get("baseFee").getAsInt();
                int displayFee = prdinfo.get("displayFee").getAsInt();
                int deliveryAmount = prdinfo.get("deliveryAmount").getAsInt();
                dto.setWon_cost("0");
                dto.setSale_cnt(this.isNullCheck(prdinfo.get("quantity")));
                dto.setTotal_cost(String.valueOf(productPrice + optionPrice));
                dto.setMall_won_cost(String.valueOf(productPrice + optionPrice - baseFee - displayFee));
                dto.setSale_cost(String.valueOf(productPrice + optionPrice));
                dto.setDelv_cost(this.isNullCheck(prdinfo.get("deliveryAmount")));
                String deliveryAmountType = this.deliveryAmountType(prdinfo.get("deliveryAmountType").getAsString());
                String PayPointTime = this.isNullCheck(prdinfo.get("deliveryAmountPayPointTime"));
                dto.setDelivery_method_str2(deliveryAmountType.equals("\ubb34\ub8cc") ? "\ubb34\ub8cc" : (PayPointTime.equals("PayedToOrder") ? "\uc120\ubd88" : "\ucc29\ubd88"));
                JsonObject deliveryReq = (JsonObject)jsonObject.get("orderDeliveryRequest");
                dto.setDelv_msg(this.isNullCheck(deliveryReq.get("requirement")));
                String roadZipCode = this.isNullCheck(deliveryReq.get("roadZipCode"));
                String zipcode = this.isNullCheck(deliveryReq.get("zipcode"));
                if (zipcode.length() > roadZipCode.length()) {
                    dto.setReceive_zipcode(zipcode);
                } else {
                    dto.setReceive_zipcode(roadZipCode);
                }
                dto.setReceive_addr(this.isNullCheck(deliveryReq.get("receiverAddress")));
                dto.setUser_cel(phoneNumber);
                dto.setUser_email("");
                dto.setReceive_tel(this.isNullCheck(deliveryReq.get("receiverPhoneNumber")));
                dto.setReceive_cel(this.isNullCheck(deliveryReq.get("receiverMobileNumber")));
                dto.setReceive_email("");
                dto.setUser_id("");
                dto.setUser_name("");
                dto.setReceive_name(this.isNullCheck(deliveryReq.get("receiverName")));
                dto.setDelivery_id("");
                dto.setInvoice_no("");
                dto.setLabel("");
                dto.setPay_cost(String.valueOf(productPrice + optionPrice + deliveryAmount));
                dto.setBox_ea("0");
                dto.setMall_exp_cd("0");
                dto.setAuthkey1(param.get(0).getAuthkey1());
                dto.setResult_code("1");
                dtolist.add(dto);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dtolist;
    }

    public String deliveryAmountType(String keyword) {
        switch (keyword) {
            case "FREE": {
                return "\ubb34\ub8cc";
            }
            case "PAID": {
                return "\uc720\ub8cc";
            }
            case "CONDITIONAL_FREE": {
                return "\uc870\uac74\ubd80\ubb34\ub8cc";
            }
            case "QUANTITY_PAID": {
                return "\uc218\ub7c9\ubcc4 \ubd80\uacfc";
            }
        }
        return keyword;
    }

    private String isNullCheck(JsonElement jsonElement) {
        YDMAStringUtil.Print();
        String value = jsonElement == null ? "" : (jsonElement.isJsonNull() ? "" : (jsonElement.getAsString().isEmpty() ? "" : jsonElement.getAsString()));
        return value;
    }
}

