/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.shop.data.lotteon;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.yellim.common.YDMATimeUtil;
import com.kdjsystem.mlink.yellim.data.dao.QuestListDto;
import com.kdjsystem.mlink.yellim.shop.data.lotteon.LotteOnProductQnaDto;
import com.kdjsystem.mlink.yellim.shop.data.lotteon.ShopLotteOnQuestionContext;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class ShopLotteOnQuestionSearch
extends ShopLotteOnQuestionContext {
    private static final String Host = "https://openapi.lotteon.com";
    OkHttpClient client = new OkHttpClient().newBuilder().hostnameVerifier(new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }).build();
    Map<String, String> cookie;

    @Override
    public List<QuestListDto> excute(List<QuestListDto> prodList) throws Exception {
        String listtp;
        ArrayList<QuestListDto> dtoArray = new ArrayList<QuestListDto>();
        ObjectMapper mapper = new ObjectMapper();
        switch (listtp = prodList.get(0).getBtnstats()) {
            case "\ubb38\uc758": {
                this.customerQnaList(prodList, dtoArray, mapper);
                this.productQnaList(prodList, dtoArray, mapper);
                break;
            }
            case "\uae34\uae09": {
                this.noticeList(prodList, dtoArray, mapper);
                break;
            }
            default: {
                this.customerQnaList(prodList, dtoArray, mapper);
                this.productQnaList(prodList, dtoArray, mapper);
                this.noticeList(prodList, dtoArray, mapper);
            }
        }
        return dtoArray;
    }

    private void customerQnaList(List<QuestListDto> prodList, List<QuestListDto> dtoArray, ObjectMapper mapper) {
        try {
            String json = this.setRequestParam1(prodList);
            MediaType mediaType = MediaType.parse((String)"");
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)json);
            Request request2 = new Request.Builder().url(Host.concat("/v1/openapi/customer/v1/getSellerInquiryList")).method("POST", body).addHeader("Authorization", "Bearer " + prodList.get(0).getApikey()).addHeader("Accept", "application/json").addHeader("Accept-Language", "ko").addHeader("X-Agent-Authorization", "t86ur8pop2rb").addHeader("X-Timezone", "GMT+09:00").addHeader("Content-Type", "application/json").build();
            try {
                Throwable throwable = null;
                Object var9_11 = null;
                try (Response response = this.client.newCall(request2).execute();){
                    JsonParser parser = new JsonParser();
                    JsonObject result = (JsonObject)parser.parse(response.body().string());
                    JsonArray data2 = (JsonArray)result.get("rsltList");
                    if (data2.size() > 0) {
                        int i = 0;
                        while (i < data2.size()) {
                            JsonObject data1 = (JsonObject)data2.get(i);
                            QuestListDto dto = new QuestListDto();
                            if (data1.get("slrInqProcStatCd").getAsString().equals("UNANS")) {
                                dto.setQnaseq(data1.get("slrInqNo").getAsString());
                                dto.setInsdm(data1.get("accpDttm").getAsString().substring(0, 8));
                                dto.setMprodid(data1.get("spdNo").getAsString());
                                dto.setAnsno(data1.get("sitmNo").getAsString());
                                dto.setInsnm("");
                                dto.setSubject("[" + data1.get("vocTypNm").getAsString() + "]" + data1.get("pdNm").getAsString());
                                dto.setSenddt("");
                                dto.setStat("\uace0\uac1d\ubb38\uc758");
                                dto.setQgubun(data1.get("vocTypNm").getAsString());
                                dto.setRegdm(YDMATimeUtil.getCurrentTime());
                                dto.setProdnm(data1.get("spdNm").getAsString());
                                dto.setQuests(data1.get("inqCnts").getAsString());
                                dto.setQnastat("100");
                                dto.setShopid(prodList.get(0).getShopid());
                                dto.setOrdid(data1.get("odNo").getAsString());
                                dto.setShopnm("shop0372");
                                dtoArray.add(dto);
                            }
                            ++i;
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {
                throw new Exception("\ub86f\ub370\uc628 \ubb38\uc758\uc5f0\ub3d9 \uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String setRequestParam1(List<QuestListDto> param) {
        ObjectMapper mapper = new ObjectMapper();
        String json = "";
        try {
            LotteOnProductQnaDto.RequestParameter2 requestParmeter = new LotteOnProductQnaDto.RequestParameter2();
            String startDate = param.get(0).getStartDt().substring(0, 8);
            String endDate = param.get(0).getEndDt().substring(0, 8);
            requestParmeter.scStrtDt = startDate;
            requestParmeter.scEndDt = endDate;
            requestParmeter.rowsPerPage = "100";
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            json = mapper.writeValueAsString((Object)requestParmeter);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return json;
    }

    private void productQnaList(List<QuestListDto> prodList, List<QuestListDto> dtoArray, ObjectMapper mapper) {
        try {
            String json = this.setRequestParam(prodList);
            MediaType mediaType = MediaType.parse((String)"");
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)json);
            Request request2 = new Request.Builder().url(Host.concat("/v1/openapi/product/v1/product/qna/list")).method("POST", body).addHeader("Authorization", "Bearer " + prodList.get(0).getApikey()).addHeader("Accept", "application/json").addHeader("Accept-Language", "ko").addHeader("X-Agent-Authorization", "t86ur8pop2rb").addHeader("X-Timezone", "GMT+09:00").addHeader("Content-Type", "application/json").build();
            try {
                Throwable throwable = null;
                Object var9_11 = null;
                try (Response response = this.client.newCall(request2).execute();){
                    JsonParser parser = new JsonParser();
                    JsonObject result = (JsonObject)parser.parse(response.body().string());
                    JsonArray data2 = (JsonArray)result.get("data");
                    if (data2.size() > 0) {
                        int i = 0;
                        while (i < data2.size()) {
                            JsonObject data1 = (JsonObject)data2.get(i);
                            QuestListDto dto = new QuestListDto();
                            dto.setQnaseq(data1.get("pdQnaNo").getAsString());
                            dto.setInsdm(data1.get("regDttm").getAsString().substring(0, 8));
                            dto.setMprodid(data1.get("spdNo").getAsString());
                            dto.setAnsno(data1.get("sitmNo").getAsString());
                            dto.setInsnm("");
                            dto.setSubject(this.getQustionTitle(data1.get("qstTypCd").getAsString()));
                            dto.setSenddt("");
                            dto.setStat("\uc0c1\ud488\ubb38\uc758");
                            dto.setRegdm(YDMATimeUtil.getCurrentTime());
                            dto.setProdnm("");
                            dto.setQuests(data1.get("qstCnts").getAsString());
                            dto.setQnastat(data1.get("qnaStatCd").getAsString().equals("NPROC") ? "100" : "101");
                            dto.setShopid(prodList.get(0).getShopid());
                            dto.setOrdid("");
                            dto.setShopnm("shop0372");
                            dtoArray.add(dto);
                            ++i;
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {
                throw new Exception("\ub86f\ub370\uc628 \ubb38\uc758\uc5f0\ub3d9 \uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String setRequestParam(List<QuestListDto> param) {
        ObjectMapper mapper = new ObjectMapper();
        String json = "";
        try {
            LotteOnProductQnaDto.RequestParameter requestParmeter = new LotteOnProductQnaDto.RequestParameter();
            String startDate = param.get(0).getStartDt().substring(0, 8) + "000000";
            String endDate = param.get(0).getEndDt().substring(0, 8) + "235959";
            Calendar calender_dateTime_from = Calendar.getInstance();
            calender_dateTime_from.add(5, -6);
            Date date_from = calender_dateTime_from.getTime();
            new SimpleDateFormat("yyyyMMdd").format(date_from);
            requestParmeter.trGrpCd = "SR";
            requestParmeter.trNo = param.get(0).getAuthkey1();
            requestParmeter.regStrDttm = startDate;
            requestParmeter.regEndDttm = endDate;
            requestParmeter.pageNo = "1";
            requestParmeter.rowsPerPage = "100";
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            json = mapper.writeValueAsString((Object)requestParmeter);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return json;
    }

    private void noticeList(List<QuestListDto> prodList, List<QuestListDto> dtoArray, ObjectMapper mapper) {
        try {
            String startDate = prodList.get(0).getStartDt().substring(0, 8);
            String endDate = prodList.get(0).getEndDt().substring(0, 8);
            String json = "{\"scStrtDt\":\"" + startDate + "\",\"scEndDt\":\"" + endDate + "\", \"ctctCfmYn\" : \"N\"}";
            MediaType mediaType = MediaType.parse((String)"");
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)json);
            Request request2 = new Request.Builder().url(Host.concat("/v1/openapi/customer/v1/getSellerContactList")).method("POST", body).addHeader("Authorization", "Bearer " + prodList.get(0).getApikey()).addHeader("Accept", "application/json").addHeader("Accept-Language", "ko").addHeader("X-Agent-Authorization", "t86ur8pop2rb").addHeader("X-Timezone", "GMT+09:00").addHeader("Content-Type", "application/json").build();
            try {
                Throwable throwable = null;
                Object var11_13 = null;
                try (Response response = this.client.newCall(request2).execute();){
                    JsonParser parser = new JsonParser();
                    JsonObject result = (JsonObject)parser.parse(response.body().string());
                    JsonArray data2 = (JsonArray)result.get("rsltList");
                    if (data2.size() > 0) {
                        int i = 0;
                        while (i < data2.size()) {
                            JsonObject data1 = (JsonObject)data2.get(i);
                            if (data1.get("sndDvsNm").getAsString().equals("\ubc1c\uc1a1")) {
                                QuestListDto dto = new QuestListDto();
                                dto.setQnaseq(data1.get("slrCtctGrpNo").getAsString());
                                dto.setInsdm(data1.get("sndDttm").getAsString().substring(0, 8));
                                dto.setMprodid("");
                                dto.setAnsno("");
                                dto.setInsnm("");
                                dto.setSubject(data1.get("ctctTtl").getAsString());
                                dto.setSenddt("");
                                dto.setStat(data1.get("ugntYn").getAsString().equals("Y") ? "\uae34\uae09\uc54c\ub9bc" : "\ud310\ub9e4\uc790\uc54c\ub9bc");
                                dto.setRegdm(YDMATimeUtil.getCurrentTime());
                                dto.setProdnm("");
                                dto.setQuests(data1.get("ctctCnts").getAsString());
                                dto.setQnastat("100");
                                dto.setOrdid("");
                                dto.setShopnm("shop0372");
                                dto.setShopid(prodList.get(0).getShopid());
                                boolean QnaseqMatch = dtoArray.stream().anyMatch(s -> s.getQnaseq().equals(dto.getQnaseq()));
                                if (!QnaseqMatch) {
                                    dtoArray.add(dto);
                                }
                            }
                            ++i;
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {
                throw new Exception("\ub86f\ub370\uc628 \ubb38\uc758\uc5f0\ub3d9 \uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getQustionTitle(String qstTypCd) {
        String value = "";
        switch (qstTypCd) {
            case "SZ_CAPA": {
                value = "\uc0ac\uc774\uc988/\uc6a9\ub7c9";
                break;
            }
            case "DSGN_CLR": {
                value = "\ub514\uc790\uc778/\uc0c9\uc0c1";
                break;
            }
            case "DP_INFO": {
                value = "\uc0c1\ud488\uc815\ubcf4";
                break;
            }
            case "USE_EPN": {
                value = "\uc0ac\uc6a9\uc124\uba85";
                break;
            }
            case "CMPN": {
                value = "\uad6c\uc131\ud488";
                break;
            }
            case "ETC": {
                value = "\uae30\ud0c0";
                break;
            }
        }
        return value;
    }
}

