/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.shop.domesin;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.shop.common.HttpClientEx;
import com.kdjsystem.mlink.yellim.shop.domesin.CategoryItemDomesinDto;
import com.kdjsystem.mlink.yellim.shop.domesin.DomesinSessonUtil;
import com.kdjsystem.mlink.yellim.shop.domesin.LoginResponseDto;
import java.lang.invoke.CallSite;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DomesinAPI {
    private static DomesinAPI instance = new DomesinAPI();
    static final String LOGIN_HOST = "http://www.domesin.com";
    static final String DATA_HOST = "http://data.domesin.com";

    public static DomesinAPI get() {
        return instance;
    }

    public String ConvertDictionaryToParameter(Map<String, String> parameters) {
        ArrayList<CallSite> list = new ArrayList<CallSite>();
        for (String key : parameters.keySet()) {
            String value = parameters.get(key);
            list.add((CallSite)((Object)(key + "=" + value)));
        }
        return list.stream().collect(Collectors.joining("&"));
    }

    private boolean loadCategory() throws Exception {
        HashMap<String, String> postPara = null;
        String response = "";
        String path = "/API/COUPANG4/category.php";
        YDMAStringUtil.Print("[DoMeSin] load category start...");
        postPara = new HashMap<String, String>();
        postPara.put("id", DomesinSessonUtil.get().getUserId());
        postPara.put("api_key", DomesinSessonUtil.get().getApiKey());
        String postForm = this.ConvertDictionaryToParameter(postPara);
        response = HttpClientEx.get().addParam("ContentType", "application/x-www-form-urlencoded").Post(DATA_HOST.concat(path), postForm);
        if (response == null) {
            return false;
        }
        ObjectMapper mapper = new ObjectMapper();
        CategoryDomesin Category2 = null;
        Category2 = (CategoryDomesin)mapper.readValue(response, CategoryDomesin.class);
        if (Category2.code.equals("0000")) {
            List<CategoryItemDomesinDto> largeCategory = Arrays.asList(Category2.data).stream().filter(p -> p.deep.equals("1")).collect(Collectors.toList());
            DomesinSessonUtil.get().setLargeCategory(largeCategory);
            List<CategoryItemDomesinDto> midCategory = Arrays.asList(Category2.data).stream().filter(p -> p.deep.equals("2")).collect(Collectors.toList());
            DomesinSessonUtil.get().setMidCategory(midCategory);
            List<CategoryItemDomesinDto> smallCategory = Arrays.asList(Category2.data).stream().filter(p -> p.deep.equals("3")).collect(Collectors.toList());
            DomesinSessonUtil.get().setSmallCategory(smallCategory);
            DomesinSessonUtil.get().setAllCategory(Arrays.asList(Category2.data));
        } else {
            String FailReason = "\uce74\ud14c\uace0\ub9ac\uc5d0 \uc815\uc758\ub418\uc9c0 \uc54a\uc740 \uc5d0\ub7ec\uac00 \uc788\uc2b5\ub2c8\ub2e4...";
            YDMAStringUtil.Print("    Error: " + FailReason);
        }
        YDMAStringUtil.Print("[DoMeSin] load category finish...");
        return true;
    }

    public boolean Login(String id, String password) throws Exception {
        boolean retVal;
        block25: {
            block26: {
                retVal = false;
                String path = "/API/COUPANG4/login_new.php";
                String formParams = String.format("id=%s&pw=%s", id, URLEncoder.encode(password, "UTF-8"));
                String response = HttpClientEx.get().addParam("ContentType", "application/x-www-form-urlencoded").Post(DATA_HOST.concat(path), formParams);
                if (response == null || response.length() <= 0) break block26;
                try {
                    ObjectMapper mapper = new ObjectMapper();
                    LoginResponseDto userInfo = (LoginResponseDto)mapper.readValue(response, LoginResponseDto.class);
                    if (userInfo.code.equals("0000")) {
                        retVal = true;
                        DomesinSessonUtil.get().setUserInfo(userInfo);
                        this.loadCategory();
                        break block25;
                    }
                    switch (userInfo.code) {
                        case "1001": {
                            DomesinSessonUtil.get().ResultLoginText = "\ub85c\uadf8\uc778\ud558\uc2e4 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \uace0\uac1d\uc13c\ud130\uc5d0 \ubb38\uc758\ud574 \uc8fc\uc2ed\uc2dc\uc624(\ucc28\ub2e8\uc544\uc774\ub514)";
                            break;
                        }
                        case "1002": {
                            DomesinSessonUtil.get().ResultLoginText = "\uc2b9\uc778\ub300\uae30\uc911 \uc774\uc2ed\ub2c8\ub2e4. \uc2b9\uc778\ud6c4 \uc774\uc6a9\ud558\uc2e4 \uc218 \uc788\uc2b5\ub2c8\ub2e4.";
                            break;
                        }
                        case "1003": {
                            DomesinSessonUtil.get().ResultLoginText = "\uacf5\uae09\uc0ac\ud68c\uc6d0\uc740 \uc774\uc6a9\ud558\uc2e4 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \uc140\ub7ec\ud68c\uc6d0 \uc2e0\uccad\ud6c4 \uc774\uc6a9\ud558\uc2e4 \uc218 \uc788\uc2b5\ub2c8\ub2e4.";
                            break;
                        }
                        case "1004": {
                            DomesinSessonUtil.get().ResultLoginText = "\uae30\ud0c0\uc624\ub958(\uc778\uc99d\uacfc\uc815\uc5d0 \ubb38\uc81c\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. \uace0\uac1d\uc13c\ud130\ub85c \ubb38\uc758\ud574 \uc8fc\uc138\uc694)";
                            break;
                        }
                        case "1005": {
                            DomesinSessonUtil.get().ResultLoginText = "\ud310\ub9e4\ud68c\uc6d0 \uc778\uc99d\ud0a4\uac00 \uc5c6\uc2b5\ub2c8\ub2e4. \uad00\ub9ac\uc790 \uc2b9\uc778\ud6c4 \uc774\uc6a9\ud558\uc2e4 \uc218 \uc788\uc2b5\ub2c8\ub2e4. \uace0\uac1d\uc13c\ud130\ub85c \uc694\uccad\ud574 \uc8fc\uc138\uc694";
                            break;
                        }
                        case "1006": {
                            DomesinSessonUtil.get().ResultLoginText = "\ud68c\uc6d0\uc544\uc774\ub514 \ub610\ub294 \ube44\ubc00\ubc88\ud638\ub97c \ud655\uc778\ud574 \uc8fc\uc138\uc694";
                            break;
                        }
                        default: {
                            DomesinSessonUtil.get().ResultLoginText = "\uc815\uc758\ub418\uc5b4 \uc788\uc9c0 \uc54a\ub294 \uc5d0\ub7ec\uc785\ub2c8\ub2e4. \uc5d0\ub7ec\ubc88\ud638: [" + userInfo.code + "], \uace0\uac1d\uc13c\ud130\ub85c \ubb38\uc758\ud574 \uc8fc\uc138\uc694";
                        }
                    }
                    retVal = false;
                }
                catch (Exception e) {
                    retVal = false;
                    DomesinSessonUtil.get().ResultLoginText = e.getMessage();
                }
                break block25;
            }
            retVal = false;
            DomesinSessonUtil.get().ResultLoginText = "\ub85c\uadf8\uc778 \uc11c\ubc84\ub85c\ubd80\ud130 \uc751\ub2f5\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.";
        }
        return retVal;
    }

    private static final class CategoryDomesin {
        @JsonProperty(value="code")
        public String code;
        @JsonProperty(value="data")
        public CategoryItemDomesinDto[] data;

        private CategoryDomesin() {
        }
    }
}

