/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.shop.jcef;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.cef.browser.CefBrowser;
import org.cef.callback.CefBeforeDownloadCallback;
import org.cef.callback.CefDownloadItem;
import org.cef.callback.CefDownloadItemCallback;
import org.cef.handler.CefDownloadHandler;

public class DownloadDialog
extends JDialog
implements CefDownloadHandler {
    private final Frame owner_;
    private final Map<Integer, DownloadObject> downloadObjects_ = new HashMap<Integer, DownloadObject>();
    private final JPanel downloadPanel_ = new JPanel();
    private final DownloadDialog dialog_;

    public DownloadDialog(Frame owner) {
        super(owner, "Downloads", false);
        this.setVisible(false);
        this.setSize(400, 300);
        this.owner_ = owner;
        this.dialog_ = this;
        this.downloadPanel_.setLayout(new BoxLayout(this.downloadPanel_, 1));
        this.add(this.downloadPanel_);
    }

    public void onBeforeDownload(CefBrowser browser, CefDownloadItem downloadItem, String suggestedName, CefBeforeDownloadCallback callback) {
        callback.Continue(suggestedName, true);
        DownloadObject dlObject = new DownloadObject(downloadItem, suggestedName);
        this.downloadObjects_.put(downloadItem.getId(), dlObject);
        this.downloadPanel_.add(dlObject);
    }

    public void onDownloadUpdated(CefBrowser browser, CefDownloadItem downloadItem, CefDownloadItemCallback callback) {
        DownloadObject dlObject = this.downloadObjects_.get(downloadItem.getId());
        if (dlObject == null) {
            return;
        }
        dlObject.update(downloadItem, callback);
    }

    private class DownloadObject
    extends JPanel {
        private boolean isHidden_ = true;
        private final int identifier_;
        private JLabel fileName_ = new JLabel();
        private JLabel status_ = new JLabel();
        private JButton dlAbort_ = new JButton();
        private JButton dlRemoveEntry_ = new JButton("x");
        private CefDownloadItemCallback callback_;
        private Color bgColor_;

        DownloadObject(CefDownloadItem downloadItem, String suggestedName) {
            this.setOpaque(true);
            this.setLayout(new BorderLayout());
            this.setMaximumSize(new Dimension(DownloadDialog.this.dialog_.getWidth() - 10, 80));
            this.identifier_ = downloadItem.getId();
            this.bgColor_ = this.identifier_ % 2 == 0 ? Color.WHITE : Color.YELLOW;
            this.setBackground(this.bgColor_);
            this.fileName_.setText(suggestedName);
            this.add((Component)this.fileName_, "North");
            this.status_.setAlignmentX(0.0f);
            this.add((Component)this.status_, "Center");
            JPanel controlPane = new JPanel();
            controlPane.setLayout(new BoxLayout(controlPane, 0));
            controlPane.setOpaque(true);
            controlPane.setBackground(this.bgColor_);
            this.dlAbort_.setText("Abort");
            this.dlAbort_.setEnabled(false);
            this.dlAbort_.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DownloadObject.this.callback_ != null) {
                        DownloadObject.this.fileName_.setText("ABORTED - " + DownloadObject.this.fileName_.getText());
                        DownloadObject.this.callback_.cancel();
                    }
                }
            });
            controlPane.add(this.dlAbort_);
            this.dlRemoveEntry_.setEnabled(false);
            this.dlRemoveEntry_.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DownloadObject removed = ((DownloadObject)DownloadObject.this).DownloadDialog.this.downloadObjects_.remove(DownloadObject.this.identifier_);
                    if (removed != null) {
                        ((DownloadObject)DownloadObject.this).DownloadDialog.this.downloadPanel_.remove(removed);
                        ((DownloadObject)DownloadObject.this).DownloadDialog.this.dialog_.repaint();
                    }
                }
            });
            controlPane.add(this.dlRemoveEntry_);
            this.add((Component)controlPane, "South");
            this.update(downloadItem, null);
        }

        String humanReadableByteCount(long bytes) {
            int unit = 1024;
            if (bytes < (long)unit) {
                return bytes + " B";
            }
            int exp = (int)(Math.log(bytes) / Math.log(unit));
            String pre = "" + "kMGTPE".charAt(exp - 1);
            return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
        }

        void update(CefDownloadItem downloadItem, CefDownloadItemCallback callback) {
            int percentComplete = downloadItem.getPercentComplete();
            String rcvBytes = this.humanReadableByteCount(downloadItem.getReceivedBytes());
            String totalBytes = this.humanReadableByteCount(downloadItem.getTotalBytes());
            String speed = this.humanReadableByteCount(downloadItem.getCurrentSpeed()) + "it/s";
            if (downloadItem.getReceivedBytes() >= 5L && this.isHidden_) {
                DownloadDialog.this.dialog_.setVisible(true);
                DownloadDialog.this.dialog_.toFront();
                DownloadDialog.this.owner_.toBack();
                this.isHidden_ = false;
            }
            Runtime.getRuntime().runFinalization();
            this.callback_ = callback;
            this.status_.setText(rcvBytes + " of " + totalBytes + " - " + percentComplete + "% - " + speed);
            this.dlAbort_.setEnabled(downloadItem.isInProgress());
            this.dlRemoveEntry_.setEnabled(!downloadItem.isInProgress() || downloadItem.isCanceled() || downloadItem.isComplete());
            if (!(downloadItem.isInProgress() || downloadItem.isCanceled() || downloadItem.isComplete())) {
                this.fileName_.setText("FAILED - " + this.fileName_.getText());
                callback.cancel();
            }
        }
    }
}

