/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.util;

import com.kdjsystem.mlink.yellim.common.YDMATimeUtil;
import com.kdjsystem.mlink.yellim.controls.ComboItem;
import com.kdjsystem.mlink.yellim.dao.DomemallDAO;
import com.kdjsystem.mlink.yellim.dao.ShoppingmallDAO;
import com.kdjsystem.mlink.yellim.dto.DomemallDTO;
import com.kdjsystem.mlink.yellim.dto.ShoppingmallDTO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.swt.widgets.TreeItem;

public class ProductAddUtil {
    public List<ComboItem> getShopComboItems() {
        ArrayList<ComboItem> result = new ArrayList<ComboItem>();
        try {
            List<ShoppingmallDTO> infos = ShoppingmallDAO.get().selectShoppingmallInfos();
            Map<String, Map<String, List<ShoppingmallDTO>>> mapList = infos.stream().collect(Collectors.groupingBy(ShoppingmallDTO::getSHOPCD, Collectors.groupingBy(ShoppingmallDTO::getSHOPPINGID)));
            List items = mapList.keySet().stream().collect(Collectors.toList());
            Collections.sort(items);
            for (String shopID : items) {
                LinkedHashMap map = new LinkedHashMap();
                if (mapList.get(shopID) == null) continue;
                mapList.get(shopID).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(x -> {
                    List list = map.put((String)x.getKey(), (List)x.getValue());
                });
                for (String shopUserID : map.keySet()) {
                    List dtos = (List)map.get(shopUserID);
                    for (ShoppingmallDTO dto : dtos) {
                        String code = String.format("%s,%s,%s", String.valueOf(dto.getSHOPSEQ()), String.valueOf(dto.getCOMPNO()), dto.getSHOPCD());
                        ComboItem item = new ComboItem(code, ((ShoppingmallDTO)dtos.get(0)).getSHOPNM() + "(" + dto.getSHOPPINGID() + ")-" + dto.getNICKNM1());
                        item.setSHOPINFO(dto);
                        result.add(item);
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        return result;
    }

    public List<ComboItem> getDomemallComboItems() {
        ArrayList<ComboItem> result = new ArrayList<ComboItem>();
        try {
            List<DomemallDTO> infos = DomemallDAO.get().selectDomemallQuickInfo();
            for (DomemallDTO info : infos) {
                ComboItem item = new ComboItem();
                item.setName(info.getNICKNM1().equals("") ? info.getSHOPNM() : info.getSHOPNM().concat("_").concat(info.getNICKNM1()));
                item.setCode(info.getSHOPCD());
                item.setDOMEINFO(info);
                result.add(item);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        return result;
    }

    public String getSearchDate(String data2) {
        try {
            YDMATimeUtil.getZMonthDiffDay(-1, "yyyyMMdd");
            switch (data2) {
                case "today": {
                    Calendar calendar = Calendar.getInstance();
                    Date date = calendar.getTime();
                    return new SimpleDateFormat("yyyy-MM-dd").format(date);
                }
                case "yesterday": {
                    Calendar calendar = Calendar.getInstance();
                    calendar.add(5, -1);
                    Date date = calendar.getTime();
                    return new SimpleDateFormat("yyyy-MM-dd").format(date);
                }
                case "7days": {
                    Calendar calendar = Calendar.getInstance();
                    calendar.add(5, -7);
                    Date date = calendar.getTime();
                    return new SimpleDateFormat("yyyy-MM-dd").format(date);
                }
                case "15days": {
                    Calendar calendar = Calendar.getInstance();
                    calendar.add(5, -15);
                    Date date = calendar.getTime();
                    return new SimpleDateFormat("yyyy-MM-dd").format(date);
                }
                case "1month": {
                    Calendar calendar = Calendar.getInstance();
                    calendar.add(2, -1);
                    Date date = calendar.getTime();
                    return new SimpleDateFormat("yyyy-MM-dd").format(date);
                }
                case "3months": {
                    Calendar calendar = Calendar.getInstance();
                    calendar.add(2, -3);
                    Date date = calendar.getTime();
                    return new SimpleDateFormat("yyyy-MM-dd").format(date);
                }
                case "1year": {
                    Calendar calendar = Calendar.getInstance();
                    calendar.add(1, -1);
                    Date date = calendar.getTime();
                    return new SimpleDateFormat("yyyy-MM-dd").format(date);
                }
                case "2year": {
                    Calendar calendar = Calendar.getInstance();
                    calendar.add(1, -2);
                    Date date = calendar.getTime();
                    return new SimpleDateFormat("yyyy-MM-dd").format(date);
                }
                case "3year": {
                    Calendar calendar = Calendar.getInstance();
                    calendar.add(1, -3);
                    Date date = calendar.getTime();
                    return new SimpleDateFormat("yyyy-MM-dd").format(date);
                }
                case "5year": {
                    Calendar calendar = Calendar.getInstance();
                    calendar.add(1, -5);
                    Date date = calendar.getTime();
                    return new SimpleDateFormat("yyyy-MM-dd").format(date);
                }
                case "10year": {
                    Calendar calendar = Calendar.getInstance();
                    calendar.add(1, -10);
                    Date date = calendar.getTime();
                    return new SimpleDateFormat("yyyy-MM-dd").format(date);
                }
            }
            return "";
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    public List<ShoppingmallDTO> getSelectedShoppingMallInfos(List<TreeItem> items) {
        ArrayList<ShoppingmallDTO> result = new ArrayList<ShoppingmallDTO>();
        try {
            for (TreeItem item : items) {
                ShoppingmallDTO dto = new ShoppingmallDTO();
                dto.setSHOPNM(item.getText(0));
                dto.setSHOPPINGID(item.getText(1));
                dto.setNICKNM1(item.getText(2));
                dto.setSHOPCD(item.getText(3));
                dto.setSHOPSEQ(Integer.parseInt(item.getText(4)));
                dto.setPASSWORD(item.getText(5));
                dto.setAPIKEY(item.getText(6));
                dto.setAUTHKEY1(item.getText(7));
                dto.setAUTHKEY2(item.getText(8));
                dto.setVENDORID(item.getText(9));
                dto.setSUPPSTDITEM(item.getText(10));
                dto.setSUPPSTDRATI(item.getText(11));
                dto.setEDITAUTHKEY1(item.getText(12));
                dto.setEDITAPIKEY(item.getText(13));
                result.add(dto);
            }
            return result;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

