/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.command;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.workbench.IWorkbench;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.UpdateOperation;

public class UpdateHandler2 {
    private static final String REPOSITORY_LOC = System.getProperty("UpdateHandler.Repo", "http://itsm.kdjsystem.com/mlink/rep/repository");
    private IWorkbench workbench;

    @Execute
    public void execute(IProvisioningAgent agent, IWorkbench workbench) {
        this.workbench = workbench;
        Job updateJob = Job.create((String)"Update Job", monitor -> this.performUpdates(agent, monitor));
        updateJob.schedule();
    }

    private IStatus performUpdates(IProvisioningAgent agent, IProgressMonitor monitor) {
        ProvisioningSession session = new ProvisioningSession(agent);
        UpdateOperation operation = new UpdateOperation(session);
        URI uri = null;
        try {
            uri = new URI(REPOSITORY_LOC);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new OperationCanceledException("Invalid repository location");
        }
        operation.getProvisioningContext().setArtifactRepositories(new URI[]{uri});
        operation.getProvisioningContext().setMetadataRepositories(new URI[]{uri});
        IStatus status2 = operation.resolveModal(monitor);
        if (status2.getCode() == 10000) {
            return Status.CANCEL_STATUS;
        }
        ProvisioningJob provisioningJob = operation.getProvisioningJob(monitor);
        if (provisioningJob == null) {
            return Status.CANCEL_STATUS;
        }
        this.configureProvisioningJob(provisioningJob);
        provisioningJob.schedule();
        return Status.OK_STATUS;
    }

    private void configureProvisioningJob(ProvisioningJob provisioningJob) {
        provisioningJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    UpdateHandler2.this.workbench.close();
                    UpdateHandler2.this.workbench.restart();
                }
                super.done(event);
            }
        });
    }
}

