/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.config;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.dto.ShoppingmallDTO;
import com.kdjsystem.mlink.yellim.shop.common.ChromeExtention;
import com.kdjsystem.mlink.yellim.shop.common.ChromeScript;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Base64;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class AcessConfig {
    private static AcessConfig context = new AcessConfig();
    public static String ACCESSTOKEN = "";
    public static LocalDateTime expTime = LocalDateTime.now();
    public static LocalTime idelTime = LocalTime.now();
    public static ChromeDriver driver;

    static {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }
            }};
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HostnameVerifier allHostsValid = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
    }

    private AcessConfig() {
    }

    public static AcessConfig get() {
        return context;
    }

    public static String getAuthGrantType(String mallId, String clientId, String callbackURL) {
        return AcessConfig.getAuthorizeUrl(mallId) + "?response_type=code&client_id=" + clientId + "&redirect_uri=" + callbackURL + "&scope=mall.read_product,mall.write_product,mall.read_category,mall.write_category,mall.read_store";
    }

    public static String getAuthorizeUrl(String mallId) {
        return "https://" + mallId + ".cafe24api.com/api/v2/oauth/authorize";
    }

    public static String getTokenUrl(String mallId) {
        return "https://" + mallId + ".cafe24api.com/api/v2/oauth/token";
    }

    public boolean checkCafe24Accesstoken(ShoppingmallDTO shopInfo) {
        LocalDateTime currentDateTime = LocalDateTime.now();
        int compval = expTime.compareTo(currentDateTime);
        if (ACCESSTOKEN.equals("") || compval < 0) {
            String code = AcessConfig.getCafe24AuthorizationCode(shopInfo);
            ACCESSTOKEN = AcessConfig.getCafe24ClientCredentials(shopInfo, code);
        }
        return !ACCESSTOKEN.equals("");
    }

    public static String getCafe24AuthorizationCode(ShoppingmallDTO shopInfo) {
        String callBackUrl = shopInfo.getAPIKEY();
        String mallId = shopInfo.getSHOPPINGID();
        String clientId = shopInfo.getAUTHKEY1();
        shopInfo.getAUTHKEY2();
        String loginID = shopInfo.getSHOPPINGID();
        String loginPw = shopInfo.getPASSWORD();
        String authorizationRedirect = AcessConfig.getAuthGrantType(mallId, clientId, callBackUrl);
        try {
            driver = ChromeExtention.getInstace().getDriver();
            new WebDriverWait((WebDriver)driver, 10L);
            driver.get(authorizationRedirect);
            WebElement elementloginBox = driver.findElement(By.xpath((String)"/html/body/div[2]/div/section/div/form/div[1]"));
            elementloginBox.findElement(By.id((String)"mall_id")).sendKeys(new CharSequence[]{loginID});
            elementloginBox.findElement(By.id((String)"userpasswd")).sendKeys(new CharSequence[]{loginPw});
            elementloginBox.findElement(By.xpath((String)"/html/body/div[2]/div[2]/section/div/form/div/div[2]/button")).click();
            try {
                WebElement login = ChromeScript.get().until((WebDriver)driver, () -> driver.findElement(By.xpath((String)"/html/body/div[2]/div/div/div[1]/div[4]")));
                login.findElement(By.id((String)"iptBtnEm")).click();
            }
            catch (Exception exception) {
                YDMAStringUtil.Print("\ubcc0\uacbd\ud560 \ube44\ubc00\ubc88\ud638\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.");
            }
            try {
                WebElement btnsubmit = ChromeScript.get().until((WebDriver)driver, () -> driver.findElement(By.xpath((String)"/html/body/div/div[3]")));
                btnsubmit.findElement(By.className((String)"btnSubmit")).click();
            }
            catch (Exception exception) {
                YDMAStringUtil.Print("\ub3d9\uc758\ud568\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.");
            }
            Thread.sleep(2000L);
            try {
                if (ExpectedConditions.alertIsPresent().apply((Object)driver) != null) {
                    driver.switchTo().alert().accept();
                }
            }
            catch (Exception e) {
                YDMAStringUtil.Print(e.getMessage());
            }
            Thread.sleep(2000L);
            String redirectUrl = driver.getCurrentUrl();
            String code = "";
            List params = URLEncodedUtils.parse((String)redirectUrl, (Charset)Charset.defaultCharset());
            for (NameValuePair param : params) {
                if (!param.getName().contains("code")) continue;
                code = param.getValue();
                break;
            }
            YDMAStringUtil.Print("code=" + code);
            String string = code;
            return string;
        }
        catch (Exception exception) {
            String.format("\uc0ac\uc6a9\uc790 \uc544\uc774\ub514 : %s , \ud328\uc2a4\uc6cc\ub4dc : %s \ub85c\uadf8\uc778\uc774  \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4.", loginID, loginPw);
        }
        finally {
            driver.close();
        }
        return null;
    }

    public static String getCafe24ClientCredentials(ShoppingmallDTO shopInfo, String code) {
        String returnValue;
        block16: {
            Pattern pat = Pattern.compile(".*\"access_token\"\\s*:\\s*\"([^\"]+)\".*");
            String mallId = shopInfo.getSHOPPINGID();
            String clientId = shopInfo.getAUTHKEY1();
            String clientSecret = shopInfo.getAUTHKEY2();
            String callBackUrl = shopInfo.getAPIKEY();
            String tokenUrl = AcessConfig.getTokenUrl(mallId);
            String auth = clientId + ":" + clientSecret;
            String authentication = Base64.getEncoder().encodeToString(auth.getBytes());
            String content = "grant_type=authorization_code&code=" + code + "&redirect_uri=" + callBackUrl;
            BufferedReader reader = null;
            HttpURLConnection connection = null;
            returnValue = "";
            try {
                try {
                    URL url = new URL(tokenUrl);
                    connection = (HttpsURLConnection)url.openConnection();
                    connection.setRequestMethod("POST");
                    connection.setDoOutput(true);
                    connection.setRequestProperty("Authorization", "Basic " + authentication);
                    connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                    connection.setRequestProperty("Accept", "application/json");
                    PrintStream os = new PrintStream(connection.getOutputStream());
                    os.print(content);
                    os.close();
                    reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    String line = null;
                    StringWriter out = new StringWriter(connection.getContentLength() > 0 ? connection.getContentLength() : 2048);
                    while ((line = reader.readLine()) != null) {
                        out.append(line);
                    }
                    String response = out.toString();
                    JsonParser jsonparser = new JsonParser();
                    JsonObject jsonobject = (JsonObject)jsonparser.parse(response);
                    String from = jsonobject.get("expires_at").getAsString();
                    expTime = LocalDateTime.parse(from);
                    Matcher matcher = pat.matcher(response);
                    if (matcher.matches() && matcher.groupCount() > 0) {
                        returnValue = matcher.group(1);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    YDMAStringUtil.Print("Error : " + e.getMessage());
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    connection.disconnect();
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                connection.disconnect();
                throw throwable;
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            connection.disconnect();
        }
        YDMAStringUtil.Print("Access Token=" + returnValue);
        return returnValue;
    }
}

