/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.dao;

import com.kdjsystem.mlink.yellim.common.YDMASessonUtil;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.data.dao.DBCPInit;
import com.kdjsystem.mlink.yellim.dto.DomemallDTO;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;

public class DomemallDAO {
    private static DomemallDAO instance = new DomemallDAO();

    public static DomemallDAO get() {
        return instance;
    }

    public List<DomemallDTO> selectDomemallInfos() {
        List<DomemallDTO> result = new ArrayList<DomemallDTO>();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(DomemallDTO.class);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                String compno = YDMASessonUtil.getCompnoInfo().getCompno();
                StringBuilder query = new StringBuilder();
                query.append("SELECT  \r\n");
                query.append("      IFNULL(A.COMPNO, '') \t\t AS COMPNO  \r\n");
                query.append("    , IFNULL(A.SHOPCD,'')  \t\t AS SHOPCD  \r\n");
                query.append("    , IFNULL(C.SHOPNM,'')  \t\t AS SHOPNM  \r\n");
                query.append("    , IFNULL(C.SHOPURL,'') \t\t AS SHOPURL  \r\n");
                query.append("    , IFNULL(B.SHOPPINGID,'') \t AS SHOPPINGID  \r\n");
                query.append("    , IFNULL(B.NICKNM1, B.NICKNM2) AS NICKNM1  \r\n");
                query.append("    , IFNULL(B.APIKEY,'') \t\t AS APIKEY  \r\n");
                query.append("    , IFNULL(B.DEALTREAD,'') \t     AS DEALTREAD  \r\n");
                query.append("    , IFNULL(B.PASSWORD, '') \t     AS PASSWORD  \r\n");
                query.append("    , IFNULL(B.AUTHKEY1, '') \t     AS AUTHKEY1  \r\n");
                query.append("    , IFNULL(B.AUTHKEY2, '') \t     AS AUTHKEY2  \r\n");
                query.append("    , IFNULL(B.EDITAUTHKEY1, '')   AS EDITAUTHKEY1  \r\n");
                query.append("    , IFNULL(B.EDITAPIKEY, '') \t AS EDITAPIKEY  \r\n");
                query.append("    , IFNULL(B.NICKNM2, '') \t     AS VENDORID  \r\n");
                query.append("    , IFNULL(B.SHOPSEQ, '') \t     AS SHOPSEQ  \r\n");
                query.append("    , IFNULL(B.SUPPSTDITEM, '')    AS SUPPSTDITEM  \r\n");
                query.append("    , IFNULL(B.SUPPSTDRATI, '')    AS SUPPSTDRATI  \r\n");
                query.append("    , IFNULL(B.CODE_DIVISION, '')  AS CODE_DIVISION  \r\n");
                query.append("  FROM shopmstdome AS A  \r\n");
                query.append("  LEFT JOIN shopdtldome AS B ON A.COMPNO = B.COMPNO AND A.SHOPCD = B.SHOPCD  \r\n");
                query.append("  JOIN shopinfodome AS C ON A.shopcd = C.shopcd  \r\n");
                query.append(" WHERE A.COMPNO = " + compno + "  \r\n");
                query.append("   AND B.DEALTREAD = '\uc0ac\uc6a9\uc911'  \r\n");
                query.append(" ORDER BY A.SHOPCD, B.SHOPSEQ  \r\n");
                YDMAStringUtil.Print(query.toString());
                result = (List)run.query(connection, query.toString(), (ResultSetHandler)handler);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<DomemallDTO> selectDomemallQuickInfo() {
        List<DomemallDTO> result = new ArrayList<DomemallDTO>();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(DomemallDTO.class);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                String compno = YDMASessonUtil.getCompnoInfo().getCompno();
                StringBuilder query = new StringBuilder();
                query.append("SELECT  \r\n");
                query.append("      B.SHOPNM  \r\n");
                query.append("    , IFNULL(A.NICKNM1,'') AS NICKNM1  \r\n");
                query.append("    , A.SHOPCD  \r\n");
                query.append("    , A.SHOPSEQ  \r\n");
                query.append("  FROM shopdtldome AS A  \r\n");
                query.append("  JOIN shopinfodome AS B ON A.SHOPCD = B.SHOPCD  \r\n");
                query.append("  WHERE A.COMPNO = " + compno + "  \r\n");
                YDMAStringUtil.Print(query.toString());
                result = (List)run.query(connection, query.toString(), (ResultSetHandler)handler);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<DomemallDTO> selectTradingDomeMallQuickInfo() {
        List<DomemallDTO> result = new ArrayList<DomemallDTO>();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(DomemallDTO.class);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                String compno = YDMASessonUtil.getCompnoInfo().getCompno();
                StringBuilder query = new StringBuilder();
                query.append("SELECT  \r\n");
                query.append("      IFNULL(A.COMPNO, '') AS COMPNO  \r\n");
                query.append("    , IFNULL(A.SHOPCD,'')  AS SHOPCD  \r\n");
                query.append("    , IFNULL(B.SHOPNM,'')  AS SHOPNM  \r\n");
                query.append("    , IFNULL(B.SHOPURL,'') AS SHOPURL  \r\n");
                query.append("  FROM shopmstdome AS A  \r\n");
                query.append("  JOIN shopinfodome AS B ON A.SHOPCD = B.SHOPCD  \r\n");
                query.append(" WHERE A.COMPNO = ?  \r\n");
                query.append("   AND A.DEALTRADE = '\uac70\ub798\uc911'  \r\n");
                query.append(" ORDER BY A.SHOPCD  \r\n");
                YDMAStringUtil.Print(query.toString());
                Object[] params = new Object[]{Integer.parseInt(compno)};
                result = (List)run.query(connection, query.toString(), (ResultSetHandler)handler, params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<DomemallDTO> selectTradingDomeMallInfo() {
        List<DomemallDTO> result = new ArrayList<DomemallDTO>();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(DomemallDTO.class);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                String compno = YDMASessonUtil.getCompnoInfo().getCompno();
                StringBuilder query = new StringBuilder();
                query.append("SELECT DISTINCT  \r\n");
                query.append("      IFNULL(A.SHOPCD, '')       AS SHOPCD  \r\n");
                query.append("    , IFNULL(B.SHOPNM, '')       AS SHOPNM  \r\n");
                query.append("  FROM shopdtldome AS A  \r\n");
                query.append("  JOIN shopinfodome AS B ON A.SHOPCD = B.SHOPCD  \r\n");
                query.append(" WHERE A.DEALTREAD = '\uc0ac\uc6a9\uc911'  \r\n");
                query.append("   AND A.COMPNO = ?  \r\n");
                YDMAStringUtil.Print(query.toString());
                Object[] params = new Object[]{Integer.parseInt(compno)};
                result = (List)run.query(connection, query.toString(), (ResultSetHandler)handler, params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<DomemallDTO> selectSearchPreferencesDomeMallInfos(int optionIdx, String searchText) {
        List<DomemallDTO> result = new ArrayList<DomemallDTO>();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(DomemallDTO.class);
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                String compno = YDMASessonUtil.getCompnoInfo().getCompno();
                String optionQuery = "";
                optionQuery = optionIdx == 1 ? "AND B.SHOPNM LIKE ?" : "AND A.SHOPCD LIKE ?";
                StringBuilder query = new StringBuilder();
                query.append("SELECT  \r\n");
                query.append("      IFNULL(A.SHOPSEQ, '')       AS SHOPSEQ  \r\n");
                query.append("    , IFNULL(A.SHOPCD, '')        AS SHOPCD  \r\n");
                query.append("    , IFNULL(B.SHOPNM, '')        AS SHOPNM  \r\n");
                query.append("    , IFNULL(A.SHOPPINGID, '')    AS SHOPPINGID  \r\n");
                query.append("    , IFNULL(A.PASSWORD, '')      AS PASSWORD  \r\n");
                query.append("    , IFNULL(A.NICKNM2, '')       AS NICKNM2  \r\n");
                query.append("    , IFNULL(A.NICKNM1, '')       AS NICKNM1  \r\n");
                query.append("    , IFNULL(A.AUTHKEY1, '')      AS AUTHKEY1  \r\n");
                query.append("    , IFNULL(A.AUTHKEY2, '')      AS AUTHKEY2  \r\n");
                query.append("    , IFNULL(A.APIKEY, '')        AS APIKEY  \r\n");
                query.append("    , IFNULL(A.SUPPSTDITEM, '0')  AS SUPPSTDITEM  \r\n");
                query.append("    , IFNULL(A.SUPPSTDRATI, '')   AS SUPPSTDRATI  \r\n");
                query.append("    , IFNULL(A.SHOPCOMPAR, '')    AS SHOPCOMPAR  \r\n");
                query.append("    , IFNULL(A.EDITAUTHKEY1, '')  AS EDITAUTHKEY1  \r\n");
                query.append("    , IFNULL(A.EDITAPIKEY, '')    AS EDITAPIKEY  \r\n");
                query.append("    , IFNULL(A.REGCNT, '')        AS REGCNT  \r\n");
                query.append("    , IFNULL(A.EXCESSYN, '')      AS EXCESSYN  \r\n");
                query.append("    , IFNULL(A.EXCESSCNT, '')     AS EXCESSCNT  \r\n");
                query.append("    , IFNULL(A.SHOPGRP, '')       AS SHOPGRP  \r\n");
                query.append("    , IFNULL(A.DEALTREAD, '')     AS DEALTREAD  \r\n");
                query.append("    , IFNULL(A.CODE_DIVISION, '') AS CODE_DIVISION  \r\n");
                query.append("  FROM shopdtldome AS A  \r\n");
                query.append("  JOIN shopinfodome AS B ON A.SHOPCD = B.SHOPCD  \r\n");
                query.append(" WHERE A.COMPNO = ?  \r\n");
                query.append("   " + optionQuery + "  \r\n");
                YDMAStringUtil.Print(query.toString());
                Object[] params = new Object[]{Integer.parseInt(compno), "%" + searchText + "%"};
                result = (List)run.query(connection, query.toString(), (ResultSetHandler)handler, params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public int updateDomeMallDealtreadYes(String shopCode, String shopSeq, String shoppingID) {
        int result = 0;
        StringBuilder query = new StringBuilder();
        query.append("UPDATE shopdtldome  \r\n");
        query.append("   SET DEALTREAD = '\uc0ac\uc6a9\uc911'  \r\n");
        query.append(" WHERE COMPNO = ?  \r\n");
        query.append("   AND SHOPCD = ?  \r\n");
        query.append("   AND SHOPSEQ = ?  \r\n");
        query.append("   AND SHOPPINGID = ?  \r\n");
        YDMAStringUtil.Print(query.toString());
        String compno = YDMASessonUtil.getCompnoInfo().getCompno();
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                QueryRunner runner = new QueryRunner();
                Object[] params = new Object[]{Integer.parseInt(compno), shopCode, shopSeq, shoppingID};
                result = runner.update(connection, query.toString(), params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public int updateDomeMallDealtreadNo(String shopCode, String shopSeq, String shoppingID) {
        int result = 0;
        StringBuilder query = new StringBuilder();
        query.append("UPDATE shopdtldome  \r\n");
        query.append("   SET DEALTREAD = ''  \r\n");
        query.append(" WHERE COMPNO = ?  \r\n");
        query.append("   AND SHOPCD = ?  \r\n");
        query.append("   AND SHOPSEQ = ?  \r\n");
        query.append("   AND SHOPPINGID = ?  \r\n");
        YDMAStringUtil.Print(query.toString());
        String compno = YDMASessonUtil.getCompnoInfo().getCompno();
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                QueryRunner runner = new QueryRunner();
                Object[] params = new Object[]{Integer.parseInt(compno), shopCode, shopSeq, shoppingID};
                result = runner.update(connection, query.toString(), params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public int deleteDomeMall(String shopCode, int shopSeq, String shoppingID) {
        int result = 0;
        StringBuilder query = new StringBuilder();
        query.append("DELETE FROM shopdtldome  \r\n");
        query.append(" WHERE COMPNO = ?  \r\n");
        query.append("   AND SHOPCD = ?  \r\n");
        query.append("   AND SHOPSEQ = ?  \r\n");
        query.append("   AND SHOPPINGID = ?  \r\n");
        YDMAStringUtil.Print(query.toString());
        String compno = YDMASessonUtil.getCompnoInfo().getCompno();
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                QueryRunner runner = new QueryRunner();
                Object[] params = new Object[]{Integer.parseInt(compno), shopCode, shopSeq, shoppingID};
                result = runner.update(connection, query.toString(), params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public DomemallDTO selectDomeMallMasterInfo(String shopCode) {
        DomemallDTO result = new DomemallDTO();
        QueryRunner run = new QueryRunner();
        BeanHandler handler = new BeanHandler(DomemallDTO.class);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                String compno = YDMASessonUtil.getCompnoInfo().getCompno();
                StringBuilder query = new StringBuilder();
                query.append("SELECT  \r\n");
                query.append("      IFNULL(A.SHOPCD, '')       AS SHOPCD  \r\n");
                query.append("    , IFNULL(B.SHOPNM, '')       AS SHOPNM  \r\n");
                query.append("    , IFNULL(B.CUSTNM, '')       AS CUSTNM  \r\n");
                query.append("    , IFNULL(B.PRODREGIS, '')    AS PRODREGIS  \r\n");
                query.append("    , IFNULL(B.PRODMODIFY, '')   AS PRODMODIFY  \r\n");
                query.append("    , IFNULL(B.PRODSOLDOUT, '')  AS PRODSOLDOUT  \r\n");
                query.append("    , IFNULL(B.STOCKSEND, '')    AS STOCKSEND  \r\n");
                query.append("    , IFNULL(B.ORDERCOLLECT, '') AS ORDERCOLLECT  \r\n");
                query.append("    , IFNULL(B.INVOICSEND, '')   AS INVOICSEND  \r\n");
                query.append("    , IFNULL(B.CLAIMCOLLECT, '') AS CLAIMCOLLECT  \r\n");
                query.append("    , IFNULL(B.QUESTION, '')     AS QUESTION  \r\n");
                query.append("    , IFNULL(B.MARKETCATEG, '')  AS MARKETCATEG  \r\n");
                query.append("    , IFNULL(A.IDNUM, '0')       AS IDNUM  \r\n");
                query.append("    , IFNULL(A.DEALTRADE, '')    AS DEALTRADE  \r\n");
                query.append("  FROM shopmstdome AS A  \r\n");
                query.append("  JOIN shopinfodome AS B ON A.SHOPCD = B.SHOPCD  \r\n");
                query.append(" WHERE A.SHOPCD = ?  \r\n");
                query.append("   AND A.COMPNO = ?  \r\n");
                YDMAStringUtil.Print(query.toString());
                Object[] params = new Object[]{shopCode, Integer.parseInt(compno)};
                result = (DomemallDTO)run.query(connection, query.toString(), (ResultSetHandler)handler, params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public int selectDomeMallDetailQty(String shopCode) {
        QueryRunner runner = new QueryRunner();
        ScalarHandler handler = new ScalarHandler();
        String compno = YDMASessonUtil.getCompnoInfo().getCompno();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                StringBuilder query = new StringBuilder();
                query.append("SELECT IFNULL(MAX(SHOPSEQ), 0)  \r\n");
                query.append("  FROM shopdtldome  \r\n");
                query.append(" WHERE COMPNO = ?  \r\n");
                query.append("   AND SHOPCD = ?  \r\n");
                YDMAStringUtil.Print(query.toString());
                Object[] params = new Object[]{Integer.parseInt(compno), shopCode};
                Long result = (Long)runner.query(connection, query.toString(), (ResultSetHandler)handler, params);
                return result.intValue();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int updateDomeMallMasterTradingInfo(String num, String shopCode) {
        int result = 0;
        StringBuilder query = new StringBuilder();
        query.append("UPDATE shopmstdome  \r\n");
        query.append("   SET IDNUM = ?  \r\n");
        query.append("     , DEALTRADE = '\uac70\ub798\uc911'  \r\n");
        query.append(" WHERE SHOPCD = ?  \r\n");
        query.append("   AND COMPNO = ?  \r\n");
        YDMAStringUtil.Print(query.toString());
        String compno = YDMASessonUtil.getCompnoInfo().getCompno();
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                QueryRunner runner = new QueryRunner();
                Object[] params = new Object[]{num, shopCode, Integer.parseInt(compno)};
                result = runner.update(connection, query.toString(), params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public int mergeMallUsingData(String shopCode, String shopName) {
        int result = 0;
        StringBuilder query = new StringBuilder();
        query.append("INSERT INTO com_code_detail (code_mng, code, name, use_yn)  \r\n");
        query.append("VALUES ('PRODUCT_SHOP', ?, ?, 'N')  \r\n");
        query.append("ON DUPLICATE KEY  \r\n");
        query.append("UPDATE name = ?, use_yn = 'N'  \r\n");
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                QueryRunner runner = new QueryRunner();
                Object[] params = new Object[]{shopCode, shopName, shopName};
                result = runner.update(connection, query.toString(), params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isExistsUserID(String shoppingID, String shopCode) {
        DomemallDTO dto = new DomemallDTO();
        QueryRunner run = new QueryRunner();
        BeanHandler handler = new BeanHandler(DomemallDTO.class);
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                String compno = YDMASessonUtil.getCompnoInfo().getCompno();
                StringBuilder query = new StringBuilder();
                query.append("SELECT IFNULL(SHOPPINGID, '') AS SHOPPINGID  \r\n");
                query.append("  FROM shopdtldome  \r\n");
                query.append(" WHERE SHOPPINGID = ?  \r\n");
                query.append("   AND COMPNO = ?  \r\n");
                query.append("   AND SHOPCD = ?  \r\n");
                YDMAStringUtil.Print(query.toString());
                Object[] params = new Object[]{shoppingID, shopCode, Integer.parseInt(compno)};
                dto = (DomemallDTO)run.query(connection, query.toString(), (ResultSetHandler)handler, params);
                if (dto == null) return false;
                if (!dto.getSHOPPINGID().equals("")) return true;
                return false;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isExistsUserID(String shoppingID, String shopCode, int shopSeq) {
        DomemallDTO dto = new DomemallDTO();
        QueryRunner run = new QueryRunner();
        BeanHandler handler = new BeanHandler(DomemallDTO.class);
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                String compno = YDMASessonUtil.getCompnoInfo().getCompno();
                StringBuilder query = new StringBuilder();
                query.append("SELECT IFNULL(SHOPPINGID, '') AS SHOPPINGID  \r\n");
                query.append("  FROM shopdtldome  \r\n");
                query.append(" WHERE SHOPPINGID = ?  \r\n");
                query.append("   AND COMPNO = ?  \r\n");
                query.append("   AND SHOPCD = ?  \r\n");
                query.append("   AND SHOPSEQ <> ?  \r\n");
                YDMAStringUtil.Print(query.toString());
                Object[] params = new Object[]{shoppingID, Integer.parseInt(compno), shopCode, shopSeq};
                dto = (DomemallDTO)run.query(connection, query.toString(), (ResultSetHandler)handler, params);
                if (dto == null) return false;
                if (!dto.getSHOPPINGID().equals("")) return true;
                return false;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public int insertDomeMallDetailInfo(DomemallDTO dto) {
        int result = 0;
        StringBuilder query = new StringBuilder();
        query.append("INSERT INTO shopdtldome (  \r\n");
        query.append("      COMPNO  \r\n");
        query.append("    , SHOPCD  \r\n");
        query.append("    , SHOPSEQ  \r\n");
        query.append("    , SHOPPINGID  \r\n");
        query.append("    , PASSWORD  \r\n");
        query.append("    , NICKNM2  \r\n");
        query.append("    , NICKNM1  \r\n");
        query.append("    , AUTHKEY1  \r\n");
        query.append("    , AUTHKEY2  \r\n");
        query.append("    , APIKEY  \r\n");
        query.append("    , SUPPSTDITEM  \r\n");
        query.append("    , SUPPSTDRATI  \r\n");
        query.append("    , DEALTREAD  \r\n");
        query.append("    , SHOPCOMPAR  \r\n");
        query.append("    , EDITAUTHKEY1  \r\n");
        query.append("    , EDITAPIKEY  \r\n");
        query.append("    , REGCNT  \r\n");
        query.append("    , EXCESSYN  \r\n");
        query.append("    , EXCESSCNT  \r\n");
        query.append("    , SHOPGRP  \r\n");
        query.append("    , CODE_DIVISION  \r\n");
        query.append(")  \r\n");
        query.append("VALUES (  \r\n");
        query.append("      ?  \r\n");
        query.append("    , ?  \r\n");
        query.append("    , ?  \r\n");
        query.append("    , ?  \r\n");
        query.append("    , ?  \r\n");
        query.append("    , ?  \r\n");
        query.append("    , ?  \r\n");
        query.append("    , ?  \r\n");
        query.append("    , ?  \r\n");
        query.append("    , ?  \r\n");
        query.append("    , ?  \r\n");
        query.append("    , 0  \r\n");
        query.append("    , ?  \r\n");
        query.append("    , '0'  \r\n");
        query.append("    , ?  \r\n");
        query.append("    , ?  \r\n");
        query.append("    , 0  \r\n");
        query.append("    , 'N'  \r\n");
        query.append("    , 0  \r\n");
        query.append("    , ?  \r\n");
        query.append("    , ?  \r\n");
        query.append(")  \r\n");
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                QueryRunner runner = new QueryRunner();
                Object[] params = new Object[]{Integer.parseInt(YDMASessonUtil.getCompnoInfo().getCompno()), dto.getSHOPCD(), dto.getSHOPSEQ(), dto.getSHOPPINGID(), dto.getPASSWORD(), dto.getNICKNM2(), dto.getNICKNM1(), dto.getAUTHKEY1(), dto.getAUTHKEY2(), dto.getAPIKEY(), dto.getSUPPSTDITEM(), dto.getDEALTREAD(), dto.getEDITAUTHKEY1(), dto.getEDITAPIKEY(), dto.getSHOPGRP(), dto.getCODE_DIVISION()};
                result = runner.update(connection, query.toString(), params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public int updateDomeMallDetailInfo(DomemallDTO dto) {
        int result = 0;
        StringBuilder query = new StringBuilder();
        query.append("UPDATE shopdtldome  \r\n");
        query.append("   SET SHOPPINGID = ?  \r\n");
        query.append("     , PASSWORD = ?  \r\n");
        query.append("     , NICKNM2 = ?  \r\n");
        query.append("     , NICKNM1 = ?  \r\n");
        query.append("     , AUTHKEY1 = ?  \r\n");
        query.append("     , AUTHKEY2 = ?  \r\n");
        query.append("     , APIKEY = ?  \r\n");
        query.append("     , SUPPSTDITEM = ?  \r\n");
        query.append("     , SUPPSTDRATI = 0  \r\n");
        query.append("     , DEALTREAD = ?  \r\n");
        query.append("     , SHOPCOMPAR = '0'  \r\n");
        query.append("     , EDITAUTHKEY1 = ?  \r\n");
        query.append("     , EDITAPIKEY = ?  \r\n");
        query.append("     , REGCNT = 0  \r\n");
        query.append("     , EXCESSYN = 'N'  \r\n");
        query.append("     , EXCESSCNT = 0  \r\n");
        query.append("     , SHOPGRP = ?  \r\n");
        query.append("     , CODE_DIVISION = ?  \r\n");
        query.append(" WHERE COMPNO = ?  \r\n");
        query.append("   AND SHOPCD = ?  \r\n");
        query.append("   AND SHOPSEQ = ?  \r\n");
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                QueryRunner runner = new QueryRunner();
                Object[] params = new Object[]{dto.getSHOPPINGID(), dto.getPASSWORD(), dto.getNICKNM2(), dto.getNICKNM1(), dto.getAUTHKEY1(), dto.getAUTHKEY2(), dto.getAPIKEY(), dto.getSUPPSTDITEM(), dto.getDEALTREAD(), dto.getEDITAUTHKEY1(), dto.getEDITAPIKEY(), dto.getSHOPGRP(), dto.getCODE_DIVISION(), Integer.parseInt(YDMASessonUtil.getCompnoInfo().getCompno()), dto.getSHOPCD(), dto.getSHOPSEQ()};
                result = runner.update(connection, query.toString(), params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

