/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.service;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import com.kdjsystem.mlink.yellim.code.MallCode;
import com.kdjsystem.mlink.yellim.common.YDMASessonUtil;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.dao.CategoryDAO;
import com.kdjsystem.mlink.yellim.dao.DomemallDAO;
import com.kdjsystem.mlink.yellim.dao.ProductDAO;
import com.kdjsystem.mlink.yellim.dto.CategoryDTO;
import com.kdjsystem.mlink.yellim.dto.DomemallDTO;
import com.kdjsystem.mlink.yellim.dto.ProductAddProcessDTO;
import com.kdjsystem.mlink.yellim.dto.ProductDTO;
import com.kdjsystem.mlink.yellim.dto.ProductOptionDTO;
import com.kdjsystem.mlink.yellim.dto.ResultProcessDTO;
import com.kdjsystem.mlink.yellim.dto.ShoppingmallDTO;
import com.kdjsystem.mlink.yellim.factory.IProductAddProcess;
import com.kdjsystem.mlink.yellim.helper.DateHelper;
import com.kdjsystem.mlink.yellim.ui.CommonProgressDialog;
import com.kdjsystem.mlink.yellim.ui.ProductAddDialog;
import java.io.Reader;
import java.io.StringReader;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.eclipse.core.runtime.IProgressMonitor;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class AlwayzProductAddService
implements IProductAddProcess {
    @Override
    public ResultProcessDTO addProcess(ProductAddProcessDTO dto) throws Exception {
        boolean flag = true;
        int page = 0;
        int infoRet = 0;
        int inRet = 0;
        ShoppingmallDTO shopInfo = dto.getSHOPINFO();
        List<DomemallDTO> domemallInfos = DomemallDAO.get().selectDomemallInfos();
        String shopInfoLog = String.format("[%s - %s(%s)]", shopInfo.getSHOPNM(), shopInfo.getSHOPPINGID(), shopInfo.getNICKNM1());
        String date = DateHelper.getCurrentTimeString();
        this.setValue(String.format("%s %s \uc1fc\ud551\ubab0 \uc0c1\ud488 \ub370\uc774\ud130 \ucd94\uac00\ub97c \uc9c4\ud589\ud569\ub2c8\ub2e4.", date, shopInfoLog), 0);
        OkHttpClient client = new OkHttpClient();
        JsonParser jsonParser = new JsonParser();
        JsonObject jsonObject = new JsonObject();
        try {
            AddInfo info2 = new AddInfo();
            info2.condition.type = "item";
            info2.condition.itemCondition.createdAt.greaterThan = this.dateFormat1(dto.getSTART_DATE());
            info2.condition.itemSortCondition.createdAt = -1;
            ObjectMapper mapper = new ObjectMapper();
            String json = mapper.writeValueAsString((Object)info2);
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.get((String)"application/json; charset=utf-8"), (String)json);
            Request request2 = new Request.Builder().url("https://alwayz-seller-back.ilevit.com/sellers/items/v2/count-request").header("Connection", "keep-alive").header("x-access-token", shopInfo.getAPIKEY()).header("Content-Type", "application/json").header("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36").post(requestBody).build();
            Response response = client.newCall(request2).execute();
            String responseBody = "";
            if (!response.isSuccessful()) {
                this.setValue("\uc120\ud0dd \ud55c \ub0a0\uc9dc\uc5d0 \ub370\uc774\ud130 \uac1c\uc218\ub97c \ucc3e\ub294 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd ERROR CODE : [" + response.code() + "] \uc7a0\uc2dc \ud6c4\uc5d0 \uc2dc\ub3c4\ud558\uc138\uc694. ", 0);
                return new ResultProcessDTO(0, "", infoRet, inRet);
            }
            responseBody = response.body().string();
            jsonObject = (JsonObject)jsonParser.parse(responseBody);
            int dataCount = jsonObject.get("data").getAsInt();
            if (dataCount == 0) {
                this.setValue("\uc120\ud0dd \ud55c \ub0a0\uc9dc\uc5d0 \ud574\ub2f9\ub418\ub294 \ub370\uc774\ud130\uac00 \uc5c6\uc2b5\ub2c8\ub2e4. \uc0c1\ud488 \ucd94\uac00\ub97c \uc885\ub8cc\ud569\ub2c8\ub2e4.", 100);
                return new ResultProcessDTO(0, "", infoRet, inRet);
            }
            this.setValue("\uc120\ud0dd \ud55c \ub0a0\uc9dc\uc5d0 \ub370\uc774\ud130\uac00 " + dataCount + "\uac74 \uc774\uba70, \uc218\uc9d1\uc744 \uc2dc\uc791\ud569\ub2c8\ub2e4.", 0);
            while (flag) {
                AddInfo info = new AddInfo();
                info.condition.type = "item";
                info.condition.itemCondition.createdAt.greaterThan = this.dateFormat1(dto.getSTART_DATE());
                info.condition.itemSortCondition.createdAt = -1;
                info.page = ++page;
                info.pageLimit = 20;
                json = mapper.writeValueAsString((Object)info);
                requestBody = RequestBody.create((MediaType)MediaType.get((String)"application/json; charset=utf-8"), (String)json);
                request2 = new Request.Builder().url("https://alwayz-seller-back.ilevit.com/sellers/items/v2/list-request").header("Connection", "keep-alive").header("x-access-token", shopInfo.getAPIKEY()).header("Content-Type", "application/json").header("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36").post(requestBody).build();
                response = client.newCall(request2).execute();
                if (response.isSuccessful()) {
                    responseBody = response.body().string();
                }
                try {
                    jsonObject = (JsonObject)jsonParser.parse(responseBody);
                }
                catch (JsonSyntaxException jsonSyntaxException) {
                    YDMAStringUtil.Print("Malformed JSON \uc751\ub2f5 : " + responseBody);
                    continue;
                }
                int status2 = jsonObject.get("status").getAsInt();
                if (status2 == 2000) {
                    JsonObject data2 = (JsonObject)jsonObject.get("data");
                    JsonArray itemsInfo = (JsonArray)data2.get("itemsInfo");
                    if (itemsInfo.size() <= 0) continue;
                    ArrayList<ProductDTO> responseProducts = new ArrayList<ProductDTO>();
                    int i = 0;
                    while (i < itemsInfo.size()) {
                        if (ProductAddDialog.getIsCanceled()) {
                            return new ResultProcessDTO(0, "", infoRet, inRet);
                        }
                        JsonObject product2 = (JsonObject)itemsInfo.get(i);
                        String recommendItemCode = product2.has("recommendItemCode") && !product2.get("recommendItemCode").isJsonNull() ? product2.get("recommendItemCode").getAsString() : "";
                        String str = recommendItemCode.equals("") ? product2.get("itemTitle").getAsString() : recommendItemCode;
                        this.setValue(String.format(" %s [%s] \ubd88\ub7ec\uc624\ub294 \uc911..", shopInfoLog, str), 0);
                        ProductDTO responseProduct = new ProductDTO();
                        responseProduct.setShopprodno(product2.get("_id").getAsString());
                        responseProduct.setGoods_nm(product2.get("itemTitle").getAsString());
                        responseProduct.setCompayny_goods_cd(recommendItemCode);
                        responseProduct.setStatus(!product2.get("soldOut").getAsBoolean() ? "0" : "1");
                        responseProduct.setSendstats(product2.get("soldOut").getAsBoolean() ? String.valueOf(4000) : String.valueOf(8000));
                        if (!recommendItemCode.equals("")) {
                            String codeDivision = domemallInfos.stream().filter(p -> p.getCODE_DIVISION().equals(MallCode.getDomeMallProductCodeDivision(responseProduct.getCompayny_goods_cd()))).map(p -> p.getSHOPCD()).findFirst().orElse("");
                            responseProduct.setGoods_keyword(codeDivision);
                        }
                        CategoryDTO category = this.getCategory(product2, shopInfo.getAPIKEY());
                        responseProduct.setClass_cd3(category.getCODE());
                        responseProduct.setShop_cid_info(category.getSHOPCATE_JSON());
                        responseProduct.setGmcategnm(category.getFULL_NAME());
                        responseProduct.setInsertdt(this.dateFormat2(product2.get("createdAt").getAsString()));
                        responseProduct.setModifyid(responseProduct.getInsertdt());
                        responseProduct.setMarket_price(product2.get("individualPurchasePrice").getAsString());
                        responseProduct.setGoods_price(product2.get("individualPurchasePrice").getAsString());
                        responseProduct.setGoods_consumer_price(product2.get("individualPurchasePrice").getAsString());
                        responseProduct.setShopcd(shopInfo.getSHOPCD());
                        responseProduct.setShopseq(String.valueOf(shopInfo.getSHOPSEQ()));
                        responseProduct.setSHOP_USERID(shopInfo.getSHOPPINGID());
                        String[] code = new String[]{"W", "F", "TS", "OH", "DS", "DMM", "HS", "3MRO", "ZEN", "CH"};
                        List<String> codeCheck = Arrays.asList(code);
                        String companyGoodsCd = responseProduct.getCompayny_goods_cd();
                        if (companyGoodsCd.equals("")) {
                            responseProduct.setCompayny_goods_cd(responseProduct.getShopprodno());
                        } else {
                            boolean isValidCode = false;
                            int j = 1;
                            while (j <= 4 && j <= companyGoodsCd.length()) {
                                if (codeCheck.contains(companyGoodsCd.substring(0, j))) {
                                    isValidCode = true;
                                    break;
                                }
                                ++j;
                            }
                            if (!isValidCode) {
                                responseProduct.setCompayny_goods_cd(responseProduct.getShopprodno());
                            }
                        }
                        JsonObject optionsInfo = (JsonObject)product2.get("optionsInfo");
                        List<ProductOptionDTO> options = this.getOption(responseProduct, optionsInfo);
                        responseProduct.setOPTIONS(options);
                        String[] optionNames = options.stream().map(p -> p.getOPTPRODNM()).findFirst().orElse("").split(":");
                        if (optionNames.length == 1) {
                            responseProduct.setChar_1_nm(optionNames[0]);
                        } else if (optionNames.length == 2) {
                            responseProduct.setChar_1_nm(optionNames[0]);
                            responseProduct.setChar_2_nm(optionNames[1]);
                        }
                        responseProducts.add(responseProduct);
                        ++i;
                    }
                    if (responseProducts.size() > 0) {
                        this.setValue(String.format(" %s \ud398\uc774\uc9c0 %s\uac74\uc744 DB\uc5d0 \uc800\uc7a5\ud569\ub2c8\ub2e4.", page, responseProducts.size()), 0);
                    }
                    for (ProductDTO product3 : responseProducts) {
                        if (ProductAddDialog.getIsCanceled()) {
                            return new ResultProcessDTO(0, "", infoRet, inRet);
                        }
                        ProductDTO copyProduct = ProductDAO.get().selectProductInfo(product3.getCompayny_goods_cd());
                        if (copyProduct == null) {
                            ret = ProductDAO.get().insertProductInfo(product3);
                            if (ret == 1) {
                                infoRet += ret;
                                comment = String.format(" [%s] \ub9c8\uc2a4\ud130 \uc0c1\ud488 \uc800\uc7a5 \uc644\ub8cc", product3.getCompayny_goods_cd());
                                this.setValueProd(comment, 50, product3, null, "YEL_ADD", "\uc131\uacf5", "[\uc6b4\uc601\uc0c1\ud488\uad00\ub9ac - \uc0c1\ud488\ucd94\uac00] \ub9c8\uc2a4\ud130 \uc0c1\ud488\uc774 \ucd94\uac00\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", false);
                            }
                        } else {
                            copyProduct.setClass_cd3(product3.getClass_cd3());
                            copyProduct.setShop_cid_info(product3.getShop_cid_info());
                            ret = ProductDAO.get().updateProductInfo(copyProduct);
                            if (ret == 1) {
                                infoRet += ret;
                                comment = String.format(" [%s] \ub9c8\uc2a4\ud130 \uc0c1\ud488 \uc218\uc815 \uc644\ub8cc", product3.getCompayny_goods_cd());
                                this.setValueProd(comment, 50, product3, null, "YEL_ADD", "\uc131\uacf5", "[\uc6b4\uc601\uc0c1\ud488\uad00\ub9ac - \uc0c1\ud488\ucd94\uac00] \ub9c8\uc2a4\ud130 \uc0c1\ud488\uc774 \uc774\ubbf8 \uc874\uc7ac\ud558\uc5ec \uc0c1\ud0dc\uac00 \uc218\uc815\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", false);
                            }
                        }
                        copyProduct = ProductDAO.get().selectProductInfo(product3.getCompayny_goods_cd());
                        ProductDTO copyProductIn = ProductDAO.get().selectProductIn(shopInfo, copyProduct.getPRODSEQ());
                        if (copyProductIn == null) {
                            product3.setPRODSEQ(copyProduct.getPRODSEQ());
                            int ret = ProductDAO.get().insertProductIn(product3);
                            if (ret == 1) {
                                inRet += ret;
                                String comment = String.format(" %s [%s] \uc1fc\ud551\ubab0 \uc0c1\ud488 \uc800\uc7a5 \uc644\ub8cc", shopInfoLog, product3.getCompayny_goods_cd());
                                this.setValueProd(comment, 50, product3, shopInfo, "YEL_ADD", "\uc131\uacf5", "[\uc6b4\uc601\uc0c1\ud488\uad00\ub9ac - \uc0c1\ud488\ucd94\uac00] \uc0c1\ud488\uc774 \uc5e0\ub9c1\ud06c\uc5d0 \ucd94\uac00\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", true);
                            }
                        } else {
                            copyProductIn.setClass_cd3(product3.getClass_cd3());
                            copyProductIn.setShop_cid_info(product3.getShop_cid_info());
                            copyProductIn.setGoods_nm(product3.getGoods_nm());
                            copyProductIn.setShopprodno(product3.getShopprodno());
                            copyProductIn.setDelv_r_cost(product3.getDelv_r_cost());
                            copyProductIn.setSaleenddt(product3.getSaleenddt());
                            copyProductIn.setMarket_price(product3.getMarket_price());
                            copyProductIn.setGoods_price(product3.getGoods_price());
                            copyProductIn.setGoods_consumer_price(product3.getGoods_consumer_price());
                            copyProductIn.setCompayny_goods_cd(product3.getCompayny_goods_cd());
                            copyProductIn.setSaleStatusCd(product3.getSaleStatusCd());
                            copyProductIn.setStdPrdYn(product3.getStdPrdYn());
                            copyProductIn.setStatus(product3.getStatus());
                            copyProductIn.setSendstats(product3.getSendstats());
                            String codeDivision = domemallInfos.stream().filter(p -> p.getCODE_DIVISION().equals(MallCode.getDomeMallProductCodeDivision(product3.getCompayny_goods_cd()))).map(p -> p.getSHOPCD()).findFirst().orElse("");
                            copyProductIn.setGoods_keyword(codeDivision);
                            int ret = ProductDAO.get().updateProductIn(copyProductIn);
                            if (ret == 1) {
                                inRet += ret;
                                String comment = String.format(" %s [%s] \uc1fc\ud551\ubab0 \uc0c1\ud488 \uc218\uc815 \uc644\ub8cc", shopInfoLog, product3.getCompayny_goods_cd());
                                this.setValueProd(comment, 50, product3, shopInfo, "YEL_ADD", "\uc131\uacf5", "[\uc6b4\uc601\uc0c1\ud488\uad00\ub9ac - \uc0c1\ud488\ucd94\uac00] \uc0c1\ud488\uc774 \uc774\ubbf8 \uc874\uc7ac\ud558\uc5ec \uc0c1\ud0dc\uac00 \uc5e0\ub9c1\ud06c\uc5d0\uc11c \uc218\uc815\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", true);
                            }
                        }
                        copyProductIn = ProductDAO.get().selectProductIn(shopInfo, copyProduct.getPRODSEQ());
                        if (product3.getOPTIONS() == null) continue;
                        for (ProductOptionDTO option2 : product3.getOPTIONS()) {
                            ProductOptionDTO copyOption = ProductDAO.get().selectOptProductInfo(copyProduct.getPRODSEQ(), option2.getSKUSEQ());
                            if (copyOption == null) {
                                option2.setPRODSEQ(Integer.parseInt(copyProduct.getPRODSEQ()));
                                option2.setCOMPAYNY_GOODS_CD(product3.getCompayny_goods_cd());
                                ProductDAO.get().insertOptProductInfo(option2);
                            } else {
                                copyOption.setCOMPAYNY_GOODS_CD(product3.getCompayny_goods_cd());
                                copyOption.setOPTPRODCD(option2.getOPTPRODCD());
                                copyOption.setOPTPRODNM(option2.getOPTPRODNM());
                                copyOption.setOPTSPECDES(option2.getOPTSPECDES());
                                copyOption.setOPTEA(option2.getOPTEA());
                                copyOption.setOPTSAFESTOCK(option2.getOPTSAFESTOCK());
                                copyOption.setOPTVERTSTOCK(option2.getOPTVERTSTOCK());
                                copyOption.setOPTADDAMT(option2.getOPTADDAMT());
                                copyOption.setINSERTDT(option2.getINSERTDT());
                                copyOption.setINSERTID(option2.getINSERTID());
                                copyOption.setMODIFYDT(option2.getMODIFYDT());
                                copyOption.setSTATUS(option2.getSTATUS());
                            }
                            ProductOptionDTO copyOptionIn = ProductDAO.get().selectOptProductIn(copyProductIn.getSENDSEQ(), option2.getSKUSEQ());
                            if (copyOptionIn == null) {
                                option2.setSENDSEQ(Integer.parseInt(copyProductIn.getSENDSEQ()));
                                option2.setPRODSEQ(Integer.parseInt(copyProduct.getPRODSEQ()));
                                ProductDAO.get().insertOptProductIn(option2);
                                continue;
                            }
                            copyOptionIn.setSHOPPRODNO(option2.getSHOPPRODNO());
                            copyOptionIn.setSHOPPRODSKU(option2.getSHOPPRODSKU());
                            copyOptionIn.setSHOPPRODSKU_NM(option2.getSHOPPRODSKU_NM());
                            copyOptionIn.setOPTPRODCD(option2.getOPTPRODCD());
                            copyOptionIn.setOPTPRODNM(option2.getOPTPRODNM());
                            copyOptionIn.setOPTSPECDES(option2.getOPTSPECDES());
                            copyOptionIn.setOPTEA(option2.getOPTEA());
                            copyOptionIn.setOPTSAFESTOCK(option2.getOPTSAFESTOCK());
                            copyOptionIn.setOPTVERTSTOCK(option2.getOPTVERTSTOCK());
                            copyOptionIn.setOPTADDAMT(option2.getOPTADDAMT());
                            copyOptionIn.setINSERTDT(option2.getINSERTDT());
                            copyOptionIn.setINSERTID(option2.getINSERTID());
                            copyOptionIn.setMODIFYDT(option2.getMODIFYDT());
                            copyOptionIn.setSTATUS(option2.getSTATUS());
                        }
                    }
                    continue;
                }
                flag = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String errorMessage = e.getMessage() != null ? e.getMessage() : "\uc54c \uc218 \uc5c6\ub294 \uc624\ub958 \ubc1c\uc0dd";
            this.setValue(String.format("%s %s %s", date, shopInfoLog, errorMessage), 100);
            this.setValue("--------------------------------------------------------------------------------------", 100);
            return new ResultProcessDTO(-1, "", 0, 0);
        }
        this.setValue(String.format("%s %s \ucd1d %s\uac74\uc758 \uc0c1\ud488 \ub370\uc774\ud130 \ucd94\uac00\ub97c \uc644\ub8cc\ud588\uc2b5\ub2c8\ub2e4.", date, shopInfoLog, inRet), 100);
        this.setValue("--------------------------------------------------------------------------------------", 100);
        return new ResultProcessDTO(0, "", infoRet, inRet);
    }

    @Override
    public ResultProcessDTO addProcess(ProductAddProcessDTO dto, List<String> specificCodes) throws Exception {
        int infoRet = 0;
        int inRet = 0;
        int page = 0;
        ShoppingmallDTO shopInfo = dto.getSHOPINFO();
        List<DomemallDTO> domemallInfos = DomemallDAO.get().selectDomemallInfos();
        String shopInfoLog = String.format("[%s - %s(%s)]", shopInfo.getSHOPNM(), shopInfo.getSHOPPINGID(), shopInfo.getNICKNM1());
        String date = DateHelper.getCurrentTimeString();
        this.setValue(String.format("%s %s \uc1fc\ud551\ubab0 \uc0c1\ud488 \ub370\uc774\ud130 \ucd94\uac00\ub97c \uc9c4\ud589\ud569\ub2c8\ub2e4.", date, shopInfoLog), 0);
        OkHttpClient client = new OkHttpClient();
        JsonParser jsonParser = new JsonParser();
        JsonObject jsonObject = new JsonObject();
        ObjectMapper mapper = new ObjectMapper();
        try {
            ArrayList<ProductDTO> responseProducts = new ArrayList<ProductDTO>();
            for (String optionCode : specificCodes) {
                JsonObject data2;
                JsonArray itemsInfo;
                int status2;
                AddInfoByWord info = new AddInfoByWord();
                info.condition.type = "item";
                info.condition.itemCondition.createdAt.greaterThan = this.dateFormat1(dto.getSTART_DATE());
                info.condition.itemCondition.optionsInfo.optionPrices.optionCode = optionCode;
                info.condition.itemSortCondition.createdAt = -1;
                info.page = 1;
                info.pageLimit = 20;
                String json = mapper.writeValueAsString((Object)info);
                RequestBody requestBody = RequestBody.create((MediaType)MediaType.get((String)"application/json; charset=utf-8"), (String)json);
                Request request2 = new Request.Builder().url("https://alwayz-seller-back.ilevit.com/sellers/items/v2/list-request").header("Connection", "keep-alive").header("x-access-token", shopInfo.getAPIKEY()).header("Content-Type", "application/json").header("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36").post(requestBody).build();
                Response response = client.newCall(request2).execute();
                String responseBody = "";
                if (response.isSuccessful()) {
                    responseBody = response.body().string();
                }
                if ((status2 = (jsonObject = (JsonObject)jsonParser.parse(responseBody)).get("status").getAsInt()) != 2000 || (itemsInfo = (JsonArray)(data2 = (JsonObject)jsonObject.get("data")).get("itemsInfo")).size() <= 0) continue;
                int i = 0;
                while (i < itemsInfo.size()) {
                    if (ProductAddDialog.getIsCanceled()) {
                        return new ResultProcessDTO(0, "", infoRet, inRet);
                    }
                    JsonObject product2 = (JsonObject)itemsInfo.get(i);
                    String recommendItemCode = product2.has("recommendItemCode") && !product2.get("recommendItemCode").isJsonNull() ? product2.get("recommendItemCode").getAsString() : "";
                    String str = recommendItemCode.equals("") ? product2.get("itemTitle").getAsString() : recommendItemCode;
                    this.setValue(String.format(" %s [%s] \ubd88\ub7ec\uc624\ub294 \uc911..", shopInfoLog, str), 0);
                    ProductDTO responseProduct = new ProductDTO();
                    responseProduct.setShopprodno(product2.get("_id").getAsString());
                    responseProduct.setGoods_nm(product2.get("itemTitle").getAsString());
                    responseProduct.setCompayny_goods_cd(recommendItemCode);
                    responseProduct.setStatus(!product2.get("soldOut").getAsBoolean() ? "0" : "1");
                    responseProduct.setSendstats(product2.get("soldOut").getAsBoolean() ? String.valueOf(4000) : String.valueOf(8000));
                    if (!recommendItemCode.equals("")) {
                        String codeDivision = domemallInfos.stream().filter(p -> p.getCODE_DIVISION().equals(MallCode.getDomeMallProductCodeDivision(responseProduct.getCompayny_goods_cd()))).map(p -> p.getSHOPCD()).findFirst().orElse("");
                        responseProduct.setGoods_keyword(codeDivision);
                    }
                    CategoryDTO category = this.getCategory(product2, shopInfo.getAPIKEY());
                    responseProduct.setClass_cd3(category.getCODE());
                    responseProduct.setShop_cid_info(category.getSHOPCATE_JSON());
                    responseProduct.setGmcategnm(category.getFULL_NAME());
                    responseProduct.setInsertdt(this.dateFormat2(product2.get("createdAt").getAsString()));
                    responseProduct.setModifyid(responseProduct.getInsertdt());
                    responseProduct.setMarket_price(product2.get("individualPurchasePrice").getAsString());
                    responseProduct.setGoods_price(product2.get("individualPurchasePrice").getAsString());
                    responseProduct.setGoods_consumer_price(product2.get("individualPurchasePrice").getAsString());
                    responseProduct.setShopcd(shopInfo.getSHOPCD());
                    responseProduct.setShopseq(String.valueOf(shopInfo.getSHOPSEQ()));
                    responseProduct.setSHOP_USERID(shopInfo.getSHOPPINGID());
                    String[] code = new String[]{"W", "F", "TS", "OH", "DS", "DMM", "HS", "3MRO", "ZEN", "CH"};
                    List<String> codeCheck = Arrays.asList(code);
                    String companyGoodsCd = responseProduct.getCompayny_goods_cd();
                    if (companyGoodsCd.equals("")) {
                        responseProduct.setCompayny_goods_cd(responseProduct.getShopprodno());
                    } else {
                        boolean isValidCode = false;
                        int j = 1;
                        while (j <= 4 && j <= companyGoodsCd.length()) {
                            if (codeCheck.contains(companyGoodsCd.substring(0, j))) {
                                isValidCode = true;
                                break;
                            }
                            ++j;
                        }
                        if (!isValidCode) {
                            responseProduct.setCompayny_goods_cd(responseProduct.getShopprodno());
                        }
                    }
                    JsonObject optionsInfo = (JsonObject)product2.get("optionsInfo");
                    List<ProductOptionDTO> options = this.getOption(responseProduct, optionsInfo);
                    responseProduct.setOPTIONS(options);
                    String[] optionNames = options.stream().map(p -> p.getOPTPRODNM()).findFirst().orElse("").split(":");
                    if (optionNames.length == 1) {
                        responseProduct.setChar_1_nm(optionNames[0]);
                    } else if (optionNames.length == 2) {
                        responseProduct.setChar_1_nm(optionNames[0]);
                        responseProduct.setChar_2_nm(optionNames[1]);
                    }
                    responseProducts.add(responseProduct);
                    ++i;
                }
            }
            if (responseProducts.size() > 0) {
                this.setValue(String.format(" %s \ud398\uc774\uc9c0 %s\uac74\uc744 DB\uc5d0 \uc800\uc7a5\ud569\ub2c8\ub2e4.", page, responseProducts.size()), 0);
            }
            for (ProductDTO product3 : responseProducts) {
                if (ProductAddDialog.getIsCanceled()) {
                    return new ResultProcessDTO(0, "", infoRet, inRet);
                }
                ProductDTO copyProduct = ProductDAO.get().selectProductInfo(product3.getCompayny_goods_cd());
                if (copyProduct == null) {
                    ret = ProductDAO.get().insertProductInfo(product3);
                    if (ret == 1) {
                        infoRet += ret;
                        comment = String.format(" [%s] \ub9c8\uc2a4\ud130 \uc0c1\ud488 \uc800\uc7a5 \uc644\ub8cc", product3.getCompayny_goods_cd());
                        this.setValueProd(comment, 50, product3, null, "YEL_ADD", "\uc131\uacf5", "[\uc6b4\uc601\uc0c1\ud488\uad00\ub9ac - \uc0c1\ud488\ucd94\uac00] \ub9c8\uc2a4\ud130 \uc0c1\ud488\uc774 \ucd94\uac00\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", false);
                    }
                } else {
                    copyProduct.setClass_cd3(product3.getClass_cd3());
                    copyProduct.setShop_cid_info(product3.getShop_cid_info());
                    ret = ProductDAO.get().updateProductInfo(copyProduct);
                    if (ret == 1) {
                        infoRet += ret;
                        comment = String.format(" [%s] \ub9c8\uc2a4\ud130 \uc0c1\ud488 \uc218\uc815 \uc644\ub8cc", product3.getCompayny_goods_cd());
                        this.setValueProd(comment, 50, product3, null, "YEL_ADD", "\uc131\uacf5", "[\uc6b4\uc601\uc0c1\ud488\uad00\ub9ac - \uc0c1\ud488\ucd94\uac00] \ub9c8\uc2a4\ud130 \uc0c1\ud488\uc774 \uc774\ubbf8 \uc874\uc7ac\ud558\uc5ec \uc0c1\ud0dc\uac00 \uc218\uc815\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", false);
                    }
                }
                copyProduct = ProductDAO.get().selectProductInfo(product3.getCompayny_goods_cd());
                ProductDTO copyProductIn = ProductDAO.get().selectProductIn(shopInfo, copyProduct.getPRODSEQ());
                if (copyProductIn == null) {
                    product3.setPRODSEQ(copyProduct.getPRODSEQ());
                    int ret = ProductDAO.get().insertProductIn(product3);
                    if (ret == 1) {
                        inRet += ret;
                        String comment = String.format(" %s [%s] \uc1fc\ud551\ubab0 \uc0c1\ud488 \uc800\uc7a5 \uc644\ub8cc", shopInfoLog, product3.getCompayny_goods_cd());
                        this.setValueProd(comment, 50, product3, shopInfo, "YEL_ADD", "\uc131\uacf5", "[\uc6b4\uc601\uc0c1\ud488\uad00\ub9ac - \uc0c1\ud488\ucd94\uac00] \uc0c1\ud488\uc774 \uc5e0\ub9c1\ud06c\uc5d0 \ucd94\uac00\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", true);
                    }
                } else {
                    copyProductIn.setClass_cd3(product3.getClass_cd3());
                    copyProductIn.setShop_cid_info(product3.getShop_cid_info());
                    copyProductIn.setGoods_nm(product3.getGoods_nm());
                    copyProductIn.setShopprodno(product3.getShopprodno());
                    copyProductIn.setDelv_r_cost(product3.getDelv_r_cost());
                    copyProductIn.setSaleenddt(product3.getSaleenddt());
                    copyProductIn.setMarket_price(product3.getMarket_price());
                    copyProductIn.setGoods_price(product3.getGoods_price());
                    copyProductIn.setGoods_consumer_price(product3.getGoods_consumer_price());
                    copyProductIn.setCompayny_goods_cd(product3.getCompayny_goods_cd());
                    copyProductIn.setSaleStatusCd(product3.getSaleStatusCd());
                    copyProductIn.setStdPrdYn(product3.getStdPrdYn());
                    copyProductIn.setStatus(product3.getStatus());
                    copyProductIn.setSendstats(product3.getSendstats());
                    String codeDivision = domemallInfos.stream().filter(p -> p.getCODE_DIVISION().equals(MallCode.getDomeMallProductCodeDivision(product3.getCompayny_goods_cd()))).map(p -> p.getSHOPCD()).findFirst().orElse("");
                    copyProductIn.setGoods_keyword(codeDivision);
                    int ret = ProductDAO.get().updateProductIn(copyProductIn);
                    if (ret == 1) {
                        inRet += ret;
                        String comment = String.format(" %s [%s] \uc1fc\ud551\ubab0 \uc0c1\ud488 \uc218\uc815 \uc644\ub8cc", shopInfoLog, product3.getCompayny_goods_cd());
                        this.setValueProd(comment, 50, product3, shopInfo, "YEL_ADD", "\uc131\uacf5", "[\uc6b4\uc601\uc0c1\ud488\uad00\ub9ac - \uc0c1\ud488\ucd94\uac00] \uc0c1\ud488\uc774 \uc774\ubbf8 \uc874\uc7ac\ud558\uc5ec \uc0c1\ud0dc\uac00 \uc5e0\ub9c1\ud06c\uc5d0\uc11c \uc218\uc815\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", true);
                    }
                }
                copyProductIn = ProductDAO.get().selectProductIn(shopInfo, copyProduct.getPRODSEQ());
                if (product3.getOPTIONS() == null) continue;
                for (ProductOptionDTO option2 : product3.getOPTIONS()) {
                    ProductOptionDTO copyOption = ProductDAO.get().selectOptProductInfo(copyProduct.getPRODSEQ(), option2.getSKUSEQ());
                    if (copyOption == null) {
                        option2.setPRODSEQ(Integer.parseInt(copyProduct.getPRODSEQ()));
                        option2.setCOMPAYNY_GOODS_CD(product3.getCompayny_goods_cd());
                        ProductDAO.get().insertOptProductInfo(option2);
                    } else {
                        copyOption.setCOMPAYNY_GOODS_CD(product3.getCompayny_goods_cd());
                        copyOption.setOPTPRODCD(option2.getOPTPRODCD());
                        copyOption.setOPTPRODNM(option2.getOPTPRODNM());
                        copyOption.setOPTSPECDES(option2.getOPTSPECDES());
                        copyOption.setOPTEA(option2.getOPTEA());
                        copyOption.setOPTSAFESTOCK(option2.getOPTSAFESTOCK());
                        copyOption.setOPTVERTSTOCK(option2.getOPTVERTSTOCK());
                        copyOption.setOPTADDAMT(option2.getOPTADDAMT());
                        copyOption.setINSERTDT(option2.getINSERTDT());
                        copyOption.setINSERTID(option2.getINSERTID());
                        copyOption.setMODIFYDT(option2.getMODIFYDT());
                        copyOption.setSTATUS(option2.getSTATUS());
                    }
                    ProductOptionDTO copyOptionIn = ProductDAO.get().selectOptProductIn(copyProductIn.getSENDSEQ(), option2.getSKUSEQ());
                    if (copyOptionIn == null) {
                        option2.setSENDSEQ(Integer.parseInt(copyProductIn.getSENDSEQ()));
                        option2.setPRODSEQ(Integer.parseInt(copyProduct.getPRODSEQ()));
                        ProductDAO.get().insertOptProductIn(option2);
                        continue;
                    }
                    copyOptionIn.setSHOPPRODNO(option2.getSHOPPRODNO());
                    copyOptionIn.setSHOPPRODSKU(option2.getSHOPPRODSKU());
                    copyOptionIn.setSHOPPRODSKU_NM(option2.getSHOPPRODSKU_NM());
                    copyOptionIn.setOPTPRODCD(option2.getOPTPRODCD());
                    copyOptionIn.setOPTPRODNM(option2.getOPTPRODNM());
                    copyOptionIn.setOPTSPECDES(option2.getOPTSPECDES());
                    copyOptionIn.setOPTEA(option2.getOPTEA());
                    copyOptionIn.setOPTSAFESTOCK(option2.getOPTSAFESTOCK());
                    copyOptionIn.setOPTVERTSTOCK(option2.getOPTVERTSTOCK());
                    copyOptionIn.setOPTADDAMT(option2.getOPTADDAMT());
                    copyOptionIn.setINSERTDT(option2.getINSERTDT());
                    copyOptionIn.setINSERTID(option2.getINSERTID());
                    copyOptionIn.setMODIFYDT(option2.getMODIFYDT());
                    copyOptionIn.setSTATUS(option2.getSTATUS());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String errorMessage = e.getMessage() != null ? e.getMessage() : "\uc54c \uc218 \uc5c6\ub294 \uc624\ub958 \ubc1c\uc0dd";
            this.setValue(String.format("%s %s %s", date, shopInfoLog, errorMessage), 100);
            this.setValue("--------------------------------------------------------------------------------------", 100);
            return new ResultProcessDTO(-1, "", 0, 0);
        }
        this.setValue(String.format("%s %s \ucd1d %s\uac74\uc758 \uc0c1\ud488 \ub370\uc774\ud130 \ucd94\uac00\ub97c \uc644\ub8cc\ud588\uc2b5\ub2c8\ub2e4.", date, shopInfoLog, inRet), 100);
        this.setValue("--------------------------------------------------------------------------------------", 100);
        return new ResultProcessDTO(0, "", infoRet, inRet);
    }

    public List<ProductOptionDTO> getOption(ProductDTO responseProduct, JsonObject optionsInfo) {
        ArrayList<ProductOptionDTO> options;
        block9: {
            JsonArray totalOptions;
            JsonArray optionPrices;
            JsonArray optionNames;
            block8: {
                String id;
                String name;
                JsonObject optionObj;
                options = new ArrayList<ProductOptionDTO>();
                optionNames = (JsonArray)optionsInfo.get("optionNames");
                optionPrices = (JsonArray)optionsInfo.get("optionPrices");
                totalOptions = (JsonArray)optionsInfo.get("totalOptions");
                if (optionNames.size() != 1) break block8;
                String optnm1 = optionNames.get(0).getAsString();
                ArrayList optionList = new ArrayList();
                JsonArray totalOptionsDetail = (JsonArray)totalOptions.get(0);
                int k = 0;
                while (k < totalOptionsDetail.size()) {
                    optionObj = (JsonObject)totalOptionsDetail.get(k);
                    name = optionObj.get("name").getAsString();
                    id = optionObj.get("_id").getAsString();
                    HashMap<String, String> optionMap = new HashMap<String, String>();
                    optionMap.put("name", name);
                    optionMap.put("id", id);
                    optionList.add(optionMap);
                    ++k;
                }
                k = 0;
                while (k < optionPrices.size()) {
                    optionObj = (JsonObject)optionPrices.get(k);
                    name = (String)((Map)optionList.get(k)).get("name");
                    id = (String)((Map)optionList.get(k)).get("id");
                    String idInPrice = optionObj.get("_id").getAsString();
                    Boolean isSale = optionObj.get("sold_out").getAsBoolean();
                    if (id.equals(idInPrice) && !isSale.booleanValue()) {
                        ProductOptionDTO option2 = new ProductOptionDTO();
                        option2.setSHOPPRODNO(responseProduct.getShopprodno());
                        option2.setSHOPPRODSKU_NM(responseProduct.getGoods_nm());
                        option2.setPRODCD(responseProduct.getCompayny_goods_cd());
                        option2.setOPTPRODNM(optnm1);
                        option2.setSKUSEQ(k + 1);
                        option2.setOPTSPECDES(name);
                        option2.setSHOPPRODSKU(id);
                        option2.setOPTPRODCD(responseProduct.getCompayny_goods_cd().concat("-" + String.valueOf(k + 1)));
                        option2.setOPTSAFESTOCK(optionObj.get("stockNumber").getAsInt());
                        option2.setOPTVERTSTOCK(optionObj.get("stockNumber").getAsInt());
                        int optAmt = optionObj.get("individualPurchasePrice").getAsInt() - Integer.parseInt(responseProduct.getGoods_price());
                        option2.setOPTADDAMT(optAmt);
                        option2.setINSERTDT(responseProduct.getInsertdt());
                        option2.setINSERTID(YDMASessonUtil.getUserInfo().getUserId());
                        option2.setSTATUS(optionObj.get("stockNumber").getAsInt() > 0 ? "0" : "1");
                        options.add(option2);
                    }
                    ++k;
                }
                break block9;
            }
            if (optionNames.size() != 2) break block9;
            String optnm1 = optionNames.get(0).getAsString();
            String optnm2 = optionNames.get(1).getAsString();
            String name = "";
            String id = "";
            ArrayList optionList = new ArrayList();
            JsonArray totalOptionsDetail1 = (JsonArray)totalOptions.get(0);
            int k = 0;
            while (k < totalOptionsDetail1.size()) {
                JsonObject optionObj1 = (JsonObject)totalOptionsDetail1.get(k);
                String name1 = optionObj1.get("name").getAsString();
                String id1 = optionObj1.get("_id").getAsString();
                JsonArray totalOptionsDetail2 = (JsonArray)totalOptions.get(1);
                int i = 0;
                while (i < totalOptionsDetail2.size()) {
                    JsonObject optionObj2 = (JsonObject)totalOptionsDetail2.get(i);
                    String name2 = optionObj2.get("name").getAsString();
                    String id2 = optionObj2.get("_id").getAsString();
                    name = name1.concat(":").concat(name2);
                    id = id1.concat("_").concat(id2);
                    HashMap<String, String> optionMap = new HashMap<String, String>();
                    optionMap.put("name", name);
                    optionMap.put("id", id);
                    optionList.add(optionMap);
                    ++i;
                }
                ++k;
            }
            int cnt = 0;
            int k2 = 0;
            while (k2 < optionPrices.size()) {
                JsonArray optionPricesArray = (JsonArray)optionPrices.get(k2);
                int i = 0;
                while (i < optionPricesArray.size()) {
                    JsonObject optionPricesArrayobj = (JsonObject)optionPricesArray.get(i);
                    name = (String)((Map)optionList.get(cnt)).get("name");
                    id = (String)((Map)optionList.get(cnt)).get("id");
                    String idInOptionPrices = optionPricesArrayobj.get("_id").getAsString();
                    Boolean isSale = optionPricesArrayobj.get("sold_out").getAsBoolean();
                    if (id.equals(idInOptionPrices) && !isSale.booleanValue()) {
                        ProductOptionDTO option3 = new ProductOptionDTO();
                        option3.setSHOPPRODNO(responseProduct.getShopprodno());
                        option3.setSHOPPRODSKU_NM(responseProduct.getGoods_nm());
                        option3.setPRODCD(responseProduct.getCompayny_goods_cd());
                        option3.setOPTPRODNM(optnm1.concat(":").concat(optnm2));
                        option3.setSKUSEQ(k2 + 1);
                        option3.setOPTSPECDES(name);
                        option3.setSHOPPRODSKU(id);
                        option3.setOPTPRODCD(responseProduct.getCompayny_goods_cd().concat("-" + String.valueOf(i + 1)));
                        option3.setOPTSAFESTOCK(optionPricesArrayobj.get("stockNumber").getAsInt());
                        option3.setOPTVERTSTOCK(optionPricesArrayobj.get("stockNumber").getAsInt());
                        int optAmt = optionPricesArrayobj.get("individualPurchasePrice").getAsInt() - Integer.parseInt(responseProduct.getGoods_price());
                        option3.setOPTADDAMT(optAmt);
                        option3.setINSERTDT(responseProduct.getInsertdt());
                        option3.setINSERTID(YDMASessonUtil.getUserInfo().getUserId());
                        option3.setSTATUS(optionPricesArrayobj.get("stockNumber").getAsInt() > 0 ? "0" : "1");
                        options.add(option3);
                    }
                    ++cnt;
                    ++i;
                }
                ++k2;
            }
        }
        return options;
    }

    private String dateFormat1(String inputDate) {
        LocalDate date = LocalDate.parse(inputDate);
        LocalDateTime dateTime = date.atStartOfDay();
        ZonedDateTime utcDateTime = dateTime.atZone(ZoneId.systemDefault()).withZoneSameInstant(ZoneId.of("UTC"));
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        String formattedDate = utcDateTime.format(formatter);
        return formattedDate;
    }

    private String dateFormat2(String inputDate) {
        DateTimeFormatter inputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSX");
        DateTimeFormatter outputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        ZonedDateTime zonedDateTime = ZonedDateTime.parse(inputDate, inputFormatter);
        String formattedDate = zonedDateTime.format(outputFormatter);
        return formattedDate;
    }

    public CategoryDTO getCategory(JsonObject data2, String token) {
        try {
            JsonObject info;
            JsonObject categoryInfo = (JsonObject)data2.get("categoryInfo");
            int minimumCategoryId = categoryInfo.get("minimumCategoryId").getAsInt();
            Connection.Response rs = Jsoup.connect((String)("https://alwayz-seller-back.ilevit.com/items/item-category/id?id=" + minimumCategoryId)).header("x-access-token", token).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36").method(Connection.Method.GET).ignoreHttpErrors(true).ignoreContentType(true).followRedirects(true).execute();
            Object responseBody = rs.body();
            if (((String)responseBody).trim().startsWith("<html")) {
                CategoryDTO category = CategoryDAO.get().selectCategory("350119000");
                return category;
            }
            try {
                JsonReader reader = new JsonReader((Reader)new StringReader((String)responseBody));
                reader.setLenient(true);
                info = new JsonParser().parse(reader).getAsJsonObject();
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                responseBody = "{ \"log\" : \"" + ((String)responseBody).replace("\"", "\\\"") + "\" }";
                info = new JsonParser().parse((String)responseBody).getAsJsonObject();
            }
            if (info == null || info.get("status").getAsInt() != 200) {
                CategoryDTO category = CategoryDAO.get().selectCategory("350119000");
                return category;
            }
            JsonObject jsonData = (JsonObject)info.get("data");
            String name = jsonData.get("name").getAsString();
            CategoryDTO category = CategoryDAO.get().selectShoppingMallCategory(String.valueOf(minimumCategoryId), name);
            if (category == null && (category = CategoryDAO.get().selectShoppingMallCategory(String.valueOf(minimumCategoryId))) == null) {
                category = CategoryDAO.get().selectCategory("350119000");
            }
            return category;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<List<String>> splitList(List<String> list, int size) {
        ArrayList<List<String>> partitionedList = new ArrayList<List<String>>();
        int i = 0;
        while (i < list.size()) {
            int end = Math.min(i + size, list.size());
            partitionedList.add(list.subList(i, end));
            i += size;
        }
        return partitionedList;
    }

    @Override
    public ResultProcessDTO addProcess2(ProductAddProcessDTO proDto, List<String> specificCodes, IProgressMonitor monitor, ShoppingmallDTO dto) throws Exception {
        return null;
    }

    private void setValue(String message, int value) {
        CommonProgressDialog.get().setValue(message, value);
    }

    private void setValueProd(String title, int value, ProductDTO item, ShoppingmallDTO shopInfo, String jobType, String jobResult, String logMsg, boolean isProdIn) {
        CommonProgressDialog.get().setValueProd(title, value, item, shopInfo, jobType, jobResult, logMsg, isProdIn);
    }

    private class AddInfo {
        @JsonProperty(value="condition")
        private Condition condition = new Condition();
        @JsonProperty(value="page")
        private int page;
        @JsonProperty(value="pageLimit")
        private int pageLimit;

        private class Condition {
            @JsonProperty(value="type")
            private String type;
            @JsonProperty(value="itemCondition")
            private ItemCondition itemCondition;
            @JsonProperty(value="itemSortCondition")
            private ItemSortCondition itemSortCondition;

            private Condition() {
                this.itemCondition = new ItemCondition();
                this.itemSortCondition = new ItemSortCondition();
            }
        }

        private class CreatedAt {
            @JsonProperty(value="$gt")
            private String greaterThan;

            private CreatedAt() {
            }
        }

        private class ItemCondition {
            @JsonProperty(value="createdAt")
            private CreatedAt createdAt;

            private ItemCondition() {
                this.createdAt = new CreatedAt();
            }
        }

        private class ItemSortCondition {
            @JsonProperty(value="createdAt")
            private int createdAt;

            private ItemSortCondition() {
            }
        }
    }

    private class AddInfoByWord {
        @JsonProperty(value="condition")
        private Condition condition = new Condition();
        @JsonProperty(value="page")
        private int page;
        @JsonProperty(value="pageLimit")
        private int pageLimit;

        private class Condition {
            @JsonProperty(value="type")
            private String type;
            @JsonProperty(value="itemCondition")
            private ItemCondition itemCondition;
            @JsonProperty(value="itemSortCondition")
            private ItemSortCondition itemSortCondition;

            private Condition() {
                this.itemCondition = new ItemCondition();
                this.itemSortCondition = new ItemSortCondition();
            }
        }

        private class CreatedAt {
            @JsonProperty(value="$gt")
            private String greaterThan;

            private CreatedAt() {
            }
        }

        private class ItemCondition {
            @JsonProperty(value="createdAt")
            private CreatedAt createdAt;
            @JsonProperty(value="recommendItemCode")
            private RecommedItemCode recommendItemCode;
            @JsonProperty(value="optionsInfo")
            private OptionsInfo optionsInfo;

            private ItemCondition() {
                this.createdAt = new CreatedAt();
                this.recommendItemCode = new RecommedItemCode();
                this.optionsInfo = new OptionsInfo();
            }
        }

        private class ItemSortCondition {
            @JsonProperty(value="createdAt")
            private int createdAt;

            private ItemSortCondition() {
            }
        }

        private class OptionPrices {
            @JsonProperty(value="optionCode")
            private String optionCode;

            private OptionPrices() {
            }
        }

        private class OptionsInfo {
            @JsonProperty(value="optionPrices")
            private OptionPrices optionPrices;

            private OptionsInfo() {
                this.optionPrices = new OptionPrices();
            }
        }

        private class RecommedItemCode {
            @JsonProperty(value="$in")
            private List<String> $in = new ArrayList<String>();

            private RecommedItemCode() {
            }
        }
    }
}

