/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.service;

import com.google.gson.JsonObject;
import com.kdjsystem.mlink.yellim.dto.ProductDTO;
import com.kdjsystem.mlink.yellim.dto.ProductModifyProcessDTO;
import com.kdjsystem.mlink.yellim.dto.ResultProcessDTO;
import com.kdjsystem.mlink.yellim.dto.ShoppingmallDTO;
import com.kdjsystem.mlink.yellim.factory.IProductModifyProcess;
import com.kdjsystem.mlink.yellim.helper.LoginHelper;
import com.kdjsystem.mlink.yellim.shop.common.IProductModifyStatusApi;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductAdditionDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductSendDto;
import com.kdjsystem.mlink.yellim.shop.data.alwayz.AlwayzAccessToken;
import com.kdjsystem.mlink.yellim.ui.CommonProgressDialog;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class AlwayzProductModifyService
extends IProductModifyStatusApi
implements IProductModifyProcess {
    @Override
    public ResultProcessDTO modifyProcess(ProductModifyProcessDTO dto, String jobType, String logMsg) throws Exception {
        ShoppingmallDTO shopInfo = dto.getSHOPINFO();
        ProductDTO prodInfo = dto.getPRODUCT();
        String shopInfoLog = String.format("[%s - %s(%s)]", shopInfo.getSHOPNM(), shopInfo.getSHOPPINGID(), shopInfo.getNICKNM1());
        boolean flag = true;
        try {
            switch (dto.getPROCESS_STATUS()) {
                case 4100: {
                    flag = this.productSoldOut(prodInfo, shopInfo);
                    if (!flag) {
                        return new ResultProcessDTO(-1, "", dto.getPRODUCT().getSENDSEQ());
                    }
                    this.logProductInDetail(shopInfoLog, prodInfo, "\ud310\ub9e4\uc911\ub2e8", shopInfo, "\uc131\uacf5", "YEL_DIS_AUT", "\uc0c1\ud488\uc744 \uc1fc\ud551\ubab0\uc5d0\uc11c \ud310\ub9e4\uc911\ub2e8 \ucc98\ub9ac\ud588\uc2b5\ub2c8\ub2e4.");
                    break;
                }
                case 4200: {
                    flag = this.productResumeSale(prodInfo, shopInfo);
                    if (flag) break;
                    return new ResultProcessDTO(-1, "", dto.getPRODUCT().getSENDSEQ());
                }
                case 3000: 
                case 4000: {
                    flag = this.DeleteProduct(shopInfo, prodInfo);
                    if (!flag) {
                        return new ResultProcessDTO(-1, "", dto.getPRODUCT().getSENDSEQ());
                    }
                    this.logProductInDetail(shopInfoLog, prodInfo, "\uc0ad\uc81c", shopInfo, "\uc131\uacf5", jobType, logMsg);
                }
            }
            return new ResultProcessDTO(0, "\uc815\uc0c1\uc801\uc73c\ub85c \ucc98\ub9ac\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", dto.getPRODUCT().getSENDSEQ());
        }
        catch (Exception e) {
            return new ResultProcessDTO(-1, e.getMessage(), dto.getPRODUCT().getSENDSEQ());
        }
    }

    private boolean productSoldOut(ProductDTO dto, ShoppingmallDTO shopdto) {
        return this.updateSellStatus(dto, shopdto.getSHOPPINGID(), shopdto.getPASSWORD(), "https://alwayz-seller-back.ilevit.com/items/sold-out");
    }

    private boolean productResumeSale(ProductDTO dto, ShoppingmallDTO shopdto) {
        return this.updateSellStatus(dto, shopdto.getSHOPPINGID(), shopdto.getPASSWORD(), "https://alwayz-seller-back.ilevit.com/items/resume");
    }

    private boolean updateSellStatus(ProductDTO dto, String id, String pw, String url) {
        try {
            String token = AlwayzAccessToken.get().getAccessToken(id, pw);
            String json = "{ \"itemId\": \"" + dto.getShopprodno() + "\" }";
            Connection.Response rs = Jsoup.connect((String)url).header("Connection", "keep-alive").header("x-access-token", token).header("Content-Type", "application/json").userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36").method(Connection.Method.POST).requestBody(json).ignoreContentType(true).execute();
            JsonObject jsonObject = jsonParser.parse(rs.body()).getAsJsonObject();
            return "200".equals(jsonObject.get("status").getAsString());
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean DeleteProduct(ShoppingmallDTO shoppingMallDetailDto, ProductDTO dto) throws Exception {
        try {
            Map<String, String> loginInfo = LoginHelper.loginAlwayzInfo(shoppingMallDetailDto.getSHOPPINGID(), shoppingMallDetailDto.getPASSWORD(), shoppingMallDetailDto.getSHOPCD());
            String targetUrl = "https://alwayz-seller-back.ilevit.com/sellers/items";
            String itemId = dto.getShopprodno();
            String jsonInputString = "{ \"itemId\": \"" + itemId + "\" }";
            URL url = new URL(targetUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("DELETE");
            connection.setRequestProperty("x-access-token", loginInfo.get("token"));
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36");
            connection.setDoOutput(true);
            Throwable throwable = null;
            Object var10_13 = null;
            try (OutputStream os = connection.getOutputStream();){
                byte[] input = jsonInputString.getBytes("utf-8");
                os.write(input, 0, input.length);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            int responseCode = connection.getResponseCode();
            return responseCode == 200;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public ResultProcessDTO optionModifyProcess(ProductModifyProcessDTO dto) throws Exception {
        return null;
    }

    @Override
    public boolean deleteProduct(ProductDTO shopProductDto) throws Exception {
        return false;
    }

    @Override
    public boolean modifyProductStatusDto(ProductDTO shopProductDto, ShopProductAdditionDto dtllist, ShoppingmallDTO shoppingmallDTO, String status2, ShopProductSendDto shopProductSendDto, Map<String, String> loginCookies) throws Exception {
        return false;
    }

    @Override
    public boolean isExistProdNo(ProductDTO dto, ShoppingmallDTO shoppingmallDTO, Map<String, String> loginCookie) throws Exception {
        return false;
    }

    private void logProductInDetail(String shopInfoLog, ProductDTO prodInfo, String action, ShoppingmallDTO shoppingmallDTO, String jobResult, String jobType, String logMsg) {
        String comment = String.format(" %s [%s]\n \u2192 \uc0c1\ud488\uc744 \uc1fc\ud551\ubab0\uc5d0\uc11c %s \ucc98\ub9ac\ud588\uc2b5\ub2c8\ub2e4.", shopInfoLog, prodInfo.getCompayny_goods_cd(), action);
        CommonProgressDialog.get().setValueBackProd(comment, 50, prodInfo, shoppingmallDTO, jobType, jobResult, logMsg, true);
    }
}

