/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.service;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.jogamp.common.util.InterruptSource;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.dto.ProductDTO;
import com.kdjsystem.mlink.yellim.dto.ProductModifyProcessDTO;
import com.kdjsystem.mlink.yellim.dto.ResultProcessDTO;
import com.kdjsystem.mlink.yellim.dto.ShoppingmallDTO;
import com.kdjsystem.mlink.yellim.factory.IProductModifyProcess;
import com.kdjsystem.mlink.yellim.shop.common.IProductModifyStatusApi;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductAdditionDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductSendDto;
import com.kdjsystem.mlink.yellim.ui.CommonProgressDialog;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class CoupangProductModifyService
extends IProductModifyStatusApi
implements IProductModifyProcess {
    List<String> optName = new ArrayList<String>();

    @Override
    public ResultProcessDTO modifyProcess(ProductModifyProcessDTO dto, String jobType, String logMsg) throws Exception {
        ShoppingmallDTO shopInfo = dto.getSHOPINFO();
        ProductDTO prodInfo = dto.getPRODUCT();
        String shopInfoLog = String.format("[%s - %s(%s)]", dto.getSHOPINFO().getSHOPNM(), dto.getSHOPINFO().getSHOPPINGID(), dto.getSHOPINFO().getNICKNM1());
        String vendorItemId = dto.getPRODUCT().getShopprodno();
        boolean flag = true;
        try {
            switch (dto.getPROCESS_STATUS()) {
                case 4100: {
                    flag = this.productSoldOut(vendorItemId, dto.getCOOKIES());
                    if (!flag) {
                        return new ResultProcessDTO(-1, "", dto.getPRODUCT().getSENDSEQ());
                    }
                    this.logProductInDetail(shopInfoLog, prodInfo, "\ud310\ub9e4\uc911\ub2e8", shopInfo, "\uc131\uacf5", "YEL_DIS_AUT", "\uc0c1\ud488\uc744 \uc1fc\ud551\ubab0\uc5d0\uc11c \ud310\ub9e4\uc911\ub2e8 \ucc98\ub9ac\ud588\uc2b5\ub2c8\ub2e4.");
                    break;
                }
                case 4200: {
                    flag = this.productResumeSale(vendorItemId, dto.getCOOKIES());
                    if (flag) break;
                    return new ResultProcessDTO(-1, "", dto.getPRODUCT().getSENDSEQ());
                }
                case 3000: 
                case 4000: {
                    flag = this.productDeleteByWeb(dto.getPRODUCT().getShopprodno(), dto.getCOOKIES());
                    if (!flag) {
                        return new ResultProcessDTO(-1, "", dto.getPRODUCT().getSENDSEQ());
                    }
                    this.logProductInDetail(shopInfoLog, prodInfo, "\uc0ad\uc81c", shopInfo, "\uc131\uacf5", jobType, logMsg);
                    InterruptSource.Thread.sleep((long)500L);
                }
            }
            YDMAStringUtil.Print();
            return new ResultProcessDTO(0, "\uc815\uc0c1\uc801\uc73c\ub85c \ucc98\ub9ac\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", dto.getPRODUCT().getSENDSEQ());
        }
        catch (Exception e) {
            return new ResultProcessDTO(-1, e.getMessage(), dto.getPRODUCT().getSENDSEQ());
        }
    }

    private boolean productResumeSale(String vendorItemId, Map<String, String> cookies) {
        return this.updateSellStatusByWeb(vendorItemId, cookies, "VALID");
    }

    private boolean productSoldOut(String vendorItemId, Map<String, String> cookies) {
        return this.updateSellStatusByWeb(vendorItemId, cookies, "INVALID");
    }

    private boolean updateSellStatusByWeb(String vendorItemId, Map<String, String> cookies, String status2) {
        try {
            JsonArray vendorInventoryIds = new JsonArray();
            vendorInventoryIds.add(vendorItemId);
            JsonObject obj = new JsonObject();
            obj.add("vendorInventoryIds", (JsonElement)vendorInventoryIds);
            obj.addProperty("saleStatus", status2);
            Connection.Response rs = Jsoup.connect((String)"https://wing.coupang.com/tenants/seller-web/vendor-inventories/sale-status-change/request").header("Content-Type", "application/json").cookies(cookies).method(Connection.Method.POST).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36").timeout(20000).requestBody(obj.toString()).ignoreContentType(true).execute();
            JsonArray arr = jsonParser.parse(rs.body()).getAsJsonArray();
            JsonObject object = arr.get(0).getAsJsonObject();
            return object.get("success").getAsBoolean();
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean productDeleteByWeb(String shopprodno, Map<String, String> cookies) {
        try {
            Connection.Response rs = Jsoup.connect((String)"https://wing.coupang.com/tenants/seller-web/v2/vendor-inventories/delete").header("Content-Type", "application/x-www-form-urlencoded").cookies(cookies).method(Connection.Method.POST).timeout(20000).data("vendorInventoryIds[]", shopprodno).ignoreHttpErrors(true).ignoreContentType(true).followRedirects(true).execute();
            YDMAStringUtil.Print(rs.body());
            if (rs.statusCode() == 200) {
                JsonParser jsonParser = new JsonParser();
                JsonArray jsonArray = jsonParser.parse(rs.body()).getAsJsonArray();
                if (jsonArray.size() == 1 && "true".equals(jsonArray.get(0).getAsJsonObject().get("success").getAsString())) {
                    return true;
                }
                return true;
            }
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public boolean modifyProductStatusDto(ProductDTO prodInfo, ShopProductAdditionDto dtllist, ShoppingmallDTO shopInfo, String status2, ShopProductSendDto sendDTO, Map<String, String> loginCookies) throws Exception {
        return true;
    }

    @Override
    public boolean isExistProdNo(ProductDTO prodInfo, ShoppingmallDTO shopInfo, Map<String, String> loginCookie) throws Exception {
        return false;
    }

    @Override
    public boolean deleteProduct(ProductDTO shopProductDto) throws Exception {
        return false;
    }

    @Override
    public ResultProcessDTO optionModifyProcess(ProductModifyProcessDTO dto) throws Exception {
        return null;
    }

    private void logProductInDetail(String shopInfoLog, ProductDTO prodInfo, String action, ShoppingmallDTO shoppingmallDTO, String jobResult, String jobType, String logMsg) {
        String comment = String.format(" %s [%s]\n \u2192 \uc0c1\ud488\uc744 \uc1fc\ud551\ubab0\uc5d0\uc11c %s \ucc98\ub9ac\ud588\uc2b5\ub2c8\ub2e4.", shopInfoLog, prodInfo.getCompayny_goods_cd(), action);
        CommonProgressDialog.get().setValueBackProd(comment, 50, prodInfo, shoppingmallDTO, jobType, jobResult, logMsg, true);
    }
}

