/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.service;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.gson.JsonObject;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.dto.ProductDTO;
import com.kdjsystem.mlink.yellim.dto.ProductModifyProcessDTO;
import com.kdjsystem.mlink.yellim.dto.ResultProcessDTO;
import com.kdjsystem.mlink.yellim.dto.ShoppingmallDTO;
import com.kdjsystem.mlink.yellim.factory.IProductModifyProcess;
import com.kdjsystem.mlink.yellim.shop.common.IProductModifyStatusApi;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductAdditionDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductSendDto;
import com.kdjsystem.mlink.yellim.shop.data.gsshop.GsShopApiClient;
import com.kdjsystem.mlink.yellim.shop.data.gsshop.GsShopRow;
import com.kdjsystem.mlink.yellim.shop.data.gsshop.GsShopRows;
import com.kdjsystem.mlink.yellim.ui.CommonProgressDialog;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class GsShopProductModifyService
extends IProductModifyStatusApi
implements IProductModifyProcess {
    ObjectMapper gsMapper = new ObjectMapper();

    @Override
    public ResultProcessDTO modifyProcess(ProductModifyProcessDTO dto, String jobType, String logMsg) throws Exception {
        ShoppingmallDTO shopInfo = dto.getSHOPINFO();
        ProductDTO prodInfo = dto.getPRODUCT();
        String shopInfoLog = String.format("[%s - %s(%s)]", shopInfo.getSHOPNM(), shopInfo.getSHOPPINGID(), shopInfo.getNICKNM1());
        this.gsMapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        this.gsMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        this.gsMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        boolean flag = true;
        try {
            switch (dto.getPROCESS_STATUS()) {
                case 4100: {
                    flag = this.saleStop(prodInfo, dto.getCOOKIES());
                    if (!flag) {
                        return new ResultProcessDTO(-1, "", dto.getPRODUCT().getSENDSEQ());
                    }
                    this.logProductInDetail(shopInfoLog, prodInfo, "\ud310\ub9e4\uc911\ub2e8", shopInfo, "\uc131\uacf5", "YEL_DIS_AUT", "\uc0c1\ud488\uc744 \uc1fc\ud551\ubab0\uc5d0\uc11c \ud310\ub9e4\uc911\ub2e8 \ucc98\ub9ac\ud588\uc2b5\ub2c8\ub2e4.");
                    break;
                }
                case 4200: {
                    flag = this.saleResume(prodInfo, dto.getCOOKIES());
                    if (!flag) {
                        return new ResultProcessDTO(-1, "", dto.getPRODUCT().getSENDSEQ());
                    }
                    break;
                }
                case 3000: 
                case 4000: {
                    flag = this.deleteOrTerminateSale(prodInfo, dto.getCOOKIES());
                    if (!flag) {
                        return new ResultProcessDTO(-1, "", dto.getPRODUCT().getSENDSEQ());
                    }
                    this.logProductInDetail(shopInfoLog, prodInfo, "\uc0ad\uc81c", shopInfo, "\uc131\uacf5", jobType, logMsg);
                }
            }
        }
        catch (Exception e) {
            return new ResultProcessDTO(-1, e.getMessage(), dto.getPRODUCT().getSENDSEQ());
        }
        return new ResultProcessDTO(0, "\uc815\uc0c1\uc801\uc73c\ub85c \ucc98\ub9ac\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", dto.getPRODUCT().getSENDSEQ());
    }

    private boolean saleStop(ProductDTO prodInfo, Map<String, String> cookies) throws Exception {
        if (prodInfo.getShopprodno().contains("GSSHOP")) {
            String goodsCd = prodInfo.getCompayny_goods_cd();
            String gsNo = this.getGsNo(goodsCd, cookies);
            if (gsNo.isEmpty() || gsNo.contains("GSSHOP")) {
                prodInfo.setResult_code("-1");
                prodInfo.setResult_text("\uc544\uc9c1 GS\uc0c1\ud488\ucf54\ub4dc\uac00 \uc0dd\uc131\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4. gs\uc0c1\ud488\ucf54\ub4dc \uc0dd\uc131\ub41c \uc774\ud6c4\uc5d0 \ud310\ub9e4\uc911\uc9c0 \uac00\ub2a5\ud569\ub2c8\ub2e4.");
                return false;
            }
            prodInfo.setShopprodno(gsNo);
        }
        return this.productTerminateOrStopSale(prodInfo.getSHOP_USERID(), prodInfo.getShopprodno(), cookies, "1");
    }

    private boolean saleResume(ProductDTO prodInfo, Map<String, String> cookies) {
        return false;
    }

    private boolean deleteOrTerminateSale(ProductDTO prodInfo, Map<String, String> cookies) throws Exception {
        if (prodInfo.getShopprodno().contains("GSSHOP")) {
            String goodsCd = prodInfo.getCompayny_goods_cd();
            String gsNo = this.getGsNo(goodsCd, cookies);
            if (gsNo.contains("GSSHOP")) {
                return this.productDelete(prodInfo.getSHOP_USERID(), goodsCd, cookies);
            }
            prodInfo.setShopprodno(gsNo);
        }
        return this.productTerminateOrStopSale(prodInfo.getSHOP_USERID(), prodInfo.getShopprodno(), cookies, "31");
    }

    private boolean productTerminateOrStopSale(String loginID, String goodId, Map<String, String> cookies, String closeDesc) throws Exception {
        GsShopRows rows = this.findSaleStatusAndStock(goodId, cookies, "20");
        List<GsShopRow> rowList = rows.getRows();
        if (rowList == null || rowList.isEmpty()) {
            return false;
        }
        GsShopRow row = rowList.get(0);
        ArrayList<SprodIntList> sprodIntList = new ArrayList<SprodIntList>();
        SprodIntList sprodInt = new SprodIntList();
        sprodInt.suppCode = loginID;
        sprodInt.partNum = "";
        sprodInt.goodId = goodId;
        sprodInt.newSaleFlag = "Y";
        sprodInt.oldNewSaleFlag = "N";
        sprodInt.closeDesc = closeDesc;
        sprodInt.allQty = "";
        sprodInt.reqAllQty = "";
        sprodInt.addPoint = "";
        sprodInt.dtype = row.getCell(42);
        sprodInt.stype = row.getCell(43);
        sprodInt.crtype = row.getCell(44);
        sprodInt.oldSaleFlag = "N";
        sprodInt.reordTemp = 0;
        sprodInt.parProdIntId = goodId;
        sprodInt.goodNm = row.getCell(8);
        sprodInt.saleEndId = "";
        sprodInt.saleEndIdSub = "";
        sprodInt.qryGbn = "20";
        sprodInt.attrInclYn = "Y";
        sprodInt.totCnt = 1;
        sprodIntList.add(sprodInt);
        try {
            Connection.Response rs = this.getConnection(this.gsMapper.writeValueAsString(sprodIntList), cookies).execute();
            if (rs.statusCode() == 200) {
                String body = rs.body();
                YDMAStringUtil.Print("================ \uc9c0\uc5d0\uc2a4\uc0f5 \uc0c1\ud488\ud310\ub9e4\uc911\uc9c0 \uacb0\uacfc" + body + "============================");
                JsonObject obj = jsonParser.parse(body).getAsJsonObject();
                if (obj.has("output") && obj.get("errCnt").getAsInt() == 0) {
                    return true;
                }
            }
        }
        catch (Exception exception) {}
        return false;
    }

    private boolean productDelete(String loginID, String goodsCd, Map<String, String> cookies) {
        ArrayList<GsScmPrdChgreq> gsScmPrdChgReqL = new ArrayList<GsScmPrdChgreq>();
        GsScmPrdChgreq gsScmPrdChgReq = new GsScmPrdChgreq();
        gsScmPrdChgReq.suppCode = loginID;
        gsScmPrdChgReq.suppGoodsCode = goodsCd;
        gsScmPrdChgReqL.add(gsScmPrdChgReq);
        try {
            Connection.Response rs = Jsoup.connect((String)"https://withgs.gsshop.com/prd/prdRegModifyList_M/deletePrd").cookies(cookies).header("Accept", "application/json, text/javascript, */*; q=0.01").header("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8").data("gsScmPrdChgreq", this.gsMapper.writeValueAsString(gsScmPrdChgReqL)).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36").method(Connection.Method.POST).ignoreContentType(true).execute();
            if (rs.statusCode() == 200) {
                String body = rs.body();
                YDMAStringUtil.Print("================ \uc9c0\uc5d0\uc2a4\uc0f5 \uc0c1\ud488\uc0c2\uac8c \uacb0\uacfc" + body + "============================");
                JsonObject obj = jsonParser.parse(body).getAsJsonObject();
                if (obj.has("output")) {
                    return true;
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    private String getGsNo(String goodsCd, Map<String, String> cookies) {
        Object prodNo = "";
        String date364DaysAgo = LocalDate.now(ZoneId.of("Asia/Seoul")).minusDays(364L).format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        String today = LocalDate.now(ZoneId.of("Asia/Seoul")).format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("coGoodsCond", "1");
        params.put("coGoodsNmCond", "1");
        params.put("setInfo1", "Y");
        params.put("setInfo2", "Y");
        params.put("setInfo3", "Y");
        params.put("setInfo4", "Y");
        params.put("setInfo5", "Y");
        params.put("coSetDe", "0");
        params.put("coSetMd", "0");
        params.put("coSetSh", "0");
        params.put("coSetQa", "0");
        params.put("coGoodsTxt", goodsCd);
        params.put("coGoodsNmTxt", "");
        params.put("coMediaType", "");
        params.put("blckPrd", "");
        params.put("regSubj", "");
        params.put("dpatOpVal", "");
        params.put("saleEndRsnCd", "");
        params.put("clsChkStCd", "");
        params.put("mdId", "");
        params.put("rowsPerPage", "50");
        params.put("dateFrom", date364DaysAgo);
        params.put("dateTo", today);
        params.put("pageIdx", "1");
        params.put("pageRange", "10");
        String baseUrl = "https://withgs.gsshop.com/prd/prdRegModifyList_M/list";
        try {
            GsShopRows rows = GsShopApiClient.search(baseUrl, params, cookies);
            if (rows.getTotalCount() > 0) {
                GsShopRow row = rows.getRows().get(0);
                prodNo = "\ud310\ub9e4\ub300\uae30".equals(row.getCell(1)) ? "GSSHOP" + row.getCell(3) : row.getCell(4);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return prodNo;
    }

    private GsShopRows findSaleStatusAndStock(String goodId, Map<String, String> cookies, String gbn) throws Exception {
        String today = LocalDate.now(ZoneId.of("Asia/Seoul")).format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        String baseUrl = "https://withgs.gsshop.com/prd/prdMgrList/searchPrdListAjax";
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("suppCode", "");
        params.put("dateFrom", today);
        params.put("dateTo", today);
        params.put("newSaleFlag", "NTYW");
        params.put("goodNm", "");
        params.put("goodId", goodId);
        params.put("intGoodNm", "");
        params.put("suppGoodId", "");
        params.put("promoNm", "");
        params.put("informNm", "");
        params.put("goodType", "");
        params.put("qtyReqTot", "");
        params.put("regSubj", "");
        params.put("dealYn", "N");
        params.put("dealTypCd", "AL");
        params.put("rowsPerPage", "50");
        params.put("goodIdList", "");
        params.put("suppGoodIdList", "");
        params.put("qryGbn", gbn);
        params.put("qryStd", "S");
        params.put("saleEndRsn", "");
        params.put("pageIdx", "1");
        params.put("rowsPerPage", "50");
        params.put("pageRange", "5");
        return GsShopApiClient.search(baseUrl, params, cookies);
    }

    private Connection getConnection(String sprodIntList, Map<String, String> cookies) {
        Connection conn = Jsoup.connect((String)"https://withgs.gsshop.com/prd/prdMgrList/updatePrdChgReq").cookies(cookies).header("Accept", "application/json, text/javascript, */*; q=0.01").header("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8").data("sprodIntList", sprodIntList).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36").method(Connection.Method.POST).ignoreContentType(true);
        return conn;
    }

    @Override
    public ResultProcessDTO optionModifyProcess(ProductModifyProcessDTO dto) throws Exception {
        return null;
    }

    @Override
    public boolean deleteProduct(ProductDTO shopProductDto) throws Exception {
        return false;
    }

    @Override
    public boolean modifyProductStatusDto(ProductDTO shopProductDto, ShopProductAdditionDto dtllist, ShoppingmallDTO shoppingmallDTO, String status2, ShopProductSendDto shopProductSendDto, Map<String, String> loginCookies) throws Exception {
        return false;
    }

    @Override
    public boolean isExistProdNo(ProductDTO dto, ShoppingmallDTO shoppingmallDTO, Map<String, String> loginCookie) throws Exception {
        return false;
    }

    private void logProductInDetail(String shopInfoLog, ProductDTO prodInfo, String action, ShoppingmallDTO shoppingmallDTO, String jobResult, String jobType, String logMsg) {
        String comment = String.format(" %s [%s]\n \u2192 \uc0c1\ud488\uc744 \uc1fc\ud551\ubab0\uc5d0\uc11c %s \ucc98\ub9ac\ud588\uc2b5\ub2c8\ub2e4.", shopInfoLog, prodInfo.getCompayny_goods_cd(), action);
        CommonProgressDialog.get().setValueBackProd(comment, 50, prodInfo, shoppingmallDTO, jobType, jobResult, logMsg, true);
    }

    private class GsScmPrdChgreq {
        private String suppCode;
        private String suppGoodsCode;

        private GsScmPrdChgreq() {
        }
    }

    private class SprodIntList {
        private String suppCode;
        private String subCode = "";
        private String partNum;
        private String goodId;
        private String rowId = "";
        private String newSaleFlag;
        private String oldNewSaleFlag;
        private String closeDesc;
        private String closeDescCntnt = "";
        private String allQty;
        private String reqAllQty;
        private String reqDmQty = "";
        private String addPoint;
        private String intGoodPreReq = "N";
        private String mode = "newSaleFlag";
        private String ecYn = "N";
        private String dtype;
        private String stype;
        private String dmQty = "";
        private String goodType = "S";
        private String crtype;
        private String oldAddPoint = "";
        private String oldSaleFlag;
        private String saleMedia = "EC";
        private String chanlTyp = "";
        private int reordTemp;
        private String imendFlag = "N";
        private String parProdIntId;
        private String oldImendFlag = "N";
        private String attrMngYn = "E";
        private String goodNm;
        private String intGoodNm = "";
        private String saleEndId;
        private String saleEndIdSub;
        private String srRegId = "";
        private String qryGbn;
        private String attrInclYn;
        private String dealYn = "";
        private String stockInSaleYn = "";
        private int totCnt;

        private SprodIntList() {
        }
    }
}

