/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.yellim.code.MallCode;
import com.kdjsystem.mlink.yellim.dto.ProductDTO;
import com.kdjsystem.mlink.yellim.dto.ProductModifyProcessDTO;
import com.kdjsystem.mlink.yellim.dto.ProductOptionDTO;
import com.kdjsystem.mlink.yellim.dto.ResultProcessDTO;
import com.kdjsystem.mlink.yellim.dto.ShoppingmallDTO;
import com.kdjsystem.mlink.yellim.factory.IProductModifyProcess;
import com.kdjsystem.mlink.yellim.helper.JsonHelper;
import com.kdjsystem.mlink.yellim.protocol.KakaoStoreCombinationAttributes;
import com.kdjsystem.mlink.yellim.protocol.KakaoStoreCombinations;
import com.kdjsystem.mlink.yellim.protocol.KakaoStoreName;
import com.kdjsystem.mlink.yellim.protocol.KakaoStoreOption;
import com.kdjsystem.mlink.yellim.protocol.KakaoStoreUpdateOptionRequest;
import com.kdjsystem.mlink.yellim.shop.common.IProductModifyStatusApi;
import com.kdjsystem.mlink.yellim.shop.dao.ShopOptionDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductAdditionDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductSendDto;
import com.kdjsystem.mlink.yellim.ui.CommonProgressDialog;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class KakaoStoreProductModifyService
extends IProductModifyStatusApi
implements IProductModifyProcess {
    private static final String Host = "https://kapi.kakao.com";
    List<ShopOptionDto> options;

    @Override
    public ResultProcessDTO modifyProcess(ProductModifyProcessDTO dto, String jobType, String logMsg) throws Exception {
        ShoppingmallDTO shopInfo = dto.getSHOPINFO();
        ProductDTO prodInfo = dto.getPRODUCT();
        String shopInfoLog = String.format("[%s - %s(%s)]", dto.getSHOPINFO().getSHOPNM(), dto.getSHOPINFO().getSHOPPINGID(), dto.getSHOPINFO().getNICKNM1());
        try {
            String apiKey = shopInfo.getAPIKEY();
            switch (dto.getPROCESS_STATUS()) {
                case 4100: {
                    this.productSoldOut(apiKey, prodInfo);
                    if (!dto.getPRODUCT().getResult_code().equals("1")) {
                        return new ResultProcessDTO(-1, "", dto.getPRODUCT().getSENDSEQ());
                    }
                    this.logProductInDetail(shopInfoLog, prodInfo, "\ud310\ub9e4\uc911\ub2e8", shopInfo, "\uc131\uacf5", "YEL_DIS_AUT", "\uc0c1\ud488\uc744 \uc1fc\ud551\ubab0\uc5d0\uc11c \ud310\ub9e4\uc911\ub2e8 \ucc98\ub9ac\ud588\uc2b5\ub2c8\ub2e4.");
                    break;
                }
                case 4200: {
                    this.productResumeSale(apiKey, prodInfo);
                    if (dto.getPRODUCT().getResult_code().equals("1")) break;
                    return new ResultProcessDTO(-1, "", dto.getPRODUCT().getSENDSEQ());
                }
                case 3000: 
                case 4000: {
                    this.productDelete(apiKey, prodInfo);
                    if (!dto.getPRODUCT().getResult_code().equals("1")) {
                        return new ResultProcessDTO(-1, "", dto.getPRODUCT().getSENDSEQ());
                    }
                    this.logProductInDetail(shopInfoLog, prodInfo, "\uc0ad\uc81c", shopInfo, "\uc131\uacf5", jobType, logMsg);
                }
            }
            return new ResultProcessDTO(0, "\uc815\uc0c1\uc801\uc73c\ub85c \ucc98\ub9ac\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", dto.getPRODUCT().getSENDSEQ());
        }
        catch (Exception e) {
            return new ResultProcessDTO(-1, e.getMessage(), dto.getPRODUCT().getSENDSEQ());
        }
    }

    private void productSoldOut(String apiKey, ProductDTO prodInfo) throws Exception {
        this.updateSellStatus(apiKey, prodInfo, "OFF");
    }

    private void productResumeSale(String apiKey, ProductDTO prodInfo) throws Exception {
        this.updateSellStatus(apiKey, prodInfo, "ON");
    }

    private void updateSellStatus(String apiKey, ProductDTO prodInfo, String status2) throws Exception {
        String body = "";
        try {
            Connection.Response response = Jsoup.connect((String)"https://kapi.kakao.com/v1/store/product/update").header("Host", "kapi.kakao.com").header("Authorization", "KakaoAK b99a474fd6fe27f966e76e37591f0053").header("Target-Authorization", "KakaoAK " + apiKey).header("channel-ids", "101").header("Content-Type", "application/x-www-form-urlencoded;charset=utf-8").data("productId", prodInfo.getShopprodno()).data("saleStatus", status2).ignoreContentType(true).method(Connection.Method.POST).execute();
            body = response.body();
            if (body.contains(prodInfo.getShopprodno()) && response.statusCode() == 200) {
                prodInfo.setResult_code("1");
            } else {
                prodInfo.setResult_code("-1");
                prodInfo.setResult_text(body);
            }
        }
        catch (Exception e) {
            if (e.getMessage().equals("HTTP error fetching URL")) {
                prodInfo.setResult_code("1");
            }
            throw new Exception("\uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4." + body + e.getMessage());
        }
    }

    private void productDelete(String apiKey, ProductDTO prodInfo) throws Exception {
        String body = "";
        try {
            String json = "{\"productIds\":[" + Integer.parseInt(prodInfo.getShopprodno()) + "]}";
            Connection.Response response = Jsoup.connect((String)Host.concat("/v2/store/products/delete")).header("Host", "kapi.kakao.com").header("Authorization", "KakaoAK b99a474fd6fe27f966e76e37591f0053").header("Target-Authorization", "KakaoAK " + apiKey).header("channel-ids", "101").header("Content-Type", "application/json").requestBody(json).ignoreContentType(true).method(Connection.Method.PUT).execute();
            body = response.body();
            if (body.contains(prodInfo.getShopprodno()) && response.statusCode() == 200) {
                prodInfo.setResult_code("1");
            } else {
                prodInfo.setResult_code("-1");
                prodInfo.setResult_text(body);
            }
        }
        catch (Exception e) {
            prodInfo.setResult_code("-1");
            prodInfo.setResult_text(body);
            throw new Exception("\uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4." + body + e.getMessage());
        }
    }

    @Override
    public ResultProcessDTO optionModifyProcess(ProductModifyProcessDTO dto) throws Exception {
        try {
            KakaoStoreUpdateOptionRequest request2 = this.getKakaoOptionDatas(dto, dto.getPRODUCT().getOPTIONS());
            ObjectMapper objectMapper = new ObjectMapper();
            String json = objectMapper.writeValueAsString((Object)request2);
            Connection.Response response = Jsoup.connect((String)Host.concat("/v1/store/product/option/update")).header("Host", "kapi.kakao.com").header("Authorization", "KakaoAK b99a474fd6fe27f966e76e37591f0053").header("Target-Authorization", "KakaoAK " + dto.getSHOPINFO().getAPIKEY()).header("channel_ids", "101").header("Content-Type", "application/x-www-form-urlencoded;charset=utf-8").data("productId", dto.getPRODUCT().getShopprodno()).data("option", json).method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).ignoreHttpErrors(true).execute();
            String body = response.body();
            JsonParser parser = new JsonParser();
            JsonObject data2 = parser.parse(body).getAsJsonObject();
            if (JsonHelper.isExistsJsonObjectKey(data2, "productId")) {
                return new ResultProcessDTO(0, "Success", dto.getPRODUCT().getCompayny_goods_cd());
            }
            return new ResultProcessDTO(-1, "Failed", dto.getPRODUCT().getCompayny_goods_cd());
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResultProcessDTO(-1, e.getMessage(), dto.getPRODUCT().getCompayny_goods_cd());
        }
    }

    private KakaoStoreUpdateOptionRequest getKakaoOptionDatas(ProductModifyProcessDTO dto, List<ProductOptionDTO> soldoutOptions) {
        try {
            Connection.Response response = Jsoup.connect((String)MallCode.getKakaoProductOptionSearchURL(dto.getPRODUCT().getShopprodno())).header("Host", "kapi.kakao.com").header("Authorization", "KakaoAK b99a474fd6fe27f966e76e37591f0053").header("Target-Authorization", "KakaoAK " + dto.getSHOPINFO().getAPIKEY()).header("channel_ids", "101").header("Content-Type", "application/json;charset=UTF-8").method(Connection.Method.GET).ignoreContentType(true).followRedirects(true).ignoreHttpErrors(true).execute();
            String body = response.body();
            JsonObject data2 = jsonParser.parse(body).getAsJsonObject();
            ArrayList<KakaoStoreCombinations> combinations = new ArrayList<KakaoStoreCombinations>();
            JsonArray combinationsArr = data2.get("combinations").getAsJsonArray();
            int i = 0;
            while (i < combinationsArr.size()) {
                JsonObject combinationsObj = combinationsArr.get(i).getAsJsonObject();
                ArrayList<KakaoStoreName> names = new ArrayList<KakaoStoreName>();
                JsonArray nameArr = combinationsObj.get("name").getAsJsonArray();
                int j = 0;
                while (j < nameArr.size()) {
                    JsonObject nameObj = nameArr.get(j).getAsJsonObject();
                    KakaoStoreName name = new KakaoStoreName();
                    name.setKey(nameObj.get("key").getAsString());
                    name.setValue(nameObj.get("value").getAsString());
                    names.add(name);
                    ++j;
                }
                ProductOptionDTO filter = soldoutOptions.stream().filter(p -> Long.parseLong(p.getSHOPPRODSKU()) == combinationsObj.get("id").getAsLong()).findFirst().orElse(null);
                KakaoStoreCombinations combination = new KakaoStoreCombinations();
                combination.setUsable(combinationsObj.get("usable").getAsBoolean());
                combination.setName(names);
                combination.setPrice(combinationsObj.get("price").getAsBigDecimal());
                combination.setStockQuantity(filter == null ? combinationsObj.get("stockQuantity").getAsInt() : 0);
                combination.setManagedCode(combinationsObj.get("managedCode").getAsString());
                combinations.add(combination);
                ++i;
            }
            ArrayList<KakaoStoreCombinationAttributes> combinationAttributes = new ArrayList<KakaoStoreCombinationAttributes>();
            JsonArray combinationAttributesArr = data2.get("combinationAttributes").getAsJsonArray();
            int i2 = 0;
            while (i2 < combinationAttributesArr.size()) {
                JsonObject combinationAttributesObj = combinationAttributesArr.get(i2).getAsJsonObject();
                KakaoStoreCombinationAttributes combinationAttribute = new KakaoStoreCombinationAttributes();
                combinationAttribute.setName(combinationAttributesObj.get("name").getAsString());
                combinationAttribute.setValue(combinationAttributesObj.get("value").getAsString());
                combinationAttributes.add(combinationAttribute);
                ++i2;
            }
            KakaoStoreOption option2 = new KakaoStoreOption();
            option2.setType(data2.get("type").getAsString());
            option2.setCombinations(combinations);
            option2.setCombinationAttributes(combinationAttributes);
            KakaoStoreUpdateOptionRequest result = new KakaoStoreUpdateOptionRequest();
            result.setOption(option2);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean modifyProductStatusDto(ProductDTO shopProductDto, ShopProductAdditionDto dtllist, ShoppingmallDTO shoppingMallDetailDto, String status2, ShopProductSendDto shopProductSendDto, Map<String, String> loginCookies) throws Exception {
        return true;
    }

    @Override
    public boolean isExistProdNo(ProductDTO dto, ShoppingmallDTO shoppingMallDetailDto, Map<String, String> cookies) throws Exception {
        return false;
    }

    @Override
    public boolean deleteProduct(ProductDTO shopProductDto) throws Exception {
        return false;
    }

    private void logProductInDetail(String shopInfoLog, ProductDTO prodInfo, String action, ShoppingmallDTO shoppingmallDTO, String jobResult, String jobType, String logMsg) {
        String comment = String.format(" %s [%s]\n \u2192 \uc0c1\ud488\uc744 \uc1fc\ud551\ubab0\uc5d0\uc11c %s \ucc98\ub9ac\ud588\uc2b5\ub2c8\ub2e4.", shopInfoLog, prodInfo.getCompayny_goods_cd(), action);
        CommonProgressDialog.get().setValueBackProd(comment, 50, prodInfo, shoppingmallDTO, jobType, jobResult, logMsg, true);
    }
}

