/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.shop.common;

import com.kdjsystem.mlink.yellim.common.YDMASessonUtil;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.data.dao.DBCPInit;
import com.kdjsystem.mlink.yellim.shop.common.CodeItem;
import com.kdjsystem.mlink.yellim.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopOrderMstDtoList;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.swt.graphics.Color;
import org.eclipse.wb.swt.SWTResourceManager;

public class WorkStatus {
    public static final String WEB_DRIVER_ID = "webdriver.chrome.driver";
    public static final String WEB_DRIVER_PATH = YDMASessonUtil.getAppPath() + "\\YDwmsData\\chromedriver.exe";
    public static final String \ub300\uae30 = "W01";
    public static final String \ucde8\uc18c = "W02";
    public static final String \uc9c4\ud589\uc911 = "W03";
    public static final String \uc624\ub958 = "W04";
    public static final String \uc2e4\ud328 = "W05";
    public static final String \uc644\ub8cc = "W06";
    public static final String \uc804\uccb4 = "W07";
    public static final String \ucc98\ub9ac\uc911 = "W08";
    public static final String \uc0c1\ud488\ub4f1\ub85d = "100";
    public static final String \uc0c1\ud488\uc218\uc815 = "200";
    public static final String \uc8fc\ubb38\uc218\uc9d1 = "300";
    public static final String \ubb38\uc758\uc218\uc9d1 = "400";
    public static final String \uc0c1\ud488\ud488\uc808 = "500";
    public static final String \uc0c1\ud488\uc0ad\uc81c = "600";
    public static final String \uc870\ud68c = "1000";
    public static final String \uc800\uc7a5 = "2000";
    public static final String \uc5c5\ub370\uc774\ud2b8 = "3000";
    public static final String \ub370\uc774\ud0c0\uc5c6\uc74c = "0";
    public static final String \uc5d0\ub7ec\ubc1c\uc0dd = "-1";
    public static final String \uc815\uc0c1\ucc98\ub9ac = "1";
    String result = "";
    private static WorkStatus instance = new WorkStatus();
    private List<OrderCodeMapperDto> items = new ArrayList<OrderCodeMapperDto>();

    private WorkStatus() {
    }

    public static WorkStatus getInstance() {
        if (WorkStatus.instance.items.size() == 0) {
            instance.bind();
        }
        return instance;
    }

    public Color workfindColor(String code) {
        Color bgColor = null;
        switch (code) {
            case "W01": {
                bgColor = SWTResourceManager.getColor(255, 251, 234);
                break;
            }
            case "W02": {
                bgColor = SWTResourceManager.getColor(255, 248, 191);
                break;
            }
            case "W03": {
                bgColor = SWTResourceManager.getColor(255, 255, 0);
                break;
            }
            case "W04": {
                bgColor = SWTResourceManager.getColor(255, 177, 177);
                break;
            }
            case "W05": {
                bgColor = SWTResourceManager.getColor(255, 4, 4);
                break;
            }
            case "W06": {
                bgColor = SWTResourceManager.getColor(246, 246, 246);
                break;
            }
            case "W07": {
                bgColor = SWTResourceManager.getColor(255, 255, 255);
                break;
            }
            default: {
                bgColor = SWTResourceManager.getColor(255, 255, 0);
            }
        }
        return bgColor;
    }

    public String findCode(String code) {
        String result = "";
        switch (code) {
            case "W01": {
                result = "\ub300\uae30";
                break;
            }
            case "W02": {
                result = "\ucde8\uc18c";
                break;
            }
            case "W03": {
                result = "\uc9c4\ud589\uc911";
                break;
            }
            case "W04": {
                result = "\uc624\ub958";
                break;
            }
            case "W08": {
                result = "\ucc98\ub9ac\uc911";
                break;
            }
            case "W05": {
                result = "\uc2e4\ud328";
                break;
            }
            case "W06": {
                result = "\uc644\ub8cc";
                break;
            }
            case "100": {
                result = "\uc0c1\ud488\ub4f1\ub85d";
                break;
            }
            case "300": {
                result = "\uc8fc\ubb38\uc218\uc9d1";
                break;
            }
            case "200": {
                result = "\uc0c1\ud488\uc218\uc815";
                break;
            }
            case "500": {
                result = "\uc0c1\ud488\ud488\uc808";
                break;
            }
            case "600": {
                result = "\uc0c1\ud488\uc0ad\uc81c";
                break;
            }
            case "400": {
                result = "\ubb38\uc758\uc218\uc9d1";
                break;
            }
            default: {
                result = "";
            }
        }
        return result;
    }

    public CodeItem findCode(String shopcd, String mall_code) {
        CodeItem item = new CodeItem();
        OrderCodeMapperDto dto = (OrderCodeMapperDto)this.items.stream().filter(p -> p.getShopid().equals(shopcd) && p.mall_code.equals(mall_code)).collect(Collectors.toList()).get(0);
        item.setCode(dto.code);
        item.setName(dto.getName());
        return item;
    }

    public String findCodeString(String shopcd, String mall_code) {
        String result = "";
        for (OrderCodeMapperDto dto : this.items) {
            if (!dto.getShopid().equals(shopcd) || !dto.getMall_code().trim().equals(mall_code)) continue;
            result = dto.getCode();
            break;
        }
        if (result == "") {
            result = mall_code;
        }
        return result;
    }

    public void setStatusShopMst(String code, ShopOrderMstDtoList list) {
        for (ShopOrderMstDto dto : list.getList()) {
            dto.setOrder_status(code);
        }
    }

    public void setMappingStatusShopMst(String shopID, ShopOrderMstDtoList list) {
        for (ShopOrderMstDto dto : list.getList()) {
            String code = this.findCodeString(shopID, dto.getOrder_status());
            dto.setOrder_status(code);
        }
    }

    public WorkStatus bind() {
        this.items.clear();
        this.setCodeMapper();
        return this;
    }

    public void setCodeMapper() {
        block12: {
            Connection connection = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    StringBuffer sql = new StringBuffer();
                    sql.append(" SELECT \r\n");
                    sql.append("IFNULL(SHOPID,  '' ) AS SHOPID,  \r\n");
                    sql.append("IFNULL(CODE,  '' ) AS CODE,  \r\n");
                    sql.append("IFNULL(MALL_CODE,  '' ) AS MALL_CODE,  \r\n");
                    sql.append("IFNULL(NAME,  '' ) AS NAME  \r\n");
                    sql.append(" FROM shopordstatus  \r\n");
                    pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                    YDMAStringUtil.Print("[ShopOrderStatus]" + pstmt.toString());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        OrderCodeMapperDto dto = new OrderCodeMapperDto();
                        dto.setShopid(rs.getString("SHOPID"));
                        dto.setCode(rs.getString("CODE"));
                        dto.setMall_code(rs.getString("MALL_CODE"));
                        dto.setName(rs.getString("NAME"));
                        this.items.add(dto);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    try {
                        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class OrderCodeMapperDto {
        private String shopid;
        private String code;
        private String name;
        private String mall_code;

        OrderCodeMapperDto() {
        }

        public String getShopid() {
            return this.shopid;
        }

        public void setShopid(String shopid) {
            this.shopid = shopid;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getMall_code() {
            return this.mall_code;
        }

        public void setMall_code(String mall_code) {
            this.mall_code = mall_code;
        }

        public WorkStatus getInstance() {
            return instance;
        }
    }
}

