/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.shop.dao;

import com.kdjsystem.mlink.yellim.common.YDMASessonUtil;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.common.YDMATimeUtil;
import com.kdjsystem.mlink.yellim.data.dao.DBCPInit;
import com.kdjsystem.mlink.yellim.dto.ProductDTO;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductOptionDto;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;

public class ShopOptionProductInfoDao {
    private static ShopOptionProductInfoDao instance = new ShopOptionProductInfoDao();

    public static ShopOptionProductInfoDao get() {
        return instance;
    }

    public List<ShopProductOptionDto> getShopOptProdInfoListByProdseq(String prodseq) throws Exception {
        ArrayList<ShopProductOptionDto> list = new ArrayList<ShopProductOptionDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT ifnull(PRODSEQ,''),ifnull(SKUSEQ,0),COMPNO,ifnull(PRODCD,''),ifnull(OPTPRODCD,''),ifnull(OPTPRODNM,''),ifnull(OPTSPECDES,''),ifnull(OPTEA,'0'), ifnull(OPTSALE,''),ifnull(OPTSALEOUT,''),ifnull(OPTNOTUSE,''),ifnull(OPTSAFESTOCK,''),ifnull(OPTVERTSTOCK,'0'),ifnull(OPTADDAMT,'0'),ifnull(OPTDELYN,''), ifnull(BARCODE,''), ifnull(LIMIT_PRICE,'0')   FROM Shop_OptProdInfo  WHERE prodseq = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, prodseq);
                rs = pstmt.executeQuery();
                int idx = 0;
                while (rs.next()) {
                    int rowIdx = 0;
                    ShopProductOptionDto dto = new ShopProductOptionDto();
                    dto.setRow("" + ++idx);
                    dto.setProdseq(Integer.parseInt(rs.getString(++rowIdx)));
                    dto.setSkuseq(Integer.parseInt(rs.getString(++rowIdx)));
                    dto.setCompno(Integer.parseInt(rs.getString(++rowIdx)));
                    dto.setProdcd(rs.getString(++rowIdx));
                    dto.setOptprodcd(rs.getString(++rowIdx));
                    dto.setOptprodnm(rs.getString(++rowIdx));
                    dto.setOptspecdes(rs.getString(++rowIdx));
                    dto.setOptea(Integer.parseInt(rs.getString(++rowIdx)));
                    dto.setOptsale(rs.getString(++rowIdx));
                    dto.setOptsaleout(rs.getString(++rowIdx));
                    dto.setOptnotuse(rs.getString(++rowIdx));
                    dto.setOptsafestock(rs.getString(++rowIdx));
                    dto.setOptvertstock(rs.getString(++rowIdx));
                    dto.setOptaddamt(Integer.parseInt(rs.getString(++rowIdx)));
                    dto.setOptdelyn(rs.getString(++rowIdx));
                    dto.setBarcode(rs.getString(++rowIdx));
                    dto.setLimit_price(rs.getString(++rowIdx));
                    list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public String getProductseq(String productid) throws Exception {
        String prodseq = null;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT b.prodseq   FROM SHOPPRODIN b \t\t  join shopordmst a ON a.MALL_PRODUCT_ID = b.SHOPPRODNO  where a.MALL_PRODUCT_ID = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, productid);
                YDMAStringUtil.Print("[getShopOptProdInfoListByProdseq]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int rowIdx = 0;
                    prodseq = rs.getString(++rowIdx);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return prodseq;
    }

    public void setOptionProductInUpdate(List<ShopProductOptionDto> list) throws Exception {
        PreparedStatement pstmt = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        String sql = "update Shop_OptProdInfo \t  set OPTSPECDES=?, OPTEA=?, OPTSALE=?, OPTSALEOUT=?, \t\t  OPTNOTUSE = ?, OPTSAFESTOCK = ?, OPTVERTSTOCK = ?, OPTADDAMT = ?, \t\t  BARCODE = ?, MODIFYDT = ?, MODIFYID =?  where PRODSEQ= ?     and SKUSEQ = ?    and compno = ? ";
        sql = sql.toUpperCase();
        Connection connection = DBCPInit.getInstance().getConnection();
        pstmt = connection.prepareStatement(sql);
        statementlist.add(pstmt);
        for (ShopProductOptionDto dto : list) {
            int i = 0;
            pstmt.setString(++i, dto.getOptprodnm());
            pstmt.setInt(++i, dto.getOptea());
            pstmt.setString(++i, dto.getOptsale());
            pstmt.setString(++i, dto.getOptsaleout());
            pstmt.setString(++i, dto.getOptnotuse());
            pstmt.setString(++i, dto.getOptsafestock().equals("") ? "0" : dto.getOptsafestock());
            pstmt.setString(++i, dto.getOptvertstock().equals("") ? "0" : dto.getOptvertstock());
            pstmt.setInt(++i, dto.getOptaddamt());
            pstmt.setString(++i, dto.getBarcode());
            pstmt.setString(++i, YDMATimeUtil.getCurrentTimeByYDFormat());
            pstmt.setString(++i, YDMASessonUtil.getUserInfo().getUsernam());
            pstmt.setInt(++i, dto.getProdseq());
            pstmt.setInt(++i, dto.getSkuseq());
            pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
            YDMAStringUtil.Print("[setOptionProductInUpdate]" + pstmt.toString());
            pstmt.addBatch();
            pstmt.clearParameters();
        }
        pstmt.executeBatch();
        pstmt.clearBatch();
    }

    public List<ShopProductOptionDto> getProdOption(ProductDTO dto) throws Exception {
        List<ShopProductOptionDto> result = new ArrayList<ShopProductOptionDto>();
        BeanListHandler handler = new BeanListHandler(ShopProductOptionDto.class);
        QueryRunner run = new QueryRunner();
        try (Connection connection = DBCPInit.getInstance().getConnection();){
            try {
                StringBuilder sql = new StringBuilder();
                sql.append("SELECT * FROM shop_optprodinfo ");
                sql.append("WHERE PRODSEQ=" + dto.getPRODSEQ() + " ");
                sql.append("AND COMPNO=" + Integer.parseInt(dto.getCompno()));
                result = (List)run.query(connection, sql.toString(), (ResultSetHandler)handler);
            }
            catch (Exception e) {
                e.printStackTrace();
                connection.close();
            }
        }
        return result;
    }
}

