/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.shop.dao;

import com.kdjsystem.mlink.yellim.common.YDMASessonUtil;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.common.YDMATimeUtil;
import com.kdjsystem.mlink.yellim.data.dao.DBCPInit;
import com.kdjsystem.mlink.yellim.data.dao.QuestListDto;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

public class ShopQuestionDao {
    private static ShopQuestionDao daoInstance = new ShopQuestionDao();

    private ShopQuestionDao() {
    }

    public static ShopQuestionDao get() {
        return daoInstance;
    }

    private String getSqlSave() {
        String sb = " insert into qnalist(qnaseq, compno,qnastat, shopnm, shopid, shopseq, regdm, MPRODID, prodnm, subject, quests, insnm,insdm, qgubun,ordid,senddt,prodid,answs,stat,infono,GOODCD,insnm2,ANSWSTITLE,insertdt,insertid,upddm,ANSNO, sno, secret)  values(?, ?, ?, ? ,? ,? ,? ,? ,? ,? , ?, ?, ? , ?, ?, ?, ?, ?, ?, ?, ?, ?, ? , ?, ?, ?, ?, ?, ?)";
        return sb;
    }

    public void SaveOrUpdate(List<QuestListDto> list) throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                String sqlUpdate = " update qnalist set qnastat = ?, shopid = ?, mprodid = ?, prodnm = ?, subject = ?, quests = ?, insnm = ? ,insdm = ?, qgubun = ?,ordid =?, senddt=?,prodid=?, stat = ?, infono = ?, GOODCD = ?, insnm2 = ?, ANSWSTITLE = ?, ANSWS = ?, modifydt = ? , modifyid = ? , ANSNO = ?, sno = ? , secret = ? where compno = ? and qnaseq = ? and shopnm = ? ";
                sqlUpdate = sqlUpdate.toUpperCase();
                connection.prepareStatement(sqlUpdate);
                PreparedStatement pstmtUpdate = connection.prepareStatement(sqlUpdate.toUpperCase());
                PreparedStatement pstmtSave = connection.prepareStatement(this.getSqlSave().toUpperCase());
                statementlist.add(pstmtUpdate);
                statementlist.add(pstmtSave);
                boolean isSave = false;
                boolean isUpdate = false;
                for (QuestListDto dto : list) {
                    int isExits = this.isShopQuestionExits(dto.getQnaseq(), dto.getShopnm());
                    String qnaStat = this.isShopQuestionExits1(dto.getQnaseq(), dto.getShopnm());
                    String qunstat = list.get(0).getQnastat().toString();
                    if (isExits > 0) {
                        isUpdate = true;
                        isSave = false;
                        if (qnaStat.equals("100") || qunstat.equals("100")) {
                            this.Update(dto, connection, statementlist, pstmtUpdate);
                        } else if (qnaStat.equals("101") && !dto.getQnastat().equals("100")) {
                            this.Update(dto, connection, statementlist, pstmtUpdate);
                        }
                    } else {
                        isSave = true;
                        isUpdate = false;
                        String companyGoodsCd = this.getGoodcompanyCd(dto.getMprodid(), dto.getShopnm());
                        if (companyGoodsCd.length() == 0) {
                            dto.setProdid(this.prodordermatch(dto.getMprodid()) == null ? "" : this.prodordermatch(dto.getMprodid()));
                        } else {
                            dto.setProdid(companyGoodsCd);
                        }
                        this.Save(dto, connection, statementlist, pstmtSave);
                    }
                    if (isUpdate) {
                        pstmtUpdate.executeBatch();
                        pstmtUpdate.clearBatch();
                    }
                    if (!isSave) continue;
                    pstmtSave.executeBatch();
                    pstmtSave.clearBatch();
                }
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public int isShopQuestionExits(String qnaseq, String shopcd) {
        int result;
        block12: {
            result = 0;
            Connection connection = null;
            PreparedStatement pstmt_orddtl = null;
            ResultSet rs = null;
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql_orddtl = "SELECT COUNT(qnaseq) AS CNT FROM qnalist WHERE COMPNO= ? AND qnaseq = ? and shopnm = ? ";
                    sql_orddtl = sql_orddtl.toUpperCase();
                    pstmt_orddtl = connection.prepareStatement(sql_orddtl);
                    pstmt_orddtl.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt_orddtl.setString(2, qnaseq == null ? "" : qnaseq);
                    pstmt_orddtl.setString(3, shopcd);
                    pstmt_orddtl.toString();
                    rs = pstmt_orddtl.executeQuery();
                    while (rs.next()) {
                        result = rs.getInt("CNT");
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    try {
                        DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private PreparedStatement Update(QuestListDto dto, Connection connection, List<PreparedStatement> statementlist, PreparedStatement pstmt) throws Exception {
        int i = 0;
        pstmt.setString(++i, dto.getQnastat());
        pstmt.setString(++i, dto.getShopid());
        pstmt.setString(++i, dto.getMprodid() == null ? "" : dto.getMprodid());
        pstmt.setString(++i, dto.getProdnm());
        pstmt.setString(++i, dto.getSubject() == null ? "" : (dto.getSubject().length() > 400 ? dto.getSubject().substring(0, 399) : dto.getSubject()));
        pstmt.setString(++i, dto.getQuests());
        pstmt.setString(++i, dto.getInsnm());
        pstmt.setString(++i, this.splitMark(dto.getInsdm()).substring(0, 8));
        pstmt.setString(++i, dto.getQgubun());
        pstmt.setString(++i, dto.getOrdid() == null ? "" : dto.getOrdid());
        pstmt.setString(++i, dto.getSenddt() == null ? "" : this.splitMark(dto.getSenddt()));
        pstmt.setString(++i, dto.getProdid() == null ? "" : dto.getProdid());
        pstmt.setString(++i, dto.getStat() == null ? "" : dto.getStat());
        pstmt.setString(++i, dto.getInfono() == null ? "" : dto.getInfono());
        pstmt.setString(++i, dto.getGoodcd() == null ? "" : dto.getGoodcd());
        pstmt.setString(++i, dto.getInsnm2() == null ? "" : dto.getInsnm2());
        pstmt.setString(++i, dto.getAnswstitle() == null ? "" : dto.getAnswstitle());
        pstmt.setString(++i, dto.getAnsws() == null ? "" : dto.getAnsws());
        pstmt.setString(++i, YDMATimeUtil.getCurrentTime());
        pstmt.setString(++i, YDMASessonUtil.getUserInfo().getUsernam());
        pstmt.setString(++i, dto.getAnsno());
        pstmt.setString(++i, dto.getSno());
        pstmt.setString(++i, dto.getSecret());
        pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
        pstmt.setString(++i, dto.getQnaseq());
        pstmt.setString(++i, dto.getShopnm());
        pstmt.addBatch();
        pstmt.clearParameters();
        return pstmt;
    }

    private PreparedStatement Save(QuestListDto dto, Connection connection, List<PreparedStatement> statementlist, PreparedStatement pstmt) throws Exception {
        int i = 0;
        pstmt.setString(++i, dto.getQnaseq() == null ? "" : dto.getQnaseq());
        pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
        pstmt.setString(++i, dto.getQnastat());
        pstmt.setString(++i, dto.getShopnm());
        pstmt.setString(++i, dto.getShopid());
        pstmt.setString(++i, dto.getShopseq());
        pstmt.setString(++i, dto.getRegdm());
        pstmt.setString(++i, dto.getMprodid() == null ? "" : dto.getMprodid());
        pstmt.setString(++i, dto.getProdnm());
        pstmt.setString(++i, dto.getSubject() == null ? "" : (dto.getSubject().length() > 400 ? dto.getSubject().substring(0, 399) : dto.getSubject()));
        pstmt.setString(++i, dto.getQuests());
        pstmt.setString(++i, dto.getInsnm());
        pstmt.setString(++i, dto.getInsdm().length() == 0 ? "" : this.splitMark(dto.getInsdm()).substring(0, 8));
        pstmt.setString(++i, dto.getQgubun());
        pstmt.setString(++i, dto.getOrdid() == null ? "" : dto.getOrdid());
        pstmt.setString(++i, dto.getSenddt() == null ? "" : this.splitMark(dto.getSenddt()));
        pstmt.setString(++i, dto.getProdid() == null ? "" : dto.getProdid());
        pstmt.setString(++i, dto.getAnsws() == null ? "" : dto.getAnsws());
        pstmt.setString(++i, dto.getStat() == null ? "" : dto.getStat());
        pstmt.setString(++i, dto.getInfono() == null ? "" : dto.getInfono());
        pstmt.setString(++i, dto.getGoodcd() == null ? "" : dto.getGoodcd());
        pstmt.setString(++i, dto.getInsnm2() == null ? "" : dto.getInsnm2());
        pstmt.setString(++i, dto.getAnswstitle() == null ? "" : dto.getAnswstitle());
        pstmt.setString(++i, YDMATimeUtil.getCurrentTime());
        pstmt.setString(++i, YDMASessonUtil.getUserInfo().getUsernam());
        pstmt.setString(++i, dto.getUpddm());
        pstmt.setString(++i, dto.getAnsno());
        pstmt.setString(++i, dto.getSno());
        pstmt.setString(++i, dto.getSecret());
        pstmt.addBatch();
        pstmt.clearParameters();
        return pstmt;
    }

    public String splitMark(String text) {
        String[] split = text.split("-| |:|\\.|/");
        Object complite = "";
        int j = 0;
        while (j < split.length) {
            complite = (String)complite + split[j];
            complite = ((String)complite).trim();
            ++j;
        }
        return complite;
    }

    public void SenddtUpdate(List<QuestListDto> list) throws Exception {
        block6: {
            Connection connection = null;
            PreparedStatement pstmt = null;
            ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sqlinsert = " update qnalist set qnastat = ?, senddt = ? where qnaseq = ? and compno = ? ";
                    sqlinsert = sqlinsert.toUpperCase();
                    pstmt = connection.prepareStatement(sqlinsert);
                    statementlist.add(pstmt);
                    for (QuestListDto dto : list) {
                        int i = 0;
                        pstmt.setString(++i, "103");
                        pstmt.setString(++i, dto.getSenddt());
                        pstmt.setString(++i, dto.getQnaseq());
                        pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                        pstmt.addBatch();
                        pstmt.clearParameters();
                    }
                    YDMAStringUtil.Print("[ShopQuestionListSave]" + pstmt.toString());
                    pstmt.executeBatch();
                    pstmt.clearParameters();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    DBCPInit.getInstance().freeConnection(connection, pstmt, null);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, pstmt, null);
                throw throwable;
            }
            DBCPInit.getInstance().freeConnection(connection, pstmt, null);
        }
    }

    public void statsUpdate(List<QuestListDto> list) throws Exception {
        block6: {
            Connection connection = null;
            PreparedStatement pstmt = null;
            ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sqlinsert = " update qnalist set qnastat = ?, oldstat = ? where qnaseq = ? and compno = ? ";
                    sqlinsert = sqlinsert.toUpperCase();
                    pstmt = connection.prepareStatement(sqlinsert);
                    statementlist.add(pstmt);
                    for (QuestListDto dto : list) {
                        int i = 0;
                        pstmt.setString(++i, dto.getQnastat());
                        pstmt.setString(++i, dto.getOldstat());
                        pstmt.setString(++i, dto.getQnaseq());
                        pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                        pstmt.addBatch();
                        pstmt.clearParameters();
                    }
                    YDMAStringUtil.Print("[statsUpdate]" + pstmt.toString());
                    pstmt.executeBatch();
                    pstmt.clearParameters();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    DBCPInit.getInstance().freeConnection(connection, pstmt, null);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, pstmt, null);
                throw throwable;
            }
            DBCPInit.getInstance().freeConnection(connection, pstmt, null);
        }
    }

    public List<QuestListDto> QuestionAnswer(String startdt, String enddt, String opt) throws Exception {
        ArrayList<QuestListDto> contents = new ArrayList<QuestListDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                if (opt.equals("INSDM")) {
                    startdt = startdt.substring(0, 8);
                    enddt = enddt.substring(0, 8);
                }
                Object sql = " SELECT IFNULL(a.shopnm,''), IFNULL(a.regdm,''), IFNULL(a.mprodid,''), IFNULL(a.PRODNM,''), IFNULL(a.subject,''), IFNULL(a.quests,''), IFNULL(a.insnm,''), IFNULL(a.insdm,''), IFNULL(a.senddt,''),IFNULL(a.qgubun,''),IFNULL(a.answs,''),IFNULL(b.PASSWORD,''), IFNULL(b.APIKEY,''),ifnull(a.shopid,''),a.qnaseq,ifnull(a.prodid,''),ifnull(a.qnastat,''),  ifnull(a.oldstat,''),  ifnull(a.answstitle,''), ifnull(a.stat,'') , ifnull(a.infono,''), ifnull(a.GOODCD,''),ifnull(b.shopseq,''), ifnull(a.ansno,''), ifnull(a.sno,''), ifnull(a.secret,'') from qnalist a LEFT JOIN shopdtl  B  ON a.COMPNO = b.COMPNO AND " + String.format(" a.shopnm = b.SHOPCD AND a.SHOPSEQ = b.SHOPSEQ WHERE  a.COMPNO = ? and A.%s between ? and ? and a.qnastat = ? ", opt);
                sql = ((String)sql).toUpperCase();
                pstmt = connection.prepareStatement((String)sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, startdt);
                pstmt.setString(3, enddt);
                pstmt.setString(4, "101");
                YDMAStringUtil.Print("[QuestionAnswer]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    QuestListDto dto = new QuestListDto();
                    int columnIndex = 0;
                    dto.setShopnm(rs.getString(++columnIndex));
                    dto.setRegdm(rs.getString(++columnIndex));
                    dto.setMprodid(rs.getString(++columnIndex));
                    dto.setProdnm(rs.getString(++columnIndex));
                    dto.setSubject(rs.getString(++columnIndex));
                    dto.setQuests(rs.getString(++columnIndex));
                    dto.setInsnm(rs.getString(++columnIndex));
                    dto.setInsdm(rs.getString(++columnIndex));
                    dto.setSenddt(rs.getString(++columnIndex));
                    dto.setQgubun(rs.getString(++columnIndex));
                    dto.setAnsws(rs.getString(++columnIndex));
                    dto.setShopPw(rs.getString(++columnIndex));
                    dto.setApikey(rs.getString(++columnIndex));
                    dto.setShopid(rs.getString(++columnIndex));
                    dto.setQnaseq(rs.getString(++columnIndex));
                    dto.setProdid(rs.getString(++columnIndex));
                    dto.setQnastat(rs.getString(++columnIndex));
                    dto.setOldstat(rs.getString(++columnIndex));
                    dto.setAnswstitle(rs.getString(++columnIndex));
                    dto.setStat(rs.getString(++columnIndex));
                    dto.setInfono(rs.getString(++columnIndex));
                    dto.setGoodcd(rs.getString(++columnIndex));
                    dto.setShopseq(rs.getString(++columnIndex));
                    dto.setAnsno(rs.getString(++columnIndex));
                    dto.setSno(rs.getString(++columnIndex));
                    dto.setSecret(rs.getString(++columnIndex));
                    contents.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public void qnaTemplateSave(String temptitle, String tempansws) throws Exception {
        block5: {
            Connection connection = null;
            PreparedStatement pstmt = null;
            ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql = "insert into qnatemp(compno,TEMPTITLE,TEMPANSWS)  values( ?, ?, ?) ";
                    sql = sql.toUpperCase();
                    pstmt = connection.prepareStatement(sql);
                    statementlist.add(pstmt);
                    int i = 0;
                    pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setString(++i, temptitle);
                    pstmt.setString(++i, tempansws);
                    pstmt.executeUpdate();
                    YDMAStringUtil.Print("[qnaTemplateSave]" + pstmt.toString());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    DBCPInit.getInstance().freeConnection(connection, pstmt, null);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, pstmt, null);
                throw throwable;
            }
            DBCPInit.getInstance().freeConnection(connection, pstmt, null);
        }
    }

    public List<QuestListDto> getTemplateList() throws Exception {
        ArrayList<QuestListDto> contents = new ArrayList<QuestListDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = " SELECT ifnull(TEMPSEQ,'0'), IFNULL(TEMPTITLE,''), IFNULL(TEMPANSWS,'')  from qnatemp where compno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[getTemplateList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    QuestListDto dto = new QuestListDto();
                    int columnIndex = 0;
                    dto.setTempseq(rs.getString(++columnIndex));
                    dto.setTemptitle(rs.getString(++columnIndex));
                    dto.setTempansws(rs.getString(++columnIndex));
                    contents.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public void qnaTemplateUpdate(String temptitle, String tempansws, List<QuestListDto> content) throws Exception {
        block6: {
            Connection connection = null;
            PreparedStatement pstmt = null;
            ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sqlinsert = " update qnatemp set TEMPTITLE = ?, TEMPANSWS = ? where TEMPSEQ = ? ";
                    sqlinsert = sqlinsert.toUpperCase();
                    pstmt = connection.prepareStatement(sqlinsert);
                    statementlist.add(pstmt);
                    for (QuestListDto dto : content) {
                        int i = 0;
                        pstmt.setString(++i, temptitle);
                        pstmt.setString(++i, tempansws);
                        pstmt.setString(++i, dto.getTempseq());
                        pstmt.addBatch();
                        pstmt.clearParameters();
                    }
                    YDMAStringUtil.Print("[qnaTemplateUpdate]" + pstmt.toString());
                    pstmt.executeBatch();
                    pstmt.clearParameters();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    DBCPInit.getInstance().freeConnection(connection, pstmt, null);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, pstmt, null);
                throw throwable;
            }
            DBCPInit.getInstance().freeConnection(connection, pstmt, null);
        }
    }

    public void templateDelete(List<QuestListDto> content) throws Exception {
        block6: {
            Connection connection = null;
            PreparedStatement pstmt = null;
            ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sqlinsert = " delete from qnatemp where tempseq = ? ";
                    sqlinsert = sqlinsert.toUpperCase();
                    pstmt = connection.prepareStatement(sqlinsert);
                    statementlist.add(pstmt);
                    for (QuestListDto dto : content) {
                        int i = 0;
                        pstmt.setString(++i, dto.getTempseq());
                        pstmt.addBatch();
                        pstmt.clearParameters();
                    }
                    YDMAStringUtil.Print("[ShopQuestionListSave]" + pstmt.toString());
                    pstmt.executeBatch();
                    pstmt.clearParameters();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    DBCPInit.getInstance().freeConnection(connection, pstmt, null);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, pstmt, null);
                throw throwable;
            }
            DBCPInit.getInstance().freeConnection(connection, pstmt, null);
        }
    }

    public String isShopQuestionExits1(String qnaseq, String shopcd) {
        String result;
        block12: {
            result = "";
            Connection connection = null;
            PreparedStatement pstmt_orddtl = null;
            ResultSet rs = null;
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql_orddtl = "SELECT QNASTAT AS CNT FROM qnalist WHERE COMPNO= ? AND qnaseq = ? and shopnm = ? ";
                    sql_orddtl = sql_orddtl.toUpperCase();
                    pstmt_orddtl = connection.prepareStatement(sql_orddtl);
                    pstmt_orddtl.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt_orddtl.setString(2, qnaseq == null ? "" : qnaseq);
                    pstmt_orddtl.setString(3, shopcd);
                    rs = pstmt_orddtl.executeQuery();
                    while (rs.next()) {
                        result = rs.getString("CNT");
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    try {
                        DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public String getGoodcompanyCd(String shopprodno, String shopcd) {
        String result;
        block12: {
            result = "";
            Connection connection = null;
            PreparedStatement pstmt_orddtl = null;
            ResultSet rs = null;
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql_orddtl = "SELECT COMPAYNY_GOODS_CD AS GOODSCD FROM shopprodin WHERE COMPNO= ? AND shopprodno = ? and shopcd = ? ";
                    sql_orddtl = sql_orddtl.toUpperCase();
                    pstmt_orddtl = connection.prepareStatement(sql_orddtl);
                    pstmt_orddtl.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt_orddtl.setString(2, shopprodno);
                    pstmt_orddtl.setString(3, shopcd);
                    rs = pstmt_orddtl.executeQuery();
                    while (rs.next()) {
                        result = rs.getString("GOODSCD");
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    try {
                        DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private String prodordermatch(String shopprodno) throws Exception {
        String value = "";
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select ifnull(compayny_goods_cd,'') from shopprodinfo as a join shop_matprodinfo as b on a.prodseq = b.prodseq   where b.shopprodno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, shopprodno);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    value = rs.getString(++columnIndex);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return value;
    }
}

