/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.shop.data.alwayz;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.jogamp.common.util.InterruptSource;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.dto.PreferencesMallDTO;
import com.kdjsystem.mlink.yellim.dto.ProductDTO;
import com.kdjsystem.mlink.yellim.dto.ShoppingmallDTO;
import com.kdjsystem.mlink.yellim.shop.common.IProduct;
import com.kdjsystem.mlink.yellim.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.yellim.shop.common.MarketPriceCalc;
import com.kdjsystem.mlink.yellim.shop.common.ResultMarketPrice;
import com.kdjsystem.mlink.yellim.shop.common.ShopCommon;
import com.kdjsystem.mlink.yellim.shop.common.ShopWorkDataQueue;
import com.kdjsystem.mlink.yellim.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.yellim.shop.dao.ShopOptionDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductAlwayzAdditionDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductSendDto;
import com.kdjsystem.mlink.yellim.shop.dao.WorkMngDao;
import com.kdjsystem.mlink.yellim.shop.dao.WorkMngDetailDto;
import com.kdjsystem.mlink.yellim.shop.dao.WorkMngDto;
import com.kdjsystem.mlink.yellim.shop.data.alwayz.AlwayzExitsProductCd;
import java.io.File;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class AlwayzProductRegService
implements IProduct {
    @Override
    public synchronized ShopProductSendDto excute(ShopProductSendDto sendProdList) throws Exception {
        ShopProductAlwayzAdditionDto dtllist = (ShopProductAlwayzAdditionDto)sendProdList.getProductAdditionDto();
        ShoppingmallDTO shoppingMallDetailDto = sendProdList.getShoppingmallDTO();
        List<ProductDTO> prodList = sendProdList.getShopProductDto();
        WorkMngDto workMngDto = sendProdList.getWorkMngDto();
        String uuid = sendProdList.getWorkgrp();
        if (!ShopWorkDataQueue.get().isExistGrp(uuid)) {
            workMngDto.setWork_status("W02");
            WorkMngDao.get().saveMst(uuid, sendProdList.getWorkMngDto());
            return sendProdList;
        }
        try {
            String loginID = shoppingMallDetailDto.getSHOPPINGID();
            String password = shoppingMallDetailDto.getPASSWORD();
            String shopcd = shoppingMallDetailDto.getSHOPCD();
            PreferencesMallDTO dto1 = ShopCommonDao.get().getSystemConf();
            int mod = dto1.getPROCCNT() / prodList.size();
            int progress = workMngDto.getProgress_rate();
            List<WorkMngDetailDto> workMngDetailDtos = workMngDto.getWork_detail();
            workMngDto.setWork_status("W06");
            WorkMngDao.get().saveMst(uuid, sendProdList.getWorkMngDto());
            for (ProductDTO dto : prodList) {
                workMngDto.setProgress_rate(progress += mod);
                workMngDto.setWork_status("W08");
                ShopWorkDataQueue.get().notifyObservers();
                WorkMngDetailDto workMngDetailDto = workMngDetailDtos.stream().filter(p -> p.getProdseq().equals(dto.getCompayny_goods_cd())).findAny().orElse(null);
                if (!ShopWorkDataQueue.get().isExistGrp(uuid)) {
                    workMngDetailDto.setStatus("W02");
                    workMngDetailDto.setMessage("\ucde8\uc18c \ucc98\ub9ac \ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                    WorkMngDao.get().saveDtl(uuid, workMngDetailDto);
                    continue;
                }
                if (workMngDetailDto.getStatus().equals("W06")) continue;
                if (workMngDto.getWork_status().equals("W02")) {
                    ShopProductSendDto shopProductSendDto = sendProdList;
                    return shopProductSendDto;
                }
                try {
                    try {
                        String forbiddenKeywords = shoppingMallDetailDto.getForbiddenKeywords();
                        ArrayList forbiddenKeywordList = forbiddenKeywords != null && !forbiddenKeywords.isEmpty() ? Arrays.asList(forbiddenKeywords.split(",")) : new ArrayList();
                        String productName = dto.getGoods_nm();
                        for (String keyword : forbiddenKeywordList) {
                            if (!productName.contains(keyword)) continue;
                            throw new Exception("\uc0c1\ud488\uba85\uc5d0 \uae08\uc9c0\ub41c \ud0a4\uc6cc\ub4dc\uac00 \ud3ec\ud568\ub418\uc5b4 \uc788\uc2b5\ub2c8\ub2e4: " + keyword);
                        }
                        String ProdNo = AlwayzExitsProductCd.get().getIsExistProdNo(dto.getCompayny_goods_cd(), loginID, password, shopcd);
                        if (!ProdNo.equals("")) {
                            workMngDto.setWork_status("-1");
                            workMngDetailDto.setStatus("-1");
                            workMngDetailDto.setMessage("\uc0c1\ud488\ub4f1\ub85d\uc2e4\ud328 : \ub9c8\ucf13\uc5d0 \uac19\uc740 \uc0c1\ud488\uc774  \uc874\uc7ac\ud558\uace0 \uc788\uc2b5\ub2c8\ub2e4. \uc0ad\uc81c\ud6c4\uc5d0 \uc7ac\ub4f1\ub85d\ud558\uc5ec \uc8fc\uc2dc\uae30 \ubc14\ub78d\ub2c8\ub2e4.");
                            dto.setResult_code("-1");
                            dto.setResult_text("\uc0c1\ud488\ub4f1\ub85d\uc2e4\ud328 : \ub9c8\ucf13\uc5d0 \uac19\uc740 \uc0c1\ud488\uc774  \uc874\uc7ac\ud558\uace0 \uc788\uc2b5\ub2c8\ub2e4. \uc0ad\uc81c\ud6c4\uc5d0 \uc7ac\ub4f1\ub85d\ud558\uc5ec \uc8fc\uc2dc\uae30 \ubc14\ub78d\ub2c8\ub2e4.");
                            WorkMngDao.get().saveDtl(uuid, workMngDetailDto);
                            continue;
                        }
                        List<Object> strImages = new ArrayList();
                        strImages = dtllist.getChangesize().equals("Y") ? this.getProductImages(dto, dtllist.getChangeSizeX(), dtllist.getChangeSizeY(), dtllist.getChangeSizeW(), dtllist.getChangeSizeH(), dtllist.getAngle(), dtllist.getScalePercent()) : this.getProductImages(dto);
                        if (dtllist.getImgThreeOnFour().equals("Y")) {
                            strImages = this.setImgRatioChange(dto, strImages, shoppingMallDetailDto);
                        }
                        this.DownLoadImage(dtllist, shoppingMallDetailDto, strImages);
                        ArrayList<String> detailImages = new ArrayList();
                        detailImages = this.DownLoadDetailImage(dto);
                        String json = this.MakeProductJson(dto, dtllist, loginID, password);
                        json = json.replaceAll("\"optionPrice\"", "\"optionPrices\"");
                        this.productRegSend(json, dto, dtllist, loginID, password);
                        this.RegImage(strImages, detailImages, dto, dtllist, loginID, password);
                        if (!dto.getShopprodno().equals("")) {
                            dto.setResult_code("1");
                            workMngDetailDto.setStatus("W06");
                            workMngDetailDto.setMessage(shoppingMallDetailDto.getSHOPNM() + "\uc5d0 \uc0c1\ud488\uc774 \uc815\uc0c1\uc801\uc73c\ub85c \ub4f1\ub85d \ub418\uc5c8\uc2b5\ub2c8\ub2e4 [\uc0c1\ud488\ubc88\ud638 : " + dto.getShopprodno() + " ]");
                            dto.setShopprodno(dto.getShopprodno());
                            dto.setResult_text(shoppingMallDetailDto.getSHOPNM() + "\uc5d0 \uc0c1\ud488\uc774 \uc815\uc0c1\uc801\uc73c\ub85c \ub4f1\ub85d \ub418\uc5c8\uc2b5\ub2c8\ub2e4 [\uc0c1\ud488\ubc88\ud638 : " + dto.getShopprodno() + " ]");
                            sendProdList.setShopProductDto(Arrays.asList(dto));
                            WorkMngDao.get().saveProductIn(sendProdList);
                        } else {
                            workMngDto.setWork_status("-1");
                            workMngDetailDto.setStatus("-1");
                            workMngDetailDto.setMessage(dto.getResult_text());
                            dto.setResult_code("-1");
                            dto.setResult_text(dto.getResult_text());
                        }
                        WorkMngDao.get().saveDtl(uuid, workMngDetailDto);
                    }
                    catch (Exception e) {
                        workMngDto.setWork_status("-1");
                        workMngDetailDto.setStatus("-1");
                        workMngDetailDto.setMessage(e.getMessage());
                        dto.setResult_code("-1");
                        dto.setResult_text(e.getMessage());
                        WorkMngDao.get().saveDtl(uuid, workMngDetailDto);
                        continue;
                    }
                    InterruptSource.Thread.sleep((long)5000L);
                    continue;
                }
                catch (Exception exception) {
                    workMngDto.setWork_status("-1");
                }
                break;
            }
        }
        finally {
            WorkMngDao.get().saveMst(uuid, sendProdList.getWorkMngDto());
        }
        return sendProdList;
    }

    private List<String> DownLoadDetailImage(ProductDTO dto) throws Exception {
        if (dto.getGoods_keyword().equals("shop9987")) {
            dto.setGoods_remarks(dto.getGoods_remarks().replace("https://www.onnme.com//", "https://cafe24.poxo.com/ec01/onnme/0jJurf5+JqL2mXn6P+LWO7AOJReIvurqGIXrcbUKXpOyPc6+sV46LMYTP2N64fK/UxkTbRHFkp58If06vHlUUA==/_/"));
        } else if (dto.getGoods_keyword().equals("shop0000")) {
            dto.setGoods_remarks(dto.getGoods_remarks().replace("https://cbw.co.kr//", "https://cafe24.poxo.com/ec01/kdh0201/EjglQcnyYl9oLKpqUS6wZgXi8sojGAGtEWIWWXL2plRUVd7qyEd9+lcioi6YTYl8+M0/iGFZrQSxc8jTkkjqtw==/_/"));
        } else if (dto.getGoods_keyword().equals("shop9986")) {
            dto.setGoods_remarks(dto.getGoods_remarks().replace("https://xn--jt2by0pl8b7va956c.kr", "https://ydinc.cafe24.com"));
        }
        ArrayList<String> detailImage = new ArrayList<String>();
        String html = dto.getGoods_remarks();
        Document doc = Jsoup.parse((String)html);
        Elements imgElements = doc.select("img");
        int i = 0;
        for (Element imgElement : imgElements) {
            if (i == 3) break;
            String imgSrc = imgElement.attr("src").replace("https", "http");
            ShopCommon.getImgPath();
            ShopCommon.downloadImgFile(imgSrc);
            InterruptSource.Thread.sleep((long)1000L);
            detailImage.add(imgSrc);
            ++i;
        }
        return detailImage;
    }

    private void RegImage(List<String> strImages, List<String> detailImages, ProductDTO dto, ShopProductAlwayzAdditionDto dtllist, String loginID, String password) throws Exception {
        ArrayList<File> fileList = new ArrayList<File>();
        String imgpath = null;
        for (String img : strImages) {
            try {
                imgpath = dtllist.getImageResizeYN().equals("Y") ? (dtllist.getImageResize().contains("1000") ? ShopCommon.getImgLocalPath2(img) : ShopCommon.getImgLocalPath(img)) : ShopCommon.getImgLocalPath(img);
                File file = new File(imgpath);
                fileList.add(file);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Map<String, String> loginInfo = IShopCommonLogin.loginAlwayzInfo(loginID, password, dtllist.getShopcd());
        OkHttpClient client = new OkHttpClient.Builder().hostnameVerifier((hostname, session) -> true).build();
        MultipartBody body = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("itemId", dto.getShopprodno()).addFormDataPart("image", "main1.jpg", RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (File)((File)fileList.get(0)))).build();
        Request request2 = new Request.Builder().url("https://alwayz-seller-back.ilevit.com/sellers/items/main-images").method("PUT", (RequestBody)body).addHeader("x-access-token", loginInfo.get("token")).build();
        Response response = client.newCall(request2).execute();
        YDMAStringUtil.Print(response.body().string());
        ArrayList<File> detailFileList = new ArrayList<File>();
        for (String detail : detailImages) {
            File file = new File(ShopCommon.getImgLocalPath(detail));
            detailFileList.add(file);
        }
        OkHttpClient client2 = new OkHttpClient.Builder().hostnameVerifier((hostname, session) -> true).build();
        new MultipartBody.Builder().setType(MultipartBody.FORM);
        MultipartBody body2 = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("itemId", dto.getShopprodno()).addFormDataPart("image", "detal1.jpg", RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (File)((File)fileList.get(0)))).build();
        Request request22 = new Request.Builder().url("https://alwayz-seller-back.ilevit.com/sellers/items/detail-images").method("PUT", (RequestBody)body2).addHeader("x-access-token", loginInfo.get("token")).build();
        Response response2 = client2.newCall(request22).execute();
        YDMAStringUtil.Print(response2.body().string());
    }

    private void productRegSend(String json, ProductDTO dto, ShopProductAlwayzAdditionDto dtllist, String loginID, String password) throws Exception {
        try {
            Map<String, String> loginInfo = IShopCommonLogin.loginAlwayzInfo(loginID, password, dtllist.getShopcd());
            Connection.Response rs = Jsoup.connect((String)"https://alwayz-seller-back.ilevit.com/sellers/items").header("Connection", "keep-alive").header("x-access-token", loginInfo.get("token")).header("Content-Type", "application/json").userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36").method(Connection.Method.POST).requestBody(json).ignoreHttpErrors(true).ignoreContentType(true).followRedirects(true).execute();
            if (rs.body().contains("wrong")) {
                throw new Exception("\uc0c1\ud488 \ub4f1\ub85d \uc2e4\ud328 : " + rs.body());
            }
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = (JsonObject)jsonParser.parse(rs.body());
            if (jsonObject.get("status").getAsInt() != 2000) {
                throw new Exception("\uc0c1\ud488 \ub4f1\ub85d \uc2e4\ud328 : " + jsonObject.get("msg").getAsString() + "[CODE:" + jsonObject.get("status").getAsString() + "]");
            }
            dto.setShopprodno(jsonObject.get("data").getAsString());
            if (dto.getShopprodno().equals("") || dto.getShopprodno() == null) {
                dto.setResult_text("\uc0c1\ud488 \ub4f1\ub85d \uc131\uacf5");
            }
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    private void DownLoadImage(ShopProductAlwayzAdditionDto dtllist, ShoppingmallDTO shoppingMallDetailDto, List<String> strImages) throws Exception, InterruptedException {
        for (String img : strImages) {
            if (dtllist.getImageResizeYN().equals("Y")) {
                if (dtllist.getImageResize().contains("1000")) {
                    ShopCommon.downloadImgFile(img, 1000, 1000);
                    InterruptSource.Thread.sleep((long)1000L);
                    continue;
                }
                ShopCommon.downloadImgFile(img);
                InterruptSource.Thread.sleep((long)1000L);
                continue;
            }
            if (dtllist.getImgThreeOnFour().equals("Y")) {
                ShopCommon.downloadImgFile(img, 600, 800);
                InterruptSource.Thread.sleep((long)1000L);
                continue;
            }
            ShopCommon.downloadImgFile(img);
            InterruptSource.Thread.sleep((long)1000L);
        }
    }

    private String MakeProductJson(ProductDTO dto, ShopProductAlwayzAdditionDto dtllist, String loginID, String password) throws Exception {
        String json = "";
        try {
            int teamPurchasePrice;
            int salePrice;
            ResultMarketPrice resultMarketPrice = new ResultMarketPrice();
            ObjectMapper mapper = new ObjectMapper();
            AlwayzProductReg azReg = new AlwayzProductReg();
            this.CategorySetting(azReg, dto, dtllist, loginID, password);
            this.ProductNameSetting(azReg, dtllist, dto);
            resultMarketPrice = this.PriceSetting(dto, dtllist, resultMarketPrice);
            int individualPurchasePrice = Integer.parseInt(resultMarketPrice.getConsumer_if_sale_price());
            if (dtllist.getTeamPurchasePriceUnit().equals("percent")) {
                salePrice = individualPurchasePrice * dtllist.getTeamPurchasePrice() / 100;
                teamPurchasePrice = individualPurchasePrice - salePrice;
            } else {
                salePrice = dtllist.getTeamPurchasePrice();
                teamPurchasePrice = individualPurchasePrice - salePrice;
            }
            azReg.itemInfo.individualPurchasePrice = individualPurchasePrice;
            azReg.itemInfo.teamPurchasePrice = teamPurchasePrice;
            azReg.itemInfo.discountRate = salePrice / individualPurchasePrice;
            TestingSkuGroupLogs testingGroupLog = new TestingSkuGroupLogs();
            this.OptionSetting(azReg, dtllist, dto, individualPurchasePrice, teamPurchasePrice, testingGroupLog);
            this.DeliverySetting(azReg, dtllist, dto);
            this.GosiSetting(azReg, dtllist, dto);
            azReg.itemInfo.soldOut = false;
            azReg.itemInfo.hurryUp = false;
            azReg.itemInfo.totalOrderQuantity = 0;
            azReg.itemInfo.totalRatingCount = 0;
            azReg.itemInfo.totalRatingScore = 0.0;
            azReg.itemInfo.hideSellerInfo = false;
            azReg.itemInfo.vectorWeights = 1;
            this.SellerInfoSetting(azReg, dtllist, dto, loginID, password);
            azReg.itemInfo.teamDealThreshold = dtllist.getTeamDealthReshold();
            azReg.itemInfo.purchaseLimits = dtllist.getPurchaseLimits();
            azReg.itemInfo.testingSkuGroup = "aperion";
            testingGroupLog.testingSkuGroup = "aperion";
            testingGroupLog.teamPurchasePrice = teamPurchasePrice;
            testingGroupLog.individualPurchasePrice = individualPurchasePrice;
            testingGroupLog.soldOut = false;
            azReg.itemInfo.testingSkuGroupLogs.add(testingGroupLog);
            azReg.itemInfo.sellerType = "inboundSeller";
            azReg.itemInfo.itemRankTestingSku = true;
            azReg.itemInfo.alfarmPhotoReviewMode = true;
            azReg.itemInfo.recommendItemCode = dto.getCompayny_goods_cd();
            if (dto.getGoods_search().equals("")) {
                azReg.itemInfo.textForQuery = "";
            } else {
                String result;
                String[] keywords = dto.getGoods_search().split(",");
                int limit = Math.min(keywords.length, 5);
                azReg.itemInfo.textForQuery = result = String.join((CharSequence)",", Arrays.copyOfRange(keywords, 0, limit));
            }
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
            json = mapper.writeValueAsString((Object)azReg);
            YDMAStringUtil.Print(json);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        return json;
    }

    private void SellerInfoSetting(AlwayzProductReg azReg, ShopProductAlwayzAdditionDto dtllist, ProductDTO dto, String loginID, String password) throws Exception {
        try {
            Map<String, String> loginInfo = IShopCommonLogin.loginAlwayzInfo(loginID, password, dtllist.getShopcd());
            Connection.Response rs = Jsoup.connect((String)"https://alwayz-seller-back.ilevit.com/sellers").header("Connection", "keep-alive").header("x-access-token", loginInfo.get("token")).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36").method(Connection.Method.GET).ignoreHttpErrors(true).ignoreContentType(true).followRedirects(true).execute();
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = (JsonObject)jsonParser.parse(rs.body());
            int status2 = jsonObject.get("status").getAsInt();
            if (status2 == 200) {
                JsonObject item = (JsonObject)jsonObject.get("data");
                azReg.itemInfo.sellerInfo.sellerId = item.get("_id").getAsString();
                azReg.itemInfo.sellerInfo.address = item.get("address").getAsString();
                azReg.itemInfo.sellerInfo.businessRegistrationNumber = item.get("businessRegistrationNumber").getAsString();
                azReg.itemInfo.sellerInfo.contactNumber = item.get("contactNumber").getAsString();
                azReg.itemInfo.sellerInfo.email = item.get("email").getAsString();
                azReg.itemInfo.sellerInfo.mailOrderBusinessNumber = item.get("mailOrderBusinessNumber").getAsString();
                azReg.itemInfo.sellerInfo.sellerDisplayName = item.get("sellerDisplayName").getAsString();
            }
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    private void CategorySetting(AlwayzProductReg azReg, ProductDTO dto, ShopProductAlwayzAdditionDto dtllist, String loginID, String password) throws Exception {
        try {
            Map<String, String> loginInfo = IShopCommonLogin.loginAlwayzInfo(loginID, password, dtllist.getShopcd());
            String[] parts = dto.getGmcategnm().split(">");
            if (parts.length == 0) {
                throw new Exception("\uce74\ud14c\uace0\ub9ac \uc218\uc9d1 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd [\ud0a4\uc6cc\ub4dc \uc5c6\uc74c]");
            }
            String[] stringArray = parts;
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                JsonArray data2;
                JsonParser jsonParser = new JsonParser();
                String element = stringArray[n2];
                Connection.Response rs = Jsoup.connect((String)("https://alwayz-seller-back.ilevit.com/items/item-category/query?q=" + URLEncoder.encode(element, "UTF-8"))).header("Connection", "keep-alive").header("x-access-token", loginInfo.get("token")).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36").method(Connection.Method.GET).ignoreHttpErrors(true).ignoreContentType(true).followRedirects(true).execute();
                JsonObject jsonObject = (JsonObject)jsonParser.parse(rs.body());
                int status2 = jsonObject.get("status").getAsInt();
                if (status2 == 200 && (data2 = (JsonArray)jsonObject.get("data")).size() != 0) {
                    int count = Math.min(data2.size(), 10);
                    int i = 0;
                    while (i < count) {
                        JsonObject obj = (JsonObject)data2.get(i);
                        if (obj.get("endNode") != null) {
                            azReg.itemInfo.categoryInfo.minimumCategoryId = obj.get("_id").getAsInt();
                            return;
                        }
                        ++i;
                    }
                }
                ++n2;
            }
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    private void ProductNameSetting(AlwayzProductReg azReg, ShopProductAlwayzAdditionDto dtllist, ProductDTO dto) {
        String value = switch (dtllist.getProdnmoutput()) {
            case "1" -> dto.getGoods_nm();
            case "2" -> dto.getModel_nm();
            case "3" -> dto.getGoods_nm().concat(" (").concat(dto.getModel_nm()).concat(")");
            case "4" -> dto.getModel_nm().concat(" (").concat(dto.getGoods_nm()).concat(")");
            case "5" -> dto.getGoods_nm().concat(" ").concat(dto.getModel_nm());
            case "6" -> dto.getModel_nm().concat(" ").concat(dto.getGoods_nm());
            default -> dto.getGoods_nm();
        };
        if (!dtllist.getProdnmaddfront().equals("")) {
            value = dtllist.getProdnmaddfront().concat(value);
        }
        if (!dtllist.getProdnmaddback().equals("")) {
            value = value.concat(" ").concat(dtllist.getProdnmaddback());
        }
        if (dtllist.getProdnmafter().equals("Y")) {
            value = ShopCommon.setAddKeywordInProdName(value, dto.getGoods_search(), "B", 99);
        }
        if (dtllist.getProdnmrand().equals("Y")) {
            value = ShopCommon.setWordRandomGenerator(value);
        }
        azReg.itemInfo.itemTitle = dto.getProdnmlenyn().equals("Y") ? YDMAStringUtil.setTextStrtok(value, 99) : value;
    }

    private ResultMarketPrice PriceSetting(ProductDTO dto, ShopProductAlwayzAdditionDto dtllist, ResultMarketPrice resultMarketPrice) throws Exception {
        try {
            String price_cost = String.valueOf(Integer.parseInt(dto.getGoods_cost()) + Integer.parseInt(dto.getDelv_cost()));
            Long salePrice = YDMAStringUtil.convertToLong(price_cost);
            int limit_price = YDMAStringUtil.convertToInt(dto.getLimit_price());
            resultMarketPrice = MarketPriceCalc.get().setCompliancePrice(limit_price).setTestPrice(salePrice.longValue()).setSellerDc(dtllist.getSellerDc()).setDc(dtllist.getDcRate()).setFlatDc(dtllist.getCumDC()).setMargin(dtllist.getMarginDC()).setCommission(dtllist.getCommDC()).calculate();
            if (salePrice > YDMAStringUtil.convertToLong(resultMarketPrice.getConsumer_if_sale_price())) {
                resultMarketPrice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
            }
            dto.setGoods_price(resultMarketPrice.getConsumer_if_sale_price());
            dto.setMarket_price(resultMarketPrice.getConsumer_if_sale_price());
            dto.setGoods_consumer_price(resultMarketPrice.getConsumer_if_sale_price());
            return resultMarketPrice;
        }
        catch (Exception exception) {
            throw new Exception("\uc0c1\ud488\uc0c1\ud0dc, \ud310\ub9e4\uac00 \ub4f1\ub85d\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void OptionSetting(AlwayzProductReg azReg, ShopProductAlwayzAdditionDto dtllist, ProductDTO dto, int individualPurchasePrice, int teamPurchasePrice, TestingSkuGroupLogs testingGroupLog) {
        ArrayList<OptionsInfo.Option> listOpt = new ArrayList<OptionsInfo.Option>();
        ArrayList<OptionsInfo.OptionPrice> ListOptPrice = new ArrayList<OptionsInfo.OptionPrice>();
        if (dto.getChar_1_nm().equals("\ub2e8\ud488")) {
            azReg.itemInfo.optionsInfo.optionNames.add("\ub2e8\ud488");
            testingGroupLog.optionsInfo.optionNames.add("\ub2e8\ud488");
            OptionsInfo.Option option2 = new OptionsInfo.Option();
            option2.name = "\ubcf8\ud488";
            option2.img = null;
            listOpt.add(option2);
            OptionsInfo.OptionPrice optPrice = new OptionsInfo.OptionPrice();
            optPrice.individualPurchasePrice = individualPurchasePrice;
            optPrice.teamPurchasePrice = teamPurchasePrice;
            optPrice.aiPrice = 0;
            optPrice.stockNumber = 999;
            optPrice.sold_out = false;
            optPrice.hurry_up = false;
            optPrice.optionCode = dto.getCompayny_goods_cd();
            ListOptPrice.add(optPrice);
            azReg.itemInfo.optionsInfo.optionPrice = new ArrayList<OptionsInfo.OptionPrice>();
            testingGroupLog.optionsInfo.optionPrice = new ArrayList<OptionsInfo.OptionPrice>();
            azReg.itemInfo.optionsInfo.optionPrice = ListOptPrice;
            testingGroupLog.optionsInfo.optionPrice = ListOptPrice;
        } else {
            List<ShopOptionDto> shopOptionDtos = this.getProductOptions(dto);
            ArrayList<String> amt = new ArrayList<String>();
            ArrayList<String> option1 = new ArrayList<String>();
            ArrayList<String> option2 = new ArrayList<String>();
            ArrayList<String> option3 = new ArrayList<String>();
            ArrayList<String> limitPrice = new ArrayList<String>();
            for (ShopOptionDto opt : shopOptionDtos) {
                if (opt.getName().contains("\ud488\uc808") || opt.getOptspecdes().contains("\ud488\uc808") || opt.getCnt().equals("0")) continue;
                amt.add(opt.getAmt());
                limitPrice.add(opt.getLimit_price());
                List<String> split = Arrays.asList(opt.getOptspecdes().split(":"));
                if (split.size() > 2) {
                    if (!option1.contains(split.get(0))) {
                        option1.add(split.get(0));
                    }
                    if (!option2.contains(split.get(1))) {
                        option2.add(split.get(1));
                    }
                    option3.add(split.get(2));
                    continue;
                }
                if (split.size() > 1) {
                    if (!option1.contains(split.get(0))) {
                        option1.add(split.get(0));
                    }
                    if (option2.contains(split.get(1))) continue;
                    option2.add(split.get(1));
                    continue;
                }
                option1.add(split.get(0));
            }
            if (option2.size() == 0) {
                azReg.itemInfo.optionsInfo.optionNames.add(shopOptionDtos.get(0).getName());
                testingGroupLog.optionsInfo.optionNames.add(shopOptionDtos.get(0).getName());
                int i = 0;
                while (i < option1.size()) {
                    OptionsInfo.Option option4 = new OptionsInfo.Option();
                    option4.name = (String)option1.get(i);
                    option4.img = null;
                    listOpt.add(option4);
                    OptionsInfo.OptionPrice optPrice = new OptionsInfo.OptionPrice();
                    optPrice.individualPurchasePrice = individualPurchasePrice;
                    optPrice.teamPurchasePrice = teamPurchasePrice;
                    optPrice.aiPrice = 0;
                    optPrice.stockNumber = 999;
                    optPrice.sold_out = false;
                    optPrice.hurry_up = false;
                    optPrice.optionCode = dto.getCompayny_goods_cd() + "_" + (i + 1);
                    ListOptPrice.add(optPrice);
                    ++i;
                }
                azReg.itemInfo.optionsInfo.optionPrice = new ArrayList<OptionsInfo.OptionPrice>();
                testingGroupLog.optionsInfo.optionPrice = new ArrayList<OptionsInfo.OptionPrice>();
                azReg.itemInfo.optionsInfo.optionPrice = ListOptPrice;
                testingGroupLog.optionsInfo.optionPrice = ListOptPrice;
            } else {
                OptionsInfo.Option option5;
                List<String> split = Arrays.asList(shopOptionDtos.get(0).getName().split(":"));
                azReg.itemInfo.optionsInfo.optionNames.add(split.get(0));
                azReg.itemInfo.optionsInfo.optionNames.add(split.get(1));
                testingGroupLog.optionsInfo.optionNames.add(split.get(0));
                testingGroupLog.optionsInfo.optionNames.add(split.get(1));
                ArrayList<OptionsInfo.Option> listOpt2 = new ArrayList<OptionsInfo.Option>();
                azReg.itemInfo.optionsInfo.optionPrices = new ArrayList<List<OptionsInfo.OptionPrice>>();
                testingGroupLog.optionsInfo.optionPrices = new ArrayList<List<OptionsInfo.OptionPrice>>();
                int count = 1;
                int i = 0;
                while (i < option1.size()) {
                    option5 = new OptionsInfo.Option();
                    option5.name = (String)option1.get(i);
                    option5.img = null;
                    listOpt.add(option5);
                    ArrayList<OptionsInfo.OptionPrice> ListOptPrice2 = new ArrayList<OptionsInfo.OptionPrice>();
                    int j = 0;
                    while (j < option2.size()) {
                        OptionsInfo.OptionPrice optPrice = new OptionsInfo.OptionPrice();
                        optPrice.individualPurchasePrice = individualPurchasePrice;
                        optPrice.teamPurchasePrice = teamPurchasePrice;
                        optPrice.aiPrice = 0;
                        optPrice.stockNumber = 999;
                        optPrice.sold_out = false;
                        optPrice.hurry_up = false;
                        optPrice.optionCode = dto.getCompayny_goods_cd() + "_" + count++;
                        ListOptPrice2.add(optPrice);
                        ++j;
                    }
                    azReg.itemInfo.optionsInfo.optionPrices.add(ListOptPrice2);
                    testingGroupLog.optionsInfo.optionPrices.add(ListOptPrice2);
                    ++i;
                }
                i = 0;
                while (i < option2.size()) {
                    option5 = new OptionsInfo.Option();
                    option5.name = (String)option2.get(i);
                    option5.img = null;
                    listOpt2.add(option5);
                    ++i;
                }
                azReg.itemInfo.optionsInfo.totalOptions.add(listOpt2);
                testingGroupLog.optionsInfo.totalOptions.add(listOpt2);
            }
        }
        azReg.itemInfo.optionsInfo.totalOptions.add(0, listOpt);
        testingGroupLog.optionsInfo.totalOptions.add(0, listOpt);
    }

    private void DeliverySetting(AlwayzProductReg azReg, ShopProductAlwayzAdditionDto dtllist, ProductDTO dto) {
        azReg.itemInfo.shippingInfo.freeShipping = true;
        azReg.itemInfo.shippingInfo.shippingMethod = "\uc21c\ucc28\ubc30\uc1a1";
        azReg.itemInfo.shippingInfo.shippingFee = 0;
        azReg.itemInfo.shippingInfo.shippingFeeInfo = dtllist.getShippingFeeInfo().equals("") ? "\ubb34\ub8cc\ubc30\uc1a1, \ub3c4\uc11c\uc0b0\uac04 \ucd94\uac00 \ubc30\uc1a1\ube44 -\uc81c\uc8fc \uc9c0\uc5ed: 3,000\uc6d0 -\ub3c4\uc11c\uc0b0\uac04 \uc9c0\uc5ed: 5,000\uc6d0" : dtllist.getShippingFeeInfo();
        azReg.itemInfo.shippingInfo.returnFee = dtllist.getReturnFee();
        azReg.itemInfo.shippingInfo.returnFeeInfo = dtllist.getReturnFeeInfo().equals("") ? "5,000\uc6d0 -\ub2e8, \uace0\uac1d \ub2e8\uc21c \ubcc0\uc2ec\uc758 \uacbd\uc6b0\uc5d0\ub9cc \ubc1c\uc0dd -\ub3c4\uc11c\uc0b0\uac04 \ubc0f \uc77c\ubd80 \uc9c0\uc5ed \ucd94\uac00\ube44\uc6a9 \ubc1c\uc0dd" : dtllist.getReturnFeeInfo();
        azReg.itemInfo.shippingInfo.shippingCompany = dtllist.getShippingCompany();
        azReg.itemInfo.shippingInfo.shippingDays = Integer.parseInt(dtllist.getShippingDays().replace("\uc77c", ""));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc778\ucc9c \uc911\uad6c \uc12c\uc9c0\uc5ed", "22386", "22388", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc778\ucc9c \uac15\ud654 \uc12c\uc9c0\uc5ed", "23004", "23010", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc778\ucc9c \uc639\uc9c4 \uc12c\uc9c0\uc5ed1", "23100", "23116", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc778\ucc9c \uc639\uc9c4 \uc12c\uc9c0\uc5ed2", "23124", "23136", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\ucda9\ub0a8 \ub2f9\uc9c4 \uc12c\uc9c0\uc5ed", "31708", "31708", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\ucda9\ub0a8 \ud0dc\uc548 \uc12c\uc9c0\uc5ed", "32133", "32133", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\ucda9\ub0a8 \ubcf4\ub839 \uc12c\uc9c0\uc5ed", "33411", "33411", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uacbd\ubd81 \uc6b8\ub989\ub3c4 \uc804\uc9c0\uc5ed", "40200", "40240", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\ubd80\uc0b0 \uac15\uc11c\uad6c \uc12c\uc9c0\uc5ed", "46768", "46771", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uacbd\ub0a8 \uc0ac\ucc9c \uc12c\uc9c0\uc5ed", "52570", "52571", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uacbd\ub0a8 \ud1b5\uc601 \uc12c\uc9c0\uc5ed1", "53031", "53033", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uacbd\ub0a8 \ud1b5\uc601 \uc12c\uc9c0\uc5ed2", "53089", "53104", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uacbd\ub0a8 \ud1b5\uc601 \uc12c\uc9c0\uc5ed3", "54000", "54000", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ubd81 \ubd80\uc548 \uc12c\uc9c0\uc5ed", "56347", "56349", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \uc601\uad11 \uc12c\uc9c0\uc5ed", "57068", "57069", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \ubaa9\ud3ec \uc12c\uc9c0\uc5ed", "58760", "58762", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \uc2e0\uc548 \uc12c\uc9c0\uc5ed1", "58800", "58810", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \uc2e0\uc548 \uc12c\uc9c0\uc5ed2", "58816", "58818", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \uc2e0\uc548 \uc12c\uc9c0\uc5ed3", "58826", "58826", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \uc2e0\uc548 \uc12c\uc9c0\uc5ed4", "58828", "58866", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \uc9c4\ub3c4 \uc12c\uc9c0\uc5ed", "58953", "58958", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \uc644\ub3c4 \uc12c\uc9c0\uc5ed1", "59102", "59103", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \uc644\ub3c4 \uc12c\uc9c0\uc5ed2", "59106", "59106", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \uc644\ub3c4 \uc12c\uc9c0\uc5ed3", "59127", "59127", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \uc644\ub3c4 \uc12c\uc9c0\uc5ed4", "59129", "59129", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \uc644\ub3c4 \uc12c\uc9c0\uc5ed5", "59137", "59166", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \ubcf4\uc131 \uc12c\uc9c0\uc5ed", "59421", "59421", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \uace0\ud765 \uc12c\uc9c0\uc5ed1", "59531", "59531", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \uace0\ud765 \uc12c\uc9c0\uc5ed2", "59551", "59551", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \uace0\ud765 \uc12c\uc9c0\uc5ed3", "59563", "59563", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \uace0\ud765 \uc12c\uc9c0\uc5ed4", "59568", "59568", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \uc5ec\uc218 \uc12c\uc9c0\uc5ed1", "59650", "59650", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \uc5ec\uc218 \uc12c\uc9c0\uc5ed2", "59766", "59766", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \uc5ec\uc218 \uc12c\uc9c0\uc5ed3", "59781", "59790", "5000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc81c\uc8fc \uc6b0\ub3c4", "63365", "63365", "3000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc81c\uc8fc \ucd94\uc790\uba74", "63000", "63001", "3000"));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uadf8 \uc678 \uc81c\uc8fc \uc804\uc9c0\uc5ed", "63000", "63644", "3000"));
    }

    private ShippingInfo.RuralAreaShippingFeeInfo CreateRuralAreaShipInfo(String ruralAreaName, String startPostNumber, String endPostNumber, String shippingFee) {
        ShippingInfo.RuralAreaShippingFeeInfo metaData = new ShippingInfo.RuralAreaShippingFeeInfo();
        metaData.ruralAreaName = ruralAreaName;
        metaData.startPostNumber = startPostNumber;
        metaData.endPostNumber = endPostNumber;
        metaData.shippingFee = shippingFee;
        return metaData;
    }

    private void GosiSetting(AlwayzProductReg azReg, ShopProductAlwayzAdditionDto dtllist, ProductDTO dto) {
        azReg.itemInfo.commonMetaDataInfoList.add(this.createCommonMetaData("\uc81c\uc870\uc790", "\uc218\uc785\ud488\uc758 \uacbd\uc6b0 \uc218\uc785\uc790 \uad04\ud638\ub85c \ud568\uaed8 \ud45c\uae30", true, dto.getMaker()));
        azReg.itemInfo.commonMetaDataInfoList.add(this.createCommonMetaData("\uc81c\uc870\uad6d(\uc6d0\uc0b0\uc9c0)", "", true, dto.getOrigin()));
        azReg.itemInfo.commonMetaDataInfoList.add(this.createCommonMetaData("\ucde8\uae09\uc2dc \uc8fc\uc758\uc0ac\ud56d(\uc120\ud0dd)", "", false, null));
        azReg.itemInfo.commonMetaDataInfoList.add(this.createCommonMetaData("\uc81c\uc870\uc5f0\uc6d4(\uc0dd\uc0b0\uc5f0\uc6d4)", "", true, "2402"));
        azReg.itemInfo.commonMetaDataInfoList.add(this.createCommonMetaData("\ud488\uc9c8\ubcf4\uc99d\uae30\uc900(\uc120\ud0dd)", "", false, null));
        azReg.itemInfo.commonMetaDataInfoList.add(this.createCommonMetaData("A/S \ucc45\uc784\uc790", "", true, ""));
        azReg.itemInfo.commonMetaDataInfoList.add(this.createCommonMetaData("A/S \uc804\ud654\ubc88\ud638", "", true, ""));
    }

    private CommonMetaDataInfo createCommonMetaData(String title, String placeholder, boolean isNecessary, String contents) {
        CommonMetaDataInfo metaData = new CommonMetaDataInfo();
        metaData.title = title;
        metaData.placeholder = placeholder;
        metaData.isNecessary = isNecessary;
        metaData.contents = contents;
        return metaData;
    }

    @Override
    public ShopProductSendDto complate(ShopProductSendDto prodList) throws Exception {
        return null;
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    private static final class AlwayzProductReg {
        private ItemInfo itemInfo = new ItemInfo();

        private AlwayzProductReg() {
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    private static class CategoryInfo {
        private int minimumCategoryId;

        private CategoryInfo() {
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    private static class CommonMetaDataInfo {
        public String title;
        public String placeholder;
        public boolean isNecessary;
        public String contents;

        private CommonMetaDataInfo() {
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    private static class ItemInfo {
        private CategoryInfo categoryInfo = new CategoryInfo();
        private String itemTitle;
        private OptionsInfo optionsInfo = new OptionsInfo();
        private List<String> mainImageUris = new ArrayList<String>();
        private List<String> detailImageUris = new ArrayList<String>();
        private ShippingInfo shippingInfo = new ShippingInfo();
        private List<CommonMetaDataInfo> commonMetaDataInfoList = new ArrayList<CommonMetaDataInfo>();
        private List<ProductMetaDataInfo> productMetaDataInfoList = new ArrayList<ProductMetaDataInfo>();
        private boolean soldOut;
        private boolean hurryUp;
        private int totalOrderQuantity;
        private int totalRatingCount;
        private double totalRatingScore;
        private int teamPurchasePrice;
        private int individualPurchasePrice;
        private double discountRate;
        private List<PurchasingUsersInfo> purchasingUsersInfo = new ArrayList<PurchasingUsersInfo>();
        private boolean hideSellerInfo;
        private int vectorWeights;
        private SellerInfo sellerInfo = new SellerInfo();
        private int teamDealThreshold;
        private int purchaseLimits;
        private String testingSkuGroup;
        private List<TestingSkuGroupLogs> testingSkuGroupLogs = new ArrayList<TestingSkuGroupLogs>();
        private String sellerType;
        private boolean itemRankTestingSku;
        private boolean alfarmPhotoReviewMode;
        private String recommendItemCode;
        private String textForQuery;

        private ItemInfo() {
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    private static class OptionsInfo {
        private List<String> optionNames = new ArrayList<String>();
        private List<List<Option>> totalOptions = new ArrayList<List<Option>>();
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        private List<OptionPrice> optionPrice;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        private List<List<OptionPrice>> optionPrices;

        private OptionsInfo() {
        }

        private static class Option {
            private String name;
            private String img;

            private Option() {
            }
        }

        private static class OptionMetaDataInfo {
            private OptionMetaDataInfo() {
            }
        }

        private static class OptionPrice {
            private int individualPurchasePrice;
            private int teamPurchasePrice;
            private int aiPrice;
            private int stockNumber;
            private boolean sold_out;
            private boolean hurry_up;
            private List<OptionMetaDataInfo> optionMetaDataInfoList = new ArrayList<OptionMetaDataInfo>();
            private String optionCode;

            private OptionPrice() {
            }
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    private static class ProductMetaDataInfo {
        private ProductMetaDataInfo() {
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    private static class PurchasingUsersInfo {
        private PurchasingUsersInfo() {
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    private static class SellerInfo {
        private String sellerId;
        private String address;
        private String businessRegistrationNumber;
        private String contactNumber;
        private String email;
        private String mailOrderBusinessNumber;
        private String sellerDisplayName;

        private SellerInfo() {
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    private static class ShippingInfo {
        private boolean freeShipping;
        private String shippingMethod;
        private int shippingFee;
        private String shippingFeeInfo;
        private int returnFee;
        private String returnFeeInfo;
        private List<RuralAreaShippingFeeInfo> ruralAreaShippingFeeInfo = new ArrayList<RuralAreaShippingFeeInfo>();
        private String shippingCompany;
        private int shippingDays;

        private ShippingInfo() {
        }

        private static class RuralAreaShippingFeeInfo {
            private String ruralAreaName;
            private String startPostNumber;
            private String endPostNumber;
            private String shippingFee;

            private RuralAreaShippingFeeInfo() {
            }
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    private static class TestingSkuGroupLogs {
        private OptionsInfo optionsInfo = new OptionsInfo();
        private String testingSkuGroup;
        private int teamPurchasePrice;
        private int individualPurchasePrice;
        private boolean soldOut;

        private TestingSkuGroupLogs() {
        }
    }
}

