/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.shop.data.cafe24;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.yellim.common.YDMASessonUtil;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.data.dao.ProductIforDao;
import com.kdjsystem.mlink.yellim.dto.PreferencesMallDTO;
import com.kdjsystem.mlink.yellim.dto.ProductDTO;
import com.kdjsystem.mlink.yellim.dto.ShoppingmallDTO;
import com.kdjsystem.mlink.yellim.shop.common.ChromeExtention;
import com.kdjsystem.mlink.yellim.shop.common.ChromeScript;
import com.kdjsystem.mlink.yellim.shop.common.CodeItem;
import com.kdjsystem.mlink.yellim.shop.common.DriverPool;
import com.kdjsystem.mlink.yellim.shop.common.IProduct;
import com.kdjsystem.mlink.yellim.shop.common.IShopProductListener;
import com.kdjsystem.mlink.yellim.shop.common.ResultMarketPrice;
import com.kdjsystem.mlink.yellim.shop.common.ShopCommon;
import com.kdjsystem.mlink.yellim.shop.common.ShopWorkDataQueue;
import com.kdjsystem.mlink.yellim.shop.dao.ShopCafe24AdditionDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopCatInfDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.yellim.shop.dao.ShopOptionDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProdAttrnmDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductAdditionDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductCafe24AdditionDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductDao;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductSendDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.yellim.shop.dao.WorkMngDao;
import com.kdjsystem.mlink.yellim.shop.dao.WorkMngDetailDto;
import com.kdjsystem.mlink.yellim.shop.dao.WorkMngDto;
import com.kdjsystem.mlink.yellim.shop.data.cafe24.Cafe24AcessToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.support.ui.ExpectedConditions;

public class Cafe24ProductRegService
implements IProduct {
    ProductDTO dto;
    ShopProductCafe24AdditionDto dtllist;
    ShoppingMallDetailDto idlist;
    DriverPool driverPool;
    ChromeDriver driver;
    int count;
    String shopinfo;
    IShopProductListener listener;
    private static final String content_type = "application/json";

    private static OkHttpClient getUnsafeOkHttpClient() {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }};
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            return new OkHttpClient.Builder().sslSocketFactory(sslSocketFactory, (X509TrustManager)trustAllCerts[0]).hostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            }).build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Cafe24ProductRegService() {
    }

    public Cafe24ProductRegService(ProductDTO dto, ShopProductAdditionDto dtllist, ShoppingMallDetailDto idlist, DriverPool driverPool, int cnt, String shopinfo, IShopProductListener listener) {
        this.dto = dto;
        this.dtllist = (ShopProductCafe24AdditionDto)dtllist;
        this.idlist = idlist;
        this.count = cnt;
        this.shopinfo = shopinfo;
        this.driverPool = driverPool;
        this.driver = driverPool.getChromeDriver();
        this.listener = listener;
    }

    private void getOption(ProductDTO dto, Cafe24ProductItem cafe24ProductItem, ResultMarketPrice resultMarketPrice) throws Exception {
        try {
            String string = cafe24ProductItem.request.has_option = dto.getChar_1_nm().equals("\ub2e8\ud488") ? "F" : "T";
            if (!dto.getChar_1_nm().equals("\ub2e8\ud488")) {
                cafe24ProductItem.request.options = new ArrayList<Cafe24Option>();
                Cafe24Option cafe24Option = new Cafe24Option();
                cafe24Option.value = new ArrayList<String>();
                List<ShopOptionDto> shopOptionDtos = this.getProductOptions(dto);
                ArrayList<String> value1 = new ArrayList<String>();
                ArrayList<String> value2 = new ArrayList<String>();
                if (shopOptionDtos.size() > 0) {
                    for (ShopOptionDto optionDto : shopOptionDtos) {
                        if (dto.getChar_2_nm().equals("")) {
                            value1.add(optionDto.getName());
                            continue;
                        }
                        value1.add(optionDto.getName());
                        value2.add(optionDto.getOptspecdes().split(":")[1]);
                    }
                    if (dto.getChar_2_nm().equals("")) {
                        cafe24Option.name = dto.getChar_1_nm();
                        cafe24Option.value = value1.stream().distinct().collect(Collectors.toList());
                        cafe24ProductItem.request.options.add(cafe24Option);
                    } else {
                        cafe24Option.name = dto.getChar_1_nm();
                        cafe24Option.value = value1.stream().distinct().collect(Collectors.toList());
                        cafe24ProductItem.request.options.add(cafe24Option);
                        cafe24Option = new Cafe24Option();
                        cafe24Option.name = dto.getChar_2_nm();
                        cafe24Option.value = value2.stream().distinct().collect(Collectors.toList());
                        cafe24ProductItem.request.options.add(cafe24Option);
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("\uc635\uc158 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void getCode(ShopCafe24AdditionDto dtllist, Cafe24ProductItem cafe24ProductItem) throws Exception {
        try {
            cafe24ProductItem.request.manufacturer_code = "M0000000";
            cafe24ProductItem.request.trend_code = "T0000000";
            cafe24ProductItem.request.brand_code = "B0000000";
            cafe24ProductItem.request.supplier_code = "S0000000";
        }
        catch (Exception exception) {
            throw new Exception("\uc81c\uc870\uc0ac,\uacf5\uae09\uc0ac,\ube0c\ub79c\ub4dc,\ud2b8\ub79c\ub4dc \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void getDelvExpress(ShopCafe24AdditionDto dtllist, Cafe24ProductItem cafe24ProductItem, ProductDTO dto) throws Exception {
        try {
            String delvtype;
            cafe24ProductItem.request.shipping_fee_by_product = dtllist.getDeliveryfeetype().equals("F") ? "F" : "T";
            String deliveryFee = "";
            if (!dtllist.getDeliveryfeetype().equals("F")) {
                cafe24ProductItem.request.shipping_scope = "A";
                cafe24ProductItem.request.shipping_method = "01";
                cafe24ProductItem.request.shipping_area = "\uc804\uad6d(\ub3c4\uc11c\uc0b0\uac04\uc81c\uc678)";
                cafe24ProductItem.request.shipping_fee_type = dtllist.getDeliveryfeetype();
                Cafe24Rates rate = new Cafe24Rates();
                if (dtllist.getShipfee().equals("9999")) {
                    if (!dto.getDelv_cost().equals("0")) {
                        deliveryFee = dto.getDelv_cost();
                    } else {
                        PreferencesMallDTO systemconf = ShopCommonDao.get().getSystemConf();
                        deliveryFee = String.valueOf(systemconf.getDELIVERYCOST());
                    }
                } else {
                    deliveryFee = dtllist.getShipfee();
                }
                rate.shipping_fee = deliveryFee;
                cafe24ProductItem.request.shipping_rates = new ArrayList<Cafe24Rates>();
                cafe24ProductItem.request.shipping_rates.add(rate);
            }
            String string = dtllist.getDeliveryfeetype().equals("F") ? "\uae30\ubcf8\ubc30\uc1a1 \uc124\uc815" : (dtllist.getDeliveryfeetype().equals("T") ? "\ubb34\ub8cc\ubc30\uc1a1" : (dtllist.getDeliveryfeetype().equals("R_C") ? "\ucc29\ubd88\ubc30\uc1a1" : (delvtype = dtllist.getDeliveryfeetype().equals("R") ? "\uc720\ub8cc\ubc30\uc1a1" : "\uc218\ub7c9\ubcc4 \ubc30\uc1a1")));
            long delvcost = delvtype.equals("\ubb34\ub8cc\ubc30\uc1a1") ? 0 : (delvtype.equals("\uae30\ubcf8\ubc30\uc1a1 \uc124\uc815") ? 0 : (delvtype.equals("\ucc29\ubd88\ubc30\uc1a1") ? 0 : Integer.parseInt(dtllist.getShipfee())));
            dto.setPack_code_str(delvtype.concat("=").concat(String.valueOf(delvcost)));
        }
        catch (Exception exception) {
            throw new Exception("\ubc30\uc1a1\uc815\ubcf4 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    public String getCategorySize(ProductDTO dto) {
        List<String> ret = Arrays.asList(dto.getClass_cd1(), dto.getClass_cd2(), dto.getClass_cd3(), dto.getClass_cd4());
        String strCategs = "";
        if (YDMASessonUtil.getLoginType() == 2) {
            List result = ret.stream().filter(p -> p != null && !p.isEmpty()).collect(Collectors.toList());
            strCategs = (String)result.get(result.size() - 1);
        } else {
            strCategs = ret.stream().map(n -> String.valueOf(n)).collect(Collectors.joining());
        }
        return strCategs;
    }

    private void getCategory(ProductDTO dto, Cafe24ProductItem cafe24ProductItem, ShoppingmallDTO shoppingMallDetailDto) throws Exception {
        try {
            Response response;
            String strCategs = this.getCategorySize(dto);
            ShopCatInfDto cateDto = ShopCommonDao.get().getShopCateInfName(dto.getClass_nm1(), dto.getShopcd());
            String sendcatno = "";
            ObjectMapper mapper = new ObjectMapper();
            List<String> class_nm = Arrays.asList(dto.getClass_nm1().split(">"));
            String catecd = "1";
            if (cateDto.getShoplagcatcd() == null || cateDto.getShoplagcatcd().equals("")) {
                catecd = this.ShopCategoryCreate(shoppingMallDetailDto, cateDto, mapper, catecd, class_nm, 0);
            } else {
                sendcatno = cateDto.getShoplagcatcd();
                response = this.ShopCategSearch(shoppingMallDetailDto, sendcatno);
                if (response.code() != 200) {
                    catecd = this.ShopCategoryCreate(shoppingMallDetailDto, cateDto, mapper, catecd, class_nm, 0);
                }
            }
            if (cateDto.getShopmidcatcd() == null || cateDto.getShopmidcatcd().equals("")) {
                catecd = cateDto.getShoplagcatcd();
                catecd = this.ShopCategoryCreate(shoppingMallDetailDto, cateDto, mapper, catecd, class_nm, 1);
            } else {
                sendcatno = cateDto.getShopmidcatcd();
                response = this.ShopCategSearch(shoppingMallDetailDto, sendcatno);
                if (response.code() != 200) {
                    catecd = cateDto.getShoplagcatcd();
                    catecd = this.ShopCategoryCreate(shoppingMallDetailDto, cateDto, mapper, catecd, class_nm, 1);
                }
            }
            if (cateDto.getShopsmlcatcd() == null || cateDto.getShopsmlcatcd().equals("")) {
                catecd = cateDto.getShopmidcatcd();
                catecd = this.ShopCategoryCreate(shoppingMallDetailDto, cateDto, mapper, catecd, class_nm, 2);
            } else {
                sendcatno = cateDto.getShopsmlcatcd();
                response = this.ShopCategSearch(shoppingMallDetailDto, sendcatno);
                if (response.code() != 200) {
                    catecd = cateDto.getShopmidcatcd();
                    catecd = this.ShopCategoryCreate(shoppingMallDetailDto, cateDto, mapper, catecd, class_nm, 2);
                }
            }
            if (cateDto.getShopdetcatcd() == null || cateDto.getShopdetcatcd().equals("")) {
                catecd = cateDto.getShopsmlcatcd();
                catecd = this.ShopCategoryCreate(shoppingMallDetailDto, cateDto, mapper, catecd, class_nm, 3);
            } else {
                sendcatno = cateDto.getShopdetcatcd();
                response = this.ShopCategSearch(shoppingMallDetailDto, sendcatno);
                if (response.code() != 200) {
                    catecd = cateDto.getShopsmlcatcd();
                    catecd = this.ShopCategoryCreate(shoppingMallDetailDto, cateDto, mapper, catecd, class_nm, 3);
                }
            }
            cateDto.setShopcatno(strCategs);
            cateDto.setCompno(YDMASessonUtil.getCompnoInfo().getCompno());
            cateDto.setShopcd(shoppingMallDetailDto.getSHOPCD());
            cateDto.setShopcatnm(shoppingMallDetailDto.getSHOPCD() + "_" + class_nm.get(class_nm.size() - 1));
            cateDto.setShopcatsitenm(dto.getClass_nm1());
            List<String> list = this.getProductCategory(cateDto);
            if (list.size() > 0) {
                cafe24ProductItem.request.add_category_no = new ArrayList<CategoryReg>();
                for (String cate : list) {
                    CategoryReg categoryReg = new CategoryReg();
                    categoryReg.category_no = cate;
                    categoryReg.recommend = "F";
                    categoryReg.neW = "F";
                    cafe24ProductItem.request.add_category_no.add(categoryReg);
                }
            }
            ShopProductDao.get().Category(cateDto, dto, class_nm, dto.getGoods_keyword());
        }
        catch (Exception exception) {
            throw new Exception("\uce74\ud14c\uace0\ub9ac \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    public List<String> getProductCategory(ShopCatInfDto dto) {
        List<String> ret = Arrays.asList(dto.getShoplagcatcd(), dto.getShopmidcatcd(), dto.getShopsmlcatcd(), dto.getShopdetcatcd());
        return ret.stream().filter(p -> p != null && !p.isEmpty()).collect(Collectors.toList());
    }

    private Response ShopCategSearch(ShoppingmallDTO shoppingMallDetailDto, String sendcatno) throws IOException {
        try {
            Request request2 = new Request.Builder().url(String.format("https://%s.cafe24api.com/api/v2/admin/categories/%s", shoppingMallDetailDto.getSHOPPINGID(), sendcatno)).addHeader("Authorization", "Bearer " + Cafe24AcessToken.get().getAccessToken(shoppingMallDetailDto)).addHeader("Content-Type", content_type).get().build();
            OkHttpClient client = Cafe24ProductRegService.getUnsafeOkHttpClient();
            Response response = client.newCall(request2).execute();
            return response;
        }
        catch (Exception e) {
            YDMAStringUtil.Print(e.getMessage());
            return null;
        }
    }

    private String ShopCategoryCreate(ShoppingmallDTO shoppingMallDetailDto, ShopCatInfDto cateDto, ObjectMapper mapper, String catecd, List<String> class_nm, int size) throws JsonProcessingException, IOException, Exception {
        int i = size;
        while (i < class_nm.size()) {
            CategoryCreate categoryCreate = new CategoryCreate();
            categoryCreate.request.parent_category_no = Integer.parseInt(catecd);
            categoryCreate.request.category_name = class_nm.get(i);
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            String json = mapper.writeValueAsString((Object)categoryCreate);
            MediaType mediaType = MediaType.parse((String)"");
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)json);
            Request request2 = new Request.Builder().url(String.format("https://%s.cafe24api.com/api/v2/admin/categories", shoppingMallDetailDto.getSHOPPINGID())).addHeader("Authorization", "Bearer " + Cafe24AcessToken.get().getAccessToken(shoppingMallDetailDto)).addHeader("Content-Type", content_type).post(body).build();
            OkHttpClient client = Cafe24ProductRegService.getUnsafeOkHttpClient();
            Response response = client.newCall(request2).execute();
            if (response.code() == 201) {
                String bodycate = response.body().string().toString();
                JsonParser jsonparser = new JsonParser();
                JsonObject jsonobject = (JsonObject)jsonparser.parse(bodycate);
                JsonObject datas = (JsonObject)jsonobject.get("category");
                JsonObject category_no = (JsonObject)datas.get("full_category_no");
                if (i == 0) {
                    catecd = category_no.get("1").getAsString();
                    cateDto.setShoplagcatcd(catecd);
                } else if (i == 1) {
                    catecd = category_no.get("2").getAsString();
                    cateDto.setShopmidcatcd(catecd);
                } else if (i == 2) {
                    catecd = category_no.get("3").getAsString();
                    cateDto.setShopsmlcatcd(catecd);
                } else if (i == 3) {
                    catecd = category_no.get("4").getAsString();
                    cateDto.setShopdetcatcd(catecd);
                }
            } else {
                throw new Exception("\uce74\ud14c\uace0\ub9ac \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
            }
            ++i;
        }
        return catecd;
    }

    private void productBasicInfo(ProductDTO dto, Cafe24ProductItem cafe24ProductItem, ShopCafe24AdditionDto dtllist) throws Exception {
        try {
            cafe24ProductItem.request.custom_product_code = dto.getCompayny_goods_cd();
            String value = "";
            switch (dtllist.getProdoutput()) {
                case "1": {
                    value = dto.getGoods_nm();
                    break;
                }
                case "2": {
                    value = dto.getModel_nm();
                    break;
                }
                case "3": {
                    value = dto.getGoods_nm().concat(" (").concat(dto.getModel_nm()).concat(")");
                    break;
                }
                case "4": {
                    value = dto.getModel_nm().concat(" (").concat(dto.getGoods_nm()).concat(")");
                    break;
                }
                case "5": {
                    value = dto.getGoods_nm().concat(" ").concat(dto.getModel_nm());
                    break;
                }
                case "6": {
                    value = dto.getModel_nm().concat(" ").concat(dto.getGoods_nm());
                    break;
                }
                default: {
                    value = dto.getGoods_nm();
                }
            }
            if (!dtllist.getProdnmfront().equals("")) {
                value = dtllist.getProdnmfront().concat(value);
            }
            if (!dtllist.getProdnmend().equals("")) {
                value = value.concat(" ").concat(dtllist.getProdnmend());
            }
            if (dtllist.getProdnmafter().equals("Y")) {
                value = ShopCommon.setAddKeywordInProdName(value, dto.getGoods_search(), "B", 250);
            }
            if (dtllist.getProdnmrand().equals("Y")) {
                value = ShopCommon.setWordRandomGenerator(value);
            }
            String sellerProductName = dto.getProdnmlenyn().equals("Y") ? YDMAStringUtil.setTextStrtok(value, 250) : value;
            cafe24ProductItem.request.product_name = sellerProductName;
            cafe24ProductItem.request.eng_product_name = dto.getGoods_nm_en();
            cafe24ProductItem.request.supply_product_name = dto.getGoods_nm();
            cafe24ProductItem.request.internal_product_name = dto.getGoods_nm();
            cafe24ProductItem.request.model_name = dto.getCompayny_goods_cd();
        }
        catch (Exception exception) {
            throw new Exception("\uc0c1\ud488\uba85 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private ResultMarketPrice getMarketPrice(ProductDTO dto, ShopCafe24AdditionDto dtllist, Cafe24ProductItem cafe24ProductItem, ResultMarketPrice resultMarketPrice) throws Exception {
        try {
            Long salePrice = YDMAStringUtil.convertToLong(dto.getGoods_cost());
            if (dtllist.getDeliveryfeetype().equals("T") && dtllist.getFreedelivery().equals("T")) {
                int deliveryFee;
                if (dtllist.getExpprc() == 9999) {
                    if (!dto.getDelv_cost().equals("0")) {
                        deliveryFee = Integer.parseInt(dto.getDelv_cost());
                    } else {
                        PreferencesMallDTO systemconf = ShopCommonDao.get().getSystemConf();
                        deliveryFee = systemconf.getDELIVERYCOST();
                    }
                } else {
                    deliveryFee = dtllist.getExpprc();
                }
                salePrice = salePrice + (long)deliveryFee;
            }
            int limit_price = YDMAStringUtil.convertToInt(dto.getLimit_price());
            resultMarketPrice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
            if (salePrice > YDMAStringUtil.convertToLong(resultMarketPrice.getConsumer_if_sale_price())) {
                resultMarketPrice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
            }
            cafe24ProductItem.request.price = resultMarketPrice.getConsumer_if_sale_price();
            cafe24ProductItem.request.retail_price = "0";
            cafe24ProductItem.request.supply_price = resultMarketPrice.getConsumer_if_sale_price();
            dto.setGoods_price(resultMarketPrice.getConsumer_if_sale_price());
            dto.setMarket_price(resultMarketPrice.getConsumer_if_sale_price());
            dto.setGoods_consumer_price(resultMarketPrice.getConsumer_if_sale_price());
        }
        catch (Exception exception) {
            throw new Exception("\ud310\ub9e4\uac00 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        return resultMarketPrice;
    }

    private void getImage(Cafe24ProductItem cafe24ProductItem, ProductDTO dto, ShopCafe24AdditionDto dtllist, ShoppingmallDTO shoppingMallDetailDto) throws Exception {
        try {
            String imgpath = "";
            if (dto.getGoods_keyword().equals("shop0319")) {
                List<String> strImages = this.getProductImages(dto);
                imgpath = strImages.get(0);
            } else {
                imgpath = ShopCommon.getImgLocalPath(dto.getImg_path());
            }
            File f = new File(imgpath);
            FileInputStream fis = new FileInputStream(f);
            byte[] byteArray = new byte[(int)f.length()];
            fis.read(byteArray);
            String imageString = Base64.getEncoder().encodeToString(byteArray);
            StringBuffer payload = new StringBuffer();
            payload.append("{ \"requests\": [\n");
            payload.append("\n");
            payload.append("{\n");
            payload.append("\"image\":\"" + imageString + "\"");
            payload.append("}\n");
            payload.append("\n");
            payload.append("] }");
            MediaType mediaType = MediaType.parse((String)"");
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)payload.toString());
            Request request2 = new Request.Builder().url(String.format("https://%s.cafe24api.com/api/v2/admin/products/images", shoppingMallDetailDto.getSHOPPINGID())).addHeader("Authorization", "Bearer " + Cafe24AcessToken.get().getAccessToken(shoppingMallDetailDto)).addHeader("Content-Type", content_type).post(body).build();
            OkHttpClient client = Cafe24ProductRegService.getUnsafeOkHttpClient();
            Response response = client.newCall(request2).execute();
            String data2 = response.body().string().toString();
            JsonParser jsonparser = new JsonParser();
            JsonObject jsonobject = (JsonObject)jsonparser.parse(data2);
            JsonArray images = (JsonArray)jsonobject.get("images");
            JsonObject object = (JsonObject)images.get(0);
            String image = object.get("path").getAsString();
            cafe24ProductItem.request.detail_image = image = image.substring(image.indexOf("/web"), image.length());
        }
        catch (Exception exception) {
            throw new Exception("\uc774\ubbf8\uc9c0 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void remarkNservice(ProductDTO dto, Cafe24ProductItem cafe24ProductItem, ShopCafe24AdditionDto dtllist) throws Exception {
        try {
            Object remark = "";
            ShopProductDao.get().setNotice(dto, dto.getShopProdAttrnmDtos());
            List noticeDto = dto.getShopProdAttrnmDtos().stream().filter(d -> !d.getProp_val().equals("")).collect(Collectors.toList());
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < noticeDto.size()) {
                sb.append(((ShopProdAttrnmDto)noticeDto.get(i)).getAttrnm() + " : " + ((ShopProdAttrnmDto)noticeDto.get(i)).getProp_val());
                sb.append("\n");
                ++i;
            }
            remark = dtllist.getDetailexplain().equals("2") ? sb.toString() + dto.getGoods_remarks() : (dtllist.getDetailexplain().equals("3") ? dto.getGoods_remarks() + sb.toString() : dto.getGoods_remarks());
            if (dtllist.getProddetailoutput().equals("1")) {
                remark = dtllist.getProddetailfront().concat((String)remark).concat(dtllist.getProddetailend());
            } else if (dtllist.getProddetailoutput().equals("2")) {
                dto.setGoods_remarks2(dtllist.getProddetailfront().concat(dto.getGoods_remarks2()).concat(dtllist.getProddetailend()));
            } else if (dtllist.getProddetailoutput().equals("3")) {
                dto.setGoods_remarks3(dtllist.getProddetailfront().concat(dto.getGoods_remarks3()).concat(dtllist.getProddetailend()));
            }
            if (dtllist.getRemarktop().equals("Y")) {
                remark = "<h2 style='font-size:16px;font-weight: bold;font-family: Dotum;text-align: center;'>\uc0c1\ud488\uba85 : " + dto.getGoods_nm() + "</h2>".concat((String)remark);
            }
            cafe24ProductItem.request.description = remark;
            cafe24ProductItem.request.summary_description = dto.getGoods_remarks2();
            ArrayList<String> list = new ArrayList<String>();
            ArrayList<String> removetag = new ArrayList<String>();
            List<String> search = new ArrayList<String>();
            if (dto.getExcepkeywdyn().equals("Y")) {
                removetag.addAll(Arrays.asList(dto.getExcepkeywd().split(",")));
                list.addAll(Arrays.asList(dto.getGoods_search().split(",")));
                search = IProduct.checkSearch(list, removetag, search);
            } else {
                search.addAll(Arrays.asList(dto.getGoods_search().split(",")));
            }
            cafe24ProductItem.request.product_tag = search.stream().collect(Collectors.joining(","));
            cafe24ProductItem.request.payment_info = dtllist.getPayinfo();
            cafe24ProductItem.request.shipping_info = dtllist.getShippinginfo();
            cafe24ProductItem.request.exchange_info = dtllist.getExchretinfo();
            cafe24ProductItem.request.service_info = dtllist.getServiceinfo();
        }
        catch (Exception exception) {
            throw new Exception("\uc0c1\uc138\uc124\uba85, \uc548\ub0b4 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void getOrginNMaterial(ProductDTO dto, ShopCafe24AdditionDto dtllist, Cafe24ProductItem cafe24ProductItem) throws Exception {
        try {
            cafe24ProductItem.request.origin_classification = "E";
            cafe24ProductItem.request.origin_place_value = dto.getOrigin();
            cafe24ProductItem.request.tax_type = dtllist.getTaxrating();
            cafe24ProductItem.request.tax_amount = "10";
            cafe24ProductItem.request.tax_amount = dtllist.getTaxrating1();
            cafe24ProductItem.request.adult_certification = dtllist.getAdultcheck();
        }
        catch (Exception exception) {
            throw new Exception("\uc6d0\uc0b0\uc9c0, \uc131\uc778\uc5ec\ubd80, \uacfc\uc138 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void shopPoint(ShopCafe24AdditionDto dtllist, Cafe24ProductItem cafe24ProductItem) throws Exception {
        try {
            cafe24ProductItem.request.points_by_product = "F";
        }
        catch (Exception exception) {
            throw new Exception("\ud3ec\uc778\ud2b8 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private List<String> getPoint(ShopCafe24AdditionDto dtllist, int i) {
        ArrayList<String> pnt = new ArrayList<String>();
        switch (i) {
            case 0: {
                pnt.add("cash");
                pnt.add(dtllist.getMileage3());
                pnt.add(dtllist.getMileage());
                break;
            }
            case 1: {
                pnt.add("card");
                pnt.add(dtllist.getMileage5());
                pnt.add(dtllist.getMileage6());
                break;
            }
            case 2: {
                pnt.add("tcash");
                pnt.add(dtllist.getMileage9());
                pnt.add(dtllist.getMileage10());
                break;
            }
            case 3: {
                pnt.add("mileage");
                pnt.add(dtllist.getMileage7());
                pnt.add(dtllist.getMileage8());
                break;
            }
            case 4: {
                pnt.add("cell");
                pnt.add(dtllist.getMileage11());
                pnt.add(dtllist.getMileage12());
                break;
            }
            case 5: {
                pnt.add("deposit");
                pnt.add(dtllist.getMileage13());
                pnt.add(dtllist.getMileage14());
            }
        }
        return pnt;
    }

    private void salesMaximumQty(ShopCafe24AdditionDto dtllist, Cafe24ProductItem cafe24ProductItem) throws Exception {
        try {
            if (dtllist.getSellpricereplace().equals("T")) {
                cafe24ProductItem.request.price_content = dtllist.getSellpricereplace1();
            }
            cafe24ProductItem.request.buy_limit_by_product = "F";
            cafe24ProductItem.request.order_quantity_limit_type = "P";
            cafe24ProductItem.request.minimum_quantity = dtllist.getProductmin().equals("") ? "1" : dtllist.getProductmin();
            cafe24ProductItem.request.maximum_quantity = dtllist.getProductmaxtype().equals("T") ? dtllist.getProductmax() : "0";
        }
        catch (Exception exception) {
            throw new Exception("\uad6c\ub9e4\uc81c\ud55c, \uc8fc\ubb38\uc218\ub7c9 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private String getApiJsonString(ProductDTO dto, ShopCafe24AdditionDto dtllist, ShoppingmallDTO shoppingMallDetailDto) throws Exception {
        Cafe24ProductItem cafe24ProductItem = new Cafe24ProductItem();
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        ResultMarketPrice resultMarketPrice = new ResultMarketPrice();
        cafe24ProductItem.shop_no = "1";
        cafe24ProductItem.request.display = "T";
        cafe24ProductItem.request.selling = "T";
        cafe24ProductItem.request.product_condition = "N";
        dto.setSaleenddt("2999-12-31");
        this.getCategory(dto, cafe24ProductItem, shoppingMallDetailDto);
        this.productBasicInfo(dto, cafe24ProductItem, dtllist);
        resultMarketPrice = this.getMarketPrice(dto, dtllist, cafe24ProductItem, resultMarketPrice);
        this.getOption(dto, cafe24ProductItem, resultMarketPrice);
        this.getCode(dtllist, cafe24ProductItem);
        try {
            cafe24ProductItem.request.release_date = dtllist.getReleasedate();
            if (dtllist.getExpirationdate().equals("T")) {
                cafe24ProductItem.request.expiration_date.start_date = dtllist.getPrstartdate();
                cafe24ProductItem.request.expiration_date.end_date = dtllist.getPrenddate();
            }
        }
        catch (Exception exception) {
            throw new Exception("\ucd9c\uc2dc\uc77c\uc790, \uc720\ud6a8\uae30\uac04 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        this.remarkNservice(dto, cafe24ProductItem, dtllist);
        this.getDelvExpress(dtllist, cafe24ProductItem, dto);
        this.getImage(cafe24ProductItem, dto, dtllist, shoppingMallDetailDto);
        this.salesMaximumQty(dtllist, cafe24ProductItem);
        this.shopPoint(dtllist, cafe24ProductItem);
        this.getOrginNMaterial(dto, dtllist, cafe24ProductItem);
        mapper.setVisibilityChecker(mapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
        String json = mapper.writeValueAsString((Object)cafe24ProductItem);
        json = json.replace("neW", "new");
        YDMAStringUtil.Print(json);
        return json;
    }

    @Override
    public Map<String, String> loginCookie(String loginID, String password, String shopcd, boolean flag, String authkey) throws Exception {
        String key = "";
        ChromeDriver driver = null;
        try {
            switch (shopcd) {
                case "shop0110": {
                    key = String.format("%s%s%s", loginID, password, LocalDate.now());
                    if (cokieManager.get(key) != null) {
                        Map map = (Map)cokieManager.get(key);
                        return map;
                    }
                    driver = this.loginCafe24(loginID, password, flag, shopcd);
                }
            }
            if (cokieManager.get(key) == null) {
                throw new Exception("\ub85c\uadf8\uc778 \uc0ac\uc6a9\uc790 \uc544\uc774\ub514 \ud328\uc2a4\uc6cc\ub4dc\ub97c \ud655\uc778\ud574 \uc8fc\uc138\uc694");
            }
            Map map = (Map)cokieManager.get(key);
            return map;
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        finally {
            if (driver != null) {
                driver.close();
                driver.quit();
            }
        }
    }

    @Override
    public ShopProductSendDto excute(ShopProductSendDto sendProdList) throws Exception {
        ShoppingmallDTO shopInfo = sendProdList.getShoppingmallDTO();
        YDMAStringUtil.Print();
        List<ProductDTO> prodList = sendProdList.getShopProductDto();
        ShopCafe24AdditionDto dtllist = (ShopCafe24AdditionDto)sendProdList.getProductAdditionDto();
        String uuid = sendProdList.getWorkgrp();
        WorkMngDto workMngDto = sendProdList.getWorkMngDto();
        if (!ShopWorkDataQueue.get().isExistGrp(uuid)) {
            workMngDto.setWork_status("W02");
            WorkMngDao.get().saveMst(uuid, sendProdList.getWorkMngDto());
            return sendProdList;
        }
        try {
            String.format("(%s) %s", shopInfo.getSHOPNM(), shopInfo.getSHOPPINGID());
            PreferencesMallDTO dto1 = ShopCommonDao.get().getSystemConf();
            int mod = dto1.getPROCCNT() / prodList.size();
            int progress = workMngDto.getProgress_rate();
            List<WorkMngDetailDto> workMngDetailDtos = workMngDto.getWork_detail();
            workMngDto.setWork_status("W06");
            WorkMngDao.get().saveMst(uuid, sendProdList.getWorkMngDto());
            for (ProductDTO dto : prodList) {
                workMngDto.setProgress_rate(progress += mod);
                workMngDto.setWork_status("W08");
                ShopWorkDataQueue.get().notifyObservers();
                ShopCommon.downloadImgFile(dto.getImg_path());
                WorkMngDetailDto workMngDetailDto = workMngDetailDtos.stream().filter(p -> p.getProdseq().equals(dto.getCompayny_goods_cd())).findAny().orElse(null);
                if (!ShopWorkDataQueue.get().isExistGrp(uuid)) {
                    workMngDetailDto.setStatus("W02");
                    workMngDetailDto.setMessage("\ucde8\uc18c \ucc98\ub9ac \ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                    WorkMngDao.get().saveDtl(uuid, workMngDetailDto);
                    continue;
                }
                if (workMngDetailDto.getStatus().equals("W06")) continue;
                if (workMngDto.getWork_status().equals("W02")) {
                    ShopProductSendDto shopProductSendDto = sendProdList;
                    return shopProductSendDto;
                }
                try {
                    try {
                        boolean isExitsProd = this.isExitsProductCd(shopInfo, dto);
                        if (isExitsProd) {
                            workMngDto.setWork_status("-1");
                            workMngDetailDto.setStatus("-1");
                            workMngDetailDto.setMessage("\uc0c1\ud488\ub4f1\ub85d\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4. \ub9c8\ucf13\uc5d0 \uac19\uc740 \uc0c1\ud488\uc774  \uc874\uc7ac\ud558\uace0 \uc788\uc2b5\ub2c8\ub2e4. \uc0ad\uc81c\ud6c4\uc5d0 \uc7ac\ub4f1\ub85d\ud558\uc5ec \uc8fc\uc2dc\uae30 \ubc14\ub78d\ub2c8\ub2e4.");
                            dto.setResult_code("-1");
                            dto.setResult_text("\uc0c1\ud488\ub4f1\ub85d\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4. \ub9c8\ucf13\uc5d0 \uac19\uc740 \uc0c1\ud488\uc774  \uc874\uc7ac\ud558\uace0 \uc788\uc2b5\ub2c8\ub2e4. \uc0ad\uc81c\ud6c4\uc5d0 \uc7ac\ub4f1\ub85d\ud558\uc5ec \uc8fc\uc2dc\uae30 \ubc14\ub78d\ub2c8\ub2e4.");
                            WorkMngDao.get().saveDtl(uuid, workMngDetailDto);
                            continue;
                        }
                        String json = this.getApiJsonString(dto, dtllist, shopInfo);
                        Response result = this.postProductReg(json, shopInfo);
                        if (result.code() == 201) {
                            String jsonData = result.body().string().toString();
                            JsonParser jsonparser = new JsonParser();
                            JsonObject jsonobject = (JsonObject)jsonparser.parse(jsonData);
                            JsonObject data2 = (JsonObject)jsonobject.get("product");
                            String code = data2.get("product_no").getAsString();
                            dto.setResult_code("1");
                            workMngDetailDto.setStatus("W06");
                            workMngDetailDto.setMessage(shopInfo.getSHOPNM() + "\uc5d0 \uc0c1\ud488\uc774 \uc815\uc0c1\uc801\uc73c\ub85c \ub4f1\ub85d \ub418\uc5c8\uc2b5\ub2c8\ub2e4 [\uc0c1\ud488\ubc88\ud638 : " + code + " ]");
                            dto.setShopprodno(code);
                            dto.setResult_text(shopInfo.getSHOPNM() + "\uc5d0 \uc0c1\ud488\uc774 \uc815\uc0c1\uc801\uc73c\ub85c \ub4f1\ub85d \ub418\uc5c8\uc2b5\ub2c8\ub2e4 [\uc0c1\ud488\ubc88\ud638 : " + code + " ]");
                            sendProdList.setShopProductDto(Arrays.asList(dto));
                            WorkMngDao.get().saveProductIn(sendProdList);
                            result.body().close();
                        } else {
                            workMngDto.setWork_status("-1");
                            workMngDetailDto.setStatus("-1");
                            workMngDetailDto.setMessage(result.message());
                            dto.setResult_code("-1");
                            dto.setResult_text(result.message());
                        }
                        WorkMngDao.get().saveDtl(uuid, workMngDetailDto);
                    }
                    catch (Exception e) {
                        workMngDto.setWork_status("-1");
                        workMngDetailDto.setStatus("-1");
                        workMngDetailDto.setMessage(e.getMessage());
                        dto.setResult_code("-1");
                        dto.setResult_text(e.getMessage());
                        WorkMngDao.get().saveDtl(uuid, workMngDetailDto);
                    }
                    continue;
                }
                catch (Exception exception) {
                    workMngDto.setWork_status("-1");
                }
                break;
            }
        }
        finally {
            WorkMngDao.get().saveMst(uuid, sendProdList.getWorkMngDto());
        }
        return sendProdList;
    }

    private boolean isExitsProductCd(ShoppingmallDTO shoppingMallDetailDto, ProductDTO dto) {
        Response response = null;
        try {
            OkHttpClient client = Cafe24ProductRegService.getUnsafeOkHttpClient();
            Request request2 = new Request.Builder().url(String.format("https://%s.cafe24api.com/api/v2/admin/products?custom_product_code=%s", shoppingMallDetailDto.getSHOPPINGID(), dto.getCompayny_goods_cd())).addHeader("Authorization", "Bearer " + Cafe24AcessToken.get().getAccessToken(shoppingMallDetailDto)).addHeader("Content-Type", content_type).get().build();
            response = client.newCall(request2).execute();
            String data2 = response.body().string().toString();
            JsonParser jsonparser = new JsonParser();
            JsonObject jsonobject = (JsonObject)jsonparser.parse(data2);
            JsonArray product2 = (JsonArray)jsonobject.get("products");
            if (product2.size() > 0) {
                return true;
            }
        }
        catch (Exception e) {
            YDMAStringUtil.Print("Error : " + e.getMessage());
        }
        return false;
    }

    private Response postProductReg(String json, ShoppingmallDTO shoppingMallDetailDto) throws Exception {
        Response response = this.useBearerToken(Cafe24AcessToken.get().getAccessToken(shoppingMallDetailDto), json, shoppingMallDetailDto);
        return response;
    }

    public Response useBearerToken(String bearerToken, String json, ShoppingmallDTO shoppingMallDetailDto) {
        Response response = null;
        try {
            MediaType mediaType = MediaType.parse((String)"");
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)json);
            Request request2 = new Request.Builder().url(String.format("https://%s.cafe24api.com/api/v2/admin/products", shoppingMallDetailDto.getSHOPPINGID())).addHeader("Authorization", "Bearer " + bearerToken).addHeader("Content-Type", content_type).post(body).build();
            OkHttpClient client = Cafe24ProductRegService.getUnsafeOkHttpClient();
            response = client.newCall(request2).execute();
        }
        catch (Exception e) {
            YDMAStringUtil.Print("Error : " + e.getMessage());
        }
        return response;
    }

    @Override
    public ShopProductSendDto complate(ShopProductSendDto prodList) throws Exception {
        return null;
    }

    private static final class Cafe24Addinfo {
        private String key;
        private String value;

        private Cafe24Addinfo() {
        }
    }

    private static final class Cafe24Date {
        private String start_date;
        private String end_date;

        private Cafe24Date() {
        }
    }

    private static final class Cafe24Icon {
        private String icon;

        private Cafe24Icon() {
        }
    }

    private static final class Cafe24Option {
        private String name;
        private List<String> value;

        private Cafe24Option() {
        }
    }

    private static final class Cafe24Period {
        private String minimum;
        private String maximum;

        private Cafe24Period() {
        }
    }

    private static final class Cafe24Point {
        private String payment_method;
        private String points_rate;
        private String points_unit_by_payment;

        private Cafe24Point() {
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    private static class Cafe24ProductItem {
        private String shop_no;
        private request request = new request();

        private Cafe24ProductItem() {
        }

        public request getRequest() {
            return this.request;
        }

        public void setRequest(request request2) {
            this.request = request2;
        }
    }

    private static final class Cafe24Rates {
        private String shipping_rates_min;
        private String shipping_rates_max;
        private String shipping_fee;

        private Cafe24Rates() {
        }
    }

    private static final class Cafe24Volume {
        private String use_product_volume;
        private String product_width;
        private String product_height;
        private String product_length;

        private Cafe24Volume() {
        }
    }

    private static final class Cafe24relational {
        private String product_no;
        private String interrelated;

        private Cafe24relational() {
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    private static class CategoryCreate {
        @JsonProperty(value="shop_no")
        private int shop_no = 1;
        @JsonProperty(value="request")
        private Requests request = new Requests();

        private CategoryCreate() {
        }
    }

    private static final class CategoryReg {
        private String category_no;
        private String recommend;
        private String neW;

        private CategoryReg() {
        }
    }

    private static class Options {
        ChromeDriver driver;
        List<ShopOptionDto> options;
        ProductDTO dto;
        private static Options instance = new Options();
        int rowNum = 0;
        ArrayList<String> popupEx;

        private Options() {
        }
    }

    private static final class ProductBaseInfo {
        ChromeDriver driver;
        private static ProductBaseInfo instance = new ProductBaseInfo();
        private ShopProductCafe24AdditionDto dtllist;
        private ProductDTO dto;

        private ProductBaseInfo() {
        }

        public static ProductBaseInfo get(ShopProductCafe24AdditionDto dtllist, ProductDTO dto, ChromeDriver driver) {
            ProductBaseInfo.instance.driver = driver;
            ProductBaseInfo.instance.dtllist = dtllist;
            ProductBaseInfo.instance.dto = dto;
            return instance;
        }

        public void setProductInfo() throws Exception {
            try {
                this.driver.executeScript(String.format("$(\"#product_name\").val(\"%s\");", this.dto.getGoods_nm()), new Object[]{""});
                String modelnm = !this.dto.getModel_nm().equals("") ? this.dto.getModel_nm() : "";
                this.driver.executeScript(String.format("$('#eProductModelName').val('%s');", modelnm), new Object[]{""});
                this.driver.executeScript(String.format("$(\"#ma_product_code\").val('%s');", this.dto.getCompayny_goods_cd()), new Object[]{""});
                String prodstat = this.dtllist.getProdstats().equals("0") ? "N" : (this.dtllist.getProdstats().equals("1") ? "U" : (this.dtllist.getProdstats().equals("2") ? "B" : (this.dtllist.getProdstats().equals("3") ? "R" : (this.dtllist.getProdstats().equals("4") ? "R" : (this.dtllist.getProdstats().equals("5") ? "E" : (this.dtllist.getProdstats().equals("6") ? "F" : "S"))))));
                this.driver.executeScript(String.format("$(\"#prd_used_type\").val('%s');", prodstat), new Object[]{""});
                this.driver.executeScript("$('#nnedit').click();", new Object[]{""});
                this.driver.executeScript("$('div[rel=\"viewSrc\"]:eq(0)').click()", new Object[]{""});
                ChromeScript.get().until((WebDriver)this.driver, () -> this.driver.findElementById("product_description_IFRAME"));
                this.driver.switchTo().frame(1);
                WebElement elementloginBox = ChromeScript.get().until((WebDriver)this.driver, () -> this.driver.findElement(By.xpath((String)"/html/body")));
                elementloginBox.findElement(By.tagName((String)"p")).sendKeys(new CharSequence[]{this.dto.getGoods_remarks()});
                this.driver.switchTo().defaultContent();
                this.driver.executeScript(String.format("$('input[name=\"product_tag\"]').val(\"%s\");", this.dto.getGoods_search()), new Object[]{""});
            }
            catch (Exception exception) {
                throw new Exception("C0012");
            }
        }

        private void setImportDec() throws Exception {
            try {
                this.driver.executeScript(String.format("$('input[name=\"product_custom[1]\"]').val('%s');", this.dto.getGoods_price()), new Object[]{""});
                this.driver.executeScript(String.format("$(\"#product_buy\").val('%s');", this.dto.getGoods_price()), new Object[]{""});
                String tax = this.dto.getTax_yn().equals("1") ? "0" : "2";
                this.driver.executeScript(String.format("$('input[name=\"product_tax_type\"]:eq(%s)').click();", tax), new Object[]{""});
                this.driver.executeScript(String.format("$(\"#product_price\").val('%s');", this.dto.getGoods_price()), new Object[]{""});
                this.driver.executeScript("SALES.calcProductPriceSetAll('1')", new Object[]{""});
                String ordertype = this.dtllist.getOrderqtytype().equals("0") ? "P" : "O";
                this.driver.executeScript(String.format("$('select[name=\"order_limit_type\"]').val(\"%s\");", ordertype), new Object[]{""});
                String minimum = this.dtllist.getMinimumqty().equals("0") ? "1" : this.dtllist.getMinimumqty();
                this.driver.executeScript(String.format("$(\"#product_min\").val('%s');", minimum), new Object[]{""});
                String maxtype = this.dtllist.getMaximumtype().equals("02") ? "1" : "0";
                this.driver.executeScript(String.format("$('input[name=\"product_max_type\"]:eq(%s)').click();", maxtype), new Object[]{""});
                if (maxtype.equals("1")) {
                    this.driver.executeScript(String.format("$(\"#product_max\").val(%s);", this.dtllist.getMaximumqty()), new Object[]{""});
                }
                String mino = this.dtllist.getMinorselcnyn().equals("01") ? "0" : "1";
                this.driver.executeScript(String.format("$('input[name=\"is_adult\"]:eq(%s)').click();", mino), new Object[]{""});
            }
            catch (Exception exception) {
                throw new Exception("C0013");
            }
        }

        private void setProductImage() throws Exception {
            try {
                ChromeScript.get().addScript("function performClick(elemId) {\r\n   var elem = document.getElementById(elemId);\r\n   if(elem && document.createEvent) {\r\n      var evt = document.createEvent(\"MouseEvents\");\r\n      evt.initEvent(\"click\", true, false);\r\n      elem.dispatchEvent(evt);\r\n   }\r\n}").addScript("\r\n").addScript("performClick(\"imageFiles\");").executeScripter(this.driver);
                if (!ShopCommon.isUrlFileExits(this.dto.getImg_path())) {
                    ShopCommon.downloadImgFile(this.dto.getImg_path());
                    Thread.sleep(2000L);
                }
                String imgpath = ShopCommon.getImgLocalPath(this.dto.getImg_path());
                this.driver.findElementById("imageFiles").sendKeys(new CharSequence[]{imgpath});
            }
            catch (Exception exception) {
                throw new Exception("C0007");
            }
        }

        public void setTemplete() throws Exception {
            try {
                this.driver.executeScript("$(\"#manufacture\").click();", new Object[]{""});
                if (!this.dtllist.getManfnm().equals("")) {
                    this.driver.executeScript(String.format("document.querySelector('#manufacturerInfoData_chzn > div > div > input[type=text]:nth-child(2)').value='%s';", this.dtllist.getManfnm()), new Object[]{""});
                }
                if (!this.dtllist.getSupplier().equals("")) {
                    this.driver.executeScript(String.format("document.querySelector('#manufacturerInfoData_chzn > div > div > input[type=text]:nth-child(2)').value='%s';", this.dtllist.getSupplier()), new Object[]{""});
                }
                if (!this.dtllist.getBrandnm().equals("")) {
                    this.driver.executeScript(String.format("document.querySelector('#manufacturerInfoData_chzn > div > div > input[type=text]:nth-child(2)').value='%s';", this.dtllist.getBrandnm()), new Object[]{""});
                }
                if (!this.dtllist.getTrendnm().equals("")) {
                    this.driver.executeScript(String.format("document.querySelector('#manufacturerInfoData_chzn > div > div > input[type=text]:nth-child(2)').value='%s';", this.dtllist.getTrendnm()), new Object[]{""});
                }
            }
            catch (Exception exception) {
                throw new Exception("C0014");
            }
        }

        public void setExpress() throws Exception {
            try {
                this.driver.executeScript("$(\"#delivery\").click();", new Object[]{""});
                String homeNabro = this.dtllist.getHomenabroship().equals("02") ? "1" : (this.dtllist.getHomenabroship().equals("03") ? "2" : "0");
                this.driver.executeScript(String.format("$('input[name=\"delivery_scope\"]:eq(%s)').click();", homeNabro), new Object[]{""});
                if (this.dtllist.getShippinginfo().equals("02")) {
                    this.driver.executeScript("$('input[name=\"use_individual_ship_config\"]:eq(1)').click();", new Object[]{""});
                    YDMAStringUtil.Print();
                    String expmethod = "0" + (Integer.parseInt(this.dtllist.getShippingmethod()) + 1);
                    this.driver.executeScript(String.format("$('select[name=\"delivery_method\"]').val('%s');", expmethod), new Object[]{""});
                    this.driver.executeScript(String.format("$('input[name=\"delivery_place\"]').val('%s');", this.dtllist.getShippingarea()), new Object[]{""});
                    String from = String.valueOf(Integer.parseInt(this.dtllist.getDelvperiodfrom()) + 1);
                    String to = String.valueOf(Integer.parseInt(this.dtllist.getDelvperiodto()) + 1);
                    this.driver.executeScript(String.format("$('select[name=\"delivery_start\"]').val('%s');", from), new Object[]{""});
                    this.driver.executeScript(String.format("$('select[name=\"delivery_end\"]').val('%s');", to), new Object[]{""});
                    String delvcosttyp = this.dtllist.getDelvcostmethod().equals("0") ? "T" : (this.dtllist.getDelvcostmethod().equals("1") ? "R" : (this.dtllist.getDelvcostmethod().equals("2") ? "M" : (this.dtllist.getDelvcostmethod().equals("3") ? "D" : (this.dtllist.getDelvcostmethod().equals("5") ? "W" : (this.dtllist.getDelvcostmethod().equals("6") ? "C" : (this.dtllist.getDelvcostmethod().equals("8") ? "N" : ""))))));
                    this.driver.executeScript(String.format("$('select[name=\"delivery_fee_type\"]').val('%s').change();", delvcosttyp), new Object[]{""});
                    if (!delvcosttyp.equals("T")) {
                        Object len = this.driver.executeScript("return $('#delivery_type" + delvcosttyp + " input[type=\"text\"]').size()", new Object[]{""});
                        int num = Integer.parseInt(len.toString());
                        switch (num) {
                            case 1: {
                                this.driver.executeScript(String.format("$('#delivery_type" + delvcosttyp + " input[type=\"text\"]:eq(0)').val('%s')", this.dtllist.getDelvcost1()), new Object[]{""});
                                break;
                            }
                            case 2: {
                                this.driver.executeScript(String.format("$('#delivery_type" + delvcosttyp + " input[type=\"text\"]:eq(0)').val('%s')", this.dtllist.getDelvcost1()), new Object[]{""});
                                this.driver.executeScript(String.format("$('#delivery_type" + delvcosttyp + " input[type=\"text\"]:eq(1)').val('%s')", this.dtllist.getDelvcost2()), new Object[]{""});
                                break;
                            }
                            case 3: {
                                this.driver.executeScript(String.format("$('#delivery_type" + delvcosttyp + " input[type=\"text\"]:eq(0)').val('%s')", this.dtllist.getDelvcost1()), new Object[]{""});
                                this.driver.executeScript(String.format("$('#delivery_type" + delvcosttyp + " input[type=\"text\"]:eq(1)').val('%s')", this.dtllist.getDelvcost2()), new Object[]{""});
                                this.driver.executeScript(String.format("$('#delivery_type" + delvcosttyp + " input[type=\"text\"]:eq(2)').val('%s')", this.dtllist.getDelvcost3()), new Object[]{""});
                                break;
                            }
                        }
                        String cost = this.dtllist.getDelvfeesetup().equals("01") ? "0" : (this.dtllist.getDelvfeesetup().equals("3") ? "2" : "1");
                        this.driver.executeScript(String.format("$('input[name=\"delivery_cost_prepaid\"]:eq(%s)').click();", cost), new Object[]{""});
                    }
                    String shippingtype = this.dtllist.getShippingtype().equals("01") ? "0" : (this.dtllist.getShippingtype().equals("3") ? "2" : "1");
                    this.driver.executeScript(String.format("$('input[name=\"supplier_trading_type\"]:eq(%s)').click();", shippingtype), new Object[]{""});
                    if (shippingtype.equals("2")) {
                        this.driver.executeScript("$('input[name=\"warehouse\"]').val('1');", new Object[]{""});
                    }
                } else {
                    this.driver.executeScript("$('input[name=\"use_individual_ship_config\"]:eq(0)').click();", new Object[]{""});
                }
            }
            catch (Exception exception) {
                throw new Exception("C0010");
            }
        }
    }

    private static final class ProductNotice {
        ChromeDriver driver;
        private static ProductNotice instance = new ProductNotice();
        private List<ShopProdAttrnmDto> shopProdAttrnmDto;
        ProductDTO dto;

        private ProductNotice() {
        }

        public static ProductNotice get(ProductDTO dto) throws Exception {
            ProductNotice.instance.driver = ChromeExtention.getInstace().getDriver();
            dto.getProp1_cd();
            new ProductIforDao();
            ProductNotice.instance.dto = dto;
            return instance;
        }
    }

    private static final class ProductSaleInfo {
        ChromeDriver driver;
        private static ProductSaleInfo instance = new ProductSaleInfo();
        ProductDTO dto;
        ShopProductAdditionDto dtllist;

        private ProductSaleInfo() {
        }

        public static ProductSaleInfo get(ShopProductAdditionDto dtllist, ProductDTO dto, ChromeDriver driver) throws Exception {
            ProductSaleInfo.instance.driver = driver;
            ProductSaleInfo.instance.dto = dto;
            ProductSaleInfo.instance.dtllist = dtllist;
            return instance;
        }

        public void setOptions(List<ShopOptionDto> options, ChromeDriver driver) throws Exception {
            try {
                String char1nm = this.dto.getChar_1_nm().equals("\ub2e8\ud488") ? "1" : "0";
                driver.executeScript(String.format("$('input[name=\"has_option\"]:eq(%s)').click().change();", char1nm), new Object[]{""});
                Thread.sleep(1000L);
                if (char1nm.equals("0")) {
                    driver.executeScript("$('#eUseOptionSetF').click();", new Object[]{""});
                    Thread.sleep(1000L);
                    driver.executeScript(String.format("$('input[name=\"option[0]\"]').val('%s');", this.dto.getChar_1_nm()), new Object[]{""});
                    Thread.sleep(1000L);
                    List items = options.stream().map(p -> p.getName().split(":")).map(p -> ((String[])p).length == 2 ? new CodeItem(p[1], p[0]) : new CodeItem("", p[0])).collect(Collectors.toList());
                    if (!this.dto.getChar_1_nm().equals("") && !this.dto.getChar_2_nm().equals("")) {
                        driver.executeScript(String.format("$('input[name=\"option[1]\"]').val('%s');", this.dto.getChar_2_nm()), new Object[]{""});
                        Thread.sleep(1000L);
                        values = items.stream().map(p -> "'" + p.getName() + "'").distinct().collect(Collectors.joining(",", "let options=[", "];"));
                        ChromeScript.get().addScript("var event = document.createEvent(\"Events\");").addScript("event.initEvent('keydown', true, true);").addScript("event.keyCode = 13;").addScript(values).addScript("let cnt = 0;").addScript("let ele = null;").addScript("for(const option of options){").addScript("ele = document.querySelectorAll(\"#\"+EC_PRODUCT_BUBBLE_OBJECT.eOptionBubbleArea_0.sElementID + \">li > span> input\")[cnt];").addScript("ele.value= option;").addScript("cnt ++;").addScript("ele.dispatchEvent(event);").addScript("}").addScript("document.querySelectorAll(\"#\"+EC_PRODUCT_BUBBLE_OBJECT.eOptionBubbleArea_0.sElementID + \">li\")[cnt].remove()").executeScripter(driver);
                        Thread.sleep(2000L);
                        String sizes = items.stream().map(p -> "'" + p.getCode() + "'").distinct().collect(Collectors.joining(",", "let options=[", "];"));
                        ChromeScript.get().addScript("var event = document.createEvent(\"Events\");").addScript("event.initEvent('keydown', true, true);").addScript("event.keyCode = 13;").addScript(sizes).addScript("let cnt = 0;").addScript("let ele = null;").addScript("for(const option of options){").addScript("ele = document.querySelectorAll(\"#\"+EC_PRODUCT_BUBBLE_OBJECT.eOptionBubbleArea_1.sElementID + \">li > span> input\")[cnt];").addScript("ele.value= option;").addScript("cnt ++;").addScript("ele.dispatchEvent(event);").addScript("}").addScript("document.querySelectorAll(\"#\"+EC_PRODUCT_BUBBLE_OBJECT.eOptionBubbleArea_1.sElementID + \">li\")[cnt].remove()").executeScripter(driver);
                        Thread.sleep(2000L);
                    } else {
                        driver.executeScript("$(\"#eOptionBubbleArea_1 button:eq(0)\").click();", new Object[]{""});
                        Thread.sleep(1000L);
                        values = items.stream().map(p -> "'" + p.getName() + "'").distinct().collect(Collectors.joining(",", "let options=[", "];"));
                        ChromeScript.get().addScript("var event = document.createEvent(\"Events\");").addScript("event.initEvent('keydown', true, true);").addScript("event.keyCode = 13;").addScript(values).addScript("let cnt = 0;").addScript("let ele = null;").addScript("for(const option of options){").addScript("ele = document.querySelectorAll(\"#\"+EC_PRODUCT_BUBBLE_OBJECT.eOptionBubbleArea_0.sElementID + \">li > span> input\")[cnt];").addScript("ele.value= option;").addScript("cnt ++;").addScript("ele.dispatchEvent(event);").addScript("}").addScript("document.querySelectorAll(\"#\"+EC_PRODUCT_BUBBLE_OBJECT.eOptionBubbleArea_0.sElementID + \">li\")[cnt].remove()").executeScripter(driver);
                        Thread.sleep(2000L);
                    }
                    driver.executeScript("$('#eManualOptionCombine').click();", new Object[]{""});
                    Thread.sleep(2000L);
                    int num = 1;
                    int i = 0;
                    while (i < options.size()) {
                        ShopOptionDto option2 = options.get(i);
                        String retname = ChromeScript.get().waitTiem(2000L).returnCallbackScripter(String.format("return $(\"span.eOptionValue:eq(%s)\").text();", i + num), driver);
                        String[] ret = retname.split("/");
                        if (ret[0].equals(((CodeItem)items.get(i)).getName()) && ret[1].equals(((CodeItem)items.get(i)).getCode())) {
                            driver.executeScript(String.format("$('input[name=\"mp_stock_number[]\"]:eq(%s)').val('%s')", i + num, option2.getCnt()), new Object[]{""});
                            driver.executeScript(String.format("$('input[name=\"mp_stock_price_value[1][]\"]:eq(%s)').val('%s')", i + num, option2.getAmt()), new Object[]{""});
                        } else {
                            driver.executeScript(String.format("$(\".w14 input.rowChk.eItemCheckBox:eq(%s)\").click()", i + num + 1), new Object[]{""});
                            --i;
                            ++num;
                        }
                        ++i;
                    }
                    driver.executeScript("$(\"a.btnNormal.eItemDelete:eq(0)\").click()", new Object[]{""});
                    Thread.sleep(1000L);
                    if (ExpectedConditions.alertIsPresent().apply((Object)driver) != null) {
                        driver.switchTo().alert().accept();
                    }
                    String retlen = ChromeScript.get().waitTiem(2000L).returnCallbackScripter("return document.querySelectorAll(\"table.eChkColor.eItemRow\").length.toString()", driver);
                    int i2 = 1;
                    while (i2 < Integer.parseInt(retlen)) {
                        YDMAStringUtil.Print();
                        String retstock = ChromeScript.get().waitTiem(2000L).returnCallbackScripter(String.format("return $('input[name=\"mp_stock_number[]\"]:eq(%s)').val();", i2), driver);
                        if (retstock.equals("0")) {
                            driver.executeScript(String.format("$(\".w14 input.rowChk.eItemCheckBox:eq(%s)\").click()", i2 + 1), new Object[]{""});
                        }
                        ++i2;
                    }
                    driver.executeScript("$(\"a.btnNormal.eItemDelete:eq(0)\").click()", new Object[]{""});
                    Thread.sleep(1000L);
                    if (ExpectedConditions.alertIsPresent().apply((Object)driver) != null) {
                        driver.switchTo().alert().accept();
                    }
                }
            }
            catch (Exception exception) {
                throw new Exception("C0005");
            }
        }
    }

    private static final class ProductStatusCategory {
        ChromeDriver driver;
        private static ProductStatusCategory instance = new ProductStatusCategory();

        private ProductStatusCategory() {
        }

        public static ProductStatusCategory get(ChromeDriver driver) {
            ProductStatusCategory.instance.driver = driver;
            return instance;
        }

        public void setSalesMethod(ShopProductAdditionDto dtllist) throws Exception {
            try {
                String script = String.format("$('input[name=\"is_display[1]\"]:eq(%s)').click();", "0");
                ChromeScript.get().addScript(script).executeScripter(this.driver);
                script = String.format("$('input[name=\"selling_status[1]\"]:eq(%s)').click();", "0");
                ChromeScript.get().addScript(script).executeScripter(this.driver);
            }
            catch (Exception exception) {
                throw new Exception("C0011");
            }
        }

        public void setSelectCateGory(ShopCatInfDto categoryDto) throws Exception {
            try {
                if (!categoryDto.getShoplagcatcd().isEmpty()) {
                    this.driver.executeScript(String.format("$('.eExposureCategory:eq(0) li')[%s].click()", categoryDto.getShoplagcatcd()), new Object[]{""});
                }
                Thread.sleep(1000L);
                if (!categoryDto.getShopmidcatcd().isEmpty()) {
                    this.driver.executeScript(String.format("$('.eExposureCategory:eq(1) li')[%s].click()", categoryDto.getShopmidcatcd()), new Object[]{""});
                }
                Thread.sleep(1000L);
                if (!categoryDto.getShopsmlcatcd().isEmpty()) {
                    this.driver.executeScript(String.format("$('.eExposureCategory:eq(2) li')[%s].click()", categoryDto.getShopsmlcatcd()), new Object[]{""});
                }
                Thread.sleep(1000L);
                if (!categoryDto.getShopdetcatcd().isEmpty()) {
                    this.driver.executeScript(String.format("$('.eExposureCategory:eq(3) li')[%s].click()", categoryDto.getShopdetcatcd()), new Object[]{""});
                }
            }
            catch (Exception exception) {
                throw new Exception("C0002");
            }
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    private static class Requests {
        @JsonProperty(value="parent_category_no")
        private int parent_category_no;
        @JsonProperty(value="category_name")
        private String category_name;
        @JsonProperty(value="display_type")
        private String display_type = "A";
        @JsonProperty(value="use_main")
        private String use_main = "F";
        @JsonProperty(value="use_display")
        private String use_display = "T";
        @JsonProperty(value="soldout_product_display")
        private String soldout_product_display = "N";
        @JsonProperty(value="sub_category_product_display")
        private String sub_category_product_display = "T";
        @JsonProperty(value="hashtag_product_display")
        private String hashtag_product_display = "F";
        @JsonProperty(value="hash_tags")
        private List<String> hash_tags = new ArrayList<String>();
        @JsonProperty(value="product_display_scope")
        private String product_display_scope;
        @JsonProperty(value="product_display_type")
        private String product_display_type;
        @JsonProperty(value="product_display_key")
        private String product_display_key;
        @JsonProperty(value="product_display_sort")
        private String product_display_sort;
        @JsonProperty(value="product_display_period")
        private String product_display_period;
        @JsonProperty(value="normal_product_display_type")
        private String normal_product_display_type;
        @JsonProperty(value="normal_product_display_key")
        private String normal_product_display_key;
        @JsonProperty(value="normal_product_display_sort")
        private String normal_product_display_sort;
        @JsonProperty(value="normal_product_display_period")
        private String normal_product_display_period;
        @JsonProperty(value="recommend_product_display_type")
        private String recommend_product_display_type;
        @JsonProperty(value="recommend_product_display_key")
        private String recommend_product_display_key;
        @JsonProperty(value="recommend_product_display_sort")
        private String recommend_product_display_sort;
        @JsonProperty(value="recommend_product_display_period")
        private String recommend_product_display_period;
        @JsonProperty(value="new_product_display_type")
        private String new_product_display_type;
        @JsonProperty(value="new_product_display_key")
        private String new_product_display_key;
        @JsonProperty(value="new_product_display_sort")
        private String new_product_display_sort;
        @JsonProperty(value="new_product_display_period")
        private String new_product_display_period;

        private Requests() {
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    private static class request {
        private String display;
        private String selling;
        private String product_condition;
        private String product_used_month;
        private List<CategoryReg> add_category_no;
        private String custom_product_code;
        private String product_name;
        private String eng_product_name;
        private String supply_product_name;
        private String internal_product_name;
        private String model_name;
        private String price_excluding_tax;
        private String price;
        private String retail_price;
        private String supply_price;
        private String has_option;
        private List<Cafe24Option> options;
        private String use_naverpay;
        private String naverpay_type;
        private String manufacturer_code;
        private String trend_code;
        private String brand_code;
        private String supplier_code;
        private String product_weight;
        private String made_date;
        private String release_date;
        private Cafe24Date expiration_date;
        private String description;
        private String mobile_description;
        private String summary_description;
        private String simple_description;
        private String product_tag;
        private String payment_info;
        private String shipping_info;
        private String exchange_info;
        private String service_info;
        private List<Cafe24Icon> icon;
        private String hscode;
        private String shipping_scope;
        private String shipping_method;
        private String shipping_fee_by_product;
        private String shipping_area;
        private Cafe24Period shipping_period;
        private String shipping_fee_type;
        private List<Cafe24Rates> shipping_rates;
        private String shipping_fee;
        private String prepaid_shipping_fee;
        private String clearance_category_code;
        private String detail_image;
        private String list_image;
        private String tiny_image;
        private String small_image;
        private String image_upload_type;
        private String price_content;
        private String buy_limit_by_product;
        private String buy_limit_type;
        private String repurchase_restriction;
        private String single_purchase_restriction;
        private String buy_unit_type;
        private String buy_unit;
        private String order_quantity_limit_type;
        private String minimum_quantity;
        private String maximum_quantity;
        private String points_by_product;
        private String points_setting_by_payment;
        private List<Cafe24Point> points_amount;
        private String except_member_points;
        private Cafe24Volume product_volume;
        private String origin_classification;
        private String origin_place_no;
        private String origin_place_value;
        private String made_in_code;
        private String main;
        private String product_material;
        private String english_product_material;
        private String cloth_fabric;
        private String classification_code;
        private String additional_price;
        private String margin_rate;
        private String tax_type;
        private String tax_amount;
        private String additional_image;
        private String adult_certification;

        private request() {
        }
    }
}

