/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.shop.data.naverstore;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.common.YDMATimeUtil;
import com.kdjsystem.mlink.yellim.data.excel.MyDataManagerFactory;
import com.kdjsystem.mlink.yellim.data.excel.MyExcelManager;
import com.kdjsystem.mlink.yellim.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.yellim.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.yellim.shop.dao.ShopOrderDao;
import com.kdjsystem.mlink.yellim.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.yellim.shop.data.naverstore.IShopOrderNaverStoreCommand;
import com.kdjsystem.mlink.yellim.shop.data.naverstore.NaverStoreGenerateSignature;
import com.kdjsystem.mlink.yellim.ui.CommonProgressDialog;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;

class NaverStoreOrderNewCommand
extends IShopOrderNaverStoreCommand {
    private static IShopOrderCommand instance = new NaverStoreOrderNewCommand();

    public static IShopOrderCommand getInstance() {
        return instance;
    }

    private NaverStoreOrderNewCommand() {
    }

    @Override
    public List<ShopOrderMstDto> Completed(List<ShopOrderMstDto> param) throws Exception {
        long range;
        ArrayList<ShopOrderMstDto> retList = new ArrayList<ShopOrderMstDto>();
        String start = YDMATimeUtil.getTime(param.get(0).getStartDt());
        String end = YDMATimeUtil.getTime(param.get(0).getEndDt());
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmm");
        Date sdate = formatter.parse(param.get(0).getStartDt());
        Date edate = formatter.parse(param.get(0).getEndDt());
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(sdate);
        cal2.setTime(edate);
        cal2.add(1, -1);
        if (cal1.getTimeInMillis() < cal2.getTimeInMillis()) {
            CommonProgressDialog.get().setValue("\uc2a4\ub9c8\ud2b8\uc2a4\ud1a0\uc5b4 - 1\ub144 \uc774\ub0b4\uc758 \uc8fc\ubb38 \uac74\ub9cc \uac00\uc838\uc62c \uc218 \uc788\uc2b5\ub2c8\ub2e4. \uc218\uc815\ub41c \ub0a0\uc9dc\ub85c \uac80\uc0c9\ud569\ub2c8\ub2e4.", 0);
            start = String.valueOf(cal2.getTimeInMillis());
            sdate = formatter.parse(formatter.format(cal2.getTime()));
        }
        int num = (int)(range = Math.abs((edate.getTime() - sdate.getTime()) / 86400000L) + 1L) % 90 == 0 ? (int)range / 90 : (int)range / 90 + 1;
        cal1.setTime(sdate);
        cal2.setTime(sdate);
        if (num > 1) {
            cal2.add(5, 89);
            end = String.valueOf(cal2.getTimeInMillis());
        }
        if (param.get(0).getVendorId().equals("N")) {
            int i = 0;
            while (i < num) {
                this.getNewOrder(param, retList, start, end, "NEW_ORDERS_DELIVERY_OPERATED_BEFORE");
                this.getNewOrder(param, retList, start, end, "NEW_ORDERS_DELIVERY_OPERATED_AFTER");
                cal1.add(5, 90);
                cal2.add(5, 90);
                start = String.valueOf(cal1.getTimeInMillis());
                end = String.valueOf(cal2.getTimeInMillis());
                ++i;
            }
        } else {
            this.getNewOrderApi(param, retList);
        }
        return retList;
    }

    public List<ShopOrderMstDto> getNewOrder(List<ShopOrderMstDto> param, List<ShopOrderMstDto> retList, String start, String end, String orderType) throws Exception {
        IShopCommonLogin is = new IShopCommonLogin(){};
        Map<Object, Object> cookies = new HashMap();
        List<String> list = Arrays.asList(param.get(0).getApikey().split(","));
        try {
            cookies = list != null && list.size() > 1 ? is.loginCookie(param.get(0).getShop_userid(), param.get(0).getShopPw(), param.get(0).getShopid(), true, param.get(0).getAuthkey1(), list.get(0), list.get(1)) : is.loginCookie(param.get(0).getShop_userid(), param.get(0).getShopPw(), param.get(0).getShopid(), true, param.get(0).getAuthkey1());
            Connection.Response rs = Jsoup.connect((String)"https://sell.smartstore.naver.com/o/v3/n/sale/delivery").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").method(Connection.Method.GET).ignoreContentType(true).followRedirects(true).execute();
            Document doc = Jsoup.parseBodyFragment((String)rs.body());
            Elements data2 = doc.select("script");
            String dataStr = data2.stream().filter(p -> p.toString().contains("merchantNo")).map(p -> p.toString().substring(p.toString().indexOf("merchantNo"))).findAny().orElseGet(() -> null);
            String merchantNo = dataStr.substring(0, dataStr.indexOf(",")).replace("\\\"", "").split(":")[1];
            String strParam = this.getNewOrderStringParam(merchantNo, orderType, start, end);
            Connection.Response response = Jsoup.connect((String)"https://sell.smartstore.naver.com/o/v3/graphql").cookies(cookies).header("content-type", "application/json").header("Content-Length", Integer.toString(strParam.length())).header("Host", "sell.smartstore.naver.com").requestBody(strParam).method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).execute();
            JsonParser parser = new JsonParser();
            JsonObject body = parser.parse(response.body()).getAsJsonObject();
            JsonObject object = body.get("data").getAsJsonObject();
            JsonObject deliveryList = object.get("deliveryList").getAsJsonObject();
            JsonArray elements = deliveryList.get("elements").getAsJsonArray();
            if (elements.size() > 0) {
                List<ShopOrderMstDto> param1 = this.setData(param, elements, cookies);
                param1.forEach(d -> d.setResult_code("1"));
                retList.addAll(param1);
            }
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        return retList;
    }

    public List<ShopOrderMstDto> setData(List<ShopOrderMstDto> param, JsonArray order_arr, Map<String, String> cookies) throws Exception {
        ArrayList<ShopOrderMstDto> list = new ArrayList<ShopOrderMstDto>();
        for (JsonElement order : order_arr) {
            boolean ordMatch;
            JsonObject object = order.getAsJsonObject();
            ShopOrderMstDto dto = new ShopOrderMstDto();
            if (param.get(0).getOrder_id() != null && (ordMatch = param.stream().anyMatch(s -> s.getOrder_id().equals(object.get("orderNo").toString())))) continue;
            dto.setReg_date(YDMATimeUtil.getCurrentTimeByYDFormat());
            dto.setOrder_id(object.get("orderNo").getAsString());
            dto.setOrder_status(this.getStatus(object.get("productOrderStatus").getAsString()));
            dto.setP_product_name(object.get("productName").getAsString());
            String orddt = YDMATimeUtil.getDate(object.get("orderDateTime").getAsString());
            dto.setOrder_date(orddt);
            dto.setProduct_name(object.get("productName").getAsString());
            dto.setSale_cnt(object.get("orderQuantity").getAsString());
            dto.setUser_name(object.get("orderMemberName").getAsString());
            dto.setUser_email("");
            dto.setReceive_name(object.get("receiverName").getAsString());
            dto.setShopid(param.get(0).getShopid());
            dto.setShop_userid(param.get(0).getShop_userid());
            dto.setUser_id(object.get("orderMemberId").getAsString());
            dto.setP_sku_value(this.jsonElementNullStr(object.get("productOptionContents")));
            dto.setSku_value(this.jsonElementNullStr(object.get("productOptionContents")));
            dto.setMall_exp_cd(object.get("productOrderNo").getAsString());
            dto.setUser_tel(this.jsonElementNullStr(object.get("orderMemberTelNo")));
            dto.setUser_cel(this.jsonElementNullStr(object.get("orderMemberTelNo")));
            dto.setReceive_tel(this.jsonElementNullStr(object.get("receiverTelNo2")));
            dto.setReceive_cel(this.jsonElementNullStr(object.get("receiverTelNo1")));
            dto.setReceive_zipcode(this.jsonElementNullStr(object.get("receiverZipCode")));
            String receiverAddr = this.jsonElementNullStr(object.get("receiverDisplayBaseAddress")).concat(" ").concat(this.jsonElementNullStr(object.get("receiverDisplayDetailAddress")));
            dto.setReceive_addr(receiverAddr);
            dto.setDelv_cost(this.jsonElementNullStr(object.get("deliveryFeeAmt")));
            dto.setDelv_msg(this.jsonElementNullStr(object.get("productOrderMemo")));
            dto.setDelivery_method_str2(this.getDelivery(this.jsonElementNullStr(object.get("deliveryFeeRatingClass"))));
            String ordamt = object.get("productPayAmt").getAsString();
            dto.setMall_won_cost(this.jsonElementNullStr(object.get("settlementExpectAmt")));
            dto.setPay_cost(Integer.toString(Integer.parseInt(ordamt) + Integer.parseInt(object.get("deliveryFeeAmt").getAsString())));
            dto.setTotal_cost(ordamt);
            dto.setSale_cost(Integer.toString(Integer.parseInt(object.get("productUnitPrice").getAsString()) * Integer.parseInt(dto.getSale_cnt())));
            dto.setCompno(param.get(0).getCompno());
            dto.setReceive_email("");
            dto.setWon_cost("0");
            dto.setBox_ea("0");
            dto.setP_sku_id("");
            dto.setCompayny_goods_cd(this.jsonElementNullStr(object.get("sellerProductManagementCode")));
            dto.setResult_code("1");
            String json = "{\"searchKeywordType\":\"CHANNEL_PRODUCT_NO\",\"searchKeyword\":\"" + object.get("productNo").getAsString() + "\",\"productName\":\"\",\"modelName\":\"\",\"manufacturerName\":\"\",\"brandName\":\"\",\"searchPaymentType\":\"ALL\",\"searchPeriodType\":\"PROD_REG_DAY\",\"deliveryAttributeType\":\"\",\"productKindType\":\"\",\"etcCondition\":\"\",\"subscriptionType\":\"\",\"fromDate\":\"\",\"toDate\":\"\",\"viewData\":{\"productStatusTypes\":[\"SALE\"],\"channelServiceTypes\":[\"STOREFARM\",\"WINDOW\",\"AFFILIATE\",\"\"],\"pageSize\":100},\"searchOrderType\":\"REG_DATE\",\"productStatusTypes\":[\"SALE\"],\"channelServiceTypes\":[\"STOREFARM\",\"WINDOW\",\"AFFILIATE\"],\"page\":0,\"size\":100,\"sort\":[]}";
            Connection.Response rs = Jsoup.connect((String)"https://sell.smartstore.naver.com/api/products/list/search").header("Host", "sell.smartstore.naver.com").header("Sec-Fetch-Site", "same-origin").header("Sec-Fetch-Mode", "cors").header("Sec-Fetch-Dest", "empty").header("Origin", "https://sell.smartstore.naver.com").header("Connection", "keep-alive").header("Content-Type", "application/json").header("Host", "sell.smartstore.naver.com").header("Accept", "application/json").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").requestBody(json).referrer("https://sell.smartstore.naver.com/o/v3/iframe/n/sale/delivery").method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).ignoreHttpErrors(true).execute();
            String body1 = rs.body();
            JsonParser parser = new JsonParser();
            JsonObject data2 = (JsonObject)parser.parse(body1);
            JsonArray contents = (JsonArray)data2.get("content");
            JsonObject data1 = (JsonObject)contents.get(0);
            String code = data1.get("id").getAsString();
            dto.setMall_product_id(code + "," + object.get("productNo").getAsString());
            list.add(dto);
        }
        return list;
    }

    public List<ShopOrderMstDto> getDeliveryCompleted(List<ShopOrderMstDto> param, List<ShopOrderMstDto> retList, String start, String end) throws Exception {
        try {
            IShopCommonLogin is = new IShopCommonLogin(){};
            Map<Object, Object> cookies = new HashMap();
            List<String> list = Arrays.asList(param.get(0).getApikey().split(","));
            cookies = list != null && list.size() > 1 ? is.loginCookie(param.get(0).getShop_userid(), param.get(0).getShopPw(), param.get(0).getShopid(), true, param.get(0).getAuthkey1(), list.get(0), list.get(1)) : is.loginCookie(param.get(0).getShop_userid(), param.get(0).getShopPw(), param.get(0).getShopid(), true, param.get(0).getAuthkey1());
            Connection.Response rs = Jsoup.connect((String)"https://sell.smartstore.naver.com/o/v3/iframe/sale/purchaseDecision").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").referrer("https://sell.smartstore.naver.com/").method(Connection.Method.GET).ignoreContentType(true).followRedirects(true).execute();
            Document doc = Jsoup.parseBodyFragment((String)rs.body());
            Elements data2 = doc.select("script");
            String user = ((Node)((Element)data2.get(5)).childNodes().get(0)).toString();
            JsonParser jsonparser = new JsonParser();
            JsonObject jsonobject = (JsonObject)jsonparser.parse(user.substring(user.indexOf("{"), user.lastIndexOf("}") + 1));
            YDMAStringUtil.Print(jsonobject);
            String json = "{\"operationName\":\"SmartStoreFindPurchaseDecisionsByDetailConditions_ForPurchaseDecision\",\"variables\":{\"merchantNo\":\"" + jsonobject.get("merchantNo").getAsString() + "\",\"serviceType\":\"MP\",\"paging_page\":1,\"paging_size\":500,\"sort_type\":\"RECENTLY_ORDER_YMDT\",\"sort_type\":\"PRODUCT_ORDER_PURCHASE_DECISION_COMPLETE_OPERATION_YMDT\",\"sort_direction\":\"DESC\",\"rangeType\":\"PURCHASE_DECISION_COMPLETED\",\"dateRange_from\":\"" + start + "\",\"dateRange_to\":\"" + end + "\",\"detailedOrderStatus\":\"ALL\"},\"query\":\"query SmartStoreFindPurchaseDecisionsByDetailConditions_ForPurchaseDecision($merchantNo: String!, $serviceType: String!, $claimStatus: ClaimStatusType, $dateRange_from: String, $dateRange_to: String, $detailSearch_keyword: String, $detailSearch_type: DetailSearchType, $paging_page: Int, $paging_size: Int, $rangeType: RangeType, $sort_direction: SortDirectionType, $sort_type: SortType) {\\n  purchaseDecisionList: SmartStoreFindPurchaseDecisionsByDetailConditions_ForPurchaseDecision(merchantNo: $merchantNo, serviceType: $serviceType, claimStatus: $claimStatus, dateRange_from: $dateRange_from, dateRange_to: $dateRange_to, detailSearch_keyword: $detailSearch_keyword, detailSearch_type: $detailSearch_type, paging_page: $paging_page, paging_size: $paging_size, rangeType: $rangeType, sort_direction: $sort_direction, sort_type: $sort_type) {\\n    elements {\\n      ...purchaseDecisionElementField\\n      __typename\\n    }\\n    pagination {\\n      ...paginationField\\n      __typename\\n    }\\n    __typename\\n  }\\n}\\n\\nfragment purchaseDecisionElementField on PurchaseDecisionMp {\\n  branchId\\n  merchantChannelNo\\n  deliveryFeeAmt\\n  deliveryFeeClass\\n  deliveryMethod\\n  biztalkAccountId\\n  deliveryInvoiceNo\\n  productPayAmt\\n  orderStatus\\n  productUnitPrice\\n  purchaseDecisionCompleteDateTime\\n  orderQuantity\\n  productName\\n  orderMemberName\\n  payDateTime\\n  productOrderNo\\n  productOptionContents\\n  deliveryFeeRatingClass\\n  orderMemberId\\n  knowledgeShoppingCommissionAmt\\n  remoteAreaCostChargeAmt\\n  productOptionAmt\\n  salesCommissionPrepay\\n  productNo\\n  payLocationType\\n  totalDiscountAmt\\n  orderNo\\n  payMeansClass\\n  productClass\\n  commissionClassType\\n  inflowPath\\n  receiverName\\n  settlementExpectAmt\\n  deliveryNo\\n  deliveryCompleteDateTime\\n  saleChannelType\\n  sellerDiscountAmt\\n  deliveryCompanyName\\n  deliveryFeeDiscountAmt\\n  dispatchDateTime\\n  sellerProductManagementCode\\n  payCommissionAmt\\n  syncDateTime\\n  productOrderStatus\\n  sellerInternalCode2\\n  sellingInterlockCommissionClassType\\n  sellingInterlockCommissionInflowPath\\n  sellerInternalCode1\\n  deliveryBundleGroupSeq\\n  productUrl\\n  __typename\\n}\\n\\nfragment paginationField on Pagination {\\n  size\\n  totalElements\\n  page\\n  totalPages\\n  __typename\\n}\\n\"}";
            rs = Jsoup.connect((String)"https://sell.smartstore.naver.com/o/v3/graphql").header("Host", "sell.smartstore.naver.com").header("Sec-Fetch-Site", "same-origin").header("Sec-Fetch-Mode", "cors").header("Sec-Fetch-Dest", "empty").header("Origin", "https://sell.smartstore.naver.com").header("Connection", "keep-alive").header("Content-Type", "application/json").header("Host", "sell.smartstore.naver.com").header("Accept", "application/json").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").requestBody(json).referrer("https://sell.smartstore.naver.com/o/v3/sale/purchaseDecision").method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).ignoreHttpErrors(true).execute();
            String body = rs.body();
            jsonparser = new JsonParser();
            jsonobject = (JsonObject)jsonparser.parse(body);
            JsonObject obj1 = (JsonObject)jsonobject.get("data");
            JsonObject obj2 = (JsonObject)obj1.get("purchaseDecisionList");
            JsonArray jsonArray = (JsonArray)obj2.get("elements");
            if (jsonArray.size() > 0) {
                List<ShopOrderMstDto> param1 = this.getExcelFileManagerJson(param, jsonArray, cookies);
                param1.forEach(d -> d.setResult_code("1"));
                retList.addAll(param1);
            }
            return retList;
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    private List<ShopOrderMstDto> getExcelFileManagerJson(List<ShopOrderMstDto> param, JsonArray jsonArray, Map<String, String> cookies) throws Exception {
        ArrayList<ShopOrderMstDto> dtolist = new ArrayList<ShopOrderMstDto>();
        try {
            int i = 0;
            while (i < jsonArray.size()) {
                JsonObject object = (JsonObject)jsonArray.get(i);
                if (!ShopOrderDao.get().isOrdered(object.get("orderNo").getAsString())) {
                    ShopOrderMstDto dto = new ShopOrderMstDto();
                    if (object.get("orderStatus").getAsString().equals("WAITING_DISPATCH")) {
                        dto.setReg_date(YDMATimeUtil.getCurrentTimeByYDFormat());
                        dto.setOrder_id(object.get("orderNo").getAsString());
                        dto.setOrder_status(this.getStatus(object.get("productOrderStatus").getAsString()));
                        dto.setP_product_name(object.get("productName").getAsString());
                        orddt = YDMATimeUtil.getDate(object.get("payDateTime").getAsString());
                        dto.setOrder_date(orddt);
                        dto.setProduct_name(object.get("productName").getAsString());
                        dto.setSale_cnt(object.get("orderQuantity").getAsString());
                        dto.setUser_name(object.get("orderMemberName").getAsString());
                        dto.setUser_email("");
                        dto.setUser_id(object.get("orderMemberId").getAsString());
                        dto.setReceive_name(object.get("receiverName").getAsString());
                        dto.setShopid(param.get(0).getShopid());
                        dto.setShop_userid(param.get(0).getShop_userid());
                        String json = "{\"searchKeywordType\":\"CHANNEL_PRODUCT_NO\",\"searchKeyword\":\"" + object.get("productNo").getAsString() + "\",\"productName\":\"\",\"modelName\":\"\",\"manufacturerName\":\"\",\"brandName\":\"\",\"searchPaymentType\":\"ALL\",\"searchPeriodType\":\"PROD_REG_DAY\",\"deliveryAttributeType\":\"\",\"productKindType\":\"\",\"etcCondition\":\"\",\"subscriptionType\":\"\",\"fromDate\":\"\",\"toDate\":\"\",\"viewData\":{\"productStatusTypes\":[\"SALE\"],\"channelServiceTypes\":[\"STOREFARM\",\"WINDOW\",\"AFFILIATE\",\"\"],\"pageSize\":100},\"searchOrderType\":\"REG_DATE\",\"productStatusTypes\":[\"SALE\"],\"channelServiceTypes\":[\"STOREFARM\",\"WINDOW\",\"AFFILIATE\"],\"page\":0,\"size\":100,\"sort\":[]}";
                        Connection.Response rs = Jsoup.connect((String)"https://sell.smartstore.naver.com/api/products/list/search").header("Host", "sell.smartstore.naver.com").header("Sec-Fetch-Site", "same-origin").header("Sec-Fetch-Mode", "cors").header("Sec-Fetch-Dest", "empty").header("Origin", "https://sell.smartstore.naver.com").header("Connection", "keep-alive").header("Content-Type", "application/json").header("Host", "sell.smartstore.naver.com").header("Accept", "application/json").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").requestBody(json).referrer("https://sell.smartstore.naver.com/o/v3/iframe/n/sale/delivery").method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).ignoreHttpErrors(true).execute();
                        String body1 = rs.body();
                        JsonParser parser = new JsonParser();
                        JsonObject data2 = (JsonObject)parser.parse(body1);
                        JsonArray contents = (JsonArray)data2.get("content");
                        JsonObject data1 = (JsonObject)contents.get(0);
                        String code = data1.get("id").getAsString();
                        dto.setMall_product_id(code + "," + object.get("productNo").getAsString());
                        dto.setReceive_zipcode(this.jsonElementNullStr(object.get("receiverZipCode")));
                        dto.setReceive_addr(this.jsonElementNullStr(object.get("receiverAddress")));
                        dto.setUser_tel(this.jsonElementNullStr(object.get("orderMemberTelNo")));
                        dto.setUser_cel(this.jsonElementNullStr(object.get("orderMemberTelNo")));
                        dto.setReceive_tel(this.jsonElementNullStr(object.get("receiverTelNo2")));
                        dto.setReceive_cel(this.jsonElementNullStr(object.get("receiverTelNo1")));
                        dto.setDelv_cost(this.jsonElementNullStr(object.get("deliveryFeeAmt")));
                        dto.setDelv_msg(this.jsonElementNullStr(object.get("productOrderMemo")));
                        dto.setDelivery_method_str2(this.getDelivery(this.jsonElementNullStr(object.get("deliveryFeeRatingClass"))));
                        String ordamt = object.get("productPayAmt").getAsString();
                        dto.setMall_won_cost(this.jsonElementNullStr(object.get("settlementExpectAmt")));
                        dto.setPay_cost(Integer.toString(Integer.parseInt(ordamt) + Integer.parseInt(object.get("deliveryFeeAmt").getAsString())));
                        dto.setTotal_cost(ordamt);
                        dto.setSale_cost(Integer.toString(Integer.parseInt(object.get("productUnitPrice").getAsString()) * Integer.parseInt(dto.getSale_cnt())));
                        dto.setCompno(param.get(0).getCompno());
                        dto.setReceive_email("");
                        dto.setWon_cost("0");
                        dto.setBox_ea("0");
                        dto.setP_sku_value(this.jsonElementNullStr(object.get("productOptionContents")));
                        dto.setSku_value(this.jsonElementNullStr(object.get("productOptionContents")));
                        dto.setMall_exp_cd(object.get("productOrderNo").getAsString());
                        dto.setP_sku_id("");
                        dto.setCompayny_goods_cd(this.jsonElementNullStr(object.get("sellerProductManagementCode")));
                        dto.setResult_code("1");
                        dto.setAuthkey1(param.get(0).getAuthkey1());
                        dtolist.add(dto);
                    } else if (object.get("orderStatus").getAsString().equals("PURCHASE_DECIDED")) {
                        dto.setReg_date(YDMATimeUtil.getCurrentTimeByYDFormat());
                        dto.setOrder_id(object.get("orderNo").getAsString());
                        dto.setOrder_status("410");
                        dto.setP_product_name(object.get("productName").getAsString());
                        orddt = YDMATimeUtil.getDate(object.get("payDateTime").getAsString());
                        dto.setOrder_date(orddt);
                        dto.setProduct_name(object.get("productName").getAsString());
                        dto.setSale_cnt(object.get("orderQuantity").getAsString());
                        dto.setUser_name(object.get("orderMemberName").getAsString());
                        dto.setUser_email("");
                        dto.setUser_id(object.get("orderMemberId").getAsString());
                        dto.setReceive_name(object.get("receiverName").getAsString());
                        dto.setShopid(param.get(0).getShopid());
                        dto.setShop_userid(param.get(0).getShop_userid());
                        dto.setMall_product_id(object.get("productNo").getAsString());
                        dto.setReceive_zipcode("");
                        dto.setReceive_addr("");
                        dto.setUser_tel("");
                        dto.setUser_cel("");
                        dto.setReceive_tel("");
                        dto.setReceive_cel("");
                        dto.setDelv_cost(this.jsonElementNullStr(object.get("deliveryFeeAmt")));
                        dto.setDelv_msg("");
                        dto.setDelivery_method_str2(this.getDelivery(this.jsonElementNullStr(object.get("deliveryFeeRatingClass"))));
                        String ordamt = object.get("productPayAmt").getAsString();
                        dto.setMall_won_cost(this.jsonElementNullStr(object.get("settlementExpectAmt")));
                        dto.setPay_cost(Integer.toString(Integer.parseInt(ordamt) + Integer.parseInt(object.get("deliveryFeeAmt").getAsString())));
                        dto.setTotal_cost(ordamt);
                        dto.setSale_cost(Integer.toString(Integer.parseInt(object.get("productUnitPrice").getAsString()) * Integer.parseInt(dto.getSale_cnt())));
                        dto.setCompno(param.get(0).getCompno());
                        dto.setReceive_email("");
                        dto.setWon_cost("0");
                        dto.setBox_ea("0");
                        dto.setP_sku_value(this.jsonElementNullStr(object.get("productOptionContents")));
                        dto.setSku_value(this.jsonElementNullStr(object.get("productOptionContents")));
                        dto.setMall_exp_cd(object.get("productOrderNo").getAsString());
                        dto.setP_sku_id("");
                        dto.setCompayny_goods_cd(this.jsonElementNullStr(object.get("sellerProductManagementCode")));
                        dto.setResult_code("1");
                        dto.setAuthkey1(param.get(0).getAuthkey1());
                        dtolist.add(dto);
                    }
                }
                ++i;
            }
        }
        catch (Exception exception) {
            throw new Exception("\uc2a4\ud1a0\uc5b4\ud31c\uc218\uc9d1\uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        return dtolist;
    }

    private String getDelivery(String jsonElementNullStr) {
        String value = "";
        switch (jsonElementNullStr) {
            case "PREPAYED": 
            case "\uc120\uacb0\uc81c": {
                value = "\uc120\uacb0\uc81c";
                break;
            }
            case "\ubb34\ub8cc": 
            case "FREE": {
                value = "\ubb34\ub8cc";
            }
        }
        return value;
    }

    @Override
    public String jsonElementNullStr(JsonElement val) {
        if (val.isJsonNull()) {
            return "";
        }
        return val.getAsString();
    }

    private String getStatus(String string) {
        String value = "";
        switch (string) {
            case "PLACE_ORDER": 
            case "NEW_ORDER": 
            case "PAYED": 
            case "PLACE_ORDER_RELEASE": {
                value = "100";
            }
        }
        return value;
    }

    private String getReturnStatus(int i) {
        String value = "";
        switch (i) {
            case 1: {
                value = "R01";
                break;
            }
            case 2: {
                value = "R01";
                break;
            }
            case 3: {
                value = "R02";
                break;
            }
            case 4: {
                value = "R02";
                break;
            }
            case 5: {
                value = "R01";
            }
        }
        return value;
    }

    private String getReturnValue(int i) {
        String value = "";
        switch (i) {
            case 1: {
                value = "RETURN_REQUEST";
                break;
            }
            case 2: {
                value = "COLLECTING";
                break;
            }
            case 3: {
                value = "COLLECT_DONE";
                break;
            }
            case 4: {
                value = "RETURN_DONE";
                break;
            }
            case 5: {
                value = "RETURN_REJECT";
            }
        }
        return value;
    }

    private String getStatus(int i) {
        String value = "";
        switch (i) {
            case 1: {
                value = "E01";
                break;
            }
            case 2: {
                value = "E01";
                break;
            }
            case 3: {
                value = "E02";
                break;
            }
            case 4: {
                value = "E01";
                break;
            }
            case 5: {
                value = "E02";
                break;
            }
            case 6: {
                value = "E01";
            }
        }
        return value;
    }

    private String getValue(int i) {
        String value = "";
        switch (i) {
            case 1: {
                value = "EXCHANGE_REQUEST";
                break;
            }
            case 2: {
                value = "COLLECTING";
                break;
            }
            case 3: {
                value = "COLLECT_DONE";
                break;
            }
            case 4: {
                value = "EXCHANGE_REDELIVERING";
                break;
            }
            case 5: {
                value = "EXCHANGE_DONE";
                break;
            }
            case 6: {
                value = "EXCHANGE_REJECT";
            }
        }
        return value;
    }

    public List<ShopOrderMstDto> getExcelFileManager(String path, List<ShopOrderMstDto> param, String status2) throws Exception {
        ArrayList<ShopOrderMstDto> dtolist = new ArrayList<ShopOrderMstDto>();
        try {
            MyExcelManager myExcelManager = null;
            myExcelManager = MyDataManagerFactory.createExcelManager(path);
            myExcelManager.loadData();
            List<List<String>> sheetContents = myExcelManager.getSheetContents(0, 1);
            sheetContents.remove(0);
            for (List<String> list : sheetContents) {
                ShopOrderMstDto dto = new ShopOrderMstDto();
                int aa = (int)Double.parseDouble(list.get(24).replace("\\", ""));
                int bb = (int)Double.parseDouble(list.get(33).replace("\\", ""));
                int cc = (int)Double.parseDouble(list.get(21).replace("\\", ""));
                int salecnt = (int)Double.parseDouble(list.get(19).replace("\\", ""));
                dto.setReg_date(YDMATimeUtil.getCurrentTimeByYDFormat());
                dto.setOrder_date(list.get(56));
                dto.setOrder_status(status2);
                dto.setShopid(param.get(0).getShopid());
                dto.setShop_userid(param.get(0).getShop_userid());
                dto.setReceive_name(list.get(9));
                dto.setMall_product_id(list.get(14));
                dto.setCompayny_goods_cd(list.get(36));
                dto.setP_product_name(list.get(15));
                dto.setP_sku_value(list.get(17));
                dto.setSale_cnt(String.valueOf(salecnt));
                dto.setWon_cost("0");
                dto.setMall_won_cost("0");
                dto.setSale_cost(String.valueOf(cc));
                dto.setDelv_cost(String.valueOf(bb));
                dto.setDelivery_method_str2(list.get(30));
                dto.setDelv_msg(list.get(44));
                dto.setDelivery_id("");
                dto.setInvoice_no("");
                dto.setLabel("");
                dto.setProduct_id(list.get(36));
                dto.setCompno(param.get(0).getCompno());
                dto.setOrder_id(list.get(1));
                dto.setUser_id(list.get(8));
                dto.setUser_name(list.get(7));
                dto.setUser_tel(list.get(64));
                dto.setUser_cel(list.get(64));
                dto.setUser_email("");
                dto.setReceive_tel(list.get(59));
                dto.setReceive_cel(list.get(39));
                dto.setReceive_email("");
                dto.setReceive_zipcode(list.get(61));
                dto.setReceive_addr(list.get(41));
                dto.setTotal_cost(String.valueOf(aa));
                Integer paycost = aa + bb;
                dto.setPay_cost(paycost.toString());
                dto.setProduct_name(list.get(15));
                dto.setBox_ea("0");
                dto.setLabel(list.get(0));
                dto.setAuthkey1(param.get(0).getAuthkey1());
                dto.setMall_exp_cd("0");
                dtolist.add(dto);
            }
        }
        catch (Exception exception) {
            throw new Exception("\uc625\uc158 \uc2e0\uaddc \uac00\uc838\uc624\uae30 \uc5d1\uc140 \ub9cc\ub4dc\ub294 \uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd \ud588\uc2b5\ub2c8\ub2e4.");
        }
        return dtolist;
    }

    public List<ShopOrderMstDto> getExcelFileManager2(String path, List<ShopOrderMstDto> param, String status2) throws Exception {
        ArrayList<ShopOrderMstDto> dtolist = new ArrayList<ShopOrderMstDto>();
        try {
            MyExcelManager myExcelManager = null;
            myExcelManager = MyDataManagerFactory.createExcelManager(path);
            myExcelManager.loadData();
            List<List<String>> sheetContents = myExcelManager.getSheetContents(0, 1);
            if (status2.equals("R02")) {
                for (List<String> list : sheetContents) {
                    ShopOrderMstDto dto = new ShopOrderMstDto();
                    int totamt = (int)Double.parseDouble(list.get(28).replace("\\", ""));
                    int deliamt = (int)Double.parseDouble(list.get(35).replace("\\", ""));
                    int saleamt = (int)Double.parseDouble(list.get(26).replace("\\", ""));
                    int salecnt = (int)Double.parseDouble(list.get(24).replace("\\", ""));
                    dto.setReg_date(YDMATimeUtil.getCurrentTimeByYDFormat());
                    dto.setOrder_date(list.get(7));
                    dto.setOrder_status(status2);
                    dto.setShopid(param.get(0).getShopid());
                    dto.setShop_userid(param.get(0).getShop_userid());
                    dto.setReceive_name(list.get(32));
                    dto.setMall_product_id(list.get(17));
                    dto.setCompayny_goods_cd(list.get(18));
                    dto.setP_product_name(list.get(21));
                    dto.setP_sku_value(list.get(23));
                    dto.setSale_cnt(String.valueOf(salecnt * -1));
                    dto.setWon_cost("0");
                    dto.setMall_won_cost("0");
                    dto.setSale_cost(String.valueOf(saleamt));
                    dto.setDelv_cost(String.valueOf(deliamt));
                    dto.setDelivery_method_str2(list.get(33));
                    dto.setDelv_msg(list.get(9));
                    dto.setDelivery_id("");
                    dto.setInvoice_no("");
                    dto.setLabel("");
                    dto.setProduct_id(list.get(18));
                    dto.setCompno(param.get(0).getCompno());
                    dto.setOrder_id(list.get(1));
                    dto.setUser_id(list.get(31));
                    dto.setUser_name(list.get(30));
                    dto.setUser_email("");
                    dto.setReceive_email("");
                    Integer paycost = totamt + deliamt;
                    dto.setPay_cost(paycost.toString());
                    dto.setProduct_name(list.get(21));
                    dto.setBox_ea("0");
                    dto.setAuthkey1(param.get(0).getAuthkey1());
                    dto.setLabel(list.get(0));
                    dtolist.add(dto);
                }
            } else if (status2.equals("C01")) {
                for (List<String> list : sheetContents) {
                    ShopOrderMstDto dto = new ShopOrderMstDto();
                    int totamt = (int)Double.parseDouble(list.get(24).replace("\\", ""));
                    int deliamt = (int)Double.parseDouble(list.get(31).replace("\\", ""));
                    int saleamt = (int)Double.parseDouble(list.get(22).replace("\\", ""));
                    int salecnt = (int)Double.parseDouble(list.get(20).replace("\\", ""));
                    dto.setReg_date(YDMATimeUtil.getCurrentTimeByYDFormat());
                    dto.setOrder_date(list.get(5));
                    dto.setOrder_status(status2);
                    dto.setShopid(param.get(0).getShopid());
                    dto.setShop_userid(param.get(0).getShop_userid());
                    dto.setReceive_name(list.get(28));
                    dto.setMall_product_id(list.get(13));
                    dto.setCompayny_goods_cd(list.get(14));
                    dto.setP_product_name(list.get(17));
                    dto.setP_sku_value(list.get(19));
                    dto.setSale_cnt(String.valueOf(salecnt * -1));
                    dto.setWon_cost("0");
                    dto.setMall_won_cost("0");
                    dto.setSale_cost(String.valueOf(saleamt));
                    dto.setDelv_cost(String.valueOf(deliamt));
                    dto.setDelivery_method_str2(list.get(29));
                    dto.setDelv_msg(list.get(7));
                    dto.setDelivery_id("");
                    dto.setInvoice_no("");
                    dto.setLabel("");
                    dto.setProduct_id(list.get(14));
                    dto.setCompno(param.get(0).getCompno());
                    dto.setOrder_id(list.get(1));
                    dto.setUser_id(list.get(27));
                    dto.setUser_name(list.get(26));
                    dto.setUser_email("");
                    dto.setReceive_email("");
                    Integer paycost = totamt + deliamt;
                    dto.setPay_cost(paycost.toString());
                    dto.setProduct_name(list.get(17));
                    dto.setBox_ea("0");
                    dto.setLabel(list.get(0));
                    dto.setAuthkey1(param.get(0).getAuthkey1());
                    dto.setMall_exp_cd("0");
                    dtolist.add(dto);
                }
            } else {
                for (List<String> list : sheetContents) {
                    ShopOrderMstDto dto = new ShopOrderMstDto();
                    int totamt = (int)Double.parseDouble(list.get(24).replace("\\", ""));
                    int deliamt = (int)Double.parseDouble(list.get(31).replace("\\", ""));
                    int saleamt = (int)Double.parseDouble(list.get(22).replace("\\", ""));
                    int salecnt = (int)Double.parseDouble(list.get(20).replace("\\", ""));
                    dto.setReg_date(YDMATimeUtil.getCurrentTimeByYDFormat());
                    dto.setOrder_date(list.get(8));
                    dto.setOrder_status(status2);
                    dto.setShopid(param.get(0).getShopid());
                    dto.setShop_userid(param.get(0).getShop_userid());
                    dto.setReceive_name(list.get(28));
                    dto.setMall_product_id(list.get(13));
                    dto.setCompayny_goods_cd(list.get(14));
                    dto.setP_product_name(list.get(17));
                    dto.setP_sku_value(list.get(18));
                    dto.setSale_cnt(String.valueOf(salecnt * -1));
                    dto.setWon_cost("0");
                    dto.setMall_won_cost("0");
                    dto.setSale_cost(String.valueOf(saleamt));
                    dto.setDelv_cost(String.valueOf(deliamt));
                    dto.setDelivery_method_str2(list.get(29));
                    dto.setDelv_msg(list.get(7));
                    dto.setDelivery_id("");
                    dto.setInvoice_no("");
                    dto.setLabel("");
                    dto.setProduct_id(list.get(14));
                    dto.setCompno(param.get(0).getCompno());
                    dto.setOrder_id(list.get(1));
                    dto.setUser_id(list.get(27));
                    dto.setUser_name(list.get(28));
                    dto.setUser_email("");
                    dto.setReceive_email("");
                    Integer paycost = totamt + deliamt;
                    dto.setPay_cost(paycost.toString());
                    dto.setProduct_name(list.get(17));
                    dto.setBox_ea("0");
                    dto.setAuthkey1(param.get(0).getAuthkey1());
                    dto.setLabel(list.get(0));
                    dto.setMall_exp_cd("0");
                    dtolist.add(dto);
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("\uc625\uc158 \uc2e0\uaddc \uac00\uc838\uc624\uae30 \uc5d1\uc140 \ub9cc\ub4dc\ub294 \uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd \ud588\uc2b5\ub2c8\ub2e4.");
        }
        return dtolist;
    }

    public String getNewOrderStringParam(String merchantNo, String type, String startDate, String endDate) throws Exception {
        NewOrder newOrder = new NewOrder();
        newOrder.operationName = "smartstoreFindDeliveriesBySummaryInfoType_ForSaleDelivery";
        newOrder.variables.merchantNo = merchantNo;
        newOrder.variables.serviceType = "MP";
        newOrder.variables.pagingPage = 1;
        newOrder.variables.pagingSize = 100;
        newOrder.variables.sortType = "RECENTLY_ORDER_YMDT";
        newOrder.variables.sortDirection = "DESC";
        newOrder.variables.summaryInfoType = type;
        String[] sellerOrderSearchTypes = new String[]{"NORMAL_ORDER", "TODAY_DISPATCH", "PRE_ORDER", "SUBSCRIPTION", "RENTAL"};
        newOrder.variables.sellerOrderSearchTypes = sellerOrderSearchTypes;
        newOrder.query = "query smartstoreFindDeliveriesBySummaryInfoType_ForSaleDelivery($merchantNo: String!, $paging_page: Int, $paging_size: Int, $serviceType: ServiceType!, $sort_direction: SortDirectionType, $sort_type: SortType, $summaryInfoType: SummaryInfoType!, $sellerOrderSearchTypes: [String]!) {\n  deliveryList: smartstoreFindDeliveriesBySummaryInfoType_ForSaleDelivery(merchantNo: $merchantNo, paging_page: $paging_page, paging_size: $paging_size, serviceType: $serviceType, sort_direction: $sort_direction, sort_type: $sort_type, summaryInfoType: $summaryInfoType, sellerOrderSearchTypes: $sellerOrderSearchTypes) {\n    elements {\n      ...deliveryElementField\n      __typename\n    }\n    pagination {\n      ...paginationField\n      __typename\n    }\n    __typename\n  }\n}\n\nfragment deliveryElementField on SaleDeliverySeller {\n  returnCareTarget\n  branchId\n  merchantChannelNo\n  deliveryFeeClass\n  deliveryInvoiceNo\n  orderQuantity\n  productName\n  payDateTime\n  deliveryDateTime\n  deliveryFeeRatingClass\n  productOrderMemo\n  orderMemberId\n  remoteAreaCostChargeAmt\n  salesCommissionPrepay\n  payLocationType\n  totalDiscountAmt\n  orderNo\n  payMeansClass\n  productClass\n  commissionClassType\n  oneYearOrderAmt\n  saleChannelType\n  oneYearOrderCount\n  deliveryCompanyName\n  sellerProductManagementCode\n  grade\n  sellingInterlockCommissionInflowPath\n  orderMemberTelNo\n  deliveryFeeAmt\n  claimNo\n  deliveryMethod\n  deliveryMethodPay\n  biztalkAccountId\n  giftName\n  receiverTelNo2\n  productPayAmt\n  receiverTelNo1\n  sixMonthOrderAmt\n  orderStatus\n  productUnitPrice\n  waybillPrintDateTime\n  threeMonthOrderCount\n  orderMemberName\n  productOrderNo\n  deliveryCompanyCode\n  productOptionContents\n  dispatchDueDateTime\n  knowledgeShoppingCommissionAmt\n  productOptionAmt\n  productNo\n  individualCustomUniqueCode\n  orderDateTime\n  placingOrderDateTime\n  inflowPath\n  receiverName\n  settlementExpectAmt\n  deliveryNo\n  threeMonthOrderAmt\n  sellerDiscountAmt\n  deliveryFeeDiscountAmt\n  dispatchDateTime\n  sixMonthOrderCount\n  receiverZipCode\n  payCommissionAmt\n  takingGoodsPlaceAddress\n  syncDateTime\n  productOrderStatus\n  sellerInternalCode2\n  sellerOptionManagementCode\n  sellerInternalCode1\n  deliveryBundleGroupSeq\n  productUrl\n  subscriptionRound\n  subscriptionPeriodCount\n  fulfillmentCompanyName\n  receiverIntegratedAddress\n  receiverDisplayBaseAddress\n  receiverDisplayDetailAddress\n  deliveryAttributeText\n  __typename\n}\n\nfragment paginationField on Pagination {\n  size\n  totalElements\n  page\n  totalPages\n  __typename\n}\n";
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString((Object)newOrder);
    }

    public List<ShopOrderMstDto> getNewOrderApi(List<ShopOrderMstDto> param, List<ShopOrderMstDto> retList) throws Exception {
        NaverStoreGenerateSignature naverStroeGenerateSignature = new NaverStoreGenerateSignature();
        String startdt = param.get(0).getStartDt().substring(0, 8);
        String enddt = param.get(0).getEndDt().substring(0, 8);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
        Date sdate = formatter.parse(startdt);
        Date edate = formatter.parse(enddt);
        long range = Math.abs((edate.getTime() - sdate.getTime()) / 86400000L) + 1L;
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(sdate);
        String clientId = param.get(0).getEDITAUTHKEY1();
        String clientSecret = param.get(0).getEDITAPIKEY();
        Long timestamp = System.currentTimeMillis();
        String secretSign = naverStroeGenerateSignature.generateSignature(clientId, clientSecret, timestamp);
        String accessToken = naverStroeGenerateSignature.accessToken(secretSign, clientId, timestamp, "client_credentials", "SELF");
        int i = 0;
        while (i < (int)range) {
            this.getOrder(accessToken, sdate, param, retList);
            cal1.add(5, 1);
            startdt = formatter.format(cal1.getTime());
            sdate = formatter.parse(startdt);
            ++i;
        }
        return retList;
    }

    private void getOrder(String accessToken, Date date, List<ShopOrderMstDto> param, List<ShopOrderMstDto> retList) {
        ArrayList<String> orderId = new ArrayList<String>();
        OkHttpClient client = new OkHttpClient();
        String datePatternNaverApi = "yyyy-MM-dd'T'HH:mm:ss.SSS";
        SimpleDateFormat format = new SimpleDateFormat(datePatternNaverApi);
        String[] status2 = new String[]{"PAYED", "CLAIM_REJECTED"};
        try {
            int j = 0;
            while (j < 2) {
                Request request2 = new Request.Builder().url("https://api.commerce.naver.com/external/v1/pay-order/seller/product-orders/last-changed-statuses?lastChangedFrom=" + format.format(date) + "Z&lastChangedType=" + status2[j]).get().addHeader("Authorization", accessToken).build();
                Thread.sleep(450L);
                Call call = client.newCall(request2);
                String body = call.execute().body().string();
                YDMAStringUtil.Print(body);
                JsonParser parser = new JsonParser();
                JsonElement jsonElement = parser.parse(body);
                JsonObject object = jsonElement.getAsJsonObject();
                if (object.get("data") != null) {
                    JsonObject jsonObject = object.get("data").getAsJsonObject();
                    JsonArray datas = jsonObject.get("lastChangeStatuses").getAsJsonArray();
                    for (JsonElement data2 : datas) {
                        JsonObject JsonObject2 = data2.getAsJsonObject();
                        orderId.add(JsonObject2.get("productOrderId").getAsString());
                    }
                }
                ++j;
            }
            if (orderId.size() != 0) {
                MediaType mediaType = MediaType.parse((String)"application/json");
                RequestBody body2 = RequestBody.create((MediaType)mediaType, (String)("{\"productOrderIds\":" + String.valueOf(orderId) + "}"));
                JsonParser parser2 = new JsonParser();
                Request request2 = new Request.Builder().url("https://api.commerce.naver.com/external/v1/pay-order/seller/product-orders/query").post(body2).addHeader("Authorization", accessToken).addHeader("content-type", "application/json").build();
                Call call2 = client.newCall(request2);
                String bodys = call2.execute().body().string();
                JsonObject object2 = (JsonObject)parser2.parse(bodys);
                JsonArray elements = object2.get("data").getAsJsonArray();
                if (elements.size() > 0) {
                    List<ShopOrderMstDto> param1 = this.setData2(param, elements, accessToken);
                    param1.forEach(d -> d.setResult_code("1"));
                    retList.addAll(param1);
                }
            }
        }
        catch (Exception e) {
            YDMAStringUtil.Print(e.getMessage());
        }
    }

    public List<ShopOrderMstDto> setData2(List<ShopOrderMstDto> param, JsonArray order_arr, String accessToken) throws Exception {
        ArrayList<ShopOrderMstDto> list = new ArrayList<ShopOrderMstDto>();
        for (JsonElement order : order_arr) {
            Object ordererTel;
            boolean ordMatch;
            JsonObject object = order.getAsJsonObject();
            JsonObject productOrder = object.getAsJsonObject("productOrder");
            JsonObject orders = object.getAsJsonObject("order");
            JsonObject shippingAddress = productOrder.getAsJsonObject("shippingAddress");
            ShopOrderMstDto dto = new ShopOrderMstDto();
            String productId = productOrder.get("productOrderId").getAsString();
            if (param.get(0).getOrder_id() != null && (ordMatch = param.stream().anyMatch(s -> s.getOrder_id().equals(object.get("orderNo").toString())))) continue;
            dto.setReg_date(YDMATimeUtil.getCurrentTimeByYDFormat());
            dto.setOrder_id(orders.get("orderId").getAsString());
            dto.setOrder_status(this.getStatus(productOrder.get("productOrderStatus").getAsString()));
            dto.setP_product_name(productOrder.get("productName").getAsString());
            String orddt = orders.get("orderDate").getAsString().substring(0, 19).replace("T", " ");
            dto.setOrder_date(orddt);
            dto.setProduct_name(productOrder.get("productName").getAsString());
            dto.setSale_cnt(productOrder.get("quantity").getAsString());
            dto.setUser_name(orders.get("ordererName").getAsString());
            dto.setUser_email("");
            dto.setReceive_name(shippingAddress.get("name").getAsString());
            dto.setShopid(param.get(0).getShopid());
            dto.setShop_userid(param.get(0).getShop_userid());
            dto.setUser_id(orders.get("ordererId").getAsString());
            dto.setP_sku_value(productOrder.get("productOption") == null ? "" : productOrder.get("productOption").getAsString());
            dto.setSku_value(productOrder.get("productOption") == null ? "" : productOrder.get("productOption").getAsString());
            dto.setMall_exp_cd(productId);
            if (orders.get("ordererTel") == null) {
                ordererTel = "";
            } else {
                String str = orders.get("ordererTel").getAsString();
                String first = str.substring(0, str.length() - 8);
                String middle = str.substring(str.length() - 8, str.length() - 4);
                String last = str.substring(str.length() - 4);
                ordererTel = first + "-" + middle + "-" + last;
            }
            dto.setUser_tel((String)ordererTel);
            dto.setUser_cel((String)ordererTel);
            dto.setReceive_tel(shippingAddress.get("tel2") == null ? "" : shippingAddress.get("tel2").getAsString());
            dto.setReceive_cel(shippingAddress.get("tel1") == null ? "" : shippingAddress.get("tel1").getAsString());
            dto.setReceive_zipcode(shippingAddress.get("zipCode") == null ? "" : shippingAddress.get("zipCode").getAsString());
            String receiverAddr = shippingAddress.get("baseAddress") == null ? "" : shippingAddress.get("baseAddress").getAsString().concat(" ").concat(shippingAddress.get("detailedAddress") == null ? "" : shippingAddress.get("detailedAddress").getAsString());
            dto.setReceive_addr(receiverAddr);
            dto.setDelv_cost(productOrder.get("deliveryFeeAmount") == null ? "" : productOrder.get("deliveryFeeAmount").getAsString());
            dto.setDelv_msg(productOrder.get("shippingMemo") == null ? "" : productOrder.get("shippingMemo").getAsString());
            dto.setDelivery_method_str2(this.getDelivery(productOrder.get("shippingFeeType") == null ? "" : productOrder.get("shippingFeeType").getAsString()));
            String ordamt = productOrder.get("totalPaymentAmount").getAsString();
            dto.setMall_won_cost(productOrder.get("expectedSettlementAmount") == null ? "" : productOrder.get("expectedSettlementAmount").getAsString());
            dto.setPay_cost(Integer.toString(Integer.parseInt(ordamt) + Integer.parseInt(productOrder.get("deliveryFeeAmount").getAsString())));
            dto.setTotal_cost(ordamt);
            dto.setSale_cost(Integer.toString(Integer.parseInt(productOrder.get("unitPrice").getAsString()) * Integer.parseInt(dto.getSale_cnt())));
            dto.setCompno(param.get(0).getCompno());
            dto.setReceive_email("");
            dto.setWon_cost("0");
            dto.setBox_ea("0");
            dto.setP_sku_id("");
            dto.setCompayny_goods_cd(this.jsonElementNullStr(productOrder.get("sellerProductCode")));
            dto.setResult_code("1");
            dto.setMall_product_id(productOrder.get("originalProductId").getAsString() + "," + productOrder.get("productId").getAsString());
            list.add(dto);
        }
        return list;
    }

    private class NewOrder {
        @JsonProperty(value="operationName")
        private String operationName;
        @JsonProperty(value="variables")
        private Variables variables = new Variables();
        @JsonProperty(value="query")
        private String query;

        private class Variables {
            @JsonProperty(value="merchantNo")
            private String merchantNo;
            @JsonProperty(value="serviceType")
            private String serviceType;
            @JsonProperty(value="paging_page")
            private int pagingPage;
            @JsonProperty(value="paging_size")
            private int pagingSize;
            @JsonProperty(value="sort_type")
            private String sortType;
            @JsonProperty(value="sort_direction")
            private String sortDirection;
            @JsonProperty(value="summaryInfoType")
            public String summaryInfoType;
            @JsonProperty(value="sellerOrderSearchTypes")
            public String[] sellerOrderSearchTypes;

            private Variables() {
            }
        }
    }
}

