/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.shop.data.naverstore;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.common.YDMATimeUtil;
import com.kdjsystem.mlink.yellim.data.excel.MyDataManagerFactory;
import com.kdjsystem.mlink.yellim.data.excel.MyExcelManager;
import com.kdjsystem.mlink.yellim.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.yellim.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.yellim.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.yellim.shop.data.naverstore.IShopOrderNaverStoreCommand;
import com.kdjsystem.mlink.yellim.shop.data.naverstore.NaverStoreGenerateSignature;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;

public class NaverStoreOrderSearchCommand
extends IShopOrderNaverStoreCommand {
    private static IShopOrderCommand instance = new NaverStoreOrderSearchCommand();

    public static IShopOrderCommand getInstance() {
        return instance;
    }

    private NaverStoreOrderSearchCommand() {
    }

    @Override
    public int Search(String URL2, String startdt, String enddt) throws Exception {
        return super.Search(URL2, startdt, enddt);
    }

    @Override
    public List<ShopOrderMstDto> Completed(List<ShopOrderMstDto> param) throws Exception {
        ArrayList<ShopOrderMstDto> ret = new ArrayList<ShopOrderMstDto>();
        IShopCommonLogin is = new IShopCommonLogin(){};
        Map<Object, Object> cookies = new HashMap();
        List<String> list = Arrays.asList(param.get(0).getApikey().split(","));
        try {
            cookies = list != null && list.size() > 1 ? is.loginCookie(param.get(0).getShop_userid(), param.get(0).getShopPw(), param.get(0).getShopid(), true, param.get(0).getAuthkey1(), list.get(0), list.get(1)) : is.loginCookie(param.get(0).getShop_userid(), param.get(0).getShopPw(), param.get(0).getShopid(), true, param.get(0).getAuthkey1());
            String start = YDMATimeUtil.getTime(param.get(0).getStartDt());
            String end = YDMATimeUtil.getTime(param.get(0).getEndDt());
            if (param.get(0).getVendorId().equals("N")) {
                this.orderCancel(param, ret, cookies, start, end);
                this.orderReturnList(param, ret, cookies, start, end);
                this.orderExChange(param, ret, cookies, start, end);
                this.delvCompleted(param, ret, cookies, start, end);
                this.delvCompleted2(param, ret, cookies, start, end);
            } else {
                NaverStoreGenerateSignature naverStroeGenerateSignature = new NaverStoreGenerateSignature();
                String startdt = param.get(0).getStartDt().substring(0, 8);
                String enddt = param.get(0).getEndDt().substring(0, 8);
                SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
                Date sdate = formatter.parse(startdt);
                Date edate = formatter.parse(enddt);
                long range = Math.abs((edate.getTime() - sdate.getTime()) / 86400000L) + 1L;
                Calendar cal1 = Calendar.getInstance();
                cal1.setTime(sdate);
                String clientId = param.get(0).getEDITAUTHKEY1();
                String clientSecret = param.get(0).getEDITAPIKEY();
                Long timestamp = System.currentTimeMillis();
                String secretSign = naverStroeGenerateSignature.generateSignature(clientId, clientSecret, timestamp);
                String accessToken = naverStroeGenerateSignature.accessToken(secretSign, clientId, timestamp, "client_credentials", "SELF");
                int i = 0;
                while (i < (int)range) {
                    this.orderCancelApi(param, ret, accessToken, sdate);
                    this.orderReturnListApi(param, ret, accessToken, sdate);
                    this.orderExChangeApi(param, ret, accessToken, sdate);
                    this.delvCompletedApi(param, ret, accessToken, sdate);
                    cal1.add(5, 1);
                    startdt = formatter.format(cal1.getTime());
                    sdate = formatter.parse(startdt);
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("\ub124\uc774\ubc84 \ub3d9\uae30\ud654 \uc911 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd \ud588\uc2b5\ub2c8\ub2e4. ");
        }
        return ret;
    }

    private void delvCompleted(List<ShopOrderMstDto> param, List<ShopOrderMstDto> ret, Map<String, String> cookies, String start, String end) throws Exception {
        Connection.Response rs = Jsoup.connect((String)"https://sell.smartstore.naver.com/o/v3/n/sale/delivery").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/107.0.0.0 Safari/537.36").referrer("https://sell.smartstore.naver.com/").method(Connection.Method.GET).ignoreContentType(true).followRedirects(true).execute();
        Document doc = Jsoup.parseBodyFragment((String)rs.body());
        Elements data2 = doc.select("script");
        String dataStr = data2.stream().filter(p -> p.toString().contains("merchantNo")).map(p -> p.toString().substring(p.toString().indexOf("merchantNo"))).findAny().orElseGet(() -> null);
        String merchantNo = dataStr.substring(0, dataStr.indexOf(",")).replace("\\\"", "").split(":")[1];
        String DeliveryComplted = this.getDeliveryCompltedOrderStringParam(merchantNo, start, end);
        JsonParser parser = new JsonParser();
        rs = Jsoup.connect((String)"https://sell.smartstore.naver.com/o/v3/graphql").header("Host", "sell.smartstore.naver.com").header("Content-Type", "application/json").cookies(cookies).requestBody(DeliveryComplted).method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).ignoreHttpErrors(true).execute();
        String body = rs.body();
        JsonObject jsonobject = (JsonObject)parser.parse(body);
        JsonObject obj1 = (JsonObject)jsonobject.get("data");
        JsonObject obj2 = (JsonObject)obj1.get("deliveryStatusListMp");
        JsonArray jsonArray = (JsonArray)obj2.get("elements");
        if (jsonArray.size() > 0) {
            int i = 0;
            while (i < jsonArray.size()) {
                JsonObject object = (JsonObject)jsonArray.get(i);
                String orderid = object.get("orderNo").getAsString();
                String mallid = object.get("productNo").getAsString();
                String expid = object.get("productOrderNo").getAsString();
                for (ShopOrderMstDto dto : param) {
                    if (!dto.getOrder_id().equals(orderid) || !dto.getMall_product_id().substring(dto.getMall_product_id().lastIndexOf(",") + 1).equals(mallid) || !dto.getMall_exp_cd().equals(expid)) continue;
                    dto.setResult_code("1");
                    dto.setOrder_status("410");
                    ret.add(dto);
                }
                ++i;
            }
        }
    }

    private void delvCompleted2(List<ShopOrderMstDto> param, List<ShopOrderMstDto> ret, Map<String, String> cookies, String start, String end) throws Exception {
        Connection.Response rs = Jsoup.connect((String)"https://sell.smartstore.naver.com/o/v3/n/sale/delivery").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/107.0.0.0 Safari/537.36").referrer("https://sell.smartstore.naver.com/").method(Connection.Method.GET).ignoreContentType(true).followRedirects(true).execute();
        Document doc = Jsoup.parseBodyFragment((String)rs.body());
        Elements data2 = doc.select("script");
        String dataStr = data2.stream().filter(p -> p.toString().contains("merchantNo")).map(p -> p.toString().substring(p.toString().indexOf("merchantNo"))).findAny().orElseGet(() -> null);
        String merchantNo = dataStr.substring(0, dataStr.indexOf(",")).replace("\\\"", "").split(":")[1];
        String PurchaseDecision = this.getPurchaseDecisionOrderStringParam(merchantNo, start, end);
        JsonParser parser = new JsonParser();
        rs = Jsoup.connect((String)"https://sell.smartstore.naver.com/o/v3/graphql").header("Host", "sell.smartstore.naver.com").header("Content-Type", "application/json").cookies(cookies).requestBody(PurchaseDecision).method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).ignoreHttpErrors(true).execute();
        String body = rs.body();
        JsonObject jsonobject = (JsonObject)parser.parse(body);
        JsonObject obj1 = (JsonObject)jsonobject.get("data");
        JsonObject obj2 = (JsonObject)obj1.get("purchaseDecisionList");
        JsonArray jsonArray = (JsonArray)obj2.get("elements");
        if (jsonArray.size() > 0) {
            int i = 0;
            while (i < jsonArray.size()) {
                JsonObject object = (JsonObject)jsonArray.get(i);
                String orderid = object.get("orderNo").getAsString();
                String mallid = object.get("productNo").getAsString();
                String expid = object.get("productOrderNo").getAsString();
                for (ShopOrderMstDto dto : param) {
                    if (!dto.getOrder_id().equals(orderid) || !dto.getMall_product_id().substring(dto.getMall_product_id().lastIndexOf(",") + 1).equals(mallid) || !dto.getMall_exp_cd().equals(expid)) continue;
                    dto.setResult_code("1");
                    dto.setOrder_status("410");
                    ret.add(dto);
                }
                ++i;
            }
        }
    }

    private void orderCancel(List<ShopOrderMstDto> param, List<ShopOrderMstDto> ret, Map<String, String> cookies, String start, String end) throws IOException, CloneNotSupportedException {
        Connection.Response rs = Jsoup.connect((String)"https://sell.smartstore.naver.com/o/v3/n/sale/delivery").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").referrer("https://sell.smartstore.naver.com/").method(Connection.Method.GET).ignoreContentType(true).followRedirects(true).execute();
        Document doc = Jsoup.parseBodyFragment((String)rs.body());
        Elements data2 = doc.select("script");
        String dataStr = data2.stream().filter(p -> p.toString().contains("merchantNo")).map(p -> p.toString().substring(p.toString().indexOf("merchantNo"))).findAny().orElseGet(() -> null);
        String merchantNo = dataStr.substring(0, dataStr.indexOf(",")).replace("\\\"", "").split(":")[1];
        int k = 0;
        while (k < 2) {
            String status2 = this.getStatusCancel(k);
            String json = "{\"operationName\":\"findClaimCancelsBySummaryInfoTypeMp_ForClaimCancel\",\"variables\":{\"merchantNo\":\"" + merchantNo + "\",\"serviceType\":\"MP\",\"paging_page\":1,\"paging_size\":100,\"sellerOrderSearchTypes\":[\"NORMAL_ORDER\",\"TODAY_DISPATCH\",\"PRE_ORDER\",\"SUBSCRIPTION\",\"RENTAL\"],\"summaryInfoType\":\"" + status2 + "\"},\"query\":\"query findClaimCancelsBySummaryInfoTypeMp_ForClaimCancel($merchantNo: String!, $paging_page: Int, $paging_size: Int, $serviceType: String!, $sort_direction: SortDirectionType, $sort_type: SortType, $summaryInfoType: SummaryInfoType!, $sellerOrderSearchTypes: [String]!) {\\n  cancelListMp: findClaimCancelsBySummaryInfoTypeMp_ForClaimCancel(merchantNo: $merchantNo, paging_page: $paging_page, paging_size: $paging_size, serviceType: $serviceType, sort_direction: $sort_direction, sort_type: $sort_type, summaryInfoType: $summaryInfoType, sellerOrderSearchTypes: $sellerOrderSearchTypes) {\\n    elements {\\n      ...cancelElementField\\n      __typename\\n    }\\n    pagination {\\n      ...paginationField\\n      __typename\\n    }\\n    __typename\\n  }\\n}\\n\\nfragment cancelElementField on CancelClaimSeller {\\n  deliveryFeeAmt\\n  deliveryFeeClass\\n  biztalkAccountId\\n  giftName\\n  receiverTelNo2\\n  productPayAmt\\n  receiverTelNo1\\n  productUnitPrice\\n  cancelDateTime\\n  orderQuantity\\n  productName\\n  claimRequestOperatorType\\n  clamRequestDateTime\\n  orderMemberName\\n  payDateTime\\n  productOrderNo\\n  productOptionContents\\n  deliveryFeeRatingClass\\n  orderMemberId\\n  orderMemberNo\\n  productOptionAmt\\n  discountAmtChangedInfo\\n  productNo\\n  refundExpectDateTime\\n  totalDiscountAmt\\n  claimRequestAdmissionOperator\\n  orderNo\\n  productClass\\n  receiverName\\n  deliveryFeeChangedInfo\\n  claimRequestReason\\n  refundOperator\\n  saleChannelType\\n  receiverAddress\\n  deliveryFeeDiscountAmt\\n  receiverZipCode\\n  sellerProductManagementCode\\n  syncDateTime\\n  productOrderStatus\\n  sellerInternalCode2\\n  claimRequestAdmissionDateTime\\n  sellerInternalCode1\\n  deliveryBundleGroupSeq\\n  productUrl\\n  claimStatus\\n  orderMemberTelNo\\n  fulfillmentCompanyName\\n  deliveryAttributeText\\n  __typename\\n}\\n\\nfragment paginationField on Pagination {\\n  size\\n  totalElements\\n  page\\n  totalPages\\n  __typename\\n}\\n\"}";
            JsonParser parser = new JsonParser();
            rs = Jsoup.connect((String)"https://sell.smartstore.naver.com/o/v3/graphql").header("Host", "sell.smartstore.naver.com").header("Content-Type", "application/json").cookies(cookies).requestBody(json).method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).ignoreHttpErrors(true).execute();
            String body = rs.body();
            JsonObject jsonobject = (JsonObject)parser.parse(body);
            JsonObject obj1 = (JsonObject)jsonobject.get("data");
            JsonObject obj2 = (JsonObject)obj1.get("cancelListMp");
            JsonArray jsonArray = (JsonArray)obj2.get("elements");
            if (jsonArray.size() > 0) {
                int i = 0;
                while (i < jsonArray.size()) {
                    JsonObject object = (JsonObject)jsonArray.get(i);
                    String orderid = object.get("orderNo").getAsString();
                    String mallid = object.get("productNo").getAsString();
                    String expid = object.get("productOrderNo").getAsString();
                    for (ShopOrderMstDto dto : param) {
                        if (!dto.getOrder_id().equals(orderid) || !dto.getMall_product_id().substring(dto.getMall_product_id().lastIndexOf(",") + 1).equals(mallid) || !dto.getMall_exp_cd().equals(expid)) continue;
                        dto.setOrder_status(this.getStatusCancel(object.get("claimStatus").getAsString()));
                        dto.setResult_code("1");
                        if (dto.getOrder_status().equals("C02")) {
                            ShopOrderMstDto temp = dto.clone("C02");
                            try {
                                String orddt = YDMATimeUtil.getDate(object.get("claimRequestAdmissionDateTime").getAsString());
                                temp.setOrder_date(orddt);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            ret.add(temp);
                        }
                        ret.add(dto);
                    }
                    ++i;
                }
            }
            ++k;
        }
    }

    private void orderReturnList(List<ShopOrderMstDto> param, List<ShopOrderMstDto> ret, Map<String, String> cookies, String start, String end) throws IOException, CloneNotSupportedException {
        Connection.Response rs = Jsoup.connect((String)"https://sell.smartstore.naver.com/o/v3/n/sale/delivery").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").referrer("https://sell.smartstore.naver.com/").method(Connection.Method.GET).ignoreContentType(true).followRedirects(true).execute();
        Document doc = Jsoup.parseBodyFragment((String)rs.body());
        Elements data2 = doc.select("script");
        String dataStr = data2.stream().filter(p -> p.toString().contains("merchantNo")).map(p -> p.toString().substring(p.toString().indexOf("merchantNo"))).findAny().orElseGet(() -> null);
        String merchantNo = dataStr.substring(0, dataStr.indexOf(",")).replace("\\\"", "").split(":")[1];
        int k = 0;
        while (k < 4) {
            String status2 = this.getStatusReturn(k);
            String json = "{\"operationName\":\"findClaimReturnsBySummaryInfoTypeMp_ForClaimReturn\",\"variables\":{\"merchantNo\":\"" + merchantNo + "\",\"serviceType\":\"MP\",\"paging_page\":1,\"paging_size\":100,\"summaryInfoType\":\"" + status2 + "\",\"sellerOrderSearchTypes\":[\"NORMAL_ORDER\",\"TODAY_DISPATCH\",\"PRE_ORDER\",\"SUBSCRIPTION\",\"RENTAL\"]},\"query\":\"query findClaimReturnsBySummaryInfoTypeMp_ForClaimReturn($merchantNo: String!, $paging_page: Int, $paging_size: Int, $serviceType: String!, $sort_direction: SortDirectionType, $sort_type: SortType, $summaryInfoType: SummaryInfoType!, $sellerOrderSearchTypes: [String]!) {\\n  returnList: findClaimReturnsBySummaryInfoTypeMp_ForClaimReturn(merchantNo: $merchantNo, paging_page: $paging_page, paging_size: $paging_size, serviceType: $serviceType, sort_direction: $sort_direction, sort_type: $sort_type, summaryInfoType: $summaryInfoType, sellerOrderSearchTypes: $sellerOrderSearchTypes) {\\n    elements {\\n      ...returnElementField\\n      __typename\\n    }\\n    pagination {\\n      ...paginationField\\n      __typename\\n    }\\n    __typename\\n  }\\n}\\n\\nfragment returnElementField on ClaimReturnSeller {\\n  returnCareTarget\\n  deliveryFeeClass\\n  holdbackStatus\\n  deliveryInvoiceNo\\n  claimExtraFeePayAmt\\n  orderQuantity\\n  productName\\n  payDateTime\\n  deliveryFeeRatingClass\\n  orderMemberId\\n  discountAmtChangedInfo\\n  refundExpectDateTime\\n  claimCollectStatusExposureText\\n  totalDiscountAmt\\n  orderNo\\n  productClass\\n  claimCollectDateTime\\n  deliveryFeeChangedInfo\\n  claimRequestDateTime\\n  claimRequestReason\\n  backDeliveryInvoiceNo\\n  refundOperator\\n  saleChannelType\\n  deliveryCompanyName\\n  sellerProductManagementCode\\n  holdbackReleaseDateTime\\n  claimStatus\\n  holdbackConfigDateTime\\n  orderMemberTelNo\\n  orderMemberNo\\n  deliveryFeeAmt\\n  claimNo\\n  backDeliveryMethodExposureText\\n  deliveryMethod\\n  biztalkAccountId\\n  branchDeliveryStartDateTime\\n  branchDeliveryEndDateTime\\n  branchId\\n  merchantChannelNo\\n  giftName\\n  receiverTelNo2\\n  productPayAmt\\n  receiverTelNo1\\n  claimCollectStatus\\n  productUnitPrice\\n  claimRequestOperatorType\\n  orderMemberName\\n  productOrderNo\\n  productOptionContents\\n  claimCollectAddress\\n  claimDeliveryFeeAmt\\n  productOptionAmt\\n  productNo\\n  returnReceiveAddress\\n  backDeliveryCompanyName\\n  receiverName\\n  deliveryNo\\n  refundDateTime\\n  deliveryFeeDiscountAmt\\n  claimRejectDetail\\n  backDeliveryMethod\\n  syncDateTime\\n  productOrderStatus\\n  backDeliveryNo\\n  sellerInternalCode2\\n  sellerInternalCode1\\n  deliveryBundleGroupSeq\\n  productUrl\\n  claimDeliveryFeePayMethod\\n  claimExtraFeePayMethod\\n  fulfillmentCompanyName\\n  collectRemoteAreaCostChargeAmt\\n  claimRequestReasonCollectFail\\n  deliveryAttributeText\\n  __typename\\n}\\n\\nfragment paginationField on Pagination {\\n  size\\n  totalElements\\n  page\\n  totalPages\\n  __typename\\n}\\n\"}";
            JsonParser parser = new JsonParser();
            rs = Jsoup.connect((String)"https://sell.smartstore.naver.com/o/v3/graphql").header("Host", "sell.smartstore.naver.com").header("Sec-Fetch-Site", "same-origin").header("Sec-Fetch-Mode", "cors").header("Sec-Fetch-Dest", "empty").header("Origin", "https://sell.smartstore.naver.com").header("Connection", "keep-alive").header("Content-Type", "application/json").header("Accept", "application/json").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").requestBody(json).referrer("https://sell.smartstore.naver.com/o/v3/iframe/claim/return").method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).ignoreHttpErrors(true).execute();
            String body = rs.body();
            JsonObject jsonobject = (JsonObject)parser.parse(body);
            JsonObject obj1 = (JsonObject)jsonobject.get("data");
            JsonObject obj2 = (JsonObject)obj1.get("returnList");
            JsonArray jsonArray = (JsonArray)obj2.get("elements");
            if (jsonArray.size() > 0) {
                int i = 0;
                while (i < jsonArray.size()) {
                    JsonObject object = (JsonObject)jsonArray.get(i);
                    String orderid = object.get("orderNo").getAsString();
                    String mallid = object.get("productNo").getAsString();
                    String expid = object.get("productOrderNo").getAsString();
                    for (ShopOrderMstDto dto : param) {
                        if (!dto.getOrder_id().equals(orderid) || !dto.getMall_product_id().substring(dto.getMall_product_id().lastIndexOf(",") + 1).equals(mallid) || !dto.getMall_exp_cd().equals(expid)) continue;
                        dto.setOrder_status(this.getStatusReturn(object.get("claimStatus").getAsString()));
                        dto.setResult_code("1");
                        if (dto.getOrder_status().equals("R02")) {
                            ShopOrderMstDto temp = dto.clone("R02");
                            try {
                                String orddt = YDMATimeUtil.getDate(object.get("refundDateTime").getAsString());
                                temp.setOrder_date(orddt);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            ret.add(temp);
                        }
                        ret.add(dto);
                    }
                    ++i;
                }
            }
            ++k;
        }
    }

    private String getStatusCancel(String asString) {
        String value = "";
        switch (asString) {
            case "CANCEL_REQUEST": {
                value = "C01";
                break;
            }
            case "CANCELING": {
                value = "C01";
                break;
            }
            case "CANCEL_DONE": {
                value = "C02";
                break;
            }
            case "CANCEL_REJECT": {
                value = "C01";
            }
        }
        return value;
    }

    private String getStatusCancel(int k) {
        String value = "";
        switch (k) {
            case 0: {
                value = "CANCEL_REQUEST";
                break;
            }
            case 1: {
                value = "CANCEL_DONE";
            }
        }
        return value;
    }

    private String getStatusReturn(String asString) {
        String value = "";
        switch (asString) {
            case "RETURN_REQUEST": {
                value = "R01";
                break;
            }
            case "COLLECTING": {
                value = "R01";
                break;
            }
            case "COLLECT_DONE": {
                value = "R01";
                break;
            }
            case "RETURN_DONE": {
                value = "R02";
                break;
            }
            case "RETURN_REJECT": {
                value = "R01";
            }
        }
        return value;
    }

    private String getStatusReturn(int k) {
        String value = "";
        switch (k) {
            case 0: {
                value = "RETURN_REQUEST";
                break;
            }
            case 1: {
                value = "RETURN_COLLECTING";
                break;
            }
            case 2: {
                value = "RETURN_COLLECT_DONE";
                break;
            }
            case 3: {
                value = "RETURN_DONE";
            }
        }
        return value;
    }

    private void orderExChange(List<ShopOrderMstDto> param, List<ShopOrderMstDto> ret, Map<String, String> cookies, String start, String end) throws IOException, CloneNotSupportedException {
        Connection.Response rs = Jsoup.connect((String)"https://sell.smartstore.naver.com/o/v3/n/sale/delivery").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").referrer("https://sell.smartstore.naver.com/").method(Connection.Method.GET).ignoreContentType(true).followRedirects(true).execute();
        Document doc = Jsoup.parseBodyFragment((String)rs.body());
        Elements data2 = doc.select("script");
        String dataStr = data2.stream().filter(p -> p.toString().contains("merchantNo")).map(p -> p.toString().substring(p.toString().indexOf("merchantNo"))).findAny().orElseGet(() -> null);
        String merchantNo = dataStr.substring(0, dataStr.indexOf(",")).replace("\\\"", "").split(":")[1];
        int k = 0;
        while (k < 4) {
            String status2 = this.getStatus(k);
            String json = "{\"operationName\":\"SmartStoreFindClaimExchangesBySummaryInfoType_ForClaimExchange\",\"variables\":{\"merchantNo\":\"" + merchantNo + "\",\"serviceType\":\"MP\",\"paging_page\":1,\"paging_size\":100,\"summaryInfoType\":\"" + status2 + "\",\"sellerOrderSearchTypes\":[\"NORMAL_ORDER\",\"TODAY_DISPATCH\",\"PRE_ORDER\",\"SUBSCRIPTION\",\"RENTAL\"]},\"query\":\"query SmartStoreFindClaimExchangesBySummaryInfoType_ForClaimExchange($merchantNo: String!, $serviceType: String!, $paging_page: Int, $paging_size: Int, $sort_direction: SortDirectionType, $sort_type: SortType, $summaryInfoType: SummaryInfoType!, $sellerOrderSearchTypes: [String]!) {\\n  exchangeList: SmartStoreFindClaimExchangesBySummaryInfoType_ForClaimExchange(merchantNo: $merchantNo, serviceType: $serviceType, paging_page: $paging_page, paging_size: $paging_size, sort_direction: $sort_direction, sort_type: $sort_type, summaryInfoType: $summaryInfoType, sellerOrderSearchTypes: $sellerOrderSearchTypes) {\\n    elements {\\n      ...exchangeElementField\\n      __typename\\n    }\\n    pagination {\\n      ...paginationField\\n      __typename\\n    }\\n    __typename\\n  }\\n}\\n\\nfragment exchangeElementField on ClaimExchangeSeller {\\n  returnCareTarget\\n  branchId\\n  merchantChannelNo\\n  deliveryFeeClass\\n  redeliveryOperationDateTime\\n  holdbackStatus\\n  deliveryInvoiceNo\\n  claimExtraFeePayAmt\\n  reDeliveryNo\\n  orderQuantity\\n  productName\\n  claimType\\n  payDateTime\\n  deliveryFeeRatingClass\\n  purchaseDecisionExtensionReasonDetailContent\\n  orderMemberId\\n  reDeliveryStatus\\n  claimCollectStatusExposureText\\n  totalDiscountAmt\\n  claimRejectDetailContent\\n  orderNo\\n  productClass\\n  claimCollectDateTime\\n  reDeliveryInvoiceNo\\n  purchaseDecisionExtensionReason\\n  claimRequestReason\\n  backDeliveryInvoiceNo\\n  exchangeRequestDateTime\\n  reDeliveryCompanyName\\n  deliveryCompanyName\\n  sellerProductManagementCode\\n  holdbackReleaseDateTime\\n  claimStatus\\n  holdbackConfigDateTime\\n  orderMemberTelNo\\n  orderMemberNo\\n  purchaseDecisionExtensionDateTime\\n  deliveryFeeAmt\\n  claimNo\\n  backDeliveryMethodExposureText\\n  deliveryMethod\\n  biztalkAccountId\\n  giftName\\n  receiverTelNo2\\n  productPayAmt\\n  receiverTelNo1\\n  claimCollectStatus\\n  productUnitPrice\\n  claimRequestOperatorType\\n  orderMemberName\\n  productOrderNo\\n  productOptionContents\\n  claimCollectAddress\\n  claimDeliveryFeeAmt\\n  productOptionAmt\\n  productNo\\n  purchaseDecisionExpectDateTime\\n  returnReceiveAddress\\n  backDeliveryCompanyName\\n  receiverName\\n  deliveryNo\\n  deliveryFeeDiscountAmt\\n  reDeliveryMethod\\n  syncDateTime\\n  productOrderStatus\\n  backDeliveryNo\\n  sellerInternalCode2\\n  sellerInternalCode1\\n  deliveryBundleGroupSeq\\n  productUrl\\n  claimDeliveryFeePayMethod\\n  claimExtraFeePayMethod\\n  fulfillmentCompanyName\\n  collectRemoteAreaCostChargeAmt\\n  claimRequestReasonCollectFail\\n  deliveryAttributeText\\n  __typename\\n}\\n\\nfragment paginationField on Pagination {\\n  size\\n  totalElements\\n  page\\n  totalPages\\n  __typename\\n}\\n\"}";
            JsonParser parser = new JsonParser();
            rs = Jsoup.connect((String)"https://sell.smartstore.naver.com/o/v3/graphql").header("Host", "sell.smartstore.naver.com").header("Sec-Fetch-Site", "same-origin").header("Sec-Fetch-Mode", "cors").header("Sec-Fetch-Dest", "empty").header("Origin", "https://sell.smartstore.naver.com").header("Connection", "keep-alive").header("Content-Type", "application/json").header("Host", "sell.smartstore.naver.com").header("Accept", "application/json").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").requestBody(json).referrer("https://sell.smartstore.naver.com/o/v3/iframe/claim/exchange").method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).ignoreHttpErrors(true).execute();
            String body = rs.body();
            JsonObject jsonobject = (JsonObject)parser.parse(body);
            JsonObject obj1 = (JsonObject)jsonobject.get("data");
            JsonObject obj2 = (JsonObject)obj1.get("exchangeList");
            JsonArray jsonArray = (JsonArray)obj2.get("elements");
            if (jsonArray.size() > 0) {
                int i = 0;
                while (i < jsonArray.size()) {
                    JsonObject object = (JsonObject)jsonArray.get(i);
                    String orderid = object.get("orderNo").getAsString();
                    String mallid = object.get("productNo").getAsString();
                    String expid = object.get("productOrderNo").getAsString();
                    for (ShopOrderMstDto dto : param) {
                        if (!dto.getOrder_id().equals(orderid) || !dto.getMall_product_id().substring(dto.getMall_product_id().lastIndexOf(",") + 1).equals(mallid) || !dto.getMall_exp_cd().equals(expid)) continue;
                        dto.setOrder_status(this.getStatusexChange(object.get("claimStatus").getAsString()));
                        dto.setResult_code("1");
                        if (dto.getOrder_status().equals("E02")) {
                            dto.setOrder_status("403");
                            dto.setResult_code("1");
                            ShopOrderMstDto temp = dto.clone("E02");
                            try {
                                String orddt = YDMATimeUtil.getDate(object.get("redeliveryOperationDateTime").getAsString());
                                temp.setOrder_date(orddt);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            ret.add(temp);
                        }
                        ret.add(dto);
                    }
                    ++i;
                }
            }
            ++k;
        }
    }

    private void orderAllList(List<ShopOrderMstDto> param, List<ShopOrderMstDto> ret, Map<String, String> cookies, String start, String end) throws IOException {
        Connection.Response rs = Jsoup.connect((String)"https://sell.smartstore.naver.com/o/v3/iframe/n/sale/delivery").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").referrer("https://sell.smartstore.naver.com/").method(Connection.Method.GET).ignoreContentType(true).followRedirects(true).execute();
        Document doc = Jsoup.parseBodyFragment((String)rs.body());
        Elements data2 = doc.select("script");
        String user = ((Node)((Element)data2.get(5)).childNodes().get(0)).toString();
        JsonParser jsonparser = new JsonParser();
        JsonObject jsonobject = (JsonObject)jsonparser.parse(user.substring(user.indexOf("{"), user.lastIndexOf("}") + 1));
        String json = "{\"operationName\":\"smartstoreFindDeliveriesByDetailConditions_ForSaleDelivery\",\"variables\":{\"merchantNo\":\"" + jsonobject.get("merchantNo").getAsString() + "\",\"serviceType\":\"MP\",\"paging_page\":1,\"paging_size\":500,\"sort_type\":\"RECENTLY_ORDER_YMDT\",\"sort_direction\":\"DESC\",\"orderStatus\":\"ALL\",\"rangeType\":\"PAY_COMPLETED\",\"dateRange_from\":\"" + start + "\",\"dateRange_to\":\"" + end + "\",\"detailedOrderStatus\":\"ALL\"},\"query\": \"query smartstoreFindDeliveriesByDetailConditions_ForSaleDelivery($dateRange_from: String, $dateRange_to: String, $delayDispatchGuideTreatStateType: DelayDispatchGuideTreatStateType, $deliveryDirectionClass: DeliveryDirectionClassType, $deliveryMethodType: DeliveryMethodType, $deliveryNo: String, $detailSearch_keyword: String, $detailSearch_type: DetailSearchType, $detailedOrderStatus: DetailedSearchOrderStatusType, $deviceClassType: DeviceClassType, $merchantNo: String!, $orderStatus: SearchOrderStatusType, $paging_page: Int, $paging_size: Int, $rangeType: RangeType, $serviceType: ServiceType!, $sort_direction: SortDirectionType, $sort_type: SortType) {\\n  deliveryList: smartstoreFindDeliveriesByDetailConditions_ForSaleDelivery(dateRange_from: $dateRange_from, dateRange_to: $dateRange_to, delayDispatchGuideTreatStateType: $delayDispatchGuideTreatStateType, deliveryDirectionClass: $deliveryDirectionClass, deliveryMethodType: $deliveryMethodType, deliveryNo: $deliveryNo, detailSearch_keyword: $detailSearch_keyword, detailSearch_type: $detailSearch_type, detailedOrderStatus: $detailedOrderStatus, deviceClassType: $deviceClassType, merchantNo: $merchantNo, orderStatus: $orderStatus, paging_page: $paging_page, paging_size: $paging_size, rangeType: $rangeType, serviceType: $serviceType, sort_direction: $sort_direction, sort_type: $sort_type) {\\n    elements {\\n      ...deliveryElementField\\n      __typename\\n    }\\n    pagination {\\n      ...paginationField\\n      __typename\\n    }\\n    __typename\\n  }\\n}\\n\\nfragment deliveryElementField on DeliveryMp {\\n  returnCareTarget\\n  branchId\\n  merchantChannelNo\\n  deliveryFeeClass\\n  deliveryInvoiceNo\\n  orderQuantity\\n  productName\\n  payDateTime\\n  deliveryDateTime\\n  deliveryFeeRatingClass\\n  productOrderMemo\\n  orderMemberId\\n  remoteAreaCostChargeAmt\\n  salesCommissionPrepay\\n  payLocationType\\n  totalDiscountAmt\\n  orderNo\\n  payMeansClass\\n  productClass\\n  commissionClassType\\n  oneYearOrderAmt\\n  saleChannelType\\n  oneYearOrderCount\\n  receiverAddress\\n  deliveryCompanyName\\n  sellerProductManagementCode\\n  grade\\n  sellingInterlockCommissionClassType\\n  sellingInterlockCommissionInflowPath\\n  orderMemberTelNo\\n  deliveryFeeAmt\\n  claimNo\\n  deliveryMethod\\n  deliveryMethodPay\\n  biztalkAccountId\\n  giftName\\n  receiverTelNo2\\n  productPayAmt\\n  receiverTelNo1\\n  sixMonthOrderAmt\\n  orderStatus\\n  productUnitPrice\\n  waybillPrintDateTime\\n  threeMonthOrderCount\\n  orderMemberName\\n  productOrderNo\\n  deliveryCompanyCode\\n  productOptionContents\\n  dispatchDueDateTime\\n  knowledgeShoppingCommissionAmt\\n  productOptionAmt\\n  productNo\\n  individualCustomUniqueCode\\n  orderDateTime\\n  placingOrderDateTime\\n  inflowPath\\n  receiverName\\n  settlementExpectAmt\\n  deliveryNo\\n  threeMonthOrderAmt\\n  sellerDiscountAmt\\n  deliveryFeeDiscountAmt\\n  dispatchDateTime\\n  sixMonthOrderCount\\n  receiverZipCode\\n  payCommissionAmt\\n  takingGoodsPlaceAddress\\n  syncDateTime\\n  productOrderStatus\\n  sellerInternalCode2\\n  sellerOptionManagementCode\\n  sellerInternalCode1\\n  deliveryBundleGroupSeq\\n  productUrl\\n  subscriptionRound\\n  subscriptionPeriodCount\\n  fulfillmentCompanyName\\n  __typename\\n}\\n\\nfragment paginationField on Pagination {\\n  size\\n  totalElements\\n  page\\n  totalPages\\n  __typename\\n}\\n\"}";
        jsonparser = new JsonParser();
        rs = Jsoup.connect((String)"https://sell.smartstore.naver.com/o/v3/graphql").header("Host", "sell.smartstore.naver.com").header("Sec-Fetch-Site", "same-origin").header("Sec-Fetch-Mode", "cors").header("Sec-Fetch-Dest", "empty").header("Origin", "https://sell.smartstore.naver.com").header("Connection", "keep-alive").header("Content-Type", "application/json").header("Host", "sell.smartstore.naver.com").header("Accept", "application/json").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").requestBody(json).referrer("https://sell.smartstore.naver.com/o/v3/iframe/n/sale/delivery").method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).ignoreHttpErrors(true).execute();
        String body = rs.body();
        jsonobject = (JsonObject)jsonparser.parse(body);
        JsonObject obj1 = (JsonObject)jsonobject.get("data");
        JsonObject obj2 = (JsonObject)obj1.get("deliveryList");
        JsonArray jsonArray = (JsonArray)obj2.get("elements");
        if (jsonArray.size() > 0) {
            int i = 0;
            while (i < jsonArray.size()) {
                JsonObject object = (JsonObject)jsonArray.get(i);
                String orderid = object.get("orderNo").getAsString();
                String mallid = object.get("productNo").getAsString();
                String expid = object.get("productOrderNo").getAsString();
                for (ShopOrderMstDto dto : param) {
                    if (!dto.getOrder_id().equals(orderid) || !dto.getMall_product_id().substring(dto.getMall_product_id().lastIndexOf(",") + 1).equals(mallid) || !dto.getMall_exp_cd().equals(expid)) continue;
                    dto.setOrder_status(this.getStatus(object.get("orderStatus").getAsString(), this.jsonElementNullStr(object.get("productOrderStatus"))));
                    dto.setResult_code("1");
                    ret.add(dto);
                }
                ++i;
            }
        }
    }

    @Override
    public String jsonElementNullStr(JsonElement val) {
        if (val.isJsonNull()) {
            return "";
        }
        return val.getAsString();
    }

    private String getStatus(int i) {
        String value = "";
        switch (i) {
            case 0: {
                value = "EXCHANGE_REQUEST";
                break;
            }
            case 1: {
                value = "EXCHANGE_COLLECTING";
                break;
            }
            case 2: {
                value = "EXCHANGE_COLLECT_DONE";
                break;
            }
            case 3: {
                value = "EXCHANGE_DONE";
            }
        }
        return value;
    }

    private String getStatusexChange(String string) {
        String value = "";
        switch (string) {
            case "EXCHANGE_REQUEST": {
                value = "E01";
                break;
            }
            case "COLLECTING": {
                value = "E01";
                break;
            }
            case "COLLECT_DONE": {
                value = "E01";
                break;
            }
            case "EXCHANGE_REDELIVERING": {
                value = "E02";
                break;
            }
            case "EXCHANGE_DONE": {
                value = "E02";
                break;
            }
            case "EXCHANGE_REJECT": {
                value = "E01";
            }
        }
        return value;
    }

    private String getStatus(String string, String string2) {
        String value = "";
        switch (string) {
            case "WAITING_DISPATCH": {
                value = "100";
                break;
            }
            case "DELIVERING": {
                value = "403";
                break;
            }
            case "DELIVERED": {
                value = "410";
            }
        }
        return value;
    }

    public List<ShopOrderMstDto> getExcellFileManager(String path, List<ShopOrderMstDto> param, String orderStatus) throws Exception {
        ArrayList<ShopOrderMstDto> dtolist = new ArrayList<ShopOrderMstDto>();
        try {
            MyExcelManager myExcelManager = null;
            myExcelManager = MyDataManagerFactory.createExcelManager(path);
            List<List<String>> sheetContents = null;
            myExcelManager.loadData();
            sheetContents = myExcelManager.getSheetContents(0, 1);
            for (List<String> list : sheetContents) {
                ShopOrderMstDto dto = param.stream().filter(p -> p.getOrder_id() != null && p.getOrder_id().equals(list.get(1))).findAny().orElse(null);
                if (dto == null) continue;
                dto.setOrder_status(orderStatus);
                dto.setResult_code("1");
                dtolist.add(dto);
            }
        }
        catch (Exception exception) {
            throw new Exception("\ub124\uc774\ubc84 \uc5d1\uc140\ud30c\uc77c \uc0c1\ud0dc\uac12 \ubcc0\uacbd\ud558\ub294\uc911 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd \ud588\uc2b5\ub2c8\ub2e4.");
        }
        return dtolist;
    }

    public List<ShopOrderMstDto> getExcellFileManager2(String path, List<ShopOrderMstDto> param) throws Exception {
        ArrayList<ShopOrderMstDto> dtolist = new ArrayList<ShopOrderMstDto>();
        try {
            MyExcelManager myExcelManager = null;
            myExcelManager = MyDataManagerFactory.createExcelManager(path);
            List<List<String>> sheetContents = null;
            myExcelManager.loadData();
            sheetContents = myExcelManager.getSheetContents(0, 1);
            for (List<String> list : sheetContents) {
                String status2;
                ShopOrderMstDto dto = param.stream().filter(p -> p.getOrder_id() != null && p.getOrder_id().equals(list.get(1))).findAny().orElse(null);
                if (dto == null) continue;
                switch (status2 = list.get(4).equals("") ? list.get(3) : list.get(4)) {
                    case "\uc2e0\uaddc\uc8fc\ubb38": {
                        dto.setOrder_status("100");
                        break;
                    }
                    case "\ubc1c\uc8fc\ud655\uc778": {
                        dto.setOrder_status("100");
                        break;
                    }
                    case "\ubc30\uc1a1\uc911": {
                        dto.setOrder_status("403");
                        break;
                    }
                    case "\uad6c\ub9e4\ud655\uc815": {
                        dto.setOrder_status("410");
                        break;
                    }
                    case "\ucde8\uc18c\uc694\uccad": {
                        dto.setOrder_status("C01");
                        break;
                    }
                    case "\ucde8\uc18c\uc644\ub8cc": {
                        dto.setOrder_status("C02");
                        break;
                    }
                    case "\ubc18\ud488\uc694\uccad": {
                        dto.setOrder_status("R01");
                        break;
                    }
                    case "\ubc18\ud488\uc644\ub8cc": {
                        dto.setOrder_status("R02");
                        break;
                    }
                    case "\uad50\ud658\uc694\uccad": {
                        dto.setOrder_status("E01");
                        break;
                    }
                    case "\uad50\ud658\uc644\ub8cc": {
                        dto.setOrder_status("E02");
                    }
                }
                dto.setResult_code("1");
                dtolist.add(dto);
            }
        }
        catch (Exception exception) {
            throw new Exception("\ub124\uc774\ubc84 \uc5d1\uc140\ud30c\uc77c \uc0c1\ud0dc\uac12 \ubcc0\uacbd\ud558\ub294\uc911 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd \ud588\uc2b5\ub2c8\ub2e4.");
        }
        return dtolist;
    }

    private void orderCancelApi(List<ShopOrderMstDto> param, List<ShopOrderMstDto> ret, String accessToken, Date sdate) throws IOException, CloneNotSupportedException {
        OkHttpClient client = new OkHttpClient();
        String datePattern5 = "yyyy-MM-dd'T'HH:mm:ss.SSS";
        SimpleDateFormat format5 = new SimpleDateFormat(datePattern5);
        ArrayList<String> orderId = new ArrayList<String>();
        String[] status2 = new String[]{"CLAIM_REQUESTED", "CLAIM_COMPLETED"};
        JsonArray elements = new JsonArray();
        try {
            int j = 0;
            while (j < 2) {
                Request request2 = new Request.Builder().url("https://api.commerce.naver.com/external/v1/pay-order/seller/product-orders/last-changed-statuses?lastChangedFrom=" + format5.format(sdate) + "Z&lastChangedType=" + status2[j]).get().addHeader("Authorization", accessToken).build();
                Thread.sleep(450L);
                Call call = client.newCall(request2);
                String body = call.execute().body().string();
                YDMAStringUtil.Print(body);
                JsonParser parser = new JsonParser();
                JsonElement jsonElement = parser.parse(body);
                JsonObject object = jsonElement.getAsJsonObject();
                if (object.get("data") != null) {
                    JsonObject jsonObject = object.get("data").getAsJsonObject();
                    JsonArray datas = jsonObject.get("lastChangeStatuses").getAsJsonArray();
                    for (JsonElement data2 : datas) {
                        JsonObject jsonObject2 = data2.getAsJsonObject();
                        if (!jsonObject2.get("claimType").getAsString().equals("CANCEL")) continue;
                        orderId.add(jsonObject2.get("productOrderId").getAsString());
                    }
                }
                ++j;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (orderId.size() != 0) {
            MediaType mediaType = MediaType.parse((String)"application/json");
            RequestBody body2 = RequestBody.create((MediaType)mediaType, (String)("{\"productOrderIds\":" + String.valueOf(orderId) + "}"));
            Request request2 = new Request.Builder().url("https://api.commerce.naver.com/external/v1/pay-order/seller/product-orders/query").post(body2).addHeader("Authorization", accessToken).addHeader("content-type", "application/json").build();
            Call call2 = client.newCall(request2);
            String bodys = call2.execute().body().string();
            JsonParser parser2 = new JsonParser();
            JsonObject object2 = (JsonObject)parser2.parse(bodys);
            elements = object2.get("data").getAsJsonArray();
        }
        if (elements.size() > 0) {
            int i = 0;
            while (i < elements.size()) {
                JsonObject object = (JsonObject)elements.get(i);
                JsonObject order = object.get("order").getAsJsonObject();
                JsonObject productOrder = object.get("productOrder").getAsJsonObject();
                JsonObject cancel = object.get("cancel").getAsJsonObject();
                String orderid = order.get("orderId").getAsString();
                String mallid = productOrder.get("productId").getAsString();
                String expid = productOrder.get("productOrderId").getAsString();
                for (ShopOrderMstDto dto : param) {
                    if (!dto.getOrder_id().equals(orderid) || !dto.getMall_product_id().substring(dto.getMall_product_id().lastIndexOf(",") + 1).equals(mallid) || !dto.getMall_exp_cd().equals(expid)) continue;
                    dto.setOrder_status(this.getStatusCancel(cancel.get("claimStatus").getAsString()));
                    dto.setResult_code("1");
                    if (dto.getOrder_status().equals("C02")) {
                        ShopOrderMstDto temp = dto.clone("C02");
                        try {
                            String orddt = cancel.get("cancelCompletedDate").getAsString().substring(0, 19).replace("T", " ");
                            temp.setOrder_date(orddt);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        ret.add(temp);
                    }
                    ret.add(dto);
                }
                ++i;
            }
        }
    }

    private void orderReturnListApi(List<ShopOrderMstDto> param, List<ShopOrderMstDto> ret, String accessToken, Date sdate) throws IOException, CloneNotSupportedException {
        OkHttpClient client = new OkHttpClient();
        String datePattern5 = "yyyy-MM-dd'T'HH:mm:ss.SSS";
        SimpleDateFormat format5 = new SimpleDateFormat(datePattern5);
        ArrayList<String> orderId = new ArrayList<String>();
        String[] status2 = new String[]{"CLAIM_REQUESTED", "CLAIM_COMPLETED"};
        JsonArray elements = new JsonArray();
        try {
            int j = 0;
            while (j < 2) {
                Request request2 = new Request.Builder().url("https://api.commerce.naver.com/external/v1/pay-order/seller/product-orders/last-changed-statuses?lastChangedFrom=" + format5.format(sdate) + "Z&lastChangedType=" + status2[j]).get().addHeader("Authorization", accessToken).build();
                Thread.sleep(450L);
                Call call = client.newCall(request2);
                String body = call.execute().body().string();
                YDMAStringUtil.Print(body);
                JsonParser parser = new JsonParser();
                JsonElement jsonElement = parser.parse(body);
                JsonObject object = jsonElement.getAsJsonObject();
                if (object.get("data") != null) {
                    JsonObject jsonObject = object.get("data").getAsJsonObject();
                    JsonArray datas = jsonObject.get("lastChangeStatuses").getAsJsonArray();
                    for (JsonElement data2 : datas) {
                        JsonObject jsonObject2 = data2.getAsJsonObject();
                        if (!jsonObject2.get("claimType").getAsString().equals("RETURN")) continue;
                        orderId.add(jsonObject2.get("productOrderId").getAsString());
                    }
                }
                ++j;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (orderId.size() != 0) {
            MediaType mediaType = MediaType.parse((String)"application/json");
            RequestBody body2 = RequestBody.create((MediaType)mediaType, (String)("{\"productOrderIds\":" + String.valueOf(orderId) + "}"));
            Request request2 = new Request.Builder().url("https://api.commerce.naver.com/external/v1/pay-order/seller/product-orders/query").post(body2).addHeader("Authorization", accessToken).addHeader("content-type", "application/json").build();
            Call call2 = client.newCall(request2);
            String bodys = call2.execute().body().string();
            JsonParser parser2 = new JsonParser();
            JsonObject object2 = (JsonObject)parser2.parse(bodys);
            elements = object2.get("data").getAsJsonArray();
        }
        if (elements.size() > 0) {
            int i = 0;
            while (i < elements.size()) {
                JsonObject object = (JsonObject)elements.get(i);
                JsonObject order = object.get("order").getAsJsonObject();
                JsonObject productOrder = object.get("productOrder").getAsJsonObject();
                JsonObject returns = object.get("return").getAsJsonObject();
                String orderid = order.get("orderId").getAsString();
                String mallid = productOrder.get("productId").getAsString();
                String expid = productOrder.get("productOrderId").getAsString();
                for (ShopOrderMstDto dto : param) {
                    if (!dto.getOrder_id().equals(orderid) || !dto.getMall_product_id().substring(dto.getMall_product_id().lastIndexOf(",") + 1).equals(mallid) || !dto.getMall_exp_cd().equals(expid)) continue;
                    dto.setOrder_status(this.getStatusReturn(returns.get("claimStatus").getAsString()));
                    dto.setResult_code("1");
                    if (dto.getOrder_status().equals("R02")) {
                        ShopOrderMstDto temp = dto.clone("R02");
                        try {
                            String orddt = returns.get("returnCompletedDate").getAsString().substring(0, 19).replace("T", " ");
                            temp.setOrder_date(orddt);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        ret.add(temp);
                    }
                    ret.add(dto);
                }
                ++i;
            }
        }
    }

    private void orderExChangeApi(List<ShopOrderMstDto> param, List<ShopOrderMstDto> ret, String accessToken, Date sdate) throws IOException, CloneNotSupportedException {
        OkHttpClient client = new OkHttpClient();
        String datePattern5 = "yyyy-MM-dd'T'HH:mm:ss.SSS";
        SimpleDateFormat format5 = new SimpleDateFormat(datePattern5);
        ArrayList<String> orderId = new ArrayList<String>();
        String[] status2 = new String[]{"CLAIM_REQUESTED", "CLAIM_COMPLETED"};
        JsonArray elements = new JsonArray();
        try {
            int j = 0;
            while (j < 2) {
                Request request2 = new Request.Builder().url("https://api.commerce.naver.com/external/v1/pay-order/seller/product-orders/last-changed-statuses?lastChangedFrom=" + format5.format(sdate) + "Z&lastChangedType=" + status2[j]).get().addHeader("Authorization", accessToken).build();
                Thread.sleep(450L);
                Call call = client.newCall(request2);
                String body = call.execute().body().string();
                YDMAStringUtil.Print(body);
                JsonParser parser = new JsonParser();
                JsonElement jsonElement = parser.parse(body);
                JsonObject object = jsonElement.getAsJsonObject();
                if (object.get("data") != null) {
                    JsonObject jsonObject = object.get("data").getAsJsonObject();
                    JsonArray datas = jsonObject.get("lastChangeStatuses").getAsJsonArray();
                    for (JsonElement data2 : datas) {
                        JsonObject jsonObject2 = data2.getAsJsonObject();
                        if (!jsonObject2.get("claimType").getAsString().equals("EXCHANGE")) continue;
                        orderId.add(jsonObject2.get("productOrderId").getAsString());
                    }
                }
                ++j;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (orderId.size() != 0) {
            MediaType mediaType = MediaType.parse((String)"application/json");
            RequestBody body2 = RequestBody.create((MediaType)mediaType, (String)("{\"productOrderIds\":" + String.valueOf(orderId) + "}"));
            Request request2 = new Request.Builder().url("https://api.commerce.naver.com/external/v1/pay-order/seller/product-orders/query").post(body2).addHeader("Authorization", accessToken).addHeader("content-type", "application/json").build();
            Call call2 = client.newCall(request2);
            String bodys = call2.execute().body().string();
            JsonParser parser2 = new JsonParser();
            JsonObject object2 = (JsonObject)parser2.parse(bodys);
            elements = object2.get("data").getAsJsonArray();
        }
        if (elements.size() > 0) {
            int i = 0;
            while (i < elements.size()) {
                JsonObject object = (JsonObject)elements.get(i);
                JsonObject order = object.get("order").getAsJsonObject();
                JsonObject productOrder = object.get("productOrder").getAsJsonObject();
                JsonObject exchange = object.get("exchange").getAsJsonObject();
                String orderid = order.get("orderId").getAsString();
                String mallid = productOrder.get("productId").getAsString();
                String expid = productOrder.get("productOrderId").getAsString();
                for (ShopOrderMstDto dto : param) {
                    if (!dto.getOrder_id().equals(orderid) || !dto.getMall_product_id().substring(dto.getMall_product_id().lastIndexOf(",") + 1).equals(mallid) || !dto.getMall_exp_cd().equals(expid)) continue;
                    dto.setOrder_status(this.getStatusexChange(exchange.get("claimStatus").getAsString()));
                    dto.setResult_code("1");
                    if (dto.getOrder_status().equals("E02")) {
                        dto.setOrder_status("E02");
                        dto.setResult_code("1");
                        ShopOrderMstDto temp = dto.clone("E02");
                        try {
                            String orddt = exchange.get("reDeliveryOperationDate").getAsString().substring(0, 19).replace("T", " ");
                            temp.setOrder_date(orddt);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        ret.add(temp);
                    }
                    ret.add(dto);
                }
                ++i;
            }
        }
    }

    private void delvCompletedApi(List<ShopOrderMstDto> param, List<ShopOrderMstDto> ret, String accessToken, Date sdate) throws Exception {
        OkHttpClient client = new OkHttpClient();
        String datePattern5 = "yyyy-MM-dd'T'HH:mm:ss.SSS";
        SimpleDateFormat format5 = new SimpleDateFormat(datePattern5);
        ArrayList<String> orderId = new ArrayList<String>();
        JsonArray elements = new JsonArray();
        try {
            Request request2 = new Request.Builder().url("https://api.commerce.naver.com/external/v1/pay-order/seller/product-orders/last-changed-statuses?lastChangedFrom=" + format5.format(sdate) + "Z").get().addHeader("Authorization", accessToken).build();
            Thread.sleep(450L);
            Call call = client.newCall(request2);
            String body = call.execute().body().string();
            YDMAStringUtil.Print(body);
            JsonParser parser = new JsonParser();
            JsonElement jsonElement = parser.parse(body);
            JsonObject object = jsonElement.getAsJsonObject();
            if (object.get("data") != null) {
                JsonObject jsonObject = object.get("data").getAsJsonObject();
                JsonArray datas = jsonObject.get("lastChangeStatuses").getAsJsonArray();
                for (JsonElement data2 : datas) {
                    JsonObject jsonObject2 = data2.getAsJsonObject();
                    if (!jsonObject2.get("productOrderStatus").getAsString().equals("DELIVERED") && !jsonObject2.get("productOrderStatus").getAsString().equals("PURCHASE_DECIDED") && !jsonObject2.get("productOrderStatus").getAsString().equals("DELIVERING")) continue;
                    orderId.add(jsonObject2.get("productOrderId").getAsString());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (orderId.size() != 0) {
            MediaType mediaType = MediaType.parse((String)"application/json");
            RequestBody body2 = RequestBody.create((MediaType)mediaType, (String)("{\"productOrderIds\":" + String.valueOf(orderId) + "}"));
            Request request2 = new Request.Builder().url("https://api.commerce.naver.com/external/v1/pay-order/seller/product-orders/query").post(body2).addHeader("Authorization", accessToken).addHeader("content-type", "application/json").build();
            Call call2 = client.newCall(request2);
            String bodys = call2.execute().body().string();
            JsonParser parser2 = new JsonParser();
            JsonObject object2 = (JsonObject)parser2.parse(bodys);
            elements = object2.get("data").getAsJsonArray();
        }
        if (elements.size() > 0) {
            int i = 0;
            while (i < elements.size()) {
                JsonObject object = (JsonObject)elements.get(i);
                JsonObject delivery = object.get("delivery").getAsJsonObject();
                String delComplted = "";
                if (delivery.get("deliveryStatus") != null) {
                    delComplted = delivery.get("deliveryStatus").getAsString();
                }
                if (delComplted.equals("DELIVERY_COMPLETION")) {
                    JsonObject order = object.get("order").getAsJsonObject();
                    JsonObject productOrder = object.get("productOrder").getAsJsonObject();
                    String orderid = order.get("orderId").getAsString();
                    String mallid = productOrder.get("productId").getAsString();
                    String expid = productOrder.get("productOrderId").getAsString();
                    for (ShopOrderMstDto dto : param) {
                        if (!dto.getOrder_id().equals(orderid) || !dto.getMall_product_id().substring(dto.getMall_product_id().lastIndexOf(",") + 1).equals(mallid) || !dto.getMall_exp_cd().equals(expid)) continue;
                        dto.setResult_code("1");
                        dto.setOrder_status("410");
                        ret.add(dto);
                    }
                }
                ++i;
            }
        }
    }

    private String getDeliveryCompltedOrderStringParam(String merchantNo, String startDate, String endDate) throws Exception {
        DeliveryCompleted deliveryComplted = new DeliveryCompleted();
        deliveryComplted.operationName = "SmartStoreFindDeliveryStatusesByDetailConditions_ForSaleDeliveryStatus";
        deliveryComplted.variables.dateRangeFrom = startDate;
        deliveryComplted.variables.dateRangeTo = endDate;
        deliveryComplted.variables.orderStatus = "DELIVERED";
        deliveryComplted.variables.merchantNo = merchantNo;
        deliveryComplted.variables.pagingPage = 1;
        deliveryComplted.variables.pagingSize = 100;
        deliveryComplted.variables.rangeType = "PAY_COMPLETED";
        deliveryComplted.variables.serviceType = "MP";
        deliveryComplted.query = "query SmartStoreFindDeliveryStatusesByDetailConditions_ForSaleDeliveryStatus($dateRange_from: String, $dateRange_to: String, $detailSearch_keyword: String, $detailSearch_tieringInstantRange_from: String, $detailSearch_tieringInstantRange_to: String, $detailSearch_type: DetailSearchType, $detailedOrderStatus: DetailedSearchOrderStatusType, $merchantNo: String!, $orderStatus: SearchOrderStatusType, $paging_page: Int, $paging_size: Int, $purchaseDecisionRequestYn: Boolean, $rangeType: RangeType, $serviceType: String!, $sort_direction: SortDirectionType, $sort_type: SortType) {\n  deliveryStatusListMp: SmartStoreFindDeliveryStatusesByDetailConditions_ForSaleDeliveryStatus(dateRange_from: $dateRange_from, dateRange_to: $dateRange_to, detailSearch_keyword: $detailSearch_keyword, detailSearch_tieringInstantRange_from: $detailSearch_tieringInstantRange_from, detailSearch_tieringInstantRange_to: $detailSearch_tieringInstantRange_to, detailSearch_type: $detailSearch_type, detailedOrderStatus: $detailedOrderStatus, merchantNo: $merchantNo, orderStatus: $orderStatus, paging_page: $paging_page, paging_size: $paging_size, purchaseDecisionRequestYn: $purchaseDecisionRequestYn, rangeType: $rangeType, serviceType: $serviceType, sort_direction: $sort_direction, sort_type: $sort_type) {\n    elements {\n      ...deliveryStatusElementField\n      __typename\n    }\n    pagination {\n      ...paginationField\n      __typename\n    }\n    __typename\n  }\n}\n\nfragment deliveryStatusElementField on SaleDeliveryStatusSeller {\n  returnCareTarget\n  branchId\n  merchantChannelNo\n  deliveryFeeClass\n  mistakenInvoiceRegDateTime\n  deliveryInvoiceNo\n  orderQuantity\n  productName\n  mistakenInvoiceReason\n  payDateTime\n  deliveryFeeRatingClass\n  mistakenInvoiceYn\n  orderMemberId\n  remoteAreaCostChargeAmt\n  invoiceNo\n  purchaseDecisionRequestDateTime\n  totalDiscountAmt\n  orderNo\n  productClass\n  deliveryCompleteDateTime\n  purchaseDecisionExtensionReason\n  saleChannelType\n  receiverAddress\n  deliveryCompanyName\n  sellerProductManagementCode\n  claimStatus\n  orderMemberTelNo\n  purchaseDecisionExtensionDateTime\n  deliveryFeeAmt\n  deliveryMethod\n  biztalkAccountId\n  receiverTelNo2\n  productPayAmt\n  receiverTelNo1\n  orderStatus\n  productUnitPrice\n  orderMemberName\n  productOrderNo\n  deliveryCompanyCode\n  productOptionContents\n  productOptionAmt\n  productNo\n  purchaseDecisionExpectDateTime\n  receiverName\n  deliveryNo\n  purchaseDecisionRequestOperator\n  sellerDiscountAmt\n  deliveryFeeDiscountAmt\n  dispatchDateTime\n  receiverZipCode\n  syncDateTime\n  productOrderStatus\n  sellerInternalCode2\n  sellerInternalCode1\n  deliveryBundleGroupSeq\n  productUrl\n  fulfillmentCompanyName\n  deliveryAttributeText\n  __typename\n}\n\nfragment paginationField on Pagination {\n  size\n  totalElements\n  page\n  totalPages\n  __typename\n}\n";
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString((Object)deliveryComplted);
    }

    private String getPurchaseDecisionOrderStringParam(String merchantNo, String startDate, String endDate) throws Exception {
        DeliveryCompleted deliveryComplted = new DeliveryCompleted();
        deliveryComplted.operationName = "SmartStoreFindPurchaseDecisionsByDetailConditions_ForPurchaseDecision";
        deliveryComplted.variables.dateRangeFrom = startDate;
        deliveryComplted.variables.dateRangeTo = endDate;
        deliveryComplted.variables.merchantNo = merchantNo;
        deliveryComplted.variables.pagingPage = 1;
        deliveryComplted.variables.pagingSize = 100;
        deliveryComplted.variables.rangeType = "PURCHASE_DECISION_COMPLETED";
        deliveryComplted.variables.serviceType = "MP";
        deliveryComplted.variables.sortDirection = "DESC";
        deliveryComplted.variables.sortType = "PRODUCT_ORDER_PURCHASE_DECISION_COMPLETE_OPERATION_YMDT";
        deliveryComplted.query = "query SmartStoreFindPurchaseDecisionsByDetailConditions_ForPurchaseDecision($merchantNo: String!, $serviceType: String!, $claimStatus: ClaimStatusType, $dateRange_from: String, $dateRange_to: String, $detailSearch_keyword: String, $detailSearch_type: DetailSearchType, $paging_page: Int, $paging_size: Int, $rangeType: RangeType, $sort_direction: SortDirectionType, $sort_type: SortType) {\n  purchaseDecisionList: SmartStoreFindPurchaseDecisionsByDetailConditions_ForPurchaseDecision(merchantNo: $merchantNo, serviceType: $serviceType, claimStatus: $claimStatus, dateRange_from: $dateRange_from, dateRange_to: $dateRange_to, detailSearch_keyword: $detailSearch_keyword, detailSearch_type: $detailSearch_type, paging_page: $paging_page, paging_size: $paging_size, rangeType: $rangeType, sort_direction: $sort_direction, sort_type: $sort_type) {\n    elements {\n      ...purchaseDecisionElementField\n      __typename\n    }\n    pagination {\n      ...paginationField\n      __typename\n    }\n    __typename\n  }\n}\n\nfragment purchaseDecisionElementField on PurchaseDecisionSeller {\n  returnCareTarget\n  branchId\n  merchantChannelNo\n  deliveryFeeAmt\n  deliveryFeeClass\n  deliveryMethod\n  biztalkAccountId\n  deliveryInvoiceNo\n  productPayAmt\n  orderStatus\n  productUnitPrice\n  purchaseDecisionCompleteDateTime\n  orderQuantity\n  productName\n  orderMemberName\n  payDateTime\n  productOrderNo\n  productOptionContents\n  deliveryFeeRatingClass\n  orderMemberId\n  knowledgeShoppingCommissionAmt\n  remoteAreaCostChargeAmt\n  productOptionAmt\n  salesCommissionPrepay\n  productNo\n  payLocationType\n  totalDiscountAmt\n  orderNo\n  payMeansClass\n  productClass\n  commissionClassType\n  inflowPath\n  receiverName\n  settlementExpectAmt\n  deliveryNo\n  deliveryCompleteDateTime\n  saleChannelType\n  sellerDiscountAmt\n  deliveryCompanyName\n  deliveryFeeDiscountAmt\n  dispatchDateTime\n  sellerProductManagementCode\n  payCommissionAmt\n  syncDateTime\n  productOrderStatus\n  sellerInternalCode2\n  sellingInterlockCommissionInflowPath\n  sellerInternalCode1\n  deliveryBundleGroupSeq\n  productUrl\n  fulfillmentCompanyName\n  sellerOptionManagementCode\n  deliveryAttributeText\n  __typename\n}\n\nfragment paginationField on Pagination {\n  size\n  totalElements\n  page\n  totalPages\n  __typename\n}\n";
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString((Object)deliveryComplted);
    }

    private class DeliveryCompleted {
        @JsonProperty(value="operationName")
        private String operationName;
        @JsonProperty(value="variables")
        private Variables variables = new Variables();
        @JsonProperty(value="query")
        private String query;

        private class Variables {
            @JsonProperty(value="dateRange_from")
            private String dateRangeFrom;
            @JsonProperty(value="dateRange_to")
            private String dateRangeTo;
            @JsonProperty(value="detailedOrderStatus")
            private String detailedOrderStatus;
            @JsonProperty(value="merchantNo")
            private String merchantNo;
            @JsonProperty(value="orderStatus")
            private String orderStatus;
            @JsonProperty(value="paging_page")
            private int pagingPage;
            @JsonProperty(value="paging_size")
            private int pagingSize;
            @JsonProperty(value="rangeType")
            private String rangeType;
            @JsonProperty(value="serviceType")
            private String serviceType;
            @JsonProperty(value="sort_direction")
            private String sortDirection;
            @JsonProperty(value="sort_type")
            private String sortType;

            private Variables() {
            }
        }
    }
}

