/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.shop.data.naverstore;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.jogamp.common.util.InterruptSource;
import com.kdjsystem.mlink.yellim.common.TimeUtils;
import com.kdjsystem.mlink.yellim.common.YDMASessonUtil;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.common.YDMATimeUtil;
import com.kdjsystem.mlink.yellim.data.dao.ShopAddProdInfoDto;
import com.kdjsystem.mlink.yellim.data.dao.ShopProdInDto;
import com.kdjsystem.mlink.yellim.data.dao.ShoppingMallDao;
import com.kdjsystem.mlink.yellim.dto.ProductAddOptionDTO;
import com.kdjsystem.mlink.yellim.dto.ProductDTO;
import com.kdjsystem.mlink.yellim.dto.ShoppingmallDTO;
import com.kdjsystem.mlink.yellim.service.IProductAddService;
import com.kdjsystem.mlink.yellim.shop.common.CaffeineCategoryCache;
import com.kdjsystem.mlink.yellim.shop.common.ChromeExtention;
import com.kdjsystem.mlink.yellim.shop.common.ChromeScript;
import com.kdjsystem.mlink.yellim.shop.common.ShopCommon;
import com.kdjsystem.mlink.yellim.shop.dao.ProductItemDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.yellim.shop.dao.ShopOptionDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopOptionProductInfoDao;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductDao;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductOptionDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.yellim.shop.dao.WorkMngDao;
import com.kdjsystem.mlink.yellim.shop.domesin.DomesinShopDao;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class ProductAddSmartStore
implements IProductAddService {
    Map<String, String> cookie;
    int companyGoodsCd = 0;
    int cnt = 0;

    @Override
    public List<ProductDTO> excute(ShoppingmallDTO shopInfo, ProductAddOptionDTO searchOption, Map<String, String> cookies, List<String> prodlist, IProgressMonitor monitor) throws Exception {
        ArrayList<ProductDTO> syncList = new ArrayList<ProductDTO>();
        ChromeDriver driver = ChromeExtention.getInstace().getDriver(true);
        String URL2 = "https://shopping.naver.com/";
        ChromeScript.get().get(driver, URL2);
        InterruptSource.Thread.sleep((long)2000L);
        this.cookie = ChromeScript.get().getCookies(driver);
        for (String strUrl : prodlist) {
            try {
                String url = String.format("%s", strUrl);
                Connection.Response rs = Jsoup.connect((String)url).cookies(this.cookie).header("Host", "brand.naver.com").header("Connection", "keep-alive").header("Upgrade-Insecure-Requests", "1").userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36").header("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.7").header("Sec-Fetch-Site", "none").header("Sec-Fetch-Mode", "navigate").header("Sec-Fetch-User", "?1").header("Sec-Fetch-Dest", "document").header("Accept-Encoding", "gzip").header("Accept-Language", "ko-KR,ko;q=0.9,en-US;q=0.8,en;q=0.7").method(Connection.Method.GET).followRedirects(true).ignoreContentType(true).ignoreHttpErrors(true).execute();
                Document body = Jsoup.parseBodyFragment((String)rs.body());
                String body2 = ((Element)body.select("script").get(1)).toString().replace("<script>window.__PRELOADED_STATE__=", "").replace("</script>", "");
                JsonParser parser = new JsonParser();
                JsonObject object = parser.parse(body2).getAsJsonObject();
                JsonObject datas = object.get("product").getAsJsonObject().get("A").getAsJsonObject();
                if (rs.statusCode() != 200 || datas.size() <= 0) continue;
                try {
                    this.onDatabindandSaveDB(datas, shopInfo, searchOption, url, driver, monitor, cookies);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        driver.close();
        return syncList;
    }

    private void onDatabindandSaveDB(JsonObject datas, ShoppingmallDTO shopInfo, ProductAddOptionDTO searchOption, String url, ChromeDriver driver, IProgressMonitor monitor, Map<String, String> cookies) throws Exception {
        ProductDTO data2 = new ProductDTO();
        data2.setGoods_nm(ShopCommon.jsonElementNullStr(datas.get("name")));
        try {
            JsonObject naverShoppingSearchInfo = (JsonObject)datas.get("naverShoppingSearchInfo");
            data2.setMaker(ShopCommon.jsonElementNullStr(naverShoppingSearchInfo.get("manufacturerName")));
            data2.setBrand_nm(ShopCommon.jsonElementNullStr(naverShoppingSearchInfo.get("brandName")));
            data2.setModel_no(ShopCommon.jsonElementNullStr(naverShoppingSearchInfo.get("modelName")));
        }
        catch (Exception exception) {
            data2.setMaker("");
            data2.setBrand_nm("");
            data2.setModel_no("");
        }
        JsonObject originAreaInfo = (JsonObject)datas.get("originAreaInfo");
        data2.setOrigin(ShopCommon.jsonElementNullStr(originAreaInfo.get("content")));
        JsonObject shopcategory = (JsonObject)datas.get("category");
        data2.setClass_cd3(ShopCommon.jsonElementNullStr(shopcategory.get("categoryId")));
        data2.setGmcategnm(ShopCommon.jsonElementNullStr(shopcategory.get("wholeCategoryName")));
        String category = ShopCommonDao.get().getEsCodeNaver(data2.getClass_cd3());
        if (!category.equals("")) {
            data2.setEs(category.split("[|]")[0]);
            data2.setCatno(category.split("[|]")[0]);
            data2.setShop_cid_info(category.split("[|]")[1]);
        } else {
            String catShortName = ShopCommon.jsonElementNullStr(shopcategory.get("categoryName"));
            boolean result = ShoppingMallDao.get().saveCatImsiTot(shopInfo.getSHOPCD(), data2.getClass_cd3(), catShortName);
            if (result) {
                String catInfo = ShopCommonDao.get().getEsCodeNaver(data2.getClass_cd3());
                if (!catInfo.equals("")) {
                    data2.setEs(catInfo.split("[|]")[0]);
                    data2.setCatno(catInfo.split("[|]")[0]);
                    data2.setShop_cid_info(catInfo.split("[|]")[1]);
                } else {
                    data2.setEs("");
                    data2.setShop_cid_info("");
                }
            } else {
                data2.setEs("");
                data2.setShop_cid_info("");
            }
        }
        String full_cateName = CaffeineCategoryCache.getInstance().getFullCategoryName(data2.getEs());
        data2.setGmcategnm(full_cateName);
        try {
            JsonObject deliveryInfo = (JsonObject)datas.get("productDeliveryInfo");
            data2.setDelv_cost(ShopCommon.jsonElementNullStr(deliveryInfo.get("baseFee")));
            data2.setDelv_type(data2.getDelv_cost().equals("0") ? "1" : "0");
            JsonObject claimDeliveryInfo = (JsonObject)datas.get("claimDeliveryInfo");
            data2.setDelv_r_cost(ShopCommon.jsonElementNullStr(claimDeliveryInfo.get("exchangeDeliveryFee")));
        }
        catch (Exception exception) {
            data2.setDelv_cost("0");
            data2.setDelv_type(data2.getDelv_cost().equals("0") ? "1" : "0");
            data2.setDelv_r_cost("0");
        }
        String salePrice = ShopCommon.jsonElementNullInt(datas.get("discountedSalePrice"));
        data2.setMarket_price(salePrice);
        data2.setGoods_price(salePrice);
        data2.setGoods_consumer_price(salePrice);
        data2.setQty(ShopCommon.jsonElementNullInt(datas.get("stockQuantity")));
        JsonObject seoInfo = (JsonObject)datas.get("seoInfo");
        JsonArray sellerTags = (JsonArray)seoInfo.get("sellerTags");
        data2.setGoods_search(this.getKeyWord(sellerTags));
        JsonArray images = (JsonArray)datas.get("productImages");
        int i = 0;
        while (i < images.size()) {
            String image = ShopCommon.jsonElementNullStr(images.get(i).getAsJsonObject().get("url"));
            this.getApiImages(data2, i, image);
            ++i;
        }
        data2.setSelect_option("");
        if (datas.get("optionUsable").getAsString().equals("true")) {
            String option2 = this.getApioption(datas, Integer.parseInt(data2.getMarket_price()));
            data2.setSelect_option(option2);
            JsonArray optionTypes = datas.get("options").getAsJsonArray();
            data2.setChar_1_nm(optionTypes.size() > 0 ? optionTypes.get(0).getAsJsonObject().get("groupName").getAsString() : "");
            data2.setChar_2_nm(optionTypes.size() > 1 ? optionTypes.get(1).getAsJsonObject().get("groupName").getAsString() : "");
            JsonArray optionVals = datas.get("optionCombinations").getAsJsonArray();
            ArrayList<String> val1s = new ArrayList<String>();
            ArrayList<String> val2s = new ArrayList<String>();
            int i2 = 0;
            while (i2 < optionVals.size()) {
                JsonObject val = optionVals.get(i2).getAsJsonObject();
                if (optionTypes.size() > 1) {
                    val1s.add(val.get("optionName1").getAsString());
                    val2s.add(val.get("optionName2").getAsString());
                } else {
                    val1s.add(val.get("optionName1").getAsString());
                }
                ++i2;
            }
            if (val1s.size() > 0) {
                String val1 = val1s.stream().distinct().collect(Collectors.joining(":"));
                data2.setChar_1_val(val1);
            }
            if (val2s.size() > 0) {
                String val2 = val2s.stream().distinct().collect(Collectors.joining(":"));
                data2.setChar_2_val(val2);
            }
        }
        JsonObject productInfoProvidedNotice = (JsonObject)datas.get("productInfoProvidedNoticeView");
        JsonObject productInfoProvidedNoticeContent = (JsonObject)productInfoProvidedNotice.get("basic");
        this.getProvidedNotice_kor(productInfoProvidedNoticeContent, data2);
        String cert = ShopCommon.jsonElementNullStr(datas.get("certification"));
        if (cert.equals("true")) {
            JsonArray prodCert = (JsonArray)datas.get("productCertificationInfos");
            data2.setCert(ShopCommon.jsonElementNullStr(prodCert.get(0).getAsJsonObject().get("certificationTypeName")));
            data2.setCert_type("1");
            data2.setCertno(ShopCommon.jsonElementNullStr(prodCert.get(0).getAsJsonObject().get("certificationNumber")));
            data2.setCertdate("");
            data2.setCertmodel(ShopCommon.jsonElementNullStr(prodCert.get(0).getAsJsonObject().get("certificationMarkType")));
            data2.setCertfield(ShopCommon.jsonElementNullStr(prodCert.get(0).getAsJsonObject().get("certificationMarkUrl")));
        } else {
            data2.setCert_type("0");
        }
        data2.setGoods_remarks(this.getDetailProducts(driver, url));
        String icode = this.saveShopprodinfoReverse(shopInfo, searchOption, data2, this.companyGoodsCd, this.cnt, monitor);
        if (!icode.equals("")) {
            try {
                JsonArray supplements = datas.get("supplements").getAsJsonArray();
                ProductDTO infoDto = ShopProductDao.get().getShopInfOne("COMPAYNY_GOODS_CD", icode);
                this.saveSupplements(supplements, infoDto.getPRODSEQ(), infoDto.getCompayny_goods_cd());
            }
            catch (Exception exception) {}
        }
        try {
            monitor.subTask("[\uc0c1\ud488\uc815\ubcf4[" + data2.getCompayny_goods_cd() + "] \ubcc0\ud658\uc911\uc785\ub2c8\ub2e4...]");
            monitor.worked(1);
            if (monitor.isCanceled()) {
                monitor.done();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getKeyWord(JsonArray sellerTags) throws Exception {
        Object tags = "";
        if (sellerTags != null) {
            int i = 0;
            while (i < sellerTags.size()) {
                String addtag = ShopCommon.jsonElementNullStr(sellerTags.get(i).getAsJsonObject().get("text"));
                if (addtag != "" && i != sellerTags.size() - 1) {
                    tags = (String)tags + addtag + ",";
                } else if (addtag != "" && i == sellerTags.size() - 1) {
                    tags = (String)tags + addtag;
                }
                ++i;
            }
        }
        return tags;
    }

    public String saveShopprodinfoReverse(ShoppingmallDTO shopInfo, ProductAddOptionDTO searchOption, ProductDTO data2, int companyGoodsCd, int cnt, IProgressMonitor monitor) throws Exception {
        ArrayList<ProductItemDto> infoTotal = new ArrayList<ProductItemDto>();
        ProductItemDto newInfoDto = new ProductItemDto();
        newInfoDto.setSearch(searchOption.getDOME_CODE());
        if (companyGoodsCd == 0) {
            companyGoodsCd = ShopProductDao.get().getMaxCompanyGoodsCd();
        }
        String icode = "MLK" + String.format("%05d", ++companyGoodsCd);
        int count = (int)infoTotal.stream().filter(d -> d.getIcode().contains(icode)).count();
        String icode2 = icode;
        if (count > 1) {
            icode2 = icode + "_" + String.valueOf(cnt++);
        }
        newInfoDto.setIcode(icode2);
        newInfoDto.setIname(data2.getGoods_nm());
        newInfoDto.setCid(data2.getEs());
        newInfoDto.setCate_depth("3");
        newInfoDto.setClass_cd3(data2.getEs());
        String[] image = new String[24];
        int i = 0;
        while (i < image.length) {
            this.saveImage(data2, i, image);
            ++i;
        }
        newInfoDto.setImg(image);
        newInfoDto.setPrice(data2.getGoods_price());
        newInfoDto.setPrice_consumer(data2.getGoods_price());
        newInfoDto.setSelect_option(data2.getSelect_option());
        newInfoDto.setContent(data2.getGoods_remarks());
        newInfoDto.setKeyword(data2.getGoods_search());
        newInfoDto.setStatus("0");
        newInfoDto.setAdult(data2.getAdult());
        newInfoDto.setDelivery_qty("0");
        newInfoDto.setIslimit("0");
        newInfoDto.setDelivery_amount(data2.getDelv_cost());
        newInfoDto.setIsreturn("1");
        newInfoDto.setR_delivery_amount(data2.getDelv_r_cost());
        newInfoDto.setDelivery_type(data2.getDelv_type());
        newInfoDto.setTax("0");
        newInfoDto.setBrand(data2.getBrand_nm());
        newInfoDto.setMaker(data2.getMaker());
        newInfoDto.setModel(data2.getModel_no());
        newInfoDto.setOrigin(data2.getOrigin());
        if (!data2.getShop_cid_info().equals("")) {
            ShopCommonDao.get().getSyncCategory(newInfoDto, data2);
        }
        newInfoDto.setPa_gmarket(data2.getGmcategnm());
        newInfoDto.setGosi_code(data2.getProp1_cd());
        newInfoDto.setGosi1(data2.getProp_val1().equals("") ? "\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870" : data2.getProp_val1());
        newInfoDto.setGosi2(data2.getProp_val2().equals("") ? "\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870" : data2.getProp_val2());
        newInfoDto.setGosi3(data2.getProp_val3().equals("") ? "\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870" : data2.getProp_val3());
        newInfoDto.setGosi4(data2.getProp_val4().equals("") ? "\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870" : data2.getProp_val4());
        newInfoDto.setGosi5(data2.getProp_val5().equals("") ? "\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870" : data2.getProp_val5());
        newInfoDto.setGosi6(data2.getProp_val6().equals("") ? "\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870" : data2.getProp_val6());
        newInfoDto.setGosi7(data2.getProp_val7().equals("") ? "\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870" : data2.getProp_val7());
        newInfoDto.setGosi8(data2.getProp_val8().equals("") ? "\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870" : data2.getProp_val8());
        newInfoDto.setGosi9(data2.getProp_val9().equals("") ? "\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870" : data2.getProp_val9());
        newInfoDto.setGosi10(data2.getProp_val10().equals("") ? "\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870" : data2.getProp_val10());
        newInfoDto.setGosi11(data2.getProp_val11().equals("") ? "\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870" : data2.getProp_val11());
        newInfoDto.setGosi12(data2.getProp_val12().equals("") ? "\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870" : data2.getProp_val12());
        newInfoDto.setGosi13(data2.getProp_val13().equals("") ? "\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870" : data2.getProp_val13());
        newInfoDto.setGosi14(data2.getProp_val14().equals("") ? "\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870" : data2.getProp_val14());
        newInfoDto.setGosi15(data2.getProp_val15().equals("") ? "\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870" : data2.getProp_val15());
        newInfoDto.setGosi16(data2.getProp_val16().equals("") ? "\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870" : data2.getProp_val16());
        newInfoDto.setGosi17(data2.getProp_val17().equals("") ? "\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870" : data2.getProp_val17());
        newInfoDto.setGosi18(data2.getProp_val18().equals("") ? "\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870" : data2.getProp_val18());
        newInfoDto.setGosi19(data2.getProp_val19().equals("") ? "\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870" : data2.getProp_val19());
        newInfoDto.setGosi20(data2.getProp_val20().equals("") ? "\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870" : data2.getProp_val20());
        newInfoDto.setGosi21(data2.getProp_val21().equals("") ? "\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870" : data2.getProp_val21());
        newInfoDto.setGosi22(data2.getProp_val22().equals("") ? "\uc0c1\uc138\ud398\uc774\uc9c0 \uc124\uba85 \ucc38\uc870" : data2.getProp_val22());
        newInfoDto.setCert_type(data2.getCert_type());
        newInfoDto.setCert(data2.getCert());
        newInfoDto.setCert_no(data2.getCertno());
        infoTotal.add(newInfoDto);
        boolean result = DomesinShopDao.get().saveInfoReverse(infoTotal, monitor);
        if (result) {
            return newInfoDto.getIcode();
        }
        return "";
    }

    public void saveSupplements(JsonArray supplements, String prodseq, String icode) throws Exception {
        ArrayList<ShopAddProdInfoDto> addOptDtoList = new ArrayList<ShopAddProdInfoDto>();
        int seq = 0;
        int i = 0;
        while (i < supplements.size()) {
            JsonArray options = supplements.get(i).getAsJsonObject().get("options").getAsJsonArray();
            int j = 0;
            while (j < options.size()) {
                ShopAddProdInfoDto addOptDto = new ShopAddProdInfoDto();
                addOptDto.setProdseq(Integer.parseInt(prodseq));
                addOptDto.setSkuseq(++seq);
                addOptDto.setCompno(Integer.parseInt(YDMASessonUtil.getCompnoInfo().getCompno()));
                addOptDto.setCompayny_goods_cd(icode);
                addOptDto.setUser_code("001");
                addOptDto.setProd_type1(ShopCommon.jsonElementNullStr(options.get(j).getAsJsonObject().get("groupName")));
                addOptDto.setProd_val1(ShopCommon.jsonElementNullStr(options.get(j).getAsJsonObject().get("name")));
                addOptDto.setProd_type2("");
                addOptDto.setProd_val2("");
                addOptDto.setProd_amt(Integer.parseInt(ShopCommon.jsonElementNullInt(options.get(j).getAsJsonObject().get("price"))));
                addOptDto.setProd_cnt(Integer.parseInt(ShopCommon.jsonElementNullInt(options.get(j).getAsJsonObject().get("stockQuantity"))));
                addOptDto.setInsertdt(TimeUtils.getCurrentTimeFormat());
                addOptDto.setInsertid(YDMASessonUtil.getUserInfo().getUserId());
                addOptDtoList.add(addOptDto);
                ++j;
            }
            ++i;
        }
        ShopProductDao.get().insertAddProdInfo(addOptDtoList);
    }

    @Override
    public List<ProductDTO> complate(ShoppingmallDTO shopInfo, ProductAddOptionDTO searchOption, Map<String, String> cookies, List<String> prodlist, IProgressMonitor monitor) throws Exception {
        new ArrayList();
        ArrayList<ProductDTO> totlaSyncList = new ArrayList<ProductDTO>();
        ChromeDriver driver = ChromeExtention.getInstace().getDriver(true);
        String URL2 = "https://shopping.naver.com/";
        ChromeScript.get().get(driver, URL2);
        InterruptSource.Thread.sleep((long)2000L);
        this.cookie = ChromeScript.get().getCookies(driver);
        boolean saleDateFlag = true;
        String dateTime = searchOption.getSTART_DATE();
        int saleDate = (int)YDMATimeUtil.getDayOffset(dateTime, searchOption.getEND_DATE());
        if (saleDate < 0) {
            return null;
        }
        int idx = 0;
        while (saleDateFlag) {
            String json = "{\"searchKeywordType\":\"CHANNEL_PRODUCT_NO\",\"searchKeyword\":\"\",\"productName\":\"\",\"modelName\":\"\",\"manufacturerName\":\"\",\"brandName\":\"\",\"searchPaymentType\":\"ALL\",\"searchPeriodType\":\"PROD_REG_DAY\",\"deliveryAttributeType\":\"\",\"productKindType\":\"\",\"etcCondition\":\"\",\"fromDate\":\"" + searchOption.getSTART_DATE() + "T00:00:00.000+09:00\",\"toDate\":\"" + searchOption.getEND_DATE() + "T23:59:59.999+09:00\",\"viewData\":{\"productStatusTypes\":[\"WAIT\",\"SALE\",\"OUTOFSTOCK\",\"UNADMISSION\",\"REJECTION\",\"SUSPENSION\",\"CLOSE\",\"PROHIBITION\",\"\"],\"channelServiceTypes\":[\"STOREFARM\",\"WINDOW\",\"AFFILIATE\",\"\"],\"pageSize\":\"100\"},\"searchOrderType\":\"REG_DATE\",\"productStatusTypes\":[\"WAIT\",\"SALE\",\"OUTOFSTOCK\",\"UNADMISSION\",\"REJECTION\",\"SUSPENSION\",\"CLOSE\",\"PROHIBITION\"],\"channelServiceTypes\":[\"STOREFARM\",\"WINDOW\",\"AFFILIATE\"],\"page\":" + idx + ",\"size\":100,\"sort\":[]}";
            ++idx;
            Connection.Response rs = Jsoup.connect((String)"https://sell.smartstore.naver.com/api/products/list/search").cookies(cookies).header("Host", "sell.smartstore.naver.com").header("Connection", "keep-alive").header("x-to-stateName", "main.product.origin-list").header("Pragma", "no-cache").header("Cache-Control", "no-cache").header("x-current-stateName", "main.product.origin-list").header("x-current-state", "https://sell.smartstore.naver.com/#/products/origin-list").header("Origin", "https://sell.smartstore.naver.com").header("Content-Type", "application/json;charset=UTF-8").header("Accept", "*/*").header("Sec-Fetch-Site", "same-origin").header("Sec-Fetch-Mode", "cors").header("Sec-Fetch-Dest", "empty").requestBody(json).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").referrer("https://sell.smartstore.naver.com/").method(Connection.Method.POST).followRedirects(true).ignoreHttpErrors(true).ignoreContentType(true).execute();
            String body = rs.body();
            JsonParser jsonparser = new JsonParser();
            JsonObject jsonobject = (JsonObject)jsonparser.parse(body);
            JsonArray jsonArray = (JsonArray)jsonobject.get("content");
            List<String> hiddenProductId = new ArrayList<String>();
            List<String> productId = new ArrayList<String>();
            if (jsonArray == null || jsonArray.size() == 0) {
                saleDateFlag = false;
            } else {
                String sellerId = "";
                if (jsonArray.size() > 0) {
                    hiddenProductId = this.gethiddenProductIdBind((JsonArray)jsonobject.get("content"));
                    productId = this.getProductIdBind((JsonArray)jsonobject.get("content"));
                    sellerId = this.getSellerId(cookies);
                }
                if (hiddenProductId.size() > 0) {
                    List<ProductDTO> syncDatas = this.getProductDetailApiSearch(hiddenProductId, productId, shopInfo, monitor, cookies);
                    this.setProductDBbind(syncDatas, shopInfo, searchOption, monitor, cookies, sellerId, driver);
                }
            }
            try {
                monitor.subTask(idx + " page \uc0c1\ud488\uc815\ubcf4 \uc218\uc9d1\uc774 \uc644\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                monitor.worked(1);
                if (!monitor.isCanceled()) continue;
                monitor.done();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        driver.close();
        return totlaSyncList;
    }

    private List<String> gethiddenProductIdBind(JsonArray datas) {
        ArrayList<String> hiddenProductId = new ArrayList<String>();
        int i = 0;
        while (i < datas.size()) {
            JsonObject obj = (JsonObject)datas.get(i);
            String productId = obj.get("id").getAsString();
            hiddenProductId.add(productId);
            ++i;
        }
        return hiddenProductId;
    }

    private List<String> getProductIdBind(JsonArray datas) {
        ArrayList<String> productId = new ArrayList<String>();
        int i = 0;
        while (i < datas.size()) {
            JsonObject obj = (JsonObject)datas.get(i);
            String prdId = obj.get("storefarmChannelProductNo").getAsString();
            productId.add(prdId);
            ++i;
        }
        return productId;
    }

    private String getSellerId(Map<String, String> cookies) {
        String sellerId = "";
        try {
            Connection.Response response = Jsoup.connect((String)"https://sell.smartstore.naver.com/api/sellers/account?maskApplyTypes=MEMBER&maskApplyTypes=SETTLEMENT").cookies(cookies).header("Host", "smartstore.naver.com").method(Connection.Method.GET).followRedirects(true).ignoreHttpErrors(true).ignoreContentType(true).execute();
            JsonParser parser = new JsonParser();
            JsonObject body = parser.parse(response.body()).getAsJsonObject();
            JsonObject defaultChannel = body.get("defaultChannel").getAsJsonObject();
            sellerId = defaultChannel.get("url").getAsString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sellerId;
    }

    private List<ProductDTO> getProductDetailApiSearch(List<String> hiddenProductId, List<String> productId, ShoppingmallDTO shopInfo, IProgressMonitor monitor, Map<String, String> cookies) throws Exception {
        ArrayList<ProductDTO> syncDatas = new ArrayList<ProductDTO>();
        try {
            int i = 0;
            while (i < hiddenProductId.size()) {
                String URL2 = "https://sell.smartstore.naver.com/api/products/%s";
                URL2 = String.format(URL2, hiddenProductId.get(i));
                Connection.Response rs = Jsoup.connect((String)URL2).cookies(cookies).header("Host", "sell.smartstore.naver.com").header("Connection", "keep-alive").header("x-to-stateName", "main.product.edit").header("Pragma", "no-cache").header("Cache-Control", "no-cache").header("x-current-stateName", "main.product.origin-list").header("x-current-state", "https://sell.smartstore.naver.com/#/products/edit/" + hiddenProductId.get(i)).header("Accept", "*/*").header("Sec-Fetch-Site", "same-origin").header("Sec-Fetch-Mode", "cors").header("Sec-Fetch-Dest", "empty").userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").referrer("https://sell.smartstore.naver.com/").method(Connection.Method.GET).followRedirects(true).ignoreHttpErrors(true).ignoreContentType(true).execute();
                String body = rs.body();
                JsonParser jsonparser = new JsonParser();
                JsonObject jsonobject = (JsonObject)jsonparser.parse(body);
                JsonObject datas = (JsonObject)jsonobject.get("product");
                if (rs.statusCode() == 200 && datas.size() > 0) {
                    try {
                        ProductDTO syncData = this.onDatabind(datas, shopInfo, monitor, productId.get(i), hiddenProductId.get(i), cookies);
                        syncDatas.add(syncData);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return syncDatas;
    }

    private ProductDTO onDatabind(JsonObject datas, ShoppingmallDTO shopInfo, IProgressMonitor monitor, String prdCd, String naverprdcd, Map<String, String> cookies) throws Exception {
        String noticetype;
        ProductDTO data2 = new ProductDTO();
        data2.setImg_path22(ShopCommon.jsonElementNullStr(datas.get("id")));
        data2.setShopprodno(prdCd);
        data2.setNaverprdcd(naverprdcd);
        data2.setSendstats(this.getStatusCd(ShopCommon.jsonElementNullStr(datas.get("statusType")).replace("\"", "")));
        JsonObject shopcategory = (JsonObject)datas.get("category");
        data2.setClass_cd3(ShopCommon.jsonElementNullStr(shopcategory.get("id")));
        String category = ShopCommonDao.get().getEsCodeNaver(data2.getClass_cd3());
        if (!category.equals("")) {
            data2.setEs(category.split("[|]")[0]);
            data2.setCatno(category.split("[|]")[0]);
            data2.setShop_cid_info(category.split("[|]")[1]);
        } else {
            data2.setEs("");
            data2.setShop_cid_info("");
        }
        String full_cateName = CaffeineCategoryCache.getInstance().getFullCategoryName(data2.getEs());
        data2.setGmcategnm(full_cateName);
        data2.setCid(ShopCommon.jsonElementNullStr(shopcategory.get("id")));
        data2.setGoods_nm(ShopCommon.jsonElementNullStr(datas.get("name")));
        String saleStartDate = ShopCommon.jsonElementNullStr(datas.get("saleStartDate"));
        saleStartDate = saleStartDate.substring(0, saleStartDate.indexOf(".")).replace("T", " ");
        String saleEndDate = ShopCommon.jsonElementNullStr(datas.get("saleEndDate"));
        saleEndDate = saleEndDate.substring(0, saleEndDate.indexOf(".")).replace("T", " ");
        data2.setInsertdt(saleStartDate.equals("") ? YDMATimeUtil.getCurrentDateScheduler() : saleStartDate);
        data2.setSaleenddt(saleEndDate);
        JsonObject detailAttribute = (JsonObject)datas.get("detailAttribute");
        JsonObject naverShoppingSearchInfo = (JsonObject)detailAttribute.get("naverShoppingSearchInfo");
        if (naverShoppingSearchInfo == null) {
            data2.setMaker("");
            data2.setBrand_nm("");
            data2.setModel_no("");
        } else {
            data2.setMaker(ShopCommon.jsonElementNullStr(naverShoppingSearchInfo.get("manufacturerName")));
            data2.setBrand_nm(ShopCommon.jsonElementNullStr(naverShoppingSearchInfo.get("brandName")));
            data2.setModel_no(ShopCommon.jsonElementNullStr(naverShoppingSearchInfo.get("modelName")));
        }
        JsonObject originAreaInfo = (JsonObject)detailAttribute.get("originAreaInfo");
        data2.setOrigin(ShopCommon.jsonElementNullStr(originAreaInfo.get("content")));
        if (!datas.has("deliveryInfo")) {
            data2.setDelv_type("FREE");
            data2.setDelv_cost("0");
            data2.setDelv_r_cost("0");
        } else {
            JsonObject deliveryInfo = (JsonObject)datas.get("deliveryInfo");
            JsonObject deliveryFee = (JsonObject)deliveryInfo.get("deliveryFee");
            JsonObject claimDeliveryInfo = (JsonObject)deliveryInfo.get("claimDeliveryInfo");
            data2.setDelv_type(this.getDeliveryType(ShopCommon.jsonElementNullStr(deliveryFee.get("deliveryFeeType"))));
            data2.setDelv_cost(ShopCommon.jsonElementNullStr(deliveryFee.get("baseFee")));
            data2.setDelv_r_cost(ShopCommon.jsonElementNullStr(claimDeliveryInfo.get("exchangeDeliveryFee")));
        }
        data2.setMarket_price(ShopCommon.jsonElementNullInt(datas.get("salePrice")));
        data2.setGoods_price(ShopCommon.jsonElementNullInt(datas.get("salePrice")));
        data2.setGoods_consumer_price(ShopCommon.jsonElementNullInt(datas.get("salePrice")));
        data2.setQty(ShopCommon.jsonElementNullInt(datas.get("stockQuantity")));
        data2.setAdult(ShopCommon.jsonElementNullStr(detailAttribute.get("minorPurchasable")).toString() == "false" ? "1" : "0");
        data2.setTax_yn(this.getTax(ShopCommon.jsonElementNullStr(detailAttribute.get("taxType"))));
        data2.setIs_overseas("0");
        JsonObject sellerCodeInfo = (JsonObject)detailAttribute.get("sellerCodeInfo");
        if (sellerCodeInfo == null) {
            data2.setCompayny_goods_cd("");
        } else {
            data2.setCompayny_goods_cd(ShopCommon.jsonElementNullStr(sellerCodeInfo.get("sellerManagementCode")));
        }
        if (data2.getCompayny_goods_cd().length() < 5) {
            data2.setCompayny_goods_cd("");
        }
        if (detailAttribute.has("seoInfo")) {
            JsonObject seoInfo = (JsonObject)detailAttribute.get("seoInfo");
            JsonArray sellerTags = (JsonArray)seoInfo.get("sellerTags");
            data2.setGoods_search(this.getKeyWord(sellerTags));
        } else {
            data2.setGoods_search("");
        }
        JsonArray images = (JsonArray)datas.get("images");
        int i = 0;
        while (i < images.size()) {
            String image = ShopCommon.jsonElementNullStr(images.get(i).getAsJsonObject().get("imageUrl"));
            this.getApiImages(data2, i, image);
            ++i;
        }
        JsonObject optionInfo = (JsonObject)detailAttribute.get("optionInfo");
        data2.setSelect_option("");
        if (optionInfo.get("optionUsable").toString().toLowerCase().equals("true")) {
            String option2 = this.getApioption(optionInfo, Integer.parseInt(data2.getMarket_price()));
            data2.setSelect_option(option2);
            JsonArray optionTypes = optionInfo.get("options").getAsJsonArray();
            data2.setChar_1_nm(optionTypes.size() > 0 ? optionTypes.get(0).getAsJsonObject().get("groupName").getAsString() : "");
            data2.setChar_2_nm(optionTypes.size() > 1 ? optionTypes.get(1).getAsJsonObject().get("groupName").getAsString() : "");
            JsonArray optionVals = optionInfo.get("optionCombinations").getAsJsonArray();
            ArrayList<String> val1s = new ArrayList<String>();
            ArrayList<String> val2s = new ArrayList<String>();
            int i2 = 0;
            while (i2 < optionVals.size()) {
                JsonObject val = optionVals.get(i2).getAsJsonObject();
                if (optionTypes.size() > 1) {
                    val1s.add(val.get("optionName1").getAsString());
                    val2s.add(val.get("optionName2").getAsString());
                } else {
                    val1s.add(val.get("optionName1").getAsString());
                }
                ++i2;
            }
            if (val1s.size() > 0) {
                String val1 = val1s.stream().distinct().collect(Collectors.joining(":"));
                data2.setChar_1_val(val1);
            }
            if (val2s.size() > 0) {
                String val2 = val2s.stream().distinct().collect(Collectors.joining(":"));
                data2.setChar_2_val(val2);
            }
        }
        JsonObject productInfoProvidedNotice = (JsonObject)detailAttribute.get("productInfoProvidedNotice");
        JsonObject productInfoProvidedNoticeContent = (JsonObject)productInfoProvidedNotice.get("productInfoProvidedNoticeContent");
        String gosiNum = "035";
        if (productInfoProvidedNoticeContent != null && !(noticetype = this.getGosiInfo(productInfoProvidedNoticeContent.get("productInfoProvidedNoticeType").toString().replace("\"", ""))).equals("\uae30\ud0c0")) {
            gosiNum = ShopProductDao.get().getGosiNum(noticetype);
        }
        data2.setProp1_cd(String.valueOf(gosiNum));
        List<String> prop = this.getProvidedNotice_eng(productInfoProvidedNoticeContent);
        this.setProp(gosiNum, prop, data2);
        data2.setGoods_remarks("");
        data2.setItype(this.setStatus(ShopCommon.jsonElementNullStr(datas.get("saleType"))));
        data2.setShopid(shopInfo.getSHOPPINGID());
        try {
            monitor.subTask("[\uc0c1\ud488\uc815\ubcf4[" + data2.getCompayny_goods_cd() + "] \ubcc0\ud658\uc911\uc785\ub2c8\ub2e4...]");
            monitor.worked(1);
            if (monitor.isCanceled()) {
                monitor.done();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return data2;
    }

    private void setProductDBbind(List<ProductDTO> syncDatas, ShoppingmallDTO shopInfo, ProductAddOptionDTO searchOption, IProgressMonitor monitor, Map<String, String> cookies, String sellerId, ChromeDriver driver) throws Exception {
        ArrayList<ProductDTO> syncList = new ArrayList<ProductDTO>();
        ArrayList<ProductItemDto> infoTotal = new ArrayList<ProductItemDto>();
        ArrayList<ProductDTO> inTotal = new ArrayList<ProductDTO>();
        int cnt = 0;
        for (ProductDTO sync : syncDatas) {
            try {
                ProductDTO infoDto;
                int count;
                if (sync.getCompayny_goods_cd().equals("")) {
                    if (this.companyGoodsCd == 0) {
                        this.companyGoodsCd = ShopProductDao.get().getMaxCompanyGoodsCd();
                    }
                    sync.setCompayny_goods_cd("MLK" + String.format("%05d", ++this.companyGoodsCd));
                }
                if ((count = (int)syncDatas.stream().filter(d -> d.getCompayny_goods_cd().contains(sync.getCompayny_goods_cd())).count()) > 1) {
                    sync.setCompayny_goods_cd(sync.getCompayny_goods_cd() + "_" + String.valueOf(cnt++));
                }
                if ((infoDto = ShopProductDao.get().getShopInfOne("COMPAYNY_GOODS_CD", sync.getCompayny_goods_cd())) != null) {
                    infoDto.setCompno(YDMASessonUtil.getCompnoInfo().getCompno());
                    infoDto.setGoods_nm(sync.getGoods_nm());
                    infoDto.setGoods_price(sync.getGoods_price());
                    infoDto.setMarket_price(sync.getGoods_price());
                    infoDto.setGoods_consumer_price(sync.getGoods_price());
                    infoDto.setShopprodno(sync.getSendstats().equals(Integer.toString(8000)) ? sync.getShopprodno() : "");
                    infoDto.setChar_1_nm(sync.getChar_1_nm());
                    infoDto.setChar_1_val(sync.getChar_1_val());
                    infoDto.setChar_2_nm(sync.getChar_2_nm());
                    infoDto.setChar_2_val(sync.getChar_2_val());
                    infoDto.setNaverprdcd(sync.getNaverprdcd());
                    infoDto.setInsertdt(sync.getInsertdt());
                    infoDto.setSaleenddt(sync.getSaleenddt());
                    infoDto.setShopcd(shopInfo.getSHOPCD());
                    infoDto.setShopseq(String.valueOf(shopInfo.getSHOPSEQ()));
                    infoDto.setSHOP_USERID(shopInfo.getSHOPPINGID());
                    infoDto.setSendstats(sync.getSendstats());
                    infoDto.setMaker(sync.getMaker());
                    infoDto.setOrigin(sync.getOrigin());
                    infoDto.setBrand_nm(sync.getBrand_nm());
                    infoDto.setProp1_cd(sync.getProp1_cd());
                    infoDto.setAdult(sync.getAdult());
                    infoDto.setIsreturn("1");
                    infoDto.setIs_overseas(sync.getIs_overseas());
                    infoDto.setItype(sync.getItype());
                    infoDto.setProp_val1(this.checkPropVal(sync.getProp_val1()));
                    infoDto.setProp_val2(this.checkPropVal(sync.getProp_val2()));
                    infoDto.setProp_val3(this.checkPropVal(sync.getProp_val3()));
                    infoDto.setProp_val4(this.checkPropVal(sync.getProp_val4()));
                    infoDto.setProp_val5(this.checkPropVal(sync.getProp_val5()));
                    infoDto.setProp_val6(this.checkPropVal(sync.getProp_val6()));
                    infoDto.setProp_val7(this.checkPropVal(sync.getProp_val7()));
                    infoDto.setProp_val8(this.checkPropVal(sync.getProp_val8()));
                    infoDto.setProp_val9(this.checkPropVal(sync.getProp_val9()));
                    infoDto.setProp_val10(this.checkPropVal(sync.getProp_val10()));
                    infoDto.setProp_val11(this.checkPropVal(sync.getProp_val11()));
                    infoDto.setProp_val12(this.checkPropVal(sync.getProp_val12()));
                    infoDto.setProp_val13(this.checkPropVal(sync.getProp_val13()));
                    infoDto.setProp_val14(this.checkPropVal(sync.getProp_val14()));
                    infoDto.setProp_val15(this.checkPropVal(sync.getProp_val15()));
                    infoDto.setProp_val16(this.checkPropVal(sync.getProp_val16()));
                    infoDto.setProp_val17(this.checkPropVal(sync.getProp_val17()));
                    infoDto.setProp_val18(this.checkPropVal(sync.getProp_val18()));
                    infoDto.setProp_val19(this.checkPropVal(sync.getProp_val19()));
                    infoDto.setProp_val20(this.checkPropVal(sync.getProp_val20()));
                    infoDto.setProp_val21(this.checkPropVal(sync.getProp_val21()));
                    infoDto.setProp_val22(this.checkPropVal(sync.getProp_val22()));
                    infoDto.setProp_val23(this.checkPropVal(sync.getProp_val23()));
                    infoDto.setProp_val24(this.checkPropVal(sync.getProp_val24()));
                    infoDto.setProp_val25(this.checkPropVal(sync.getProp_val25()));
                    infoDto.setProp_val26(this.checkPropVal(sync.getProp_val26()));
                    infoDto.setProp_val27(this.checkPropVal(sync.getProp_val27()));
                    infoDto.setProp_val28(this.checkPropVal(sync.getProp_val28()));
                    infoDto.setCompayny_goods_cd(sync.getCompayny_goods_cd());
                    infoDto.setSelect_option(sync.getSelect_option());
                    int i = 0;
                    while (i < syncList.size()) {
                        this.saveImages(sync, i, infoDto);
                        ++i;
                    }
                    infoDto.setTax_yn(sync.getTax_yn());
                    infoDto.setDelv_cost(sync.getDelv_cost());
                    infoDto.setDelv_r_cost(sync.getDelv_r_cost());
                    infoDto.setShopcatcd(sync.getShop_cid_info());
                    infoDto.setGoods_search(sync.getGoods_search());
                    infoDto.setStatus(sync.getStatus());
                    String retJsoncate = ShopCommonDao.get().getCategorySetting(infoDto.getShop_cid_info(), infoDto.getShopcd(), sync.getClass_cd3());
                    infoDto.setShop_cid_info(retJsoncate);
                    infoDto.setImg_path22(sync.getImg_path22());
                    infoDto.setGmcategnm(sync.getGmcategnm());
                    inTotal.add(infoDto);
                    syncList.add(infoDto);
                    continue;
                }
                if (!sync.getSendstats().equals(Integer.toString(8000))) continue;
                ProductDTO inDto = new ProductDTO();
                inDto.setCatno(sync.getCatno());
                inDto.setImg_path22(sync.getImg_path22());
                inDto.setNaverprdcd(sync.getNaverprdcd());
                inDto.setCompno(YDMASessonUtil.getCompnoInfo().getCompno());
                inDto.setGoods_nm(sync.getGoods_nm());
                inDto.setGoods_price(sync.getGoods_price());
                inDto.setGoods_cost(sync.getGoods_price());
                inDto.setMarket_price(sync.getGoods_price());
                inDto.setLimit_price("0");
                inDto.setGoods_consumer_price(sync.getGoods_price());
                inDto.setShopprodno(sync.getShopprodno());
                inDto.setInsertdt(sync.getInsertdt());
                inDto.setSaleenddt(sync.getSaleenddt());
                inDto.setShopcd(shopInfo.getSHOPCD());
                inDto.setShopseq(String.valueOf(shopInfo.getSHOPSEQ()));
                inDto.setDelv_type(sync.getDelv_type());
                inDto.setSHOP_USERID(shopInfo.getSHOPPINGID());
                inDto.setSendstats(sync.getSendstats());
                String url = String.format("https://smartstore.naver.com/%s/products/%s", sellerId, sync.getShopprodno());
                sync.setGoods_remarks(this.getDetailProducts(driver, url));
                inDto.setGoods_remarks(sync.getGoods_remarks());
                inDto.setDelv_qty("");
                inDto.setIslimit("0");
                inDto.setChar_1_nm(sync.getChar_1_nm());
                inDto.setChar_1_val(sync.getChar_1_val());
                inDto.setChar_2_nm(sync.getChar_2_nm());
                inDto.setChar_2_val(sync.getChar_2_val());
                inDto.setMaker(sync.getMaker());
                inDto.setOrigin(sync.getOrigin());
                inDto.setBrand_nm(sync.getBrand_nm());
                inDto.setProp1_cd(sync.getProp1_cd());
                inDto.setAdult(sync.getAdult());
                inDto.setIsreturn("1");
                inDto.setIs_overseas(sync.getIs_overseas());
                inDto.setItype(sync.getItype());
                inDto.setGoods_keyword(searchOption.getDOME_CODE());
                inDto.setProp_val1(this.checkPropVal(sync.getProp_val1()));
                inDto.setProp_val2(this.checkPropVal(sync.getProp_val2()));
                inDto.setProp_val3(this.checkPropVal(sync.getProp_val3()));
                inDto.setProp_val4(this.checkPropVal(sync.getProp_val4()));
                inDto.setProp_val5(this.checkPropVal(sync.getProp_val5()));
                inDto.setProp_val6(this.checkPropVal(sync.getProp_val6()));
                inDto.setProp_val7(this.checkPropVal(sync.getProp_val7()));
                inDto.setProp_val8(this.checkPropVal(sync.getProp_val8()));
                inDto.setProp_val9(this.checkPropVal(sync.getProp_val9()));
                inDto.setProp_val10(this.checkPropVal(sync.getProp_val10()));
                inDto.setProp_val11(this.checkPropVal(sync.getProp_val11()));
                inDto.setProp_val12(this.checkPropVal(sync.getProp_val12()));
                inDto.setProp_val13(this.checkPropVal(sync.getProp_val13()));
                inDto.setProp_val14(this.checkPropVal(sync.getProp_val14()));
                inDto.setProp_val15(this.checkPropVal(sync.getProp_val15()));
                inDto.setProp_val16(this.checkPropVal(sync.getProp_val16()));
                inDto.setProp_val17(this.checkPropVal(sync.getProp_val17()));
                inDto.setProp_val18(this.checkPropVal(sync.getProp_val18()));
                inDto.setProp_val19(this.checkPropVal(sync.getProp_val19()));
                inDto.setProp_val20(this.checkPropVal(sync.getProp_val20()));
                inDto.setProp_val21(this.checkPropVal(sync.getProp_val21()));
                inDto.setProp_val22(this.checkPropVal(sync.getProp_val22()));
                inDto.setProp_val23(this.checkPropVal(sync.getProp_val23()));
                inDto.setProp_val24(this.checkPropVal(sync.getProp_val24()));
                inDto.setProp_val25(this.checkPropVal(sync.getProp_val25()));
                inDto.setProp_val26(this.checkPropVal(sync.getProp_val26()));
                inDto.setProp_val27(this.checkPropVal(sync.getProp_val27()));
                inDto.setProp_val28(this.checkPropVal(sync.getProp_val28()));
                inDto.setCompayny_goods_cd(sync.getCompayny_goods_cd());
                inDto.setSelect_option(sync.getSelect_option());
                int i = 0;
                while (i < syncList.size()) {
                    this.saveImages(sync, i, inDto);
                    ++i;
                }
                inDto.setTax_yn(sync.getTax_yn());
                inDto.setDelv_cost(sync.getDelv_cost());
                inDto.setDelv_r_cost(sync.getDelv_r_cost());
                inDto.setShopcatcd(sync.getShop_cid_info());
                inDto.setGoods_search(sync.getGoods_search());
                inDto.setStatus(sync.getStatus());
                inDto.setGmcategnm(sync.getGmcategnm());
                ProductItemDto newInfoDto = new ProductItemDto();
                newInfoDto.setIname(sync.getGoods_nm());
                newInfoDto.setPrice(sync.getGoods_price());
                newInfoDto.setPrice_consumer(sync.getGoods_price());
                newInfoDto.setGosi_code(sync.getProp1_cd());
                newInfoDto.setCid(sync.getEs());
                newInfoDto.setStatus("0");
                newInfoDto.setAdult(sync.getAdult());
                newInfoDto.setSearch(searchOption.getDOME_CODE());
                newInfoDto.setPa_gmarket(sync.getGmcategnm());
                newInfoDto.setGosi1(sync.getProp_val1());
                newInfoDto.setGosi2(sync.getProp_val2());
                newInfoDto.setGosi3(sync.getProp_val3());
                newInfoDto.setGosi4(sync.getProp_val4());
                newInfoDto.setGosi5(sync.getProp_val5());
                newInfoDto.setContent(sync.getGoods_remarks());
                newInfoDto.setDelivery_qty("0");
                newInfoDto.setIslimit("0");
                newInfoDto.setDelivery_type(sync.getDelv_type());
                newInfoDto.setBrand(sync.getBrand_nm());
                newInfoDto.setMaker(sync.getMaker());
                newInfoDto.setOrigin(sync.getOrigin());
                newInfoDto.setCate_depth("3");
                newInfoDto.setCert_type("0");
                newInfoDto.setIcode(sync.getCompayny_goods_cd());
                if (!sync.getShop_cid_info().equals("")) {
                    ShopCommonDao.get().getSyncCategory(newInfoDto, sync);
                }
                newInfoDto.setClass_cd3(sync.getEs());
                newInfoDto.setKeyword(sync.getGoods_search());
                newInfoDto.setSelect_option(sync.getSelect_option());
                String[] image = new String[24];
                int i2 = 0;
                while (i2 < image.length) {
                    this.saveImage(sync, i2, image);
                    ++i2;
                }
                newInfoDto.setImg(image);
                newInfoDto.setTax(sync.getTax_yn());
                newInfoDto.setDelivery_amount(sync.getDelv_cost());
                if (monitor.isCanceled()) {
                    monitor.done();
                    break;
                }
                infoTotal.add(newInfoDto);
                inTotal.add(inDto);
            }
            catch (Exception exception) {}
        }
        try {
            monitor.subTask("\uc0c1\ud488\uc815\ubcf4\ub97c \uc800\uc7a5\uc911\uc785\ub2c8\ub2e4...");
            monitor.worked(1);
            if (monitor.isCanceled()) {
                monitor.done();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        ArrayList<ProductDTO> inSaveList = new ArrayList<ProductDTO>();
        if (infoTotal != null && infoTotal.size() > 0) {
            DomesinShopDao.get().saveInfoReverse(infoTotal, monitor);
        }
        for (ProductDTO inList : inTotal) {
            try {
                String[] infomation = ShopProductDao.get().getProdSeq(inList.getCompayny_goods_cd());
                inList.setPRODSEQ(infomation[0]);
                inList.setClass_cd1(infomation[1]);
                inList.setClass_cd2(infomation[2]);
                inList.setClass_cd3(infomation[3]);
                inList.setShopseq(String.valueOf(shopInfo.getSHOPSEQ()));
                ObjectMapper mapper = new ObjectMapper();
                ShopProductDao.ShopCateItem[] shopcateItem = (ShopProductDao.ShopCateItem[])mapper.readValue(infomation[4], ShopProductDao.ShopCateItem[].class);
                mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
                String retJson = mapper.writeValueAsString((Object)shopcateItem);
                inList.setShop_cid_info(retJson);
                inSaveList.add(inList);
            }
            catch (Exception exception) {}
        }
        if (inSaveList.size() > 0) {
            ShopProductDao.get().setProductInfoInsertNUpdate(inSaveList);
        }
        for (ProductDTO inList1 : inSaveList) {
            try {
                List<ShopProductOptionDto> ItemList2;
                this.getProductOptions(inList1);
                ShoppingMallDetailDto shoppingMallDetailDto = new ShoppingMallDetailDto();
                shoppingMallDetailDto.setAuthkey1(shopInfo.getAUTHKEY1());
                shoppingMallDetailDto.setAuthkey2(shopInfo.getAUTHKEY2());
                shoppingMallDetailDto.setVendorId(shopInfo.getVENDORID());
                try {
                    monitor.subTask("[\uc635\uc158\uc815\ubcf4 \uc800\uc7a5\uc911\uc785\ub2c8\ub2e4...]");
                    monitor.worked(0);
                    if (monitor.isCanceled()) {
                        monitor.done();
                        break;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if ((ItemList2 = this.getMallItemInfo(inList1, shoppingMallDetailDto, cookies)).size() <= 0) continue;
                WorkMngDao.get().insertOptprodin(ItemList2);
            }
            catch (Exception exception) {}
        }
    }

    private String getDetailProducts(ChromeDriver driver, String url) throws Exception {
        StringBuilder detailDesc = new StringBuilder();
        driver.get(url);
        InterruptSource.Thread.sleep((long)5000L);
        WebElement Element2 = null;
        try {
            Element2 = driver.findElement(By.xpath((String)"//*[@id='INTRODUCE']/div/div[4]/div/button"));
            driver.executeScript("arguments[0].scrollIntoView();", new Object[]{Element2});
            InterruptSource.Thread.sleep((long)1000L);
            driver.executeScript("document.querySelector('#INTRODUCE > div > div:nth-child(4) > div > button').click();", new Object[]{""});
        }
        catch (Exception exception) {
            try {
                Element2 = driver.findElement(By.xpath((String)"//*[@id='INTRODUCE']/div/div[5]/div/button"));
                driver.executeScript("arguments[0].scrollIntoView();", new Object[]{Element2});
                InterruptSource.Thread.sleep((long)1000L);
                driver.executeScript("document.querySelector('#INTRODUCE > div > div:nth-child(5) > div > button').click();", new Object[]{""});
            }
            catch (Exception exception2) {
                try {
                    driver.executeScript("window.scrollBy(0,4500)", new Object[]{""});
                    InterruptSource.Thread.sleep((long)1000L);
                    driver.executeScript("document.querySelector('#INTRODUCE > div > div:nth-child(5) > div > button').click();", new Object[]{""});
                }
                catch (Exception exception3) {}
            }
        }
        String getGoods_remarks1 = "";
        Object getGoods_remarks2 = "";
        WebDriverWait wait = new WebDriverWait((WebDriver)driver, 10L);
        detailDesc.append("<p align=center>");
        try {
            InterruptSource.Thread.sleep((long)2000L);
            getGoods_remarks1 = ((WebElement)wait.until((Function)ExpectedConditions.elementToBeClickable((By)By.className((String)"HU3BvGpu9d")))).getAttribute("innerHTML");
            BufferedReader reader = new BufferedReader(new StringReader(getGoods_remarks1));
            while (true) {
                String line;
                if (!(line = reader.readLine()).equals("") && line != null) {
                    continue;
                }
                int len = line.length();
                int strIdx = line.indexOf("data-src=\"http");
                if (strIdx == -1) continue;
                int strPos = strIdx + 10;
                String findStr = line.substring(strPos, len);
                int endPos = findStr.indexOf("\"");
                String rsultStr = findStr.substring(1, endPos);
                detailDesc.append("<img src=");
                detailDesc.append(rsultStr);
                detailDesc.append("></p><p align=center>");
            }
        }
        catch (Exception exception) {
            try {
                String line;
                InterruptSource.Thread.sleep((long)4000L);
                getGoods_remarks2 = (String)getGoods_remarks2 + ((WebElement)wait.until((Function)ExpectedConditions.elementToBeClickable((By)By.className((String)"_9F9CWn02VE")))).getAttribute("innerHTML");
                BufferedReader reader = new BufferedReader(new StringReader((String)getGoods_remarks2));
                while (!(line = reader.readLine()).equals("") && line != null) {
                    int len = line.length();
                    int strIdx = line.indexOf("data-src=\"http");
                    if (strIdx == -1) continue;
                    int strPos = strIdx + 10;
                    String findStr = line.substring(strPos, len);
                    int endPos = findStr.indexOf("\"");
                    String rsultStr = findStr.substring(0, endPos);
                    detailDesc.append("<img src=");
                    detailDesc.append(rsultStr);
                    detailDesc.append("></p><p align=center>");
                }
            }
            catch (Exception exception4) {}
            detailDesc.append("</p><p align=center>");
            return detailDesc.toString();
        }
    }

    private List<ShopProductOptionDto> getMallItemInfo(ProductDTO dto, ShoppingMallDetailDto shoppingMallDetailDto, Map<String, String> cookies) throws Exception {
        String URL2 = "https://sell.smartstore.naver.com/api/products/%s";
        URL2 = String.format(URL2, dto.getNaverprdcd());
        Connection.Response response = Jsoup.connect((String)URL2).cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").referrer("https://sell.smartstore.naver.com/").ignoreContentType(true).method(Connection.Method.GET).execute();
        String body = response.body();
        JsonParser jsonparser = new JsonParser();
        JsonObject jsonobject = (JsonObject)jsonparser.parse(body);
        JsonObject datas = (JsonObject)jsonobject.get("product");
        JsonObject detailAttribute = (JsonObject)datas.get("detailAttribute");
        JsonObject optionInfo = (JsonObject)detailAttribute.get("optionInfo");
        JsonArray optionCombinations = optionInfo.get("optionCombinations").getAsJsonArray();
        ArrayList<String> optionTypes = new ArrayList<String>();
        JsonArray options = optionInfo.get("options").getAsJsonArray();
        int i = 0;
        while (i < options.size()) {
            JsonObject option2 = options.get(i).getAsJsonObject();
            optionTypes.add(option2.get("groupName").getAsString());
            ++i;
        }
        String optionType = optionTypes.stream().collect(Collectors.joining(":"));
        ArrayList<ShopProductOptionDto> dtos = new ArrayList<ShopProductOptionDto>();
        if (response.statusCode() == 200 && datas.size() > 0) {
            ShopProdInDto prodIn = ShopProductDao.get().getShopSaleProductInfo(dto.getCompayny_goods_cd(), dto.getShopcd());
            int i2 = 0;
            while (i2 < optionCombinations.size()) {
                JsonObject option3 = optionCombinations.get(i2).getAsJsonObject();
                ShopProductOptionDto optdto = new ShopProductOptionDto();
                optdto.setSendseq(prodIn.getSendseq());
                optdto.setSkuseq(i2 + 1);
                optdto.setCompno(Integer.parseInt(YDMASessonUtil.getCompnoInfo().getCompno()));
                optdto.setShopprodno(dto.getShopprodno());
                optdto.setShopprodsku(ShopCommon.jsonElementNullStr(option3.get("id")));
                optdto.setShopprodsku_nm(dto.getGoods_nm());
                optdto.setProdseq(Integer.parseInt(dto.getPRODSEQ()));
                optdto.setProdcd(dto.getCompayny_goods_cd().concat("-").concat(Integer.toString(i2 + 1)));
                optdto.setOptprodnm(optionType);
                String val = "";
                if (option3.has("optionName1")) {
                    val = option3.get("optionName1").getAsString();
                }
                if (option3.has("optionName2")) {
                    val = val.concat(":").concat(option3.get("optionName2").getAsString());
                }
                if (option3.has("optionName3")) {
                    val = val.concat(":").concat(option3.get("optionName3").getAsString());
                }
                optdto.setOptspecdes(val);
                optdto.setOptsafestock(Integer.toString(option3.get("price").getAsInt() + Integer.parseInt(dto.getGoods_price())));
                optdto.setOptvertstock(ShopCommon.jsonElementNullStr(datas.get("stockQuantity")));
                optdto.setOptaddamt(option3.get("price").getAsInt());
                optdto.setBarcode(ShopCommon.jsonElementNullStr(option3.get("id")));
                dtos.add(optdto);
                ++i2;
            }
        }
        return dtos;
    }

    public List<ShopOptionDto> getProductOptions(ProductDTO dto) {
        ArrayList<ShopOptionDto> options = new ArrayList<ShopOptionDto>();
        ShopOptionProductInfoDao dao = new ShopOptionProductInfoDao();
        try {
            List<ShopProductOptionDto> list = dao.getShopOptProdInfoListByProdseq(dto.getPRODSEQ());
            for (ShopProductOptionDto optdto : list) {
                ShopOptionDto opt = new ShopOptionDto();
                opt.setSkuseq(String.valueOf(optdto.getSkuseq()));
                opt.setName(optdto.getOptprodnm());
                opt.setOptspecdes(optdto.getOptspecdes());
                opt.setCnt(optdto.getOptvertstock());
                opt.setAmt(String.valueOf(optdto.getOptaddamt()));
                opt.setOptcompanycd(optdto.getOptprodcd());
                opt.setLimit_price(optdto.getLimit_price());
                opt.setSellerProductItemId("");
                opt.setVendorItemId("");
                options.add(opt);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return options;
    }

    private String checkPropVal(String propVal) {
        if (propVal == null || propVal.trim().isEmpty()) {
            return "";
        }
        return propVal;
    }

    private void setProp(String gosiNum, List<String> prop, ProductDTO data2) throws Exception {
        HashMap<String, String> propMapping = ShopProductDao.get().setNaverNotice(gosiNum, prop);
        Set<String> keySet = propMapping.keySet();
        for (String key : keySet) {
            if (propMapping.get(key) == null) continue;
            String[] seqList = propMapping.get(key).split(",");
            String inputProp = "";
            if (key.contains("\ud488\uba85")) {
                inputProp = prop.get(0);
            } else if (key.contains("\ubaa8\ub378\uba85")) {
                inputProp = prop.get(1);
            } else if (key.contains("\uc778\uc99d \ud5c8\uac00")) {
                inputProp = prop.get(2);
            } else if (key.contains("\uc81c\uc870\uc790") || key.contains("\uc0dd\uc0b0\uc790")) {
                inputProp = prop.get(3);
            } else if (key.contains("A/S \ucc45\uc784\uc790")) {
                inputProp = prop.get(4);
            } else if (key.contains("\uc8fc\uc5f0")) {
                inputProp = prop.get(5);
            } else if (key.contains("\uc2dd\ud488\ub4f1\uc758\ud45c\uc2dc\u00b7\uad11\uace0")) {
                inputProp = prop.get(6);
            } else if (key.contains("\ud3ec\uc7a5\ub2e8\uc704") || key.contains("\ud310\ub9e4\uac1c\uc218")) {
                inputProp = prop.get(7);
            } else if (key.contains("\uc801\uc6a9\ucc28\uc885")) {
                inputProp = prop.get(8);
            } else if (key.contains("\uc2b9\uc778\ubc88\ud638")) {
                inputProp = prop.get(9);
            } else if (key.contains("\ub0c9\ub09c\ubc29\uba74\uc801")) {
                inputProp = prop.get(10);
            } else if (key.contains("\uc800\uc790") || key.contains("\ucd9c\ud310\uc0ac")) {
                inputProp = prop.get(11);
            } else if (key.contains("\uc601\uc720\uc544\uc2dd") || key.contains("\uccb4\uc911\uc870\uc808\uc2dd\ud488")) {
                inputProp = prop.get(12);
            } else if (key.contains("\uc18c\uc7ac") || key.contains("\uc7ac\uc9c8")) {
                inputProp = prop.get(13);
            } else if (key.contains("\uc608\ub9e4 \ucde8\uc18c \uc870\uac74")) {
                inputProp = prop.get(14);
            } else if (key.contains("\ud658\ubd88") || key.contains("\uccad\uc57d\ucca0\ud68c")) {
                inputProp = prop.get(15);
            } else if (key.contains("\uc6a9\ub7c9 \ub610\ub294 \uc911\ub7c9") || key.contains("\uc911\ub7c9 \ub610\ub294 \uc6a9\ub7c9")) {
                inputProp = prop.get(16);
            } else if (key.contains("\uc8fc\uc758\uc0ac\ud56d")) {
                inputProp = prop.get(17);
            } else if (key.contains("\uc12d\ucde8\uc2dc \uc8fc\uc758\uc0ac\ud56d")) {
                inputProp = prop.get(18);
            } else if (key.contains("KC\uc778\uc99d\ud544 \ud56d\ubaa9")) {
                inputProp = prop.get(19);
            } else if (key.contains("\ud654\ud559\ubb3c\uc9c8 \uba85\uce6d")) {
                inputProp = prop.get(20);
            } else if (key.contains("\ubcf4\ud638\ud3ec\uc7a5")) {
                inputProp = prop.get(21);
            } else if (key.contains("\uc0c9\uc0c1")) {
                inputProp = prop.get(22);
            } else if (key.contains("\uc81c\ud488 \uad6c\uc131")) {
                inputProp = prop.get(23);
            } else if (key.contains("\uc81c\ud488 \uad6c\uc131")) {
                inputProp = prop.get(24);
            } else if (key.contains("\ubd80\uc791\uc6a9\ubc1c\uc0dd \uac00\ub2a5\uc131 \uc5ec\ubd80")) {
                inputProp = prop.get(25);
            } else if (key.contains("\uc0c1\ub2f4") || key.contains("\uc608\uc57d\ub2f4\ub2f9")) {
                inputProp = prop.get(26);
            } else if (key.contains("\ubaa9\ucc28 \ub610\ub294 \ucc45\uc18c\uac1c")) {
                inputProp = prop.get(27);
            } else if (key.contains("\uc0c1\ud488\ubcc4 \uc138\ubd80 \uc0ac\uc591")) {
                inputProp = prop.get(28);
            } else if (key.contains("\ud654\uba74\uc0ac\uc591")) {
                inputProp = prop.get(29);
            } else if (key.contains("\uc81c\uc870\uc0ac(\uc218\uc785\uc790/\ubcd1\ud589\uc218\uc785)")) {
                inputProp = prop.get(30);
            } else if (key.equals("\uc6a9\ub3c4")) {
                inputProp = prop.get(31);
            } else if (key.equals("\ud6a8\uacfc")) {
                inputProp = prop.get(32);
            } else if (key.contains("\uc815\uaca9\uc804\uc555") || key.contains("\uc18c\ube44\uc804\ub825") || key.contains("\uc5d0\ub108\uc9c0\uc18c\ube44\ud6a8\uc728")) {
                inputProp = prop.get(33);
            } else if (key.contains("\uc720\ud1b5\uae30\ud55c")) {
                inputProp = prop.get(34);
            } else if (key.contains("\ud488\ubaa9 \ub610\ub294 \uba85\uce6d") || key.contains("\ud488\ubaa9 \ubc0f \uc81c\ud488\uba85")) {
                inputProp = prop.get(35);
            } else if (key.contains("\uc2dd\ud488\uc758 \uc720\ud615")) {
                inputProp = prop.get(36);
            } else if (key.contains("\ubb34\uc0c1\uae30\uac04")) {
                inputProp = prop.get(37);
            } else if (key.contains("GMO") || key.contains("\uc720\uc804\uc790 \uc7ac\uc870\ud569")) {
                inputProp = prop.get(38);
            } else if (key.contains("\uc0b4\uc0dd\ubb3c\ubb3c\uc9c8")) {
                inputProp = prop.get(39);
            } else if (key.contains("\uce58\uc218")) {
                inputProp = prop.get(40);
            } else if (key.contains("\uc2dd\ud488\uc704\uc0dd\ubc95")) {
                inputProp = prop.get(41);
            } else if (key.contains("\uc218\uc785\uc2dd\ud488 \uc5ec\ubd80")) {
                inputProp = prop.get(42);
            } else if (key.contains("\uc218\uc785\uc790")) {
                inputProp = prop.get(43);
            } else if (key.contains("\ud568\ub7c9")) {
                inputProp = prop.get(44);
            } else if (key.contains("\ubc30\uc1a1\uc124\uce58") || key.contains("\ucd94\uac00\uc124\uce58")) {
                inputProp = prop.get(45);
            } else if (key.contains("\ubc1c\ud589\uc790")) {
                inputProp = prop.get(46);
            } else if (key.contains("\ubcf4\uad00\ubc29\ubc95 \ub610\ub294 \ucde8\uae09\ubc29\ubc95")) {
                inputProp = prop.get(47);
            } else if (key.contains("\uc758\ub8cc\uae30\uae30 \ud5c8\uac00")) {
                inputProp = prop.get(48);
            } else if (key.contains("\uc0dd\uc0b0\uc790 \ubc0f \uc18c\uc7ac\uc9c0")) {
                inputProp = prop.get(49);
            } else if (key.contains("\uc8fc\uc694\uc131\ubd84")) {
                inputProp = prop.get(50);
            } else if (key.contains("\uc720\ud574\uc131 \ubc0f \uc704\ud574\uc131")) {
                inputProp = prop.get(51);
            } else if (key.contains("\uc7ac\uc9c8") || key.contains("\uc18c\uc7ac")) {
                inputProp = prop.get(52);
            } else if (key.contains("\uc0c1\ud488 \uc81c\uacf5 \ubc29\uc2dd")) {
                inputProp = prop.get(53);
            } else if (key.contains("\uc9c8\ubcd1\uc608\ubc29")) {
                inputProp = prop.get(54);
            } else if (key.contains("\uc601\uc591\uc131\ubd84") || key.contains("\uc601\uc591\uc815\ubcf4")) {
                inputProp = prop.get(55);
            } else if (key.contains("\uc18c\uc720\uad8c \uc774\uc804 \uc870\uac74")) {
                inputProp = prop.get(56);
            } else if (key.contains("\uc81c\uc870\uc5f0\uc6d4")) {
                inputProp = prop.get(57);
            } else if (key.contains("\ucabd\uc218")) {
                inputProp = prop.get(58);
            } else if (key.contains("\uc18c\ube44\uc790 \ucc45\uc784")) {
                inputProp = prop.get(59);
            } else if (key.equals("\uc720\ud6a8\uae30\uac04")) {
                inputProp = prop.get(60);
            } else if (key.contains("\uc815\uaca9\uc804\uc555") || key.contains("\uc18c\ube44\uc804\ub825") || key.contains("\uc5d0\ub108\uc9c0\uc18c\ube44\ud6a8\uc728")) {
                inputProp = prop.get(61);
            } else if (key.contains("\uc81c\uc870\uad6d")) {
                inputProp = prop.get(62);
            } else if (key.contains("\uc81c\ud488 \uad6c\uc131")) {
                inputProp = prop.get(63);
            } else if (key.contains("\ud488\uba85") || key.contains("\uc81c\ud488\uc720\ud615")) {
                inputProp = prop.get(64);
            } else if (key.contains("\ud488\uc9c8\ubcf4\uc99d\uc11c")) {
                inputProp = prop.get(65);
            } else if (key.contains("\ucd9c\uac04\uc77c")) {
                inputProp = prop.get(66);
            } else if (key.contains("\ucd9c\ud310\uc0ac")) {
                inputProp = prop.get(67);
            } else if (key.contains("\uc21c\ub3c4")) {
                inputProp = prop.get(68);
            } else if (key.contains("\uc0ac\uc6a9\ubaa9\uc801")) {
                inputProp = prop.get(69);
            } else if (key.contains("\uc0ac\uc6a9\ub300\uc0c1\uc790")) {
                inputProp = prop.get(70);
            } else if (key.contains("\uc815\uaca9\uc804\uc555") || key.contains("\uc18c\ube44\uc804\ub825") || key.contains("\uc5d0\ub108\uc9c0\uc18c\ube44\ud6a8\uc728")) {
                inputProp = prop.get(71);
            } else if (key.contains("\uad00\ub78c\ub4f1\uae09")) {
                inputProp = prop.get(72);
            } else if (key.contains("\uc0ac\uc6a9\uc5f0\ub839")) {
                inputProp = prop.get(73);
            } else if (key.contains("\uc794\uc561\ud658\uae09\uc870\uac74")) {
                inputProp = prop.get(74);
            } else if (key.contains("\ud658\ubd88\uae30\uc900")) {
                inputProp = prop.get(75);
            } else if (key.contains("\ub3d9\uc77c\ubaa8\ub378 \ucd9c\uc2dc\ub144\uc6d4")) {
                inputProp = prop.get(76);
            } else if (key.contains("\uad00\ub828\ubc95\uc0c1 \ud45c\uc2dc\uc0ac\ud56d")) {
                inputProp = prop.get(77);
            } else if (key.contains("\ucd5c\uc18c \uc2dc\uc2a4\ud15c \uc0ac\uc591") || key.contains("\ud544\uc218 \uc18c\ud504\ud2b8\uc6e8\uc5b4")) {
                inputProp = prop.get(78);
            } else if (key.contains("\uac80\uc0ac\ud569\uaca9\uc99d \ubc88\ud638")) {
                inputProp = prop.get(79);
            } else if (key.contains("\uc548\uc804\uae30\uc900 \uc801\ud569")) {
                inputProp = prop.get(80);
            } else if (key.contains("\uc11c\ube44\uc2a4 \uc81c\uacf5 \uc0ac\uc5c5\uc790")) {
                inputProp = prop.get(81);
            } else if (key.contains("\uacf5\uc5f0\uc7a5\uc18c")) {
                inputProp = prop.get(82);
            } else if (key.contains("\uacf5\uc5f0\uc2dc\uac04")) {
                inputProp = prop.get(83);
            } else if (key.contains("\uce58\uc218")) {
                inputProp = prop.get(84);
            } else if (key.contains("\uae30\ub2a5\uc815\ubcf4") || key.contains("\uc81c\ud488 \uc8fc\uc694 \uc0ac\uc591")) {
                inputProp = prop.get(85);
            } else if (key.contains("\uc8fc\ucd5c \ub610\ub294 \uae30\ud68d")) {
                inputProp = prop.get(86);
            } else if (key.contains("\uc774\uc6a9\uc870\uac74")) {
                inputProp = prop.get(87);
            } else if (key.contains("\ub3c4\uc11c\uba85")) {
                inputProp = prop.get(88);
            } else if (key.equals("\uc885\ub958")) {
                inputProp = prop.get(89);
            } else if (key.contains("\ub9f5 \uc5c5\ub370\uc774\ud2b8")) {
                inputProp = prop.get(90);
            } else if (key.contains("\uc774\uc6a9\uc870\uac74")) {
                inputProp = prop.get(91);
            } else if (key.contains("\uc774\uc6a9\uac00\ub2a5\ub9e4\uc7a5")) {
                inputProp = prop.get(92);
            } else if (key.contains("\uc0ac\uc6a9\ubc29\ubc95")) {
                inputProp = prop.get(93);
            } else if (key.contains("\uc0ac\uc6a9\uae30\ud55c \ub610\ub294 \uac1c\ubd09 \ud6c4 \uc0ac\uc6a9\uae30\uac04")) {
                inputProp = prop.get(94);
            } else if (key.contains("\uc774\uc6a9\uac00\ub2a5\ub9e4\uc7a5")) {
                inputProp = prop.get(95);
            } else if (key.contains("\ud488\uc9c8\ubcf4\uc99d\uae30\uc900")) {
                inputProp = prop.get(96);
            } else if (key.contains("\uc911\ub7c9") || key.contains("\ud06c\uae30,\ubb34\uac8c")) {
                inputProp = prop.get(97);
            }
            int i = 0;
            while (i < seqList.length) {
                if (seqList[i].equals("1") && inputProp != "") {
                    data2.setProp_val1(inputProp);
                }
                if (seqList[i].equals("2") && inputProp != "") {
                    data2.setProp_val2(inputProp);
                }
                if (seqList[i].equals("3") && inputProp != "") {
                    data2.setProp_val3(inputProp);
                }
                if (seqList[i].equals("4") && inputProp != "") {
                    data2.setProp_val4(inputProp);
                }
                if (seqList[i].equals("5") && inputProp != "") {
                    data2.setProp_val5(inputProp);
                }
                if (seqList[i].equals("6") && inputProp != "") {
                    data2.setProp_val6(inputProp);
                }
                if (seqList[i].equals("7") && inputProp != "") {
                    data2.setProp_val7(inputProp);
                }
                if (seqList[i].equals("8") && inputProp != "") {
                    data2.setProp_val8(inputProp);
                }
                if (seqList[i].equals("9") && inputProp != "") {
                    data2.setProp_val9(inputProp);
                }
                if (seqList[i].equals("10") && inputProp != "") {
                    data2.setProp_val10(inputProp);
                }
                if (seqList[i].equals("11") && inputProp != "") {
                    data2.setProp_val11(inputProp);
                }
                if (seqList[i].equals("12") && inputProp != "") {
                    data2.setProp_val12(inputProp);
                }
                if (seqList[i].equals("13") && inputProp != "") {
                    data2.setProp_val13(inputProp);
                }
                if (seqList[i].equals("14") && inputProp != "") {
                    data2.setProp_val14(inputProp);
                }
                if (seqList[i].equals("15") && inputProp != "") {
                    data2.setProp_val15(inputProp);
                }
                if (seqList[i].equals("16") && inputProp != "") {
                    data2.setProp_val16(inputProp);
                }
                if (seqList[i].equals("17") && inputProp != "") {
                    data2.setProp_val17(inputProp);
                }
                if (seqList[i].equals("18") && inputProp != "") {
                    data2.setProp_val18(inputProp);
                }
                if (seqList[i].equals("19") && inputProp != "") {
                    data2.setProp_val19(inputProp);
                }
                if (seqList[i].equals("20") && inputProp != "") {
                    data2.setProp_val20(inputProp);
                }
                if (seqList[i].equals("21") && inputProp != "") {
                    data2.setProp_val21(inputProp);
                }
                if (seqList[i].equals("22") && inputProp != "") {
                    data2.setProp_val22(inputProp);
                }
                if (seqList[i].equals("23") && inputProp != "") {
                    data2.setProp_val23(inputProp);
                }
                if (seqList[i].equals("24") && inputProp != "") {
                    data2.setProp_val24(inputProp);
                }
                if (seqList[i].equals("25") && inputProp != "") {
                    data2.setProp_val25(inputProp);
                }
                if (seqList[i].equals("26") && inputProp != "") {
                    data2.setProp_val26(inputProp);
                }
                if (seqList[i].equals("27") && inputProp != "") {
                    data2.setProp_val27(inputProp);
                }
                if (seqList[i].equals("28") && inputProp != "") {
                    data2.setProp_val28(inputProp);
                }
                ++i;
            }
        }
    }

    private void saveImages(ProductDTO syncDto, int k, ProductDTO infoDto) {
        switch (k) {
            case 0: {
                infoDto.setImg_path(syncDto.getImg_path());
                break;
            }
            case 1: {
                infoDto.setImg_path1(syncDto.getImg_path1());
                break;
            }
            case 2: {
                infoDto.setImg_path2(syncDto.getImg_path2());
                break;
            }
            case 3: {
                infoDto.setImg_path3(syncDto.getImg_path3());
                break;
            }
            case 4: {
                infoDto.setImg_path4(syncDto.getImg_path4());
                break;
            }
            case 5: {
                infoDto.setImg_path5(syncDto.getImg_path5());
                break;
            }
            case 6: {
                infoDto.setImg_path6(syncDto.getImg_path6());
                break;
            }
            case 7: {
                infoDto.setImg_path7(syncDto.getImg_path7());
                break;
            }
            case 8: {
                infoDto.setImg_path8(syncDto.getImg_path8());
                break;
            }
            case 9: {
                infoDto.setImg_path9(syncDto.getImg_path9());
                break;
            }
            case 10: {
                infoDto.setImg_path10(syncDto.getImg_path10());
                break;
            }
            case 11: {
                infoDto.setImg_path11(syncDto.getImg_path11());
                break;
            }
            case 12: {
                infoDto.setImg_path12(syncDto.getImg_path12());
                break;
            }
            case 13: {
                infoDto.setImg_path13(syncDto.getImg_path13());
                break;
            }
            case 14: {
                infoDto.setImg_path14(syncDto.getImg_path14());
                break;
            }
            case 15: {
                infoDto.setImg_path15(syncDto.getImg_path15());
                break;
            }
            case 16: {
                infoDto.setImg_path16(syncDto.getImg_path16());
                break;
            }
            case 17: {
                infoDto.setImg_path17(syncDto.getImg_path17());
                break;
            }
            case 18: {
                infoDto.setImg_path18(syncDto.getImg_path18());
                break;
            }
            case 19: {
                infoDto.setImg_path19(syncDto.getImg_path19());
                break;
            }
            case 20: {
                infoDto.setImg_path20(syncDto.getImg_path20());
                break;
            }
            case 21: {
                infoDto.setImg_path21(syncDto.getImg_path12());
                break;
            }
            case 22: {
                infoDto.setImg_path22(syncDto.getImg_path22());
                break;
            }
            case 23: {
                infoDto.setImg_path23(syncDto.getImg_path23());
                break;
            }
            case 24: {
                infoDto.setImg_path24(syncDto.getImg_path24());
            }
        }
    }

    private void saveImage(ProductDTO syncDto, int k, String[] image) {
        switch (k) {
            case 0: {
                image[k] = syncDto.getImg_path();
                break;
            }
            case 1: {
                image[k] = syncDto.getImg_path1();
                break;
            }
            case 2: {
                image[k] = syncDto.getImg_path2();
                break;
            }
            case 3: {
                image[k] = syncDto.getImg_path3();
                break;
            }
            case 4: {
                image[k] = syncDto.getImg_path4();
                break;
            }
            case 5: {
                image[k] = syncDto.getImg_path5();
                break;
            }
            case 6: {
                image[k] = syncDto.getImg_path6();
                break;
            }
            case 7: {
                image[k] = syncDto.getImg_path7();
                break;
            }
            case 8: {
                image[k] = syncDto.getImg_path8();
                break;
            }
            case 9: {
                image[k] = syncDto.getImg_path9();
                break;
            }
            case 10: {
                image[k] = syncDto.getImg_path10();
                break;
            }
            case 11: {
                image[k] = syncDto.getImg_path11();
                break;
            }
            case 12: {
                image[k] = syncDto.getImg_path12();
                break;
            }
            case 13: {
                image[k] = syncDto.getImg_path13();
                break;
            }
            case 14: {
                image[k] = syncDto.getImg_path14();
                break;
            }
            case 15: {
                image[k] = syncDto.getImg_path15();
                break;
            }
            case 16: {
                image[k] = syncDto.getImg_path16();
                break;
            }
            case 17: {
                image[k] = syncDto.getImg_path17();
                break;
            }
            case 18: {
                image[k] = syncDto.getImg_path18();
                break;
            }
            case 19: {
                image[k] = syncDto.getImg_path19();
                break;
            }
            case 20: {
                image[k] = syncDto.getImg_path20();
                break;
            }
            case 21: {
                image[k] = syncDto.getImg_path21();
                break;
            }
            case 22: {
                image[k] = syncDto.getImg_path22();
                break;
            }
            case 23: {
                image[k] = syncDto.getImg_path23();
                break;
            }
            case 24: {
                image[k] = syncDto.getImg_path24();
            }
        }
    }

    private String setStatus(String code) {
        String result = "";
        switch (code) {
            case "NEW": {
                result = "0";
                break;
            }
            case "OLD": {
                result = "1";
            }
        }
        return result;
    }

    private String getApioption(JsonObject datas, int price2) throws Exception {
        Object result = "";
        JsonArray options = (JsonArray)datas.get("options");
        JsonArray optionCombinations = (JsonArray)datas.get("optionCombinations");
        String groupName = options.get(0).getAsJsonObject().get("groupName").getAsString();
        try {
            if (optionCombinations.size() > 0) {
                if (options.size() == 1) {
                    result = "[" + groupName + "]\n";
                    int i = 0;
                    while (i < optionCombinations.size()) {
                        result = (String)result + optionCombinations.get(i).getAsJsonObject().get("optionName1").getAsString() + "==" + String.valueOf(optionCombinations.get(i).getAsJsonObject().get("price").getAsInt() + price2) + "=0=0=" + (String.valueOf(optionCombinations.get(i).getAsJsonObject().get("stockQuantity").getAsInt()).equals("0") ? "1" : "0") + "\n";
                        ++i;
                    }
                } else if (options.size() == 2) {
                    result = "[" + groupName + "=" + options.get(1).getAsJsonObject().get("groupName").getAsString() + "]\n";
                    int i = 0;
                    while (i < optionCombinations.size()) {
                        JsonObject obj = optionCombinations.get(i).getAsJsonObject();
                        result = (String)result + obj.getAsJsonObject().get("optionName1").getAsString() + "=" + (obj.has("optionName2") ? obj.get("optionName2").getAsString() : "") + "=" + String.valueOf(obj.getAsJsonObject().get("price").getAsInt() + price2) + "=0=0=" + (String.valueOf(obj.getAsJsonObject().get("stockQuantity").getAsInt()).equals("0") ? "1" : "0") + "\n";
                        ++i;
                    }
                } else if (options.size() == 3) {
                    result = "[" + groupName.concat("=").concat(options.get(1).getAsJsonObject().get("groupName").getAsString()).concat("=").concat(options.get(2).getAsJsonObject().get("groupName").getAsString()).concat("]\n");
                    int i = 0;
                    while (i < optionCombinations.size()) {
                        JsonObject obj = optionCombinations.get(i).getAsJsonObject();
                        result = (String)result + obj.getAsJsonObject().get("optionName1").getAsString().concat("=").concat(obj.has("optionName2") ? obj.get("optionName2").getAsString() : "").concat("=").concat(obj.has("optionName3") ? obj.get("optionName3").getAsString() : "").concat("=").concat(String.valueOf(obj.getAsJsonObject().get("price").getAsInt() + price2)).concat("=0=0=").concat(String.valueOf(obj.getAsJsonObject().get("stockQuantity").getAsInt()).equals("0") ? "1" : "0").concat("\n");
                        ++i;
                    }
                }
            } else {
                List<Object> optionTitle = new ArrayList<String>();
                ArrayList<String> optionValue = new ArrayList<String>();
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                int cnt = 1;
                YDMAStringUtil.Print();
                int i = 0;
                while (i < options.size()) {
                    optionTitle.add(options.get(i).getAsJsonObject().get("groupName").getAsString());
                    optionValue.add(options.get(i).getAsJsonObject().get("name").getAsString());
                    if (i > 0 && ((String)optionTitle.get(i)).equals(optionTitle.get(i - 1))) {
                        map.put((String)optionTitle.get(i), ++cnt);
                    } else {
                        cnt = 1;
                    }
                    ++i;
                }
                int firstOption = (Integer)map.get((optionTitle = optionTitle.stream().distinct().collect(Collectors.toList())).get(0));
                if (firstOption < options.size()) {
                    result = "[" + (String)optionTitle.get(0) + "=" + (String)optionTitle.get(1) + "]\n";
                    int i2 = 0;
                    while (i2 < firstOption) {
                        int j = firstOption;
                        while (j < options.size()) {
                            result = (String)result + (String)optionValue.get(i2) + "=" + (String)optionValue.get(j) + "=" + price2 + "=0=0=0\n";
                            ++j;
                        }
                        ++i2;
                    }
                } else if (firstOption == options.size()) {
                    result = "[" + groupName + "]\n";
                    int i3 = 0;
                    while (i3 < options.size()) {
                        result = (String)result + (String)optionValue.get(i3) + "==" + price2 + "=0=0=0\n";
                        ++i3;
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("\uc635\uc158 \uc77d\ub294 \uc911 \uc624\ub958 \ubc1c\uc0dd.");
        }
        return result;
    }

    private String getGosiInfo(String noticetype) {
        switch (noticetype) {
            case "IMAGE_APPLIANCES": {
                return "\uc601\uc0c1\uac00\uc804(TV\ub958)";
            }
            case "HOME_APPLIANCES": {
                return "\uac00\uc815\uc6a9\uc804\uae30\uc81c\ud488(\ub0c9\uc7a5\uace0/\uc138\ud0c1\uae30/\uc2dd\uae30\uc138\ucc99\uae30/\uc804\uc790";
            }
            case "SEASON_APPLIANCES": {
                return "\uacc4\uc808\uac00\uc804(\uc5d0\uc5b4\ucee8/\uc628\ud48d\uae30)";
            }
            case "OFFICE_APPLIANCES": {
                return "\uc0ac\ubb34\uc6a9\uae30\uae30(\ucef4\ud4e8\ud130/\ub178\ud2b8\ubd81/\ud504\ub9b0\ud130)";
            }
            case "OPTICS_APPLIANCES": {
                return "\uad11\ud559\uae30\uae30(\ub514\uc9c0\ud138\uce74\uba54\ub77c/\ucea0\ucf54\ub354)";
            }
            case "MICROELECTRONICS": {
                return "\uc18c\ud615\uc804\uc790(MP3/\uc804\uc790\uc0ac\uc804 \ub4f1)";
            }
            case "NAVIGATION": {
                return "\ub0b4\ube44\uac8c\uc774\uc158";
            }
            case "CAR_ARTICLES": {
                return "\uc790\ub3d9\ucc28\uc6a9\ud488 (\uc790\ub3d9\ucc28\ubd80\ud488 / \uae30\ud0c0 \uc790\ub3d9\ucc28\uc6a9\ud488)";
            }
            case "MOBILE_COUPON": {
                return "\ubaa8\ubc14\uc77c\ucfe0\ud3f0";
            }
            case "WEAR": {
                return "\uc758\ub958";
            }
            case "SHOES": {
                return "\uad6c\ub450/\uc2e0\ubc1c";
            }
            case "BAG": {
                return "\uac00\ubc29";
            }
            case "FASHION_ITEMS": {
                return "\ud328\uc158\uc7a1\ud654(\ubaa8\uc790/\ubca8\ud2b8/\uc561\uc138\uc11c\ub9ac)";
            }
            case "SLEEPING_GEAR": {
                return "\uce68\uad6c\ub958/\ucee4\ud2bc";
            }
            case "FURNITURE": {
                return "\uac00\uad6c(\uce68\ub300/\uc18c\ud30c/\uc2f1\ud06c\ub300/DIY\uc81c\ud488";
            }
            case "COSMETIC": {
                return "\ud654\uc7a5\ud488";
            }
            case "FOOD": {
                return "\uc2dd\ud488(\ub18d\uc218\uc0b0\ubb3c)";
            }
            case "GENERAL_FOOD": {
                return "\uac00\uacf5\uc2dd\ud488";
            }
            case "DIET_FOOD": {
                return "\uac74\uac15\uae30\ub2a5\uc2dd\ud488";
            }
            case "KIDS": {
                return "\uc601\uc720\uc544\uc6a9\ud488";
            }
            case "SPORTS_EQUIPMENT": {
                return "\uc2a4\ud3ec\uce20\uc6a9\ud488";
            }
            case "BOOKS": {
                return "\uc11c\uc801";
            }
            case "DIGITAL_CONTENTS": {
                return "\ub514\uc9c0\ud138 \ucf58\ud150\uce20(\uc74c\uc6d0/\uac8c\uc784/\uc778\ud130\ub137 \uac15\uc758 \ub4f1)";
            }
            case "BIOCHEMISTRY": {
                return "\uae30\ud0c0";
            }
            case "BIOCIDAL": {
                return "\uae30\ud0c0";
            }
        }
        return "\uae30\ud0c0";
    }

    private void getApiImages(ProductDTO syncDto, int k, String image) {
        switch (k) {
            case 0: {
                syncDto.setImg_path(image);
                break;
            }
            case 1: {
                syncDto.setImg_path1(image);
                break;
            }
            case 2: {
                syncDto.setImg_path2(image);
                break;
            }
            case 3: {
                syncDto.setImg_path3(image);
                break;
            }
            case 4: {
                syncDto.setImg_path4(image);
                break;
            }
            case 5: {
                syncDto.setImg_path5(image);
                break;
            }
            case 6: {
                syncDto.setImg_path6(image);
                break;
            }
            case 7: {
                syncDto.setImg_path7(image);
                break;
            }
            case 8: {
                syncDto.setImg_path8(image);
                break;
            }
            case 9: {
                syncDto.setImg_path9(image);
                break;
            }
            case 10: {
                syncDto.setImg_path10(image);
            }
        }
    }

    private String getTax(String status2) {
        String value = "";
        switch (status2) {
            case "TAX": {
                value = "0";
                break;
            }
            case "DUTYFREE": {
                value = "1";
            }
        }
        return value;
    }

    private String getDeliveryType(String status2) {
        String value = "";
        switch (status2) {
            case "FREE": {
                value = "0";
                break;
            }
            case "PAID": {
                value = "1";
                break;
            }
            case "UNIT_QUANTITY_PAID": {
                value = "3";
                break;
            }
            case "RANGE_QUANTITY_PAID": {
                value = "3";
                break;
            }
            case "CONDITIONAL_FREE": {
                value = "0";
                break;
            }
        }
        return value;
    }

    private String getStatusCd(String saleStatusCd) {
        String value = "";
        switch (saleStatusCd) {
            case "WAIT": {
                value = String.valueOf(9000);
                break;
            }
            case "SALE": {
                value = String.valueOf(8000);
                break;
            }
            case "OUTOFSTOCK": {
                value = String.valueOf(4000);
                break;
            }
            case "UNADMISSION": {
                value = String.valueOf(9000);
                break;
            }
            case "REJECTION": {
                value = String.valueOf(9000);
                break;
            }
            case "SUSPENSION": {
                value = String.valueOf(3000);
                break;
            }
            case "CLOSE": {
                value = String.valueOf(3000);
                break;
            }
            case "PROHIBITION": {
                value = String.valueOf(3000);
            }
        }
        return value;
    }

    public List<String> getProvidedNotice_eng(JsonObject ProvidedNotice) {
        ArrayList<String> prop = new ArrayList<String>();
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("itemName")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("modelName")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("certificateDetails")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("manufacturer")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("afterServiceDirector")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("actor")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("adCaution")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("amount")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("applyModel")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("approvalNumber")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("area")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("author")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("babyFoodOrDietFoodAdDeliberation")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("bandMaterial")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("cancelationCondition")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("cancelationPolicy")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("capacity")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("caution")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("cautionAndSideEffect")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("certificationType")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("chemicals")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("childProtection")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("color")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("component")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("components")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("consumerSafetyCaution")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("customerServicePhoneNumber")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("description")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("detailContent")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("displaySpecification")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("distributor")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("dosageForm")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("effect")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("energyEfficiencyRating")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("expirationDateText")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("foodItem")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("foodType")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("freeCostPeriod")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("geneticallyModified")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("harmfulChemicalSubstance")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("height")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("importDeclaration")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("importDeclarationCheck")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("importer")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("ingredients")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("installedCharge")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("issuer")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("keep")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("licenceNo")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("location")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("mainIngredient")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("maleficence")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("material")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("medium")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("nonMedicinalUsesMessage")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("nutritionFacts")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("ownershipTransferCondition")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("packDateText")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("pages")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("payingForLossOrDamage")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("periodDays")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("powerConsumption")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("producer")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("productComposition")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("productName")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("provideWarranty")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("publishDateText")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("publisher")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("purity")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("purpose")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("rangeOfUse")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("ratedVoltage")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("rating")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("recommendedAge")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("refundPolicy")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("refundPolicyForCancel")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("releaseDateText")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("relevantLawContent")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("requirement")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("roadWorthyCertification")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("safeCriterionNo")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("serviceProvider")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("showPlace")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("showTime")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("size")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("specification")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("sponsor")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("termsOfUse")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("title")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("type")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("updateCost")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("usableCondition")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("usableStore")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("usage")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("usePeriod")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("useStorePlace")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("warrantyPolicy")));
        prop.add(ShopCommon.jsonElementNullStr(ProvidedNotice.get("weight")));
        return prop;
    }

    public void getProvidedNotice_kor(JsonObject ProvidedNotice, ProductDTO data2) throws Exception {
        ArrayList<String> prop = new ArrayList<String>(100);
        int i = 0;
        while (i < 100) {
            prop.add(i, "");
            ++i;
        }
        data2.setProp1_cd("035");
        Set entrySet = ProvidedNotice.entrySet();
        for (Map.Entry entry : entrySet) {
            String key1 = (String)entry.getKey();
            if (((JsonElement)entry.getValue()).isJsonObject()) {
                data2.setProp1_cd("021");
                Set entrySet2 = ((JsonElement)entry.getValue()).getAsJsonObject().entrySet();
                for (Map.Entry entry2 : entrySet2) {
                    String key21 = (String)entry2.getKey();
                    String val21 = ((JsonElement)entry2.getValue()).getAsString();
                    prop.set(this.getProvidedNotice_kor_detail(key21), val21);
                }
                continue;
            }
            String val1 = ((JsonElement)entry.getValue()).getAsString();
            prop.set(this.getProvidedNotice_kor_detail(key1), val1);
        }
        ArrayList<String> proShop = new ArrayList<String>(100);
        int i2 = 0;
        while (i2 < 100) {
            if (!((String)prop.get(i2)).equals("")) {
                proShop.add(String.valueOf(i2 + 1));
            }
            ++i2;
        }
        Map<String, Map<String, String>> propMapping = null;
        try {
            propMapping = ShopProductDao.get().setNaverNotice2();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int cntwin = 0;
        String findwin = "";
        for (Map.Entry entry : propMapping.entrySet()) {
            String key = ((String)entry.getKey()).toString();
            int cnt = 0;
            Set entrypPop2 = ((Map)entry.getValue()).entrySet();
            for (Map.Entry popList : entrypPop2) {
                String[] seqList = ((String)popList.getValue()).toString().split(",");
                int i3 = 0;
                while (i3 < seqList.length) {
                    int j = 0;
                    while (j < proShop.size()) {
                        if (seqList[i3].equals(proShop.get(j))) {
                            ++cnt;
                        }
                        ++j;
                    }
                    ++i3;
                }
            }
            if (cnt <= cntwin) continue;
            cntwin = cnt;
            findwin = key;
        }
        if (cntwin > 3) {
            data2.setProp1_cd(findwin);
        }
        this.setProp(data2.getProp1_cd(), prop, data2);
    }

    public int getProvidedNotice_kor_detail(String key) {
        int idx = 0;
        if (key.contains("\ud488\uba85")) {
            idx = 0;
        } else if (key.contains("\ubaa8\ub378\uba85")) {
            idx = 1;
        } else if (key.contains("\uc778\uc99d \ud5c8\uac00")) {
            idx = 2;
        } else if (key.contains("\uc81c\uc870\uc790") || key.contains("\uc0dd\uc0b0\uc790")) {
            idx = 3;
        } else if (key.contains("A/S \ucc45\uc784\uc790")) {
            idx = 4;
        } else if (key.contains("\uc8fc\uc5f0")) {
            idx = 5;
        } else if (key.contains("\uc2dd\ud488\ub4f1\uc758\ud45c\uc2dc\u00b7\uad11\uace0")) {
            idx = 6;
        } else if (key.contains("\ud3ec\uc7a5\ub2e8\uc704") || key.contains("\ud310\ub9e4\uac1c\uc218")) {
            idx = 7;
        } else if (key.contains("\uc801\uc6a9\ucc28\uc885")) {
            idx = 8;
        } else if (key.contains("\uc2b9\uc778\ubc88\ud638")) {
            idx = 9;
        } else if (key.contains("\ub0c9\ub09c\ubc29\uba74\uc801")) {
            idx = 10;
        } else if (key.contains("\uc800\uc790") || key.contains("\ucd9c\ud310\uc0ac")) {
            idx = 11;
        } else if (key.contains("\uc601\uc720\uc544\uc2dd") || key.contains("\uccb4\uc911\uc870\uc808\uc2dd\ud488")) {
            idx = 12;
        } else if (key.contains("\uc18c\uc7ac") || key.contains("\uc7ac\uc9c8")) {
            idx = 13;
        } else if (key.contains("\uc608\ub9e4 \ucde8\uc18c \uc870\uac74")) {
            idx = 14;
        } else if (key.contains("\ud658\ubd88") || key.contains("\uccad\uc57d\ucca0\ud68c")) {
            idx = 15;
        } else if (key.contains("\uc6a9\ub7c9 \ub610\ub294 \uc911\ub7c9") || key.contains("\uc911\ub7c9 \ub610\ub294 \uc6a9\ub7c9")) {
            idx = 16;
        } else if (key.contains("\uc8fc\uc758\uc0ac\ud56d")) {
            idx = 17;
        } else if (key.contains("\uc12d\ucde8\uc2dc \uc8fc\uc758\uc0ac\ud56d")) {
            idx = 18;
        } else if (key.contains("KC\uc778\uc99d\ud544 \ud56d\ubaa9")) {
            idx = 19;
        } else if (key.contains("\ud654\ud559\ubb3c\uc9c8 \uba85\uce6d")) {
            idx = 20;
        } else if (key.contains("\ubcf4\ud638\ud3ec\uc7a5")) {
            idx = 21;
        } else if (key.contains("\uc0c9\uc0c1")) {
            idx = 22;
        } else if (key.contains("\uc81c\ud488 \uad6c\uc131")) {
            idx = 23;
        } else if (key.contains("\uc81c\ud488 \uad6c\uc131")) {
            idx = 24;
        } else if (key.contains("\ubd80\uc791\uc6a9\ubc1c\uc0dd \uac00\ub2a5\uc131 \uc5ec\ubd80")) {
            idx = 25;
        } else if (key.contains("\uc0c1\ub2f4") || key.contains("\uc608\uc57d\ub2f4\ub2f9")) {
            idx = 26;
        } else if (key.contains("\ubaa9\ucc28 \ub610\ub294 \ucc45\uc18c\uac1c")) {
            idx = 27;
        } else if (key.contains("\uc0c1\ud488\ubcc4 \uc138\ubd80 \uc0ac\uc591")) {
            idx = 28;
        } else if (key.contains("\ud654\uba74\uc0ac\uc591")) {
            idx = 29;
        } else if (key.contains("\uc81c\uc870\uc0ac(\uc218\uc785\uc790/\ubcd1\ud589\uc218\uc785)")) {
            idx = 30;
        } else if (key.equals("\uc6a9\ub3c4")) {
            idx = 31;
        } else if (key.equals("\ud6a8\uacfc")) {
            idx = 32;
        } else if (key.contains("\uc815\uaca9\uc804\uc555") || key.contains("\uc18c\ube44\uc804\ub825") || key.contains("\uc5d0\ub108\uc9c0\uc18c\ube44\ud6a8\uc728")) {
            idx = 33;
        } else if (key.contains("\uc720\ud1b5\uae30\ud55c")) {
            idx = 34;
        } else if (key.contains("\ud488\ubaa9 \ub610\ub294 \uba85\uce6d") || key.contains("\ud488\ubaa9 \ubc0f \uc81c\ud488\uba85")) {
            idx = 35;
        } else if (key.contains("\uc2dd\ud488\uc758 \uc720\ud615")) {
            idx = 36;
        } else if (key.contains("\ubb34\uc0c1\uae30\uac04")) {
            idx = 37;
        } else if (key.contains("GMO") || key.contains("\uc720\uc804\uc790 \uc7ac\uc870\ud569")) {
            idx = 38;
        } else if (key.contains("\uc0b4\uc0dd\ubb3c\ubb3c\uc9c8")) {
            idx = 39;
        } else if (key.contains("\uce58\uc218")) {
            idx = 40;
        } else if (key.contains("\uc2dd\ud488\uc704\uc0dd\ubc95")) {
            idx = 41;
        } else if (key.contains("\uc218\uc785\uc2dd\ud488 \uc5ec\ubd80")) {
            idx = 42;
        } else if (key.contains("\uc218\uc785\uc790")) {
            idx = 43;
        } else if (key.contains("\ud568\ub7c9")) {
            idx = 44;
        } else if (key.contains("\ubc30\uc1a1\uc124\uce58") || key.contains("\ucd94\uac00\uc124\uce58")) {
            idx = 45;
        } else if (key.contains("\ubc1c\ud589\uc790")) {
            idx = 46;
        } else if (key.contains("\ubcf4\uad00\ubc29\ubc95 \ub610\ub294 \ucde8\uae09\ubc29\ubc95")) {
            idx = 47;
        } else if (key.contains("\uc758\ub8cc\uae30\uae30 \ud5c8\uac00")) {
            idx = 48;
        } else if (key.contains("\uc0dd\uc0b0\uc790 \ubc0f \uc18c\uc7ac\uc9c0")) {
            idx = 49;
        } else if (key.contains("\uc8fc\uc694\uc131\ubd84")) {
            idx = 50;
        } else if (key.contains("\uc720\ud574\uc131 \ubc0f \uc704\ud574\uc131")) {
            idx = 51;
        } else if (key.contains("\uc7ac\uc9c8") || key.contains("\uc18c\uc7ac")) {
            idx = 52;
        } else if (key.contains("\uc0c1\ud488 \uc81c\uacf5 \ubc29\uc2dd")) {
            idx = 53;
        } else if (key.contains("\uc9c8\ubcd1\uc608\ubc29")) {
            idx = 54;
        } else if (key.contains("\uc601\uc591\uc131\ubd84") || key.contains("\uc601\uc591\uc815\ubcf4")) {
            idx = 55;
        } else if (key.contains("\uc18c\uc720\uad8c \uc774\uc804 \uc870\uac74")) {
            idx = 56;
        } else if (key.contains("\uc81c\uc870\uc5f0\uc6d4")) {
            idx = 57;
        } else if (key.contains("\ucabd\uc218")) {
            idx = 58;
        } else if (key.contains("\uc18c\ube44\uc790 \ucc45\uc784")) {
            idx = 59;
        } else if (key.equals("\uc720\ud6a8\uae30\uac04")) {
            idx = 60;
        } else if (key.contains("\uc815\uaca9\uc804\uc555") || key.contains("\uc18c\ube44\uc804\ub825") || key.contains("\uc5d0\ub108\uc9c0\uc18c\ube44\ud6a8\uc728")) {
            idx = 61;
        } else if (key.contains("\uc81c\uc870\uad6d")) {
            idx = 62;
        } else if (key.contains("\uc81c\ud488 \uad6c\uc131")) {
            idx = 63;
        } else if (key.contains("\ud488\uba85") || key.contains("\uc81c\ud488\uc720\ud615")) {
            idx = 64;
        } else if (key.contains("\ud488\uc9c8\ubcf4\uc99d\uc11c")) {
            idx = 65;
        } else if (key.contains("\ucd9c\uac04\uc77c")) {
            idx = 66;
        } else if (key.contains("\ucd9c\ud310\uc0ac")) {
            idx = 67;
        } else if (key.contains("\uc21c\ub3c4")) {
            idx = 68;
        } else if (key.contains("\uc0ac\uc6a9\ubaa9\uc801")) {
            idx = 69;
        } else if (key.contains("\uc0ac\uc6a9\ub300\uc0c1\uc790")) {
            idx = 70;
        } else if (key.contains("\uc815\uaca9\uc804\uc555") || key.contains("\uc18c\ube44\uc804\ub825") || key.contains("\uc5d0\ub108\uc9c0\uc18c\ube44\ud6a8\uc728")) {
            idx = 71;
        } else if (key.contains("\uad00\ub78c\ub4f1\uae09")) {
            idx = 72;
        } else if (key.contains("\uc0ac\uc6a9\uc5f0\ub839")) {
            idx = 73;
        } else if (key.contains("\uc794\uc561\ud658\uae09\uc870\uac74")) {
            idx = 74;
        } else if (key.contains("\ud658\ubd88\uae30\uc900")) {
            idx = 75;
        } else if (key.contains("\ub3d9\uc77c\ubaa8\ub378 \ucd9c\uc2dc\ub144\uc6d4")) {
            idx = 76;
        } else if (key.contains("\uad00\ub828\ubc95\uc0c1 \ud45c\uc2dc\uc0ac\ud56d")) {
            idx = 77;
        } else if (key.contains("\ucd5c\uc18c \uc2dc\uc2a4\ud15c \uc0ac\uc591") || key.contains("\ud544\uc218 \uc18c\ud504\ud2b8\uc6e8\uc5b4")) {
            idx = 78;
        } else if (key.contains("\uac80\uc0ac\ud569\uaca9\uc99d \ubc88\ud638")) {
            idx = 79;
        } else if (key.contains("\uc548\uc804\uae30\uc900 \uc801\ud569")) {
            idx = 80;
        } else if (key.contains("\uc11c\ube44\uc2a4 \uc81c\uacf5 \uc0ac\uc5c5\uc790")) {
            idx = 81;
        } else if (key.contains("\uacf5\uc5f0\uc7a5\uc18c")) {
            idx = 82;
        } else if (key.contains("\uacf5\uc5f0\uc2dc\uac04")) {
            idx = 83;
        } else if (key.contains("\uce58\uc218")) {
            idx = 84;
        } else if (key.contains("\uae30\ub2a5\uc815\ubcf4") || key.contains("\uc81c\ud488 \uc8fc\uc694 \uc0ac\uc591")) {
            idx = 85;
        } else if (key.contains("\uc8fc\ucd5c \ub610\ub294 \uae30\ud68d")) {
            idx = 86;
        } else if (key.contains("\uc774\uc6a9\uc870\uac74")) {
            idx = 87;
        } else if (key.contains("\ub3c4\uc11c\uba85")) {
            idx = 88;
        } else if (key.equals("\uc885\ub958")) {
            idx = 89;
        } else if (key.contains("\ub9f5 \uc5c5\ub370\uc774\ud2b8")) {
            idx = 90;
        } else if (key.contains("\uc774\uc6a9\uc870\uac74")) {
            idx = 91;
        } else if (key.contains("\uc774\uc6a9\uac00\ub2a5\ub9e4\uc7a5")) {
            idx = 92;
        } else if (key.contains("\uc0ac\uc6a9\ubc29\ubc95")) {
            idx = 93;
        } else if (key.contains("\uc0ac\uc6a9\uae30\ud55c \ub610\ub294 \uac1c\ubd09 \ud6c4 \uc0ac\uc6a9\uae30\uac04")) {
            idx = 94;
        } else if (key.contains("\uc774\uc6a9\uac00\ub2a5\ub9e4\uc7a5")) {
            idx = 95;
        } else if (key.contains("\ud488\uc9c8\ubcf4\uc99d\uae30\uc900")) {
            idx = 96;
        } else if (key.contains("\uc911\ub7c9") || key.contains("\ud06c\uae30,\ubb34\uac8c")) {
            idx = 97;
        }
        return idx;
    }
}

