/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.shop.job;

import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.shop.dao.ScheduleInfoDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopOrderMstDto;
import java.util.List;
import java.util.Properties;
import org.quartz.CronScheduleBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.simpl.SimpleThreadPool;

public class JobContext {
    private static JobContext instance = new JobContext();
    StdSchedulerFactory schedulerFactory = null;
    Scheduler scheduler = null;
    String name;
    String group;
    ScheduleInfoDto dto;
    List<ShopOrderMstDto> list;

    public static JobContext get() {
        try {
            instance.initDetectionScheduler();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            YDMAStringUtil.Print();
            JobContext.instance.scheduler = JobContext.instance.schedulerFactory.getScheduler();
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
        return instance;
    }

    private void initDetectionScheduler() throws Exception {
        this.schedulerFactory = new StdSchedulerFactory();
        Properties mergedProps = new Properties();
        mergedProps.setProperty("org.quartz.threadPool.class", SimpleThreadPool.class.getName());
        mergedProps.setProperty("org.quartz.scheduler.makeSchedulerThreadDaemon", "true");
        mergedProps.setProperty("org.quartz.scheduler.instanceName", "UfloClusterHeartbeatScheduler");
        mergedProps.setProperty("org.quartz.scheduler.instanceId", "UfloHeartbeatDetectionScheduler");
        mergedProps.setProperty("org.quartz.threadPool.threadCount", "10");
        this.schedulerFactory.initialize(mergedProps);
        this.scheduler = this.schedulerFactory.getScheduler();
    }

    private JobContext() {
    }

    public JobContext addJobNamGroup(String name, String group, ScheduleInfoDto dto, List<ShopOrderMstDto> list) {
        this.name = name;
        this.group = group;
        this.dto = dto;
        this.list = list;
        return this;
    }

    public JobContext addJob(Class<? extends Job> jobClass, String cronExpression) throws SchedulerException {
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put(this.name, (Object)this.dto);
        jobDataMap.put("SHOP", this.list);
        JobDetail jobDetail = JobBuilder.newJob(jobClass).usingJobData(jobDataMap).build();
        YDMAStringUtil.Print("\ud2b8\ub9ac\uac70\uc2dc\uc791\uc804 \uc2dc\uc791");
        Trigger trigger = TriggerBuilder.newTrigger().forJob(jobDetail).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression)).build();
        this.scheduler.scheduleJob(jobDetail, trigger);
        return this;
    }

    public void start() throws SchedulerException {
        this.scheduler.start();
    }

    public void stop() throws SchedulerException {
        this.scheduler.shutdown();
    }
}

