/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.util;

import com.coupang.openapi.sdk.Hmac;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.yellim.code.MallCode;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.common.YDMATimeUtil;
import com.kdjsystem.mlink.yellim.controls.ComboItem;
import com.kdjsystem.mlink.yellim.dao.DomemallDAO;
import com.kdjsystem.mlink.yellim.dao.ProductDAO;
import com.kdjsystem.mlink.yellim.dao.ProductOperatingDAO;
import com.kdjsystem.mlink.yellim.dao.ShoppingmallDAO;
import com.kdjsystem.mlink.yellim.dto.DomemallDTO;
import com.kdjsystem.mlink.yellim.dto.ProductDTO;
import com.kdjsystem.mlink.yellim.dto.ProductDiscontinueOptionDTO;
import com.kdjsystem.mlink.yellim.dto.ProductFolderDTO;
import com.kdjsystem.mlink.yellim.dto.ProductOptionDTO;
import com.kdjsystem.mlink.yellim.dto.ResultSearchDTO;
import com.kdjsystem.mlink.yellim.dto.ShoppingmallDTO;
import com.kdjsystem.mlink.yellim.helper.JsonHelper;
import com.kdjsystem.mlink.yellim.helper.LoginHelper;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class ProductDiscontinueUtil {
    public List<ComboItem> getDomemallComboItems() {
        ArrayList<ComboItem> result = new ArrayList<ComboItem>();
        try {
            List<DomemallDTO> infos = DomemallDAO.get().selectDomemallQuickInfo();
            for (DomemallDTO info : infos) {
                ComboItem item = new ComboItem();
                item.setName(info.getNICKNM1().equals("") ? info.getSHOPNM() : info.getSHOPNM().concat("_").concat(info.getNICKNM1()));
                item.setCode(info.getSHOPCD());
                item.setDOMEINFO(info);
                result.add(item);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        return result;
    }

    public List<ProductDTO> getGridItems(ProductDiscontinueOptionDTO dto, String commandID, String shopCode, String shopSeq, boolean next) {
        List<ProductDTO> result = null;
        List<Object> options = new ArrayList();
        try {
            switch (commandID) {
                case "A": {
                    result = ProductDAO.get().getDiscontinueProductInfo(dto);
                    List<String> prodseqs = result.stream().map(p -> p.getPRODSEQ()).collect(Collectors.toList());
                    options = ProductDAO.get().selectAllOptProductInfoByProdSeq(prodseqs);
                    int i = 0;
                    while (i < result.size()) {
                        result.get(i).setRowno(String.valueOf(i + 1));
                        String prodseq = result.get(i).getPRODSEQ();
                        List<ProductOptionDTO> option2 = options.stream().filter(p -> p.getPRODSEQ() == Integer.parseInt(prodseq)).collect(Collectors.toList());
                        int j = 0;
                        while (j < option2.size()) {
                            ((ProductOptionDTO)option2.get(j)).setROWNO(j + 1);
                            option2.get(j).setSHOPPRODSKU_NM(result.get(i).getGoods_nm());
                            ++j;
                        }
                        result.get(i).setOPTIONS(option2);
                        ++i;
                    }
                    break;
                }
                case "S": 
                case "U": {
                    result = ProductDAO.get().getDiscontinueProductsIn(dto, commandID, shopCode, shopSeq, next);
                    List<String> sendseqs = result.stream().map(p -> p.getSENDSEQ()).collect(Collectors.toList());
                    options = ProductDAO.get().selectAllOptProductInBySendSeq(sendseqs);
                    int i = 0;
                    while (i < result.size()) {
                        result.get(i).setRowno(String.valueOf(i + 1));
                        String sendseq = result.get(i).getSENDSEQ();
                        List<ProductOptionDTO> option3 = options.stream().filter(p -> p.getSENDSEQ() == Integer.parseInt(sendseq)).collect(Collectors.toList());
                        int j = 0;
                        while (j < option3.size()) {
                            ((ProductOptionDTO)option3.get(j)).setROWNO(j + 1);
                            option3.get(j).setSHOPCD(result.get(0).getShopcd());
                            option3.get(j).setSHOPPINGID(result.get(0).getSHOP_USERID());
                            ++j;
                        }
                        result.get(i).setOPTIONS(option3);
                        ++i;
                    }
                    break block6;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        return result;
    }

    public ResultSearchDTO getProductTotalPage(ProductDiscontinueOptionDTO dto, String commandID, String shopCode, String shopSeq) throws Exception {
        ResultSearchDTO result = new ResultSearchDTO();
        int cnt = 0;
        try {
            switch (commandID) {
                case "A": {
                    cnt = ProductDAO.get().getDiscontinueProductInfoAllCount(dto);
                    break;
                }
                case "S": 
                case "U": {
                    cnt = ProductDAO.get().getDiscontinueProductInAllCount(dto, commandID, shopCode, shopSeq);
                }
            }
            int block = dto.getSearchBlock();
            int pages = cnt / block;
            int remain = cnt % block;
            result.setTOTAL_CNT(cnt);
            result.setTOTAL_PAGE(pages + (remain > 0 ? 1 : 0));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public List<ProductDTO> getShoppingMallTreeItems(ProductDiscontinueOptionDTO dto) {
        try {
            if (dto.getStartDate().equals("") && dto.getEndDate().equals("") && dto.getDomemall().equals("\uc804\uccb4") && dto.getSearchText().equals("") && dto.getFolder().equals("") && dto.getCategory().equals("")) {
                return ProductDAO.get().getDiscontinueProductInDistinctItem();
            }
            return ProductDAO.get().getDiscontinueProductInDistinctItem(dto);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<ProductFolderDTO> getProductFolders() {
        List<ProductFolderDTO> result = null;
        try {
            result = ProductOperatingDAO.get().getProductFolders();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public void exportDataToExcel(String savePath, List<ProductDTO> products) {
        String[] prod11stmst = new String[]{"NO.", "\uc1fc\ud551\ubab0\uc0c1\ud488\ucf54\ub4dc", "\ub3c4\ub9e4\ubab0", "\uc790\uccb4\uc0c1\ud488\ucf54\ub4dc", "\uc1fc\ud551\ubab0\ucf54\ub4dc-ID", "\uc0c1\ud488\uba85", "\uc0c1\ud488\ubd84\ub958", "\uc0c1\ud488\uad6c\ubd84", "\ub9e4\uc785\ucc98", "\uc635\uc158\uc81c\ubaa91", "\uc635\uc158\uc81c\ubaa92", "\ubaa8\ub378\uba85", "\uc6d0\uc0b0\uc9c0", "\uc81c\uc870\uc0ac", "\ube0c\ub79c\ub4dc\uba85", "\uc0c1\ud488\uc0c1\ud0dc", "\ubc30\uc1a1\ube44\uad6c\ubd84", "\ubc30\uc1a1\ube44", "\ucd1d\ub2e8\ud488(\uc635\uc158)\uc218", "\ub2e8\ud488(\uc635\uc158)\uc218_\ud310\ub9e4", "\ucd1d\uc7ac\uace0\uc218\ub7c9", "\ud310\ub9e4\uac00", "\uc6d0\uac00", "\uc774\uc775\uc728", "\ub4f1\ub85d\uc77c\uc2dc", "\uc218\uc815\uc77c\uc2dc"};
        try {
            XSSFWorkbook workbook = new XSSFWorkbook();
            XSSFColor color_fail = new XSSFColor();
            color_fail.setIndexed((int)IndexedColors.RED.getIndex());
            XSSFColor color_pass = new XSSFColor();
            color_pass.setIndexed((int)IndexedColors.BLUE.getIndex());
            XSSFColor color_normal = new XSSFColor();
            color_normal.setIndexed((int)IndexedColors.WHITE.getIndex());
            XSSFCellStyle cs_left = workbook.createCellStyle();
            cs_left.setAlignment(HorizontalAlignment.LEFT);
            cs_left.setFillForegroundColor(color_normal);
            cs_left.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            XSSFCellStyle cs_right = workbook.createCellStyle();
            cs_right.setAlignment(HorizontalAlignment.RIGHT);
            cs_right.setFillForegroundColor(color_normal);
            cs_right.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            XSSFCellStyle cs_center = workbook.createCellStyle();
            cs_center.setAlignment(HorizontalAlignment.CENTER);
            cs_center.setFillForegroundColor(color_normal);
            cs_center.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            XSSFSheet prodmanager = workbook.createSheet("\uc0c1\ud488\uad00\ub9ac");
            if (prodmanager == null) {
                return;
            }
            Row row_head = prodmanager.createRow(0);
            int i = 0;
            while (i < prod11stmst.length) {
                Cell cell = row_head.createCell(i);
                cell.setCellValue(prod11stmst[i]);
                if (i == 4 || i == 5 || i == 12) {
                    prodmanager.setColumnWidth(i, 8000);
                } else if (i == 0 || i == 1 || i == 3 || i == 6 || i == 7 || i == 8 || i == 9 || i == 14 || i == 15 || i == 16 || i == 20 || i == 21 || i == 22) {
                    prodmanager.setColumnWidth(i, 3000);
                } else {
                    prodmanager.setColumnWidth(i, 5000);
                }
                ++i;
            }
            int rowIdx = 1;
            for (ProductDTO product2 : products) {
                Row row = prodmanager.createRow(rowIdx);
                Cell cell = null;
                int i2 = 0;
                while (i2 < prod11stmst.length) {
                    if (i2 == 0) {
                        cell = row.createCell(i2);
                        String value = product2.getRowno();
                        cell.setCellValue(value);
                    } else if (i2 == 1) {
                        cell = row.createCell(i2);
                        String value = product2.getShopprodno();
                        cell.setCellValue(value);
                    } else if (i2 == 2) {
                        cell = row.createCell(i2);
                        String value = MallCode.getDomeMallName(product2.getGoods_keyword());
                        cell.setCellValue(value);
                    } else if (i2 == 3) {
                        cell = row.createCell(i2);
                        String value = product2.getCompayny_goods_cd();
                        cell.setCellValue(value);
                    } else if (i2 == 4) {
                        cell = row.createCell(i2);
                        String value = product2.getShopcd().equals("0") ? "" : product2.getShopcd() + "-" + product2.getSHOP_USERID();
                        cell.setCellValue(value);
                    } else if (i2 == 5) {
                        cell = row.createCell(i2);
                        String value = product2.getGoods_nm();
                        cell.setCellValue(value);
                    } else if (i2 == 6) {
                        cell = row.createCell(i2);
                        String value = product2.getClass_cd1() + ">" + product2.getClass_cd2() + ">" + product2.getClass_cd3() + ">" + product2.getClass_cd4();
                        cell.setCellValue(value);
                    } else if (i2 == 7) {
                        cell = row.createCell(i2);
                        String value = product2.getGoods_gubun();
                        cell.setCellValue(value);
                    } else if (i2 == 8) {
                        cell = row.createCell(i2);
                        String value = product2.getPartner_id();
                        cell.setCellValue(value);
                    } else if (i2 == 9) {
                        cell = row.createCell(i2);
                        String value = product2.getChar_1_nm();
                        cell.setCellValue(value);
                    } else if (i2 == 10) {
                        cell = row.createCell(i2);
                        String value = product2.getChar_2_nm();
                        cell.setCellValue(value);
                    } else if (i2 == 11) {
                        cell = row.createCell(i2);
                        String value = product2.getModel_nm();
                        cell.setCellValue(value);
                    } else if (i2 == 12) {
                        cell = row.createCell(i2);
                        String value = product2.getOrigin();
                        cell.setCellValue(value);
                    } else if (i2 == 13) {
                        cell = row.createCell(i2);
                        String value = product2.getMaker();
                        cell.setCellValue(value);
                    } else if (i2 == 14) {
                        cell = row.createCell(i2);
                        String value = product2.getBrand_nm();
                        cell.setCellValue(value);
                    } else if (i2 == 15) {
                        cell = row.createCell(i2);
                        String value = product2.getStatus();
                        cell.setCellValue(value);
                    } else if (i2 == 16) {
                        cell = row.createCell(i2);
                        String value = product2.getDelv_type();
                        cell.setCellValue(value);
                    } else if (i2 == 17) {
                        cell = row.createCell(i2);
                        String value = product2.getDelv_cost();
                        cell.setCellValue(value);
                    } else if (i2 == 18) {
                        cell = row.createCell(i2);
                        String value = "";
                        cell.setCellValue(value);
                    } else if (i2 == 19) {
                        cell = row.createCell(i2);
                        String value = "";
                        cell.setCellValue(value);
                    } else if (i2 == 20) {
                        cell = row.createCell(i2);
                        String value = "";
                        cell.setCellValue(value);
                    } else if (i2 == 21) {
                        cell = row.createCell(i2);
                        String value = product2.getGoods_price();
                        cell.setCellValue(value);
                    } else if (i2 == 22) {
                        cell = row.createCell(i2);
                        String value = product2.getGoods_cost();
                        cell.setCellValue(value);
                    } else if (i2 == 23) {
                        String str;
                        cell = row.createCell(i2);
                        double price2 = Integer.parseInt(product2.getGoods_price());
                        double cost = Integer.parseInt(product2.getGoods_cost());
                        float f = (float)((price2 - cost) / price2 * 100.0);
                        String value = str = String.format("%.2f%%%n", Float.valueOf(f));
                        cell.setCellValue(value);
                    } else if (i2 == 24) {
                        cell = row.createCell(i2);
                        String value = product2.getInsertdt();
                        cell.setCellValue(value);
                    } else if (i2 == 25) {
                        cell = row.createCell(i2);
                        String value = product2.getModifydt();
                        cell.setCellValue(value);
                    }
                    ++i2;
                }
                ++rowIdx;
            }
            FileOutputStream fileOut = new FileOutputStream(savePath);
            workbook.write((OutputStream)fileOut);
            fileOut.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public List<String> getCoupangProductCodes(ProductDTO dto) throws Exception {
        ArrayList<String> code;
        block22: {
            code = new ArrayList<String>();
            CloseableHttpResponse response = null;
            CloseableHttpClient client = null;
            try {
                try {
                    ShoppingmallDTO shopInfo = ShoppingmallDAO.get().selectShoppingmallInfo(dto.getShopcd(), dto.getShopseq());
                    String URL2 = "/v2/providers/seller_api/apis/api/v1/marketplace/seller-products/%s";
                    String acessKey = shopInfo.getAUTHKEY1();
                    String secretKey = shopInfo.getAUTHKEY2();
                    shopInfo.getNICKNM1();
                    URL2 = String.format(URL2, dto.getShopprodno());
                    URIBuilder uriBuilder = new URIBuilder().setPath(URL2);
                    String authorization = Hmac.generate((String)"GET", (String)uriBuilder.build().toString(), (String)secretKey, (String)acessKey);
                    uriBuilder.setScheme("https").setHost("api-gateway.coupang.com").setPort(443);
                    client = HttpClients.createDefault();
                    HttpGet requestPatch = new HttpGet(uriBuilder.build().toString());
                    requestPatch.addHeader("Authorization", authorization);
                    requestPatch.addHeader("content-type", "application/json");
                    response = client.execute((HttpUriRequest)requestPatch);
                    if (response.getStatusLine().getStatusCode() == 200) {
                        InputStream is = response.getEntity().getContent();
                        BufferedReader br = new BufferedReader(new InputStreamReader(is, "utf-8"));
                        JsonParser parser = new JsonParser();
                        JsonObject resObject = (JsonObject)parser.parse((Reader)br);
                        YDMAStringUtil.Print(resObject);
                        String result = JsonHelper.jsonNullStr(resObject.get("code"));
                        if (result.equals("SUCCESS")) {
                            JsonObject data2 = (JsonObject)resObject.get("data");
                            JsonArray items = (JsonArray)data2.get("items");
                            JsonObject item = (JsonObject)items.get(0);
                            code.add(JsonHelper.jsonNullStr(data2.get("productId")));
                            code.add(JsonHelper.jsonNullStr(item.get("vendorItemId")));
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (response != null) {
                        response.close();
                    }
                    if (client == null) break block22;
                    client.close();
                }
            }
            finally {
                if (response != null) {
                    response.close();
                }
                if (client != null) {
                    client.close();
                }
            }
        }
        return code;
    }

    public String getNaverURL(ProductDTO dto) {
        String url = "";
        try {
            ShoppingmallDTO shopInfo = ShoppingmallDAO.get().selectShoppingmallInfo(dto.getShopcd(), dto.getShopseq());
            Map<String, String> cookies = LoginHelper.loginCookie(shopInfo);
            String json = "{\"searchKeywordType\":\"SELLER_CODE\",\"searchKeyword\":\"" + dto.getCompayny_goods_cd() + "\",\"productName\":\"\",\"modelName\":\"\",\"manufacturerName\":\"\",\"brandName\":\"\",\"searchPaymentType\":\"ALL\",\"searchPeriodType\":\"PROD_REG_DAY\",\"deliveryAttributeType\":\"\",\"productKindType\":\"\",\"etcCondition\":\"\",\"fromDate\":\"" + YDMATimeUtil.getSaleEndDt("-90") + "T00:00:00.000+09:00\",\"toDate\":\"" + YDMATimeUtil.getCurrentDateScheduler() + "T23:59:59.999+09:00\",\"viewData\":{\"productStatusTypes\":[\"SALE\"],\"channelServiceTypes\":[\"STOREFARM\",\"WINDOW\",\"AFFILIATE\",\"\"],\"pageSize\":100},\"searchOrderType\":\"REG_DATE\",\"productStatusTypes\":[\"SALE\"],\"channelServiceTypes\":[\"STOREFARM\",\"WINDOW\",\"AFFILIATE\"],\"page\":0,\"size\":100,\"sort\":[]}";
            Connection.Response response = Jsoup.connect((String)"https://sell.smartstore.naver.com/api/products/list/search").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").header("Connection", "keep-alive").header("x-to-stateName", "main.product.origin-list").header("Content-Type", "application/json;charset=UTF-8").header("Origin", "https://sell.smartstore.naver.com").header("Pragma", "no-cache").header("Cache-Control", "no-cache").header("x-current-stateName", "main.product.origin-list").header("x-current-state", "https://sell.smartstore.naver.com/#/products/origin-list").header("Sec-Fetch-Site", "same-origin").header("Sec-Fetch-Mode", "cors").header("Sec-Fetch-Dest", "empty").referrer("https://sell.smartstore.naver.com/").requestBody(json).method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).ignoreHttpErrors(true).execute();
            String body = response.body();
            JsonParser jsonparser = new JsonParser();
            JsonObject jsonobject = (JsonObject)jsonparser.parse(body);
            JsonArray content = (JsonArray)jsonobject.get("content");
            JsonObject obj = (JsonObject)content.get(0);
            url = obj.get("channelProductDisplayStatusTypes").getAsJsonArray().get(0).getAsJsonObject().get("productDirectUrl").getAsString();
        }
        catch (Exception exception) {
            return url;
        }
        return url;
    }

    public String getKakaoDomain(ProductDTO dto) {
        String domain = "";
        try {
            ShoppingmallDTO shopInfo = ShoppingmallDAO.get().selectShoppingmallInfo(dto.getShopcd(), dto.getShopseq());
            Map<String, String> cookies = LoginHelper.loginCookie(shopInfo);
            Connection.Response response = Jsoup.connect((String)"https://store-sell.kakao.com/a/main").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36").header("Accept", "*/*").header("Host", "store-sell.kakao.com").header("Connection", "keep-alive").header("sec-ch-ua", "\"Chromium\";v=\"114\", \" Not A;Brand\";v=\"99\", \"Google Chrome\";v=\"114\"").header("sec-ch-ua-mobile", "?0").header("Upgrade-Insecure-Requests", "1").header("Sec-Fetch-Site", "same-origin").header("Sec-Fetch-Mode", "cors").header("Sec-Fetch-Dest", "empty").referrer("https://store-sell.kakao.com/dashboard").method(Connection.Method.GET).ignoreContentType(true).followRedirects(true).ignoreHttpErrors(true).execute();
            String body = response.body();
            JsonParser parser = new JsonParser();
            JsonObject object = (JsonObject)parser.parse(body);
            JsonObject store = (JsonObject)object.get("store");
            domain = store.get("domain").toString();
        }
        catch (Exception exception) {
            return domain;
        }
        return domain;
    }
}

